/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.NtpMessage;
import gov.usgs.util.Retriable;
import gov.usgs.util.Util;
import gov.usgs.util.UtilException;
import java.io.File;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;
import java.util.logging.Logger;

public class CurrentTime {
    private static final String CONFIG_FILENAME = "NTP.config";
    private static final int DEFAULT_RECALIBRATION_INTERVAL = 600000;
    private static final int DEFAULT_TIMEOUT = 500;
    private static final String[] DEFAULT_NTP_SERVERS = new String[]{"0.pool.ntp.org", "1.pool.ntp.org", "2.pool.ntp.org", "time.nist.gov"};
    private long lastOffsetCheck = 0L;
    private long lastOffset;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private boolean netFailed = false;
    private boolean synchronizeDisabled = false;
    private long recalibrationInterval = 600000L;
    private int timeout = 500;
    private String[] servers = DEFAULT_NTP_SERVERS;
    private Logger logger = Log.getLogger("gov.usgs.util");
    private static CurrentTime currentTime;

    private CurrentTime() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        LinkedList<String> canaditeNames = new LinkedList<String>();
        canaditeNames.add(CONFIG_FILENAME);
        canaditeNames.add(System.getProperty("user.home") + File.separatorChar + CONFIG_FILENAME);
        String configFile = Util.stringToString(ConfigFile.findConfig(canaditeNames), CONFIG_FILENAME);
        ConfigFile cf = new ConfigFile(configFile);
        if (cf.wasSuccessfullyRead()) {
            String svrs = cf.getString("servers");
            if (svrs != null) {
                this.servers = svrs.split(",");
            }
            this.timeout = Util.stringToInt(cf.getString("timeout"), 500);
            this.synchronizeDisabled = Util.stringToBoolean(cf.getString("synchronizeDisabled"));
            this.recalibrationInterval = Util.stringToInt(cf.getString("recalibrationInterval"), 600000);
        }
    }

    public static CurrentTime getInstance() {
        return CurrentTimeHolder.currentTime;
    }

    public void setRecalibrationInterval(long ms) {
        this.recalibrationInterval = ms;
    }

    public String nowString() {
        return this.dateFormat.format(this.nowDate());
    }

    public double nowEW() {
        return (double)this.now() / 1000.0;
    }

    public double nowJ2K() {
        return (double)this.now() / 1000.0 - 9.46728E8;
    }

    public Date nowDate() {
        return new Date(this.now());
    }

    public long now() {
        if (this.netFailed) {
            return System.currentTimeMillis();
        }
        if (this.lastOffsetCheck == 0L || System.currentTimeMillis() - this.lastOffsetCheck > this.recalibrationInterval) {
            this.getOffset();
        }
        return System.currentTimeMillis() + this.lastOffset;
    }

    public long getLastOffset() {
        return this.lastOffset;
    }

    public synchronized long getOffset() {
        if (this.synchronizeDisabled) {
            return 0L;
        }
        Retriable<Long> rt = new Retriable<Long>("getCurrentTime()", this.servers.length){
            private int attempt;
            {
                this.attempt = 0;
            }

            @Override
            public void attemptFix() {
                ++this.attempt;
            }

            @Override
            public boolean attempt() throws UtilException {
                double localClockOffset = 0.0;
                DatagramSocket socket = null;
                try {
                    socket = new DatagramSocket();
                    socket.setSoTimeout(CurrentTime.this.timeout);
                    InetAddress address = InetAddress.getByName(CurrentTime.this.servers[this.attempt]);
                    byte[] buf = new NtpMessage().toByteArray();
                    DatagramPacket packet = new DatagramPacket(buf, buf.length, address, 123);
                    NtpMessage.encodeTimestamp(packet.getData(), 40, (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9);
                    socket.send(packet);
                    packet = new DatagramPacket(buf, buf.length);
                    socket.receive(packet);
                    double destinationTimestamp = (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9;
                    NtpMessage msg = new NtpMessage(packet.getData());
                    localClockOffset = (msg.receiveTimestamp - msg.originateTimestamp + (msg.transmitTimestamp - destinationTimestamp)) / 2.0;
                    long l = Math.round(localClockOffset * 1000.0);
                    this.result = new Long(l);
                    CurrentTime.this.lastOffset = l;
                    CurrentTime.this.lastOffsetCheck = System.currentTimeMillis();
                    CurrentTime.this.logger.finest("Successfully synchronized with NTP server: " + CurrentTime.this.servers[this.attempt]);
                    socket.close();
                    return true;
                }
                catch (Exception e) {
                    CurrentTime.this.logger.finest("Could not synchronize with NTP server: " + CurrentTime.this.servers[this.attempt]);
                    try {
                        socket.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    return false;
                }
            }
        };
        Long result = null;
        try {
            rt.setOutput(false);
            result = (Long)rt.go();
        }
        catch (UtilException utilException) {
            // empty catch block
        }
        if (result == null) {
            this.netFailed = true;
            return 0L;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        System.out.printf("        GMT Time\nMillis: %d\n   J2K: %f\n    EW: %f\n  Date: %s\nOffset: %d\n", CurrentTime.getInstance().now(), CurrentTime.getInstance().nowJ2K(), CurrentTime.getInstance().nowEW(), CurrentTime.getInstance().nowString(), CurrentTime.getInstance().getLastOffset());
    }

    private static class CurrentTimeHolder {
        public static CurrentTime currentTime = new CurrentTime();

        private CurrentTimeHolder() {
        }
    }
}

