/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util;

import gov.usgs.util.CodeTimer;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class DriveSwamp {
    private Thread readThread;
    private Thread writeThread;
    private FileChannel[] files;

    public DriveSwamp(final int numFiles, final int size, final int readSize, final int writeSize, final int sleep) throws Exception {
        int i;
        this.files = new FileChannel[numFiles];
        ByteBuffer bb = ByteBuffer.allocateDirect(size);
        for (i = 0; i < size; ++i) {
            bb.put((byte)i);
        }
        for (i = 0; i < numFiles; ++i) {
            bb.flip();
            FileChannel out = new FileOutputStream("swamp_" + i + ".tmp").getChannel();
            while (bb.hasRemaining()) {
                out.write(bb);
            }
            this.files[i] = out;
        }
        this.readThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ByteBuffer bb = ByteBuffer.allocateDirect(readSize);
                while (true) {
                    try {
                        while (true) {
                            CodeTimer ct = new CodeTimer("read");
                            int i = (int)Math.floor(Math.random() * (double)numFiles);
                            FileChannel in = new RandomAccessFile("swamp_" + i + ".tmp", "r").getChannel();
                            int p = (int)Math.floor(Math.random() * (double)(size - readSize));
                            in.position(p);
                            bb.clear();
                            in.read(bb, readSize);
                            in.close();
                            ct.stopAndReport();
                            Thread.sleep(sleep);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        this.readThread.start();
        this.writeThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ByteBuffer bb = ByteBuffer.allocateDirect(writeSize);
                for (int i = 0; i < writeSize; ++i) {
                    bb.put((byte)i);
                }
                while (true) {
                    try {
                        while (true) {
                            CodeTimer ct = new CodeTimer("write");
                            int i = (int)Math.floor(Math.random() * (double)numFiles);
                            FileChannel out = DriveSwamp.this.files[i];
                            bb.flip();
                            out.write(bb);
                            ct.stopAndReport();
                            Thread.sleep(sleep);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        this.writeThread.start();
    }

    public static void main(String[] args) throws Exception {
        int numFiles = Integer.parseInt(args[0]);
        int size = Integer.parseInt(args[1]);
        int readSize = Integer.parseInt(args[2]);
        int writeSize = Integer.parseInt(args[3]);
        int sleep = Integer.parseInt(args[4]);
        new DriveSwamp(numFiles, size, readSize, writeSize, sleep);
    }
}

