/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util.persist;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.persist.Persistent;
import gov.usgs.util.persist.PersistentID;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class Persistence {
    private static final String NULL_VALUE = "@@null@@";
    private static ConfigFile config;
    private static ConfigFile outConfig;
    private static Map<Class<?>, Translator> translators;

    private Persistence() {
    }

    public static void loadConfig(String cf) {
        config = new ConfigFile(cf);
    }

    private static String getPersistentID(Field[] fields, Object object) {
        try {
            for (Field field : fields) {
                if (!field.isAnnotationPresent(PersistentID.class)) continue;
                boolean acc = field.isAccessible();
                field.setAccessible(true);
                Object obj = field.get(object);
                String s = null;
                if (obj != null) {
                    s = obj.toString();
                }
                field.setAccessible(acc);
                return s;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Translator getTranslator(Class<?> type) {
        Translator translator = translators.get(type);
        if (translator == null) {
            for (Class<?> t : translators.keySet()) {
                if (!t.isAssignableFrom(type)) continue;
                translator = translators.get(t);
                break;
            }
        }
        return translator;
    }

    public static void load(Object object) {
        Persistence.load(object, object.getClass());
    }

    public static void load(Object object, Class<?> superClass) {
        ConfigFile cf = config.getSubConfig(object.getClass().getName());
        Field[] fields = superClass.getDeclaredFields();
        String id = Persistence.getPersistentID(fields, object);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Persistent.class)) continue;
            try {
                String key = field.getName();
                if (id != null) {
                    key = key + ":" + id;
                }
                String value = cf.getString(key);
                String fieldName = object.getClass().getName() + "." + key;
                if (value == null || value.length() == 0) {
                    System.err.println("no data for persisent field: " + fieldName);
                    continue;
                }
                boolean acc = field.isAccessible();
                field.setAccessible(true);
                Class<?> type = field.getType();
                Translator xlat = Persistence.getTranslator(type);
                if (xlat != null) {
                    Object v = value.equals(NULL_VALUE) ? null : xlat.translateFromString(value);
                    field.set(object, v);
                } else {
                    System.err.println("could not load persistent field: " + fieldName);
                }
                field.setAccessible(acc);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void useOriginalConfig() {
        outConfig = config;
    }

    public static void save(Object object) {
        Persistence.save(object, object.getClass());
    }

    public static void save(Object object, Class<?> superClass) {
        if (outConfig == null) {
            outConfig = new ConfigFile();
        }
        Field[] fields = superClass.getDeclaredFields();
        String id = Persistence.getPersistentID(fields, object);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Persistent.class)) continue;
            try {
                Translator xlat;
                boolean acc = field.isAccessible();
                field.setAccessible(true);
                String key = object.getClass().getName() + "." + field.getName();
                if (id != null) {
                    key = key + ":" + id;
                }
                if ((xlat = Persistence.getTranslator(field.getType())) != null) {
                    Object v = field.get(object);
                    String value = v == null ? NULL_VALUE : xlat.translateToString(field.get(object));
                    outConfig.put(key, value, false);
                } else {
                    System.err.println("could not save persistent field: " + object.getClass().getName() + "." + field.getName());
                }
                field.setAccessible(acc);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void flush(String fn) {
        outConfig.writeToFile(fn);
    }

    static {
        translators = new HashMap();
        translators.put(Boolean.TYPE, new BooleanTranslator());
        translators.put(Byte.TYPE, new ByteTranslator());
        translators.put(Short.TYPE, new ShortTranslator());
        translators.put(Integer.TYPE, new IntTranslator());
        translators.put(Long.TYPE, new LongTranslator());
        translators.put(Character.TYPE, new CharTranslator());
        translators.put(Float.TYPE, new FloatTranslator());
        translators.put(Double.TYPE, new DoubleTranslator());
        translators.put(String.class, new StringTranslator());
    }

    protected static class StringTranslator
    extends Translator {
        protected StringTranslator() {
        }

        @Override
        public Object translateFromString(String str) {
            return str.replace("\\n", "\n");
        }

        @Override
        public String translateToString(Object obj) {
            return ((String)obj).replace("\n", "\\n");
        }
    }

    protected static class DoubleTranslator
    extends Translator {
        protected DoubleTranslator() {
        }

        @Override
        public Object translateFromString(String str) {
            return Double.parseDouble(str);
        }
    }

    protected static class FloatTranslator
    extends Translator {
        protected FloatTranslator() {
        }

        @Override
        public Object translateFromString(String str) {
            return Float.valueOf(Float.parseFloat(str));
        }
    }

    protected static class ShortTranslator
    extends Translator {
        protected ShortTranslator() {
        }

        @Override
        public Object translateFromString(String str) {
            return Short.parseShort(str);
        }
    }

    protected static class CharTranslator
    extends Translator {
        protected CharTranslator() {
        }

        @Override
        public Object translateFromString(String str) {
            return Character.valueOf(str.charAt(0));
        }
    }

    protected static class LongTranslator
    extends Translator {
        protected LongTranslator() {
        }

        @Override
        public Object translateFromString(String str) {
            return Long.parseLong(str);
        }
    }

    protected static class IntTranslator
    extends Translator {
        protected IntTranslator() {
        }

        @Override
        public Object translateFromString(String str) {
            return Integer.parseInt(str);
        }
    }

    protected static class ByteTranslator
    extends Translator {
        protected ByteTranslator() {
        }

        @Override
        public Object translateFromString(String str) {
            return Byte.parseByte(str);
        }
    }

    protected static class BooleanTranslator
    extends Translator {
        protected BooleanTranslator() {
        }

        @Override
        public Object translateFromString(String str) {
            return Boolean.parseBoolean(str);
        }
    }

    public static abstract class Translator {
        public abstract Object translateFromString(String var1);

        public String translateToString(Object obj) {
            return obj.toString();
        }
    }
}

