/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util.xml;

import gov.usgs.util.xml.XMLDocHandler;
import java.io.Reader;
import java.util.HashMap;
import java.util.Stack;

public class SimpleXMLParser {
    private static final int TEXT = 1;
    private static final int ENTITY = 2;
    private static final int OPEN_TAG = 3;
    private static final int CLOSE_TAG = 4;
    private static final int START_TAG = 5;
    private static final int ATTRIBUTE_LVALUE = 6;
    private static final int ATTRIBUTE_EQUAL = 9;
    private static final int ATTRIBUTE_RVALUE = 10;
    private static final int QUOTE = 7;
    private static final int IN_TAG = 8;
    private static final int SINGLE_TAG = 12;
    private static final int COMMENT = 13;
    private static final int DONE = 11;
    private static final int DOCTYPE = 14;
    private static final int PRE = 15;
    private static final int CDATA = 16;

    private static int popMode(Stack<Integer> st) {
        if (!st.empty()) {
            return st.pop();
        }
        return 15;
    }

    public static void parse(XMLDocHandler doc, Reader r) throws Exception {
        Stack<Integer> st = new Stack<Integer>();
        int depth = 0;
        int mode = 15;
        int c = 0;
        int quotec = 34;
        depth = 0;
        StringBuffer sb = new StringBuffer();
        StringBuffer etag = new StringBuffer();
        String tagName = null;
        String lvalue = null;
        String rvalue = null;
        HashMap<String, String> attrs = null;
        st = new Stack();
        doc.startDocument();
        int line = 1;
        int col = 0;
        boolean eol = false;
        while ((c = r.read()) != -1) {
            if (c == 10 && eol) {
                eol = false;
                continue;
            }
            if (eol) {
                eol = false;
            } else if (c == 10) {
                ++line;
                col = 0;
            } else if (c == 13) {
                eol = true;
                c = 10;
                ++line;
                col = 0;
            } else {
                ++col;
            }
            if (mode == 11) {
                doc.endDocument();
                return;
            }
            if (mode == 1) {
                if (c == 60) {
                    st.push(mode);
                    mode = 5;
                    if (sb.length() <= 0) continue;
                    doc.text(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                if (c == 38) {
                    st.push(mode);
                    mode = 2;
                    etag.setLength(0);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 4) {
                if (c == 62) {
                    mode = SimpleXMLParser.popMode(st);
                    tagName = sb.toString();
                    sb.setLength(0);
                    if (--depth == 0) {
                        mode = 11;
                    }
                    doc.endElement(tagName);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 16) {
                if (c == 62 && sb.toString().endsWith("]]")) {
                    sb.setLength(sb.length() - 2);
                    doc.text(sb.toString());
                    sb.setLength(0);
                    mode = SimpleXMLParser.popMode(st);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 13) {
                if (c == 62 && sb.toString().endsWith("--")) {
                    sb.setLength(0);
                    mode = SimpleXMLParser.popMode(st);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 15) {
                if (c != 60) continue;
                mode = 1;
                st.push(mode);
                mode = 5;
                continue;
            }
            if (mode == 14) {
                if (c != 62 || (mode = SimpleXMLParser.popMode(st)) != 1) continue;
                mode = 15;
                continue;
            }
            if (mode == 5) {
                mode = SimpleXMLParser.popMode(st);
                if (c == 47) {
                    st.push(mode);
                    mode = 4;
                    continue;
                }
                if (c == 63) {
                    mode = 14;
                    continue;
                }
                st.push(mode);
                mode = 3;
                tagName = null;
                attrs = new HashMap<String, String>();
                sb.append((char)c);
                continue;
            }
            if (mode == 2) {
                if (c == 59) {
                    mode = SimpleXMLParser.popMode(st);
                    String cent = etag.toString();
                    etag.setLength(0);
                    if (cent.equals("lt")) {
                        sb.append('<');
                        continue;
                    }
                    if (cent.equals("gt")) {
                        sb.append('>');
                        continue;
                    }
                    if (cent.equals("amp")) {
                        sb.append('&');
                        continue;
                    }
                    if (cent.equals("quot")) {
                        sb.append('\"');
                        continue;
                    }
                    if (cent.equals("apos")) {
                        sb.append('\'');
                        continue;
                    }
                    if (cent.startsWith("#x")) {
                        sb.append((char)Integer.parseInt(cent.substring(2), 16));
                        continue;
                    }
                    if (cent.startsWith("#")) {
                        sb.append((char)Integer.parseInt(cent.substring(1)));
                        continue;
                    }
                    SimpleXMLParser.exc("Unknown entity: &" + cent + ";", line, col);
                    continue;
                }
                etag.append((char)c);
                continue;
            }
            if (mode == 12) {
                if (tagName == null) {
                    tagName = sb.toString();
                }
                if (c != 62) {
                    SimpleXMLParser.exc("Expected > for tag: <" + tagName + "/>", line, col);
                }
                doc.startElement(tagName, attrs);
                doc.endElement(tagName);
                if (depth == 0) {
                    doc.endDocument();
                    return;
                }
                sb.setLength(0);
                attrs = new HashMap();
                tagName = null;
                mode = SimpleXMLParser.popMode(st);
                continue;
            }
            if (mode == 3) {
                if (c == 62) {
                    if (tagName == null) {
                        tagName = sb.toString();
                    }
                    sb.setLength(0);
                    ++depth;
                    doc.startElement(tagName, attrs);
                    tagName = null;
                    attrs = new HashMap();
                    mode = SimpleXMLParser.popMode(st);
                    continue;
                }
                if (c == 47) {
                    mode = 12;
                    continue;
                }
                if (c == 45 && sb.toString().equals("!-")) {
                    mode = 13;
                    continue;
                }
                if (c == 91 && sb.toString().equals("![CDATA")) {
                    mode = 16;
                    sb.setLength(0);
                    continue;
                }
                if (c == 69 && sb.toString().equals("!DOCTYP")) {
                    sb.setLength(0);
                    mode = 14;
                    continue;
                }
                if (Character.isWhitespace((char)c)) {
                    tagName = sb.toString();
                    sb.setLength(0);
                    mode = 8;
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 7) {
                if (c == quotec) {
                    rvalue = sb.toString();
                    sb.setLength(0);
                    attrs.put(lvalue, rvalue);
                    mode = 8;
                    continue;
                }
                if (" \r\n\t".indexOf(c) >= 0) {
                    sb.append(' ');
                    continue;
                }
                if (c == 38) {
                    st.push(mode);
                    mode = 2;
                    etag.setLength(0);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 10) {
                if (c == 34 || c == 39) {
                    quotec = c;
                    mode = 7;
                    continue;
                }
                if (Character.isWhitespace((char)c)) continue;
                SimpleXMLParser.exc("Error in attribute processing", line, col);
                continue;
            }
            if (mode == 6) {
                if (Character.isWhitespace((char)c)) {
                    lvalue = sb.toString();
                    sb.setLength(0);
                    mode = 9;
                    continue;
                }
                if (c == 61) {
                    lvalue = sb.toString();
                    sb.setLength(0);
                    mode = 10;
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 9) {
                if (c == 61) {
                    mode = 10;
                    continue;
                }
                if (Character.isWhitespace((char)c)) continue;
                SimpleXMLParser.exc("Error in attribute processing.", line, col);
                continue;
            }
            if (mode != 8) continue;
            if (c == 62) {
                mode = SimpleXMLParser.popMode(st);
                doc.startElement(tagName, attrs);
                ++depth;
                tagName = null;
                attrs = new HashMap();
                continue;
            }
            if (c == 47) {
                mode = 12;
                continue;
            }
            if (Character.isWhitespace((char)c)) continue;
            mode = 6;
            sb.append((char)c);
        }
        if (mode == 11) {
            doc.endDocument();
        } else {
            SimpleXMLParser.exc("missing end tag", line, col);
        }
    }

    private static void exc(String s, int line, int col) throws Exception {
        throw new Exception(s + " near line " + line + ", column " + col);
    }
}

