/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.in.ew;

import gov.usgs.earthworm.message.TraceBuf;
import gov.usgs.util.ConfigFile;
import gov.usgs.winston.in.ew.Options;
import gov.usgs.winston.in.ew.SCNLFilter;
import java.util.ArrayList;
import java.util.List;

public class OptionsFilter {
    private String name;
    private Options options;
    private List<SCNLFilter> filters;

    public OptionsFilter(String n, ConfigFile cf, Options def) {
        this.name = n;
        this.options = Options.createOptions(cf, def);
        String at = cf.getString("applyTo");
        if (at == null) {
            return;
        }
        String[] fs = at.split(",");
        this.filters = new ArrayList<SCNLFilter>(fs.length);
        for (String f : fs) {
            SCNLFilter filter = new SCNLFilter(f.trim());
            this.filters.add(filter);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean match(TraceBuf tb) {
        for (SCNLFilter filter : this.filters) {
            if (!filter.match(tb, null)) continue;
            return true;
        }
        return false;
    }

    public Options getOptions() {
        return this.options;
    }

    public String toString() {
        return this.options.toString();
    }
}

