/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd.http;

import gov.usgs.net.HttpRequest;
import gov.usgs.net.HttpResponse;
import gov.usgs.net.NetTools;
import gov.usgs.util.Util;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import gov.usgs.winston.server.cmd.http.AbstractHttpCommand;
import gov.usgs.winston.server.cmd.http.HttpBaseCommand;
import java.text.DecimalFormat;
import java.util.List;
import java.util.TimeZone;

public final class HttpGapsCommand
extends AbstractHttpCommand
implements HttpBaseCommand {
    private static final String DEFAULT_T1 = "-12";
    private static final String DEFAULT_T2 = "now";
    private static final boolean DEFAULT_WC = false;
    private static final int DEFAULT_MGD = 5;
    DecimalFormat formatter = new DecimalFormat("#.###");
    double now = Util.ewToJ2K(System.currentTimeMillis() / 1000L);
    String error = "";
    String code;
    Double endTime;
    Double startTime;
    String timeZone;
    TimeZone zone;
    Double minGapDuration;
    int writeComputer;
    String startTimeS;
    String endTimeE;
    double totalTime;
    List<double[]> gaps;
    double[] gap;
    int gapCount;
    String[] color = new String[]{"#ffeeee;", "#eeffee;", "#eeeeff;"};
    int colorCount;
    double gapLength;
    double totalGapLength;
    double averageGapLength;
    double dataPercentage;

    public HttpGapsCommand(NetTools nt, WinstonDatabase db, WWS wws) {
        super(nt, db, wws);
    }

    @Override
    protected void sendResponse() {
        this.code = (String)this.arguments.get("code");
        if (this.code == null) {
            this.error = "Error: you must specify a channel (code).";
        } else {
            this.code = this.code.replace('_', '$');
            if (this.code.indexOf(";") != -1) {
                this.error = "Error: illegal characters in channel (code).";
            }
        }
        this.endTime = this.getEndTime((String)this.arguments.get("t2"));
        if (this.endTime == Double.NaN) {
            this.error = this.error + "Error: could not parse end time (t2). Should be " + "yyyyMMddHHmm" + ".";
        }
        this.startTime = this.getStartTime((String)this.arguments.get("t1"), this.endTime, 3600L);
        if (this.startTime == Double.NaN) {
            this.error = this.error + "Error: could not parse start time (t1). Should be " + "yyyyMMddHHmm" + " or -HH.";
        }
        this.timeZone = Util.stringToString((String)this.arguments.get("tz"), "UTC");
        this.zone = TimeZone.getTimeZone(this.timeZone);
        this.minGapDuration = Util.stringToDouble((String)this.arguments.get("mgd"), 5.0);
        this.writeComputer = Util.stringToInt((String)this.arguments.get("wc"), 0);
        if (this.error.length() > 0) {
            this.writeSimpleHTML(this.error);
        } else {
            this.gaps = this.data.findGaps(this.code, this.startTime, this.endTime);
            this.code = this.code.replace('$', '_');
            this.startTimeS = Util.j2KToDateString((double)this.startTime, this.zone);
            this.endTimeE = Util.j2KToDateString((double)this.endTime, this.zone);
            this.totalTime = this.endTime - this.startTime;
            if (this.writeComputer == 1) {
                this.writeComputer();
            } else {
                this.writeHuman();
            }
        }
    }

    void writeHuman() {
        StringBuilder header = new StringBuilder();
        StringBuilder outputSettings_Analysis = new StringBuilder();
        StringBuilder outputDataGaps = new StringBuilder();
        StringBuilder footer = new StringBuilder();
        header.append("<HTML><TITLE>Winston Gaps</TITLE>");
        header.append("<BODY><TABLE CELLSPACING=5 CELLPADDING=5 STYLE=\"border-width: 2; border-style: solid;\"><THEAD><TD ALIGN=center COLSPAN=3><BIG><B><U>Winston Gaps</U></B></BIG></TD></THEAD><TBODY><TR>");
        outputSettings_Analysis.append("<TD VALIGN=top><TABLE CELLSPACING=0 CELLPADDING=5 STYLE=\"border-width: 2; border-style: solid;\" WIDTH=400><THEAD><TR><TH ALIGN=center COLSPAN=2><B>Settings</B></TH></TR></THEAD>");
        outputSettings_Analysis.append("<TBODY><TR><TD>Start Time:</TD><TD>" + this.startTimeS + "</TD></TR>");
        outputSettings_Analysis.append("<TR><TD>End Time:</TD><TD>" + this.endTimeE + "</TD></TR>");
        outputSettings_Analysis.append("<TR><TD>Duration:</TD><TD>" + this.totalTime + " seconds</TD></TR>");
        outputSettings_Analysis.append("<TR><TD>Time Zone:</TD><TD>" + this.timeZone + "</TD></TR>");
        outputSettings_Analysis.append("<TR><TD>Station Name:</TD><TD>" + this.code + "</TD></TR>");
        outputSettings_Analysis.append("<TR><TD>Minimum Gap Duration:</TD><TD>" + this.minGapDuration + " seconds</TD></TR></TBODY></TABLE>");
        outputDataGaps.append("<TD VALIGN=top><TABLE CELLSPACING=0 CELLPADDING=5 STYLE=\"border-width: 2; border-style: solid;\" WIDTH=500><THEAD><TR><TH ALIGN=center COLSPAN=3><B>Data Gaps</B></TH></TR></THEAD>");
        outputDataGaps.append("<TR><TH>Gap Start Time</TH><TH>Gap End Time</TH><TH>Gap Duration</TH></TR>");
        this.gapCount = 0;
        this.colorCount = 0;
        this.totalGapLength = 0.0;
        for (double[] gap : this.gaps) {
            this.gapLength = gap[1] - gap[0];
            if (this.gapLength < this.minGapDuration) continue;
            outputDataGaps.append("<TR STYLE=\"background: " + this.color[this.colorCount++ % 3] + "\"><TD>" + Util.j2KToDateString(gap[0], this.zone) + "</TD><TD>" + Util.j2KToDateString(gap[1], this.zone) + "</TD><TD ALIGN=right>" + this.formatter.format(this.gapLength) + " seconds</TD></TR>");
            ++this.gapCount;
            this.totalGapLength += this.gapLength;
        }
        this.averageGapLength = this.gapCount > 0 ? this.totalGapLength / (double)this.gapCount : 0.0;
        this.dataPercentage = (this.totalTime - this.totalGapLength) / this.totalTime * 100.0;
        outputDataGaps.append("</TABLE>");
        outputSettings_Analysis.append("<TABLE CELLSPACING=0 CELLPADDING=5 STYLE=\"border-width: 2; border-style: solid;\" WIDTH=400><THEAD><TR><TH ALIGN=center COLSPAN=2 ><B>Analysis</B></TH></TR></THEAD>");
        outputSettings_Analysis.append("<TR><TD>Number of Gaps:</TD><TD>" + this.gapCount + "</TD></TR>");
        outputSettings_Analysis.append("<TR><TD>Total Gap Length:</TD><TD>" + this.formatter.format(this.totalGapLength) + "seconds</TD></TR>");
        outputSettings_Analysis.append("<TR><TD>Average Gap Length:</TD><TD>" + this.formatter.format(this.averageGapLength) + "seconds</TD></TR>");
        outputSettings_Analysis.append("<TR><TD>Data percentage:</TD><TD>" + this.formatter.format(this.dataPercentage) + "%</TD></TR></TABLE></TD>");
        footer.append("</TD></TR></TBODY><TFOOT></TFOOT</TABLE></BODY></HTML>");
        if (this.gapCount == 0) {
            this.writeSimpleHTML("No Gaps for selected time frame.");
        } else if (this.totalGapLength == this.totalTime) {
            this.writeSimpleHTML("No Data for selected time frame.");
        }
        String html = header.toString() + outputSettings_Analysis.toString() + outputDataGaps.toString() + footer.toString();
        HttpResponse response = new HttpResponse("text/html");
        response.setLength(html.length());
        this.netTools.writeString(response.getHeaderString(), this.socketChannel);
        this.netTools.writeString(html, this.socketChannel);
    }

    void writeComputer() {
        StringBuilder header = new StringBuilder();
        StringBuilder output = new StringBuilder();
        output.append("# Gap Start\t\tGap End\t\t\tDuration\n");
        this.gapCount = 0;
        this.totalGapLength = 0.0;
        for (double[] gap : this.gaps) {
            this.gapLength = gap[1] - gap[0];
            if (this.gapLength < this.minGapDuration) continue;
            output.append(gap[0] + "\t" + gap[1] + "\t" + this.gapLength + "\n");
            ++this.gapCount;
            this.totalGapLength += this.gapLength;
        }
        header.append("# Start Time: " + this.startTimeS + " (" + this.startTime + ")\n# End Time: " + this.endTimeE + " (" + this.endTime + ")\n# Total Time: " + this.totalTime + "\n# Time Zone: " + this.timeZone + "\n# Station: " + this.code + "\n# Minumum Gap Duration: " + this.minGapDuration + "\n# GapCount: " + this.gapCount + "\n");
        this.writeSimpleText(header.toString() + output.toString());
    }

    @Override
    public String getUsage(HttpRequest req) {
        StringBuilder output = new StringBuilder();
        output.append("<script>function buildGapsUrl() {var urlDiv = document.getElementById(\"gapsUrl\");\nvar gapsWC = document.getElementById(\"gapsWC\");\nvar gapsMGD = document.getElementById(\"gapsMGD\");\nvar gapsTZ = document.getElementById(\"gapsTZ\");\nvar gapsT1 = document.getElementById(\"gapsT1\");\nvar gapsT2 = document.getElementById(\"gapsT2\");\nvar gapsCODE = document.getElementById(\"gapsCODE\");\nvar a = document.createElement('a');\nvar linkUrl = \"http://" + req.getHeader("Host") + "/gaps?\";\n");
        output.append("linkUrl += \"code=\" + gapsCODE.value;");
        output.append("if (gapsT1.value != \"-12\" && gapsT1.value != \"\") { linkUrl += \"&t1=\" + gapsT1.value;}\n");
        output.append("if (gapsT2.value != \"now\" && gapsT2.value != \"\") { linkUrl += \"&t2=\" + gapsT2.value;}\n");
        output.append("if (gapsMGD.value != \"5\" && gapsMGD.value != \"\") { linkUrl += \"&mgd=\" + gapsMGD.value;}\n");
        output.append("if (gapsWC.checked == \"\") { linkUrl += \"&wc=1\";}\n");
        output.append("if (gapsTZ.value != \"UTC\") { linkUrl += \"&tz=\" + gapsTZ.value;}\n");
        output.append("linkUrl = linkUrl.replace(\"?&\", \"?\");\n");
        output.append("linkUrl = linkUrl.replace(/\\?$/, \"\");\n");
        output.append("a.href = linkUrl;\na.text = linkUrl;\na.textContent = linkUrl; \nwhile(urlDiv.hasChildNodes()) {urlDiv.removeChild(urlDiv.lastChild);}urlDiv.appendChild(a);\n}</script>\n");
        output.append("Locates gaps in continous data. \n");
        output.append("<div class=\"tabContentTitle\">URL Builder</div>\n");
        output.append("<div class=\"tabContent\">\n");
        output.append("<FORM>\n");
        output.append("<div class=\"left\">\n");
        output.append("<div class=\"left\">Channel<BR>");
        output.append("<select id=\"gapsCODE\" onchange=\"buildGapsUrl()\" name=\"code\" class=\"channel\" size=8></select></div>\n");
        output.append("<div class=\"right\">Time zone<br>");
        output.append("<select onchange=\"buildGapsUrl()\" class=\"timeZone\" id=\"gapsTZ\" name=\"tz\" size=8></select></div>\n");
        output.append("<div class=\"clear\"></div>");
        output.append("<P><br><p><div class=\"label\"><label for=\"t1\">Start Time</label></div><input type=text id=\"gapsT1\" onchange=\"buildGapsUrl()\" name=\"t1\" size=10 value=\"-12\"><br>");
        output.append("<div class=\"label\"><label for=\"t2\">End Time</label></div><input type=text id=\"gapsT2\" onchange=\"buildGapsUrl()\" name=\"t2\" size=10 value=\"now\"><br>");
        output.append("</div>\n");
        output.append("<div class=\"right\" style=\"padding-right:15px;\">\n");
        output.append("<div class=\"input\"><label for=\"mgd\">Min Gap</label><input type=text id=\"gapsMGD\" onchange=\"buildGapsUrl()\" name=\"mgd\" size=3 value=\"5\"></div>");
        output.append("<div class=\"input\"><label for=\"dt\">Human Readable?</label><input type=checkbox id=\"gapsWC\" onchange=\"buildGapsUrl()\" name=\"wc\" checked></div>");
        output.append("</div></FORM><div class=\"clear\"></div>\n");
        output.append("<HR class=\"urlBuilder\"><b>URL:</b><BR><div id=\"gapsUrl\"></div>");
        output.append("</div><div class=\"tabContentTitle\">Arguments</div>\n");
        output.append("<div class=\"tabContent\">\n");
        output.append("The options (separated by the & character, all optional except for <code>code</code> ) are defined as follows:<br><br>This url will return data, data gaps, and analysis for the channel PS4A EHZ AV, for the last 24 hours, in Alaskan time, with a minimum gap duration of 30 seconds, written for humans.<br>The options (separated by the & character, all optional except for code ) are defined as follows<br><br>code: <b>Station Name</b> The name of the Station desired<br><br>t1: <b>Start Time</b> The start time (local) of the gap analysis as given by the number of hours before present or a specific time in the format YYYYMMDDHHMM. Note that, in the first case, this is a negative number (default = -12).<br><br>t2: <b>End Time</b> The end time (local) of the gap analysis as given by the format YYYYMMDDHHMM or 'now' (default = 'now').<br><br>tz: <b>Time Zone</b> The time zone, a complete list of time zones that WWS understands is shown below (default = UTC).<br><br>mgd: <b>Minimumm Gap Duration</b> The minimum gap duration desired in seconds (default = 5)<br><br>wc: <b>Write Computer</b> Whether to show data gaps as the computer sees, 1 is yes, 0 is no (default = 0)");
        output.append("</div>");
        return output.toString();
    }

    @Override
    public String getAnchor() {
        return "gaps";
    }

    @Override
    public String getTitle() {
        return "WWS Gaps";
    }

    @Override
    public String getCommand() {
        return "/gaps";
    }
}

