/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd.http;

import gov.usgs.net.HttpRequest;
import gov.usgs.net.NetTools;
import gov.usgs.util.Util;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import gov.usgs.winston.server.cmd.http.AbstractHttpCommand;
import gov.usgs.winston.server.cmd.http.HttpBaseCommand;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TimeZone;

public final class HttpMenuCommand
extends AbstractHttpCommand
implements HttpBaseCommand {
    private static int DEFAULT_OB = 2;
    private static String DEFAULT_SO = "a";

    public HttpMenuCommand(NetTools nt, WinstonDatabase db, WWS wws) {
        super(nt, db, wws);
    }

    @Override
    protected void sendResponse() {
        int sortCol = Util.stringToInt((String)this.arguments.get("ob"), DEFAULT_OB);
        if (sortCol < 1 || sortCol > 8) {
            this.writeSimpleHTML("Error: could not parse ob = " + (String)this.arguments.get("ob"));
            return;
        }
        String o = Util.stringToString((String)this.arguments.get("so"), DEFAULT_SO);
        char order = o.charAt(0);
        if (order != 'a' && order != 'd') {
            this.writeSimpleHTML("Error: could not parse so = " + (String)this.arguments.get("so"));
            return;
        }
        String tz = Util.stringToString((String)this.arguments.get("tz"), "UTC");
        TimeZone timeZone = TimeZone.getTimeZone(tz);
        String[] colTitle = new String[]{null, "Pin", "S", "C", "N", "L", "Earliest", "Most Recent", "Type"};
        int n = sortCol;
        colTitle[n] = colTitle[n] + (order == 'a' ? " &#9652;" : " &#9662;");
        char[] colOrd = new char[colTitle.length];
        Arrays.fill(colOrd, 'a');
        if (order == 'a') {
            colOrd[sortCol] = 100;
        }
        StringBuilder output = new StringBuilder();
        output.append("<table CELLPADDING=\"5\"><tr>");
        for (int i = 1; i < colTitle.length; ++i) {
            output.append("<th><a href=\"?ob=" + i + "&so=" + colOrd[i] + "\">" + colTitle[i] + "</a></th>");
        }
        output.append("</tr>");
        List<String> list = this.emulator.getWaveServerMenu(true, 0.0, 0.0, this.maxDays);
        String[][] menu = new String[list.size()][8];
        int i = 0;
        for (String s : list) {
            menu[i++] = s.split("\\s");
        }
        Arrays.sort(menu, this.getMenuComparator(sortCol, order));
        for (String[] line : menu) {
            if (line.length < 8) {
                output.append("can't parse line, skipping. " + line);
                continue;
            }
            double start = Double.parseDouble(line[6]);
            double end = Double.parseDouble(line[7]);
            output.append("<tr>");
            output.append("<td>" + line[1] + "</td>");
            output.append("<td>" + line[2] + "</td>");
            output.append("<td>" + line[3] + "</td>");
            output.append("<td>" + line[4] + "</td>");
            output.append("<td>" + line[5] + "</td>");
            output.append("<td>" + Util.j2KToDateString(Util.ewToJ2K(start), timeZone) + "</td>");
            output.append("<td>" + Util.j2KToDateString(Util.ewToJ2K(end), timeZone) + "</td>");
            output.append("<td>" + line[8] + "</td>");
            output.append("</tr>\n");
        }
        output.append("</table>");
        this.writeSimpleHTML(output.toString());
    }

    private Comparator<String[]> getMenuComparator(int sortCol, char order) {
        return new Comparator<String[]>(){

            @Override
            public int compare(String[] e1, String[] e2) {
                if (sortCol == 1 || sortCol == 6 || sortCol == 7) {
                    int i;
                    double d2;
                    double d1 = Double.parseDouble(e1[sortCol]);
                    double d = d1 - (d2 = Double.parseDouble(e2[sortCol]));
                    if (d == 0.0) {
                        return 0;
                    }
                    int n = i = d < 0.0 ? -1 : 1;
                    if (order == 'a') {
                        return i;
                    }
                    return -i;
                }
                if (order == 'a') {
                    return e1[sortCol].compareTo(e2[sortCol]);
                }
                return e2[sortCol].compareTo(e1[sortCol]);
            }
        };
    }

    @Override
    public String getUsage(HttpRequest req) {
        String Url = "http://" + req.getHeader("Host") + "/menu";
        StringBuilder output = new StringBuilder();
        output.append("<script>function buildMenuUrl() {var urlDiv = document.getElementById(\"menuUrl\");\nvar menuOB = document.getElementById(\"menuOB\");\nvar menuSO = document.getElementById(\"menuSO\");\nvar menuTZ = document.getElementById(\"menuTZ\");\nvar a = document.createElement('a');\nvar linkUrl = \"http://" + req.getHeader("Host") + "/menu?\";\n");
        output.append("if (menuOB.value != \"" + DEFAULT_OB + "\") { linkUrl += \"&ob=\" + menuOB.value;}\n");
        output.append("if (menuSO.value != \"" + DEFAULT_SO + "\") { linkUrl += \"&so=\" + menuSO.value;}\n");
        output.append("if (menuTZ.value != \"UTC\") { linkUrl += \"&tz=\" + menuTZ.value;}\n");
        output.append("linkUrl = linkUrl.replace(\"?&\", \"?\");\n");
        output.append("linkUrl = linkUrl.replace(/\\?$/, \"\");\n");
        output.append("a.href = linkUrl;\na.text = linkUrl;\na.textContent = linkUrl; \na.textContent = linkUrl; \nwhile(urlDiv.hasChildNodes()) {urlDiv.removeChild(urlDiv.lastChild);}urlDiv.appendChild(a);\n}</script>\n");
        output.append("Returns the server menu. The menu contains the list of stations in this winston along with the earliest and most recent data point for each station.\n");
        output.append("<div class=\"tabContentTitle\">URL Builder</DIV>\n");
        output.append("<div class=\"tabContent\">\n");
        output.append("<FORM>\n");
        output.append("<div class=\"left\"><div class=\"left\">\n");
        output.append("<label for=\"tz\">Time Zone</label><br>\n");
        output.append("<select onchange=\"buildMenuUrl()\" class=\"timeZone\" id=\"menuTZ\" name=\"tz\" size=8></select>");
        output.append("</div><div class=\"right\">\n");
        output.append("<br><div class=\"input\" style=\"width: 20em\"><label for=\"ob\">Order By</label>");
        output.append("<select id=\"menuOB\" onchange=\"buildMenuUrl()\" name=\"ob\">\n<option value=1>Pin</option><option value=2 selected>Station</option><option value=3>Component</option><option value=4>Network</option><option value=5>Location</option><option value=6>Earliest</option><option value=7>Most Recent</option><option value=8>Type</Option></select></div><br>\n");
        output.append("<div class=\"input\" style=\"width: 20em\"><label for=\"so\">Sort Order</label>");
        output.append("<select id=\"menuSO\" onchange=\"buildMenuUrl()\" name=\"so\"><option value=\"a\" selected>Ascending</option><option value=\"d\">Descending</option></select></div><br>");
        output.append("</div></div></FORM><div class=\"clear\"></div>\n");
        output.append("<HR class=\"urlBuilder\"><b>URL:</b><BR><div id=\"menuUrl\"></div>");
        output.append("</div>");
        output.append("<div class=\"tabContentTitle\">Arguments</DIV>\n");
        output.append("<div class=\"tabContent\">\n");
        output.append("<code>ob</code>: <b>Order By</b> The column number used to order the menu (default = " + DEFAULT_OB + ").<br><br>\n" + "<code>so</code>: <b>Sort Order</b> How to order the menu, a is ascending, d is decending (default = " + DEFAULT_SO + ").<br><br>\n" + "<code>tz</code>: <b>Time Zone</b> (deafult = " + "UTC" + ")<br><br>\n");
        output.append("</div>");
        output.append("<div class=\"tabContentTitle\">Examples</DIV>\n");
        output.append("<div class=\"tabContent\">\n");
        output.append("Most recently added channels:<br><a href=\"http://" + req.getHeader("Host") + "/menu?ob=6&so=d\">" + "http://" + req.getHeader("Host") + "/menu?ob=6&so=d</a><br><p><br>");
        output.append("Channels with least recent data:<br><a href=\"http://" + req.getHeader("Host") + "/menu?ob=7&so=a\">" + "http://" + req.getHeader("Host") + "/menu?ob=7&so=a</a><p>");
        output.append("</div>");
        return output.toString();
    }

    @Override
    public String getAnchor() {
        return "menu";
    }

    @Override
    public String getTitle() {
        return "Server Menu";
    }

    @Override
    public String getCommand() {
        return "/menu";
    }
}

