/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.tools.pannel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.util.Arguments;
import gov.usgs.winston.in.ImportSAC;
import gov.usgs.winston.in.StaticImporter;
import gov.usgs.winston.tools.FilePanel;
import gov.usgs.winston.tools.ScnlPanel;
import gov.usgs.winston.tools.WinstonToolsRunnablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTextField;

public class ImportSACPanel
extends WinstonToolsRunnablePanel {
    private static final long serialVersionUID = 1L;
    private ImportSAC is;
    private ScnlPanel scnlP;
    private FilePanel fileP;
    private JTextField rsamDeltaF;
    private JTextField rsamDurationF;
    private JButton importB;

    public ImportSACPanel() {
        super("Import SAC");
    }

    @Override
    protected void createUI() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Import SAC File"));
        FormLayout layout = new FormLayout("right:max(40dlu;p), 4dlu, left:p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append("SCNL", (Component)this.scnlP);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append("file", (Component)this.fileP);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append("RSAM Delta", (Component)this.rsamDeltaF);
        builder.nextLine();
        builder.append("RSAM Duration", (Component)this.rsamDurationF);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append("", (Component)this.importB);
        this.add((Component)builder.getPanel(), "Center");
    }

    @Override
    protected void createFields() {
        this.scnlP = new ScnlPanel();
        this.fileP = new FilePanel(FilePanel.Type.OPEN);
        this.rsamDeltaF = new JTextField(5);
        this.rsamDeltaF.setText("10");
        this.rsamDurationF = new JTextField(5);
        this.rsamDurationF.setText("60");
        this.importB = new JButton("import");
        this.importB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportSACPanel.this.start();
            }
        });
    }

    @Override
    protected void go() {
        ArrayList<String> as = new ArrayList<String>();
        as.add("-rd");
        as.add(this.rsamDeltaF.getText());
        as.add("-rl");
        as.add(this.rsamDurationF.getText());
        as.add(this.fileP.getFileName());
        HashSet<String> kvs = new HashSet<String>();
        kvs.add("-rd");
        kvs.add("-rl");
        kvs.add("-c");
        HashSet<String> flags = new HashSet<String>();
        Arguments args = new Arguments(as.toArray(new String[0]), flags, kvs);
        this.is = new ImportSAC();
        this.is.processArguments(args);
        this.is.setChannel(this.scnlP.getSCNL('$'));
        List<String> files = args.unused();
        StaticImporter.process(files, this.is);
    }

    @Override
    public boolean needsWinston() {
        return true;
    }
}

