/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.tools.pannel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.winston.in.ImportSeed;
import gov.usgs.winston.in.StaticImporter;
import gov.usgs.winston.tools.FilePanel;
import gov.usgs.winston.tools.WinstonToolsRunnablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTextField;

public class ImportSeedPanel
extends WinstonToolsRunnablePanel {
    private static final long serialVersionUID = 1L;
    ImportSeed is;
    private static FilePanel fileP;
    private static JTextField rsamDeltaF;
    private static JTextField rsamDurationF;
    private static JButton importB;

    public ImportSeedPanel() {
        super("Import SEED");
    }

    @Override
    protected void createUI() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Import SEED Volume"));
        this.createFields();
        FormLayout layout = new FormLayout("right:max(40dlu;p), 4dlu, left:p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append("file", (Component)fileP);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append("RSAM Delta", (Component)rsamDeltaF);
        builder.nextLine();
        builder.append("RSAM Duration", (Component)rsamDurationF);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append("", (Component)importB);
        this.add((Component)builder.getPanel(), "Center");
    }

    @Override
    protected void createFields() {
        fileP = new FilePanel(FilePanel.Type.OPEN);
        rsamDeltaF = new JTextField(5);
        rsamDeltaF.setText("10");
        rsamDurationF = new JTextField(5);
        rsamDurationF.setText("60");
        importB = new JButton("import");
        importB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportSeedPanel.this.start();
            }
        });
    }

    @Override
    protected void go() {
        this.is = new ImportSeed();
        this.is.setRsamDelta(Integer.parseInt(rsamDeltaF.getText()));
        this.is.setRsamDuration(Integer.parseInt(rsamDurationF.getText()));
        ArrayList<String> f = new ArrayList<String>();
        f.add(fileP.getFileName());
        StaticImporter.process(f, this.is);
    }

    @Override
    public boolean needsWinston() {
        return true;
    }
}

