PROGRAM RADARDTAINTRP
!
!##################################################################
!##################################################################
!######                                                      ######
!######                   PROGRAM RADARDTAINTRP              ######
!######                                                      ######
!######                     Developed by                     ######
!######     Center for Analysis and Prediction of Storms     ######
!######                University of Oklahoma                ######
!######                                                      ######
!##################################################################
!##################################################################
!
!-----------------------------------------------------------------------
!
!  PURPOSE:
!  
!  Interpolate radar data generated by ossedata.f90 from one ARPS 
!  horizontal grid to another
!
!-----------------------------------------------------------------------
!
!  AUTHOR: Mingjing Tong 
!  (02/9/2007)
!
!  MODIFICATION HISTORY:
!
!-----------------------------------------------------------------------
!
!  Variable Declarations:
!
!-----------------------------------------------------------------------
!
  IMPLICIT NONE

  REAL, allocatable :: x (:),y (:),z (:)
  REAL, allocatable :: x1(:),y1(:),z1(:)
  REAL, allocatable :: zp(:,:,:)

  REAL, allocatable :: xs (:), ys (:) ! x,y coord for scalar points
  REAL, allocatable :: xs1(:), ys1(:) ! x,y coord for scalar points
  INTEGER, allocatable :: isx(:),jsy(:),iux(:),jvy(:)
  REAL, allocatable:: wgtsx(:),wgtsy(:),wgtux(:),wgtvy(:)

  INTEGER :: nx,ny,nz,nzsoil   ! Grid dimensions.
  INTEGER :: nstyps            ! Maximum number of soil types.

  INTEGER :: hinfmt
  CHARACTER (LEN=256) :: grdbasfn, grdbasfn1

  INTEGER :: datanamopt, vareadopt,nfile,datatype
  INTEGER, PARAMETER :: nfilemax = 30
  CHARACTER (LEN=128) :: rdrdtadir, vadtadir
  CHARACTER (LEN=50) :: rdrdtanam(nfilemax), vadtanam(nfilemax)
  CHARACTER (LEN=50) :: radarnam, vanam
  REAL :: t0, tn, dt

  INTEGER :: intrp_opt
  INTEGER :: nx1,ny1,nzsoil1,nstyp1
  REAL :: xctr1,yctr1,dx1,dy1,xorig1,yorig1

  CHARACTER (LEN=80  ) :: runname  

  CHARACTER (LEN=256) :: dirname

  CHARACTER (LEN=80  ) :: outname

  NAMELIST /history_data/ hinfmt, grdbasfn, grdbasfn1

  NAMELIST /radar_data/ datanamopt, rdrdtadir, vadtadir, &
            vareadopt, nfile, rdrdtanam, vadtanam, &
            radarnam, vanam, t0, tn, dt, datatype

  NAMELIST /output_dims/ intrp_opt,nx1,ny1,xctr1,yctr1,dx1,dy1

  NAMELIST /jobname/ runname

  NAMELIST /output/ dirname,outname

!
!-----------------------------------------------------------------------
!  Include files:
!-----------------------------------------------------------------------
!
  INCLUDE 'grid.inc'

  INTEGER :: i,j,k,l,ireturn
  INTEGER :: itime
  INTEGER :: nen3
  INTEGER :: istatus
  INTEGER :: lengbf, ldirnam

  REAL :: time, xeps, yeps
  LOGICAL :: iexist

  CHARACTER (LEN=10) :: timnam
  CHARACTER (LEN=128) :: filename1, filename2

!
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
!
!  Beginning of executable code...
!
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
!
  WRITE(6,'(/9(/5x,a)/)')                                               &
     '###############################################################', &
     '###############################################################', &
     '###                                                         ###', &
     '###                Welcome to ARPSSUBDOMAIN                 ###', &
     '###      This program read, interpolate then write out      ###', &
     '###      variables in ARPS history for files one variable   ###', &
     '###      at a time to minimize memory requirement.          ###', &
     '###                                                         ###', &
     '###############################################################', &
     '###############################################################'
!
!-----------------------------------------------------------------------
!  Get the names of the input data files.
!-----------------------------------------------------------------------
!
  READ(5,history_data, END=100)
  WRITE(6,'(/a,a/)')                                                    &
      'NAMELIST block history_data successfully read.'

  READ(5,radar_data, END=100)
  WRITE(6,'(/a,a/)')                                                    &
      'NAMELIST block radar_data successfully read.'

  READ(5,output_dims, END=100)
  WRITE(6,'(/a,a/)')                                                    &
      'NAMELIST block output_dims successfully read.'

  READ (5,jobname,END=100)
  WRITE(6,'(/a/)') 'Sucessfully read namelist block JOBNAME.'

  READ (5,output,END=100)
  WRITE(6,'(/a/)') 'Sucessfully read namelist block OUTPUT.'

  lengbf = len_trim(grdbasfn)
  WRITE(6,'(/a,a)')' The grid/base name is ', trim(grdbasfn)

  CALL get_dims_from_data(hinfmt,grdbasfn(1:lengbf),                    &
       nx,ny,nz,nzsoil,nstyps, ireturn)

  Print*,'nx,ny,nz of input data were ', nx,ny,nz

  allocate(x(nx ),stat=istatus)
  x = 0.0
  allocate(y(ny ),stat=istatus)
  y = 0.0
  allocate(xs(nx ),stat=istatus)
  xs = 0.0
  allocate(ys(ny ),stat=istatus)
  ys = 0.0
  allocate(z(nz ),stat=istatus)
  y = 0.0
  allocate(zp(nx,ny,nz),stat=istatus)

  CALL get_gridinfo_from_hdf(grdbasfn(1:lengbf),nx,ny,nz,x,y,z,zp,ireturn)

! Print*,'x,y,z,zp of input data read in.'
! print*,'x(1 )=',x(1)
! print*,'x(nx)=',x(nx)
! print*,'y(1 )=',y(1)
! print*,'y(ny)=',y(ny)

  dx = x(2) - x(1)
  dy = y(2) - y(1)

  IF( ireturn /= 0 ) THEN
    PRINT*,'Problem occured when trying to get dimensions from data.'
    PRINT*,'Program stopped.'
    STOP
  END IF

  WRITE(6,'(4(a,i5))') 'nx =',nx,', ny=',ny,', nz=',nz , &
            'nzsoil=',nzsoil  


  WRITE(6,'(4(a,i5))') 'nx1 =',nx1,', ny1=',ny1

  allocate(x1(nx1),stat=istatus)
  x1 = 0.0
  allocate(y1(ny1),stat=istatus)
  y1 = 0.0

  allocate(xs1(nx1),stat=istatus)
  xs1 = 0.0
  allocate(ys1(ny1),stat=istatus)
  ys1 = 0.0

  WRITE(6,'(/2x,a,a)') 'The name of this run is: ', runname
!
!-----------------------------------------------------------------------
!  Set the control parameters for output:
!-----------------------------------------------------------------------
!
  ldirnam=LEN_trim(dirname)
  print*,'ldirnam, dirname', ldirnam, trim(dirname)

  IF( dirname(1:ldirnam) /= ' ') THEN
    INQUIRE(FILE=dirname(1:ldirnam),EXIST=iexist)
    IF( .NOT.iexist ) THEN

      WRITE(6,'(5x,a,2(/5x,a))')                                        &
          'Specified output directory '//dirname(1:ldirnam)//           &
          ' not found.','It will be created by the program.'
      CALL unixcmd( 'mkdir -p '//dirname(1:ldirnam) )
    END IF
  END IF

  WRITE(6,'(5x,a)')                                                   &
      'Output files will be in directory '//dirname(1:ldirnam)//'.'

  WRITE(6,'(/a/)') 'Output control parameters read in are:'
  WRITE(6,output)

  xorig1 = xctr1 - (nx1-3)*dx1*0.5
  yorig1 = yctr1 - (ny1-3)*dy1*0.5

  DO i=1,nx1
    x1(i) =xorig1+(i-2.0)*dx1
    xs1(i)=xorig1+(i-1.5)*dx1
  END DO

  DO j=1,ny1
    y1 (j) =yorig1+(j-2.0)*dy1
    ys1(j) =yorig1+(j-1.5)*dy1
  END DO

  DO i=1,nx-1
    xs(i)=0.5*(x(i)+x(i+1))
  END DO

  DO j=1,ny-1
    ys(j)=0.5*(y(j)+y(j+1))
  END DO

  print*,'xorig1,xs1(1),xs1(nx1-1)=',xorig1,xs1(1),xs1(nx1-1)
  print*,'yorig1,ys1(1),ys1(ny1-1)=',yorig1,ys1(1),ys1(ny1-1)

  xeps = 0.01*dx
  yeps = 0.01*dy
write(*,*)'xeps', xeps, 'dx', dx
write(*,*)'yeps', yeps, 'dy', dy
write(*,*)'x1(1)', x1(1), 'x(1)-xeps', x(1)-xeps
write(*,*)'y1(1)', y1(1), 'y(1)-yeps', y(1)-yeps
write(*,*)'x1(nx1)', x1(nx1), x(nx)+xeps, 'y1(ny1)', y1(ny1), y(ny)+yeps

  PRINT*,'x (2),x (nx -1),y (2),y (ny -1) =',                       &
          x(2),x(nx-1),y(2),y(ny-1)
  PRINT*,'x1(2),x1(nx1-1),y1(2),y1(ny1-1) =',                       &
          x1(2),x1(nx1-1),y1(2),y1(ny1-1)

!  IF(x1(    1) < x(   1)-xeps.OR.x1(nx1) > x(nx)+xeps.OR.           &
!        y1(    1) < y(   1)-yeps.OR.y1(ny1) > y(ny)+yeps) THEN
!    WRITE(6,'(3(/2x,a),/2x,2(a,f12.4),2(a,i5),2(a,f12.4),/2x,a)')   &
!    'Sorry, at least part of your new grid is outside the border of', &
!    'the original grid, please check input parameters',         &
!    'dx1,dy1, nx1, ny1, xctr1 and yctr1. Currently,',           &
!    'dx1=',dx1,', dy1=',dy1,', nx1=',nx1,', ny1=',ny1,          &
!    ', xctr1=',xctr1,', yctr1=',yctr1,                          &
!    'Job stopped in RADARDTAINTRP.'
!     GOTO 600
!!          STOP 1001
!  END IF

  allocate(isx(nx1),stat=istatus)
  isx = 0.0
  allocate(jsy(ny1),stat=istatus)
  jsy = 0.0
  allocate(wgtsx(nx1),stat=istatus)
  wgtsx = 0.0
  allocate(wgtsy(ny1),stat=istatus)
  wgtsy = 0.0

  DO i=1,nx1-1
    isx(i) = MAX(1, MIN(nx-2, INT((xs1(i)-xs(1))/dx)+1 ))
    wgtsx(i)= (xs(isx(i)+1)-xs1(i))/(xs(isx(i)+1)-xs(isx(i)))
  END DO

  DO j=1,ny1-1
    jsy(j) = MAX(1, MIN(ny-2, INT((ys1(j)-ys(1))/dy)+1 ))
    wgtsy(j)= (ys(jsy(j)+1)-ys1(j))/(ys(jsy(j)+1)-ys(jsy(j)))
  END DO

  print*,'isx(1),jsy(1)=', isx(1),jsy(1)
  print*,'nx1, ny1 =', nx1, ny1
  print*,'x1(1), x1(nx1), y1(1), y1(ny1) for output grid are :'
  print*,x1(1), x1(nx1), y1(1), y1(ny1)

  IF(datanamopt == 1)then
    nfile=INT((tn-t0)/dt)+1
  ENDIF

  DO l = 1,nfile

    IF(datanamopt == 1)then
      time=t0+(l-1)*dt
      itime=INT(time)
      timnam(1:1)=ACHAR( 48+int(itime/100000) )
      nen3=itime-100000*int(itime/100000)
      timnam(2:2)=ACHAR( 48+int(nen3/10000) )
      nen3=nen3-10000*int(nen3/10000)
      timnam(3:3)=ACHAR( 48+int(nen3/1000) )
      nen3=nen3-1000*int(nen3/1000)
      timnam(4:4)=ACHAR( 48+int(nen3/100) )
      nen3=nen3-100*int(nen3/100)
      timnam(5:5)=ACHAR( 48+int(nen3/10) )
      nen3=nen3-10*int(nen3/10)
      timnam(6:6)=ACHAR( 48+nen3 )
    ENDIF

    IF(datanamopt == 1)then
      filename1=trim(rdrdtadir)//'/'//trim(radarnam)//trim(timnam)
      write(*,*)trim(filename1)
      IF(vareadopt == 1)THEN
        filename2=trim(vadtadir)//'/'//trim(vanam)//trim(timnam)
      ENDIF
    ELSE
      filename1=trim(rdrdtadir)//'/'//trim(rdrdtanam(l))
      write(*,*)trim(filename1)
      IF(vareadopt == 1)THEN
        filename2=trim(vadtadir)//'/'//trim(vadtanam(l))
      ENDIF
    ENDIF

    CALL rdrdtareaddump(nx,ny,nz,nx1,ny1,x1,y1,xs1,ys1,dx1,dy1,   &
           isx,jsy,wgtsx,wgtsy,trim(filename1),trim(filename2),   &
           timnam,datatype,vareadopt,intrp_opt,grdbasfn1,runname, &
           dirname,hinfmt,outname,time)

   ENDDO

  STOP

  100 CONTINUE
  WRITE(6,'(a)') 'Error reading NAMELIST file. Program ARPSINTRP_LS stopped.'
  STOP

  600 CONTINUE
  STOP 600

END PROGRAM RADARDTAINTRP

!##################################################################
!##################################################################
!######                                                      ######
!######             SUBROUTINE RDRDTAREADDUMP                ######
!######                                                      ######
!######                     Developed by                     ######
!######     Center for Analysis and Prediction of Storms     ######
!######                University of Oklahoma                ######
!######                                                      ######
!##################################################################
!##################################################################

SUBROUTINE rdrdtareaddump(nx,ny,nz,nx1,ny1,x1,y1,xs1,ys1,dx1,dy1, &
           isx,jsy,wgtsx,wgtsy,filename1,filename2,   &
           timnam,datatype,vareadopt,intrp_opt,grdbasfn1,runname, &
           dirname,hinfmt,outname,time)

!-----------------------------------------------------------------------
!  PURPOSE:
!  Read in radar data.
!-----------------------------------------------------------------------
!
!  AUTHOR: Mingjing Tong
!  02/10/2007
!
!  MODIFICATION HISTORY:
!-----------------------------------------------------------------------
!
!  INPUT :
!
!    nx       Number of grid points in the x-direction (east/west)
!    ny       Number of grid points in the y-direction (north/south)
!    nz       Number of grid points in the vertical
!
!    filename1  Character variable nhming the input data file
!    filename2
!
!-----------------------------------------------------------------------
!  Variable Declarations.
!-----------------------------------------------------------------------

  IMPLICIT NONE

  INTEGER :: nx,ny,nz
  INTEGER :: nx1,ny1
  REAL :: x1(nx1), y1(ny1)
  REAL :: xs1(nx1), ys1(ny1)
  REAL :: dx1, dy1
  INTEGER :: isx(nx1),jsy(ny1)
  REAL :: wgtsx(nx1),wgtsy(ny1)

  CHARACTER (LEN=*) :: filename1
  CHARACTER (LEN=*) :: filename2
  CHARACTER (LEN=*) :: grdbasfn1
  CHARACTER (LEN=*) :: runname, timnam, outname
  CHARACTER (LEN=*) :: dirname

  INTEGER :: datatype, vareadopt, intrp_opt, hinfmt

  INTEGER :: ireturn
  REAL :: time

  INTEGER, PARAMETER :: ntiltmax = 15
  REAL, DIMENSION(:), ALLOCATABLE :: elvobs
  REAL, DIMENSION(:,:,:), ALLOCATABLE :: vr, ref, vro, refo, va, vao
  REAL, DIMENSION(:,:,:), ALLOCATABLE :: hgtoelv, hgto, rngoelv, rngo
  REAL, DIMENSION(:,:,:), ALLOCATABLE :: zps
  REAL :: timeset,iyr,imon,iday,ihour,imin,isec
  INTEGER :: ntilt,nxtmp,nytmp,nztmp 
  CHARACTER (LEN=10) :: rdrnam
  REAL :: rdrlat,rdrlon,radarx,radary,rdralt
  REAL :: dazim,rngmin,rngmax

  CHARACTER (LEN=60) :: varunits
  CHARACTER (LEN=60) :: varname
  CHARACTER (LEN=6) :: varid

  CHARACTER (LEN=128) :: filename1_out, filename2_out

  REAL, DIMENSION(nx1,ny1) :: azmsc,sfcrng
  REAL, DIMENSION(nx1,ny1,nz) :: elvsc,rngsc
!-----------------------------------------------------------------------
!  Misc. local variables
!-----------------------------------------------------------------------

  INTEGER :: i,j,k,itilt 

  INTEGER :: istat, istatus
  INTEGER :: nstyp1,nstypin
  INTEGER :: lengbf
  INTEGER :: nchin, nchout
  INTEGER :: nzsoil,nstyps

  REAL :: mapfct(nx1,ny1,8)      ! Map factors at scalar, u and v points

  REAL :: xtmp  (nx1)           ! x coord.
  REAL :: ytmp  (ny1)           ! y coord.
  REAL :: ztmp  (nz)            ! z coord.
  REAL :: zp1   (nx1,ny1,nz)
  REAL, DIMENSION(:,:,:), ALLOCATABLE :: temx1yz

!-----------------------------------------------------------------------
!
!  Include files:
!
!-----------------------------------------------------------------------

  INCLUDE 'grid.inc'        ! Grid parameters

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
!
!  Beginning of executable code...
!
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

  WRITE(*,*) 'Reading radar data file: ', trim(filename1)

  WRITE(*,*) 'Reading radar data file: ', trim(filename2)

!-----------------------------------------------------------------------
! Open file for reading 
!-----------------------------------------------------------------------

  IF(datatype == 1)THEN
    ALLOCATE(vr(nx,ny,nz),stat=istatus)
    CALL check_alloc_status(istatus, ":vr")
    ALLOCATE(ref(nx,ny,nz),stat=istatus)
    CALL check_alloc_status(istatus, "rdrdtareaddump:ref")
    ALLOCATE(vro(nx1,ny1,nz),stat=istatus)
    CALL check_alloc_status(istatus, ":vro")
    ALLOCATE(refo(nx1,ny1,nz),stat=istatus)
    CALL check_alloc_status(istatus, "rdrdtareaddump:refo")
    ALLOCATE(temx1yz(nx1,ny,nz),stat=istatus)
    CALL check_alloc_status(istatus, "rdrdtareaddump:temx1yz")
  ELSE IF(datatype == 2)THEN
    ALLOCATE(elvobs(ntiltmax),stat=istatus)
    CALL check_alloc_status(istatus, "rdrdtareaddump:elvobs")
    ALLOCATE(hgtoelv(nx,ny,ntiltmax),stat=istatus)
    CALL check_alloc_status(istatus, "rdrdtareaddump:hgtoelv")
    ALLOCATE(rngoelv(nx,ny,ntiltmax),stat=istatus)
    CALL check_alloc_status(istatus, "rdrdtareaddump:rngoelv")
    ALLOCATE(vr(nx,ny,ntiltmax),stat=istatus)
    CALL check_alloc_status(istatus, "rdrdtareaddump:vr")
    ALLOCATE(ref(nx,ny,ntiltmax),stat=istatus)
    CALL check_alloc_status(istatus, "rdrdtareaddump:ref")
    ALLOCATE(vro(nx1,ny1,ntiltmax),stat=istatus)
    CALL check_alloc_status(istatus, "rdrdtareaddump:vro")
    ALLOCATE(refo(nx1,ny1,ntiltmax),stat=istatus)
    CALL check_alloc_status(istatus, "rdrdtareaddump:refo")
    ALLOCATE(hgto(nx1,ny1,ntiltmax),stat=istatus)
    CALL check_alloc_status(istatus, "rdrdtareaddump:hgto")
    ALLOCATE(rngo(nx1,ny1,ntiltmax),stat=istatus)
    CALL check_alloc_status(istatus, "rdrdtareaddump:rngo")
    ALLOCATE(zps(nx1,ny1,nz),stat=istatus)
    CALL check_alloc_status(istatus, "rdrdtareaddump:zps")
  ELSE
    write(*,*)'additional type of data are not available now'
    STOP
  ENDIF

  CALL getunit(nchin)
  OPEN(UNIT=nchin,FILE=trim(filename1),STATUS='old',  &
       FORM='unformatted',IOSTAT= istat )
  IF( istat /= 0) GO TO 999
  IF(datatype == 1)THEN
    READ(nchin) timeset,iyr,imon,iday,ihour,imin,isec
    READ(nchin) nxtmp,nytmp
    READ(nchin) rdrnam
    READ(nchin) rdrlat,rdrlon,radarx,radary,rdralt
    READ(nchin) dazim,rngmin,rngmax
    IF(nxtmp /= nx .or. nytmp /= ny) GO TO 700
    READ(nchin)vr(:,:,:)
    READ(nchin)ref(:,:,:)
  ELSE IF(datatype == 2)THEN
    READ(nchin) timeset,iyr,imon,iday,ihour,imin,isec
    READ(nchin) ntilt,nxtmp,nytmp
    READ(nchin) rdrnam
    READ(nchin) rdrlat,rdrlon,radarx,radary,rdralt
    READ(nchin) dazim,rngmin,rngmax
    IF(nxtmp /= nx .or. nytmp /= ny) GO TO 700
    READ(nchin)elvobs(1:ntilt)
    READ(nchin)hgtoelv(:,:,1:ntilt)
    READ(nchin)rngoelv(:,:,1:ntilt)
    READ(nchin)vr(:,:,1:ntilt)
    READ(nchin)ref(:,:,1:ntilt)
  ELSE
    WRITE(*,*)'Additional type of data are not available now'
    STOP
  ENDIF
  CLOSE(UNIT=nchin)

  IF(vareadopt == 1)THEN
    IF(datatype == 1)THEN
      ALLOCATE(va(nx,ny,nz),stat=istatus)
      ALLOCATE(vao(nx1,ny1,nz),stat=istatus)
      varid = rdrnam(1:4)//'va'
      varname = 'cross beam wind component'
      varunits = 'm/s'
      CALL readvar2(nx,ny,nz,va, varid,varname,varunits,         &
                    time,runname,dirname, 3, 0, istatus)
    ELSE
      ALLOCATE(va(nx,ny,ntiltmax),stat=istatus)
      ALLOCATE(vao(nx1,ny1,ntiltmax),stat=istatus)
      OPEN(UNIT=30,FILE=trim(filename2),STATUS='old', &
           FORM='unformatted',IOSTAT= istatus )
      READ(30,ERR=110,END=120) va(:,:,1:ntilt)
      CLOSE(UNIT=30)
    ENDIF
  ENDIF 

!-----------------------------------------------------------------------
!  Interpolation 
!-----------------------------------------------------------------------


  IF(datatype == 1)THEN
    call intrpxy3d(vr,nx,1,nx-1,ny,1,ny-1,nz,1,nz,  &
         wgtsx,isx,wgtsy,jsy,intrp_opt,vro,nx1,1,nx1-1,ny1,1,ny1-1, temx1yz)
    call intrpxy3d(ref,nx,1,nx-1,ny,1,ny-1,nz,1,nz,  &
         wgtsx,isx,wgtsy,jsy,intrp_opt,refo,nx1,1,nx1-1,ny1,1,ny1-1, temx1yz)
    if(vareadopt == 1)then
      call intrpxy3d(va,nx,1,nx-1,ny,1,ny-1,nz,1,nz,  &
         wgtsx,isx,wgtsy,jsy,intrp_opt,vao,nx1,1,nx1-1,ny1,1,ny1-1, temx1yz)
    endif 
  ELSE
    ALLOCATE(temx1yz(nx1,ny,ntilt),stat=istatus)
    CALL check_alloc_status(istatus, "rdrdtareaddump:temx1yz")
    call intrpxy3d(vr,nx,1,nx-1,ny,1,ny-1,ntiltmax,1,ntilt,  &
         wgtsx,isx,wgtsy,jsy,intrp_opt,vro,nx1,1,nx1-1,ny1,1,ny1-1, temx1yz)
    call intrpxy3d(ref,nx,1,nx-1,ny,1,ny-1,ntiltmax,1,ntilt,  &
         wgtsx,isx,wgtsy,jsy,intrp_opt,refo,nx1,1,nx1-1,ny1,1,ny1-1, temx1yz)
    if(vareadopt == 1)then
      call intrpxy3d(va,nx,1,nx-1,ny,1,ny-1,ntiltmax,1,ntilt,  &
           wgtsx,isx,wgtsy,jsy,intrp_opt,vao,nx1,1,nx1-1,ny1,1,ny1-1, temx1yz)
    endif

    lengbf = len_trim(grdbasfn1)
    WRITE(6,'(/a,a)')' The grid/base name is ', trim(grdbasfn1)

    CALL get_dims_from_data(hinfmt,grdbasfn1(1:lengbf),                    &
         nxtmp,nytmp,nztmp,nzsoil,nstyps, ireturn)
    
    if(nxtmp /= nx1 .or. nytmp /= ny1 .or. nztmp /= nz) GOTO 700
    CALL get_gridinfo_from_hdf(grdbasfn1(1:lengbf),nxtmp,nytmp,nztmp,xtmp, &
         ytmp,ztmp,zp1,ireturn)

    DO k=1,nz-1
      DO j=1,ny1-1
        DO i=1,nx1-1
          zps(i,j,k)=0.5*(zp1(i,j,k)+zp1(i,j,k+1))
        END DO
      END DO
    END DO

    IF(mapproj > 0) THEN
      CALL mapprjpara(nx1,ny1,x1,y1,dx1,dy1,mapfct)
    ENDIF

    CALL rdrgrdpara(nx1,ny1,nz,xs1,ys1,zps,rdrlat,rdrlon,    &
                    rdralt,radarx,radary,rngmin, &
                    rngmax,azmsc,sfcrng,elvsc,rngsc)

    hgto=-999.0
    rngo=-999.0
    DO itilt=1,ntilt
      DO j=2,ny1-2 
        DO i=2,nx1-2
          CALL bmhgtsfr2(elvobs(itilt),sfcrng(i,j),hgto(i,j,itilt), &
               rngo(i,j,itilt))
          hgto(i,j,itilt)=hgto(i,j,itilt)+rdralt
        ENDDO
      ENDDO
    ENDDO
  ENDIF

!-----------------------------------------------------------------------
! Data dump
!-----------------------------------------------------------------------

  filename1_out=trim(rdrnam)//'_'//trim(outname)//'_'//trim(timnam)
  IF(vareadopt == 1)THEN
    filename2_out=trim(rdrnam)//'_'//trim(outname)//'_Va_'//trim(timnam)
  ENDIF

  CALL getunit(nchout)
  OPEN(UNIT=nchout,FILE=trim(filename1_out),STATUS='replace', &
       FORM='unformatted',IOSTAT= istat )
  IF( istat /= 0) GO TO 999
  IF(datatype == 1)THEN
    WRITE(nchout)timeset,iyr,imon,iday,ihour,imin,isec
    WRITE(nchout)nx1,ny1
    WRITE(nchout)rdrnam
    WRITE(nchout)rdrlat,rdrlon,radarx,radary,rdralt
    WRITE(nchout)dazim,rngmin,rngmax
    WRITE(nchout)vro(:,:,:)
    WRITE(nchout)refo(:,:,:)
  ELSE IF(datatype == 2)THEN
    WRITE(nchout) timeset,iyr,imon,iday,ihour,imin,isec
    WRITE(nchout) ntilt,nx1,ny1
    WRITE(nchout) rdrnam
    WRITE(nchout) rdrlat,rdrlon,radarx,radary,rdralt
    WRITE(nchout) dazim,rngmin,rngmax
    WRITE(nchout)elvobs(1:ntilt)
    WRITE(nchout)hgto(:,:,1:ntilt)
    WRITE(nchout)rngo(:,:,1:ntilt)
    WRITE(nchout)vro(:,:,1:ntilt)
    WRITE(nchout)refo(:,:,1:ntilt)
  ELSE
    WRITE(*,*)'Additional type of data are not available now'
    STOP
  ENDIF
  CLOSE(UNIT=nchout)
  CALL retunit(nchout)

  IF(vareadopt > 0)THEN
    IF(datatype == 1)THEN
      varid = rdrnam(1:4)//'va'
      varname = 'cross beam wind component'
      varunits = 'm/s'
      CALL wrtvar2(nx1,ny1,nz,vao,varid,trim(varname),trim(varunits), &
                   time,trim(outname),trim(dirname),3,5,0,   &
                   istatus)
    ELSE
      CALL getunit(nchout)
      OPEN(UNIT=nchout,FILE=trim(filename2_out),STATUS='replace', &
           FORM='unformatted',IOSTAT= istat )
      IF( istat /= 0) GO TO 999
      WRITE(nchout)vao(:,:,1:ntilt)
      CLOSE(UNIT=nchout)
      CALL retunit(nchout)
    ENDIF
  ENDIF

  RETURN
!-----------------------------------------------------------------------
!
!  Error during read
!
!-----------------------------------------------------------------------

  110   CONTINUE
  WRITE(6,'(/a/)') ' Error reading data filename2'
  STOP

  999   CONTINUE
  WRITE(6,'(1x,a,a,a,/1x,i3)')                        &
      'Error occured when opening file ',trim(filename2_out),  &
      'using FORTRAN unit ',nchout
  CALL arpsstop(' Program stopped in dumprdrobs.',1)
  STOP


  700   CONTINUE
  WRITE(6,'(1x,a,a,i4,a,i4)') 'Dimensions are not consisitent'
  WRITE(6,'(1x,a,/1x,a,i4,/1x,a,i4)') 'Dimensions read in are', 'nx=', nxtmp, &
                   'ny=', nytmp
  WRITE(6,'(1x,a,/1x,a,i4,/1x,a,i4)') 'Dimensions used are', 'nx=', nx, &
                   'ny=', ny
  STOP

!-----------------------------------------------------------------------
!
!  End-of-file during read
!
!-----------------------------------------------------------------------

  120   CONTINUE
  WRITE(6,'(/a/)') ' End of file reached in HDFREAD'
  STOP

END SUBROUTINE rdrdtareaddump

!##################################################################
!##################################################################
!######                                                      ######
!######             SUBROUTINE GET_GRIDINFO_FROM_HDF         ######
!######                                                      ######
!######                     Developed by                     ######
!######     Center for Analysis and Prediction of Storms     ######
!######                University of Oklahoma                ######
!######                                                      ######
!##################################################################
!##################################################################

SUBROUTINE get_gridinfo_from_hdf(filename,nx,ny,nz,x,y,z,zp,ireturn)

!
!-----------------------------------------------------------------------
!
!  PURPOSE:
!  Read in grid dimensions from base state/grid history data.
!
!-----------------------------------------------------------------------
!
!  AUTHOR: Ming Xue
!  7/17/2000.
!
!  MODIFICATION HISTORY:
!
!-----------------------------------------------------------------------
!
!  INPUT :
!
!    filename Channel number for binary reading.
!
!  OUTPUT:
!
!    nx       Number of grid points in the x-direction (east/west)
!    ny       Number of grid points in the y-direction (north/south)
!    nz       Number of grid points in the vertical
!
!-----------------------------------------------------------------------

  IMPLICIT NONE

  INTEGER :: stat, sd_id
  CHARACTER (LEN=*) :: filename

  INTEGER :: nx,ny,nz          ! Number of grid points in 3 directions
  REAL :: x(nx),y(ny),z(nz)
  REAL :: zp(nx,ny,nz)

  INTEGER (KIND=selected_int_kind(4)), ALLOCATABLE :: itmp(:,:,:) ! Temporary array
  REAL, ALLOCATABLE :: hmax(:), hmin(:) ! Temporary array

  INTEGER :: ireturn           ! Return status indicator

  INTEGER istat

!-----------------------------------------------------------------------
!
!  Include files:
!
!-----------------------------------------------------------------------

  INCLUDE 'grid.inc'

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
!
!  Beginning of executable code...
!
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

  CALL hdfopen(filename,1,sd_id)

  IF (sd_id < 0) THEN
    WRITE (6,*) "get_gridinfo_from_hdf: ERROR opening ",                 &
                 trim(filename)," for reading."
    GO TO 110
  ELSE
    WRITE(6,*) 'File ',filename,' openned.'
  END IF

  ALLOCATE (itmp(nx,ny,nz),stat=istat)
  ALLOCATE (hmax(nz),stat=istat)
  ALLOCATE (hmin(nz),stat=istat)

! print*,'sd_id, nx =', sd_id, nx

  CALL hdfrd1d(sd_id,"x",nx,x,istat)

! print*,'istat after reading x =', istat

  IF (istat /= 0) GO TO 110
  CALL hdfrd1d(sd_id,"y",ny,y,istat)
  IF (istat /= 0) GO TO 110
  CALL hdfrd1d(sd_id,"z",nz,z,istat)
  IF (istat /= 0) GO TO 110

  CALL hdfrd3d(sd_id,"zp",nx,ny,nz,zp,istat,itmp,hmax,hmin)
  IF (istat /= 0) GO TO 110

  CALL hdfrdi(sd_id,"mapproj",mapproj,istat)
  IF (istat /= 0) GO TO 110
  CALL hdfrdr(sd_id,"trulat1",trulat1,istat)
  IF (istat /= 0) GO TO 110
  CALL hdfrdr(sd_id,"trulat2",trulat2,istat)
  IF (istat /= 0) GO TO 110
  CALL hdfrdr(sd_id,"trulon",trulon,istat)
  IF (istat /= 0) GO TO 110
  CALL hdfrdr(sd_id,"sclfct",sclfct,istat)
  IF (istat /= 0) GO TO 110
  CALL hdfrdr(sd_id,"ctrlat",ctrlat,istat)
  IF (istat /= 0) GO TO 110
  CALL hdfrdr(sd_id,"ctrlon",ctrlon,istat)
  IF (istat /= 0) GO TO 110

  ireturn = 0
  GO TO 130

!-----------------------------------------------------------------------
!
!  Error during read
!
!-----------------------------------------------------------------------

  110   CONTINUE
  WRITE(6,'(/a/)') ' Error reading data in GET_GRIDINFO_FROM_HDF.'
  ireturn=1

130 CONTINUE

!tmp  stat = sfendacc(sd_id)   ! is this necessary?
  CALL hdfclose(sd_id,stat)
  DEALLOCATE (itmp)
  DEALLOCATE (hmax)
  DEALLOCATE (hmin)

  RETURN
END SUBROUTINE get_gridinfo_from_hdf

