Program PLT3DTRAJC
!
! This program calls ZXPLOT plotting space initialization subroutines
! then NCAR 3D plotting subroutines (TDINIT, TDGRDS, TDLINE - Google them
! for their definitions), to plot 3D trajectories generated by
! arpstrajc program.
!
! To compile:
! zxncarpgf90 -o plt3dtrajc plt3dtrajc.f90
!
! or using zxncarifort or zxncarf90 in place of zxncarpgf90
! depending what Fortran compiler you use.
!
! To run:
! plt3dtrajc < plt3dtrajc.input
!

  REAL :: dx, dy, dz
  REAL :: xlow, xhigh, ylow, yhigh, zlow, zhigh
  REAL :: xtra
  REAL, allocatable :: xtrajc(:,:),ytrajc(:,:),ztrajc(:,:),ttrajc(:)
  INTEGER :: ntrajcs, npoints
  INTEGER :: i,j,k, istat, nunit
  CHARACTER(LEN=256) :: trajc_fn
  CHARACTER(LEN=80)  :: runname
  CHARACTER(LEN=256) :: outfilename
  REAL :: tstart, tzero, tend
  NAMELIST /input/ trajc_fn

  trajc_fn = 'default_file_name'
  READ(5,input)

  nunit = 15

  OPEN(UNIT=nunit,FILE=trim(trajc_fn),STATUS='unknown',   &
        FORM='formatted',IOSTAT= istat )

  READ(nunit,'(a)') runname
  READ(nunit,'(6e17.6)') xlow, xhigh, ylow, yhigh, zlow, zhigh
  write(6,'(6e17.6)') xlow, xhigh, ylow, yhigh, zlow, zhigh
  READ(nunit,'(3e17.6)') dx, dy, dz
  write(6,'(3e17.6)') dx, dy, dz

  READ(nunit,'(3e17.6)') tstart, tzero, tend
  READ(nunit,'(i10)') npoints
  READ(nunit,'(i10)') ntrajcs

  allocate(xtrajc(npoints,ntrajcs))
  allocate(ytrajc(npoints,ntrajcs))
  allocate(ztrajc(npoints,ntrajcs))
  allocate(ttrajc(npoints))

  DO j=1,npoints
    READ(nunit,'(4e17.6)') ttrajc(j)
    READ(nunit,'(6e17.6)') ((xtrajc(j,i),ytrajc(j,i),ztrajc(j,i)),i=1,ntrajcs)
  ENDDO


  CLOSE(UNIT=nunit)

  call xdevic(1,outfilename,0,0)
  CALL xdspac(0.9)

  call xpspac(0.05, 0.95, 0.05, 0.95)

  CALL ZX3DSTRM(dx,dy,dz,xtrajc,ytrajc,ztrajc,ttrajc, npoints, ntrajcs,  &
           xlow, xhigh, ylow, yhigh, zlow, zhigh)

  call xgrend

  stop
end

SUBROUTINE ZX3DSTRM(dx,dy,dz,xga,yga,zga,tga, npoints, ntrajcs,  &
           xlow, xhigh, ylow, yhigh, zlow, zhigh)

  implicit none

  REAL :: dx, dy, dz

  INTEGER :: npoints,ntrajcs
  real xga(npoints,ntrajcs)
  real zga(npoints,ntrajcs)
  real yga(npoints,ntrajcs)
  real tga(npoints)

  REAL :: xlow, xhigh, ylow, yhigh, zlow, zhigh

  real umid,vmid,wmid,uori,vori,wori,uthi,vthi,wthi

  real normalize, missing_value, eps, zga_normalized1,zga_normalized2

  integer i,j,k, n

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

   print *,'entering zx3dplot plotting routine...'

  missing_value = -99999.0
  eps = 0.001

  call xsetclrs(1)

!-----------------------------------draw lines------------------

  normalize = 2.0 * (xhigh-xlow) / (zhigh-zlow)

  umid = xlow - (1.75*(xhigh-xlow))
  vmid = ylow - (1.75*(yhigh-ylow))
  wmid = (3.00*((zlow+zhigh)/2.0))*normalize

  umid = xlow - 2.0*(xhigh-xlow)
  vmid = ylow - 2.0*(yhigh-ylow)
  wmid = (0.5 *((zlow+zhigh)/2.0))*normalize

  uori = (xlow+xhigh)/2.0
  vori = (ylow+yhigh)/2.0
  wori = ((zlow+zhigh)/4.0)*normalize

  uthi = uori
  vthi = vori
  wthi = 2.0*wori

  print *,' calling tdinit'
  CALL TDINIT(umid,vmid,wmid,uori,vori,wori,uthi,vthi,wthi,0)

  print *,' calling tdgrds start'
  CALL TDGRDS(xlow,ylow,zlow*normalize,xhigh,yhigh,  &
              zhigh*normalize,dx,dy, dz*normalize,2,1)

  print *, 'starting to make plot'

  DO i=1,ntrajcs
    call xcolor( mod( i+2, 253 ) )
    DO n=1, npoints-1

      if( .not. (                                  &
          abs(xga(n  ,i)-missing_value).lt.eps.or. &
          abs(yga(n  ,i)-missing_value).lt.eps.or. &
          abs(zga(n  ,i)-missing_value).lt.eps.or. &
          abs(xga(n+1,i)-missing_value).lt.eps.or. &
          abs(yga(n+1,i)-missing_value).lt.eps.or. &
          abs(zga(n+1,i)-missing_value).lt.eps ) ) then

        zga_normalized1 = zga(n  ,i)*normalize
        zga_normalized2 = zga(n+1,i)*normalize

        CALL TDLINE(xga(n  ,i),yga(n  ,i),zga_normalized1, &
                    xga(n+1,i),yga(n+1,i),zga_normalized2)
      endif
    ENDDO
  ENDDO

  print *,' calling TDGRDS end'

  print*,'xlow,ylow,zlow,xhigh,yhigh,zhigh*normalize=',xlow,ylow,zlow,xhigh,yhigh,zhigh*normalize
  print*,'dx,dy,dz=', dx,dy,dz

  CALL GSPLCI(1)
  CALL TDGRDS(xlow,ylow,zlow*normalize,xhigh,yhigh,  &
               zhigh*normalize,dx,dy,dz*normalize,2,0)
!-----------------------------------------------------------------
  CALL FRAME

  RETURN
  END
