      FUNCTION GCDIST(RLAT1,RLON1,RLAT2,RLON2)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:  GCDIST     COMPUTE GREAT CIRCLE DISTANCE
C   PRGMMR: IREDELL       ORG: W/NMC23       DATE: 96-04-10
C
C ABSTRACT: THIS SUBPROGRAM COMPUTES GREAT CIRCLE DISTANCE
C           BETWEEN TWO POINTS ON THE EARTH.
C
C PROGRAM HISTORY LOG:
C   96-04-10  IREDELL
C
C USAGE:    ...GCDIST(RLAT1,RLON1,RLAT2,RLON2)
C
C   INPUT ARGUMENT LIST:
C     RLAT1    - REAL LATITUDE OF POINT 1 IN DEGREES
C     RLON1    - REAL LONGITUDE OF POINT 1 IN DEGREES
C     RLAT2    - REAL LATITUDE OF POINT 2 IN DEGREES
C     RLON2    - REAL LONGITUDE OF POINT 2 IN DEGREES
C
C   OUTPUT ARGUMENT LIST:
C     GCDIST   - REAL GREAT CIRCLE DISTANCE IN METERS
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C
C$$$
      PARAMETER(RERTH=6.3712E6)
      PARAMETER(PI=3.14159265358979,DPR=180./PI)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      CLAT1=COS(RLAT1/DPR)
      SLAT1=SIN(RLAT1/DPR)
      CLAT2=COS(RLAT2/DPR)
      SLAT2=SIN(RLAT2/DPR)
      CDLON=COS((RLON1-RLON2)/DPR)
      CRD=SLAT1*SLAT2+CLAT1*CLAT2*CDLON
      GCDIST=RERTH*ACOS(CRD)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END
