C-----------------------------------------------------------------------
      SUBROUTINE MOVECT(FLAT,FLON,TLAT,TLON,CROT,SROT)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:  MOVECT     MOVE A VECTOR ALONG A GREAT CIRCLE
C   PRGMMR: IREDELL       ORG: W/NMC23       DATE: 96-04-10
C
C ABSTRACT: THIS SUBPROGRAM PROVIDES THE ROTATION PARAMETERS
C           TO MOVE A VECTOR ALONG A GREAT CIRCLE FROM ONE
C           POSITION TO ANOTHER WHILE CONSERVING ITS ORIENTATION
C           WITH RESPECT TO THE GREAT CIRCLE.  THESE ROTATION
C           PARAMETERS ARE USEFUL FOR VECTOR INTERPOLATION.
C        
C PROGRAM HISTORY LOG:
C   96-04-10  IREDELL
C
C USAGE:    CALL MOVECT(FLAT,FLON,TLAT,TLON,CROT,SROT)
C
C   INPUT ARGUMENT LIST:
C     FLAT     - REAL LATITUDE IN DEGREES FROM WHICH TO MOVE THE VECTOR
C     FLON     - REAL LONGITUDE IN DEGREES FROM WHICH TO MOVE THE VECTOR
C     TLAT     - REAL LATITUDE IN DEGREES TO WHICH TO MOVE THE VECTOR
C     TLON     - REAL LONGITUDE IN DEGREES TO WHICH TO MOVE THE VECTOR
C
C   OUTPUT ARGUMENT LIST:
C     CROT     - REAL CLOCKWISE VECTOR ROTATION COSINE
C     SROT     - REAL CLOCKWISE VECTOR ROTATION SINE
C                (UTO=CROT*UFROM-SROT*VFROM;
C                 VTO=SROT*UFROM+CROT*VFROM)
C
C REMARKS: THIS SUBPROGRAM IS CORRECT TO SEVEN DIGITS ON THE CRAYS.
C          USE DOUBLE PRECISION IF BETTER PRECISION IS REQUIRED.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C
C$$$
      PARAMETER(PI=3.14159265358979,DPR=180./PI)
      PARAMETER(CRDLIM=0.9999999)
CC    DOUBLE PRECISION PI,DPR,CRDLIM
CC    DOUBLE PRECISION CTLAT,STLAT,CFLAT,SFLAT,CDLON,SDLON,CRD
CC    DOUBLE PRECISION SRD2RN,STR,CTR,SFR,CFR
CC    PARAMETER(PI=3.1415926535897932384626433833,DPR=180./PI)
CC    PARAMETER(CRDLIM=0.99999999999999)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  COMPUTE COSINE OF THE RADIAL DISTANCE BETWEEN THE POINTS.
      CTLAT=COS(TLAT/DPR)
      STLAT=SIN(TLAT/DPR)
      CFLAT=COS(FLAT/DPR)
      SFLAT=SIN(FLAT/DPR)
      CDLON=COS((FLON-TLON)/DPR)
      SDLON=SIN((FLON-TLON)/DPR)
      CRD=STLAT*SFLAT+CTLAT*CFLAT*CDLON
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  COMPUTE ROTATIONS AT BOTH POINTS WITH RESPECT TO THE GREAT CIRCLE
C  AND COMBINE THEM TO GIVE THE TOTAL VECTOR ROTATION PARAMETERS.
      IF(ABS(CRD).LE.CRDLIM) THEN
        SRD2RN=-1/(1-CRD**2)
        STR=CFLAT*SDLON
        CTR=CFLAT*STLAT*CDLON-SFLAT*CTLAT
        SFR=CTLAT*SDLON
        CFR=CTLAT*SFLAT*CDLON-STLAT*CFLAT
        CROT=SRD2RN*(CTR*CFR-STR*SFR)
        SROT=SRD2RN*(CTR*SFR+STR*CFR)
C  USE A DIFFERENT APPROXIMATION FOR NEARLY COINCIDENT POINTS.
C  MOVING VECTORS TO ANTIPODAL POINTS IS AMBIGUOUS ANYWAY.
      ELSE
        CROT=CDLON
        SROT=SDLON*STLAT
      ENDIF
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END
