AC_DEFUN([SED_GET_ARCHITECTURE],
[AC_CHECK_PROGS(DPKG,dpkg)
if test x$DPKG != x ; then
   $1=`$DPKG --print-installation-architecture`
else
   AC_CHECK_PROGS(UNAME,uname)
   if test x$UNAME != x ; then
      $1=`uname -s`-`uname -p`
   else
      $1=Unknown
   fi
fi])

AC_DEFUN([SED_ENABLE_PROCESS],
[AC_ARG_ENABLE($1,
   AC_HELP_STRING([--enable-$1],[Enable $1 process]),
   [echo ENABLE_VAL ${enableval}
   if test x"${enableval}" = xno ; then
      sed_with_$1=false
   else
      sed_with_$1=true
   fi
   echo Setting sed_with_$1 = $sed_with_$1
   ],
   [sed_with_$1=true])
])


AC_DEFUN([SED_WITH_LIBINTL_DIR],
[AC_ARG_WITH(libintl-dir,
   AC_HELP_STRING([--with-libintl-dir=PATH], [path to libintl]),
   [if test x$with_libintl_dir != x ; then
      GLIB_ADD_TO_VAR(LIBS, -L${with_libintl_dir} , -L${with_libintl_dir})
   else
      if test x${LIBINTL_DIR} != x ; then
         GLIB_ADD_TO_VAR(LIBS, -L${LIBINTL_DIR} , -L${LIBINTL_DIR})
      fi
   fi])
])

AC_DEFUN([SED_WITH_CHECK],
[AC_ARG_WITH(check,
   AC_HELP_STRING([--with-check=PATH],[Use check unit tests]),
   [sed_save_PKG_CONFIG_PATH=$PKG_CONFIG_PATH
   if test x"${with_check}" != x ; then
      PKG_CONFIG_PATH=$PKG_CONFIG_PATH:$with_check/lib/pkgconfig
   fi
   PKG_CHECK_MODULES(CHECK,check,,AC_MSG_ERROR(libcheck not found))
   AC_SUBST(CHECK_LIBS)
   AC_SUBST(CHECK_CFLAGS)
   sed_with_check=true],
   sed_with_check=false)
])

AC_DEFUN([SED_WITH_SEDFLUX],
[AC_ARG_WITH(sedflux,
   AC_HELP_STRING([--with-sedflux=PATH],[Use sedflux library]),
   [sed_save_PKG_CONFIG_PATH=$PKG_CONFIG_PATH
   if test x"${with_sedflux}" != x ; then
      PKG_CONFIG_PATH=$PKG_CONFIG_PATH:$with_sedflux/lib/pkgconfig
   fi
   PKG_CHECK_MODULES(SEDFLUX,sedflux,,AC_MSG_ERROR(libsedflux not found))
   AC_SUBST(SEDFLUX_LIBS)
   AC_SUBST(SEDFLUX_CFLAGS)
   sed_with_sedflux=true],
   sed_with_sedflux=false)
])

AC_DEFUN([SED_WITH_GTK],
[AC_ARG_WITH(gtk,
   AC_HELP_STRING([--with-gtk=PATH],[Compile GUI using GTK+-2.0]),
   [if test x"${with_gtk}" == x ; then
      PKG_CHECK_MODULES(GTK,[gtk+-2.0 >= gtk_required_version],
         GTK=gtk,
         AC_MSG_ERROR([
*** Checks for GTK+-2.0 failed.  You can build without it by passing
*** --disable-libgtk to configure but some programs using GTK+ will
*** not work properly.]) )
   fi
   sed_with_gtk=true],
   sed_with_gtk=false)
])


AC_DEFUN([SED_WITH_BLAS],
[AC_ARG_WITH(blas,
   AC_HELP_STRING([--with-blas=PATH],[Use BLAS/LAPACK libraries]),
   [if test x"${with_blas}" == x ; then
      PKG_CHECK_MODULES(BLAS,[blas >= blas_required_version],BLAS=blas,
         AC_MSG_ERROR([
*** Checks for BLAS failed.  You can build without it by passing
*** --disable-blas to configure.]) )
   else
      sed_save_LIBS=$LIBS
      LIBS=-L$with_blas/lib
      AC_CHECK_LIB(cblas,[cblas_dscal],,,[-latlas])
      LIBS=$sed_save_LIBS
      if test x"${ac_cv_lib_cblas_cblas_dscal}" = xno ; then
         AC_MSG_ERROR([*** Failed to find BLAS library in $with_blas/lib.])
      else
         BLAS_LIBS="-L${with_blas}/lib -lcblas -latlas"
         BLAS_CFLAGS="-I${with_blas}/include -DENABLE_BLAS"
         AC_SUBST(BLAS_LIBS)
         AC_SUBST(BLAS_CFLAGS)
      fi
   fi
   sed_with_blas=true],
   sed_with_blas=false)
])

AC_DEFUN([SED_WITH_HTML_DOC_DIR],
[AC_ARG_WITH(html-dir,
   AC_HELP_STRING([--with-html-dir=PATH], [path to installed docs]),
   [if test x$"{with_html_dir}" == x ; then
      HTML_DIR='${datadir}/ew-doc/html'
   else
      HTML_DIR=${with_html_dir}
   fi
   AC_SUBST(HTML_DIR)
   sed_with_html_doc_dir=true],
   sed_with_html_doc_dir=false)
])

AC_DEFUN([SED_WITH_DOXYGEN],
[AC_ARG_WITH(doxygen,
   AC_HELP_STRING([--with-doxygen],[use doxygen to build documentation [default=no]]),
   [if test x"${with_doxygen}" == x ; then
      AC_CHECK_PROGS(DOXYGEN,doxygen)
      sed_with_flex=false
      if x$DOXYGEN != x ; then
         AC_CHECK_LIB(fl,[main])
         if test x$HAVE_LIBFL != x ; then
            AC_CHECK_PROGS( FLEX , flex )
            if test x$FLEX != x ; then
               sed_with_flex=true
            fi
         fi
      else
         AC_MSG_ERROR([
*** Program Doxygen was not found.  If you don't need to generate documentaion,
*** use the --disable-doxygen option when configuring.  Otherwise, if you
*** have doxygen, make sure it is in your path. ])
      fi
   fi
   sed_with_doxygen=true],
   sed_with_doxygen=false)
])

