#define CREST_VERSION "CREST V1.6c"
MODULE RunCon ! All Control Information from File
	IMPLICIT NONE
	CHARACTER(80):: gProject,  gBasicFolder, gExportFolder, gRainFolder, gPETFolder, gQobsFile
	CHARACTER(6)::  gRunStyle, gBasicFormat, gExportFormat, gRainFormat, gPetFormat, gQobsFormat

	INTEGER(4):: gChildNum
	CHARACTER(80), ALLOCATABLE:: gChildFile(:)

	CHARACTER(1):: gTimeMark
	INTEGER(4):: gTimeStep, gDatBegin(1:6), gDatWarm(1:6), gDatEND(1:6)
	LOGICAL:: gStatusLoad, gStatusSave

	INTEGER(4):: gParaNum
	CHARACTER(6), ALLOCATABLE:: gParaName(:)
	REAL(4), ALLOCATABLE:: gParaValue(:), gParaMin(:), gParaMax(:)
	LOGICAL, ALLOCATABLE:: gParaRenew(:)

	INTEGER(4):: gExitNum
	LOGICAL:: gClipByExit, gExitColRow
	INTEGER(4), allocatable:: gExitCol(:), gExitRow(:)
	CHARACTER(10), ALLOCATABLE:: gExitName(:)

	REAL(4):: gMinNSCE, gMaxBiasP, gErrLimit
	INTEGER(4):: gBaseNum, gTopNum
	
	LOGICAL:: gExport2D(9)
	
	Integer(4):: gLevelNum
	Integer(4), allocatable:: gLevelMark(:)
	Real(4), allocatable:: gLevel(:,:,:)

	! Public Array
	INTEGER(4):: nCols, nRows
	REAL(4):: xllCor, yllCor, ceSize, noData
	REAL(4), ALLOCATABLE:: gDEM(:,:), gDDM(:,:), gFAM(:,:)

	! 2-D Parameter
	REAL(4), ALLOCATABLE:: pOneW(:,:),   pOneSto(:,:), pTwoSto(:,:), pFc(:,:)
    REAL(4), ALLOCATABLE:: pWmax(:,:),   pIM(:,:),     pKE(:,:),     pB(:,:)
    REAL(4), ALLOCATABLE:: pCoeM(:,:),   pExpM(:,:),   pCoeR(:,:),   pCoeS(:,:)
    REAL(4), ALLOCATABLE:: PLeaOne(:,:), PLeaTwo(:,:), pTh(:,:),     pGm(:,:)

	! EXTERNAL FUNCTION
	CHARACTER(14), EXTERNAL:: myDtoStr
	CHARACTER(6), EXTERNAL:: PosIntMsg
	INTEGER(4), EXTERNAL:: myDdIFf, myDcompare
	LOGICAL, EXTERNAL:: myDequal
END MODULE


program Main
	USE RunCon
	IMPLICIT NONE
	
	CHARACTER(80):: Filename, msg, buf
	Character(14):: strD
	INTEGER(4):: I, lR, lC
	LOGICAL:: fExist
	REAL(4), ALLOCATABLE:: Mask(:,:), ExitLong(:), ExitLati(:)
	REAL(4):: LenEW, LenSN, TotalArea

	
	Filename="control.txt"
	CALL GETARG(1,buf)
	IF (len(TRIM(buf)) .NE. 0) THEN
		Filename = buf
	END IF
	INQUIRE(file=TRIM(Filename), exist=fExist)
	IF (fExist) THEN
		Write(*,*) CREST_VERSION
	Else
		WRITE(*,*) "Missing [control file] ", TRIM(Filename)
		CALL EXIT
	END IF
	
	OPEN(102,file=TRIM(Filename), form="formatted")
		READ(102,*) msg ! user defination
		READ(102,*) msg, gProject
		READ(102,*) msg, gRunStyle
		READ(102,*) msg, gBasicFormat,  gBasicFolder
		READ(102,*) msg, gRainFormat,   gRainFolder
		READ(102,*) msg, gPETFormat,    gPETFolder
		READ(102,*) msg, gExportFormat, gExportFolder
		READ(102,*) msg, gQobsFormat,	gQobsFile

		READ(102,*) msg ! user defination
		READ(102,*) msg, gChildNum
		if (gChildNum>0) THEN
			ALLOCATE(gChildFile(gChildNum))
			DO I = 1, gChildNum
				READ(102,*) msg, gChildFile(I)
			END DO
		END IF

		READ(102,*) msg ! user defination
		READ(102,*) msg, gTimeMark, gTimeStep
		READ(102,*) msg, strD, msg
			CALL myStrtoD(strD, gDatBegin, gTimeMark)
			gStatusLoad = (TRIM(msg)=="yes")
		READ(102,*) msg, strD
			CALL myStrtoD(strD, gDatWarm,  gTimeMark)
			if (myDcompare(gDatBegin, gDatWarm)==-1) gDatWarm=gDatBegin
		READ(102,*) msg, strD, msg
			CALL myStrtoD(strD, gDatEND,   gTimeMark)			
			gStatusSave = (TRIM(msg)=="yes")
			if (myDcompare(gDatWarm, gDatEnd)==-1) gDatWarm=gDatEnd

		READ(102,*) msg ! user defination
		READ(102,*) msg, gParaNum
		ALLOCATE(gParaName(gParaNum), gParaMin(gParaNum), gParaValue(gParaNum), gParaMax(gParaNum), gParaRenew(gParaNum))
		DO I = 1, gParaNum
			READ(102,*) gParaName(I), gParaMin(I), gParaMax(I), msg, gParaValue(I)
				gParaRenew(I) = (TRIM(msg)=="yes")
		END DO
	
		READ(102,*) msg ! user defination
		READ(102,*) msg, gExitNum
		READ(102,*) msg, strD, msg
			gExitColRow = (TRIM(strD)=="yes")
			gClipByExit = (TRIM(msg)=="yes")
		If (gExitNum>0) Then
			Allocate(gExitName(gExitNum), gEXitCol(gExitNum), gExitRow(gExitNum), ExitLong(gExitNum), ExitLati(gExitNum))
			If (gExitColRow) Then
				Do I=1, gExitNum
					READ(102,*) msg, gExitName(I), gExitCol(I),  gExitRow(I)
				End DO
			Else
				Do I=1, gExitNum
					READ(102,*) msg, gExitName(I), ExitLong(I),  ExitLati(I)
				End DO
			End if
		END IF
		
		READ(102,*) msg ! user defination
		READ(102,*) msg, gMinNSCE
		READ(102,*) msg, gMaxBiasP
		READ(102,*) msg, gBaseNum
		READ(102,*) msg, gTopNum
		READ(102,*) msg, gErrLimit
		
		READ(102,*) msg ! user defination
		DO I = 1, 9
			READ(102,*) msg, msg
				gExport2D(I) = (TRIM(msg)=="yes")
		END DO

		READ(102,*) msg ! user defination
		READ(102,*) msg, gLevelNum
		IF (gLevelNum>0) Then
			ALLOCATE(gLevelMark(1:gLevelNum))
			Read(102,*) msg, (gLevelMark(I), I=1, gLevelNum)
		Else
			Read(102,*) msg
		END if
		
		READ(102,*) msg ! user defination
		READ(102,*) msg, msg
	Close(102)
	IF (TRIM(msg)/="eof") THEN
		WRITE(*,*) "Wrong in Reading [control file]"
		CALL EXIT
	END IF
	
	! Load basic data and speed up for next time
	CALL LoadFileHead(TRIM(gBasicFolder) // "DEM", gBasicFormat)
	ALLOCATE(gDEM(1:nCols, 1:nRows), gDDM(1:nCols, 1:nRows), gFAM(1:nCols, 1:nRows))
	CALL LoadFile(TRIM(gBasicFolder) // "DEM", gDEM, gBasicFormat)
		Filename = TRIM(gBasicFolder) // "DEM.bif"
		INQUIRE(file=TRIM(Filename), exist=fExist)
		IF (.not. fExist) CALL Savebif(TRIM(Filename), gDEM, nCols, nRows, xLlCor, yLlCor, ceSize, noData)

    CALL LoadFile(TRIM(gBasicFolder) // "DDM", gDDM, gBasicFormat)
		Filename = TRIM(gBasicFolder) // "DDM.bif"
		INQUIRE(file=TRIM(Filename), exist=fExist)
		IF (.not. fExist) CALL Savebif(TRIM(Filename), gDDM, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
    CALL LoadFile(TRIM(gBasicFolder) // "FAM", gFAM, gBasicFormat)
		Filename = TRIM(gBasicFolder) // "FAM.bif"
		INQUIRE(file=TRIM(Filename), exist=fExist)
		IF (.not. fExist) CALL Savebif(TRIM(Filename), gFAM, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
	
	! Find Location
	if (gExitColRow) Then
		Do I=1, gExitNum
			ExitLong(I) = (gExitCol(I) - 0.5) * ceSize + xLlCor
			ExitLati(I) = yLlCor + nRows * ceSize - (gExitRow(I) - 0.5) * ceSize
		End Do
	Else
		Do I=1, gExitNum
			gExitCol(I) = (ExitLong(I) - xLlCor) / ceSize + 1
			gExitRow(I) = (yLlCor + nRows * ceSize - ExitLati(I)) / ceSize + 1
		End Do
	END IF
	Do I=1, gExitNum
		if (1<=gEXitCol(I) .and. gEXitCol(i)<=nCols .and. 1<=gExitRow(I) .and. gExitRow(I) <=nRows) Then
			Write(*,*) trim(gExitname(I)), gExitCol(I), gExitRow(I), ExitLong(I), ExitLati(I), gFAM(gExitCol(I), gEXitRow(I))
		Else
			Write(*,*) trim(gExitname(I)), " Out of Region"
		End if
	End Do

	! Reduce Region
	ALLOCATE(MASK(1:nCols, 1:nRows))
	Mask=noData
	IF (gExitNum>=1 .and. gClipByExit) THEN
		CALL ClipByEXIT(Mask, gExitCol(1), gExitRow(1))

		TotalArea=0
		LenSN = ceSize * 110.574
		DO lR=1, nRows
			DO lC=1, nCols
				IF (Mask(lC,lR)==noData) THEN
					gDEM(lC,lR)=nodata
					gDDM(lC,lR)=nodata
					gFAM(lC,lR)=nodata
				Else
					LenEW = yllCor + (nRows - lR + 0.5) * ceSize
					LenEW = LenSN * Cos(LenEW / 180 * 3.1415926)
					TotalArea = TotalArea + LenSN * LenEW
				END IF
			END DO
		END DO
		Filename=TRIM(gExportFolder) // TRIM(gProject) // ".clip." //  TRIM(gExitName(1)) // ".txt"
		CALL SaveAscii(TRIM(Filename), Mask, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
		Write(*,*) trim(gExitname(1)), TotalArea, "km^2"
	END IF

	! Load Level message
	If (gLevelNum>0) Then
		Allocate(gLevel(1:gLevelNum, 1:nCols, 1:nRows))
		gLevel=noData
		DO I=1, gLevelNum
			msg=PosIntMsg(gLevelMark(I))
			Filename=TRIM(gBasicFolder) // "Level." // trim(msg)
			Call LoadFile(Filename, Mask, gBasicFormat)
			Do lR=1, nRows
				Do lC=1, nCols
					gLevel(I, lC, lR)=Mask(lc, lR)
				End Do
			END DO

			Filename = TRIM(gBasicFolder) // "Level." // trim(msg) // ".bif"
			INQUIRE(file=TRIM(Filename), exist=fExist)
			IF (.not. fExist) CALL Savebif(TRIM(Filename), Mask, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
		END DO
	END IF

	! Main process
	ALLOCATE(pOneW(1:nCols, 1:nRows),   pOneSto(1:nCols, 1:nRows), pTwoSto(1:nCols, 1:nRows), pFc(1:nCols, 1:nRows))
    ALLOCATE(pWmax(1:nCols, 1:nRows),   pIM(1:nCols, 1:nRows),     pKE(1:nCols, 1:nRows),     pB(1:nCols, 1:nRows))
    ALLOCATE(pCoeM(1:nCols, 1:nRows),   pExpM(1:nCols, 1:nRows),   pCoeR(1:nCols, 1:nRows),   pCoeS(1:nCols, 1:nRows))
    ALLOCATE(PLeaOne(1:nCols, 1:nRows), PLeaTwo(1:nCols, 1:nRows), pTh(1:nCols, 1:nRows),     pGm(1:nCols, 1:nRows))
	SELECT CASE (gRunStyle)
	CASE ("simu")
		CALL Simulate
	CASE ("cali")
		CALL Calibrate
	CASE ("line")
		CALL OnLineRun
	CASE ("repe")
		CALL ReturnPeriod
	END SELECT
	WRITE(*,*) CREST_VERSION // " Finished"
END


subroutine ReturnPeriod()
	USE RunCon
	IMPLICIT NONE
	
	Integer(4):: lY, lYmin, lYmax, D(1:6), DEnd(1:6), lR, lC, I
	Real(4),allocatable:: Q(:,:,:), V(:,:)
	Character(80):: Filename, strD
	Logical:: fExist
	Real(4):: temV
	
	If (gDatBegin(2)<=4) Then
		lYmin=gDatBegin(1)
	Else
		lYmin=gDatBegin(1)+1
	End if
	If (gDatEnd(2)>=9) Then
		lYmax=gDatEnd(1)
	Else
		lYmax=gDatEnd(1)-1
	End if

	allocate(Q(lYmin:lYmax, 1:nCols, 1:nRows), V(1:nCols, 1:nRows))
	DO lY=lYmin, lYmax
		DO lR=1, nRows
			DO lC=1, nCols
				Q(lY, lC, lR)=noData
			END DO
		END DO
	END DO

	DO lY=lYmin, lYmax
		D(1)=lY
		D(2)=1
		D(3)=1
		D(4)=0
		D(5)=0
		D(6)=0
		DEnd=D
		DEnd(1)=lY+1
		
		DO While (myDcompare(D, DEnd)==1)
			strD=myDtoStr(D, gTimeMark)
			Write(*,*) "Load " // trim(strD)

			Filename=trim(gExportFolder) // trim(gProject) // "." // trim(strD) // ".Runoff"
			Select Case (gExportFormat)
			Case ("ascfit")
				 INQUIRE(file=TRIM(Filename) // ".txt", exist=fExist)
			Case ("biffit")
				INQUIRE(file=TRIM(Filename) // ".bif", exist=fExist)
			End Select
			
			IF (fExist) Then
				Call LoadFile(Filename, V, gExportFormat)
				DO lR=1, nRows
					DO lC=1, nCols
						IF (Q(lY,lC,lR) < V(lC,lR)) Q(lY,lC,lR) = V(lC,lR)
					END DO
				END DO
			END IF
			Call myDadd(gTimeMark, gTimeStep, D)
		End DO
	End DO
	
	Write(*,*) "Sort"
	DO lR=1, nRows
		DO lC=1, nCols
			DO lY=lYmin, lYmax-1
				Do I=lY+1, lYmax
					If (Q(lY, lC, lR)<Q(I, lC, lR)) THEN
						temV=Q(lY, lC, lR)
						Q(lY, lC, lR)=Q(I, lC, lR)
						Q(I, lC, lR)=temV
					END IF
				END DO
			END DO
		END DO
	END DO
	
	DO lY=lYmin, lYmax
		I=lYmax-lY+1
		Write (*,*) "Export ", I
		DO lR=1, nRows
			DO lC=1, nCols	
				V(lc,lR)=Q(lY, lC, lR)
			END DO
		END DO	
		strD=PosIntMsg(I)
		Filename=trim(gBasicFolder) // "Level." // trim(strD)
		Call SaveFile(Filename, V, gBasicFormat)
	END DO
end subroutine


SUBROUTINE Simulate() 
	USE RunCon
	IMPLICIT NONE
	REAL(4), ALLOCATABLE:: RegMean(:,:), Qobs(:), Qsim(:)
	CHARACTER(14):: strD
	INTEGER(4):: lTmax, DX(1:6), lT
	Real(4):: NSCE, Bias

	CALL Para2D
	lTmax = myDdIFf(gTimeMark, gDatBegin, gDatEND) / gTimeStep + 1
	ALLOCATE(RegMean(1:gExitNum+8, 1:lTmax), Qobs(1:lTmax), Qsim(1:lTmax))
	CALL LoadColumn(gQobsFile, gDatBegin, gDatWarm, lTmax, gTimeMark, gTimeStep, Qobs)
	CALL CREST (RegMean, lTmax, .TRUE.)
	
	DO lT=1, lTmax
		Qsim(lT)=RegMean(9, lT)
	END DO
	CALL StatNSCEBias(Qobs, Qsim, lTmax, NSCE, Bias)
	Write(*,*) NSCE, Bias

	CALL myNow(DX)
	strD=myDtoStr(DX,"s")
	CALL SaveRegionMean (RegMean,  Qobs, gDatBegin, lTmax, TRIM(gExportFolder) // TRIM(gProject) // ".Simu." // TRIM(strD) // '.txt')
END SUBROUTINE


SUBROUTINE OnLineRun()
	USE RunCon
	IMPLICIT NONE
	
	INTEGER(4):: I, lTmax, lT
	REAL(4), ALLOCATABLE:: RegMeanOld(:,:), QobsOld(:), RegMean(:,:), Qobs(:)
	REAL(4):: temV
	INTEGER(4):: D(1:6), DX(1:6), SouDatBegin(1:6), SouDatEND(1:6)
	CHARACTER(80):: msg, Filename
	CHARACTER(14):: strD
	LOGICAL:: fExist
    
	! get current time based on time step, add 24 hours for dIFferent time zone
	CALL myNow(DX)
	D=DX
	SELECT CASE (gTimeMark)
	CASE ("y","Y");	I=1
	CASE ("m","M");	I=2
	CASE ("d","D");	I=3
	CASE ("h","H");	I=4
	CASE ("u","U");	I=5
	CASE ("s","S");	I=6
	END SELECT
	DO lT=I, 6
		D(lT)=0
	END DO
	DO WHILE (D(I)<DX(I))
		D(I)=D(I)+gTimeStep
	END DO
	D(I)=D(I)-gTimeStep
	SouDatEND  =gDatEND
	IF (myDcompare(D, gDatEND)==-1) gDatEND=D

	! get END data of rain file
	fExist=.False.
	DO WHILE (.NOT. fExist)
		strD=myDtoStr(gDatEND, gTimeMark)
		SELECT CASE (gRainFormat)
		CASE ("trmmrt")
			Filename = TRIM(gRainFolder) // "3B42RT." // TRIM(strD) // ".bin"
			INQUIRE(File=TRIM(Filename), Exist=fExist)
			IF (.not. fExist) THEN
				Filename = TRIM(gRainFolder) // "3B42RT." // TRIM(strD) // ".6.bin"
				INQUIRE(File=TRIM(Filename), Exist=fExist)
				IF (.Not. fExist) THEN
					Filename = TRIM(gRainFolder) // "3B42RT." // TRIM(strD) // ".6A.bin"
					INQUIRE(File=TRIM(Filename), Exist=fExist)
				END IF
			END IF
		CASE ("biffit")
			Filename = TRIM(gRainFolder) // TRIM(strD) // ".bif"
			INQUIRE(File=TRIM(Filename), Exist=fExist)
        END SELECT
		IF (myDequal(gDatbegin, gDatEND)) THEN
			fEXist=.TRUE.
		ELSE
			IF (.NOT. fEXist) CALL myDadd(gTimeMark, -gTimeStep, gDatEND)
		END IF
	END DO

	! get date of last status
	SouDatBegin=gDatBegin
	gDatBegin=gDatEND
	CALL myDadd(gTimeMark, gTimeStep, gDatBegin)
	fExist=.False.
	DO WHILE (.NOT. fEXist)
		strD=myDtoStr(gDatBegin, gTimeMark)
		Filename=TRIM(gExportFolder) // TRIM(gProject) // ".Status." // TRIM(strD) // ".OneW.bif"
		INQUIRE(file=TRIM(Filename), exist=fExist)
		IF (myDequal(gDatbegin, souDatBegin)) THEN
			fEXist=.TRUE.
		ELSE
			IF (.NOT. fEXist) CALL myDadd(gTimeMark,  -gTimeStep, gDatbegin)
		END IF
	END DO
	

	IF (myDcompare(gDatBegin,gDatEND)==1) THEN 
		! get old result including gauged discharge
		lTmax = myDdIFf(gTimeMark, souDatBegin, gDatBegin ) / gTimeStep
		ALLOCATE(RegMeanOld(1:gExitNum+8, 1:lTmax), QobsOld(1:lTmax))
		CALL LoadColumn(gQobsFile, souDatBegin, gDatWarm, lTmax, gTimeMark, gTimeStep, QobsOld)
		Filename=TRIM(gExportFolder) // TRIM(gProject) // ".Line.txt"
		INQUIRE(file=TRIM(Filename), exist=fExist)
		IF (fEXist) THEN
			OPEN(102, file=TRIM(Filename), form="formatted")
				READ(102,*) msg
				DO lT=1, lTmax
					READ(102,*) temV, (RegMeanOld(I,lT), I=1, gExitNum+8), temV
				END DO	
			CLOSE (102)
		END IF
		CALL SaveRegionMean(RegMeanOld, QobsOld,souDatBegin, lTmax, Filename)

		gStatusLoad=.True.
		gStatusSave=.True.
		
		CALL Para2D
		lTmax = myDdIFf(gTimeMark, gDatBegin, gDatEND)/ gTimeStep + 1
		ALLOCATE(RegMean(1:gExitNum+8, 1:lTmax), Qobs(1:lTmax))
		CALL LoadColumn(gQobsFile, gDatBegin, gDatBegin, lTmax, gTimeMark, gTimeStep, Qobs)
		CALL CREST (RegMean, lTmax, .TRUE.)
		
		OPEN(102, file=TRIM(Filename), form="formatted", Position="AppEND")
			D=gDatBegin
			DO lT = 1, lTmax
				WRITE(102,"(A14, $)") myDToStr(D, gTimeMark)
				DO I = 1, UBound(RegMean, 1)
					WRITE(102,"(F10.3, $)") RegMean(I, lT)
				END DO
				WRITE(102,"(F10.3)") Qobs(lT)
				CALL myDadd(gTimeMark, gTimeStep, D)
			END DO
		CLOSE (102)
	END IF
END SUBROUTINE


SUBROUTINE Calibrate() ! using Adaptive RanDOme Search method
	USE RunCon
	IMPLICIT NONE

	INTEGER(4):: I, lR, lC, N, J, lTmax, lT, Z
	INTEGER(4):: DX(1:6)
	CHARACTER(80):: msg, Filename, strD, saveParamName, saveParamNameTemp
	REAL(4):: NSCE, Bias
	INTEGER(4):: NumTotal, NumValid, fStat1(13), fStat2(13)
	REAL(4), ALLOCATABLE:: BestNSCE(:), BestBias(:), BestPar(:,:), Qsim(:), RegMean(:,:), Qobs(:)
	LOGICAL:: fExist, fExist2

	lTmax = myDdIFf(gTimeMark, gDatBegin, gDatEND) / gTimeStep + 1
	ALLOCATE(RegMean(1:gExitNum+8, 1:lTmax), Qobs(1:lTmax), Qsim(1:lTmax))
	CALL LoadColumn(gQobsFile, gDatBegin, gDatWarm, lTmax, gTimeMark, gTimeStep, Qobs)

	ALLOCATE(BestNSCE(gTopNum+2), BestBias(gTopNum+2), BestPar(gTopNum+2, 1:gParaNum))
	DO I=1, gTopNum +2 ! 12 11 洢½, 1  10 TOPNĽ
		BestNsce(I)=gMinNSCE
		BestBias(I)=gMaxBiasP
	END DO

	saveParamName = TRIM(gExportFolder) // "savedParams.cali"
	saveParamNameTemp = TRIM(gExportFolder) // "savedParams.cali.tmp"

	CALL myNow(DX)
	strD=myDtoStr(DX, "s")
	Filename = TRIM(gExportFolder) // TRIM(gProject)  // ".Cali." // TRIM(strD)
	OPEN(102, file=TRIM(Filename) // ".txt", form="formatted")
		WRITE(102,"(A12,$)") "NSCE", "Bias"
		DO I=1, gParaNum
			WRITE(102,"(A12,$)") TRIM(gParaName(I))
		END DO
		WRITE(102,"(2A12)") "Index", "Run Num"
	CLOSE(102)

	gStatusSave=.False.
	DO I=1, 9
		gExport2D(I)=.FALSE.
	END DO
	NumTotal=0
	NumValid=0
	CALL ranDOm_seed()

	INQUIRE(file=TRIM(saveParamName), exist=fExist)
	INQUIRE(file=TRIM(saveParamNameTemp), exist=fExist2)
	IF (fExist2 .AND. fExist) THEN
		CALL STAT(TRIM(saveParamName), fStat1)
		CALL STAT(TRIM(saveParamNameTemp), fStat2)
		IF (fStat2(8) .GE. fStat1(8)) THEN
			CALL UNLINK(saveParamName)
			CALL RENAME(saveParamNameTemp, saveParamName)
		END IF
	ELSE IF ((fExist2) .AND. (.NOT. fExist)) THEN
		CALL RENAME(saveParamNameTemp, saveParamName)
		INQUIRE(file=TRIM(saveParamName), exist=fExist) 
	END IF 
        IF (fExist) THEN                                                                                                                                                       
                WRITE(*,*) "Loading saved calibration file: " // TRIM(saveParamName)                                                                                           
                OPEN (102, file=TRIM(saveParamName), access='direct', form='unformatted', recl=4)                                                                              
                Z=1                                                                                                                                                            
                DO I=1, gTopNum +2                                                                                                                                             
                        READ(102, rec=Z) BestNsce(I)                                                                                                                           
                        Z=Z+1                                                                                                                                                  
                        READ(102, rec=Z) BestBias(I)                                                                                                                           
                        Z=Z+1                                                                                                                                                  
                        DO N=1, gParaNum                                                                                                                                       
                                READ(102, rec=Z) BestPar(I, N)                                                                                                                 
                                Z=Z+1                                                                                                                                          
                        END DO                                                                                                                                                 
                END DO                                                                                                                                                         
                DO N=1, gParaNum                                                                                                                                               
                        READ(102, rec=Z) gParaMin(N)                                                                                                                           
                        Z=Z+1                                                                                                                                                  
                        READ(102, rec=Z) gParaMax(N)                                                                                                                           
                        Z=Z+1                                                                                                                                                  
                END DO                                                                                                                                                         
                READ(102, rec=Z) NumValid                                                                                                                                      
                Z=Z+1                                                                                                                                                          
                READ(102, rec=Z) NumToTal                                                                                                                                      
                Z=Z+1                                                                                                                                                          
                CLOSE (102)                                                                                                                                                    
        END IF 

	DO
		DO I=1, gParaNum
			IF (gParaRenew(I)) THEN
				CALL ranDOm_number (gParaValue(I)) 
				gParaValue(i)=gParaMin(i)+(gParaMax(i)-gParaMin(i))*gParaValue(i)
			END IF
		END DO

		CALL Para2D
		CALL CREST (RegMean, lTmax, .FALSE.)

		DO I=1, lTmax
			Qsim(I)=RegMean(9, I)
		END DO
		CALL StatNSCEBias(Qobs, Qsim, lTmax, NSCE, Bias)
		
		CALL myNow(DX)
		strD=myDtoStr(DX, "s")
		NumTotal=NumTotal+1
		IF (Abs(Bias)<gMaxBiasP .and. NSCE>gMinNSCE) THEN
			! ϸĲ
			NumValid=NumValid+1
			OPEN(102, file=TRIM(Filename)  // ".txt", form="formatted", Position="AppEND")
				WRITE(102,"(F12.6,$)") NSCE, Bias
				DO I=1, gParaNum
					WRITE(102,"(F12.6,$)") gParaValue(I)
				END DO
				WRITE(102,*) NumValid, NumTotal
			CLOSE(102)
			If (Numvalid<10) Then
				WRITE(msg,"(I1)") numvalid
			Elseif (Numvalid<100) Then
				WRITE(msg,"(I2)") numvalid
			Elseif (Numvalid<1000) Then
				WRITE(msg,"(I3)") numvalid
			Elseif (Numvalid<10000) Then
				WRITE(msg,"(I4)") numvalid
			Else
				WRITE(msg,"(I5)") numvalid
			End if
			IF (NSCE > BestNSCE(1)) CALL SaveRegionMean (RegMean,  Qobs, gDatBegin, lTmax, TRIM(Filename) // "." // TRIM(msg) // ".txt") ! 
							
			! ֵ
			BestNSCE(gTopNum+1)=NSCE
			BestBias(gTopNum+1)=Bias
			DO I=1, gParaNum
				BestPar(gTopNum+1,I)=gParaValue(I)
			END DO
			
			! 
			DO I=1, gTopNum
				DO J=I+1, gTopNum+1
					IF (BestNSCE(I)<BestNSCE(J)) THEN
						BestNSCE(gTopNum+2)=BestNSCE(I)
						BestNSCE(I)=BestNSCE(J)
						BestNSCE(J)=BestNSCE(gTopNum+2)
						
						BestBias(gTopNum+2)=BestBias(I)
						BestBias(I)=BestBias(J)
						BestBias(J)=BestBias(gTopNum+2)
						
						DO N=1, gParaNum
							BestPar(gTopNum+2,N)=BestPar(I,N)
							BestPar(I,N)=BestPar(J,N)
							BestPar(J,N)=BestPar(gTopNum+2,N)
						END DO
					END IF
				END DO
			END DO
					
			IF (NumValid>gBaseNum) THEN
				! Χ
				DO N=1, gParaNum
					gParaMin(N)=BestPar(1, N)
					gParaMax(N)=BestPar(1, N)
					DO I=2, gTopNum
						IF (gParaMin(N)>BestPar(I, N)) gParaMin(N)=BestPar(I, N)
						IF (gParaMax(N)<BestPar(I, N)) gParaMax(N)=BestPar(I, N)
					END DO
				END DO

				! ˳
				IF (abs(BestNSCE(1)-BestNSCE(gTopNum))<=gErrLimit) THEN 
					OPEN(102, file=TRIM(Filename)  // ".txt", form="formatted", Position="AppEND")
						WRITE(102,*) " Final Result"
						DO I=1, gTopNum, 1
							WRITE(102,"(2F12.6,$)") BestNSCE(I), BestBias(I)
							DO N=1, gParaNum
								WRITE(102,"(F12.6,$)") BestPar(I,N)
							END DO
							WRITE(102,"(I10)") I
						END DO
					CLOSE(102)
					EXIT
				END IF
			END IF

			WRITE(*,"(A12,2I10,F10.6,F10.4, F10.6)") TRIM(strD), NumToTal, NumValid, BestNSCE(1), BestBias(1), BestNSCE(1)-BestNSCE(gTopNum)
		ELSE
			WRITE(*,"(A12,I10)") TRIM(strD), NumToTal
		END IF
		OPEN(102, file=TRIM(saveParamNameTemp), status="REPLACE", access='direct', form='unformatted', recl=4)
		Z=1
		DO I=1, gTopNum +2 
			WRITE(102, rec=Z) BestNsce(I) 
			Z=Z+1
			WRITE(102, rec=Z) BestBias(I)
			Z=Z+1
			DO N=1, gParaNum
				WRITE(102, rec=Z) BestPar(I, N)
				Z=Z+1
			END DO
		END DO
		DO N=1, gParaNum
			WRITE(102, rec=Z) gParaMin(N)
			Z=Z+1
			WRITE(102, rec=Z) gParaMax(N)
			Z=Z+1
		END DO 
		WRITE(102, rec=Z) NumValid
		Z=Z+1
		WRITE(102, rec=Z) NumToTal
		Z=Z+1
        	CLOSE (102)
		CALL UNLINK(saveParamName)
		CALL RENAME(saveParamNameTemp, saveParamName)
	END DO
END SUBROUTINE


! Kernal MODULE
SUBROUTINE CREST(RegMean, lTmax, ECHO)
	USE RunCon
	IMPLICIT NONE
	INTEGER(4):: lTmax
	REAL(4):: RegMean(1:gExitNum+8, 1:lTmax)
	LOGICAL:: ECHO

	INTEGER(4):: toR, toC, lT, I, N, lR, lC
	INTEGER(4), ALLOCATABLE:: NextR(:,:), OneRowA(:,:), OneColA(:,:), OneRowB(:,:), OneColB(:,:)
	INTEGER(4), ALLOCATABLE:: NextC(:,:), TwoRowA(:,:), TwoColA(:,:), TwoRowB(:,:), TwoColB(:,:)
	REAL(4), ALLOCATABLE:: NexTime(:,:), OnePerA(:,:), OnePerB(:,:), TwoPerA(:,:), TwoPerB(:,:)
	REAL(4), ALLOCATABLE:: Rain(:,:), PET(:,:), GridArea(:,:), actE(:,:)
    REAL(4), ALLOCATABLE:: Runoff(:,:), OneWOut(:,:)
    REAL(4), ALLOCATABLE:: OneExc(:,:), OneRou(:,:), TwoExc(:,:), TwoRou(:,:), Level(:,:)
	INTEGER(4):: D(1:6)
    CHARACTER(80):: Filename
	CHARACTER(14):: strD, msg
	LOGICAL:: fExist
	
	If (echo) write(*,*) "Kernal"
	! Ԥ
	ALLOCATE(NextR(0:nCols, 0:nRows), NextC(0:nCols, 0:nRows), NexTime(0:nCols, 0:nRows), GridArea(1:nCols, 1:nRows))
	CALL RoutePreTreat(NextR, NextC, NexTime, GridArea)

	ALLOCATE(OneRowA(1:nCols, 1:nRows), OneColA(1:nCols, 1:nRows), OnePerA(1:nCols, 1:nRows))
	ALLOCATE(OneRowB(1:nCols, 1:nRows), OneColB(1:nCols, 1:nRows), OnePerB(1:nCols, 1:nRows))
	CALL RouteTreat(NextR, NextC, NexTime, OneRowA, OneColA, OnePerA, OneRowB, OneColB, OnePerB)

	DO lR = 1, nRows
        DO lC = 1, nCols
            IF (gDEM(lC, lR) /= noData) NexTime(lC, lR) = NexTime(lC, lR) / pCoeS(lC, lR) 
        END DO
    END DO
	ALLOCATE(TwoRowA(1:nCols, 1:nRows), TwoColA(1:nCols, 1:nRows), TwoPerA(1:nCols, 1:nRows))
	ALLOCATE(TwoRowB(1:nCols, 1:nRows), TwoColB(1:nCols, 1:nRows), TwoPerB(1:nCols, 1:nRows))
    CALL RouteTreat(NextR, NextC, NexTime, TwoRowA, TwoColA, TwoPerA, TwoRowB, TwoColB, TwoPerB)
    
    ALLOCATE(actE(1:nCols, 1:nRows), Runoff(1:nCols, 1:nRows), OneWOut(1:nCols, 1:nRows))
	ALLOCATE(Rain(1:nCols, 1:nRows), PET(1:nCols, 1:nRows), Level(1:nCols, 1:nRows))
	ALLOCATE(OneExc(1:nCols, 1:nRows), OneRou(1:nCols, 1:nRows), TwoExc(1:nCols, 1:nRows), TwoRou(1:nCols, 1:nRows))
	DO I=1, ubound(RegMean,1)
		DO N=1, ubound(RegMean,2)
			RegMean(I,N)=0
		END DO
	END DO


	! ״ֵ̬ȡ
	IF (gStatusLoad) THEN
		strD = myDtoStr(gDatBegin, gTimeMark)
		Filename=TRIM(gExportFolder) // TRIM(gProject) // ".Status." // TRIM(strD) // ".OneW.bif"
		INQUIRE(file=TRIM(Filename), exist=fExist)
		IF (fExist) THEN
			CALL Loadbif(TRIM(Filename), pOneW, nCols, nRows)
			If (echo) WRITE(*,*) "Loading status file: " // TRIM(Filename)
		END IF
		
		Filename=TRIM(gExportFolder) // TRIM(gProject) // ".Status." // TRIM(strD) // ".OneSto.bif"
		INQUIRE(file=TRIM(Filename), exist=fExist)
		IF (fExist) THEN
			CALL Loadbif(TRIM(Filename), pOneSto, nCols, nRows)
			If (echo) WRITE(*,*) "Loading status file: " // TRIM(Filename)
		END IF

		Filename=TRIM(gExportFolder) // TRIM(gProject) // ".Status." // TRIM(strD) // ".TwoSto.bif"
		INQUIRE(file=TRIM(Filename), exist=fExist)
		IF (fExist) THEN
			CALL Loadbif(TRIM(Filename), pTwoSto, nCols, nRows)
			If (echo) WRITE(*,*) "Loading status file: " // TRIM(Filename)
		END IF
	END IF

	! temperal recycle
	D=gDatBegin
	DO lT=1, lTmax
		strD = myDtoStr(D, gTimeMark)
		IF (ECHO) WRITE (*,'(A,$)') TRIM(strD)
		
		! 뽵ˮ
		SELECT CASE (gRainFormat)
		CASE ("ascfit")
			Filename = TRIM(gRainFolder) // TRIM(strD) // ".txt"
			INQUIRE(file=TRIM(Filename), exist=fExist)
			IF (fExist) CALL LoadAsc(Filename, Rain, nCols, nRows)

		CASE ("ascbig")
			Filename = TRIM(gRainFolder) // TRIM(strD) // ".txt"
			INQUIRE(file=TRIM(Filename), exist=fExist)
			IF (fExist)  CALL LoadASCbyRegion(TRIM(Filename), Rain, nCols, nRows, xLlCor, yLlCor, ceSize, noData)

		CASE ("biffit")
			Filename = TRIM(gRainFolder) // TRIM(strD) // ".bif"
			INQUIRE(file=TRIM(Filename), exist=fExist)
			IF (fExist) CALL Loadbif(Filename, Rain, nCols, nRows)
			
		CASE ("nmqbin")
			Filename = TRIM(gRainFolder) // "1HRAD.HSR." // TRIM(strD(1:8)) // "." // TRIM(strD(9:10)) // "00"
			INQUIRE(file=TRIM(Filename), exist=fExist)
			IF (fExist)  CALL LoadNMQBinbyRegion(TRIM(Filename), Rain, nCols, nRows, xLlCor, yLlCor, ceSize, noData)

		CASE ("trmmrt")
			Filename = TRIM(gRainFolder) // "3B42RT." // strD(1:10) // ".6A.bin"
			INQUIRE(File=TRIM(Filename), Exist=fExist)
			IF (.not. fExist) THEN
				Filename = TRIM(gRainFolder) // "3B42RT." // strD(1:10) // ".6.bin"
				INQUIRE(File=TRIM(Filename), Exist=fExist)
				IF (.Not. fExist) THEN
					Filename = TRIM(gRainFolder) // "3B42RT." // strD(1:10) // ".bin"
					INQUIRE(File=TRIM(Filename), Exist=fExist)
				END IF
			END IF
			IF (fExist) CALL LoadRTByRegion(TRIM(Filename), Rain, nCols, nRows, xLlCor, yLlCor, ceSize, noData)

		Case ("trmmv6")
			If (D(4)<10) Then
				write(msg,"(I1)") D(4)
			Else
				write(msg,"(I2)") D(4)
			End if
			Filename = TRIM(gRainFolder) // "3B42." // strD(3:8) // "." // trim(msg) // ".6.HDF"
			INQUIRE(File=TRIM(Filename), Exist=fExist)
			IF (.not. fExist) THEN
				Filename = TRIM(gRainFolder) // "3B42." // strD(3:8) // "." // trim(msg) // ".6A.HDF"
				INQUIRE(File=TRIM(Filename), Exist=fExist)
			END IF
			IF (fExist) CALL LoadV6ByRegion(Filename, Rain, nCols, nRows, xLlCor, yLlCor, ceSize, noData)

        END SELECT
		IF (.not. fExist .and. ECHO) WRITE(*,'(A20, $)') "Rain File Missed"
		IF (gExport2D(1)) THEN 
			CALL SaveFile(TRIM(gExportFolder) // TRIM(gProject) // ".rain." // TRIM(strD), Rain, gExportFormat)
		END IF

		
		! 
		SELECT CASE (gPetFormat)
		CASE ("ascfit")
			Filename = TRIM(gPETFolder) // TRIM(strD) // ".txt"
			INQUIRE(file=TRIM(Filename), exist=fExist)
			IF (fExist) CALL LoadAsc(Filename, PET, nCols, nRows)

		CASE ("biffit")
			Filename = TRIM(gPETFolder) // TRIM(strD) // ".bif"
			INQUIRE(file=TRIM(Filename), exist=fExist)
			IF (fExist) CALL Loadbif(Filename, PET, nCols, nRows)

		CASE ("bibimo")
			Filename = TRIM(gPETFolder) // "PET025." // strD(5:6) // ".bif"
			INQUIRE(file=TRIM(Filename), exist=fExist)
			IF (fExist)  CALL LoadbifbyRegion(TRIM(Filename), PET, nCols, nRows, xLlCor, yLlCor, ceSize, noData)

		CASE ("asbimo")
			Filename = TRIM(gPETFolder) // "PET025." // strD(5:6) // ".txt"
			INQUIRE(file=TRIM(Filename), exist=fExist)
			IF (fExist)  CALL LoadASCbyRegion(TRIM(Filename), PET, nCols, nRows, xLlCor, yLlCor, ceSize, noData)

		END SELECT
		if (ECHO) Then
			if (fExist) Then
				WRITE(*,*) ""
			Else
				WRITE(*,'(A20)') "PET File Missed"
			End if
		End if
		IF (gExport2D(2)) THEN 
			CALL SaveFile(TRIM(gExportFolder) // TRIM(gProject) // ".pet." // TRIM(strD), PET, gExportFormat)
		END IF

		
		! 
        DO lR = 1, nRows
            DO lC = 1, nCols
                IF (gDEM(lC, lR) /= noData) THEN
                    IF (Rain(lC, lR) > 0) THEN
                        Rain(lC, lR) = Rain(lC, lR) * gTimeStep * gParaValue(17)
                    ELSE
                        Rain(lC, lR) = 0
                    END IF
                    
                    IF (PET(lC, lR) > 0) THEN
                        PET(lC, lR) = PET(lC, lR) * gTimeStep
                    ELSE
                        PET(lC, lR) = 0
                    END IF
                    
                    CALL ESOneTwoKey(pOneW(lC,lR), Rain(lC,lR), PET(lC,lR), &
							& pWmax(lC,lR), pKE(lC,lR), pIM(lC,lR), pB(lC,lR), pFc(lC,lR), OneWOut(lC,lR), &
							& OneExc(lC,lR), TwoExc(lC,lR), actE(lC,lR))

                    pOneW(lC, lR) = OneWOut(lC, lR)
                    
                    pOneSto(lC, lR) = pOneSto(lC, lR) + OneExc(lC, lR)
                    OneRou(lC, lR) = pOneSto(lC, lR) * PLeaOne(lC, lR)
                    pOneSto(lC, lR) = pOneSto(lC, lR) * (1 - PLeaOne(lC, lR))
                    
                    pTwoSto(lC, lR) = pTwoSto(lC, lR) + TwoExc(lC, lR)
                    TwoRou(lC, lR) = pTwoSto(lC, lR) * PLeaTwo(lC, lR)
                    pTwoSto(lC, lR) = pTwoSto(lC, lR) * (1 - PLeaTwo(lC, lR))
                    
                    Runoff(lC, lR) = (OneRou(lC, lR) + TwoRou(lC, lR)) / gTimeStep * GridArea(lC, lR) / 3.6
				ELSE
					actE(lC, lR)=0
					Runoff(lC, lR)=0
					pOneW(lC, lR)=0
					OneExc(lC, lR)=0
					TwoExc(lC, lR)=0
					pOneSto(lC, lR)=0
					pTwoSto(lC, lR)=0
                END IF
            END DO
        END DO
        
        DO lR = 1, nRows
            DO lC = 1, nCols
                IF (gDEM(lC, lR) /= noData) THEN
                    toR = OneRowA(lC, lR)
                    toC = OneColA(lC, lR)
                    IF (toR > 0 .And. toC > 0) pOneSto(toC, toR) = pOneSto(toC, toR) + OneRou(lC, lR) * OnePerA(lC, lR) * GridArea(lC, lR) / GridArea(toC, toR)
                    toR = OneRowB(lC, lR)
                    toC = OneColB(lC, lR)
                    IF (toR > 0 .And. toC > 0) pOneSto(toC, toR) = pOneSto(toC, toR) + OneRou(lC, lR) * OnePerB(lC, lR) * GridArea(lC, lR) / GridArea(toC, toR)
                    
                    toR = TwoRowA(lC, lR)
                    toC = TwoColA(lC, lR)
                    IF (toR > 0 .And. toC > 0) pTwoSto(toC, toR) = pTwoSto(toC, toR) + TwoRou(lC, lR) * TwoPerA(lC, lR) * GridArea(lC, lR) / GridArea(toC, toR)
                    toR = TwoRowB(lC, lR)
                    toC = TwoColB(lC, lR)
                    IF (toR > 0 .And. toC > 0) pTwoSto(toC, toR) = pTwoSto(toC, toR) + TwoRou(lC, lR) * TwoPerB(lC, lR) * GridArea(lC, lR) / GridArea(toC, toR)
                END IF
            END DO
        END DO
        
        N = 0
        
        DO lR = 1, nRows
            DO lC = 1, nCols
                IF (gDEM(lC, lR) /= noData) THEN
                    N = N + 1
                    RegMean(1, lT) = RegMean(1, lT) + Rain(lC, lR) / gTimeStep
                    RegMean(2, lT) = RegMean(2, lT) + PET(lC, lR) / gTimeStep
                    RegMean(3, lT) = RegMean(3, lT) + actE(lC, lR) / gTimeStep
                    RegMean(4, lT) = RegMean(4, lT) + pOneW(lC, lR)
                    RegMean(5, lT) = RegMean(5, lT) + OneExc(lC, lR) / gTimeStep
                    RegMean(6, lT) = RegMean(6, lT) + TwoExc(lC, lR) / gTimeStep
                    RegMean(7, lT) = RegMean(7, lT) + pOneSto(lC, lR) / gTimeStep
                    RegMean(8, lT) = RegMean(8, lT) + pTwoSto(lC, lR) / gTimeStep
                    
                    DO I = 1, gExitNum
						IF (1<=gExitCol(I) .and. gExitCol(I) <=nCols .and. 1<= gExitRow(I) .and. gExitRow(I)<=nRows) THEN
							RegMean(8 + I, lT) = Runoff(gExitCol(I), gExitRow(I))
						ELSE
							RegMean(8 + I, lT) = noData
						END IF
                    END DO

					! Ϊһ㱣ֵ
					IF (Rain(lC, lR) > 0) Rain(lC, lR) = Rain(lC, lR) / gTimeStep
                    IF (PET(lC, lR) > 0)  PET(lC, lR) = PET(lC, lR) / gTimeStep
                END IF
            END DO
        END DO
        DO I = 1, 8
            RegMean(I, lT) = RegMean(I, lT) / N
        END DO
		
		! ά
		Filename=TRIM(gExportFolder) // TRIM(gProject) // "." // TRIM(strD)
        IF (gExport2D(3)) CALL SaveFile(TRIM(Filename) // ".actE", actE, gExportFormat)
        IF (gExport2D(4)) CALL SaveFile(TRIM(Filename) // ".Runoff", Runoff, gExportFormat)
        IF (gExport2D(5)) CALL SaveFile(TRIM(Filename) // ".OneW", pOneW, gExportFormat)
        IF (gExport2D(6)) CALL SaveFile(TRIM(Filename) // ".OneExc", OneExc, gExportFormat)
        IF (gExport2D(7)) CALL SaveFile(TRIM(Filename) // ".TwoExc", TwoExc, gExportFormat)
        IF (gExport2D(8)) CALL SaveFile(TRIM(Filename) // ".OneSto", pOneSto, gExportFormat)
        IF (gExport2D(9)) CALL SaveFile(TRIM(Filename) // ".TwoSto", pTwoSto, gExportFormat)

		IF (gLevelNum>0) THEN ! ּϢ
			actE=noData
			DO I=1, gLevelNum
				Do lR=1, nRows
					Do lC=1, nCols
						If (Runoff(lc,lR)/=noData .and. gLevel(I,lC,lR)/=noData .and. Runoff(lc,lR)>=gLevel(I,lC,lR)) actE(lc,lr)=gLevelMark(I)
					END DO
				END DO
			END DO
			CALL SaveFile(TRIM(Filename) // ".Level", actE, gExportFormat)
		END IF		

		CALL myDadd(gTimeMark, gTimeStep, D)
    END DO
    
	! ״ֵ̬
	IF (gStatusSave) THEN
		strD = myDtoStr(D, gTimeMark)
		CALL Savebif(TRIM(gExportFolder) // TRIM(gProject) // ".Status." // TRIM(strD) // ".OneW.bif", pOneW, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
		CALL Savebif(TRIM(gExportFolder) // TRIM(gProject) // ".Status." // TRIM(strD) // ".OneSto.bif", pOneSto, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
		CALL Savebif(TRIM(gExportFolder) // TRIM(gProject) // ".Status." // TRIM(strD) // ".TwoSto.bif", pTwoSto, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
	END IF
END SUBROUTINE


SUBROUTINE RouteTreat(NextR, NextC, NexTime, toRowA, toColA, toPerA, toRowB, toColB, toPerB)
	USE RunCon
	IMPLICIT NONE
	
	INTEGER(4):: NextR(0:nCols, 0:nRows), NextC(0:nCols, 0:nRows)
	INTEGER(4):: toRowA(1:nCols, 1:nRows), toColA(1:nCols, 1:nRows), toRowB(1:nCols, 1:nRows), toColB(1:nCols, 1:nRows)
	REAL(4):: NexTime(0:nCols, 0:nRows), toPerA(1:nCols, 1:nRows), toPerB(1:nCols, 1:nRows)
	INTEGER(4):: lR, lC
    
    DO lR = 1, nRows
        DO lC = 1, nCols
            IF (gDEM(lC, lR) /= noData) THEN
                toRowB(lC, lR) = lR
                toColB(lC, lR) = lC
                toPerB(lC, lR) = 0
                DO WHILE (toPerB(lC, lR) < gTimeStep)
                    toRowA(lC, lR) = toRowB(lC, lR)
                    toColA(lC, lR) = toColB(lC, lR)
                    toPerA(lC, lR) = toPerB(lC, lR)

                    toRowB(lC, lR) = NextR(toColA(lC, lR), toRowA(lC, lR))
                    toColB(lC, lR) = NextC(toColA(lC, lR), toRowA(lC, lR))
                    toPerB(lC, lR) = toPerB(lC, lR) + NexTime(toColA(lC, lR), toRowA(lC, lR))
                END DO
                toPerB(lC, lR) = (gTimeStep - toPerA(lC, lR)) / (toPerB(lC, lR) - toPerA(lC, lR))
                toPerA(lC, lR) = 1 - toPerB(lC, lR)
            END IF
        END DO
    END DO
END SUBROUTINE


SUBROUTINE RoutePreTreat(NextR, NextC, NexTime, GridArea)
	USE RunCon
	IMPLICIT NONE
	INTEGER(4):: NextR(0:nCols, 0:nRows), NextC(0:nCols, 0:nRows)
	REAL(4):: NexTime(0:nCols, 0:nRows), GridArea(1:nCols, 1:nRows)
	REAL(4), ALLOCATABLE:: Slope(:,:), NextLen(:,:), Speed(:,:)
	REAL(4):: LenSN, LenEW, LenCross, SpeedVegLocal, SpeedVegNext
	INTEGER(1):: Special
	INTEGER(4):: lR, lC
    
    ALLOCATE(Slope(1:nCols, 1:nRows), NextLen(1:nCols, 1:nRows), Speed(1:nCols, 1:nRows))
    
    LenSN = ceSize * 110574
    DO lR = 1, nRows
        DO lC = 1, nCols
            IF (gDEM(lC, lR) /= noData) THEN
                LenEW = yllCor + (nRows - lR + 0.5) * ceSize
                LenEW = LenSN * Cos(LenEW / 180 * 3.1415926)
                LenCross = Sqrt((LenEW ** 2 + LenSN ** 2))
                GridArea(lC, lR) = LenSN * LenEW / 1000000
				If (gParaName(gParaNum)=="AreaC") GridArea(lC, lR)=GridArea(lC, lR)*gParaValue(gParaNum)
                
                Special = 1
                SELECT CASE (INT(gDDM(lC, lR)))
                CASE (1)
                    NextR(lC, lR) = lR - 1;  NextC(lC, lR) = lC;       NextLen(lC, lR) = LenSN
                CASE (2)
                    NextR(lC, lR) = lR - 1;  NextC(lC, lR) = lC + 1;   NextLen(lC, lR) = LenCross
                CASE (3)
                    NextR(lC, lR) = lR;      NextC(lC, lR) = lC + 1;   NextLen(lC, lR) = LenEW
                CASE (4)
                    NextR(lC, lR) = lR + 1;  NextC(lC, lR) = lC + 1;   NextLen(lC, lR) = LenCross
                CASE (5)
                    NextR(lC, lR) = lR + 1;  NextC(lC, lR) = lC;       NextLen(lC, lR) = LenSN
                CASE (6)
                    NextR(lC, lR) = lR + 1;  NextC(lC, lR) = lC - 1;   NextLen(lC, lR) = LenCross
                CASE (7)
                    NextR(lC, lR) = lR;      NextC(lC, lR) = lC - 1;   NextLen(lC, lR) = LenEW
                CASE (8)
                    NextR(lC, lR) = lR - 1;  NextC(lC, lR) = lC - 1;   NextLen(lC, lR) = LenCross
                CASE default ! ڵ
                    Special = 0
                    NextR(lC, lR) = 0;       NextC(lC, lR) = 0;        NextLen(lC, lR) = LenSN ! ȫˮѻ00㣬õ㲻
                END SELECT
                        
                IF (NextR(lC, lR) < 1 .Or. nRows < NextR(lC, lR) .Or. NextC(lC, lR) < 1 .Or. nCols < NextC(lC, lR)) THEN
                    Special = 0
                    NextR(lC, lR) = 0;       NextC(lC, lR) = 0;        NextLen(lC, lR) = LenSN
                ELSE
                    IF (gDEM(NextC(lC, lR), NextR(lC, lR)) == noData) THEN
                        Special = 0
                        NextR(lC, lR) = 0;   NextC(lC, lR) = 0;        NextLen(lC, lR) = LenSN
                    END IF
                END IF

                SpeedVegLocal = 0.5 !˴ԿֲٵӰ
                IF (Special == 0) THEN
                    SpeedVegNext = SpeedVegLocal
                    Slope(lC, lR) = pGm(lC, lR) / NextLen(lC, lR)
                ELSE
                    SpeedVegNext = 0.5
                    IF (gDEM(lC, lR) > gDEM(NextC(lC, lR), NextR(lC, lR))) THEN
                        Slope(lC, lR) = (gDEM(lC, lR) - gDEM(NextC(lC, lR), NextR(lC, lR))) / NextLen(lC, lR)
                    ELSE
                        Slope(lC, lR) = pGm(lC, lR) / NextLen(lC, lR)
                    END IF
                END IF
        
                Speed(lC, lR) = pCoeM(lC, lR) * (SpeedVegLocal + SpeedVegNext) / 2 * (Slope(lC, lR)) ** pExpM(lC, lR)
                IF (gFAM(lC, lR) > pTh(lC, lR)) Speed(lC, lR) = Speed(lC, lR) * pCoeR(lC, lR)
                NexTime(lC, lR) = NextLen(lC, lR) / Speed(lC, lR) / 3600 ! Unit= meter/second
            END IF
        END DO
    END DO
    NexTime(0, 0) = 9999
END SUBROUTINE


SUBROUTINE ESOneTwoKey(pOneW, Rain, PET, pWmax, pKE, pIM, pB, pFc, Wo, RS, RG, actE)
    REAL(4), INTent(in):: pOneW, Rain, PET, pWmax, pKE, pIM, pB, pFc
	REAL(4), INTent(out) :: Wo, RS, RG, actE
	REAL(4) :: Ex, Wmaxm, A, R, Psoil, temX
    
    EX = PET * pKE
    IF (Rain > EX) THEN
        Psoil = (Rain - EX) * (1 - pIM) ! Calculate part of precip that goes into soil
        IF (pOneW < pWmax) THEN
            Wmaxm = pWmax * (1 + pB) 
            A = Wmaxm * (1 - (1 - pOneW / pWmax) ** (1 / (1 + pB)))
            IF (Psoil + A >= Wmaxm) THEN
                R = Psoil - (pWmax - pOneW)
                Wo = pWmax
            ELSE
                R = Psoil - pWmax * ((1 - A / Wmaxm) ** (1 + pB) - (1 - (A + Psoil) / Wmaxm) ** (1 + pB))
                IF (R < 0) R = 0
                Wo = pOneW + Psoil - R
            END IF
        ELSE
            R = Psoil
        END IF
        temX = (pOneW + Wo) / pWmax / 2 * pFc !Calculate how much water can infiltrate
		IF (R<=temX) THEN
			RG=R
		ELSE
			RG=temX
		END IF
        RS = R - RG + (Rain - EX) * pIM
        actE = EX
    ELSE
        RG = 0
        RS = 0
        temX = (EX - Rain) * pOneW / pWmax
        IF (temX < pOneW) THEN
            Wo = pOneW - temX
        ELSE
            Wo = 0
        END IF
        actE = pOneW - Wo
    END IF
END SUBROUTINE


SUBROUTINE StatNSCEBias(X, Y, upL, NSCE, Bias)
	Use RunCon
	IMPLICIT NONE
	INTEGER(4):: upL
	REAL(4):: X(1:upL), Y(1:upL), NSCE, Bias

	REAL(4), ALLOCATABLE:: Vobs(:), Vsim(:)
	INTEGER(4):: I, L
	REAL(4):: VobsMean, VsimMean, Vobsacc, Vsimacc
	
	L=0
	DO i=1, upL
		IF (X(I)>0 .and. Y(I)>0) L=L+1
	END DO
	ALLOCATE(Vobs(1:L), Vsim(1:L))
	L=0
	DO i=1, upL
		IF (X(I)>0 .and. Y(I)>0) THEN
			L=L+1
			Vobs(L)=X(I)
			Vsim(L)=Y(I)
		END IF
	END DO
	
	VobsMean=0
	VsimMean=0
    DO I = 1, UBound(Vobs,1)
        VobsMean = VobsMean + Vobs(I)
        VsimMean = VsimMean + Vsim(I)
    END DO
    VobsMean = VobsMean / UBound(Vobs,1) 
    VsimMean = VsimMean / UBound(Vsim,1)
    Bias = (VsimMean / VobsMean - 1) * 100
	Vobsacc=0
	Vsimacc=0
    DO I = 1, UBound(Vobs,1)
        Vobsacc = Vobsacc + (Vobs(I) - VobsMean) ** 2
        Vsimacc = Vsimacc + (Vobs(I) - Vsim(I)) ** 2
    END DO
    NSCE = (Vobsacc - Vsimacc) / Vobsacc
END SUBROUTINE


! Save 2-D file in dIFferent format, work for ascfit, biffit
SUBROUTINE SaveFile(Filename, Vout, FileStyle)
	Use RunCon
	IMPLICIT NONE
	CHARACTER(*):: Filename
	CHARACTER(6):: FileStyle
	INTEGER(4):: lR, lC
	REAL(4):: Vout(1:nCols, 1:nRows)

	DO lR=1, nRows
		DO lC=1, nCols
			IF (gDEM(lC,lR)==noData) Vout(lC,lR)=noData
		END DO
	END DO
	
	SELECT CASE (FileStyle)
	CASE ("biffit")
		CALL Savebif(TRIM(Filename) // ".bif", Vout, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
	CASE ("ascfit")
		CALL SaveAscii(TRIM(Filename) // ".txt", Vout, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
	END SELECT
END SUBROUTINE

SUBROUTINE LoadFileHead(Filename, FileStyle)
	Use RunCon
	IMPLICIT NONE
	CHARACTER(*):: Filename
	CHARACTER(6):: FileStyle
	
	SELECT CASE (FileStyle)
	CASE ("biffit")
		CALL LoadbifHead(TRIM(Filename) // ".bif", nCols, nRows, xLlCor, yLlCor, ceSize, noData)
	CASE ("ascfit")
		CALL LoadAscHead(TRIM(Filename) // ".txt", nCols, nRows, xLlCor, yLlCor, ceSize, noData)
	END SELECT
END SUBROUTINE

SUBROUTINE LoadFile(Filename, Vout, FileStyle)
	Use RunCon
	IMPLICIT NONE
	CHARACTER(*):: Filename
	CHARACTER(6):: FileStyle
	REAL(4):: Vout(1:nCols, 1:nRows)
	
	SELECT CASE (FileStyle)
	CASE ("biffit")
		CALL Loadbif(TRIM(Filename) // ".bif", Vout, nCols, nRows)
	CASE ("ascfit")
		CALL LoadAsc(TRIM(Filename) // ".txt", Vout, nCols, nRows)
	END SELECT
END SUBROUTINE

! Work for ascfit, ascbig
SUBROUTINE LoadAscHead(Filename, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
	IMPLICIT NONE
	CHARACTER(*):: Filename
	INTEGER(4):: lC, lR, nCols, nRows
	REAL(4):: xLlCor, yLlCor, ceSize, noData
	CHARACTER(20):: buf
	
	OPEN(102,file=TRIM(Filename),form='formatted')
		READ(102,*) buf, nCols
		READ(102,*) buf, nRows
		READ(102,*) buf, xllCor
		READ(102,*) buf, yllCor
		READ(102,*) buf, ceSize
		READ(102,*) buf, noData
	CLOSE (102)
END SUBROUTINE


SUBROUTINE LoadAsc(Filename, Vout, nCols, nRows)
	IMPLICIT NONE
	CHARACTER(*):: Filename
	INTEGER(4):: lC, lR, nC, nR, nCols, nRows
	REAL(4):: Vout(1:nCols, 1:nRows), xLlCor, yLlCor, ceSize, noData
	CHARACTER(20):: buf
	
	OPEN(102,file=TRIM(Filename),form='formatted')
		READ(102,*) buf, nC
		READ(102,*) buf, nR
		READ(102,*) buf, xllCor
		READ(102,*) buf, yllCor
		READ(102,*) buf, ceSize
		READ(102,*) buf, noData
		DO lR=1, nRows
			READ(102,*) (Vout(lC,lR), lC=1, nCols)
		ENDDO
	CLOSE (102)
END SUBROUTINE


SUBROUTINE SaveAscii(Filename, Vout, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
	IMPLICIT NONE
	CHARACTER(*):: Filename
	INTEGER(4):: lC, lR, nCols, nRows
	REAL(4):: Vout(1:nCols, 1:nRows), xLlCor, yLlCor, ceSize, noData
	
	OPEN(102,file=TRIM(Filename),form='formatted')
		WRITE(102,"('ncols 		')",advance='no'); WRITE(102,"(i8)")nCols
		WRITE(102,"('nrows 		')",advance='no'); WRITE(102,"(i8)")nRows
		WRITE(102,"('xllCorner 	')",advance='no'); WRITE(102,"(f11.6)")xllCor
		WRITE(102,"('yllCorner 	')",advance='no'); WRITE(102,"(f11.6)")yLlCor
		WRITE(102,"('cellSize 	 ')",advance='no'); WRITE(102,"(f11.6)")ceSize
		WRITE(102,"('NODATA_value ')",advance='no'); WRITE(102,"(f11.0)")noData
		DO lR=1, nRows
			DO lC=1, nCols
				WRITE(102,'(f10.3,A)',advance='no')Vout(lC,lR),' '
			ENDDO
			WRITE(102,*)
		ENDDO
	CLOSE (102)
END SUBROUTINE


! work for biffit, bifbig, bifimo, bibimo
SUBROUTINE LoadbifHead(filePath, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
	IMPLICIT NONE
	CHARACTER(*):: filePath
	INTEGER*4:: nCols, nRows, lR, lC, BlockLength
	REAL*4:: xLlCor, yLlCor, ceSize, noData
	  
	BlockLength=24
	OPEN (102, file=TRIM(filePath), access='direct', form='unformatted', recl=BlockLength)
		READ(102, rec=1) nCols, nRows, xLlCor, yLlCor, ceSize, noData
	CLOSE (102)
END SUBROUTINE


SUBROUTINE Loadbif(filePath, Vout, nCols, nRows)
	IMPLICIT NONE
	CHARACTER(*):: filePath
	CHARACTER*26:: EmptySpace
	INTEGER*4:: nC, nR, nCols, nRows, lR, lC, BlockLength
	REAL*4:: xLlCor, yLlCor, ceSize, noData, Vout(1:nCols,1:nRows)

	BlockLength=6*4+26+nRows*nCols*4
	OPEN (102, file=TRIM(filePath), access='direct', form='unformatted', recl=BlockLength)
		READ(102, rec=1) nCols, nRows, xLlCor, yLlCor, ceSize, noData, EmptySpace, ((Vout(lC,lR), lC=1, nCols), lR=1, nRows) 
	CLOSE (102)
END SUBROUTINE


SUBROUTINE Savebif(Filename, Vout, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
	IMPLICIT NONE
	CHARACTER(*):: Filename
	CHARACTER*26:: EmptySpace
	INTEGER*4:: nCols, nRows, lR, lC, BlockLength
	REAL*4:: xLlCor, yLlCor, ceSize, noData, Vout(1:nCols, 1:nRows)

	BlockLength=6*4+26+nRows*nCols*4
	OPEN(102, file=TRIM(Filename), status="REPLACE", access='direct', form='unformatted', recl=BlockLength)
		WRITE(102, rec=1)nCols, nRows, xLlCor, yLlCor, ceSize, noData, EmptySpace, ((Vout(lC,lR), lC=1, nCols), lR=1, nRows) 
	CLOSE (102)
END SUBROUTINE


! work for bifbig, bibimo
SUBROUTINE LoadbifbyRegion(filePath, Vout, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
	IMPLICIT NONE
	CHARACTER(*):: filePath
	INTEGER*4:: nCols, nRows, souCols, souRows
	REAL*4:: xLlCor, yLlCor, ceSize, noData, Vout(1:nCols, 1:nRows), souXll, souYll, souCS, souND
	REAL*4, ALLOCATABLE:: Vsou(:,:)
	
	CALL LoadbifHead(filePath, souCols, souRows, souXLL, souYLL, souCS, souND)
	ALLOCATE(Vsou(1:souCols, 1:souRows))
	CALL Loadbif(filePath, Vsou, souCols, souRows)
	CALL GetBfromA(souCols, souRows, souXll, souYll, souCS, souND, Vsou, &
			&nCols, nRows, xllCor, yllCor, ceSize, noData, Vout)
END SUBROUTINE


SUBROUTINE LoadASCbyRegion(filePath, Vout, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
	IMPLICIT NONE
	CHARACTER(*):: filePath
	INTEGER*4:: nCols, nRows, souCols, souRows
	REAL*4:: xLlCor, yLlCor, ceSize, noData, Vout(1:nCols, 1:nRows), souXll, souYll, souCS, souND
	REAL*4, ALLOCATABLE:: Vsou(:,:)
	
	CALL LoadASCHead(filePath, souCols, souRows, souXLL, souYLL, souCS, souND)
	ALLOCATE(Vsou(1:souCols, 1:souRows))
	CALL LoadASC(filePath, Vsou, souCols, souRows)
	CALL GetBfromA(souCols, souRows, souXll, souYll, souCS, souND, Vsou, &
			&nCols, nRows, xllCor, yllCor, ceSize, noData, Vout)
END SUBROUTINE

SUBROUTINE LoadNMQBinHead(filePath, nCols, nRows)
        IMPLICIT NONE
        CHARACTER(*):: filePath
        INTEGER*4:: nCols, nRows, souNZ
        INTEGER*4:: Year, Month, Day, Hour, Minute, Second
        OPEN (102, file=TRIM(filePath), access='direct', form='unformatted', recl=4)
        READ(102, rec=1) Year
        READ(102, rec=2) Month
        READ(102, rec=3) Day
        READ(102, rec=4) Hour
        READ(102, rec=5) Minute
        READ(102, rec=6) Second
        READ(102, rec=7) nCols
        READ(102, rec=8) nRows
        READ(102, rec=9) souNZ
        CLOSE(102)
END SUBROUTINE


SUBROUTINE LoadNMQBinbyRegion(filePath, Vout, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
        IMPLICIT NONE
        CHARACTER(*):: filePath
        INTEGER*4:: nCols, nRows, souCols, souRows, souNZ
	INTEGER*4:: Year, Month, Day, Hour, Minute, Second
	INTEGER*4:: mapProject, truLat1, truLat2, truLon, xy_scale, map_scale_temp, nw_lon_temp, nw_lat_temp, i, j
	INTEGER*4:: dx, dy, dxy_scale, z_height, z_scale, filler, blockLength, varScaleTemp, varMissingTemp, numRad
	CHARACTER*1:: varName(20), varUnit(6), radName(4)
	REAL*4:: nw_lat, nw_lon, map_scale, varScale, varMissing
        REAL*4:: xLlCor, yLlCor, ceSize, noData, Vout(1:nCols, 1:nRows), souXll, souYll, souCS, souND
        REAL*4, ALLOCATABLE:: Vsou(:,:)
	INTEGER*2, ALLOCATABLE:: ShortData(:,:)
	INTEGER*1:: foundNull
	CALL LoadNMQBinHead(filePath, souCols, souRows)
	blockLength = (souCols * souRows * 2) + (34 * 4) + 30 + 4
	ALLOCATE(Vsou(1:souCols, 1:souRows))
	ALLOCATE(ShortData(1:souCols, 1:souRows))
	OPEN (102, file=TRIM(filePath), access='direct', form='unformatted', recl=blockLength)
	READ(102, rec=1) Year, Month, Day, Hour, Minute, Second, souCols, souRows, souNZ, mapProject, map_scale_temp, truLat1, truLat2, truLon, nw_lon_temp, nw_lat_temp, xy_scale, dx, dy, dxy_scale, z_height, z_scale, filler, filler, filler, filler, filler, filler, filler, filler, filler, filler, varName, varUnit, varScaleTemp, varMissingTemp, numRad, radName, ShortData
	CLOSE(102)
	
	!convert our ints to floats and scale things properly
	map_scale = REAL(map_scale_temp)
	nw_lon = REAL(nw_lon_temp) / map_scale
	nw_lat = REAL(nw_lat_temp) / map_scale
	varScale = REAL(varScaleTemp)
	varMissing = REAL(varMissingTemp)
	do i = 1, souCols
		do j = 1, souRows
			Vsou(i, j) = REAL(ShortData(i, (souRows - j + 1))) / varScale
			IF (Vsou(i, j) .LT. 0) THEN
				Vsou(i, j) = varMissing
			ENDIF
		end do
	end do
	souXll = nw_lon
	souYll = nw_lat - ((REAL(dy) / REAL(dxy_scale)) * REAL(souRows))
	souCS = REAL(dx) / REAL(dxy_scale)
	souND = varMissing
        ! WRITE (*,*) nw_lon, nw_lat, souXll, souYll, souCS, souND
	CALL GetBfromA(souCols, souRows, souXll, souYll, souCS, souND, Vsou, &
                        &nCols, nRows, xllCor, yllCor, ceSize, noData, Vout)
END SUBROUTINE

! Change resolution and span, including INTerpolation FUNCTION based on resampling technique
SUBROUTINE GetBfromA(AnCols, AnRows, AxLlCor, AyLlCor, AceSize, AnoData, mtxA, &
					&BnCols, BnRows, BxLlCor, ByLlCor, BceSize, BnoData, mtxB)
	IMPLICIT NONE
	INTEGER*4:: AnCols, AnRows, BnCols, BnRows, lR, lC, souR, souC
	REAL*4:: AxLlCor, AyLlCor, AceSize, AnoData, mtxA(1:AnCols, 1:AnRows), &
			&BxLlCor, ByLlCor, BceSize, BnoData, mtxB(1:BnCols, 1:BnRows), SR, SC

	mtxB=BnoData
	DO lR=1, BnRows
		SR = ByLlCor + BnRows * BceSize - (lR - 0.5) * BceSize
		souR = (AyLlCor + AnRows * AceSize - SR) / AceSize + 1
		IF (souR>=1 .And. souR <= AnRows) THEN
			DO lC=1, BnCols
				sC = (lC - 0.5) * BceSize + BxLlCor
				souC = (sC - AxLlCor) / AceSize + 1
				IF (souC>=1 .And. souC <= AnCols) THEN
					IF (mtxA(souC, souR) /= AnoData)  mtxB(lC, lR) = mtxA(souC, souR)
				END IF
			ENDDO
		END IF
	ENDDO
END SUBROUTINE


! Work for colomn
SUBROUTINE LoadColumn(Filename, DatBegin, DatWarm, lTmax, TimeMark, TimeStep, V)
	IMPLICIT NONE
	CHARACTER(80):: Filename
	CHARACTER(1):: TimeMark
	INTEGER(4):: DatBegin(1:6), DatWarm(1:6), TimeStep, lTmax, lTmin
	REAL(4):: V(1:lTmax)

	INTEGER(4), EXTERNAL:: myDdIFf
	
	INTEGER(4):: D(1:6), lT
	CHARACTER(80):: msg
	LOGICAL:: fExist
	REAL(4):: temV

	DO lT=1, lTmax
		V(lT)=-1
	END DO
	
	lTmin=myDdIFf(TimeMark, Datbegin, DatWarm) / TimeStep
	INQUIRE(file=TRIM(Filename), exist=fExist)
	IF (fExist) THEN
		OPEN(102,file=TRIM(Filename),form='formatted')
			READ(102,*) msg, msg
			DO WHILE (.true.)
				READ(102,*,END=999) msg, temV
				IF (temV<0) temV=-1
				CALL myStrtoD(msg, D, TimeMark)
				lT=myDdIFf(TimeMark, Datbegin, D) / TimeStep +1
				IF (lTmin < lT .And. lT <= lTmax) V(lT)=temV
			END DO
			999 continue
		CLOSE (102)
	END IF
END SUBROUTINE


! work for trmmrt
SUBROUTINE LoadRT(filePath, Vsou, nCols, nRows, noData)
	IMPLICIT NONE
	CHARACTER(*):: filePath
	CHARACTER*2880:: EmptySpace
	INTEGER*4:: nCols, nRows, lR, lC, BlockLength, gC
	REAL*4:: noData, Vsou(1:nCols, 1:nRows)
	
	INTEGER*2, ALLOCATABLE:: Idir(:,:)
	REAL*4, ALLOCATABLE:: temS(:,:)
	ALLOCATE(Idir(1:nCols, 1:nRows), temS(1:nCols, 1:nRows))

	BlockLength=2880+nCols*nRows*2
	OPEN(102, file=TRIM(filePath), access='direct', form='unformatted', recl=BlockLength)
		READ(102, rec=1)EmptySpace, ((Idir(lC,lR), lC=1, nCols), lR=1, nRows)
	CLOSE(102)

	DO lR=1,nRows
		DO lC=1,nCols
			CALL SwapINT(Idir(lC,lR))
		ENDDO
	ENDDO

	temS=noData
	DO lR = 1, nRows
		DO lC = 1, nCols
			IF(Idir(lC, lR)>=0)THEN
				temS(lC, lR) = REAL(Idir(lC, lR)) / 100.0
			ELSEIF (Idir(lC, lR)==-1)THEN
				temS(lC, lR) = 0.0
			END IF
		ENDDO
	ENDDO
	
	DO lC = 1, nCols
		IF (lC <= 720) THEN
			gC = lC + 720
		ELSE
			gC = lC - 720
		END IF
		DO lR = 1, nRows
			Vsou(gC, lR) = temS(lC, lR)
		ENDDO
	ENDDO
END 


SUBROUTINE SwapINT(Vsou)
	IMPLICIT NONE
	INTEGER*2:: Vsou, temI
	CHARACTER*1:: cha2(1:2), cha
	Equivalence (temI, cha2)
	temI=Vsou
	cha=cha2(1)
	cha2(1)=cha2(2)
	cha2(2)=cha
	Vsou=temI
END

SUBROUTINE SwapSng(Vsou)
	IMPLICIT NONE
	Real(4):: Vsou, temS
	CHARACTER*1:: cha2(1:4), cha
	Equivalence (temS, cha2)
	temS=Vsou
	cha=cha2(1)
	cha2(1)=cha2(4)
	cha2(4)=cha
	cha=cha2(2)
	cha2(2)=cha2(3)
	cha2(3)=cha
	Vsou=temS
END

SUBROUTINE LoadV6(filePath, Vsou, nCols, nRows, noData)
	IMPLICIT NONE
	CHARACTER(80):: filePath
	CHARACTER(298):: EmptySpace
	INTEGER*4:: nCols, nRows, lR, lC, BlockLength
	REAL(4):: noData, Vsou(1:nCols, 1:nRows)
	Real(4), allocatable:: temS(:,:)
	
	allocate(temS(1:nRows, 1:nCols))
	BlockLength=298+nCols*nRows*4
	OPEN(102, file=TRIM(filePath), access='direct', form='unformatted', recl=BlockLength)
		READ(102, rec=1)EmptySpace, ((temS(lR,lC), lR=1, nRows), lC=1, nCols)
	CLOSE(102)
	
	DO lR=1,nRows
		DO lC=1,nCols
			CALL SwapSng(temS(lR,lC))
			if (temS(lR,lC)<0) temS(lR,lC)=noData
		ENDDO
	ENDDO
    
    DO lR=1,nRows
		DO lC=1,nCols
			Vsou(lc,nRows-lr+1)=temS(lR,lC)
		ENDDO
	ENDDO
End SUBROUTINE

SUBROUTINE LoadV6ByRegion(filePath, Vout, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
	IMPLICIT NONE
	CHARACTER(80):: filePath
	INTEGER*4:: nCols, nRows
	REAL*4:: xLlCor, yLlCor, ceSize, noData, Vout(1:nCols, 1:nRows)
	REAL*4, ALLOCATABLE:: Vsou(:,:)

	ALLOCATE(Vsou(1:1440, 1:400))
	CALL LoadV6(filePath, Vsou, 1440, 400, -9999.)
	CALL GetBfromA(1440, 400, -180., -50., 0.25, -9999., Vsou, &
			&nCols, nRows, xllCor, yllCor, ceSize, noData, Vout)
END SUBROUTINE



SUBROUTINE LoadRTByRegion(filePath, Vout, nCols, nRows, xLlCor, yLlCor, ceSize, noData)
	IMPLICIT NONE
	CHARACTER(*):: filePath
	INTEGER*4:: nCols, nRows
	REAL*4:: xLlCor, yLlCor, ceSize, noData, Vout(1:nCols, 1:nRows)
	REAL*4, ALLOCATABLE:: Vsou(:,:)

	ALLOCATE(Vsou(1:1440, 1:480))
	CALL LoadRT(filePath, Vsou, 1440, 480, -9999.)
	CALL GetBfromA(1440, 480, -180., -60., 0.25, -9999., Vsou, &
			&nCols, nRows, xllCor, yllCor, ceSize, noData, Vout)
END SUBROUTINE


SUBROUTINE SaveRegionMean(RegMean, Qobs, DatBegin, lTmax, Filename)
	USE RunCon
	IMPLICIT NONE
	
	INTEGER(4):: lTmax
	REAL(4):: RegMean(1:gExitNum+8, 1:lTmax), Qobs(1:lTmax)
	CHARACTER(*):: Filename
	INTEGER(4):: DatBegin(1:6), D(1:6)
	INTEGER(4):: lT, N

	OPEN(102, file=TRIM(Filename), form="formatted")
		WRITE(102,"(A14, 8A10, $)") "Date      ", "Rain", "PET", "actE", "Soil", "OneExc", "TwoExc", "pOneSto", "pTwoSto"
		DO lT = 1, gExitNum
			WRITE(102,"(A10, $)") TRIM(gExitName(lT))
		END DO
		WRITE(102,"(A10)") "Gauge"
		
		D=DatBegin
        DO lT = 1, UBound(RegMean, 2)
            WRITE(102,"(A14, $)") myDtoStr(D, gTimeMark)
			DO N = 1, UBound(RegMean, 1)
				WRITE(102,"(F10.3, $)") RegMean(N, lT)
			END DO
            WRITE(102,"(F10.3)") Qobs(lT)
			CALL myDadd(gTimeMark, gTimeStep, D)
        END DO
    CLOSE (102)
END SUBROUTINE


! ȷΧԺҪ
SUBROUTINE Para2D() 
	USE RunCon
	IMPLICIT NONE
	
	INTEGER(4):: lR, lC
    DO lR = 1, nRows
        DO lC = 1, nCols
            IF (gDEM(lC, lR) /= noData) THEN
                pCoeM(lC, lR) = gParaValue(1)
                pExpM(lC, lR) = gParaValue(2)
                pCoeR(lC, lR) = gParaValue(3)
                pCoeS(lC, lR) = gParaValue(4)
                PLeaOne(lC, lR) = gParaValue(5)
                PLeaTwo(lC, lR) = gParaValue(6)
                pTh(lC, lR) = gParaValue(7)
                pGm(lC, lR) = gParaValue(8)
                
                pWmax(lC, lR) = gParaValue(9)
                pB(lC, lR) = gParaValue(10)
                pIM(lC, lR) = gParaValue(11) / 100.
                pKE(lC, lR) = gParaValue(12)
                pFc(lC, lR) = gParaValue(13) * gTimeStep
                
                pOneW(lC, lR) = gParaValue(14) * pWmax(lC, lR) / 100.
                pOneSto(lC, lR) = gParaValue(15)
                pTwoSto(lC, lR) = gParaValue(16)
            END IF
        END DO
    END DO
END SUBROUTINE


SUBROUTINE ClipByEXIT(Mask, gC, gR)
	Use RunCon
	IMPLICIT NONE
	REAL(4):: Mask(1:nCols,1:nRows)
	INTEGER(4), allocatable:: LinkR(:), linkC(:)
	INTEGER(4):: lR, lC, TotalNum, L, gR, gC, I

	TotalNum=0
    DO lR=1, nRows
		DO lC=1, nCols
			IF (gDEM(lC,lR)/=noData) TotalNum=TotalNum+1
		END DO
	END DO
    ALLOCATE(linkR(TotalNum), linkC(TotalNum))
    linkR(1) = gR
    linkC(1) = gC
    L=1
    CALL LinkByMulP(linkR, linkC, L, TotalNum)
    DO lR = 1, nRows
        DO lC = 1, nCols
            Mask(lC, lR) = noData
        END DO
    END DO
    DO I = 1, TotalNum
        Mask(linkC(I), linkR(I)) = 1
    END DO
END SUBROUTINE


SUBROUTINE LinkByMulP(linkR, linkC, StaNum, TotalNum)
	Use RunCon
	IMPLICIT NONE
	INTEGER(4):: I, upL, lR, lC, TotalNum, StaNum
	INTEGER(4):: linkR(1:TotalNum), linkC(1:TotalNum)
	
    DO I = 1, StaNum
        gDDM(linkC(I), linkR(I)) = gDDM(linkC(I), linkR(I)) + 10
    END DO
    
    upL = StaNum + 1
    I = 1
    DO WHILE (I < upL)
        lR = linkR(I)
        lC = linkC(I)
        CALL ReturnUpper(lR - 1, lC, 5, I, upL, linkR, linkC, TotalNum)
        CALL ReturnUpper(lR - 1, lC + 1, 6, I, upL, linkR, linkC, TotalNum)
        CALL ReturnUpper(lR, lC + 1, 7, I, upL, linkR, linkC, TotalNum)
        CALL ReturnUpper(lR + 1, lC + 1, 8, I, upL, linkR, linkC, TotalNum)
        CALL ReturnUpper(lR + 1, lC, 1, I, upL, linkR, linkC, TotalNum)
        CALL ReturnUpper(lR + 1, lC - 1, 2, I, upL, linkR, linkC, TotalNum)
        CALL ReturnUpper(lR, lC - 1, 3, I, upL, linkR, linkC, TotalNum)
        CALL ReturnUpper(lR - 1, lC - 1, 4, I, upL, linkR, linkC, TotalNum)
        I = I + 1
    END DO
    
    DO I = 1, StaNum
        gDDM(linkC(I), linkR(I)) = gDDM(linkC(I), linkR(I)) - 10
    END DO
	TotalNum= upL - 1
END SUBROUTINE


SUBROUTINE ReturnUpper(newR, newC, Goaldire, L, upL, linkR, linkC, TotalNum)
	USE RunCon
	IMPLICIT NONE
	INTEGER(4):: newR, newC, Goaldire, L, upL, TotalNum, linkR(1:TotalNum), linkC(1:TotalNum)

    IF (1 <= newR .And. newR <= nRows .And. 1 <= newC .And. newC <= nCols) THEN
        IF (INT(gDDM(newC, newR)) == Goaldire) THEN
            linkR(upL) = newR
            linkC(upL) = newC
            upL = upL + 1
        END IF
    END IF
END SUBROUTINE


SUBROUTINE SearchEXIT(xR, xC, Radius)
	USE RunCon
	IMPLICIT NONE
	INTEGER(4):: xR, xC, Radius
	
	INTEGER(4):: lR, lC, Lmax, gR, gC
	
	Lmax=gFAM(xC,xR)
	DO lR=xR-1, xR+1
		DO lC=xC-1, xC+1
			IF (1<=lR .and. lR<=nRows .and. 1<=lC .and. lR <=nCols) THEN
				IF (Lmax < gFAM(lC,lR)) THEN
					gR=lR
					gC=lC
					Lmax=gFAM(lC,lR)
				END IF
			END IF
		END DO
	END DO
	
	xR=gR
	xC=gC
END SUBROUTINE



! ʱ䴦
SUBROUTINE myNow(DX)
	IMPLICIT NONE
	INTEGER(4):: DX(1:6)
	CHARACTER(20):: A, B
	CHARACTER(14):: strD

	CALL Date_and_Time(A, B)
	strD(1:8)=A(1:8)
	strD(9:14)=B(1:6)
	CALL myStrtoD(strD, DX, "s")
END SUBROUTINE

FUNCTION myDtoStr(myD, Mark)
	IMPLICIT NONE
	INTEGER(4):: myD(1:6)
	CHARACTER(1):: Mark
	CHARACTER(14):: myDtoStr, msg
	
	myDtoStr=""
	WRITE(msg,"(I4)") myD(1);   myDtoStr(1:4)=msg(1:4);
	WRITE(msg,"(I2)") myD(2);   myDtoStr(5:6)=msg(1:2);     IF (myD(2)<10) myDtoStr(5:5)="0"
	WRITE(msg,"(I2)") myD(3);   myDtoStr(7:8)=msg(1:2);     IF (myD(3)<10) myDtoStr(7:7)="0"
	SELECT CASE (Mark)
	CASE ("h","H")
		WRITE(msg,"(I2)") myD(4);   myDtoStr(9:10)=msg(1:2);	IF (myD(4)<10) myDtoStr(9:9)="0"
	CASE ("u","U")
		WRITE(msg,"(I2)") myD(4);   myDtoStr(9:10)=msg(1:2);	IF (myD(4)<10) myDtoStr(9:9)="0"
		WRITE(msg,"(I2)") myD(5);   myDtoStr(11:12)=msg(1:2);   IF (myD(5)<10) myDtoStr(11:11)="0"
	CASE ("s","S")
		WRITE(msg,"(I2)") myD(4);   myDtoStr(9:10)=msg(1:2);	IF (myD(4)<10) myDtoStr(9:9)="0"
		WRITE(msg,"(I2)") myD(5);   myDtoStr(11:12)=msg(1:2);   IF (myD(5)<10) myDtoStr(11:11)="0"
		WRITE(msg,"(I2)") myD(6);   myDtoStr(13:14)=msg(1:2);   IF (myD(6)<10) myDtoStr(13:13)="0"
	END SELECT
END FUNCTION

SUBROUTINE myStrtoD(Str, myD, Mark)
	INTEGER(4):: myD(1:6), I
	CHARACTER(14):: Str, msg
	CHARACTER(1)::Mark

	msg=Str(1:4)
	READ(msg,*) myD(1)
	msg=Str(5:6)
	READ(msg,*) myD(2)
	msg=Str(7:8)
	READ(msg,*) myD(3)

	SELECT CASE (Mark)
	CASE ("h","H")
		msg=Str(9:10)
		READ(msg,*) myD(4)
		Str(11:14)="0000"
	CASE ("u","U")
		msg=Str(9:10)
		READ(msg,*) myD(4)
		msg=Str(11:12)
		READ(msg,*) myD(5)
		Str(13:14)="00"
	CASE ("s","S")
		msg=Str(9:10)
		READ(msg,*) myD(4)
		msg=Str(11:12)
		READ(msg,*) myD(5)
		msg=Str(13:14)
		READ(msg,*) myD(6)
	END SELECT
END SUBROUTINE

! һڱȽϴ
FUNCTION myDdIFf(Mark, myDAout, myDBout)
	IMPLICIT NONE
	CHARACTER(1):: Mark
	INTEGER(4):: myDdIFf, myDAout(1:6), myDBout(1:6)
	INTEGER(4):: myDA(1:6), myDB(1:6), DX(1:6), Num, Sign
	INTEGER(4), EXTERNAL:: myDcompare
	
	myDA=myDAout
	myDB=myDBout
	Sign=myDcompare(myDA, myDB)
	IF (Sign==-1) THEN
		myDA=myDBout
		myDB=myDAout
	END IF
	
	SELECT CASE (Mark)
	CASE ("h","H", "u", "U", "s", "S")
		DX=myDA
		Num=0
		DO
			IF (DX(1)==myDB(1) .and. DX(2)==myDB(2) .And. DX(3)==myDB(3)) EXIT
			CALL myDadd("d", 1, DX)
			Num=Num+1
		END DO

		SELECT CASE (Mark)		
		CASE ("h","H")
			myDdIFf=Num*24+myDB(4)-myDA(4)
		CASE ("u","U")
			myDdIFf=(Num*24+myDB(4)-myDA(4))*60+myDB(5)-myDA(5)
		CASE ("s","S")
			myDdIFf=((Num*24+myDB(4)-myDA(4))*60+myDB(5)-myDA(5))*60+myDB(6)-myDA(6)
		END SELECT
	CASE Default
		DX=myDA
		Num=0
		DO
			SELECT CASE (Mark)
			CASE ("y", "Y")				
				IF (DX(1)==myDB(1)) EXIT
			CASE ("m","M")
				IF (DX(1)==myDB(1) .and. DX(2)==myDB(2)) EXIT
			CASE ("d", "D")
				IF (DX(1)==myDB(1) .and. DX(2)==myDB(2) .And. DX(3)==myDB(3)) EXIT
			END SELECT
			CALL myDadd(Mark, 1, DX)
			Num=Num+1
		END DO
		myDdIFf=Num
	END SELECT
	myDdIFf=myDdIFf*Sign
END FUNCTION

SUBROUTINE myDAdd(Mark, Num, myD)
	IMPLICIT NONE
	CHARACTER(1):: Mark
	INTEGER(4):: myD(1:6)
	INTEGER(4):: Num, I, Days
	
	SELECT CASE (Mark)
	CASE ("y","Y");	I=1
	CASE ("m","M");	I=2
	CASE ("d","D");	I=3
	CASE ("h","H");	I=4
	CASE ("u","U");	I=5
	CASE ("s","S");	I=6
	END SELECT
	myD(I)=myD(I)+Num

	IF (I==6) THEN ! second
		IF (myD(6)<0) THEN
			DO WHILE (myD(6)<0)
				myD(6)=myD(6)+60
				myD(5)=myD(5)-1
			END DO
		ELSE
			DO WHILE (myD(6)>=60)
				myD(6)=myD(6)-60
				myD(5)=myD(5)+1
			END DO
		END IF
	END IF
	IF (I>=5) THEN ! minute
		IF (myD(5)<0) THEN
			DO WHILE (myD(5)<0)
				myD(5)=myD(5)+60
				myD(4)=myD(4)-1
			END DO
		ELSE
			DO WHILE (myD(5)>=60)
				myD(5)=myD(5)-60
				myD(4)=myD(4)+1
			END DO
		END IF
	END IF
	IF (I>=4) THEN ! hour
		IF (myD(4)<0) THEN
			DO WHILE (myD(4)<0)
				myD(4)=myD(4)+24
				myD(3)=myD(3)-1
			END DO
		ELSE
			DO WHILE (myD(4)>=24)
				myD(4)=myD(4)-24
				myD(3)=myD(3)+1
			END DO
		END IF
	END IF
	IF (I>=3) THEN ! day
		IF (myD(3)<0) THEN
			DO WHILE (myD(3)<0)
				SELECT CASE (myD(2))
				CASE (2,4,6,8,9,11,1)
					Days=31
				CASE (5,7,10,12)
					Days=30
				CASE (3)
					IF (Mod(myD(1), 4)==0) THEN
						Days=29
					ELSE
						Days=28
					END IF
				END SELECT
				myD(3)=myD(3)+days
				myD(2)=myD(2)-1
			END DO
		ELSE
			DO
				SELECT CASE (myD(2))
				CASE (1,3,5,7,8,10,12)
					Days=31
				CASE (4,6,9,11)
					Days=30
				CASE (2)
					IF (Mod(myD(1), 4)==0) THEN
						Days=29
					ELSE
						Days=28
					END IF
				END SELECT
				IF (myD(3)<=Days) THEN
					EXIT
				ELSE
					myD(3)=myD(3)-Days
					myD(2)=myD(2)+1
				END IF
			END DO
		END IF
	END IF
	IF (I>=2) THEN ! Month
		IF (myD(2)<0) THEN
			DO WHILE (myD(2)<0)
				myD(2)=myD(2)+12
				myD(1)=myD(1)-1
			END DO
		ELSE
			DO WHILE (myD(2)>12)
				myD(1)=myD(1)+1
				myD(2)=myD(2)-12
			END DO
		END IF
	END IF	
END SUBROUTINE


FUNCTION myDcompare(DA, DB)
	IMPLICIT NONE
	INTEGER(4):: DA(1:6), DB(1:6), myDcompare
	
	myDcompare=1
	IF (DA(1)>DB(1)) THEN
		myDcompare=-1
	ElseIF (DA(1)==DB(1) .and. DA(2)>DB(2)) THEN
		myDcompare=-1
	ELSEIF (DA(1)==DB(1) .and. DA(2)==DB(2) .and. DA(3)>DB(3)) THEN
		myDcompare=-1
	ELSEIF (DA(1)==DB(1) .and. DA(2)==DB(2) .and. DA(3)==DB(3) .and. DA(4)>DB(4)) THEN
		myDcompare=-1
	ELSEIF (DA(1)==DB(1) .and. DA(2)==DB(2) .and. DA(3)==DB(3) .and. DA(4)==DB(4) .and. DA(5)>DB(5)) THEN
		myDcompare=-1
	ELSEIF (DA(1)==DB(1) .and. DA(2)==DB(2) .and. DA(3)==DB(3) .and. DA(4)==DB(4) .and. DA(5)==DB(5) .and. DA(6)>DB(6)) THEN
		myDcompare=-1
	END IF
END FUNCTION


FUNCTION myDequal(DA, DB)
	INTEGER(4):: DA(1:6), DB(1:6)
	LOGICAL:: myDequal
	myDequal=(DA(1)==DB(1) .and. DA(2)==DB(2) .and. DA(3)==DB(3) .and. DA(4)==DB(4) .and. DA(5)==DB(5) .and. DA(6)==DB(6))
END FUNCTION


Function PosIntMsg(I)
	IMPLICIT NONE
	Integer(4)::I
	Character(6):: PosIntMsg
	IF (I<10) Then
		Write(PosIntMsg, "(I1)") I
	ELSEIF (I<100) THEN
		Write(PosIntMsg, "(I2)") I
	ELSEIF (I<1000) THEN
		Write(PosIntMsg, "(I3)") I
	ELSEIF (I<10000) THEN
		Write(PosIntMsg, "(I4)") I
	ELSEIF (I<100000) THEN
		Write(PosIntMsg, "(I5)") I
	ELSE
		Write(PosIntMsg, "(I6)") I
	END IF
End Function

