!EOC
!------------------------------------------------------------------------------
!                  Harvard-NASA Emissions Component (HEMCO)                   !
!------------------------------------------------------------------------------
!BOP
!
! !IROUTINE: hcox_finn_include.H
!
! !DESCRIPTION: Include file with FINN emission factor data that was 
!  originally contained in files FINN\_EFratios\_CO2.csv and
!  FINN\_VOC\_speciation.csv.  We transform these data into hardwired F90
!  assignment statements so that we can avoid reading ASCII files in the 
!  ESMF environment.
!
! !REMARKS:
!  ABOUT THIS FILE:
!  ----------------
!  This file was created by script HEMCO/Extensions/Preprocess/finn.pl.
!  This script can be executed with the following command:
!
!    cd HEMCO/Extensions/Preprocess
!    make finn
!
!  This will regenerate this include file from the original data and 
!  automatically place it in the HEMCO/Extensions directory.
!
!  White space has been removed in order to reduce the file size as much
!  as possible.  If you have to recreate this file, then it is easier to
!  generate via the Perl script than to try to hand edit the code below.
!
! !REVISION HISTORY: 
!  11 Aug 2014 - R. Yantosca - Initial version
!  10 Jul 2015 - R. Yantosca - Fixed minor issues in ProTeX header
!EOP
!------------------------------------------------------------------------------
!BOC
!---------------------------------------------------
! Data from FINN_EFratios_CO2.csv
!---------------------------------------------------

! Number of emissions species in FINN_EFratios_CO2.csv
N_SPEC_EMFAC=12
N_SPECSTRS=12

! Allocate the EMFAC_IN temporary array
ALLOCATE ( EMFAC_IN(N_SPEC_EMFAC, N_EMFAC), STAT=AS )
IF ( AS/=0 ) THEN
 CALL HCO_ERROR('Cannot allocate EMFAC_IN',RC)
 RETURN
ENDIF
EMFAC_IN=0.0_dp

! Species from FINN_EFratios_CO2.csv
IN_SPEC_NAME( 1)="CO2/CO2"
IN_SPEC_NAME( 2)="CO2/CO"
IN_SPEC_NAME( 3)="CO2/CH4"
IN_SPEC_NAME( 4)="CO2/NMOC"
IN_SPEC_NAME( 5)="CO2/H2"
IN_SPEC_NAME( 6)="CO2/NOx"
IN_SPEC_NAME( 7)="CO2/SO2"
IN_SPEC_NAME( 8)="CO2/OC"
IN_SPEC_NAME( 9)="CO2/BC"
IN_SPEC_NAME(10)="CO2/NH3"
IN_SPEC_NAME(11)="CO2/NO"
IN_SPEC_NAME(12)="CO2/NO2"

! SavannaGrasslands emission factors from FINN_EFratios_CO2.csv
EMFAC_IN( 1,1)=1_dp
EMFAC_IN( 2,1)=17.0_dp
EMFAC_IN( 3,1)=316.7_dp
EMFAC_IN( 4,1)=210.1_dp
EMFAC_IN( 5,1)=45.5_dp
EMFAC_IN( 6,1)=294.8_dp
EMFAC_IN( 7,1)=5112.7_dp
EMFAC_IN( 8,1)=14.7_dp
EMFAC_IN( 9,1)=103.5_dp
EMFAC_IN(10,1)=1254.6_dp
EMFAC_IN(11,1)=1553.6_dp
EMFAC_IN(12,1)=550.8_dp

! WoodySavannah emission factors from FINN_EFratios_CO2.csv
EMFAC_IN( 1,2)=1_dp
EMFAC_IN( 2,2)=15.3_dp
EMFAC_IN( 3,2)=226.5_dp
EMFAC_IN( 4,2)=398.7_dp
EMFAC_IN( 5,2)=80.6_dp
EMFAC_IN( 6,2)=353.0_dp
EMFAC_IN( 7,2)=3645.4_dp
EMFAC_IN( 8,2)=10.5_dp
EMFAC_IN( 9,2)=29.8_dp
EMFAC_IN(10,2)=523.0_dp
EMFAC_IN(11,2)=829.5_dp
EMFAC_IN(12,2)=1271.7_dp

! TropicalForest emission factors from FINN_EFratios_CO2.csv
EMFAC_IN( 1,3)=1_dp
EMFAC_IN( 2,3)=11.2_dp
EMFAC_IN( 3,3)=118.1_dp
EMFAC_IN( 4,3)=97.6_dp
EMFAC_IN( 5,3)=22.4_dp
EMFAC_IN( 6,3)=439.4_dp
EMFAC_IN( 7,3)=5978.8_dp
EMFAC_IN( 8,3)=7.9_dp
EMFAC_IN( 9,3)=71.8_dp
EMFAC_IN(10,3)=478.0_dp
EMFAC_IN(11,3)=1231.1_dp
EMFAC_IN(12,3)=477.1_dp

! TemperateForest emission factors from FINN_EFratios_CO2.csv
EMFAC_IN( 1,4)=1_dp
EMFAC_IN( 2,4)=10.3_dp
EMFAC_IN( 3,4)=127.7_dp
EMFAC_IN( 4,4)=109.3_dp
EMFAC_IN( 5,4)=30.3_dp
EMFAC_IN( 6,4)=555.2_dp
EMFAC_IN( 7,4)=2594.2_dp
EMFAC_IN( 8,4)=4.0_dp
EMFAC_IN( 9,4)=65.1_dp
EMFAC_IN(10,4)=437.9_dp
EMFAC_IN(11,4)=1015.1_dp
EMFAC_IN(12,4)=594.6_dp

! Boreal emission factors from FINN_EFratios_CO2.csv
EMFAC_IN( 1,5)=1_dp
EMFAC_IN( 2,5)=7.5_dp
EMFAC_IN( 3,5)=91.1_dp
EMFAC_IN( 4,5)=78.5_dp
EMFAC_IN( 5,5)=29.7_dp
EMFAC_IN( 6,5)=1128.1_dp
EMFAC_IN( 7,5)=2167.4_dp
EMFAC_IN( 8,5)=4.3_dp
EMFAC_IN( 9,5)=169.2_dp
EMFAC_IN(10,5)=211.8_dp
EMFAC_IN(11,5)=676.9_dp
EMFAC_IN(12,5)=518.9_dp

! Crops emission factors from FINN_EFratios_CO2.csv
EMFAC_IN( 1,6)=1_dp
EMFAC_IN( 2,6)=9.9_dp
EMFAC_IN( 3,6)=99.3_dp
EMFAC_IN( 4,6)=95.3_dp
EMFAC_IN( 5,6)=28.1_dp
EMFAC_IN( 6,6)=347.5_dp
EMFAC_IN( 7,6)=5767.7_dp
EMFAC_IN( 8,6)=15.7_dp
EMFAC_IN( 9,6)=48.0_dp
EMFAC_IN(10,6)=282.6_dp
EMFAC_IN(11,6)=635.8_dp
EMFAC_IN(12,6)=424.9_dp

!---------------------------------------------------
! Data from FINN_VOC_speciation.csv
!---------------------------------------------------

! Number of emissions species in FINN_VOC_speciation.csv
N_NMOC=47
N_NMOCSTRS=47

! Allocate the NMOC_RATIO_IN temporary array
ALLOCATE ( NMOC_RATIO_IN(N_NMOC, N_EMFAC), STAT=AS )
IF ( AS/=0 ) THEN
 CALL HCO_ERROR('Cannot allocate NMOC_RATIO_IN',RC)
 RETURN
ENDIF
NMOC_RATIO_IN=0.0_dp

! Species from FINN_VOC_speciation.csv
IN_NMOC_NAME( 1)="ACET"
IN_NMOC_NAME( 2)="ACTA"
IN_NMOC_NAME( 3)="ALD2"
IN_NMOC_NAME( 4)="ALK4"
IN_NMOC_NAME( 5)="APINE"
IN_NMOC_NAME( 6)="AROM"
IN_NMOC_NAME( 7)="BENZ"
IN_NMOC_NAME( 8)="BPINE"
IN_NMOC_NAME( 9)="C2H2"
IN_NMOC_NAME(10)="C2H4"
IN_NMOC_NAME(11)="C2H6"
IN_NMOC_NAME(12)="C3H8"
IN_NMOC_NAME(13)="CARENE"
IN_NMOC_NAME(14)="CH2Br2"
IN_NMOC_NAME(15)="CH2O"
IN_NMOC_NAME(16)="CH3Br"
IN_NMOC_NAME(17)="CH3CN"
IN_NMOC_NAME(18)="CH3I"
IN_NMOC_NAME(19)="DMS"
IN_NMOC_NAME(20)="EOH"
IN_NMOC_NAME(21)="ETBENZ"
IN_NMOC_NAME(22)="FUR"
IN_NMOC_NAME(23)="GLYC"
IN_NMOC_NAME(24)="HAC"
IN_NMOC_NAME(25)="HCN"
IN_NMOC_NAME(26)="HCOOH"
IN_NMOC_NAME(27)="HNO2"
IN_NMOC_NAME(28)="IGNOR"
IN_NMOC_NAME(29)="ISOP"
IN_NMOC_NAME(30)="LIMO"
IN_NMOC_NAME(31)="MACR"
IN_NMOC_NAME(32)="MEK"
IN_NMOC_NAME(33)="MGLY"
IN_NMOC_NAME(34)="MNO3"
IN_NMOC_NAME(35)="MOH"
IN_NMOC_NAME(36)="MTPO"
IN_NMOC_NAME(37)="MVK "
IN_NMOC_NAME(38)="PRPE"
IN_NMOC_NAME(39)="R4N2"
IN_NMOC_NAME(40)="RCHO"
IN_NMOC_NAME(41)="RCOOH"
IN_NMOC_NAME(42)="ROH"
IN_NMOC_NAME(43)="SESQ"
IN_NMOC_NAME(44)="STYR"
IN_NMOC_NAME(45)="TMB"
IN_NMOC_NAME(46)="TOLU"
IN_NMOC_NAME(47)="XYLE"

! SavannaGrasslands emission factors from FINN_VOC_speciation.csv
NMOC_RATIO_IN( 1,1)=1.70E-01_dp
NMOC_RATIO_IN( 2,1)=3.54E+00_dp
NMOC_RATIO_IN( 3,1)=7.80E-01_dp
NMOC_RATIO_IN( 4,1)=1.20E-01_dp
NMOC_RATIO_IN( 5,1)=0.00E+00_dp
NMOC_RATIO_IN( 6,1)=3.30E-01_dp
NMOC_RATIO_IN( 7,1)=1.50E-01_dp
NMOC_RATIO_IN( 8,1)=0.00E+00_dp
NMOC_RATIO_IN( 9,1)=5.50E-01_dp
NMOC_RATIO_IN(10,1)=1.75E+00_dp
NMOC_RATIO_IN(11,1)=1.32E+00_dp
NMOC_RATIO_IN(12,1)=1.40E-01_dp
NMOC_RATIO_IN(13,1)=0.00E+00_dp
NMOC_RATIO_IN(14,1)=0.00E+00_dp
NMOC_RATIO_IN(15,1)=1.46E+00_dp
NMOC_RATIO_IN(16,1)=0.00E+00_dp
NMOC_RATIO_IN(17,1)=1.60E-01_dp
NMOC_RATIO_IN(18,1)=0.00E+00_dp
NMOC_RATIO_IN(19,1)=0.00E+00_dp
NMOC_RATIO_IN(20,1)=1.00E-02_dp
NMOC_RATIO_IN(21,1)=0.00E+00_dp
NMOC_RATIO_IN(22,1)=6.70E-01_dp
NMOC_RATIO_IN(23,1)=8.10E-01_dp
NMOC_RATIO_IN(24,1)=7.60E-01_dp
NMOC_RATIO_IN(25,1)=9.10E-01_dp
NMOC_RATIO_IN(26,1)=2.70E-01_dp
NMOC_RATIO_IN(27,1)=2.50E-01_dp
NMOC_RATIO_IN(28,1)=1.90E-01_dp
NMOC_RATIO_IN(29,1)=3.00E-02_dp
NMOC_RATIO_IN(30,1)=0.00E+00_dp
NMOC_RATIO_IN(31,1)=0.00E+00_dp
NMOC_RATIO_IN(32,1)=1.21E+00_dp
NMOC_RATIO_IN(33,1)=6.10E-01_dp
NMOC_RATIO_IN(34,1)=0.00E+00_dp
NMOC_RATIO_IN(35,1)=5.50E-01_dp
NMOC_RATIO_IN(36,1)=1.00E-02_dp
NMOC_RATIO_IN(37,1)=0.00E+00_dp
NMOC_RATIO_IN(38,1)=1.79E+00_dp
NMOC_RATIO_IN(39,1)=0.00E+00_dp
NMOC_RATIO_IN(40,1)=1.90E-01_dp
NMOC_RATIO_IN(41,1)=0.00E+00_dp
NMOC_RATIO_IN(42,1)=5.00E-02_dp
NMOC_RATIO_IN(43,1)=0.00E+00_dp
NMOC_RATIO_IN(44,1)=1.00E-02_dp
NMOC_RATIO_IN(45,1)=0.00E+00_dp
NMOC_RATIO_IN(46,1)=5.00E-02_dp
NMOC_RATIO_IN(47,1)=1.00E-02_dp

! WoodySavannah emission factors from FINN_VOC_speciation.csv
NMOC_RATIO_IN( 1,2)=7.10E-01_dp
NMOC_RATIO_IN( 2,2)=1.54E+00_dp
NMOC_RATIO_IN( 3,2)=9.50E-01_dp
NMOC_RATIO_IN( 4,2)=5.70E-01_dp
NMOC_RATIO_IN( 5,2)=0.00E+00_dp
NMOC_RATIO_IN( 6,2)=4.00E-01_dp
NMOC_RATIO_IN( 7,2)=3.00E-01_dp
NMOC_RATIO_IN( 8,2)=0.00E+00_dp
NMOC_RATIO_IN( 9,2)=6.50E-01_dp
NMOC_RATIO_IN(10,2)=2.25E+00_dp
NMOC_RATIO_IN(11,2)=1.01E+00_dp
NMOC_RATIO_IN(12,2)=3.60E-01_dp
NMOC_RATIO_IN(13,2)=0.00E+00_dp
NMOC_RATIO_IN(14,2)=0.00E+00_dp
NMOC_RATIO_IN(15,2)=2.33E+00_dp
NMOC_RATIO_IN(16,2)=0.00E+00_dp
NMOC_RATIO_IN(17,2)=4.10E-01_dp
NMOC_RATIO_IN(18,2)=0.00E+00_dp
NMOC_RATIO_IN(19,2)=0.00E+00_dp
NMOC_RATIO_IN(20,2)=2.00E-02_dp
NMOC_RATIO_IN(21,2)=1.00E-02_dp
NMOC_RATIO_IN(22,2)=9.50E-01_dp
NMOC_RATIO_IN(23,2)=3.20E-01_dp
NMOC_RATIO_IN(24,2)=0.00E+00_dp
NMOC_RATIO_IN(25,2)=1.18E+00_dp
NMOC_RATIO_IN(26,2)=1.10E-01_dp
NMOC_RATIO_IN(27,2)=7.30E-01_dp
NMOC_RATIO_IN(28,2)=2.20E-01_dp
NMOC_RATIO_IN(29,2)=3.00E-02_dp
NMOC_RATIO_IN(30,2)=0.00E+00_dp
NMOC_RATIO_IN(31,2)=0.00E+00_dp
NMOC_RATIO_IN(32,2)=1.19E+00_dp
NMOC_RATIO_IN(33,2)=8.50E-01_dp
NMOC_RATIO_IN(34,2)=0.00E+00_dp
NMOC_RATIO_IN(35,2)=5.30E-01_dp
NMOC_RATIO_IN(36,2)=1.00E-02_dp
NMOC_RATIO_IN(37,2)=0.00E+00_dp
NMOC_RATIO_IN(38,2)=1.58E+00_dp
NMOC_RATIO_IN(39,2)=0.00E+00_dp
NMOC_RATIO_IN(40,2)=2.60E-01_dp
NMOC_RATIO_IN(41,2)=0.00E+00_dp
NMOC_RATIO_IN(42,2)=8.00E-02_dp
NMOC_RATIO_IN(43,2)=0.00E+00_dp
NMOC_RATIO_IN(44,2)=2.00E-02_dp
NMOC_RATIO_IN(45,2)=0.00E+00_dp
NMOC_RATIO_IN(46,2)=1.70E-01_dp
NMOC_RATIO_IN(47,2)=3.00E-02_dp

! TropicalForest emission factors from FINN_VOC_speciation.csv
NMOC_RATIO_IN( 1,3)=3.40E-01_dp
NMOC_RATIO_IN( 2,3)=1.60E+00_dp
NMOC_RATIO_IN( 3,3)=1.11E+00_dp
NMOC_RATIO_IN( 4,3)=1.20E-01_dp
NMOC_RATIO_IN( 5,3)=0.00E+00_dp
NMOC_RATIO_IN( 6,3)=1.70E-01_dp
NMOC_RATIO_IN( 7,3)=1.60E-01_dp
NMOC_RATIO_IN( 8,3)=0.00E+00_dp
NMOC_RATIO_IN( 9,3)=5.30E-01_dp
NMOC_RATIO_IN(10,3)=1.19E+00_dp
NMOC_RATIO_IN(11,3)=7.50E-01_dp
NMOC_RATIO_IN(12,3)=9.00E-02_dp
NMOC_RATIO_IN(13,3)=0.00E+00_dp
NMOC_RATIO_IN(14,3)=0.00E+00_dp
NMOC_RATIO_IN(15,3)=1.82E+00_dp
NMOC_RATIO_IN(16,3)=0.00E+00_dp
NMOC_RATIO_IN(17,3)=3.20E-01_dp
NMOC_RATIO_IN(18,3)=0.00E+00_dp
NMOC_RATIO_IN(19,3)=0.00E+00_dp
NMOC_RATIO_IN(20,3)=1.00E-02_dp
NMOC_RATIO_IN(21,3)=1.00E-02_dp
NMOC_RATIO_IN(22,3)=1.44E+00_dp
NMOC_RATIO_IN(23,3)=1.49E+00_dp
NMOC_RATIO_IN(24,3)=4.80E-01_dp
NMOC_RATIO_IN(25,3)=4.90E-01_dp
NMOC_RATIO_IN(26,3)=5.30E-01_dp
NMOC_RATIO_IN(27,3)=7.90E-01_dp
NMOC_RATIO_IN(28,3)=1.90E-01_dp
NMOC_RATIO_IN(29,3)=6.00E-02_dp
NMOC_RATIO_IN(30,3)=0.00E+00_dp
NMOC_RATIO_IN(31,3)=5.00E-02_dp
NMOC_RATIO_IN(32,3)=1.45E+00_dp
NMOC_RATIO_IN(33,3)=3.20E-01_dp
NMOC_RATIO_IN(34,3)=0.00E+00_dp
NMOC_RATIO_IN(35,3)=6.00E-01_dp
NMOC_RATIO_IN(36,3)=3.00E-02_dp
NMOC_RATIO_IN(37,3)=1.70E-01_dp
NMOC_RATIO_IN(38,3)=9.10E-01_dp
NMOC_RATIO_IN(39,3)=0.00E+00_dp
NMOC_RATIO_IN(40,3)=6.00E-01_dp
NMOC_RATIO_IN(41,3)=0.00E+00_dp
NMOC_RATIO_IN(42,3)=3.00E-02_dp
NMOC_RATIO_IN(43,3)=0.00E+00_dp
NMOC_RATIO_IN(44,3)=1.00E-02_dp
NMOC_RATIO_IN(45,3)=0.00E+00_dp
NMOC_RATIO_IN(46,3)=9.00E-02_dp
NMOC_RATIO_IN(47,3)=3.00E-02_dp

! TemperateForest emission factors from FINN_VOC_speciation.csv
NMOC_RATIO_IN( 1,4)=3.10E-01_dp
NMOC_RATIO_IN( 2,4)=1.69E+00_dp
NMOC_RATIO_IN( 3,4)=4.30E-01_dp
NMOC_RATIO_IN( 4,4)=2.90E-01_dp
NMOC_RATIO_IN( 5,4)=2.60E-01_dp
NMOC_RATIO_IN( 6,4)=8.50E-01_dp
NMOC_RATIO_IN( 7,4)=3.20E-01_dp
NMOC_RATIO_IN( 8,4)=2.30E-01_dp
NMOC_RATIO_IN( 9,4)=1.80E-01_dp
NMOC_RATIO_IN(10,4)=1.23E+00_dp
NMOC_RATIO_IN(11,4)=1.34E+00_dp
NMOC_RATIO_IN(12,4)=2.30E-01_dp
NMOC_RATIO_IN(13,4)=1.00E-02_dp
NMOC_RATIO_IN(14,4)=0.00E+00_dp
NMOC_RATIO_IN(15,4)=1.56E+00_dp
NMOC_RATIO_IN(16,4)=0.00E+00_dp
NMOC_RATIO_IN(17,4)=3.30E-01_dp
NMOC_RATIO_IN(18,4)=0.00E+00_dp
NMOC_RATIO_IN(19,4)=0.00E+00_dp
NMOC_RATIO_IN(20,4)=3.00E-02_dp
NMOC_RATIO_IN(21,4)=1.00E-02_dp
NMOC_RATIO_IN(22,4)=6.80E-01_dp
NMOC_RATIO_IN(23,4)=2.90E-01_dp
NMOC_RATIO_IN(24,4)=0.00E+00_dp
NMOC_RATIO_IN(25,4)=1.29E+00_dp
NMOC_RATIO_IN(26,4)=2.80E-01_dp
NMOC_RATIO_IN(27,4)=2.30E-01_dp
NMOC_RATIO_IN(28,4)=4.20E-01_dp
NMOC_RATIO_IN(29,4)=5.00E-02_dp
NMOC_RATIO_IN(30,4)=1.30E-01_dp
NMOC_RATIO_IN(31,4)=2.00E-02_dp
NMOC_RATIO_IN(32,4)=8.40E-01_dp
NMOC_RATIO_IN(33,4)=2.50E-01_dp
NMOC_RATIO_IN(34,4)=0.00E+00_dp
NMOC_RATIO_IN(35,4)=5.20E-01_dp
NMOC_RATIO_IN(36,4)=1.80E-01_dp
NMOC_RATIO_IN(37,4)=7.00E-02_dp
NMOC_RATIO_IN(38,4)=1.40E+00_dp
NMOC_RATIO_IN(39,4)=1.00E-02_dp
NMOC_RATIO_IN(40,4)=2.90E-01_dp
NMOC_RATIO_IN(41,4)=2.00E-02_dp
NMOC_RATIO_IN(42,4)=4.50E-01_dp
NMOC_RATIO_IN(43,4)=1.00E-02_dp
NMOC_RATIO_IN(44,4)=1.00E-02_dp
NMOC_RATIO_IN(45,4)=2.00E-02_dp
NMOC_RATIO_IN(46,4)=1.20E-01_dp
NMOC_RATIO_IN(47,4)=8.00E-02_dp

! Boreal emission factors from FINN_VOC_speciation.csv
NMOC_RATIO_IN( 1,5)=3.10E-01_dp
NMOC_RATIO_IN( 2,5)=1.76E+00_dp
NMOC_RATIO_IN( 3,5)=5.90E-01_dp
NMOC_RATIO_IN( 4,5)=2.50E-01_dp
NMOC_RATIO_IN( 5,5)=2.90E-01_dp
NMOC_RATIO_IN( 6,5)=7.80E-01_dp
NMOC_RATIO_IN( 7,5)=3.40E-01_dp
NMOC_RATIO_IN( 8,5)=2.60E-01_dp
NMOC_RATIO_IN( 9,5)=1.70E-01_dp
NMOC_RATIO_IN(10,5)=1.22E+00_dp
NMOC_RATIO_IN(11,5)=1.43E+00_dp
NMOC_RATIO_IN(12,5)=2.40E-01_dp
NMOC_RATIO_IN(13,5)=0.00E+00_dp
NMOC_RATIO_IN(14,5)=0.00E+00_dp
NMOC_RATIO_IN(15,5)=1.49E+00_dp
NMOC_RATIO_IN(16,5)=0.00E+00_dp
NMOC_RATIO_IN(17,5)=3.60E-01_dp
NMOC_RATIO_IN(18,5)=0.00E+00_dp
NMOC_RATIO_IN(19,5)=0.00E+00_dp
NMOC_RATIO_IN(20,5)=3.00E-02_dp
NMOC_RATIO_IN(21,5)=1.00E-02_dp
NMOC_RATIO_IN(22,5)=6.10E-01_dp
NMOC_RATIO_IN(23,5)=3.10E-01_dp
NMOC_RATIO_IN(24,5)=6.80E-01_dp
NMOC_RATIO_IN(25,5)=1.35E+00_dp
NMOC_RATIO_IN(26,5)=2.90E-01_dp
NMOC_RATIO_IN(27,5)=6.20E-01_dp
NMOC_RATIO_IN(28,5)=2.60E-01_dp
NMOC_RATIO_IN(29,5)=5.00E-02_dp
NMOC_RATIO_IN(30,5)=0.00E+00_dp
NMOC_RATIO_IN(31,5)=2.00E-02_dp
NMOC_RATIO_IN(32,5)=5.50E-01_dp
NMOC_RATIO_IN(33,5)=2.40E-01_dp
NMOC_RATIO_IN(34,5)=0.00E+00_dp
NMOC_RATIO_IN(35,5)=5.30E-01_dp
NMOC_RATIO_IN(36,5)=5.40E-01_dp
NMOC_RATIO_IN(37,5)=7.00E-02_dp
NMOC_RATIO_IN(38,5)=1.14E+00_dp
NMOC_RATIO_IN(39,5)=1.00E-02_dp
NMOC_RATIO_IN(40,5)=1.50E-01_dp
NMOC_RATIO_IN(41,5)=0.00E+00_dp
NMOC_RATIO_IN(42,5)=3.00E-02_dp
NMOC_RATIO_IN(43,5)=0.00E+00_dp
NMOC_RATIO_IN(44,5)=3.00E-02_dp
NMOC_RATIO_IN(45,5)=2.00E-02_dp
NMOC_RATIO_IN(46,5)=1.30E-01_dp
NMOC_RATIO_IN(47,5)=4.00E-02_dp

! Crops emission factors from FINN_VOC_speciation.csv
NMOC_RATIO_IN( 1,6)=2.30E-01_dp
NMOC_RATIO_IN( 2,6)=2.76E+00_dp
NMOC_RATIO_IN( 3,6)=8.30E-01_dp
NMOC_RATIO_IN( 4,6)=1.60E-01_dp
NMOC_RATIO_IN( 5,6)=0.00E+00_dp
NMOC_RATIO_IN( 6,6)=1.80E-01_dp
NMOC_RATIO_IN( 7,6)=6.00E-02_dp
NMOC_RATIO_IN( 8,6)=0.00E+00_dp
NMOC_RATIO_IN( 9,6)=3.10E-01_dp
NMOC_RATIO_IN(10,6)=1.54E+00_dp
NMOC_RATIO_IN(11,6)=9.00E-01_dp
NMOC_RATIO_IN(12,6)=1.90E-01_dp
NMOC_RATIO_IN(13,6)=0.00E+00_dp
NMOC_RATIO_IN(14,6)=0.00E+00_dp
NMOC_RATIO_IN(15,6)=2.05E+00_dp
NMOC_RATIO_IN(16,6)=0.00E+00_dp
NMOC_RATIO_IN(17,6)=1.50E-01_dp
NMOC_RATIO_IN(18,6)=0.00E+00_dp
NMOC_RATIO_IN(19,6)=0.00E+00_dp
NMOC_RATIO_IN(20,6)=1.00E-02_dp
NMOC_RATIO_IN(21,6)=2.00E-02_dp
NMOC_RATIO_IN(22,6)=5.90E-01_dp
NMOC_RATIO_IN(23,6)=9.90E-01_dp
NMOC_RATIO_IN(24,6)=0.00E+00_dp
NMOC_RATIO_IN(25,6)=3.20E-01_dp
NMOC_RATIO_IN(26,6)=6.30E-01_dp
NMOC_RATIO_IN(27,6)=1.40E-01_dp
NMOC_RATIO_IN(28,6)=4.10E-01_dp
NMOC_RATIO_IN(29,6)=1.70E-01_dp
NMOC_RATIO_IN(30,6)=0.00E+00_dp
NMOC_RATIO_IN(31,6)=0.00E+00_dp
NMOC_RATIO_IN(32,6)=2.47E+00_dp
NMOC_RATIO_IN(33,6)=3.00E-01_dp
NMOC_RATIO_IN(34,6)=0.00E+00_dp
NMOC_RATIO_IN(35,6)=7.60E-01_dp
NMOC_RATIO_IN(36,6)=0.00E+00_dp
NMOC_RATIO_IN(37,6)=0.00E+00_dp
NMOC_RATIO_IN(38,6)=1.05E+00_dp
NMOC_RATIO_IN(39,6)=0.00E+00_dp
NMOC_RATIO_IN(40,6)=6.80E-01_dp
NMOC_RATIO_IN(41,6)=0.00E+00_dp
NMOC_RATIO_IN(42,6)=4.00E-02_dp
NMOC_RATIO_IN(43,6)=0.00E+00_dp
NMOC_RATIO_IN(44,6)=1.00E-02_dp
NMOC_RATIO_IN(45,6)=0.00E+00_dp
NMOC_RATIO_IN(46,6)=6.00E-02_dp
NMOC_RATIO_IN(47,6)=4.00E-02_dp

!EOC
