! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Linear Algebra Data and Routines File
! 
! Generated by KPP-2.2.4_gc symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : gckpp_LinearAlgebra.f90
! Time                 : Wed Nov 30 14:50:29 2016
! Working directory    : /n/home05/msulprizio/GC/FlexChem/Mechanisms/Standard
! Equation file        : gckpp.kpp
! Output root filename : gckpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE gckpp_LinearAlgebra

  USE gckpp_Parameters
  USE gckpp_JacobianSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! SPARSE_UTIL - SPARSE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecomp( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER  :: IER
      REAL(kind=dp) :: JVS(LU_NONZERO), W(NVAR), a
      INTEGER  :: k, kk, j, jj

      a = 0. ! mz_rs_20050606
      IER = 0
      DO k=1,NVAR
        ! mz_rs_20050606: don't check if real value == 0
        ! IF ( JVS( LU_DIAG(k) ) .EQ. 0. ) THEN
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(a) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecomp


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplx( JVS, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse LU factorization, complex
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER        :: IER
      DOUBLE COMPLEX :: JVS(LU_NONZERO), W(NVAR), a
      REAL(kind=dp)  :: b = 0.0
      INTEGER        :: k, kk, j, jj

      IER = 0
      DO k=1,NVAR
        IF ( ABS(JVS(LU_DIAG(k))) < TINY(b) ) THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              W( LU_ICOL(kk) ) = JVS(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            a = -W(j) / JVS( LU_DIAG(j) )
            W(j) = -a
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               W( LU_ICOL(jj) ) = W( LU_ICOL(jj) ) + a*JVS(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVS(kk) = W( LU_ICOL(kk) )
         END DO
      END DO
      
END SUBROUTINE KppDecompCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppDecompCmplxR( JVSR, JVSI, IER )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!    Sparse LU factorization, complex
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER       :: IER
      REAL(kind=dp) :: JVSR(LU_NONZERO), JVSI(LU_NONZERO) 
      REAL(kind=dp) :: WR(NVAR), WI(NVAR), ar, ai, den
      INTEGER       :: k, kk, j, jj

      IER = 0
      ar  = 0.0
      DO k=1,NVAR
        IF (  ( ABS(JVSR(LU_DIAG(k))) < TINY(ar) ) .AND. &
              ( ABS(JVSI(LU_DIAG(k))) < TINY(ar) ) )  THEN
            IER = k
            RETURN
        END IF
        DO kk = LU_CROW(k), LU_CROW(k+1)-1
              WR( LU_ICOL(kk) ) = JVSR(kk)
              WI( LU_ICOL(kk) ) = JVSI(kk)
        END DO
        DO kk = LU_CROW(k), LU_DIAG(k)-1
            j = LU_ICOL(kk)
            den = JVSR(LU_DIAG(j))**2 + JVSI(LU_DIAG(j))**2
            ar = -(WR(j)*JVSR(LU_DIAG(j)) + WI(j)*JVSI(LU_DIAG(j)))/den
            ai = -(WI(j)*JVSR(LU_DIAG(j)) - WR(j)*JVSI(LU_DIAG(j)))/den
            WR(j) = -ar
            WI(j) = -ai
            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
               WR( LU_ICOL(jj) ) = WR( LU_ICOL(jj) ) + ar*JVSR(jj) - ai*JVSI(jj)
               WI( LU_ICOL(jj) ) = WI( LU_ICOL(jj) ) + ar*JVSI(jj) + ai*JVSR(jj)
            END DO
         END DO
         DO kk = LU_CROW(k), LU_CROW(k+1)-1
            JVSR(kk) = WR( LU_ICOL(kk) )
            JVSI(kk) = WI( LU_ICOL(kk) )
         END DO
      END DO

END SUBROUTINE KppDecompCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER  :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRIndirect( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER       :: i, j
      REAL(kind=dp) :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO
      
END SUBROUTINE KppSolveTRIndirect


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR), sum

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             X(i) = X(i) - JVS(j)*X(LU_ICOL(j));
         END DO  
      END DO

      DO i=NVAR,1,-1
        sum = X(i);
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
          sum = sum - JVS(j)*X(LU_ICOL(j));
        END DO
        X(i) = sum/JVS(LU_DIAG(i));
      END DO
      
END SUBROUTINE KppSolveCmplx

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), sumr, sumi, den

      DO i=1,NVAR
         DO j = LU_CROW(i), LU_DIAG(i)-1 
             XR(i) = XR(i) - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
             XI(i) = XI(i) - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
         END DO  
      END DO

      DO i=NVAR,1,-1
        sumr = XR(i); sumi = XI(i)
        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
            sumr = sumr - (JVSR(j)*XR(LU_ICOL(j)) - JVSI(j)*XI(LU_ICOL(j)))
            sumi = sumi - (JVSR(j)*XI(LU_ICOL(j)) + JVSI(j)*XR(LU_ICOL(j)))
        END DO
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (sumr*JVSR(LU_DIAG(i)) + sumi*JVSI(LU_DIAG(i)))/den
        XI(i) = (sumi*JVSR(LU_DIAG(i)) - sumr*JVSI(LU_DIAG(i)))/den
      END DO
      
END SUBROUTINE KppSolveCmplxR


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplx( JVS, X )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!        Complex sparse solve transpose subroutine using indirect addressing
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER        :: i, j
      DOUBLE COMPLEX :: JVS(LU_NONZERO), X(NVAR)

      DO i=1,NVAR
        X(i) = X(i)/JVS(LU_DIAG(i))
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  X(LU_ICOL(j)) = X(LU_ICOL(j))-JVS(j)*X(i)
	END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplx


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
SUBROUTINE KppSolveTRCmplxR( JVSR, JVSI, XR, XI )
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!   Complex sparse solve transpose subroutine using indirect addressing
!   (Real and Imaginary parts are used instead of complex data type)     
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  USE gckpp_Parameters
  USE gckpp_JacobianSP

      INTEGER       ::  i, j
      REAL(kind=dp) ::  JVSR(LU_NONZERO), JVSI(LU_NONZERO), XR(NVAR), XI(NVAR), den

      DO i=1,NVAR
        den   = JVSR(LU_DIAG(i))**2 + JVSI(LU_DIAG(i))**2
        XR(i) = (XR(i)*JVSR(LU_DIAG(i)) + XI(i)*JVSI(LU_DIAG(i)))/den
        XI(i) = (XI(i)*JVSR(LU_DIAG(i)) - XR(i)*JVSI(LU_DIAG(i)))/den
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO

      DO i=NVAR, 1, -1
	! subtract all nonzero elements in row i of JVS from X
        DO j=LU_CROW(i),LU_DIAG(i)-1
	  XR(LU_ICOL(j)) = XR(LU_ICOL(j))-(JVSR(j)*XR(i) - JVSI(j)*XI(i))
	  XI(LU_ICOL(j)) = XI(LU_ICOL(j))-(JVSI(j)*XR(i) + JVSR(j)*XI(i))
	END DO
      END DO
      
END SUBROUTINE KppSolveTRCmplxR


!
! Next few commented subroutines perform sparse big linear algebra
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppDecompBig( JVS, IP, IER )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse LU factorization
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE gckpp_Parameters
!  USE gckpp_JacobianSP
!
!      INTEGER  :: IP3(3), IER, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), W(3,3,NVAR), a(3,3), E(3,3)
!      INTEGER  :: k, kk, j, jj
!
!      a = 0.0d0
!      IER = 0
!      DO k=1,NVAR
!        DO kk = LU_CROW(k), LU_CROW(k+1)-1
!              W( 1:3,1:3,LU_ICOL(kk) ) = JVS(1:3,1:3,kk)
!        END DO
!        DO kk = LU_CROW(k), LU_DIAG(k)-1
!            j = LU_ICOL(kk)
!            E(1:3,1:3) = JVS( 1:3,1:3,LU_DIAG(j) )
!            ! CALL DGETRF(3,3,E,3,IP3,IER) 
!            CALL FAC3(E,IP3,IER)
!            IF ( IER /= 0 )  RETURN
!            ! a = W(j) / JVS( LU_DIAG(j) )
!            a(1:3,1:3) = W( 1:3,1:3,j )
!            ! CALL DGETRS ('N',3,3,E,3,IP3,a,3,IER) 
!            CALL SOL3('N',E,IP3,a(1,1))
!            CALL SOL3('N',E,IP3,a(1,2))
!            CALL SOL3('N',E,IP3,a(1,3))
!            W(1:3,1:3,j) = a(1:3,1:3)
!            DO jj = LU_DIAG(j)+1, LU_CROW(j+1)-1
!               W( 1:3,1:3,LU_ICOL(jj) ) = W( 1:3,1:3,LU_ICOL(jj) ) &
!                        - MATMUL( a(1:3,1:3) , JVS(1:3,1:3,jj) )
!            END DO
!         END DO
!         DO kk = LU_CROW(k), LU_CROW(k+1)-1
!            JVS(1:3,1:3,kk) = W( 1:3,1:3,LU_ICOL(kk) )
!         END DO
!      END DO
!
!      DO k=1,NVAR
!         ! CALL WGEFA(JVS(1,1,LU_DIAG(k)),3,3,IP(1,k),IER)
!         ! CALL DGETRF(3,3,JVS(1,1,LU_DIAG(k)),3,IP(1,k),IER)
!         CALL FAC3(JVS(1,1,LU_DIAG(k)),IP(1,k),IER)
!         IF ( IER /= 0 )  RETURN
!      END DO 
!      
!END SUBROUTINE KppDecompBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBig( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Sparse solve subroutine using indirect addressing
!!        for the Runge Kutta (3n)x(3n) linear system
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE gckpp_Parameters
!  USE gckpp_JacobianSP
!
!      INTEGER  :: i, j, k, m, IP3(3), IP(3,NVAR), IER
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR), sum(3)
!
!      DO i=1,NVAR
!        DO j = LU_CROW(i), LU_DIAG(i)-1 
!          !X(1:3,i) = X(1:3,i) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       X(k,i) = X(k,i) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO  
!      END DO
!
!      DO i=NVAR,1,-1
!        sum(1:3) = X(1:3,i);
!        DO j = LU_DIAG(i)+1, LU_CROW(i+1)-1
!          !sum(1:3) = sum(1:3) - MATMUL(JVS(1:3,1:3,j),X(1:3,LU_ICOL(j)));
!          DO k=1,3
!            DO m=1,3
!	       sum(k) = sum(k) - JVS(k,m,j)*X(m,LU_ICOL(j))
!            END DO
!          END DO
!        END DO
!        ! X(i) = sum/JVS(LU_DIAG(i));
!        ! CALL DGETRS ('N',3,1,JVS(1:3,1:3,LU_DIAG(i)),3,IP(1,i),sum,3,0) 
!        ! CALL WGESL('N',JVS(1,1,LU_DIAG(i)),3,3,IP(1,i),sum)
!        CALL SOL3('N',JVS(1,1,LU_DIAG(i)),IP(1,i),sum)
!        X(1:3,i) = sum(1:3)
!      END DO
!      
!END SUBROUTINE KppSolveBig
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE KppSolveBigTR( JVS, IP, X )
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!        Big sparse transpose solve using indirect addressing
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!  USE gckpp_Parameters
!  USE gckpp_JacobianSP
!
!      INTEGER       :: i, j, k, m, IP(3,NVAR)
!      REAL(kind=dp) :: JVS(3,3,LU_NONZERO), X(3,NVAR)
!
!      DO i=1,NVAR
!        ! X(i) = X(i)/JVS(LU_DIAG(i))
!        CALL SOL3('T',JVS(1,1,LU_DIAG(i)),IP(1,i),X(1,i))
!        DO j=LU_DIAG(i)+1,LU_CROW(i+1)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !    - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!
!      DO i=NVAR, 1, -1
!        DO j=LU_CROW(i),LU_DIAG(i)-1
!	  !X(1:3,LU_ICOL(j)) = X(1:3,LU_ICOL(j)) &
!          !   - MATMUL( TRANSPOSE(JVS(1:3,1:3,j)), X(1:3,i) )
!          DO k=1,3
!            DO m=1,3
!	       X(k,LU_ICOL(j)) = X(k,LU_ICOL(j)) - JVS(m,k,j)*X(m,i)
!            END DO
!          END DO
!	END DO
!      END DO
!      
!END SUBROUTINE KppSolveBigTR
!
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE FAC3(A,IPVT,INFO)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     FAC3 FACTORS THE MATRIX A (3,3) BY
!!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!!     LINPACK - LIKE 
!!
!!     Remove comments to perform pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!
!      REAL(kind=dp) :: A(3,3)
!      INTEGER       :: IPVT(3),INFO
!!      INTEGER       :: L
!!      REAL(kind=dp) :: t, dmax, da, TMP(3)
!      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0
!
!      info = 0
!!      t = TINY(da)
!!      
!!      da = ABS(A(1,1)); L = 1
!!      IF ( ABS(A(2,1))>da ) THEN
!!        da = ABS(A(2,1)); L = 2
!!        IF ( ABS(A(3,1))>da ) THEN
!!          L = 3
!!        END IF  
!!      END IF  
!!      IPVT(1)  = L
!!      IF (L /=1 ) THEN
!!         TMP(1:3) = A(L,1:3)
!!         A(L,1:3) = A(1,1:3)
!!         A(1,1:3) = TMP(1:3)
!!      END IF
!!      IF (ABS(A(1,1)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!
!      A(2,1) = A(2,1)/A(1,1)
!      A(2,2) = A(2,2) - A(2,1)*A(1,2)
!      A(2,3) = A(2,3) - A(2,1)*A(1,3)
!      A(3,1) = A(3,1)/A(1,1)
!      A(3,2) = A(3,2) - A(3,1)*A(1,2)
!      A(3,3) = A(3,3) - A(3,1)*A(1,3)
!      
!!      IPVT(2)  = 2
!!      IF (ABS(A(3,2))>ABS(A(2,2))) THEN
!!         IPVT(2)  = 3
!!         TMP(2:3) = A(3,2:3)
!!         A(3,2:3) = A(2,2:3)
!!         A(2,2:3) = TMP(2:3)
!!      END IF
!!      IF (ABS(A(2,2)) < t) THEN
!!         info = 1
!!         return
!!      END IF   
!!      
!      A(3,2)   = A(3,2)/A(2,2)
!      A(3,3)   = A(3,3) - A(3,2)*A(2,3)
!      IPVT(3)  = 3
!      
!END SUBROUTINE FAC3
!
!
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!SUBROUTINE SOL3(Trans,A,IPVT,b)
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!!     SOL3 solves the system 3x3
!!     A * x = b  or  trans(a) * x = b
!!     using the factors computed by WGEFA.
!!
!!     Trans      = 'N'   to solve  A*x = b ,
!!                = 'T'   to solve  transpose(A)*x = b
!!     LINPACK - LIKE 
!!
!!     Remove comments to use pivoting
!! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!
!      CHARACTER     :: Trans
!      REAL(kind=dp) :: a(3,3),b(3)
!      INTEGER       :: IPVT(3)
!!      INTEGER       :: L
!!      REAL(kind=dp) :: TMP
!      
!      SELECT CASE (Trans)
!
!      CASE ('n','N')  !  Solve  A * x = b
!
!!     Solve  L*y = b
!!         L = IPVT(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!         b(2) = b(2)-A(2,1)*b(1)
!         b(3) = b(3)-A(3,1)*b(1)
!         
!!         L = IPVT(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(3) = b(3)-A(3,2)*b(2)
!
!!     Solve  U*x = y
!         b(3) = b(3)/A(3,3)
!         b(2) = (b(2)-A(2,3)*b(3))/A(2,2)
!         b(1) = (b(1)-A(1,3)*b(3)-A(1,2)*b(2))/A(1,1)
!      
!      
!      CASE ('t','T')  !  Solve transpose(A) * x = b
!
!!      Solve transpose(U)*y = b
!         b(1) = b(1)/A(1,1)
!         b(2) = (b(2)-A(1,2)*b(1))/A(2,2)
!         b(3) = (b(3)-A(1,3)*b(1)-A(2,3)*b(2))/A(3,3)
!
!!      Solve transpose(L)*x = y
!         b(2) = b(2)-A(3,2)*b(3)
!!         L = ipvt(2)
!!         IF (L /= 2) THEN
!!            TMP = B(2); B(2) = B(L); B(L) = TMP
!!         END IF
!         b(1) = b(1)-A(3,1)*b(3)-A(2,1)*b(2)
!!         L = ipvt(1)
!!         IF (L /= 1) THEN
!!            TMP = B(1); B(1) = B(L); B(L) = TMP
!!         END IF
!   
!      END SELECT
!
!END SUBROUTINE SOL3

! End of SPARSE_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolve - sparse back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolve ( JVS, X )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)

  X(258) = X(258)-JVS(734)*X(244)
  X(261) = X(261)-JVS(745)*X(242)
  X(262) = X(262)-JVS(750)*X(243)
  X(286) = X(286)-JVS(831)*X(268)
  X(303) = X(303)-JVS(923)*X(299)
  X(311) = X(311)-JVS(976)*X(304)
  X(313) = X(313)-JVS(999)*X(247)-JVS(1000)*X(300)
  X(318) = X(318)-JVS(1034)*X(248)
  X(320) = X(320)-JVS(1045)*X(319)
  X(321) = X(321)-JVS(1051)*X(286)
  X(324) = X(324)-JVS(1074)*X(296)
  X(325) = X(325)-JVS(1086)*X(293)-JVS(1087)*X(317)
  X(326) = X(326)-JVS(1098)*X(310)
  X(327) = X(327)-JVS(1107)*X(313)-JVS(1108)*X(314)-JVS(1109)*X(322)-JVS(1110)*X(323)
  X(329) = X(329)-JVS(1131)*X(320)
  X(331) = X(331)-JVS(1149)*X(288)
  X(332) = X(332)-JVS(1157)*X(278)-JVS(1158)*X(281)
  X(334) = X(334)-JVS(1175)*X(282)
  X(335) = X(335)-JVS(1186)*X(319)
  X(337) = X(337)-JVS(1204)*X(318)-JVS(1205)*X(331)-JVS(1206)*X(332)
  X(338) = X(338)-JVS(1235)*X(319)-JVS(1236)*X(320)
  X(340) = X(340)-JVS(1254)*X(295)-JVS(1255)*X(320)
  X(341) = X(341)-JVS(1265)*X(310)
  X(343) = X(343)-JVS(1282)*X(320)
  X(344) = X(344)-JVS(1293)*X(328)-JVS(1294)*X(330)-JVS(1295)*X(335)-JVS(1296)*X(336)-JVS(1297)*X(338)-JVS(1298)*X(343)
  X(345) = X(345)-JVS(1315)*X(296)-JVS(1316)*X(320)
  X(347) = X(347)-JVS(1334)*X(278)-JVS(1335)*X(282)
  X(349) = X(349)-JVS(1354)*X(302)-JVS(1355)*X(319)
  X(350) = X(350)-JVS(1365)*X(279)-JVS(1366)*X(298)
  X(351) = X(351)-JVS(1380)*X(299)
  X(352) = X(352)-JVS(1388)*X(257)-JVS(1389)*X(291)-JVS(1390)*X(339)
  X(353) = X(353)-JVS(1403)*X(305)
  X(354) = X(354)-JVS(1413)*X(264)-JVS(1414)*X(283)-JVS(1415)*X(298)-JVS(1416)*X(306)-JVS(1417)*X(311)-JVS(1418)*X(314)&
             &-JVS(1419)*X(317)-JVS(1420)*X(327)-JVS(1421)*X(331)-JVS(1422)*X(348)-JVS(1423)*X(351)
  X(355) = X(355)-JVS(1454)*X(268)-JVS(1455)*X(272)-JVS(1456)*X(273)-JVS(1457)*X(306)-JVS(1458)*X(321)-JVS(1459)*X(348)
  X(356) = X(356)-JVS(1474)*X(299)-JVS(1475)*X(302)-JVS(1476)*X(313)-JVS(1477)*X(314)-JVS(1478)*X(326)-JVS(1479)*X(328)&
             &-JVS(1480)*X(333)-JVS(1481)*X(349)-JVS(1482)*X(351)
  X(357) = X(357)-JVS(1501)*X(301)-JVS(1502)*X(334)-JVS(1503)*X(346)-JVS(1504)*X(347)
  X(358) = X(358)-JVS(1516)*X(309)-JVS(1517)*X(342)
  X(360) = X(360)-JVS(1537)*X(288)-JVS(1538)*X(315)-JVS(1539)*X(339)-JVS(1540)*X(359)
  X(361) = X(361)-JVS(1552)*X(308)-JVS(1553)*X(319)-JVS(1554)*X(322)-JVS(1555)*X(323)-JVS(1556)*X(359)
  X(362) = X(362)-JVS(1565)*X(300)-JVS(1566)*X(319)
  X(363) = X(363)-JVS(1575)*X(300)-JVS(1576)*X(310)-JVS(1577)*X(333)-JVS(1578)*X(361)-JVS(1579)*X(362)
  X(364) = X(364)-JVS(1588)*X(299)-JVS(1589)*X(301)-JVS(1590)*X(302)-JVS(1591)*X(313)-JVS(1592)*X(314)-JVS(1593)*X(318)&
             &-JVS(1594)*X(324)-JVS(1595)*X(326)-JVS(1596)*X(330)-JVS(1597)*X(333)-JVS(1598)*X(336)-JVS(1599)*X(341)&
             &-JVS(1600)*X(342)-JVS(1601)*X(345)-JVS(1602)*X(346)-JVS(1603)*X(349)-JVS(1604)*X(351)-JVS(1605)*X(353)&
             &-JVS(1606)*X(357)-JVS(1607)*X(361)-JVS(1608)*X(362)-JVS(1609)*X(363)
  X(365) = X(365)-JVS(1632)*X(309)-JVS(1633)*X(310)-JVS(1634)*X(342)-JVS(1635)*X(362)
  X(366) = X(366)-JVS(1646)*X(309)-JVS(1647)*X(333)-JVS(1648)*X(342)-JVS(1649)*X(361)-JVS(1650)*X(362)-JVS(1651)*X(365)
  X(367) = X(367)-JVS(1661)*X(319)
  X(368) = X(368)-JVS(1671)*X(295)-JVS(1672)*X(299)-JVS(1673)*X(303)-JVS(1674)*X(305)-JVS(1675)*X(313)-JVS(1676)*X(314)&
             &-JVS(1677)*X(315)-JVS(1678)*X(318)-JVS(1679)*X(328)-JVS(1680)*X(331)-JVS(1681)*X(333)-JVS(1682)*X(339)&
             &-JVS(1683)*X(340)-JVS(1684)*X(341)-JVS(1685)*X(351)-JVS(1686)*X(353)-JVS(1687)*X(357)-JVS(1688)*X(359)&
             &-JVS(1689)*X(360)-JVS(1690)*X(361)-JVS(1691)*X(362)-JVS(1692)*X(363)-JVS(1693)*X(365)-JVS(1694)*X(366)&
             &-JVS(1695)*X(367)
  X(369) = X(369)-JVS(1714)*X(264)-JVS(1715)*X(297)-JVS(1716)*X(311)-JVS(1717)*X(314)-JVS(1718)*X(351)-JVS(1719)*X(358)&
             &-JVS(1720)*X(362)-JVS(1721)*X(363)-JVS(1722)*X(365)-JVS(1723)*X(366)
  X(370) = X(370)-JVS(1734)*X(308)-JVS(1735)*X(322)-JVS(1736)*X(323)-JVS(1737)*X(339)-JVS(1738)*X(342)-JVS(1739)*X(346)&
             &-JVS(1740)*X(357)-JVS(1741)*X(358)-JVS(1742)*X(359)-JVS(1743)*X(361)-JVS(1744)*X(365)-JVS(1745)*X(366)&
             &-JVS(1746)*X(369)
  X(371) = X(371)-JVS(1759)*X(255)-JVS(1760)*X(256)-JVS(1761)*X(259)-JVS(1762)*X(269)-JVS(1763)*X(270)-JVS(1764)*X(285)&
             &-JVS(1765)*X(317)-JVS(1766)*X(325)
  X(372) = X(372)-JVS(1781)*X(281)-JVS(1782)*X(296)-JVS(1783)*X(297)-JVS(1784)*X(308)-JVS(1785)*X(309)-JVS(1786)*X(311)&
             &-JVS(1787)*X(312)-JVS(1788)*X(314)-JVS(1789)*X(322)-JVS(1790)*X(323)-JVS(1791)*X(331)-JVS(1792)*X(332)&
             &-JVS(1793)*X(340)-JVS(1794)*X(342)-JVS(1795)*X(345)-JVS(1796)*X(346)-JVS(1797)*X(347)-JVS(1798)*X(349)&
             &-JVS(1799)*X(351)-JVS(1800)*X(353)-JVS(1801)*X(358)-JVS(1802)*X(359)-JVS(1803)*X(360)-JVS(1804)*X(361)&
             &-JVS(1805)*X(362)-JVS(1806)*X(363)-JVS(1807)*X(365)-JVS(1808)*X(366)-JVS(1809)*X(367)-JVS(1810)*X(369)&
             &-JVS(1811)*X(370)
  X(373) = X(373)-JVS(1828)*X(249)-JVS(1829)*X(250)-JVS(1830)*X(251)-JVS(1831)*X(252)-JVS(1832)*X(253)-JVS(1833)*X(254)&
             &-JVS(1834)*X(259)-JVS(1835)*X(268)-JVS(1836)*X(272)-JVS(1837)*X(274)-JVS(1838)*X(275)-JVS(1839)*X(276)&
             &-JVS(1840)*X(277)-JVS(1841)*X(286)-JVS(1842)*X(321)-JVS(1843)*X(348)-JVS(1844)*X(355)-JVS(1845)*X(371)
  X(374) = X(374)-JVS(1861)*X(302)-JVS(1862)*X(303)-JVS(1863)*X(304)-JVS(1864)*X(308)-JVS(1865)*X(322)-JVS(1866)*X(323)&
             &-JVS(1867)*X(331)-JVS(1868)*X(346)-JVS(1869)*X(349)-JVS(1870)*X(351)-JVS(1871)*X(353)-JVS(1872)*X(357)&
             &-JVS(1873)*X(359)-JVS(1874)*X(360)-JVS(1875)*X(361)-JVS(1876)*X(362)-JVS(1877)*X(363)-JVS(1878)*X(366)&
             &-JVS(1879)*X(367)-JVS(1880)*X(369)-JVS(1881)*X(370)
  X(375) = X(375)-JVS(1897)*X(300)-JVS(1898)*X(319)-JVS(1899)*X(361)-JVS(1900)*X(362)-JVS(1901)*X(367)
  X(376) = X(376)-JVS(1914)*X(279)-JVS(1915)*X(291)-JVS(1916)*X(295)-JVS(1917)*X(320)-JVS(1918)*X(339)-JVS(1919)*X(340)&
             &-JVS(1920)*X(343)-JVS(1921)*X(345)-JVS(1922)*X(346)-JVS(1923)*X(350)-JVS(1924)*X(352)-JVS(1925)*X(358)&
             &-JVS(1926)*X(359)-JVS(1927)*X(361)-JVS(1928)*X(365)-JVS(1929)*X(366)-JVS(1930)*X(369)-JVS(1931)*X(370)&
             &-JVS(1932)*X(372)-JVS(1933)*X(374)-JVS(1934)*X(375)
  X(377) = X(377)-JVS(1949)*X(300)-JVS(1950)*X(319)-JVS(1951)*X(335)-JVS(1952)*X(361)-JVS(1953)*X(362)
  X(378) = X(378)-JVS(1966)*X(266)-JVS(1967)*X(267)-JVS(1968)*X(288)-JVS(1969)*X(301)-JVS(1970)*X(302)-JVS(1971)*X(315)&
             &-JVS(1972)*X(319)-JVS(1973)*X(326)-JVS(1974)*X(331)-JVS(1975)*X(332)-JVS(1976)*X(334)-JVS(1977)*X(336)&
             &-JVS(1978)*X(339)-JVS(1979)*X(340)-JVS(1980)*X(342)-JVS(1981)*X(345)-JVS(1982)*X(346)-JVS(1983)*X(347)&
             &-JVS(1984)*X(349)-JVS(1985)*X(350)-JVS(1986)*X(351)-JVS(1987)*X(352)-JVS(1988)*X(353)-JVS(1989)*X(357)&
             &-JVS(1990)*X(358)-JVS(1991)*X(359)-JVS(1992)*X(360)-JVS(1993)*X(361)-JVS(1994)*X(362)-JVS(1995)*X(363)&
             &-JVS(1996)*X(364)-JVS(1997)*X(365)-JVS(1998)*X(366)-JVS(1999)*X(367)-JVS(2000)*X(368)-JVS(2001)*X(369)&
             &-JVS(2002)*X(370)-JVS(2003)*X(372)-JVS(2004)*X(374)-JVS(2005)*X(375)-JVS(2006)*X(376)-JVS(2007)*X(377)
  X(379) = X(379)-JVS(2020)*X(263)-JVS(2021)*X(283)-JVS(2022)*X(294)-JVS(2023)*X(328)-JVS(2024)*X(330)-JVS(2025)*X(335)&
             &-JVS(2026)*X(336)-JVS(2027)*X(338)-JVS(2028)*X(343)-JVS(2029)*X(363)-JVS(2030)*X(367)-JVS(2031)*X(375)&
             &-JVS(2032)*X(377)-JVS(2033)*X(378)
  X(380) = X(380)-JVS(2046)*X(1)-JVS(2047)*X(271)-JVS(2048)*X(283)-JVS(2049)*X(288)-JVS(2050)*X(289)-JVS(2051)*X(292)&
             &-JVS(2052)*X(295)-JVS(2053)*X(300)-JVS(2054)*X(301)-JVS(2055)*X(302)-JVS(2056)*X(305)-JVS(2057)*X(310)&
             &-JVS(2058)*X(313)-JVS(2059)*X(315)-JVS(2060)*X(318)-JVS(2061)*X(319)-JVS(2062)*X(320)-JVS(2063)*X(322)&
             &-JVS(2064)*X(323)-JVS(2065)*X(324)-JVS(2066)*X(326)-JVS(2067)*X(327)-JVS(2068)*X(329)-JVS(2069)*X(331)&
             &-JVS(2070)*X(332)-JVS(2071)*X(333)-JVS(2072)*X(338)-JVS(2073)*X(339)-JVS(2074)*X(340)-JVS(2075)*X(341)&
             &-JVS(2076)*X(342)-JVS(2077)*X(345)-JVS(2078)*X(346)-JVS(2079)*X(347)-JVS(2080)*X(349)-JVS(2081)*X(350)&
             &-JVS(2082)*X(351)-JVS(2083)*X(352)-JVS(2084)*X(353)-JVS(2085)*X(356)-JVS(2086)*X(357)-JVS(2087)*X(358)&
             &-JVS(2088)*X(359)-JVS(2089)*X(360)-JVS(2090)*X(361)-JVS(2091)*X(362)-JVS(2092)*X(363)-JVS(2093)*X(365)&
             &-JVS(2094)*X(366)-JVS(2095)*X(367)-JVS(2096)*X(368)-JVS(2097)*X(369)-JVS(2098)*X(370)-JVS(2099)*X(372)&
             &-JVS(2100)*X(373)-JVS(2101)*X(374)-JVS(2102)*X(375)-JVS(2103)*X(376)-JVS(2104)*X(377)-JVS(2105)*X(378)&
             &-JVS(2106)*X(379)
  X(381) = X(381)-JVS(2123)*X(245)-JVS(2124)*X(274)-JVS(2125)*X(275)-JVS(2126)*X(276)-JVS(2127)*X(277)-JVS(2128)*X(280)&
             &-JVS(2129)*X(284)-JVS(2130)*X(285)-JVS(2131)*X(287)-JVS(2132)*X(289)-JVS(2133)*X(298)-JVS(2134)*X(301)&
             &-JVS(2135)*X(306)-JVS(2136)*X(307)-JVS(2137)*X(313)-JVS(2138)*X(316)-JVS(2139)*X(317)-JVS(2140)*X(318)&
             &-JVS(2141)*X(325)-JVS(2142)*X(326)-JVS(2143)*X(328)-JVS(2144)*X(329)-JVS(2145)*X(330)-JVS(2146)*X(334)&
             &-JVS(2147)*X(335)-JVS(2148)*X(336)-JVS(2149)*X(337)-JVS(2150)*X(338)-JVS(2151)*X(340)-JVS(2152)*X(341)&
             &-JVS(2153)*X(342)-JVS(2154)*X(343)-JVS(2155)*X(344)-JVS(2156)*X(345)-JVS(2157)*X(346)-JVS(2158)*X(347)&
             &-JVS(2159)*X(348)-JVS(2160)*X(349)-JVS(2161)*X(350)-JVS(2162)*X(351)-JVS(2163)*X(352)-JVS(2164)*X(353)&
             &-JVS(2165)*X(354)-JVS(2166)*X(355)-JVS(2167)*X(356)-JVS(2168)*X(357)-JVS(2169)*X(358)-JVS(2170)*X(359)&
             &-JVS(2171)*X(360)-JVS(2172)*X(361)-JVS(2173)*X(362)-JVS(2174)*X(363)-JVS(2175)*X(364)-JVS(2176)*X(365)&
             &-JVS(2177)*X(366)-JVS(2178)*X(367)-JVS(2179)*X(368)-JVS(2180)*X(369)-JVS(2181)*X(370)-JVS(2182)*X(371)&
             &-JVS(2183)*X(372)-JVS(2184)*X(373)-JVS(2185)*X(374)-JVS(2186)*X(375)-JVS(2187)*X(376)-JVS(2188)*X(377)&
             &-JVS(2189)*X(378)-JVS(2190)*X(379)-JVS(2191)*X(380)
  X(382) = X(382)-JVS(2207)*X(246)-JVS(2208)*X(248)-JVS(2209)*X(257)-JVS(2210)*X(265)-JVS(2211)*X(266)-JVS(2212)*X(271)&
             &-JVS(2213)*X(273)-JVS(2214)*X(280)-JVS(2215)*X(287)-JVS(2216)*X(292)-JVS(2217)*X(296)-JVS(2218)*X(306)&
             &-JVS(2219)*X(308)-JVS(2220)*X(309)-JVS(2221)*X(310)-JVS(2222)*X(311)-JVS(2223)*X(313)-JVS(2224)*X(314)&
             &-JVS(2225)*X(315)-JVS(2226)*X(317)-JVS(2227)*X(318)-JVS(2228)*X(322)-JVS(2229)*X(323)-JVS(2230)*X(324)&
             &-JVS(2231)*X(326)-JVS(2232)*X(328)-JVS(2233)*X(330)-JVS(2234)*X(331)-JVS(2235)*X(332)-JVS(2236)*X(333)&
             &-JVS(2237)*X(335)-JVS(2238)*X(336)-JVS(2239)*X(338)-JVS(2240)*X(339)-JVS(2241)*X(340)-JVS(2242)*X(341)&
             &-JVS(2243)*X(342)-JVS(2244)*X(343)-JVS(2245)*X(345)-JVS(2246)*X(346)-JVS(2247)*X(347)-JVS(2248)*X(348)&
             &-JVS(2249)*X(349)-JVS(2250)*X(350)-JVS(2251)*X(351)-JVS(2252)*X(352)-JVS(2253)*X(353)-JVS(2254)*X(354)&
             &-JVS(2255)*X(356)-JVS(2256)*X(357)-JVS(2257)*X(358)-JVS(2258)*X(359)-JVS(2259)*X(360)-JVS(2260)*X(361)&
             &-JVS(2261)*X(362)-JVS(2262)*X(363)-JVS(2263)*X(364)-JVS(2264)*X(365)-JVS(2265)*X(366)-JVS(2266)*X(367)&
             &-JVS(2267)*X(368)-JVS(2268)*X(369)-JVS(2269)*X(370)-JVS(2270)*X(371)-JVS(2271)*X(372)-JVS(2272)*X(373)&
             &-JVS(2273)*X(374)-JVS(2274)*X(375)-JVS(2275)*X(376)-JVS(2276)*X(377)-JVS(2277)*X(378)-JVS(2278)*X(379)&
             &-JVS(2279)*X(380)-JVS(2280)*X(381)
  X(383) = X(383)-JVS(2295)*X(242)-JVS(2296)*X(243)-JVS(2297)*X(244)-JVS(2298)*X(245)-JVS(2299)*X(247)-JVS(2300)*X(263)&
             &-JVS(2301)*X(264)-JVS(2302)*X(267)-JVS(2303)*X(268)-JVS(2304)*X(269)-JVS(2305)*X(270)-JVS(2306)*X(272)&
             &-JVS(2307)*X(273)-JVS(2308)*X(274)-JVS(2309)*X(275)-JVS(2310)*X(276)-JVS(2311)*X(277)-JVS(2312)*X(278)&
             &-JVS(2313)*X(279)-JVS(2314)*X(280)-JVS(2315)*X(281)-JVS(2316)*X(282)-JVS(2317)*X(283)-JVS(2318)*X(284)&
             &-JVS(2319)*X(285)-JVS(2320)*X(287)-JVS(2321)*X(288)-JVS(2322)*X(289)-JVS(2323)*X(291)-JVS(2324)*X(292)&
             &-JVS(2325)*X(293)-JVS(2326)*X(294)-JVS(2327)*X(295)-JVS(2328)*X(296)-JVS(2329)*X(297)-JVS(2330)*X(298)&
             &-JVS(2331)*X(299)-JVS(2332)*X(300)-JVS(2333)*X(301)-JVS(2334)*X(302)-JVS(2335)*X(303)-JVS(2336)*X(304)&
             &-JVS(2337)*X(305)-JVS(2338)*X(306)-JVS(2339)*X(307)-JVS(2340)*X(308)-JVS(2341)*X(309)-JVS(2342)*X(310)&
             &-JVS(2343)*X(311)-JVS(2344)*X(312)-JVS(2345)*X(313)-JVS(2346)*X(314)-JVS(2347)*X(315)-JVS(2348)*X(316)&
             &-JVS(2349)*X(317)-JVS(2350)*X(318)-JVS(2351)*X(319)-JVS(2352)*X(320)-JVS(2353)*X(321)-JVS(2354)*X(322)&
             &-JVS(2355)*X(323)-JVS(2356)*X(324)-JVS(2357)*X(325)-JVS(2358)*X(326)-JVS(2359)*X(327)-JVS(2360)*X(328)&
             &-JVS(2361)*X(329)-JVS(2362)*X(330)-JVS(2363)*X(331)-JVS(2364)*X(332)-JVS(2365)*X(333)-JVS(2366)*X(334)&
             &-JVS(2367)*X(335)-JVS(2368)*X(336)-JVS(2369)*X(337)-JVS(2370)*X(338)-JVS(2371)*X(339)-JVS(2372)*X(340)&
             &-JVS(2373)*X(341)-JVS(2374)*X(342)-JVS(2375)*X(343)-JVS(2376)*X(344)-JVS(2377)*X(345)-JVS(2378)*X(346)&
             &-JVS(2379)*X(347)-JVS(2380)*X(348)-JVS(2381)*X(349)-JVS(2382)*X(350)-JVS(2383)*X(351)-JVS(2384)*X(352)&
             &-JVS(2385)*X(353)-JVS(2386)*X(354)-JVS(2387)*X(355)-JVS(2388)*X(356)-JVS(2389)*X(357)-JVS(2390)*X(358)&
             &-JVS(2391)*X(359)-JVS(2392)*X(360)-JVS(2393)*X(361)-JVS(2394)*X(362)-JVS(2395)*X(363)-JVS(2396)*X(364)&
             &-JVS(2397)*X(365)-JVS(2398)*X(366)-JVS(2399)*X(367)-JVS(2400)*X(368)-JVS(2401)*X(369)-JVS(2402)*X(370)&
             &-JVS(2403)*X(371)-JVS(2404)*X(372)-JVS(2405)*X(373)-JVS(2406)*X(374)-JVS(2407)*X(375)-JVS(2408)*X(376)&
             &-JVS(2409)*X(377)-JVS(2410)*X(378)-JVS(2411)*X(379)-JVS(2412)*X(380)-JVS(2413)*X(381)-JVS(2414)*X(382)
  X(384) = X(384)-JVS(2428)*X(258)-JVS(2429)*X(260)-JVS(2430)*X(261)-JVS(2431)*X(262)-JVS(2432)*X(265)-JVS(2433)*X(280)&
             &-JVS(2434)*X(311)-JVS(2435)*X(313)-JVS(2436)*X(314)-JVS(2437)*X(318)-JVS(2438)*X(322)-JVS(2439)*X(323)&
             &-JVS(2440)*X(328)-JVS(2441)*X(330)-JVS(2442)*X(331)-JVS(2443)*X(332)-JVS(2444)*X(335)-JVS(2445)*X(336)&
             &-JVS(2446)*X(338)-JVS(2447)*X(339)-JVS(2448)*X(340)-JVS(2449)*X(341)-JVS(2450)*X(342)-JVS(2451)*X(343)&
             &-JVS(2452)*X(345)-JVS(2453)*X(346)-JVS(2454)*X(347)-JVS(2455)*X(349)-JVS(2456)*X(350)-JVS(2457)*X(351)&
             &-JVS(2458)*X(352)-JVS(2459)*X(353)-JVS(2460)*X(357)-JVS(2461)*X(358)-JVS(2462)*X(359)-JVS(2463)*X(360)&
             &-JVS(2464)*X(361)-JVS(2465)*X(362)-JVS(2466)*X(363)-JVS(2467)*X(365)-JVS(2468)*X(366)-JVS(2469)*X(367)&
             &-JVS(2470)*X(369)-JVS(2471)*X(370)-JVS(2472)*X(371)-JVS(2473)*X(372)-JVS(2474)*X(373)-JVS(2475)*X(374)&
             &-JVS(2476)*X(375)-JVS(2477)*X(377)-JVS(2478)*X(378)-JVS(2479)*X(379)-JVS(2480)*X(381)-JVS(2481)*X(382)&
             &-JVS(2482)*X(383)
  X(385) = X(385)-JVS(2495)*X(263)-JVS(2496)*X(278)-JVS(2497)*X(284)-JVS(2498)*X(298)-JVS(2499)*X(299)-JVS(2500)*X(303)&
             &-JVS(2501)*X(305)-JVS(2502)*X(313)-JVS(2503)*X(315)-JVS(2504)*X(319)-JVS(2505)*X(320)-JVS(2506)*X(324)&
             &-JVS(2507)*X(327)-JVS(2508)*X(328)-JVS(2509)*X(330)-JVS(2510)*X(333)-JVS(2511)*X(334)-JVS(2512)*X(335)&
             &-JVS(2513)*X(336)-JVS(2514)*X(339)-JVS(2515)*X(341)-JVS(2516)*X(342)-JVS(2517)*X(343)-JVS(2518)*X(345)&
             &-JVS(2519)*X(347)-JVS(2520)*X(351)-JVS(2521)*X(353)-JVS(2522)*X(356)-JVS(2523)*X(359)-JVS(2524)*X(360)&
             &-JVS(2525)*X(361)-JVS(2526)*X(362)-JVS(2527)*X(363)-JVS(2528)*X(364)-JVS(2529)*X(365)-JVS(2530)*X(366)&
             &-JVS(2531)*X(367)-JVS(2532)*X(368)-JVS(2533)*X(369)-JVS(2534)*X(370)-JVS(2535)*X(372)-JVS(2536)*X(374)&
             &-JVS(2537)*X(375)-JVS(2538)*X(376)-JVS(2539)*X(377)-JVS(2540)*X(378)-JVS(2541)*X(379)-JVS(2542)*X(380)&
             &-JVS(2543)*X(381)-JVS(2544)*X(382)-JVS(2545)*X(383)-JVS(2546)*X(384)
  X(386) = X(386)-JVS(2558)*X(249)-JVS(2559)*X(250)-JVS(2560)*X(251)-JVS(2561)*X(252)-JVS(2562)*X(253)-JVS(2563)*X(254)&
             &-JVS(2564)*X(255)-JVS(2565)*X(256)-JVS(2566)*X(259)-JVS(2567)*X(260)-JVS(2568)*X(265)-JVS(2569)*X(269)&
             &-JVS(2570)*X(270)-JVS(2571)*X(274)-JVS(2572)*X(275)-JVS(2573)*X(276)-JVS(2574)*X(277)-JVS(2575)*X(285)&
             &-JVS(2576)*X(321)-JVS(2577)*X(329)-JVS(2578)*X(348)-JVS(2579)*X(355)-JVS(2580)*X(371)-JVS(2581)*X(373)&
             &-JVS(2582)*X(376)-JVS(2583)*X(377)-JVS(2584)*X(378)-JVS(2585)*X(379)-JVS(2586)*X(381)-JVS(2587)*X(382)&
             &-JVS(2588)*X(383)-JVS(2589)*X(384)-JVS(2590)*X(385)
  X(387) = X(387)-JVS(2601)*X(278)-JVS(2602)*X(298)-JVS(2603)*X(334)-JVS(2604)*X(347)-JVS(2605)*X(348)-JVS(2606)*X(355)&
             &-JVS(2607)*X(369)-JVS(2608)*X(370)-JVS(2609)*X(371)-JVS(2610)*X(373)-JVS(2611)*X(374)-JVS(2612)*X(375)&
             &-JVS(2613)*X(376)-JVS(2614)*X(377)-JVS(2615)*X(378)-JVS(2616)*X(379)-JVS(2617)*X(380)-JVS(2618)*X(381)&
             &-JVS(2619)*X(382)-JVS(2620)*X(383)-JVS(2621)*X(384)-JVS(2622)*X(385)-JVS(2623)*X(386)
  X(388) = X(388)-JVS(2633)*X(304)-JVS(2634)*X(310)-JVS(2635)*X(315)-JVS(2636)*X(316)-JVS(2637)*X(319)-JVS(2638)*X(320)&
             &-JVS(2639)*X(329)-JVS(2640)*X(333)-JVS(2641)*X(339)-JVS(2642)*X(351)-JVS(2643)*X(352)-JVS(2644)*X(359)&
             &-JVS(2645)*X(360)-JVS(2646)*X(361)-JVS(2647)*X(362)-JVS(2648)*X(363)-JVS(2649)*X(372)-JVS(2650)*X(374)&
             &-JVS(2651)*X(375)-JVS(2652)*X(376)-JVS(2653)*X(377)-JVS(2654)*X(378)-JVS(2655)*X(379)-JVS(2656)*X(380)&
             &-JVS(2657)*X(381)-JVS(2658)*X(382)-JVS(2659)*X(383)-JVS(2660)*X(384)-JVS(2661)*X(385)-JVS(2662)*X(386)&
             &-JVS(2663)*X(387)
  X(389) = X(389)-JVS(2672)*X(246)-JVS(2673)*X(255)-JVS(2674)*X(256)-JVS(2675)*X(259)-JVS(2676)*X(269)-JVS(2677)*X(270)&
             &-JVS(2678)*X(278)-JVS(2679)*X(285)-JVS(2680)*X(290)-JVS(2681)*X(293)-JVS(2682)*X(298)-JVS(2683)*X(317)&
             &-JVS(2684)*X(325)-JVS(2685)*X(334)-JVS(2686)*X(347)-JVS(2687)*X(348)-JVS(2688)*X(355)-JVS(2689)*X(369)&
             &-JVS(2690)*X(370)-JVS(2691)*X(371)-JVS(2692)*X(373)-JVS(2693)*X(374)-JVS(2694)*X(375)-JVS(2695)*X(376)&
             &-JVS(2696)*X(377)-JVS(2697)*X(378)-JVS(2698)*X(379)-JVS(2699)*X(380)-JVS(2700)*X(381)-JVS(2701)*X(382)&
             &-JVS(2702)*X(383)-JVS(2703)*X(384)-JVS(2704)*X(385)-JVS(2705)*X(386)-JVS(2706)*X(387)-JVS(2707)*X(388)
  X(390) = X(390)-JVS(2715)*X(258)-JVS(2716)*X(261)-JVS(2717)*X(262)-JVS(2718)*X(271)-JVS(2719)*X(279)-JVS(2720)*X(281)&
             &-JVS(2721)*X(282)-JVS(2722)*X(284)-JVS(2723)*X(285)-JVS(2724)*X(287)-JVS(2725)*X(289)-JVS(2726)*X(291)&
             &-JVS(2727)*X(295)-JVS(2728)*X(296)-JVS(2729)*X(297)-JVS(2730)*X(299)-JVS(2731)*X(300)-JVS(2732)*X(302)&
             &-JVS(2733)*X(303)-JVS(2734)*X(304)-JVS(2735)*X(305)-JVS(2736)*X(307)-JVS(2737)*X(308)-JVS(2738)*X(309)&
             &-JVS(2739)*X(310)-JVS(2740)*X(311)-JVS(2741)*X(312)-JVS(2742)*X(313)-JVS(2743)*X(314)-JVS(2744)*X(316)&
             &-JVS(2745)*X(318)-JVS(2746)*X(319)-JVS(2747)*X(320)-JVS(2748)*X(322)-JVS(2749)*X(323)-JVS(2750)*X(326)&
             &-JVS(2751)*X(327)-JVS(2752)*X(329)-JVS(2753)*X(331)-JVS(2754)*X(332)-JVS(2755)*X(333)-JVS(2756)*X(338)&
             &-JVS(2757)*X(339)-JVS(2758)*X(340)-JVS(2759)*X(341)-JVS(2760)*X(342)-JVS(2761)*X(344)-JVS(2762)*X(345)&
             &-JVS(2763)*X(346)-JVS(2764)*X(347)-JVS(2765)*X(349)-JVS(2766)*X(350)-JVS(2767)*X(351)-JVS(2768)*X(352)&
             &-JVS(2769)*X(353)-JVS(2770)*X(356)-JVS(2771)*X(357)-JVS(2772)*X(358)-JVS(2773)*X(359)-JVS(2774)*X(360)&
             &-JVS(2775)*X(361)-JVS(2776)*X(362)-JVS(2777)*X(363)-JVS(2778)*X(364)-JVS(2779)*X(365)-JVS(2780)*X(366)&
             &-JVS(2781)*X(367)-JVS(2782)*X(368)-JVS(2783)*X(369)-JVS(2784)*X(370)-JVS(2785)*X(371)-JVS(2786)*X(372)&
             &-JVS(2787)*X(373)-JVS(2788)*X(374)-JVS(2789)*X(375)-JVS(2790)*X(376)-JVS(2791)*X(377)-JVS(2792)*X(378)&
             &-JVS(2793)*X(379)-JVS(2794)*X(380)-JVS(2795)*X(381)-JVS(2796)*X(382)-JVS(2797)*X(383)-JVS(2798)*X(384)&
             &-JVS(2799)*X(385)-JVS(2800)*X(386)-JVS(2801)*X(387)-JVS(2802)*X(388)-JVS(2803)*X(389)
  X(391) = X(391)-JVS(2810)*X(245)-JVS(2811)*X(249)-JVS(2812)*X(250)-JVS(2813)*X(251)-JVS(2814)*X(252)-JVS(2815)*X(253)&
             &-JVS(2816)*X(254)-JVS(2817)*X(259)-JVS(2818)*X(268)-JVS(2819)*X(273)-JVS(2820)*X(274)-JVS(2821)*X(275)&
             &-JVS(2822)*X(276)-JVS(2823)*X(277)-JVS(2824)*X(284)-JVS(2825)*X(286)-JVS(2826)*X(290)-JVS(2827)*X(306)&
             &-JVS(2828)*X(317)-JVS(2829)*X(321)-JVS(2830)*X(325)-JVS(2831)*X(329)-JVS(2832)*X(344)-JVS(2833)*X(348)&
             &-JVS(2834)*X(355)-JVS(2835)*X(363)-JVS(2836)*X(367)-JVS(2837)*X(371)-JVS(2838)*X(373)-JVS(2839)*X(375)&
             &-JVS(2840)*X(376)-JVS(2841)*X(377)-JVS(2842)*X(378)-JVS(2843)*X(379)-JVS(2844)*X(380)-JVS(2845)*X(381)&
             &-JVS(2846)*X(382)-JVS(2847)*X(383)-JVS(2848)*X(384)-JVS(2849)*X(385)-JVS(2850)*X(386)-JVS(2851)*X(387)&
             &-JVS(2852)*X(388)-JVS(2853)*X(389)-JVS(2854)*X(390)
  X(392) = X(392)-JVS(2860)*X(266)-JVS(2861)*X(267)-JVS(2862)*X(271)-JVS(2863)*X(283)-JVS(2864)*X(284)-JVS(2865)*X(285)&
             &-JVS(2866)*X(289)-JVS(2867)*X(319)-JVS(2868)*X(320)-JVS(2869)*X(322)-JVS(2870)*X(323)-JVS(2871)*X(324)&
             &-JVS(2872)*X(329)-JVS(2873)*X(331)-JVS(2874)*X(332)-JVS(2875)*X(333)-JVS(2876)*X(334)-JVS(2877)*X(336)&
             &-JVS(2878)*X(337)-JVS(2879)*X(340)-JVS(2880)*X(341)-JVS(2881)*X(342)-JVS(2882)*X(343)-JVS(2883)*X(345)&
             &-JVS(2884)*X(346)-JVS(2885)*X(347)-JVS(2886)*X(349)-JVS(2887)*X(350)-JVS(2888)*X(351)-JVS(2889)*X(352)&
             &-JVS(2890)*X(353)-JVS(2891)*X(357)-JVS(2892)*X(358)-JVS(2893)*X(359)-JVS(2894)*X(360)-JVS(2895)*X(361)&
             &-JVS(2896)*X(362)-JVS(2897)*X(363)-JVS(2898)*X(365)-JVS(2899)*X(366)-JVS(2900)*X(367)-JVS(2901)*X(368)&
             &-JVS(2902)*X(369)-JVS(2903)*X(370)-JVS(2904)*X(372)-JVS(2905)*X(373)-JVS(2906)*X(374)-JVS(2907)*X(375)&
             &-JVS(2908)*X(376)-JVS(2909)*X(377)-JVS(2910)*X(378)-JVS(2911)*X(379)-JVS(2912)*X(381)-JVS(2913)*X(382)&
             &-JVS(2914)*X(383)-JVS(2915)*X(384)-JVS(2916)*X(385)-JVS(2917)*X(386)-JVS(2918)*X(387)-JVS(2919)*X(388)&
             &-JVS(2920)*X(389)-JVS(2921)*X(390)-JVS(2922)*X(391)
  X(393) = X(393)-JVS(2927)*X(264)-JVS(2928)*X(266)-JVS(2929)*X(271)-JVS(2930)*X(283)-JVS(2931)*X(287)-JVS(2932)*X(298)&
             &-JVS(2933)*X(306)-JVS(2934)*X(315)-JVS(2935)*X(317)-JVS(2936)*X(318)-JVS(2937)*X(319)-JVS(2938)*X(320)&
             &-JVS(2939)*X(323)-JVS(2940)*X(326)-JVS(2941)*X(327)-JVS(2942)*X(328)-JVS(2943)*X(330)-JVS(2944)*X(335)&
             &-JVS(2945)*X(336)-JVS(2946)*X(338)-JVS(2947)*X(339)-JVS(2948)*X(341)-JVS(2949)*X(343)-JVS(2950)*X(348)&
             &-JVS(2951)*X(349)-JVS(2952)*X(351)-JVS(2953)*X(353)-JVS(2954)*X(354)-JVS(2955)*X(356)-JVS(2956)*X(359)&
             &-JVS(2957)*X(360)-JVS(2958)*X(361)-JVS(2959)*X(362)-JVS(2960)*X(363)-JVS(2961)*X(364)-JVS(2962)*X(365)&
             &-JVS(2963)*X(366)-JVS(2964)*X(367)-JVS(2965)*X(368)-JVS(2966)*X(369)-JVS(2967)*X(370)-JVS(2968)*X(371)&
             &-JVS(2969)*X(372)-JVS(2970)*X(373)-JVS(2971)*X(374)-JVS(2972)*X(375)-JVS(2973)*X(376)-JVS(2974)*X(377)&
             &-JVS(2975)*X(378)-JVS(2976)*X(379)-JVS(2977)*X(380)-JVS(2978)*X(381)-JVS(2979)*X(382)-JVS(2980)*X(383)&
             &-JVS(2981)*X(384)-JVS(2982)*X(385)-JVS(2983)*X(386)-JVS(2984)*X(387)-JVS(2985)*X(388)-JVS(2986)*X(389)&
             &-JVS(2987)*X(390)-JVS(2988)*X(391)-JVS(2989)*X(392)
  X(394) = X(394)-JVS(2993)*X(284)-JVS(2994)*X(306)-JVS(2995)*X(317)-JVS(2996)*X(325)-JVS(2997)*X(329)-JVS(2998)*X(344)&
             &-JVS(2999)*X(348)-JVS(3000)*X(355)-JVS(3001)*X(363)-JVS(3002)*X(367)-JVS(3003)*X(371)-JVS(3004)*X(373)&
             &-JVS(3005)*X(375)-JVS(3006)*X(376)-JVS(3007)*X(377)-JVS(3008)*X(378)-JVS(3009)*X(379)-JVS(3010)*X(380)&
             &-JVS(3011)*X(381)-JVS(3012)*X(382)-JVS(3013)*X(383)-JVS(3014)*X(384)-JVS(3015)*X(385)-JVS(3016)*X(386)&
             &-JVS(3017)*X(387)-JVS(3018)*X(388)-JVS(3019)*X(389)-JVS(3020)*X(390)-JVS(3021)*X(391)-JVS(3022)*X(392)&
             &-JVS(3023)*X(393)
  X(395) = X(395)-JVS(3026)*X(249)-JVS(3027)*X(250)-JVS(3028)*X(251)-JVS(3029)*X(252)-JVS(3030)*X(253)-JVS(3031)*X(254)&
             &-JVS(3032)*X(255)-JVS(3033)*X(256)-JVS(3034)*X(259)-JVS(3035)*X(263)-JVS(3036)*X(265)-JVS(3037)*X(269)&
             &-JVS(3038)*X(270)-JVS(3039)*X(272)-JVS(3040)*X(274)-JVS(3041)*X(275)-JVS(3042)*X(276)-JVS(3043)*X(277)&
             &-JVS(3044)*X(316)-JVS(3045)*X(321)-JVS(3046)*X(325)-JVS(3047)*X(329)-JVS(3048)*X(344)-JVS(3049)*X(348)&
             &-JVS(3050)*X(355)-JVS(3051)*X(363)-JVS(3052)*X(367)-JVS(3053)*X(371)-JVS(3054)*X(373)-JVS(3055)*X(375)&
             &-JVS(3056)*X(376)-JVS(3057)*X(377)-JVS(3058)*X(378)-JVS(3059)*X(379)-JVS(3060)*X(380)-JVS(3061)*X(381)&
             &-JVS(3062)*X(382)-JVS(3063)*X(383)-JVS(3064)*X(384)-JVS(3065)*X(385)-JVS(3066)*X(386)-JVS(3067)*X(387)&
             &-JVS(3068)*X(388)-JVS(3069)*X(389)-JVS(3070)*X(390)-JVS(3071)*X(391)-JVS(3072)*X(392)-JVS(3073)*X(393)&
             &-JVS(3074)*X(394)
  X(395) = X(395)/JVS(3075)
  X(394) = (X(394)-JVS(3025)*X(395))/(JVS(3024))
  X(393) = (X(393)-JVS(2991)*X(394)-JVS(2992)*X(395))/(JVS(2990))
  X(392) = (X(392)-JVS(2924)*X(393)-JVS(2925)*X(394)-JVS(2926)*X(395))/(JVS(2923))
  X(391) = (X(391)-JVS(2856)*X(392)-JVS(2857)*X(393)-JVS(2858)*X(394)-JVS(2859)*X(395))/(JVS(2855))
  X(390) = (X(390)-JVS(2805)*X(391)-JVS(2806)*X(392)-JVS(2807)*X(393)-JVS(2808)*X(394)-JVS(2809)*X(395))/(JVS(2804))
  X(389) = (X(389)-JVS(2709)*X(390)-JVS(2710)*X(391)-JVS(2711)*X(392)-JVS(2712)*X(393)-JVS(2713)*X(394)-JVS(2714)&
             &*X(395))/(JVS(2708))
  X(388) = (X(388)-JVS(2665)*X(389)-JVS(2666)*X(390)-JVS(2667)*X(391)-JVS(2668)*X(392)-JVS(2669)*X(393)-JVS(2670)*X(394)&
             &-JVS(2671)*X(395))/(JVS(2664))
  X(387) = (X(387)-JVS(2625)*X(388)-JVS(2626)*X(389)-JVS(2627)*X(390)-JVS(2628)*X(391)-JVS(2629)*X(392)-JVS(2630)*X(393)&
             &-JVS(2631)*X(394)-JVS(2632)*X(395))/(JVS(2624))
  X(386) = (X(386)-JVS(2592)*X(387)-JVS(2593)*X(388)-JVS(2594)*X(389)-JVS(2595)*X(390)-JVS(2596)*X(391)-JVS(2597)*X(392)&
             &-JVS(2598)*X(393)-JVS(2599)*X(394)-JVS(2600)*X(395))/(JVS(2591))
  X(385) = (X(385)-JVS(2548)*X(386)-JVS(2549)*X(387)-JVS(2550)*X(388)-JVS(2551)*X(389)-JVS(2552)*X(390)-JVS(2553)*X(391)&
             &-JVS(2554)*X(392)-JVS(2555)*X(393)-JVS(2556)*X(394)-JVS(2557)*X(395))/(JVS(2547))
  X(384) = (X(384)-JVS(2484)*X(385)-JVS(2485)*X(386)-JVS(2486)*X(387)-JVS(2487)*X(388)-JVS(2488)*X(389)-JVS(2489)*X(390)&
             &-JVS(2490)*X(391)-JVS(2491)*X(392)-JVS(2492)*X(393)-JVS(2493)*X(394)-JVS(2494)*X(395))/(JVS(2483))
  X(383) = (X(383)-JVS(2416)*X(384)-JVS(2417)*X(385)-JVS(2418)*X(386)-JVS(2419)*X(387)-JVS(2420)*X(388)-JVS(2421)*X(389)&
             &-JVS(2422)*X(390)-JVS(2423)*X(391)-JVS(2424)*X(392)-JVS(2425)*X(393)-JVS(2426)*X(394)-JVS(2427)*X(395))&
             &/(JVS(2415))
  X(382) = (X(382)-JVS(2282)*X(383)-JVS(2283)*X(384)-JVS(2284)*X(385)-JVS(2285)*X(386)-JVS(2286)*X(387)-JVS(2287)*X(388)&
             &-JVS(2288)*X(389)-JVS(2289)*X(390)-JVS(2290)*X(391)-JVS(2291)*X(392)-JVS(2292)*X(393)-JVS(2293)*X(394)&
             &-JVS(2294)*X(395))/(JVS(2281))
  X(381) = (X(381)-JVS(2193)*X(382)-JVS(2194)*X(383)-JVS(2195)*X(384)-JVS(2196)*X(385)-JVS(2197)*X(386)-JVS(2198)*X(387)&
             &-JVS(2199)*X(388)-JVS(2200)*X(389)-JVS(2201)*X(390)-JVS(2202)*X(391)-JVS(2203)*X(392)-JVS(2204)*X(393)&
             &-JVS(2205)*X(394)-JVS(2206)*X(395))/(JVS(2192))
  X(380) = (X(380)-JVS(2108)*X(381)-JVS(2109)*X(382)-JVS(2110)*X(383)-JVS(2111)*X(384)-JVS(2112)*X(385)-JVS(2113)*X(386)&
             &-JVS(2114)*X(387)-JVS(2115)*X(388)-JVS(2116)*X(389)-JVS(2117)*X(390)-JVS(2118)*X(391)-JVS(2119)*X(392)&
             &-JVS(2120)*X(393)-JVS(2121)*X(394)-JVS(2122)*X(395))/(JVS(2107))
  X(379) = (X(379)-JVS(2035)*X(381)-JVS(2036)*X(382)-JVS(2037)*X(383)-JVS(2038)*X(384)-JVS(2039)*X(385)-JVS(2040)*X(388)&
             &-JVS(2041)*X(389)-JVS(2042)*X(390)-JVS(2043)*X(392)-JVS(2044)*X(393)-JVS(2045)*X(395))/(JVS(2034))
  X(378) = (X(378)-JVS(2009)*X(379)-JVS(2010)*X(381)-JVS(2011)*X(382)-JVS(2012)*X(383)-JVS(2013)*X(384)-JVS(2014)*X(385)&
             &-JVS(2015)*X(388)-JVS(2016)*X(389)-JVS(2017)*X(390)-JVS(2018)*X(392)-JVS(2019)*X(393))/(JVS(2008))
  X(377) = (X(377)-JVS(1955)*X(378)-JVS(1956)*X(379)-JVS(1957)*X(381)-JVS(1958)*X(382)-JVS(1959)*X(383)-JVS(1960)*X(384)&
             &-JVS(1961)*X(385)-JVS(1962)*X(388)-JVS(1963)*X(390)-JVS(1964)*X(392)-JVS(1965)*X(393))/(JVS(1954))
  X(376) = (X(376)-JVS(1936)*X(377)-JVS(1937)*X(378)-JVS(1938)*X(379)-JVS(1939)*X(381)-JVS(1940)*X(382)-JVS(1941)*X(383)&
             &-JVS(1942)*X(384)-JVS(1943)*X(385)-JVS(1944)*X(388)-JVS(1945)*X(389)-JVS(1946)*X(390)-JVS(1947)*X(392)&
             &-JVS(1948)*X(393))/(JVS(1935))
  X(375) = (X(375)-JVS(1903)*X(378)-JVS(1904)*X(379)-JVS(1905)*X(381)-JVS(1906)*X(382)-JVS(1907)*X(383)-JVS(1908)*X(384)&
             &-JVS(1909)*X(385)-JVS(1910)*X(388)-JVS(1911)*X(390)-JVS(1912)*X(392)-JVS(1913)*X(393))/(JVS(1902))
  X(374) = (X(374)-JVS(1883)*X(375)-JVS(1884)*X(377)-JVS(1885)*X(378)-JVS(1886)*X(379)-JVS(1887)*X(381)-JVS(1888)*X(382)&
             &-JVS(1889)*X(383)-JVS(1890)*X(384)-JVS(1891)*X(385)-JVS(1892)*X(388)-JVS(1893)*X(389)-JVS(1894)*X(390)&
             &-JVS(1895)*X(392)-JVS(1896)*X(393))/(JVS(1882))
  X(373) = (X(373)-JVS(1847)*X(381)-JVS(1848)*X(382)-JVS(1849)*X(383)-JVS(1850)*X(384)-JVS(1851)*X(386)-JVS(1852)*X(387)&
             &-JVS(1853)*X(388)-JVS(1854)*X(389)-JVS(1855)*X(390)-JVS(1856)*X(391)-JVS(1857)*X(392)-JVS(1858)*X(393)&
             &-JVS(1859)*X(394)-JVS(1860)*X(395))/(JVS(1846))
  X(372) = (X(372)-JVS(1813)*X(374)-JVS(1814)*X(375)-JVS(1815)*X(377)-JVS(1816)*X(378)-JVS(1817)*X(379)-JVS(1818)*X(381)&
             &-JVS(1819)*X(382)-JVS(1820)*X(383)-JVS(1821)*X(384)-JVS(1822)*X(385)-JVS(1823)*X(388)-JVS(1824)*X(389)&
             &-JVS(1825)*X(390)-JVS(1826)*X(392)-JVS(1827)*X(393))/(JVS(1812))
  X(371) = (X(371)-JVS(1768)*X(373)-JVS(1769)*X(381)-JVS(1770)*X(382)-JVS(1771)*X(383)-JVS(1772)*X(384)-JVS(1773)*X(386)&
             &-JVS(1774)*X(387)-JVS(1775)*X(388)-JVS(1776)*X(389)-JVS(1777)*X(390)-JVS(1778)*X(393)-JVS(1779)*X(394)&
             &-JVS(1780)*X(395))/(JVS(1767))
  X(370) = (X(370)-JVS(1748)*X(374)-JVS(1749)*X(375)-JVS(1750)*X(378)-JVS(1751)*X(382)-JVS(1752)*X(383)-JVS(1753)*X(384)&
             &-JVS(1754)*X(388)-JVS(1755)*X(389)-JVS(1756)*X(390)-JVS(1757)*X(392)-JVS(1758)*X(393))/(JVS(1747))
  X(369) = (X(369)-JVS(1725)*X(370)-JVS(1726)*X(375)-JVS(1727)*X(378)-JVS(1728)*X(383)-JVS(1729)*X(384)-JVS(1730)*X(388)&
             &-JVS(1731)*X(390)-JVS(1732)*X(392)-JVS(1733)*X(393))/(JVS(1724))
  X(368) = (X(368)-JVS(1697)*X(369)-JVS(1698)*X(370)-JVS(1699)*X(374)-JVS(1700)*X(375)-JVS(1701)*X(377)-JVS(1702)*X(378)&
             &-JVS(1703)*X(379)-JVS(1704)*X(381)-JVS(1705)*X(382)-JVS(1706)*X(383)-JVS(1707)*X(384)-JVS(1708)*X(385)&
             &-JVS(1709)*X(388)-JVS(1710)*X(389)-JVS(1711)*X(390)-JVS(1712)*X(392)-JVS(1713)*X(393))/(JVS(1696))
  X(367) = (X(367)-JVS(1663)*X(379)-JVS(1664)*X(381)-JVS(1665)*X(382)-JVS(1666)*X(383)-JVS(1667)*X(384)-JVS(1668)*X(385)&
             &-JVS(1669)*X(388)-JVS(1670)*X(393))/(JVS(1662))
  X(366) = (X(366)-JVS(1653)*X(375)-JVS(1654)*X(378)-JVS(1655)*X(383)-JVS(1656)*X(384)-JVS(1657)*X(388)-JVS(1658)*X(390)&
             &-JVS(1659)*X(392)-JVS(1660)*X(393))/(JVS(1652))
  X(365) = (X(365)-JVS(1637)*X(366)-JVS(1638)*X(375)-JVS(1639)*X(378)-JVS(1640)*X(383)-JVS(1641)*X(384)-JVS(1642)*X(388)&
             &-JVS(1643)*X(390)-JVS(1644)*X(392)-JVS(1645)*X(393))/(JVS(1636))
  X(364) = (X(364)-JVS(1611)*X(365)-JVS(1612)*X(366)-JVS(1613)*X(367)-JVS(1614)*X(368)-JVS(1615)*X(369)-JVS(1616)*X(370)&
             &-JVS(1617)*X(374)-JVS(1618)*X(375)-JVS(1619)*X(377)-JVS(1620)*X(378)-JVS(1621)*X(379)-JVS(1622)*X(381)&
             &-JVS(1623)*X(382)-JVS(1624)*X(383)-JVS(1625)*X(384)-JVS(1626)*X(385)-JVS(1627)*X(388)-JVS(1628)*X(389)&
             &-JVS(1629)*X(390)-JVS(1630)*X(392)-JVS(1631)*X(393))/(JVS(1610))
  X(363) = (X(363)-JVS(1581)*X(378)-JVS(1582)*X(383)-JVS(1583)*X(384)-JVS(1584)*X(388)-JVS(1585)*X(390)-JVS(1586)*X(392)&
             &-JVS(1587)*X(393))/(JVS(1580))
  X(362) = (X(362)-JVS(1568)*X(378)-JVS(1569)*X(383)-JVS(1570)*X(384)-JVS(1571)*X(388)-JVS(1572)*X(390)-JVS(1573)*X(392)&
             &-JVS(1574)*X(393))/(JVS(1567))
  X(361) = (X(361)-JVS(1558)*X(378)-JVS(1559)*X(383)-JVS(1560)*X(384)-JVS(1561)*X(388)-JVS(1562)*X(390)-JVS(1563)*X(392)&
             &-JVS(1564)*X(393))/(JVS(1557))
  X(360) = (X(360)-JVS(1542)*X(361)-JVS(1543)*X(375)-JVS(1544)*X(378)-JVS(1545)*X(382)-JVS(1546)*X(383)-JVS(1547)*X(384)&
             &-JVS(1548)*X(388)-JVS(1549)*X(390)-JVS(1550)*X(392)-JVS(1551)*X(393))/(JVS(1541))
  X(359) = (X(359)-JVS(1530)*X(361)-JVS(1531)*X(378)-JVS(1532)*X(383)-JVS(1533)*X(384)-JVS(1534)*X(388)-JVS(1535)*X(392)&
             &-JVS(1536)*X(393))/(JVS(1529))
  X(358) = (X(358)-JVS(1519)*X(365)-JVS(1520)*X(366)-JVS(1521)*X(370)-JVS(1522)*X(375)-JVS(1523)*X(378)-JVS(1524)*X(383)&
             &-JVS(1525)*X(384)-JVS(1526)*X(390)-JVS(1527)*X(392)-JVS(1528)*X(393))/(JVS(1518))
  X(357) = (X(357)-JVS(1506)*X(369)-JVS(1507)*X(370)-JVS(1508)*X(374)-JVS(1509)*X(378)-JVS(1510)*X(383)-JVS(1511)*X(384)&
             &-JVS(1512)*X(389)-JVS(1513)*X(390)-JVS(1514)*X(392)-JVS(1515)*X(393))/(JVS(1505))
  X(356) = (X(356)-JVS(1484)*X(361)-JVS(1485)*X(362)-JVS(1486)*X(363)-JVS(1487)*X(365)-JVS(1488)*X(366)-JVS(1489)*X(377)&
             &-JVS(1490)*X(378)-JVS(1491)*X(379)-JVS(1492)*X(381)-JVS(1493)*X(382)-JVS(1494)*X(383)-JVS(1495)*X(384)&
             &-JVS(1496)*X(385)-JVS(1497)*X(388)-JVS(1498)*X(390)-JVS(1499)*X(392)-JVS(1500)*X(393))/(JVS(1483))
  X(355) = (X(355)-JVS(1461)*X(371)-JVS(1462)*X(373)-JVS(1463)*X(381)-JVS(1464)*X(382)-JVS(1465)*X(383)-JVS(1466)*X(386)&
             &-JVS(1467)*X(387)-JVS(1468)*X(390)-JVS(1469)*X(391)-JVS(1470)*X(392)-JVS(1471)*X(393)-JVS(1472)*X(394)&
             &-JVS(1473)*X(395))/(JVS(1460))
  X(354) = (X(354)-JVS(1425)*X(356)-JVS(1426)*X(359)-JVS(1427)*X(360)-JVS(1428)*X(362)-JVS(1429)*X(363)-JVS(1430)*X(364)&
             &-JVS(1431)*X(365)-JVS(1432)*X(366)-JVS(1433)*X(371)-JVS(1434)*X(372)-JVS(1435)*X(373)-JVS(1436)*X(374)&
             &-JVS(1437)*X(375)-JVS(1438)*X(376)-JVS(1439)*X(378)-JVS(1440)*X(380)-JVS(1441)*X(381)-JVS(1442)*X(382)&
             &-JVS(1443)*X(383)-JVS(1444)*X(384)-JVS(1445)*X(387)-JVS(1446)*X(388)-JVS(1447)*X(389)-JVS(1448)*X(390)&
             &-JVS(1449)*X(391)-JVS(1450)*X(392)-JVS(1451)*X(393)-JVS(1452)*X(394)-JVS(1453)*X(395))/(JVS(1424))
  X(353) = (X(353)-JVS(1405)*X(367)-JVS(1406)*X(375)-JVS(1407)*X(378)-JVS(1408)*X(381)-JVS(1409)*X(383)-JVS(1410)*X(384)&
             &-JVS(1411)*X(390)-JVS(1412)*X(392))/(JVS(1404))
  X(352) = (X(352)-JVS(1392)*X(359)-JVS(1393)*X(372)-JVS(1394)*X(374)-JVS(1395)*X(377)-JVS(1396)*X(378)-JVS(1397)*X(382)&
             &-JVS(1398)*X(383)-JVS(1399)*X(384)-JVS(1400)*X(390)-JVS(1401)*X(392)-JVS(1402)*X(393))/(JVS(1391))
  X(351) = (X(351)-JVS(1382)*X(363)-JVS(1383)*X(378)-JVS(1384)*X(383)-JVS(1385)*X(384)-JVS(1386)*X(390)-JVS(1387)&
             &*X(392))/(JVS(1381))
  X(350) = (X(350)-JVS(1368)*X(352)-JVS(1369)*X(369)-JVS(1370)*X(370)-JVS(1371)*X(372)-JVS(1372)*X(374)-JVS(1373)*X(378)&
             &-JVS(1374)*X(383)-JVS(1375)*X(384)-JVS(1376)*X(389)-JVS(1377)*X(390)-JVS(1378)*X(392)-JVS(1379)*X(393))&
             &/(JVS(1367))
  X(349) = (X(349)-JVS(1357)*X(377)-JVS(1358)*X(378)-JVS(1359)*X(383)-JVS(1360)*X(384)-JVS(1361)*X(388)-JVS(1362)*X(390)&
             &-JVS(1363)*X(392)-JVS(1364)*X(393))/(JVS(1356))
  X(348) = (X(348)-JVS(1346)*X(373)-JVS(1347)*X(381)-JVS(1348)*X(382)-JVS(1349)*X(383)-JVS(1350)*X(387)-JVS(1351)*X(391)&
             &-JVS(1352)*X(394)-JVS(1353)*X(395))/(JVS(1345))
  X(347) = (X(347)-JVS(1337)*X(369)-JVS(1338)*X(370)-JVS(1339)*X(378)-JVS(1340)*X(383)-JVS(1341)*X(384)-JVS(1342)*X(389)&
             &-JVS(1343)*X(390)-JVS(1344)*X(392))/(JVS(1336))
  X(346) = (X(346)-JVS(1327)*X(374)-JVS(1328)*X(378)-JVS(1329)*X(383)-JVS(1330)*X(384)-JVS(1331)*X(390)-JVS(1332)*X(392)&
             &-JVS(1333)*X(393))/(JVS(1326))
  X(345) = (X(345)-JVS(1318)*X(377)-JVS(1319)*X(378)-JVS(1320)*X(383)-JVS(1321)*X(384)-JVS(1322)*X(388)-JVS(1323)*X(390)&
             &-JVS(1324)*X(392)-JVS(1325)*X(393))/(JVS(1317))
  X(344) = (X(344)-JVS(1300)*X(363)-JVS(1301)*X(367)-JVS(1302)*X(375)-JVS(1303)*X(377)-JVS(1304)*X(379)-JVS(1305)*X(381)&
             &-JVS(1306)*X(382)-JVS(1307)*X(383)-JVS(1308)*X(384)-JVS(1309)*X(385)-JVS(1310)*X(388)-JVS(1311)*X(390)&
             &-JVS(1312)*X(391)-JVS(1313)*X(393)-JVS(1314)*X(395))/(JVS(1299))
  X(343) = (X(343)-JVS(1284)*X(377)-JVS(1285)*X(379)-JVS(1286)*X(381)-JVS(1287)*X(382)-JVS(1288)*X(383)-JVS(1289)*X(384)&
             &-JVS(1290)*X(385)-JVS(1291)*X(388)-JVS(1292)*X(393))/(JVS(1283))
  X(342) = (X(342)-JVS(1276)*X(375)-JVS(1277)*X(378)-JVS(1278)*X(384)-JVS(1279)*X(390)-JVS(1280)*X(392)-JVS(1281)&
             &*X(393))/(JVS(1275))
  X(341) = (X(341)-JVS(1267)*X(353)-JVS(1268)*X(362)-JVS(1269)*X(365)-JVS(1270)*X(366)-JVS(1271)*X(383)-JVS(1272)*X(384)&
             &-JVS(1273)*X(388)-JVS(1274)*X(390))/(JVS(1266))
  X(340) = (X(340)-JVS(1257)*X(377)-JVS(1258)*X(378)-JVS(1259)*X(383)-JVS(1260)*X(384)-JVS(1261)*X(388)-JVS(1262)*X(390)&
             &-JVS(1263)*X(392)-JVS(1264)*X(393))/(JVS(1256))
  X(339) = (X(339)-JVS(1248)*X(359)-JVS(1249)*X(382)-JVS(1250)*X(383)-JVS(1251)*X(384)-JVS(1252)*X(390)-JVS(1253)&
             &*X(393))/(JVS(1247))
  X(338) = (X(338)-JVS(1238)*X(375)-JVS(1239)*X(377)-JVS(1240)*X(379)-JVS(1241)*X(381)-JVS(1242)*X(382)-JVS(1243)*X(383)&
             &-JVS(1244)*X(384)-JVS(1245)*X(388)-JVS(1246)*X(393))/(JVS(1237))
  X(337) = (X(337)-JVS(1208)*X(340)-JVS(1209)*X(341)-JVS(1210)*X(342)-JVS(1211)*X(343)-JVS(1212)*X(345)-JVS(1213)*X(346)&
             &-JVS(1214)*X(347)-JVS(1215)*X(349)-JVS(1216)*X(350)-JVS(1217)*X(351)-JVS(1218)*X(353)-JVS(1219)*X(357)&
             &-JVS(1220)*X(358)-JVS(1221)*X(360)-JVS(1222)*X(361)-JVS(1223)*X(362)-JVS(1224)*X(368)-JVS(1225)*X(369)&
             &-JVS(1226)*X(370)-JVS(1227)*X(378)-JVS(1228)*X(381)-JVS(1229)*X(382)-JVS(1230)*X(383)-JVS(1231)*X(384)&
             &-JVS(1232)*X(389)-JVS(1233)*X(390)-JVS(1234)*X(392))/(JVS(1207))
  X(336) = (X(336)-JVS(1197)*X(377)-JVS(1198)*X(379)-JVS(1199)*X(381)-JVS(1200)*X(382)-JVS(1201)*X(384)-JVS(1202)*X(385)&
             &-JVS(1203)*X(388))/(JVS(1196))
  X(335) = (X(335)-JVS(1188)*X(379)-JVS(1189)*X(381)-JVS(1190)*X(382)-JVS(1191)*X(383)-JVS(1192)*X(384)-JVS(1193)*X(385)&
             &-JVS(1194)*X(388)-JVS(1195)*X(393))/(JVS(1187))
  X(334) = (X(334)-JVS(1177)*X(347)-JVS(1178)*X(369)-JVS(1179)*X(370)-JVS(1180)*X(378)-JVS(1181)*X(383)-JVS(1182)*X(384)&
             &-JVS(1183)*X(389)-JVS(1184)*X(390)-JVS(1185)*X(392))/(JVS(1176))
  X(333) = (X(333)-JVS(1169)*X(361)-JVS(1170)*X(362)-JVS(1171)*X(383)-JVS(1172)*X(384)-JVS(1173)*X(388)-JVS(1174)&
             &*X(392))/(JVS(1168))
  X(332) = (X(332)-JVS(1160)*X(369)-JVS(1161)*X(370)-JVS(1162)*X(378)-JVS(1163)*X(383)-JVS(1164)*X(384)-JVS(1165)*X(389)&
             &-JVS(1166)*X(390)-JVS(1167)*X(392))/(JVS(1159))
  X(331) = (X(331)-JVS(1151)*X(360)-JVS(1152)*X(378)-JVS(1153)*X(383)-JVS(1154)*X(384)-JVS(1155)*X(390)-JVS(1156)&
             &*X(392))/(JVS(1150))
  X(330) = (X(330)-JVS(1141)*X(363)-JVS(1142)*X(375)-JVS(1143)*X(379)-JVS(1144)*X(381)-JVS(1145)*X(382)-JVS(1146)*X(384)&
             &-JVS(1147)*X(385)-JVS(1148)*X(388))/(JVS(1140))
  X(329) = (X(329)-JVS(1133)*X(376)-JVS(1134)*X(377)-JVS(1135)*X(383)-JVS(1136)*X(386)-JVS(1137)*X(388)-JVS(1138)*X(391)&
             &-JVS(1139)*X(393))/(JVS(1132))
  X(328) = (X(328)-JVS(1124)*X(363)-JVS(1125)*X(379)-JVS(1126)*X(381)-JVS(1127)*X(382)-JVS(1128)*X(384)-JVS(1129)*X(385)&
             &-JVS(1130)*X(388))/(JVS(1123))
  X(327) = (X(327)-JVS(1112)*X(351)-JVS(1113)*X(356)-JVS(1114)*X(359)-JVS(1115)*X(362)-JVS(1116)*X(378)-JVS(1117)*X(383)&
             &-JVS(1118)*X(384)-JVS(1119)*X(388)-JVS(1120)*X(390)-JVS(1121)*X(392)-JVS(1122)*X(393))/(JVS(1111))
  X(326) = (X(326)-JVS(1100)*X(349)-JVS(1101)*X(362)-JVS(1102)*X(365)-JVS(1103)*X(383)-JVS(1104)*X(384)-JVS(1105)*X(388)&
             &-JVS(1106)*X(390))/(JVS(1099))
  X(325) = (X(325)-JVS(1089)*X(371)-JVS(1090)*X(381)-JVS(1091)*X(382)-JVS(1092)*X(383)-JVS(1093)*X(387)-JVS(1094)*X(389)&
             &-JVS(1095)*X(390)-JVS(1096)*X(394)-JVS(1097)*X(395))/(JVS(1088))
  X(324) = (X(324)-JVS(1076)*X(333)-JVS(1077)*X(342)-JVS(1078)*X(345)-JVS(1079)*X(366)-JVS(1080)*X(378)-JVS(1081)*X(383)&
             &-JVS(1082)*X(384)-JVS(1083)*X(388)-JVS(1084)*X(390)-JVS(1085)*X(392))/(JVS(1075))
  X(323) = (X(323)-JVS(1069)*X(359)-JVS(1070)*X(384)-JVS(1071)*X(390)-JVS(1072)*X(392)-JVS(1073)*X(393))/(JVS(1068))
  X(322) = (X(322)-JVS(1063)*X(359)-JVS(1064)*X(383)-JVS(1065)*X(384)-JVS(1066)*X(390)-JVS(1067)*X(392))/(JVS(1062))
  X(321) = (X(321)-JVS(1053)*X(348)-JVS(1054)*X(355)-JVS(1055)*X(371)-JVS(1056)*X(373)-JVS(1057)*X(383)-JVS(1058)*X(386)&
             &-JVS(1059)*X(391)-JVS(1060)*X(392)-JVS(1061)*X(394))/(JVS(1052))
  X(320) = (X(320)-JVS(1047)*X(377)-JVS(1048)*X(383)-JVS(1049)*X(388)-JVS(1050)*X(393))/(JVS(1046))
  X(319) = (X(319)-JVS(1042)*X(383)-JVS(1043)*X(388)-JVS(1044)*X(393))/(JVS(1041))
  X(318) = (X(318)-JVS(1036)*X(341)-JVS(1037)*X(382)-JVS(1038)*X(383)-JVS(1039)*X(384)-JVS(1040)*X(390))/(JVS(1035))
  X(317) = (X(317)-JVS(1029)*X(371)-JVS(1030)*X(381)-JVS(1031)*X(382)-JVS(1032)*X(389)-JVS(1033)*X(394))/(JVS(1028))
  X(316) = (X(316)-JVS(1018)*X(329)-JVS(1019)*X(380)-JVS(1020)*X(383)-JVS(1021)*X(386)-JVS(1022)*X(387)-JVS(1023)*X(388)&
             &-JVS(1024)*X(390)-JVS(1025)*X(391)-JVS(1026)*X(394)-JVS(1027)*X(395))/(JVS(1017))
  X(315) = (X(315)-JVS(1012)*X(339)-JVS(1013)*X(360)-JVS(1014)*X(382)-JVS(1015)*X(383)-JVS(1016)*X(388))/(JVS(1011))
  X(314) = (X(314)-JVS(1007)*X(362)-JVS(1008)*X(378)-JVS(1009)*X(384)-JVS(1010)*X(390))/(JVS(1006))
  X(313) = (X(313)-JVS(1002)*X(362)-JVS(1003)*X(383)-JVS(1004)*X(384)-JVS(1005)*X(390))/(JVS(1001))
  X(312) = (X(312)-JVS(985)*X(331)-JVS(986)*X(332)-JVS(987)*X(340)-JVS(988)*X(345)-JVS(989)*X(346)-JVS(990)*X(347)&
             &-JVS(991)*X(349)-JVS(992)*X(351)-JVS(993)*X(353)-JVS(994)*X(358)-JVS(995)*X(362)-JVS(996)*X(369)-JVS(997)&
             &*X(383)-JVS(998)*X(392))/(JVS(984))
  X(311) = (X(311)-JVS(978)*X(351)-JVS(979)*X(378)-JVS(980)*X(383)-JVS(981)*X(384)-JVS(982)*X(388)-JVS(983)*X(390))&
             &/(JVS(977))
  X(310) = (X(310)-JVS(972)*X(362)-JVS(973)*X(383)-JVS(974)*X(384)-JVS(975)*X(388))/(JVS(971))
  X(309) = (X(309)-JVS(966)*X(342)-JVS(967)*X(365)-JVS(968)*X(366)-JVS(969)*X(383)-JVS(970)*X(390))/(JVS(965))
  X(308) = (X(308)-JVS(960)*X(322)-JVS(961)*X(323)-JVS(962)*X(361)-JVS(963)*X(383)-JVS(964)*X(390))/(JVS(959))
  X(307) = (X(307)-JVS(948)*X(313)-JVS(949)*X(318)-JVS(950)*X(326)-JVS(951)*X(338)-JVS(952)*X(356)-JVS(953)*X(366)&
             &-JVS(954)*X(368)-JVS(955)*X(381)-JVS(956)*X(383)-JVS(957)*X(384)-JVS(958)*X(390))/(JVS(947))
  X(306) = (X(306)-JVS(943)*X(381)-JVS(944)*X(382)-JVS(945)*X(393)-JVS(946)*X(394))/(JVS(942))
  X(305) = (X(305)-JVS(937)*X(353)-JVS(938)*X(367)-JVS(939)*X(381)-JVS(940)*X(383)-JVS(941)*X(390))/(JVS(936))
  X(304) = (X(304)-JVS(931)*X(351)-JVS(932)*X(378)-JVS(933)*X(383)-JVS(934)*X(384)-JVS(935)*X(388))/(JVS(930))
  X(303) = (X(303)-JVS(925)*X(351)-JVS(926)*X(378)-JVS(927)*X(383)-JVS(928)*X(384)-JVS(929)*X(390))/(JVS(924))
  X(302) = (X(302)-JVS(920)*X(349)-JVS(921)*X(383)-JVS(922)*X(390))/(JVS(919))
  X(301) = (X(301)-JVS(915)*X(346)-JVS(916)*X(357)-JVS(917)*X(383)-JVS(918)*X(390))/(JVS(914))
  X(300) = (X(300)-JVS(911)*X(362)-JVS(912)*X(383)-JVS(913)*X(390))/(JVS(910))
  X(299) = (X(299)-JVS(907)*X(351)-JVS(908)*X(383)-JVS(909)*X(390))/(JVS(906))
  X(298) = (X(298)-JVS(903)*X(383)-JVS(904)*X(389)-JVS(905)*X(393))/(JVS(902))
  X(297) = (X(297)-JVS(897)*X(311)-JVS(898)*X(314)-JVS(899)*X(369)-JVS(900)*X(383)-JVS(901)*X(390))/(JVS(896))
  X(296) = (X(296)-JVS(893)*X(345)-JVS(894)*X(383)-JVS(895)*X(390))/(JVS(892))
  X(295) = (X(295)-JVS(889)*X(340)-JVS(890)*X(383)-JVS(891)*X(390))/(JVS(888))
  X(294) = (X(294)-JVS(879)*X(328)-JVS(880)*X(330)-JVS(881)*X(335)-JVS(882)*X(336)-JVS(883)*X(338)-JVS(884)*X(343)&
             &-JVS(885)*X(367)-JVS(886)*X(379)-JVS(887)*X(383))/(JVS(878))
  X(293) = (X(293)-JVS(872)*X(317)-JVS(873)*X(325)-JVS(874)*X(371)-JVS(875)*X(383)-JVS(876)*X(387)-JVS(877)*X(389))&
             &/(JVS(871))
  X(292) = (X(292)-JVS(865)*X(333)-JVS(866)*X(366)-JVS(867)*X(383)-JVS(868)*X(384)-JVS(869)*X(388)-JVS(870)*X(390))&
             &/(JVS(864))
  X(291) = (X(291)-JVS(860)*X(339)-JVS(861)*X(352)-JVS(862)*X(383)-JVS(863)*X(390))/(JVS(859))
  X(290) = (X(290)-JVS(851)*X(317)-JVS(852)*X(325)-JVS(853)*X(348)-JVS(854)*X(355)-JVS(855)*X(371)-JVS(856)*X(373)&
             &-JVS(857)*X(387)-JVS(858)*X(394))/(JVS(850))
  X(289) = (X(289)-JVS(847)*X(383)-JVS(848)*X(390)-JVS(849)*X(392))/(JVS(846))
  X(288) = (X(288)-JVS(843)*X(360)-JVS(844)*X(383)-JVS(845)*X(390))/(JVS(842))
  X(287) = (X(287)-JVS(839)*X(382)-JVS(840)*X(383)-JVS(841)*X(390))/(JVS(838))
  X(286) = (X(286)-JVS(833)*X(371)-JVS(834)*X(373)-JVS(835)*X(383)-JVS(836)*X(391)-JVS(837)*X(392))/(JVS(832))
  X(285) = (X(285)-JVS(829)*X(383)-JVS(830)*X(386))/(JVS(828))
  X(284) = (X(284)-JVS(826)*X(383)-JVS(827)*X(391))/(JVS(825))
  X(283) = (X(283)-JVS(823)*X(383)-JVS(824)*X(393))/(JVS(822))
  X(282) = (X(282)-JVS(819)*X(347)-JVS(820)*X(383)-JVS(821)*X(390))/(JVS(818))
  X(281) = (X(281)-JVS(815)*X(332)-JVS(816)*X(383)-JVS(817)*X(390))/(JVS(814))
  X(280) = (X(280)-JVS(811)*X(382)-JVS(812)*X(383)-JVS(813)*X(384))/(JVS(810))
  X(279) = (X(279)-JVS(807)*X(350)-JVS(808)*X(383)-JVS(809)*X(390))/(JVS(806))
  X(278) = (X(278)-JVS(804)*X(383)-JVS(805)*X(389))/(JVS(803))
  X(277) = (X(277)-JVS(801)*X(383)-JVS(802)*X(386))/(JVS(800))
  X(276) = (X(276)-JVS(798)*X(383)-JVS(799)*X(386))/(JVS(797))
  X(275) = (X(275)-JVS(795)*X(383)-JVS(796)*X(386))/(JVS(794))
  X(274) = (X(274)-JVS(792)*X(383)-JVS(793)*X(386))/(JVS(791))
  X(273) = (X(273)-JVS(788)*X(306)-JVS(789)*X(383)-JVS(790)*X(394))/(JVS(787))
  X(272) = (X(272)-JVS(784)*X(371)-JVS(785)*X(373)-JVS(786)*X(383))/(JVS(783))
  X(271) = (X(271)-JVS(781)*X(382)-JVS(782)*X(392))/(JVS(780))
  X(270) = (X(270)-JVS(778)*X(383)-JVS(779)*X(386))/(JVS(777))
  X(269) = (X(269)-JVS(775)*X(383)-JVS(776)*X(386))/(JVS(774))
  X(268) = (X(268)-JVS(772)*X(373)-JVS(773)*X(383))/(JVS(771))
  X(267) = (X(267)-JVS(768)*X(378)-JVS(769)*X(383)-JVS(770)*X(390))/(JVS(767))
  X(266) = (X(266)-JVS(765)*X(378)-JVS(766)*X(382))/(JVS(764))
  X(265) = (X(265)-JVS(762)*X(382)-JVS(763)*X(384))/(JVS(761))
  X(264) = (X(264)-JVS(759)*X(383)-JVS(760)*X(393))/(JVS(758))
  X(263) = (X(263)-JVS(756)*X(383)-JVS(757)*X(395))/(JVS(755))
  X(262) = (X(262)-JVS(752)*X(383)-JVS(753)*X(384)-JVS(754)*X(390))/(JVS(751))
  X(261) = (X(261)-JVS(747)*X(383)-JVS(748)*X(384)-JVS(749)*X(390))/(JVS(746))
  X(260) = (X(260)-JVS(742)*X(265)-JVS(743)*X(382)-JVS(744)*X(386))/(JVS(741))
  X(259) = (X(259)-JVS(740)*X(386))/(JVS(739))
  X(258) = (X(258)-JVS(736)*X(383)-JVS(737)*X(384)-JVS(738)*X(390))/(JVS(735))
  X(257) = (X(257)-JVS(732)*X(352)-JVS(733)*X(382))/(JVS(731))
  X(256) = (X(256)-JVS(730)*X(386))/(JVS(729))
  X(255) = (X(255)-JVS(728)*X(386))/(JVS(727))
  X(254) = (X(254)-JVS(726)*X(386))/(JVS(725))
  X(253) = (X(253)-JVS(724)*X(386))/(JVS(723))
  X(252) = (X(252)-JVS(722)*X(386))/(JVS(721))
  X(251) = (X(251)-JVS(720)*X(386))/(JVS(719))
  X(250) = (X(250)-JVS(718)*X(386))/(JVS(717))
  X(249) = (X(249)-JVS(716)*X(386))/(JVS(715))
  X(248) = (X(248)-JVS(713)*X(318)-JVS(714)*X(382))/(JVS(712))
  X(247) = (X(247)-JVS(710)*X(300)-JVS(711)*X(383))/(JVS(709))
  X(246) = (X(246)-JVS(707)*X(382)-JVS(708)*X(389))/(JVS(706))
  X(245) = (X(245)-JVS(705)*X(383))/(JVS(704))
  X(244) = (X(244)-JVS(703)*X(383))/(JVS(702))
  X(243) = (X(243)-JVS(701)*X(383))/(JVS(700))
  X(242) = (X(242)-JVS(699)*X(383))/(JVS(698))
  X(241) = (X(241)-JVS(696)*X(328)-JVS(697)*X(379))/(JVS(695))
  X(240) = (X(240)-JVS(693)*X(343)-JVS(694)*X(379))/(JVS(692))
  X(239) = (X(239)-JVS(690)*X(336)-JVS(691)*X(379))/(JVS(689))
  X(238) = (X(238)-JVS(687)*X(330)-JVS(688)*X(379))/(JVS(686))
  X(237) = (X(237)-JVS(684)*X(335)-JVS(685)*X(379))/(JVS(683))
  X(236) = (X(236)-JVS(681)*X(367)-JVS(682)*X(379))/(JVS(680))
  X(235) = (X(235)-JVS(678)*X(338)-JVS(679)*X(379))/(JVS(677))
  X(234) = (X(234)-JVS(675)*X(379)-JVS(676)*X(383))/(JVS(674))
  X(233) = (X(233)-JVS(672)*X(328)-JVS(673)*X(385))/(JVS(671))
  X(232) = (X(232)-JVS(669)*X(343)-JVS(670)*X(385))/(JVS(668))
  X(231) = (X(231)-JVS(666)*X(336)-JVS(667)*X(385))/(JVS(665))
  X(230) = (X(230)-JVS(663)*X(330)-JVS(664)*X(385))/(JVS(662))
  X(229) = (X(229)-JVS(660)*X(335)-JVS(661)*X(385))/(JVS(659))
  X(228) = (X(228)-JVS(657)*X(367)-JVS(658)*X(385))/(JVS(656))
  X(227) = (X(227)-JVS(654)*X(383)-JVS(655)*X(385))/(JVS(653))
  X(226) = (X(226)-JVS(652)*X(263))/(JVS(651))
  X(225) = (X(225)-JVS(650)*X(324))/(JVS(649))
  X(224) = (X(224)-JVS(648)*X(341))/(JVS(647))
  X(223) = (X(223)-JVS(646)*X(305))/(JVS(645))
  X(222) = (X(222)-JVS(644)*X(299))/(JVS(643))
  X(221) = (X(221)-JVS(642)*X(375))/(JVS(641))
  X(220) = (X(220)-JVS(640)*X(377))/(JVS(639))
  X(219) = (X(219)-JVS(638)*X(377))/(JVS(637))
  X(218) = (X(218)-JVS(636)*X(364))/(JVS(635))
  X(217) = (X(217)-JVS(634)*X(327))/(JVS(633))
  X(216) = (X(216)-JVS(632)*X(327))/(JVS(631))
  X(215) = (X(215)-JVS(630)*X(327))/(JVS(629))
  X(214) = (X(214)-JVS(628)*X(356))/(JVS(627))
  X(213) = (X(213)-JVS(626)*X(334))/(JVS(625))
  X(212) = (X(212)-JVS(624)*X(372))/(JVS(623))
  X(211) = (X(211)-JVS(622)*X(376))/(JVS(621))
  X(210) = (X(210)-JVS(620)*X(376))/(JVS(619))
  X(209) = (X(209)-JVS(618)*X(380))/(JVS(617))
  X(208) = (X(208)-JVS(616)*X(380))/(JVS(615))
  X(207) = (X(207)-JVS(613)*X(284)-JVS(614)*X(391))/(JVS(612))
  X(206) = (X(206)-JVS(610)*X(380)-JVS(611)*X(391))/(JVS(609))
  X(205) = (X(205)-JVS(607)*X(303)-JVS(608)*X(383))/(JVS(606))
  X(204) = (X(204)-JVS(604)*X(278)-JVS(605)*X(389))/(JVS(603))
  X(203) = (X(203)-JVS(601)*X(298)-JVS(602)*X(389))/(JVS(600))
  X(202) = (X(202)-JVS(598)*X(334)-JVS(599)*X(389))/(JVS(597))
  X(201) = (X(201)-JVS(595)*X(376)-JVS(596)*X(389))/(JVS(594))
  X(200) = (X(200)-JVS(592)*X(380)-JVS(593)*X(389))/(JVS(591))
  X(199) = (X(199)-JVS(589)*X(342)-JVS(590)*X(378))/(JVS(588))
  X(198) = (X(198)-JVS(586)*X(353)-JVS(587)*X(378))/(JVS(585))
  X(197) = (X(197)-JVS(583)*X(351)-JVS(584)*X(378))/(JVS(582))
  X(196) = (X(196)-JVS(580)*X(313)-JVS(581)*X(390))/(JVS(579))
  X(195) = (X(195)-JVS(577)*X(368)-JVS(578)*X(383))/(JVS(576))
  X(194) = (X(194)-JVS(574)*X(364)-JVS(575)*X(383))/(JVS(573))
  X(193) = (X(193)-JVS(571)*X(327)-JVS(572)*X(383))/(JVS(570))
  X(192) = (X(192)-JVS(568)*X(356)-JVS(569)*X(383))/(JVS(567))
  X(191) = (X(191)-JVS(565)*X(356)-JVS(566)*X(383))/(JVS(564))
  X(190) = (X(190)-JVS(562)*X(315)-JVS(563)*X(383))/(JVS(561))
  X(189) = (X(189)-JVS(559)*X(342)-JVS(560)*X(392))/(JVS(558))
  X(188) = (X(188)-JVS(556)*X(353)-JVS(557)*X(392))/(JVS(555))
  X(187) = (X(187)-JVS(553)*X(351)-JVS(554)*X(392))/(JVS(552))
  X(186) = (X(186)-JVS(550)*X(342)-JVS(551)*X(390))/(JVS(549))
  X(185) = (X(185)-JVS(548)*X(353))/(JVS(547))
  X(184) = (X(184)-JVS(545)*X(376)-JVS(546)*X(383))/(JVS(544))
  X(183) = (X(183)-JVS(542)*X(380)-JVS(543)*X(383))/(JVS(541))
  X(182) = (X(182)-JVS(540)*X(355))/(JVS(539))
  X(181) = (X(181)-JVS(538)*X(268))/(JVS(537))
  X(180) = (X(180)-JVS(536)*X(325))/(JVS(535))
  X(179) = (X(179)-JVS(534)*X(393))/(JVS(533))
  X(178) = (X(178)-JVS(531)*X(325)-JVS(532)*X(394))/(JVS(530))
  X(177) = (X(177)-JVS(528)*X(355)-JVS(529)*X(387))/(JVS(527))
  X(176) = (X(176)-JVS(525)*X(355)-JVS(526)*X(394))/(JVS(524))
  X(175) = (X(175)-JVS(522)*X(317)-JVS(523)*X(394))/(JVS(521))
  X(174) = (X(174)-JVS(519)*X(348)-JVS(520)*X(387))/(JVS(518))
  X(173) = (X(173)-JVS(516)*X(348)-JVS(517)*X(394))/(JVS(515))
  X(172) = (X(172)-JVS(513)*X(306)-JVS(514)*X(394))/(JVS(512))
  X(171) = (X(171)-JVS(510)*X(371)-JVS(511)*X(373))/(JVS(509))
  X(170) = (X(170)-JVS(507)*X(371)-JVS(508)*X(373))/(JVS(506))
  X(169) = (X(169)-JVS(505)*X(373))/(JVS(504))
  X(168) = (X(168)-JVS(503)*X(373))/(JVS(502))
  X(167) = (X(167)-JVS(500)*X(373)-JVS(501)*X(395))/(JVS(499))
  X(166) = (X(166)-JVS(497)*X(268)-JVS(498)*X(383))/(JVS(496))
  X(165) = (X(165)-JVS(494)*X(272)-JVS(495)*X(383))/(JVS(493))
  X(164) = (X(164)-JVS(491)*X(373)-JVS(492)*X(383))/(JVS(490))
  X(163) = (X(163)-JVS(488)*X(373)-JVS(489)*X(383))/(JVS(487))
  X(162) = (X(162)-JVS(485)*X(373)-JVS(486)*X(392))/(JVS(484))
  X(161) = (X(161)-JVS(482)*X(274)-JVS(483)*X(386))/(JVS(481))
  X(160) = (X(160)-JVS(479)*X(285)-JVS(480)*X(386))/(JVS(478))
  X(159) = (X(159)-JVS(476)*X(386)-JVS(477)*X(387))/(JVS(475))
  X(158) = (X(158)-JVS(473)*X(386)-JVS(474)*X(394))/(JVS(472))
  X(157) = (X(157)-JVS(470)*X(380)-JVS(471)*X(395))/(JVS(469))
  X(156) = (X(156)-JVS(467)*X(371)-JVS(468)*X(395))/(JVS(466))
  X(155) = (X(155)-JVS(464)*X(316)-JVS(465)*X(388))/(JVS(463))
  X(154) = (X(154)-JVS(461)*X(344)-JVS(462)*X(395))/(JVS(460))
  X(153) = (X(153)-JVS(458)*X(393)-JVS(459)*X(395))/(JVS(457))
  X(152) = (X(152)-JVS(455)*X(382)-JVS(456)*X(395))/(JVS(454))
  X(151) = (X(151)-JVS(452)*X(263)-JVS(453)*X(395))/(JVS(451))
  X(150) = (X(150)-JVS(449)*X(386)-JVS(450)*X(388))/(JVS(448))
  X(149) = (X(149)-JVS(446)*X(390)-JVS(447)*X(395))/(JVS(445))
  X(148) = (X(148)-JVS(443)*X(383)-JVS(444)*X(395))/(JVS(442))
  X(147) = (X(147)-JVS(440)*X(388)-JVS(441)*X(395))/(JVS(439))
  X(146) = (X(146)-JVS(437)*X(329)-JVS(438)*X(386))/(JVS(436))
  X(145) = (X(145)-JVS(434)*X(329)-JVS(435)*X(386))/(JVS(433))
  X(144) = (X(144)-JVS(431)*X(329)-JVS(432)*X(386))/(JVS(430))
  X(143) = (X(143)-JVS(428)*X(260)-JVS(429)*X(386))/(JVS(427))
  X(142) = (X(142)-JVS(425)*X(260)-JVS(426)*X(386))/(JVS(424))
  X(141) = (X(141)-JVS(423)*X(386))/(JVS(422))
  X(140) = (X(140)-JVS(420)*X(381)-JVS(421)*X(386))/(JVS(419))
  X(139) = (X(139)-JVS(417)*X(304)-JVS(418)*X(388))/(JVS(416))
  X(138) = (X(138)-JVS(414)*X(318)-JVS(415)*X(382))/(JVS(413))
  X(137) = (X(137)-JVS(411)*X(309)-JVS(412)*X(383))/(JVS(410))
  X(136) = (X(136)-JVS(408)*X(310)-JVS(409)*X(383))/(JVS(407))
  X(135) = (X(135)-JVS(405)*X(333)-JVS(406)*X(383))/(JVS(404))
  X(134) = (X(134)-JVS(403)*X(325))/(JVS(402))
  X(133) = (X(133)-JVS(401)*X(325))/(JVS(400))
  X(132) = (X(132)-JVS(398)*X(371)-JVS(399)*X(383))/(JVS(397))
  X(131) = (X(131)-JVS(395)*X(387)-JVS(396)*X(395))/(JVS(394))
  X(130) = (X(130)-JVS(392)*X(325)-JVS(393)*X(395))/(JVS(391))
  X(129) = (X(129)-JVS(390)*X(371))/(JVS(389))
  X(128) = (X(128)-JVS(388)*X(371))/(JVS(387))
  X(127) = (X(127)-JVS(385)*X(283)-JVS(386)*X(393))/(JVS(384))
  X(126) = (X(126)-JVS(382)*X(306)-JVS(383)*X(381))/(JVS(381))
  X(125) = (X(125)-JVS(380)*X(393))/(JVS(379))
  X(124) = (X(124)-JVS(378)*X(382))/(JVS(377))
  X(123) = (X(123)-JVS(375)*X(333)-JVS(376)*X(388))/(JVS(374))
  X(122) = (X(122)-JVS(372)*X(310)-JVS(373)*X(388))/(JVS(371))
  X(121) = (X(121)-JVS(370)*X(393))/(JVS(369))
  X(120) = (X(120)-JVS(367)*X(363)-JVS(368)*X(388))/(JVS(366))
  X(119) = (X(119)-JVS(364)*X(298)-JVS(365)*X(393))/(JVS(363))
  X(118) = (X(118)-JVS(361)*X(375)-JVS(362)*X(393))/(JVS(360))
  X(117) = (X(117)-JVS(358)*X(375)-JVS(359)*X(393))/(JVS(357))
  X(116) = (X(116)-JVS(355)*X(319)-JVS(356)*X(393))/(JVS(354))
  X(115) = (X(115)-JVS(352)*X(375)-JVS(353)*X(388))/(JVS(351))
  X(114) = (X(114)-JVS(349)*X(377)-JVS(350)*X(388))/(JVS(348))
  X(113) = (X(113)-JVS(346)*X(319)-JVS(347)*X(388))/(JVS(345))
  X(112) = (X(112)-JVS(343)*X(364)-JVS(344)*X(393))/(JVS(342))
  X(111) = (X(111)-JVS(340)*X(327)-JVS(341)*X(393))/(JVS(339))
  X(110) = (X(110)-JVS(337)*X(320)-JVS(338)*X(393))/(JVS(336))
  X(109) = (X(109)-JVS(334)*X(320)-JVS(335)*X(388))/(JVS(333))
  X(108) = (X(108)-JVS(331)*X(374)-JVS(332)*X(393))/(JVS(330))
  X(107) = (X(107)-JVS(328)*X(372)-JVS(329)*X(393))/(JVS(327))
  X(106) = (X(106)-JVS(325)*X(264)-JVS(326)*X(393))/(JVS(324))
  X(105) = (X(105)-JVS(322)*X(322)-JVS(323)*X(392))/(JVS(321))
  X(104) = (X(104)-JVS(319)*X(322)-JVS(320)*X(384))/(JVS(318))
  X(103) = (X(103)-JVS(316)*X(359)-JVS(317)*X(388))/(JVS(315))
  X(102) = (X(102)-JVS(313)*X(339)-JVS(314)*X(390))/(JVS(312))
  X(101) = (X(101)-JVS(310)*X(339)-JVS(311)*X(382))/(JVS(309))
  X(100) = (X(100)-JVS(307)*X(339)-JVS(308)*X(393))/(JVS(306))
  X(99) = (X(99)-JVS(304)*X(359)-JVS(305)*X(393))/(JVS(303))
  X(98) = (X(98)-JVS(301)*X(361)-JVS(302)*X(393))/(JVS(300))
  X(97) = (X(97)-JVS(298)*X(376)-JVS(299)*X(393))/(JVS(297))
  X(96) = (X(96)-JVS(295)*X(380)-JVS(296)*X(393))/(JVS(294))
  X(95) = (X(95)-JVS(292)*X(382)-JVS(293)*X(393))/(JVS(291))
  X(94) = (X(94)-JVS(289)*X(383)-JVS(290)*X(393))/(JVS(288))
  X(93) = (X(93)-JVS(286)*X(390)-JVS(287)*X(393))/(JVS(285))
  X(92) = (X(92)-JVS(283)*X(388)-JVS(284)*X(392))/(JVS(282))
  X(91) = (X(91)-JVS(280)*X(388)-JVS(281)*X(390))/(JVS(279))
  X(90) = (X(90)-JVS(277)*X(383)-JVS(278)*X(388))/(JVS(276))
  X(89) = (X(89)-JVS(275)*X(384))/(JVS(274))
  X(88) = (X(88)-JVS(273)*X(260))/(JVS(272))
  X(87) = (X(87)-JVS(271)*X(271))/(JVS(270))
  X(86) = (X(86)-JVS(269)*X(266))/(JVS(268))
  X(85) = (X(85)-JVS(267)*X(287))/(JVS(266))
  X(84) = X(84)/JVS(265)
  X(83) = (X(83)-JVS(263)*X(286)-JVS(264)*X(391))/(JVS(262))
  X(82) = (X(82)-JVS(260)*X(390)-JVS(261)*X(391))/(JVS(259))
  X(81) = (X(81)-JVS(257)*X(348)-JVS(258)*X(383))/(JVS(256))
  X(80) = (X(80)-JVS(254)*X(273)-JVS(255)*X(383))/(JVS(253))
  X(79) = (X(79)-JVS(251)*X(321)-JVS(252)*X(383))/(JVS(250))
  X(78) = (X(78)-JVS(248)*X(265)-JVS(249)*X(384))/(JVS(247))
  X(77) = (X(77)-JVS(246)*X(265))/(JVS(245))
  X(76) = (X(76)-JVS(243)*X(316)-JVS(244)*X(390))/(JVS(242))
  X(75) = (X(75)-JVS(240)*X(328)-JVS(241)*X(382))/(JVS(239))
  X(74) = (X(74)-JVS(237)*X(328)-JVS(238)*X(384))/(JVS(236))
  X(73) = (X(73)-JVS(234)*X(343)-JVS(235)*X(382))/(JVS(233))
  X(72) = (X(72)-JVS(231)*X(343)-JVS(232)*X(384))/(JVS(230))
  X(71) = (X(71)-JVS(228)*X(336)-JVS(229)*X(382))/(JVS(227))
  X(70) = (X(70)-JVS(225)*X(336)-JVS(226)*X(384))/(JVS(224))
  X(69) = (X(69)-JVS(222)*X(330)-JVS(223)*X(382))/(JVS(221))
  X(68) = (X(68)-JVS(219)*X(330)-JVS(220)*X(384))/(JVS(218))
  X(67) = (X(67)-JVS(216)*X(335)-JVS(217)*X(382))/(JVS(215))
  X(66) = (X(66)-JVS(213)*X(335)-JVS(214)*X(384))/(JVS(212))
  X(65) = (X(65)-JVS(210)*X(367)-JVS(211)*X(382))/(JVS(209))
  X(64) = (X(64)-JVS(207)*X(367)-JVS(208)*X(384))/(JVS(206))
  X(63) = (X(63)-JVS(204)*X(338)-JVS(205)*X(382))/(JVS(203))
  X(62) = (X(62)-JVS(201)*X(338)-JVS(202)*X(384))/(JVS(200))
  X(61) = (X(61)-JVS(198)*X(311)-JVS(199)*X(384))/(JVS(197))
  X(60) = (X(60)-JVS(195)*X(311)-JVS(196)*X(384))/(JVS(194))
  X(59) = (X(59)-JVS(192)*X(314)-JVS(193)*X(384))/(JVS(191))
  X(58) = (X(58)-JVS(189)*X(314)-JVS(190)*X(384))/(JVS(188))
  X(57) = (X(57)-JVS(187)*X(248))/(JVS(186))
  X(56) = (X(56)-JVS(184)*X(318)-JVS(185)*X(390))/(JVS(183))
  X(55) = (X(55)-JVS(181)*X(318)-JVS(182)*X(384))/(JVS(180))
  X(54) = (X(54)-JVS(178)*X(326)-JVS(179)*X(383))/(JVS(177))
  X(53) = (X(53)-JVS(175)*X(365)-JVS(176)*X(390))/(JVS(174))
  X(52) = (X(52)-JVS(172)*X(365)-JVS(173)*X(384))/(JVS(171))
  X(51) = (X(51)-JVS(169)*X(365)-JVS(170)*X(384))/(JVS(168))
  X(50) = (X(50)-JVS(166)*X(366)-JVS(167)*X(390))/(JVS(165))
  X(49) = (X(49)-JVS(163)*X(366)-JVS(164)*X(384))/(JVS(162))
  X(48) = (X(48)-JVS(160)*X(366)-JVS(161)*X(384))/(JVS(159))
  X(47) = (X(47)-JVS(157)*X(351)-JVS(158)*X(384))/(JVS(156))
  X(46) = (X(46)-JVS(154)*X(351)-JVS(155)*X(384))/(JVS(153))
  X(45) = (X(45)-JVS(151)*X(293)-JVS(152)*X(383))/(JVS(150))
  X(44) = (X(44)-JVS(148)*X(331)-JVS(149)*X(384))/(JVS(147))
  X(43) = (X(43)-JVS(145)*X(331)-JVS(146)*X(384))/(JVS(144))
  X(42) = (X(42)-JVS(142)*X(313)-JVS(143)*X(384))/(JVS(141))
  X(41) = (X(41)-JVS(139)*X(360)-JVS(140)*X(390))/(JVS(138))
  X(40) = (X(40)-JVS(136)*X(352)-JVS(137)*X(390))/(JVS(135))
  X(39) = (X(39)-JVS(133)*X(378)-JVS(134)*X(390))/(JVS(132))
  X(38) = (X(38)-JVS(130)*X(360)-JVS(131)*X(384))/(JVS(129))
  X(37) = (X(37)-JVS(127)*X(352)-JVS(128)*X(384))/(JVS(126))
  X(36) = (X(36)-JVS(124)*X(345)-JVS(125)*X(384))/(JVS(123))
  X(35) = (X(35)-JVS(121)*X(323)-JVS(122)*X(392))/(JVS(120))
  X(34) = (X(34)-JVS(118)*X(323)-JVS(119)*X(384))/(JVS(117))
  X(33) = (X(33)-JVS(115)*X(339)-JVS(116)*X(384))/(JVS(114))
  X(32) = (X(32)-JVS(112)*X(361)-JVS(113)*X(384))/(JVS(111))
  X(31) = (X(31)-JVS(109)*X(347)-JVS(110)*X(384))/(JVS(108))
  X(30) = (X(30)-JVS(106)*X(342)-JVS(107)*X(384))/(JVS(105))
  X(29) = (X(29)-JVS(103)*X(353)-JVS(104)*X(384))/(JVS(102))
  X(28) = (X(28)-JVS(100)*X(349)-JVS(101)*X(384))/(JVS(99))
  X(27) = (X(27)-JVS(97)*X(362)-JVS(98)*X(384))/(JVS(96))
  X(26) = (X(26)-JVS(94)*X(346)-JVS(95)*X(384))/(JVS(93))
  X(25) = (X(25)-JVS(91)*X(357)-JVS(92)*X(384))/(JVS(90))
  X(24) = (X(24)-JVS(88)*X(358)-JVS(89)*X(384))/(JVS(87))
  X(23) = (X(23)-JVS(85)*X(369)-JVS(86)*X(384))/(JVS(84))
  X(22) = (X(22)-JVS(82)*X(369)-JVS(83)*X(384))/(JVS(81))
  X(21) = (X(21)-JVS(79)*X(340)-JVS(80)*X(384))/(JVS(78))
  X(20) = (X(20)-JVS(76)*X(332)-JVS(77)*X(384))/(JVS(75))
  X(19) = (X(19)-JVS(73)*X(350)-JVS(74)*X(384))/(JVS(72))
  X(18) = (X(18)-JVS(70)*X(378)-JVS(71)*X(384))/(JVS(69))
  X(17) = (X(17)-JVS(67)*X(280)-JVS(68)*X(383))/(JVS(66))
  X(16) = (X(16)-JVS(64)*X(354)-JVS(65)*X(383))/(JVS(63))
  X(15) = (X(15)-JVS(61)*X(384)-JVS(62)*X(392))/(JVS(60))
  X(14) = (X(14)-JVS(58)*X(384)-JVS(59)*X(390))/(JVS(57))
  X(13) = (X(13)-JVS(56)*X(383))/(JVS(55))
  X(12) = (X(12)-JVS(33)*X(263)-JVS(34)*X(292)-JVS(35)*X(304)-JVS(36)*X(305)-JVS(37)*X(307)-JVS(38)*X(311)-JVS(39)&
            &*X(313)-JVS(40)*X(318)-JVS(41)*X(331)-JVS(42)*X(337)-JVS(43)*X(342)-JVS(44)*X(356)-JVS(45)*X(360)-JVS(46)&
            &*X(362)-JVS(47)*X(368)-JVS(48)*X(378)-JVS(49)*X(383)-JVS(50)*X(384)-JVS(51)*X(385)-JVS(52)*X(388)-JVS(53)&
            &*X(390)-JVS(54)*X(392))/(JVS(32))
  X(11) = (X(11)-JVS(30)*X(326)-JVS(31)*X(383))/(JVS(29))
  X(10) = (X(10)-JVS(27)*X(258)-JVS(28)*X(384))/(JVS(26))
  X(9) = (X(9)-JVS(24)*X(258)-JVS(25)*X(390))/(JVS(23))
  X(8) = (X(8)-JVS(21)*X(262)-JVS(22)*X(384))/(JVS(20))
  X(7) = (X(7)-JVS(18)*X(262)-JVS(19)*X(390))/(JVS(17))
  X(6) = (X(6)-JVS(15)*X(261)-JVS(16)*X(384))/(JVS(14))
  X(5) = (X(5)-JVS(12)*X(261)-JVS(13)*X(390))/(JVS(11))
  X(4) = (X(4)-JVS(9)*X(319)-JVS(10)*X(393))/(JVS(8))
  X(3) = (X(3)-JVS(6)*X(319)-JVS(7)*X(383))/(JVS(5))
  X(2) = (X(2)-JVS(3)*X(283)-JVS(4)*X(383))/(JVS(2))
  X(1) = X(1)/JVS(1)
      
END SUBROUTINE KppSolve

! End of KppSolve function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! KppSolveTR - sparse, transposed back substitution
!   Arguments :
!      JVS       - sparse Jacobian of variables
!      X         - Vector for variables
!      XX        - Vector for output variables
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE KppSolveTR ( JVS, X, XX )

! JVS - sparse Jacobian of variables
  REAL(kind=dp) :: JVS(LU_NONZERO)
! X - Vector for variables
  REAL(kind=dp) :: X(NVAR)
! XX - Vector for output variables
  REAL(kind=dp) :: XX(NVAR)

  XX(1) = X(1)/JVS(1)
  XX(2) = X(2)/JVS(2)
  XX(3) = X(3)/JVS(5)
  XX(4) = X(4)/JVS(8)
  XX(5) = X(5)/JVS(11)
  XX(6) = X(6)/JVS(14)
  XX(7) = X(7)/JVS(17)
  XX(8) = X(8)/JVS(20)
  XX(9) = X(9)/JVS(23)
  XX(10) = X(10)/JVS(26)
  XX(11) = X(11)/JVS(29)
  XX(12) = X(12)/JVS(32)
  XX(13) = X(13)/JVS(55)
  XX(14) = X(14)/JVS(57)
  XX(15) = X(15)/JVS(60)
  XX(16) = X(16)/JVS(63)
  XX(17) = X(17)/JVS(66)
  XX(18) = X(18)/JVS(69)
  XX(19) = X(19)/JVS(72)
  XX(20) = X(20)/JVS(75)
  XX(21) = X(21)/JVS(78)
  XX(22) = X(22)/JVS(81)
  XX(23) = X(23)/JVS(84)
  XX(24) = X(24)/JVS(87)
  XX(25) = X(25)/JVS(90)
  XX(26) = X(26)/JVS(93)
  XX(27) = X(27)/JVS(96)
  XX(28) = X(28)/JVS(99)
  XX(29) = X(29)/JVS(102)
  XX(30) = X(30)/JVS(105)
  XX(31) = X(31)/JVS(108)
  XX(32) = X(32)/JVS(111)
  XX(33) = X(33)/JVS(114)
  XX(34) = X(34)/JVS(117)
  XX(35) = X(35)/JVS(120)
  XX(36) = X(36)/JVS(123)
  XX(37) = X(37)/JVS(126)
  XX(38) = X(38)/JVS(129)
  XX(39) = X(39)/JVS(132)
  XX(40) = X(40)/JVS(135)
  XX(41) = X(41)/JVS(138)
  XX(42) = X(42)/JVS(141)
  XX(43) = X(43)/JVS(144)
  XX(44) = X(44)/JVS(147)
  XX(45) = X(45)/JVS(150)
  XX(46) = X(46)/JVS(153)
  XX(47) = X(47)/JVS(156)
  XX(48) = X(48)/JVS(159)
  XX(49) = X(49)/JVS(162)
  XX(50) = X(50)/JVS(165)
  XX(51) = X(51)/JVS(168)
  XX(52) = X(52)/JVS(171)
  XX(53) = X(53)/JVS(174)
  XX(54) = X(54)/JVS(177)
  XX(55) = X(55)/JVS(180)
  XX(56) = X(56)/JVS(183)
  XX(57) = X(57)/JVS(186)
  XX(58) = X(58)/JVS(188)
  XX(59) = X(59)/JVS(191)
  XX(60) = X(60)/JVS(194)
  XX(61) = X(61)/JVS(197)
  XX(62) = X(62)/JVS(200)
  XX(63) = X(63)/JVS(203)
  XX(64) = X(64)/JVS(206)
  XX(65) = X(65)/JVS(209)
  XX(66) = X(66)/JVS(212)
  XX(67) = X(67)/JVS(215)
  XX(68) = X(68)/JVS(218)
  XX(69) = X(69)/JVS(221)
  XX(70) = X(70)/JVS(224)
  XX(71) = X(71)/JVS(227)
  XX(72) = X(72)/JVS(230)
  XX(73) = X(73)/JVS(233)
  XX(74) = X(74)/JVS(236)
  XX(75) = X(75)/JVS(239)
  XX(76) = X(76)/JVS(242)
  XX(77) = X(77)/JVS(245)
  XX(78) = X(78)/JVS(247)
  XX(79) = X(79)/JVS(250)
  XX(80) = X(80)/JVS(253)
  XX(81) = X(81)/JVS(256)
  XX(82) = X(82)/JVS(259)
  XX(83) = X(83)/JVS(262)
  XX(84) = X(84)/JVS(265)
  XX(85) = X(85)/JVS(266)
  XX(86) = X(86)/JVS(268)
  XX(87) = X(87)/JVS(270)
  XX(88) = X(88)/JVS(272)
  XX(89) = X(89)/JVS(274)
  XX(90) = X(90)/JVS(276)
  XX(91) = X(91)/JVS(279)
  XX(92) = X(92)/JVS(282)
  XX(93) = X(93)/JVS(285)
  XX(94) = X(94)/JVS(288)
  XX(95) = X(95)/JVS(291)
  XX(96) = X(96)/JVS(294)
  XX(97) = X(97)/JVS(297)
  XX(98) = X(98)/JVS(300)
  XX(99) = X(99)/JVS(303)
  XX(100) = X(100)/JVS(306)
  XX(101) = X(101)/JVS(309)
  XX(102) = X(102)/JVS(312)
  XX(103) = X(103)/JVS(315)
  XX(104) = X(104)/JVS(318)
  XX(105) = X(105)/JVS(321)
  XX(106) = X(106)/JVS(324)
  XX(107) = X(107)/JVS(327)
  XX(108) = X(108)/JVS(330)
  XX(109) = X(109)/JVS(333)
  XX(110) = X(110)/JVS(336)
  XX(111) = X(111)/JVS(339)
  XX(112) = X(112)/JVS(342)
  XX(113) = X(113)/JVS(345)
  XX(114) = X(114)/JVS(348)
  XX(115) = X(115)/JVS(351)
  XX(116) = X(116)/JVS(354)
  XX(117) = X(117)/JVS(357)
  XX(118) = X(118)/JVS(360)
  XX(119) = X(119)/JVS(363)
  XX(120) = X(120)/JVS(366)
  XX(121) = X(121)/JVS(369)
  XX(122) = X(122)/JVS(371)
  XX(123) = X(123)/JVS(374)
  XX(124) = X(124)/JVS(377)
  XX(125) = X(125)/JVS(379)
  XX(126) = X(126)/JVS(381)
  XX(127) = X(127)/JVS(384)
  XX(128) = X(128)/JVS(387)
  XX(129) = X(129)/JVS(389)
  XX(130) = X(130)/JVS(391)
  XX(131) = X(131)/JVS(394)
  XX(132) = X(132)/JVS(397)
  XX(133) = X(133)/JVS(400)
  XX(134) = X(134)/JVS(402)
  XX(135) = X(135)/JVS(404)
  XX(136) = X(136)/JVS(407)
  XX(137) = X(137)/JVS(410)
  XX(138) = X(138)/JVS(413)
  XX(139) = X(139)/JVS(416)
  XX(140) = X(140)/JVS(419)
  XX(141) = X(141)/JVS(422)
  XX(142) = X(142)/JVS(424)
  XX(143) = X(143)/JVS(427)
  XX(144) = X(144)/JVS(430)
  XX(145) = X(145)/JVS(433)
  XX(146) = X(146)/JVS(436)
  XX(147) = X(147)/JVS(439)
  XX(148) = X(148)/JVS(442)
  XX(149) = X(149)/JVS(445)
  XX(150) = X(150)/JVS(448)
  XX(151) = X(151)/JVS(451)
  XX(152) = X(152)/JVS(454)
  XX(153) = X(153)/JVS(457)
  XX(154) = X(154)/JVS(460)
  XX(155) = X(155)/JVS(463)
  XX(156) = X(156)/JVS(466)
  XX(157) = X(157)/JVS(469)
  XX(158) = X(158)/JVS(472)
  XX(159) = X(159)/JVS(475)
  XX(160) = X(160)/JVS(478)
  XX(161) = X(161)/JVS(481)
  XX(162) = X(162)/JVS(484)
  XX(163) = X(163)/JVS(487)
  XX(164) = X(164)/JVS(490)
  XX(165) = X(165)/JVS(493)
  XX(166) = X(166)/JVS(496)
  XX(167) = X(167)/JVS(499)
  XX(168) = X(168)/JVS(502)
  XX(169) = X(169)/JVS(504)
  XX(170) = X(170)/JVS(506)
  XX(171) = X(171)/JVS(509)
  XX(172) = X(172)/JVS(512)
  XX(173) = X(173)/JVS(515)
  XX(174) = X(174)/JVS(518)
  XX(175) = X(175)/JVS(521)
  XX(176) = X(176)/JVS(524)
  XX(177) = X(177)/JVS(527)
  XX(178) = X(178)/JVS(530)
  XX(179) = X(179)/JVS(533)
  XX(180) = X(180)/JVS(535)
  XX(181) = X(181)/JVS(537)
  XX(182) = X(182)/JVS(539)
  XX(183) = X(183)/JVS(541)
  XX(184) = X(184)/JVS(544)
  XX(185) = X(185)/JVS(547)
  XX(186) = X(186)/JVS(549)
  XX(187) = X(187)/JVS(552)
  XX(188) = X(188)/JVS(555)
  XX(189) = X(189)/JVS(558)
  XX(190) = X(190)/JVS(561)
  XX(191) = X(191)/JVS(564)
  XX(192) = X(192)/JVS(567)
  XX(193) = X(193)/JVS(570)
  XX(194) = X(194)/JVS(573)
  XX(195) = X(195)/JVS(576)
  XX(196) = X(196)/JVS(579)
  XX(197) = X(197)/JVS(582)
  XX(198) = X(198)/JVS(585)
  XX(199) = X(199)/JVS(588)
  XX(200) = X(200)/JVS(591)
  XX(201) = X(201)/JVS(594)
  XX(202) = X(202)/JVS(597)
  XX(203) = X(203)/JVS(600)
  XX(204) = X(204)/JVS(603)
  XX(205) = X(205)/JVS(606)
  XX(206) = X(206)/JVS(609)
  XX(207) = X(207)/JVS(612)
  XX(208) = X(208)/JVS(615)
  XX(209) = X(209)/JVS(617)
  XX(210) = X(210)/JVS(619)
  XX(211) = X(211)/JVS(621)
  XX(212) = X(212)/JVS(623)
  XX(213) = X(213)/JVS(625)
  XX(214) = X(214)/JVS(627)
  XX(215) = X(215)/JVS(629)
  XX(216) = X(216)/JVS(631)
  XX(217) = X(217)/JVS(633)
  XX(218) = X(218)/JVS(635)
  XX(219) = X(219)/JVS(637)
  XX(220) = X(220)/JVS(639)
  XX(221) = X(221)/JVS(641)
  XX(222) = X(222)/JVS(643)
  XX(223) = X(223)/JVS(645)
  XX(224) = X(224)/JVS(647)
  XX(225) = X(225)/JVS(649)
  XX(226) = X(226)/JVS(651)
  XX(227) = X(227)/JVS(653)
  XX(228) = X(228)/JVS(656)
  XX(229) = X(229)/JVS(659)
  XX(230) = X(230)/JVS(662)
  XX(231) = X(231)/JVS(665)
  XX(232) = X(232)/JVS(668)
  XX(233) = X(233)/JVS(671)
  XX(234) = X(234)/JVS(674)
  XX(235) = X(235)/JVS(677)
  XX(236) = X(236)/JVS(680)
  XX(237) = X(237)/JVS(683)
  XX(238) = X(238)/JVS(686)
  XX(239) = X(239)/JVS(689)
  XX(240) = X(240)/JVS(692)
  XX(241) = X(241)/JVS(695)
  XX(242) = X(242)/JVS(698)
  XX(243) = X(243)/JVS(700)
  XX(244) = X(244)/JVS(702)
  XX(245) = X(245)/JVS(704)
  XX(246) = X(246)/JVS(706)
  XX(247) = X(247)/JVS(709)
  XX(248) = (X(248)-JVS(187)*XX(57))/(JVS(712))
  XX(249) = X(249)/JVS(715)
  XX(250) = X(250)/JVS(717)
  XX(251) = X(251)/JVS(719)
  XX(252) = X(252)/JVS(721)
  XX(253) = X(253)/JVS(723)
  XX(254) = X(254)/JVS(725)
  XX(255) = X(255)/JVS(727)
  XX(256) = X(256)/JVS(729)
  XX(257) = X(257)/JVS(731)
  XX(258) = (X(258)-JVS(24)*XX(9)-JVS(27)*XX(10))/(JVS(735))
  XX(259) = X(259)/JVS(739)
  XX(260) = (X(260)-JVS(273)*XX(88)-JVS(425)*XX(142)-JVS(428)*XX(143))/(JVS(741))
  XX(261) = (X(261)-JVS(12)*XX(5)-JVS(15)*XX(6))/(JVS(746))
  XX(262) = (X(262)-JVS(18)*XX(7)-JVS(21)*XX(8))/(JVS(751))
  XX(263) = (X(263)-JVS(33)*XX(12)-JVS(452)*XX(151)-JVS(652)*XX(226))/(JVS(755))
  XX(264) = (X(264)-JVS(325)*XX(106))/(JVS(758))
  XX(265) = (X(265)-JVS(246)*XX(77)-JVS(248)*XX(78)-JVS(742)*XX(260))/(JVS(761))
  XX(266) = (X(266)-JVS(269)*XX(86))/(JVS(764))
  XX(267) = X(267)/JVS(767)
  XX(268) = (X(268)-JVS(497)*XX(166)-JVS(538)*XX(181))/(JVS(771))
  XX(269) = X(269)/JVS(774)
  XX(270) = X(270)/JVS(777)
  XX(271) = (X(271)-JVS(271)*XX(87))/(JVS(780))
  XX(272) = (X(272)-JVS(494)*XX(165))/(JVS(783))
  XX(273) = (X(273)-JVS(254)*XX(80))/(JVS(787))
  XX(274) = (X(274)-JVS(482)*XX(161))/(JVS(791))
  XX(275) = X(275)/JVS(794)
  XX(276) = X(276)/JVS(797)
  XX(277) = X(277)/JVS(800)
  XX(278) = (X(278)-JVS(604)*XX(204))/(JVS(803))
  XX(279) = X(279)/JVS(806)
  XX(280) = (X(280)-JVS(67)*XX(17))/(JVS(810))
  XX(281) = X(281)/JVS(814)
  XX(282) = X(282)/JVS(818)
  XX(283) = (X(283)-JVS(3)*XX(2)-JVS(385)*XX(127))/(JVS(822))
  XX(284) = (X(284)-JVS(613)*XX(207))/(JVS(825))
  XX(285) = (X(285)-JVS(479)*XX(160))/(JVS(828))
  XX(286) = (X(286)-JVS(263)*XX(83))/(JVS(832))
  XX(287) = (X(287)-JVS(267)*XX(85))/(JVS(838))
  XX(288) = X(288)/JVS(842)
  XX(289) = X(289)/JVS(846)
  XX(290) = X(290)/JVS(850)
  XX(291) = X(291)/JVS(859)
  XX(292) = (X(292)-JVS(34)*XX(12))/(JVS(864))
  XX(293) = (X(293)-JVS(151)*XX(45))/(JVS(871))
  XX(294) = X(294)/JVS(878)
  XX(295) = X(295)/JVS(888)
  XX(296) = X(296)/JVS(892)
  XX(297) = X(297)/JVS(896)
  XX(298) = (X(298)-JVS(364)*XX(119)-JVS(601)*XX(203))/(JVS(902))
  XX(299) = (X(299)-JVS(644)*XX(222))/(JVS(906))
  XX(300) = (X(300)-JVS(710)*XX(247))/(JVS(910))
  XX(301) = X(301)/JVS(914)
  XX(302) = X(302)/JVS(919)
  XX(303) = (X(303)-JVS(607)*XX(205))/(JVS(924))
  XX(304) = (X(304)-JVS(35)*XX(12)-JVS(417)*XX(139))/(JVS(930))
  XX(305) = (X(305)-JVS(36)*XX(12)-JVS(646)*XX(223))/(JVS(936))
  XX(306) = (X(306)-JVS(382)*XX(126)-JVS(513)*XX(172)-JVS(788)*XX(273))/(JVS(942))
  XX(307) = (X(307)-JVS(37)*XX(12))/(JVS(947))
  XX(308) = X(308)/JVS(959)
  XX(309) = (X(309)-JVS(411)*XX(137))/(JVS(965))
  XX(310) = (X(310)-JVS(372)*XX(122)-JVS(408)*XX(136))/(JVS(971))
  XX(311) = (X(311)-JVS(38)*XX(12)-JVS(195)*XX(60)-JVS(198)*XX(61)-JVS(897)*XX(297))/(JVS(977))
  XX(312) = X(312)/JVS(984)
  XX(313) = (X(313)-JVS(39)*XX(12)-JVS(142)*XX(42)-JVS(580)*XX(196)-JVS(948)*XX(307))/(JVS(1001))
  XX(314) = (X(314)-JVS(189)*XX(58)-JVS(192)*XX(59)-JVS(898)*XX(297))/(JVS(1006))
  XX(315) = (X(315)-JVS(562)*XX(190))/(JVS(1011))
  XX(316) = (X(316)-JVS(243)*XX(76)-JVS(464)*XX(155))/(JVS(1017))
  XX(317) = (X(317)-JVS(522)*XX(175)-JVS(851)*XX(290)-JVS(872)*XX(293))/(JVS(1028))
  XX(318) = (X(318)-JVS(40)*XX(12)-JVS(181)*XX(55)-JVS(184)*XX(56)-JVS(414)*XX(138)-JVS(713)*XX(248)-JVS(949)*XX(307))&
              &/(JVS(1035))
  XX(319) = (X(319)-JVS(6)*XX(3)-JVS(9)*XX(4)-JVS(346)*XX(113)-JVS(355)*XX(116))/(JVS(1041))
  XX(320) = (X(320)-JVS(334)*XX(109)-JVS(337)*XX(110))/(JVS(1046))
  XX(321) = (X(321)-JVS(251)*XX(79))/(JVS(1052))
  XX(322) = (X(322)-JVS(319)*XX(104)-JVS(322)*XX(105)-JVS(960)*XX(308))/(JVS(1062))
  XX(323) = (X(323)-JVS(118)*XX(34)-JVS(121)*XX(35)-JVS(961)*XX(308))/(JVS(1068))
  XX(324) = (X(324)-JVS(650)*XX(225))/(JVS(1075))
  XX(325) = (X(325)-JVS(392)*XX(130)-JVS(401)*XX(133)-JVS(403)*XX(134)-JVS(531)*XX(178)-JVS(536)*XX(180)-JVS(852)&
              &*XX(290)-JVS(873)*XX(293))/(JVS(1088))
  XX(326) = (X(326)-JVS(30)*XX(11)-JVS(178)*XX(54)-JVS(950)*XX(307))/(JVS(1099))
  XX(327) = (X(327)-JVS(340)*XX(111)-JVS(571)*XX(193)-JVS(630)*XX(215)-JVS(632)*XX(216)-JVS(634)*XX(217))/(JVS(1111))
  XX(328) = (X(328)-JVS(237)*XX(74)-JVS(240)*XX(75)-JVS(672)*XX(233)-JVS(696)*XX(241)-JVS(879)*XX(294))/(JVS(1123))
  XX(329) = (X(329)-JVS(431)*XX(144)-JVS(434)*XX(145)-JVS(437)*XX(146)-JVS(1018)*XX(316))/(JVS(1132))
  XX(330) = (X(330)-JVS(219)*XX(68)-JVS(222)*XX(69)-JVS(663)*XX(230)-JVS(687)*XX(238)-JVS(880)*XX(294))/(JVS(1140))
  XX(331) = (X(331)-JVS(41)*XX(12)-JVS(145)*XX(43)-JVS(148)*XX(44)-JVS(985)*XX(312))/(JVS(1150))
  XX(332) = (X(332)-JVS(76)*XX(20)-JVS(815)*XX(281)-JVS(986)*XX(312))/(JVS(1159))
  XX(333) = (X(333)-JVS(375)*XX(123)-JVS(405)*XX(135)-JVS(865)*XX(292)-JVS(1076)*XX(324))/(JVS(1168))
  XX(334) = (X(334)-JVS(598)*XX(202)-JVS(626)*XX(213))/(JVS(1176))
  XX(335) = (X(335)-JVS(213)*XX(66)-JVS(216)*XX(67)-JVS(660)*XX(229)-JVS(684)*XX(237)-JVS(881)*XX(294))/(JVS(1187))
  XX(336) = (X(336)-JVS(225)*XX(70)-JVS(228)*XX(71)-JVS(666)*XX(231)-JVS(690)*XX(239)-JVS(882)*XX(294))/(JVS(1196))
  XX(337) = (X(337)-JVS(42)*XX(12))/(JVS(1207))
  XX(338) = (X(338)-JVS(201)*XX(62)-JVS(204)*XX(63)-JVS(678)*XX(235)-JVS(883)*XX(294)-JVS(951)*XX(307))/(JVS(1237))
  XX(339) = (X(339)-JVS(115)*XX(33)-JVS(307)*XX(100)-JVS(310)*XX(101)-JVS(313)*XX(102)-JVS(860)*XX(291)-JVS(1012)&
              &*XX(315))/(JVS(1247))
  XX(340) = (X(340)-JVS(79)*XX(21)-JVS(889)*XX(295)-JVS(987)*XX(312)-JVS(1208)*XX(337))/(JVS(1256))
  XX(341) = (X(341)-JVS(648)*XX(224)-JVS(1036)*XX(318)-JVS(1209)*XX(337))/(JVS(1266))
  XX(342) = (X(342)-JVS(43)*XX(12)-JVS(106)*XX(30)-JVS(550)*XX(186)-JVS(559)*XX(189)-JVS(589)*XX(199)-JVS(966)*XX(309)&
              &-JVS(1077)*XX(324)-JVS(1210)*XX(337))/(JVS(1275))
  XX(343) = (X(343)-JVS(231)*XX(72)-JVS(234)*XX(73)-JVS(669)*XX(232)-JVS(693)*XX(240)-JVS(884)*XX(294)-JVS(1211)&
              &*XX(337))/(JVS(1283))
  XX(344) = (X(344)-JVS(461)*XX(154))/(JVS(1299))
  XX(345) = (X(345)-JVS(124)*XX(36)-JVS(893)*XX(296)-JVS(988)*XX(312)-JVS(1078)*XX(324)-JVS(1212)*XX(337))/(JVS(1317))
  XX(346) = (X(346)-JVS(94)*XX(26)-JVS(915)*XX(301)-JVS(989)*XX(312)-JVS(1213)*XX(337))/(JVS(1326))
  XX(347) = (X(347)-JVS(109)*XX(31)-JVS(819)*XX(282)-JVS(990)*XX(312)-JVS(1177)*XX(334)-JVS(1214)*XX(337))/(JVS(1336))
  XX(348) = (X(348)-JVS(257)*XX(81)-JVS(516)*XX(173)-JVS(519)*XX(174)-JVS(853)*XX(290)-JVS(1053)*XX(321))/(JVS(1345))
  XX(349) = (X(349)-JVS(100)*XX(28)-JVS(920)*XX(302)-JVS(991)*XX(312)-JVS(1100)*XX(326)-JVS(1215)*XX(337))/(JVS(1356))
  XX(350) = (X(350)-JVS(73)*XX(19)-JVS(807)*XX(279)-JVS(1216)*XX(337))/(JVS(1367))
  XX(351) = (X(351)-JVS(154)*XX(46)-JVS(157)*XX(47)-JVS(553)*XX(187)-JVS(583)*XX(197)-JVS(907)*XX(299)-JVS(925)*XX(303)&
              &-JVS(931)*XX(304)-JVS(978)*XX(311)-JVS(992)*XX(312)-JVS(1112)*XX(327)-JVS(1217)*XX(337))/(JVS(1381))
  XX(352) = (X(352)-JVS(127)*XX(37)-JVS(136)*XX(40)-JVS(732)*XX(257)-JVS(861)*XX(291)-JVS(1368)*XX(350))/(JVS(1391))
  XX(353) = (X(353)-JVS(103)*XX(29)-JVS(548)*XX(185)-JVS(556)*XX(188)-JVS(586)*XX(198)-JVS(937)*XX(305)-JVS(993)*XX(312)&
              &-JVS(1218)*XX(337)-JVS(1267)*XX(341))/(JVS(1404))
  XX(354) = (X(354)-JVS(64)*XX(16))/(JVS(1424))
  XX(355) = (X(355)-JVS(525)*XX(176)-JVS(528)*XX(177)-JVS(540)*XX(182)-JVS(854)*XX(290)-JVS(1054)*XX(321))/(JVS(1460))
  XX(356) = (X(356)-JVS(44)*XX(12)-JVS(565)*XX(191)-JVS(568)*XX(192)-JVS(628)*XX(214)-JVS(952)*XX(307)-JVS(1113)*XX(327)&
              &-JVS(1425)*XX(354))/(JVS(1483))
  XX(357) = (X(357)-JVS(91)*XX(25)-JVS(916)*XX(301)-JVS(1219)*XX(337))/(JVS(1505))
  XX(358) = (X(358)-JVS(88)*XX(24)-JVS(994)*XX(312)-JVS(1220)*XX(337))/(JVS(1518))
  XX(359) = (X(359)-JVS(304)*XX(99)-JVS(316)*XX(103)-JVS(1063)*XX(322)-JVS(1069)*XX(323)-JVS(1114)*XX(327)-JVS(1248)&
              &*XX(339)-JVS(1392)*XX(352)-JVS(1426)*XX(354))/(JVS(1529))
  XX(360) = (X(360)-JVS(45)*XX(12)-JVS(130)*XX(38)-JVS(139)*XX(41)-JVS(843)*XX(288)-JVS(1013)*XX(315)-JVS(1151)*XX(331)&
              &-JVS(1221)*XX(337)-JVS(1427)*XX(354))/(JVS(1541))
  XX(361) = (X(361)-JVS(112)*XX(32)-JVS(301)*XX(98)-JVS(962)*XX(308)-JVS(1169)*XX(333)-JVS(1222)*XX(337)-JVS(1484)&
              &*XX(356)-JVS(1530)*XX(359)-JVS(1542)*XX(360))/(JVS(1557))
  XX(362) = (X(362)-JVS(46)*XX(12)-JVS(97)*XX(27)-JVS(911)*XX(300)-JVS(972)*XX(310)-JVS(995)*XX(312)-JVS(1002)*XX(313)&
              &-JVS(1007)*XX(314)-JVS(1101)*XX(326)-JVS(1115)*XX(327)-JVS(1170)*XX(333)-JVS(1223)*XX(337)-JVS(1268)*XX(341)&
              &-JVS(1428)*XX(354)-JVS(1485)*XX(356))/(JVS(1567))
  XX(363) = (X(363)-JVS(367)*XX(120)-JVS(1124)*XX(328)-JVS(1141)*XX(330)-JVS(1300)*XX(344)-JVS(1382)*XX(351)-JVS(1429)&
              &*XX(354)-JVS(1486)*XX(356))/(JVS(1580))
  XX(364) = (X(364)-JVS(343)*XX(112)-JVS(574)*XX(194)-JVS(636)*XX(218)-JVS(1430)*XX(354))/(JVS(1610))
  XX(365) = (X(365)-JVS(169)*XX(51)-JVS(172)*XX(52)-JVS(175)*XX(53)-JVS(967)*XX(309)-JVS(1102)*XX(326)-JVS(1269)*XX(341)&
              &-JVS(1431)*XX(354)-JVS(1487)*XX(356)-JVS(1519)*XX(358)-JVS(1611)*XX(364))/(JVS(1636))
  XX(366) = (X(366)-JVS(160)*XX(48)-JVS(163)*XX(49)-JVS(166)*XX(50)-JVS(866)*XX(292)-JVS(953)*XX(307)-JVS(968)*XX(309)&
              &-JVS(1079)*XX(324)-JVS(1270)*XX(341)-JVS(1432)*XX(354)-JVS(1488)*XX(356)-JVS(1520)*XX(358)-JVS(1612)*XX(364)&
              &-JVS(1637)*XX(365))/(JVS(1652))
  XX(367) = (X(367)-JVS(207)*XX(64)-JVS(210)*XX(65)-JVS(657)*XX(228)-JVS(681)*XX(236)-JVS(885)*XX(294)-JVS(938)*XX(305)&
              &-JVS(1301)*XX(344)-JVS(1405)*XX(353)-JVS(1613)*XX(364))/(JVS(1662))
  XX(368) = (X(368)-JVS(47)*XX(12)-JVS(577)*XX(195)-JVS(954)*XX(307)-JVS(1224)*XX(337)-JVS(1614)*XX(364))/(JVS(1696))
  XX(369) = (X(369)-JVS(82)*XX(22)-JVS(85)*XX(23)-JVS(899)*XX(297)-JVS(996)*XX(312)-JVS(1160)*XX(332)-JVS(1178)*XX(334)&
              &-JVS(1225)*XX(337)-JVS(1337)*XX(347)-JVS(1369)*XX(350)-JVS(1506)*XX(357)-JVS(1615)*XX(364)-JVS(1697)*XX(368))&
              &/(JVS(1724))
  XX(370) = (X(370)-JVS(1161)*XX(332)-JVS(1179)*XX(334)-JVS(1226)*XX(337)-JVS(1338)*XX(347)-JVS(1370)*XX(350)-JVS(1507)&
              &*XX(357)-JVS(1521)*XX(358)-JVS(1616)*XX(364)-JVS(1698)*XX(368)-JVS(1725)*XX(369))/(JVS(1747))
  XX(371) = (X(371)-JVS(388)*XX(128)-JVS(390)*XX(129)-JVS(398)*XX(132)-JVS(467)*XX(156)-JVS(507)*XX(170)-JVS(510)&
              &*XX(171)-JVS(784)*XX(272)-JVS(833)*XX(286)-JVS(855)*XX(290)-JVS(874)*XX(293)-JVS(1029)*XX(317)-JVS(1055)&
              &*XX(321)-JVS(1089)*XX(325)-JVS(1433)*XX(354)-JVS(1461)*XX(355))/(JVS(1767))
  XX(372) = (X(372)-JVS(328)*XX(107)-JVS(624)*XX(212)-JVS(1371)*XX(350)-JVS(1393)*XX(352)-JVS(1434)*XX(354))/(JVS(1812))
  XX(373) = (X(373)-JVS(485)*XX(162)-JVS(488)*XX(163)-JVS(491)*XX(164)-JVS(500)*XX(167)-JVS(503)*XX(168)-JVS(505)&
              &*XX(169)-JVS(508)*XX(170)-JVS(511)*XX(171)-JVS(772)*XX(268)-JVS(785)*XX(272)-JVS(834)*XX(286)-JVS(856)&
              &*XX(290)-JVS(1056)*XX(321)-JVS(1346)*XX(348)-JVS(1435)*XX(354)-JVS(1462)*XX(355)-JVS(1768)*XX(371))&
              &/(JVS(1846))
  XX(374) = (X(374)-JVS(331)*XX(108)-JVS(1327)*XX(346)-JVS(1372)*XX(350)-JVS(1394)*XX(352)-JVS(1436)*XX(354)-JVS(1508)&
              &*XX(357)-JVS(1617)*XX(364)-JVS(1699)*XX(368)-JVS(1748)*XX(370)-JVS(1813)*XX(372))/(JVS(1882))
  XX(375) = (X(375)-JVS(352)*XX(115)-JVS(358)*XX(117)-JVS(361)*XX(118)-JVS(642)*XX(221)-JVS(1142)*XX(330)-JVS(1238)&
              &*XX(338)-JVS(1276)*XX(342)-JVS(1302)*XX(344)-JVS(1406)*XX(353)-JVS(1437)*XX(354)-JVS(1522)*XX(358)-JVS(1543)&
              &*XX(360)-JVS(1618)*XX(364)-JVS(1638)*XX(365)-JVS(1653)*XX(366)-JVS(1700)*XX(368)-JVS(1726)*XX(369)-JVS(1749)&
              &*XX(370)-JVS(1814)*XX(372)-JVS(1883)*XX(374))/(JVS(1902))
  XX(376) = (X(376)-JVS(298)*XX(97)-JVS(545)*XX(184)-JVS(595)*XX(201)-JVS(620)*XX(210)-JVS(622)*XX(211)-JVS(1133)&
              &*XX(329)-JVS(1438)*XX(354))/(JVS(1935))
  XX(377) = (X(377)-JVS(349)*XX(114)-JVS(638)*XX(219)-JVS(640)*XX(220)-JVS(1047)*XX(320)-JVS(1134)*XX(329)-JVS(1197)&
              &*XX(336)-JVS(1239)*XX(338)-JVS(1257)*XX(340)-JVS(1284)*XX(343)-JVS(1303)*XX(344)-JVS(1318)*XX(345)-JVS(1357)&
              &*XX(349)-JVS(1395)*XX(352)-JVS(1489)*XX(356)-JVS(1619)*XX(364)-JVS(1701)*XX(368)-JVS(1815)*XX(372)-JVS(1884)&
              &*XX(374)-JVS(1936)*XX(376))/(JVS(1954))
  XX(378) = (X(378)-JVS(48)*XX(12)-JVS(70)*XX(18)-JVS(133)*XX(39)-JVS(584)*XX(197)-JVS(587)*XX(198)-JVS(590)*XX(199)&
              &-JVS(765)*XX(266)-JVS(768)*XX(267)-JVS(926)*XX(303)-JVS(932)*XX(304)-JVS(979)*XX(311)-JVS(1008)*XX(314)&
              &-JVS(1080)*XX(324)-JVS(1116)*XX(327)-JVS(1152)*XX(331)-JVS(1162)*XX(332)-JVS(1180)*XX(334)-JVS(1227)*XX(337)&
              &-JVS(1258)*XX(340)-JVS(1277)*XX(342)-JVS(1319)*XX(345)-JVS(1328)*XX(346)-JVS(1339)*XX(347)-JVS(1358)*XX(349)&
              &-JVS(1373)*XX(350)-JVS(1383)*XX(351)-JVS(1396)*XX(352)-JVS(1407)*XX(353)-JVS(1439)*XX(354)-JVS(1490)*XX(356)&
              &-JVS(1509)*XX(357)-JVS(1523)*XX(358)-JVS(1531)*XX(359)-JVS(1544)*XX(360)-JVS(1558)*XX(361)-JVS(1568)*XX(362)&
              &-JVS(1581)*XX(363)-JVS(1620)*XX(364)-JVS(1639)*XX(365)-JVS(1654)*XX(366)-JVS(1702)*XX(368)-JVS(1727)*XX(369)&
              &-JVS(1750)*XX(370)-JVS(1816)*XX(372)-JVS(1885)*XX(374)-JVS(1903)*XX(375)-JVS(1937)*XX(376)-JVS(1955)*XX(377))&
              &/(JVS(2008))
  XX(379) = (X(379)-JVS(675)*XX(234)-JVS(679)*XX(235)-JVS(682)*XX(236)-JVS(685)*XX(237)-JVS(688)*XX(238)-JVS(691)&
              &*XX(239)-JVS(694)*XX(240)-JVS(697)*XX(241)-JVS(886)*XX(294)-JVS(1125)*XX(328)-JVS(1143)*XX(330)-JVS(1188)&
              &*XX(335)-JVS(1198)*XX(336)-JVS(1240)*XX(338)-JVS(1285)*XX(343)-JVS(1304)*XX(344)-JVS(1491)*XX(356)-JVS(1621)&
              &*XX(364)-JVS(1663)*XX(367)-JVS(1703)*XX(368)-JVS(1817)*XX(372)-JVS(1886)*XX(374)-JVS(1904)*XX(375)-JVS(1938)&
              &*XX(376)-JVS(1956)*XX(377)-JVS(2009)*XX(378))/(JVS(2034))
  XX(380) = (X(380)-JVS(295)*XX(96)-JVS(470)*XX(157)-JVS(542)*XX(183)-JVS(592)*XX(200)-JVS(610)*XX(206)-JVS(616)*XX(208)&
              &-JVS(618)*XX(209)-JVS(1019)*XX(316)-JVS(1440)*XX(354))/(JVS(2107))
  XX(381) = (X(381)-JVS(383)*XX(126)-JVS(420)*XX(140)-JVS(939)*XX(305)-JVS(943)*XX(306)-JVS(955)*XX(307)-JVS(1030)&
              &*XX(317)-JVS(1090)*XX(325)-JVS(1126)*XX(328)-JVS(1144)*XX(330)-JVS(1189)*XX(335)-JVS(1199)*XX(336)-JVS(1228)&
              &*XX(337)-JVS(1241)*XX(338)-JVS(1286)*XX(343)-JVS(1305)*XX(344)-JVS(1347)*XX(348)-JVS(1408)*XX(353)-JVS(1441)&
              &*XX(354)-JVS(1463)*XX(355)-JVS(1492)*XX(356)-JVS(1622)*XX(364)-JVS(1664)*XX(367)-JVS(1704)*XX(368)-JVS(1769)&
              &*XX(371)-JVS(1818)*XX(372)-JVS(1847)*XX(373)-JVS(1887)*XX(374)-JVS(1905)*XX(375)-JVS(1939)*XX(376)-JVS(1957)&
              &*XX(377)-JVS(2010)*XX(378)-JVS(2035)*XX(379)-JVS(2108)*XX(380))/(JVS(2192))
  XX(382) = (X(382)-JVS(205)*XX(63)-JVS(211)*XX(65)-JVS(217)*XX(67)-JVS(223)*XX(69)-JVS(229)*XX(71)-JVS(235)*XX(73)&
              &-JVS(241)*XX(75)-JVS(292)*XX(95)-JVS(311)*XX(101)-JVS(378)*XX(124)-JVS(415)*XX(138)-JVS(455)*XX(152)-JVS(707)&
              &*XX(246)-JVS(714)*XX(248)-JVS(733)*XX(257)-JVS(743)*XX(260)-JVS(762)*XX(265)-JVS(766)*XX(266)-JVS(781)&
              &*XX(271)-JVS(811)*XX(280)-JVS(839)*XX(287)-JVS(944)*XX(306)-JVS(1014)*XX(315)-JVS(1031)*XX(317)-JVS(1037)&
              &*XX(318)-JVS(1091)*XX(325)-JVS(1127)*XX(328)-JVS(1145)*XX(330)-JVS(1190)*XX(335)-JVS(1200)*XX(336)-JVS(1229)&
              &*XX(337)-JVS(1242)*XX(338)-JVS(1249)*XX(339)-JVS(1287)*XX(343)-JVS(1306)*XX(344)-JVS(1348)*XX(348)-JVS(1397)&
              &*XX(352)-JVS(1442)*XX(354)-JVS(1464)*XX(355)-JVS(1493)*XX(356)-JVS(1545)*XX(360)-JVS(1623)*XX(364)-JVS(1665)&
              &*XX(367)-JVS(1705)*XX(368)-JVS(1751)*XX(370)-JVS(1770)*XX(371)-JVS(1819)*XX(372)-JVS(1848)*XX(373)-JVS(1888)&
              &*XX(374)-JVS(1906)*XX(375)-JVS(1940)*XX(376)-JVS(1958)*XX(377)-JVS(2011)*XX(378)-JVS(2036)*XX(379)-JVS(2109)&
              &*XX(380)-JVS(2193)*XX(381))/(JVS(2281))
  XX(383) = (X(383)-JVS(4)*XX(2)-JVS(7)*XX(3)-JVS(31)*XX(11)-JVS(49)*XX(12)-JVS(56)*XX(13)-JVS(65)*XX(16)-JVS(68)*XX(17)&
              &-JVS(152)*XX(45)-JVS(179)*XX(54)-JVS(252)*XX(79)-JVS(255)*XX(80)-JVS(258)*XX(81)-JVS(277)*XX(90)-JVS(289)&
              &*XX(94)-JVS(399)*XX(132)-JVS(406)*XX(135)-JVS(409)*XX(136)-JVS(412)*XX(137)-JVS(443)*XX(148)-JVS(489)*XX(163)&
              &-JVS(492)*XX(164)-JVS(495)*XX(165)-JVS(498)*XX(166)-JVS(543)*XX(183)-JVS(546)*XX(184)-JVS(563)*XX(190)&
              &-JVS(566)*XX(191)-JVS(569)*XX(192)-JVS(572)*XX(193)-JVS(575)*XX(194)-JVS(578)*XX(195)-JVS(608)*XX(205)&
              &-JVS(654)*XX(227)-JVS(676)*XX(234)-JVS(699)*XX(242)-JVS(701)*XX(243)-JVS(703)*XX(244)-JVS(705)*XX(245)&
              &-JVS(711)*XX(247)-JVS(736)*XX(258)-JVS(747)*XX(261)-JVS(752)*XX(262)-JVS(756)*XX(263)-JVS(759)*XX(264)&
              &-JVS(769)*XX(267)-JVS(773)*XX(268)-JVS(775)*XX(269)-JVS(778)*XX(270)-JVS(786)*XX(272)-JVS(789)*XX(273)&
              &-JVS(792)*XX(274)-JVS(795)*XX(275)-JVS(798)*XX(276)-JVS(801)*XX(277)-JVS(804)*XX(278)-JVS(808)*XX(279)&
              &-JVS(812)*XX(280)-JVS(816)*XX(281)-JVS(820)*XX(282)-JVS(823)*XX(283)-JVS(826)*XX(284)-JVS(829)*XX(285)&
              &-JVS(835)*XX(286)-JVS(840)*XX(287)-JVS(844)*XX(288)-JVS(847)*XX(289)-JVS(862)*XX(291)-JVS(867)*XX(292)&
              &-JVS(875)*XX(293)-JVS(887)*XX(294)-JVS(890)*XX(295)-JVS(894)*XX(296)-JVS(900)*XX(297)-JVS(903)*XX(298)&
              &-JVS(908)*XX(299)-JVS(912)*XX(300)-JVS(917)*XX(301)-JVS(921)*XX(302)-JVS(927)*XX(303)-JVS(933)*XX(304)&
              &-JVS(940)*XX(305)-JVS(956)*XX(307)-JVS(963)*XX(308)-JVS(969)*XX(309)-JVS(973)*XX(310)-JVS(980)*XX(311)&
              &-JVS(997)*XX(312)-JVS(1003)*XX(313)-JVS(1015)*XX(315)-JVS(1020)*XX(316)-JVS(1038)*XX(318)-JVS(1042)*XX(319)&
              &-JVS(1048)*XX(320)-JVS(1057)*XX(321)-JVS(1064)*XX(322)-JVS(1081)*XX(324)-JVS(1092)*XX(325)-JVS(1103)*XX(326)&
              &-JVS(1117)*XX(327)-JVS(1135)*XX(329)-JVS(1153)*XX(331)-JVS(1163)*XX(332)-JVS(1171)*XX(333)-JVS(1181)*XX(334)&
              &-JVS(1191)*XX(335)-JVS(1230)*XX(337)-JVS(1243)*XX(338)-JVS(1250)*XX(339)-JVS(1259)*XX(340)-JVS(1271)*XX(341)&
              &-JVS(1288)*XX(343)-JVS(1307)*XX(344)-JVS(1320)*XX(345)-JVS(1329)*XX(346)-JVS(1340)*XX(347)-JVS(1349)*XX(348)&
              &-JVS(1359)*XX(349)-JVS(1374)*XX(350)-JVS(1384)*XX(351)-JVS(1398)*XX(352)-JVS(1409)*XX(353)-JVS(1443)*XX(354)&
              &-JVS(1465)*XX(355)-JVS(1494)*XX(356)-JVS(1510)*XX(357)-JVS(1524)*XX(358)-JVS(1532)*XX(359)-JVS(1546)*XX(360)&
              &-JVS(1559)*XX(361)-JVS(1569)*XX(362)-JVS(1582)*XX(363)-JVS(1624)*XX(364)-JVS(1640)*XX(365)-JVS(1655)*XX(366)&
              &-JVS(1666)*XX(367)-JVS(1706)*XX(368)-JVS(1728)*XX(369)-JVS(1752)*XX(370)-JVS(1771)*XX(371)-JVS(1820)*XX(372)&
              &-JVS(1849)*XX(373)-JVS(1889)*XX(374)-JVS(1907)*XX(375)-JVS(1941)*XX(376)-JVS(1959)*XX(377)-JVS(2012)*XX(378)&
              &-JVS(2037)*XX(379)-JVS(2110)*XX(380)-JVS(2194)*XX(381)-JVS(2282)*XX(382))/(JVS(2415))
  XX(384) = (X(384)-JVS(16)*XX(6)-JVS(22)*XX(8)-JVS(28)*XX(10)-JVS(50)*XX(12)-JVS(58)*XX(14)-JVS(61)*XX(15)-JVS(71)&
              &*XX(18)-JVS(74)*XX(19)-JVS(77)*XX(20)-JVS(80)*XX(21)-JVS(83)*XX(22)-JVS(86)*XX(23)-JVS(89)*XX(24)-JVS(92)&
              &*XX(25)-JVS(95)*XX(26)-JVS(98)*XX(27)-JVS(101)*XX(28)-JVS(104)*XX(29)-JVS(107)*XX(30)-JVS(110)*XX(31)&
              &-JVS(113)*XX(32)-JVS(116)*XX(33)-JVS(119)*XX(34)-JVS(125)*XX(36)-JVS(128)*XX(37)-JVS(131)*XX(38)-JVS(143)&
              &*XX(42)-JVS(146)*XX(43)-JVS(149)*XX(44)-JVS(155)*XX(46)-JVS(158)*XX(47)-JVS(161)*XX(48)-JVS(164)*XX(49)&
              &-JVS(170)*XX(51)-JVS(173)*XX(52)-JVS(182)*XX(55)-JVS(190)*XX(58)-JVS(193)*XX(59)-JVS(196)*XX(60)-JVS(199)&
              &*XX(61)-JVS(202)*XX(62)-JVS(208)*XX(64)-JVS(214)*XX(66)-JVS(220)*XX(68)-JVS(226)*XX(70)-JVS(232)*XX(72)&
              &-JVS(238)*XX(74)-JVS(249)*XX(78)-JVS(275)*XX(89)-JVS(320)*XX(104)-JVS(737)*XX(258)-JVS(748)*XX(261)-JVS(753)&
              &*XX(262)-JVS(763)*XX(265)-JVS(813)*XX(280)-JVS(868)*XX(292)-JVS(928)*XX(303)-JVS(934)*XX(304)-JVS(957)&
              &*XX(307)-JVS(974)*XX(310)-JVS(981)*XX(311)-JVS(1004)*XX(313)-JVS(1009)*XX(314)-JVS(1039)*XX(318)-JVS(1065)&
              &*XX(322)-JVS(1070)*XX(323)-JVS(1082)*XX(324)-JVS(1104)*XX(326)-JVS(1118)*XX(327)-JVS(1128)*XX(328)-JVS(1146)&
              &*XX(330)-JVS(1154)*XX(331)-JVS(1164)*XX(332)-JVS(1172)*XX(333)-JVS(1182)*XX(334)-JVS(1192)*XX(335)-JVS(1201)&
              &*XX(336)-JVS(1231)*XX(337)-JVS(1244)*XX(338)-JVS(1251)*XX(339)-JVS(1260)*XX(340)-JVS(1272)*XX(341)-JVS(1278)&
              &*XX(342)-JVS(1289)*XX(343)-JVS(1308)*XX(344)-JVS(1321)*XX(345)-JVS(1330)*XX(346)-JVS(1341)*XX(347)-JVS(1360)&
              &*XX(349)-JVS(1375)*XX(350)-JVS(1385)*XX(351)-JVS(1399)*XX(352)-JVS(1410)*XX(353)-JVS(1444)*XX(354)-JVS(1495)&
              &*XX(356)-JVS(1511)*XX(357)-JVS(1525)*XX(358)-JVS(1533)*XX(359)-JVS(1547)*XX(360)-JVS(1560)*XX(361)-JVS(1570)&
              &*XX(362)-JVS(1583)*XX(363)-JVS(1625)*XX(364)-JVS(1641)*XX(365)-JVS(1656)*XX(366)-JVS(1667)*XX(367)-JVS(1707)&
              &*XX(368)-JVS(1729)*XX(369)-JVS(1753)*XX(370)-JVS(1772)*XX(371)-JVS(1821)*XX(372)-JVS(1850)*XX(373)-JVS(1890)&
              &*XX(374)-JVS(1908)*XX(375)-JVS(1942)*XX(376)-JVS(1960)*XX(377)-JVS(2013)*XX(378)-JVS(2038)*XX(379)-JVS(2111)&
              &*XX(380)-JVS(2195)*XX(381)-JVS(2283)*XX(382)-JVS(2416)*XX(383))/(JVS(2483))
  XX(385) = (X(385)-JVS(51)*XX(12)-JVS(655)*XX(227)-JVS(658)*XX(228)-JVS(661)*XX(229)-JVS(664)*XX(230)-JVS(667)*XX(231)&
              &-JVS(670)*XX(232)-JVS(673)*XX(233)-JVS(1129)*XX(328)-JVS(1147)*XX(330)-JVS(1193)*XX(335)-JVS(1202)*XX(336)&
              &-JVS(1290)*XX(343)-JVS(1309)*XX(344)-JVS(1496)*XX(356)-JVS(1626)*XX(364)-JVS(1668)*XX(367)-JVS(1708)*XX(368)&
              &-JVS(1822)*XX(372)-JVS(1891)*XX(374)-JVS(1909)*XX(375)-JVS(1943)*XX(376)-JVS(1961)*XX(377)-JVS(2014)*XX(378)&
              &-JVS(2039)*XX(379)-JVS(2112)*XX(380)-JVS(2196)*XX(381)-JVS(2284)*XX(382)-JVS(2417)*XX(383)-JVS(2484)*XX(384))&
              &/(JVS(2547))
  XX(386) = (X(386)-JVS(421)*XX(140)-JVS(423)*XX(141)-JVS(426)*XX(142)-JVS(429)*XX(143)-JVS(432)*XX(144)-JVS(435)&
              &*XX(145)-JVS(438)*XX(146)-JVS(449)*XX(150)-JVS(473)*XX(158)-JVS(476)*XX(159)-JVS(480)*XX(160)-JVS(483)&
              &*XX(161)-JVS(716)*XX(249)-JVS(718)*XX(250)-JVS(720)*XX(251)-JVS(722)*XX(252)-JVS(724)*XX(253)-JVS(726)&
              &*XX(254)-JVS(728)*XX(255)-JVS(730)*XX(256)-JVS(740)*XX(259)-JVS(744)*XX(260)-JVS(776)*XX(269)-JVS(779)&
              &*XX(270)-JVS(793)*XX(274)-JVS(796)*XX(275)-JVS(799)*XX(276)-JVS(802)*XX(277)-JVS(830)*XX(285)-JVS(1021)&
              &*XX(316)-JVS(1058)*XX(321)-JVS(1136)*XX(329)-JVS(1466)*XX(355)-JVS(1773)*XX(371)-JVS(1851)*XX(373)-JVS(2113)&
              &*XX(380)-JVS(2197)*XX(381)-JVS(2285)*XX(382)-JVS(2418)*XX(383)-JVS(2485)*XX(384)-JVS(2548)*XX(385))&
              &/(JVS(2591))
  XX(387) = (X(387)-JVS(395)*XX(131)-JVS(477)*XX(159)-JVS(520)*XX(174)-JVS(529)*XX(177)-JVS(857)*XX(290)-JVS(876)&
              &*XX(293)-JVS(1022)*XX(316)-JVS(1093)*XX(325)-JVS(1350)*XX(348)-JVS(1445)*XX(354)-JVS(1467)*XX(355)-JVS(1774)&
              &*XX(371)-JVS(1852)*XX(373)-JVS(2114)*XX(380)-JVS(2198)*XX(381)-JVS(2286)*XX(382)-JVS(2419)*XX(383)-JVS(2486)&
              &*XX(384)-JVS(2549)*XX(385)-JVS(2592)*XX(386))/(JVS(2624))
  XX(388) = (X(388)-JVS(52)*XX(12)-JVS(278)*XX(90)-JVS(280)*XX(91)-JVS(283)*XX(92)-JVS(317)*XX(103)-JVS(335)*XX(109)&
              &-JVS(347)*XX(113)-JVS(350)*XX(114)-JVS(353)*XX(115)-JVS(368)*XX(120)-JVS(373)*XX(122)-JVS(376)*XX(123)&
              &-JVS(418)*XX(139)-JVS(440)*XX(147)-JVS(450)*XX(150)-JVS(465)*XX(155)-JVS(869)*XX(292)-JVS(935)*XX(304)&
              &-JVS(975)*XX(310)-JVS(982)*XX(311)-JVS(1016)*XX(315)-JVS(1023)*XX(316)-JVS(1043)*XX(319)-JVS(1049)*XX(320)&
              &-JVS(1083)*XX(324)-JVS(1105)*XX(326)-JVS(1119)*XX(327)-JVS(1130)*XX(328)-JVS(1137)*XX(329)-JVS(1148)*XX(330)&
              &-JVS(1173)*XX(333)-JVS(1194)*XX(335)-JVS(1203)*XX(336)-JVS(1245)*XX(338)-JVS(1261)*XX(340)-JVS(1273)*XX(341)&
              &-JVS(1291)*XX(343)-JVS(1310)*XX(344)-JVS(1322)*XX(345)-JVS(1361)*XX(349)-JVS(1446)*XX(354)-JVS(1497)*XX(356)&
              &-JVS(1534)*XX(359)-JVS(1548)*XX(360)-JVS(1561)*XX(361)-JVS(1571)*XX(362)-JVS(1584)*XX(363)-JVS(1627)*XX(364)&
              &-JVS(1642)*XX(365)-JVS(1657)*XX(366)-JVS(1669)*XX(367)-JVS(1709)*XX(368)-JVS(1730)*XX(369)-JVS(1754)*XX(370)&
              &-JVS(1775)*XX(371)-JVS(1823)*XX(372)-JVS(1853)*XX(373)-JVS(1892)*XX(374)-JVS(1910)*XX(375)-JVS(1944)*XX(376)&
              &-JVS(1962)*XX(377)-JVS(2015)*XX(378)-JVS(2040)*XX(379)-JVS(2115)*XX(380)-JVS(2199)*XX(381)-JVS(2287)*XX(382)&
              &-JVS(2420)*XX(383)-JVS(2487)*XX(384)-JVS(2550)*XX(385)-JVS(2593)*XX(386)-JVS(2625)*XX(387))/(JVS(2664))
  XX(389) = (X(389)-JVS(593)*XX(200)-JVS(596)*XX(201)-JVS(599)*XX(202)-JVS(602)*XX(203)-JVS(605)*XX(204)-JVS(708)&
              &*XX(246)-JVS(805)*XX(278)-JVS(877)*XX(293)-JVS(904)*XX(298)-JVS(1032)*XX(317)-JVS(1094)*XX(325)-JVS(1165)&
              &*XX(332)-JVS(1183)*XX(334)-JVS(1232)*XX(337)-JVS(1342)*XX(347)-JVS(1376)*XX(350)-JVS(1447)*XX(354)-JVS(1512)&
              &*XX(357)-JVS(1628)*XX(364)-JVS(1710)*XX(368)-JVS(1755)*XX(370)-JVS(1776)*XX(371)-JVS(1824)*XX(372)-JVS(1854)&
              &*XX(373)-JVS(1893)*XX(374)-JVS(1945)*XX(376)-JVS(2016)*XX(378)-JVS(2041)*XX(379)-JVS(2116)*XX(380)-JVS(2200)&
              &*XX(381)-JVS(2288)*XX(382)-JVS(2421)*XX(383)-JVS(2488)*XX(384)-JVS(2551)*XX(385)-JVS(2594)*XX(386)-JVS(2626)&
              &*XX(387)-JVS(2665)*XX(388))/(JVS(2708))
  XX(390) = (X(390)-JVS(13)*XX(5)-JVS(19)*XX(7)-JVS(25)*XX(9)-JVS(53)*XX(12)-JVS(59)*XX(14)-JVS(134)*XX(39)-JVS(137)&
              &*XX(40)-JVS(140)*XX(41)-JVS(167)*XX(50)-JVS(176)*XX(53)-JVS(185)*XX(56)-JVS(244)*XX(76)-JVS(260)*XX(82)&
              &-JVS(281)*XX(91)-JVS(286)*XX(93)-JVS(314)*XX(102)-JVS(446)*XX(149)-JVS(551)*XX(186)-JVS(581)*XX(196)-JVS(738)&
              &*XX(258)-JVS(749)*XX(261)-JVS(754)*XX(262)-JVS(770)*XX(267)-JVS(809)*XX(279)-JVS(817)*XX(281)-JVS(821)&
              &*XX(282)-JVS(841)*XX(287)-JVS(845)*XX(288)-JVS(848)*XX(289)-JVS(863)*XX(291)-JVS(870)*XX(292)-JVS(891)&
              &*XX(295)-JVS(895)*XX(296)-JVS(901)*XX(297)-JVS(909)*XX(299)-JVS(913)*XX(300)-JVS(918)*XX(301)-JVS(922)&
              &*XX(302)-JVS(929)*XX(303)-JVS(941)*XX(305)-JVS(958)*XX(307)-JVS(964)*XX(308)-JVS(970)*XX(309)-JVS(983)&
              &*XX(311)-JVS(1005)*XX(313)-JVS(1010)*XX(314)-JVS(1024)*XX(316)-JVS(1040)*XX(318)-JVS(1066)*XX(322)-JVS(1071)&
              &*XX(323)-JVS(1084)*XX(324)-JVS(1095)*XX(325)-JVS(1106)*XX(326)-JVS(1120)*XX(327)-JVS(1155)*XX(331)-JVS(1166)&
              &*XX(332)-JVS(1184)*XX(334)-JVS(1233)*XX(337)-JVS(1252)*XX(339)-JVS(1262)*XX(340)-JVS(1274)*XX(341)-JVS(1279)&
              &*XX(342)-JVS(1311)*XX(344)-JVS(1323)*XX(345)-JVS(1331)*XX(346)-JVS(1343)*XX(347)-JVS(1362)*XX(349)-JVS(1377)&
              &*XX(350)-JVS(1386)*XX(351)-JVS(1400)*XX(352)-JVS(1411)*XX(353)-JVS(1448)*XX(354)-JVS(1468)*XX(355)-JVS(1498)&
              &*XX(356)-JVS(1513)*XX(357)-JVS(1526)*XX(358)-JVS(1549)*XX(360)-JVS(1562)*XX(361)-JVS(1572)*XX(362)-JVS(1585)&
              &*XX(363)-JVS(1629)*XX(364)-JVS(1643)*XX(365)-JVS(1658)*XX(366)-JVS(1711)*XX(368)-JVS(1731)*XX(369)-JVS(1756)&
              &*XX(370)-JVS(1777)*XX(371)-JVS(1825)*XX(372)-JVS(1855)*XX(373)-JVS(1894)*XX(374)-JVS(1911)*XX(375)-JVS(1946)&
              &*XX(376)-JVS(1963)*XX(377)-JVS(2017)*XX(378)-JVS(2042)*XX(379)-JVS(2117)*XX(380)-JVS(2201)*XX(381)-JVS(2289)&
              &*XX(382)-JVS(2422)*XX(383)-JVS(2489)*XX(384)-JVS(2552)*XX(385)-JVS(2595)*XX(386)-JVS(2627)*XX(387)-JVS(2666)&
              &*XX(388)-JVS(2709)*XX(389))/(JVS(2804))
  XX(391) = (X(391)-JVS(261)*XX(82)-JVS(264)*XX(83)-JVS(611)*XX(206)-JVS(614)*XX(207)-JVS(827)*XX(284)-JVS(836)*XX(286)&
              &-JVS(1025)*XX(316)-JVS(1059)*XX(321)-JVS(1138)*XX(329)-JVS(1312)*XX(344)-JVS(1351)*XX(348)-JVS(1449)*XX(354)&
              &-JVS(1469)*XX(355)-JVS(1856)*XX(373)-JVS(2118)*XX(380)-JVS(2202)*XX(381)-JVS(2290)*XX(382)-JVS(2423)*XX(383)&
              &-JVS(2490)*XX(384)-JVS(2553)*XX(385)-JVS(2596)*XX(386)-JVS(2628)*XX(387)-JVS(2667)*XX(388)-JVS(2710)*XX(389)&
              &-JVS(2805)*XX(390))/(JVS(2855))
  XX(392) = (X(392)-JVS(54)*XX(12)-JVS(62)*XX(15)-JVS(122)*XX(35)-JVS(284)*XX(92)-JVS(323)*XX(105)-JVS(486)*XX(162)&
              &-JVS(554)*XX(187)-JVS(557)*XX(188)-JVS(560)*XX(189)-JVS(782)*XX(271)-JVS(837)*XX(286)-JVS(849)*XX(289)&
              &-JVS(998)*XX(312)-JVS(1060)*XX(321)-JVS(1067)*XX(322)-JVS(1072)*XX(323)-JVS(1085)*XX(324)-JVS(1121)*XX(327)&
              &-JVS(1156)*XX(331)-JVS(1167)*XX(332)-JVS(1174)*XX(333)-JVS(1185)*XX(334)-JVS(1234)*XX(337)-JVS(1263)*XX(340)&
              &-JVS(1280)*XX(342)-JVS(1324)*XX(345)-JVS(1332)*XX(346)-JVS(1344)*XX(347)-JVS(1363)*XX(349)-JVS(1378)*XX(350)&
              &-JVS(1387)*XX(351)-JVS(1401)*XX(352)-JVS(1412)*XX(353)-JVS(1450)*XX(354)-JVS(1470)*XX(355)-JVS(1499)*XX(356)&
              &-JVS(1514)*XX(357)-JVS(1527)*XX(358)-JVS(1535)*XX(359)-JVS(1550)*XX(360)-JVS(1563)*XX(361)-JVS(1573)*XX(362)&
              &-JVS(1586)*XX(363)-JVS(1630)*XX(364)-JVS(1644)*XX(365)-JVS(1659)*XX(366)-JVS(1712)*XX(368)-JVS(1732)*XX(369)&
              &-JVS(1757)*XX(370)-JVS(1826)*XX(372)-JVS(1857)*XX(373)-JVS(1895)*XX(374)-JVS(1912)*XX(375)-JVS(1947)*XX(376)&
              &-JVS(1964)*XX(377)-JVS(2018)*XX(378)-JVS(2043)*XX(379)-JVS(2119)*XX(380)-JVS(2203)*XX(381)-JVS(2291)*XX(382)&
              &-JVS(2424)*XX(383)-JVS(2491)*XX(384)-JVS(2554)*XX(385)-JVS(2597)*XX(386)-JVS(2629)*XX(387)-JVS(2668)*XX(388)&
              &-JVS(2711)*XX(389)-JVS(2806)*XX(390)-JVS(2856)*XX(391))/(JVS(2923))
  XX(393) = (X(393)-JVS(10)*XX(4)-JVS(287)*XX(93)-JVS(290)*XX(94)-JVS(293)*XX(95)-JVS(296)*XX(96)-JVS(299)*XX(97)&
              &-JVS(302)*XX(98)-JVS(305)*XX(99)-JVS(308)*XX(100)-JVS(326)*XX(106)-JVS(329)*XX(107)-JVS(332)*XX(108)-JVS(338)&
              &*XX(110)-JVS(341)*XX(111)-JVS(344)*XX(112)-JVS(356)*XX(116)-JVS(359)*XX(117)-JVS(362)*XX(118)-JVS(365)&
              &*XX(119)-JVS(370)*XX(121)-JVS(380)*XX(125)-JVS(386)*XX(127)-JVS(458)*XX(153)-JVS(534)*XX(179)-JVS(760)&
              &*XX(264)-JVS(824)*XX(283)-JVS(905)*XX(298)-JVS(945)*XX(306)-JVS(1044)*XX(319)-JVS(1050)*XX(320)-JVS(1073)&
              &*XX(323)-JVS(1122)*XX(327)-JVS(1139)*XX(329)-JVS(1195)*XX(335)-JVS(1246)*XX(338)-JVS(1253)*XX(339)-JVS(1264)&
              &*XX(340)-JVS(1281)*XX(342)-JVS(1292)*XX(343)-JVS(1313)*XX(344)-JVS(1325)*XX(345)-JVS(1333)*XX(346)-JVS(1364)&
              &*XX(349)-JVS(1379)*XX(350)-JVS(1402)*XX(352)-JVS(1451)*XX(354)-JVS(1471)*XX(355)-JVS(1500)*XX(356)-JVS(1515)&
              &*XX(357)-JVS(1528)*XX(358)-JVS(1536)*XX(359)-JVS(1551)*XX(360)-JVS(1564)*XX(361)-JVS(1574)*XX(362)-JVS(1587)&
              &*XX(363)-JVS(1631)*XX(364)-JVS(1645)*XX(365)-JVS(1660)*XX(366)-JVS(1670)*XX(367)-JVS(1713)*XX(368)-JVS(1733)&
              &*XX(369)-JVS(1758)*XX(370)-JVS(1778)*XX(371)-JVS(1827)*XX(372)-JVS(1858)*XX(373)-JVS(1896)*XX(374)-JVS(1913)&
              &*XX(375)-JVS(1948)*XX(376)-JVS(1965)*XX(377)-JVS(2019)*XX(378)-JVS(2044)*XX(379)-JVS(2120)*XX(380)-JVS(2204)&
              &*XX(381)-JVS(2292)*XX(382)-JVS(2425)*XX(383)-JVS(2492)*XX(384)-JVS(2555)*XX(385)-JVS(2598)*XX(386)-JVS(2630)&
              &*XX(387)-JVS(2669)*XX(388)-JVS(2712)*XX(389)-JVS(2807)*XX(390)-JVS(2857)*XX(391)-JVS(2924)*XX(392))&
              &/(JVS(2990))
  XX(394) = (X(394)-JVS(474)*XX(158)-JVS(514)*XX(172)-JVS(517)*XX(173)-JVS(523)*XX(175)-JVS(526)*XX(176)-JVS(532)&
              &*XX(178)-JVS(790)*XX(273)-JVS(858)*XX(290)-JVS(946)*XX(306)-JVS(1026)*XX(316)-JVS(1033)*XX(317)-JVS(1061)&
              &*XX(321)-JVS(1096)*XX(325)-JVS(1352)*XX(348)-JVS(1452)*XX(354)-JVS(1472)*XX(355)-JVS(1779)*XX(371)-JVS(1859)&
              &*XX(373)-JVS(2121)*XX(380)-JVS(2205)*XX(381)-JVS(2293)*XX(382)-JVS(2426)*XX(383)-JVS(2493)*XX(384)-JVS(2556)&
              &*XX(385)-JVS(2599)*XX(386)-JVS(2631)*XX(387)-JVS(2670)*XX(388)-JVS(2713)*XX(389)-JVS(2808)*XX(390)-JVS(2858)&
              &*XX(391)-JVS(2925)*XX(392)-JVS(2991)*XX(393))/(JVS(3024))
  XX(395) = (X(395)-JVS(393)*XX(130)-JVS(396)*XX(131)-JVS(441)*XX(147)-JVS(444)*XX(148)-JVS(447)*XX(149)-JVS(453)&
              &*XX(151)-JVS(456)*XX(152)-JVS(459)*XX(153)-JVS(462)*XX(154)-JVS(468)*XX(156)-JVS(471)*XX(157)-JVS(501)&
              &*XX(167)-JVS(757)*XX(263)-JVS(1027)*XX(316)-JVS(1097)*XX(325)-JVS(1314)*XX(344)-JVS(1353)*XX(348)-JVS(1453)&
              &*XX(354)-JVS(1473)*XX(355)-JVS(1780)*XX(371)-JVS(1860)*XX(373)-JVS(2045)*XX(379)-JVS(2122)*XX(380)-JVS(2206)&
              &*XX(381)-JVS(2294)*XX(382)-JVS(2427)*XX(383)-JVS(2494)*XX(384)-JVS(2557)*XX(385)-JVS(2600)*XX(386)-JVS(2632)&
              &*XX(387)-JVS(2671)*XX(388)-JVS(2714)*XX(389)-JVS(2809)*XX(390)-JVS(2859)*XX(391)-JVS(2926)*XX(392)-JVS(2992)&
              &*XX(393)-JVS(3025)*XX(394))/(JVS(3075))
  XX(395) = XX(395)
  XX(394) = XX(394)-JVS(3074)*XX(395)
  XX(393) = XX(393)-JVS(3023)*XX(394)-JVS(3073)*XX(395)
  XX(392) = XX(392)-JVS(2989)*XX(393)-JVS(3022)*XX(394)-JVS(3072)*XX(395)
  XX(391) = XX(391)-JVS(2922)*XX(392)-JVS(2988)*XX(393)-JVS(3021)*XX(394)-JVS(3071)*XX(395)
  XX(390) = XX(390)-JVS(2854)*XX(391)-JVS(2921)*XX(392)-JVS(2987)*XX(393)-JVS(3020)*XX(394)-JVS(3070)*XX(395)
  XX(389) = XX(389)-JVS(2803)*XX(390)-JVS(2853)*XX(391)-JVS(2920)*XX(392)-JVS(2986)*XX(393)-JVS(3019)*XX(394)-JVS(3069)&
              &*XX(395)
  XX(388) = XX(388)-JVS(2707)*XX(389)-JVS(2802)*XX(390)-JVS(2852)*XX(391)-JVS(2919)*XX(392)-JVS(2985)*XX(393)-JVS(3018)&
              &*XX(394)-JVS(3068)*XX(395)
  XX(387) = XX(387)-JVS(2663)*XX(388)-JVS(2706)*XX(389)-JVS(2801)*XX(390)-JVS(2851)*XX(391)-JVS(2918)*XX(392)-JVS(2984)&
              &*XX(393)-JVS(3017)*XX(394)-JVS(3067)*XX(395)
  XX(386) = XX(386)-JVS(2623)*XX(387)-JVS(2662)*XX(388)-JVS(2705)*XX(389)-JVS(2800)*XX(390)-JVS(2850)*XX(391)-JVS(2917)&
              &*XX(392)-JVS(2983)*XX(393)-JVS(3016)*XX(394)-JVS(3066)*XX(395)
  XX(385) = XX(385)-JVS(2590)*XX(386)-JVS(2622)*XX(387)-JVS(2661)*XX(388)-JVS(2704)*XX(389)-JVS(2799)*XX(390)-JVS(2849)&
              &*XX(391)-JVS(2916)*XX(392)-JVS(2982)*XX(393)-JVS(3015)*XX(394)-JVS(3065)*XX(395)
  XX(384) = XX(384)-JVS(2546)*XX(385)-JVS(2589)*XX(386)-JVS(2621)*XX(387)-JVS(2660)*XX(388)-JVS(2703)*XX(389)-JVS(2798)&
              &*XX(390)-JVS(2848)*XX(391)-JVS(2915)*XX(392)-JVS(2981)*XX(393)-JVS(3014)*XX(394)-JVS(3064)*XX(395)
  XX(383) = XX(383)-JVS(2482)*XX(384)-JVS(2545)*XX(385)-JVS(2588)*XX(386)-JVS(2620)*XX(387)-JVS(2659)*XX(388)-JVS(2702)&
              &*XX(389)-JVS(2797)*XX(390)-JVS(2847)*XX(391)-JVS(2914)*XX(392)-JVS(2980)*XX(393)-JVS(3013)*XX(394)-JVS(3063)&
              &*XX(395)
  XX(382) = XX(382)-JVS(2414)*XX(383)-JVS(2481)*XX(384)-JVS(2544)*XX(385)-JVS(2587)*XX(386)-JVS(2619)*XX(387)-JVS(2658)&
              &*XX(388)-JVS(2701)*XX(389)-JVS(2796)*XX(390)-JVS(2846)*XX(391)-JVS(2913)*XX(392)-JVS(2979)*XX(393)-JVS(3012)&
              &*XX(394)-JVS(3062)*XX(395)
  XX(381) = XX(381)-JVS(2280)*XX(382)-JVS(2413)*XX(383)-JVS(2480)*XX(384)-JVS(2543)*XX(385)-JVS(2586)*XX(386)-JVS(2618)&
              &*XX(387)-JVS(2657)*XX(388)-JVS(2700)*XX(389)-JVS(2795)*XX(390)-JVS(2845)*XX(391)-JVS(2912)*XX(392)-JVS(2978)&
              &*XX(393)-JVS(3011)*XX(394)-JVS(3061)*XX(395)
  XX(380) = XX(380)-JVS(2191)*XX(381)-JVS(2279)*XX(382)-JVS(2412)*XX(383)-JVS(2542)*XX(385)-JVS(2617)*XX(387)-JVS(2656)&
              &*XX(388)-JVS(2699)*XX(389)-JVS(2794)*XX(390)-JVS(2844)*XX(391)-JVS(2977)*XX(393)-JVS(3010)*XX(394)-JVS(3060)&
              &*XX(395)
  XX(379) = XX(379)-JVS(2106)*XX(380)-JVS(2190)*XX(381)-JVS(2278)*XX(382)-JVS(2411)*XX(383)-JVS(2479)*XX(384)-JVS(2541)&
              &*XX(385)-JVS(2585)*XX(386)-JVS(2616)*XX(387)-JVS(2655)*XX(388)-JVS(2698)*XX(389)-JVS(2793)*XX(390)-JVS(2843)&
              &*XX(391)-JVS(2911)*XX(392)-JVS(2976)*XX(393)-JVS(3009)*XX(394)-JVS(3059)*XX(395)
  XX(378) = XX(378)-JVS(2033)*XX(379)-JVS(2105)*XX(380)-JVS(2189)*XX(381)-JVS(2277)*XX(382)-JVS(2410)*XX(383)-JVS(2478)&
              &*XX(384)-JVS(2540)*XX(385)-JVS(2584)*XX(386)-JVS(2615)*XX(387)-JVS(2654)*XX(388)-JVS(2697)*XX(389)-JVS(2792)&
              &*XX(390)-JVS(2842)*XX(391)-JVS(2910)*XX(392)-JVS(2975)*XX(393)-JVS(3008)*XX(394)-JVS(3058)*XX(395)
  XX(377) = XX(377)-JVS(2007)*XX(378)-JVS(2032)*XX(379)-JVS(2104)*XX(380)-JVS(2188)*XX(381)-JVS(2276)*XX(382)-JVS(2409)&
              &*XX(383)-JVS(2477)*XX(384)-JVS(2539)*XX(385)-JVS(2583)*XX(386)-JVS(2614)*XX(387)-JVS(2653)*XX(388)-JVS(2696)&
              &*XX(389)-JVS(2791)*XX(390)-JVS(2841)*XX(391)-JVS(2909)*XX(392)-JVS(2974)*XX(393)-JVS(3007)*XX(394)-JVS(3057)&
              &*XX(395)
  XX(376) = XX(376)-JVS(2006)*XX(378)-JVS(2103)*XX(380)-JVS(2187)*XX(381)-JVS(2275)*XX(382)-JVS(2408)*XX(383)-JVS(2538)&
              &*XX(385)-JVS(2582)*XX(386)-JVS(2613)*XX(387)-JVS(2652)*XX(388)-JVS(2695)*XX(389)-JVS(2790)*XX(390)-JVS(2840)&
              &*XX(391)-JVS(2908)*XX(392)-JVS(2973)*XX(393)-JVS(3006)*XX(394)-JVS(3056)*XX(395)
  XX(375) = XX(375)-JVS(1934)*XX(376)-JVS(2005)*XX(378)-JVS(2031)*XX(379)-JVS(2102)*XX(380)-JVS(2186)*XX(381)-JVS(2274)&
              &*XX(382)-JVS(2407)*XX(383)-JVS(2476)*XX(384)-JVS(2537)*XX(385)-JVS(2612)*XX(387)-JVS(2651)*XX(388)-JVS(2694)&
              &*XX(389)-JVS(2789)*XX(390)-JVS(2839)*XX(391)-JVS(2907)*XX(392)-JVS(2972)*XX(393)-JVS(3005)*XX(394)-JVS(3055)&
              &*XX(395)
  XX(374) = XX(374)-JVS(1933)*XX(376)-JVS(2004)*XX(378)-JVS(2101)*XX(380)-JVS(2185)*XX(381)-JVS(2273)*XX(382)-JVS(2406)&
              &*XX(383)-JVS(2475)*XX(384)-JVS(2536)*XX(385)-JVS(2611)*XX(387)-JVS(2650)*XX(388)-JVS(2693)*XX(389)-JVS(2788)&
              &*XX(390)-JVS(2906)*XX(392)-JVS(2971)*XX(393)
  XX(373) = XX(373)-JVS(2100)*XX(380)-JVS(2184)*XX(381)-JVS(2272)*XX(382)-JVS(2405)*XX(383)-JVS(2474)*XX(384)-JVS(2581)&
              &*XX(386)-JVS(2610)*XX(387)-JVS(2692)*XX(389)-JVS(2787)*XX(390)-JVS(2838)*XX(391)-JVS(2905)*XX(392)-JVS(2970)&
              &*XX(393)-JVS(3004)*XX(394)-JVS(3054)*XX(395)
  XX(372) = XX(372)-JVS(1932)*XX(376)-JVS(2003)*XX(378)-JVS(2099)*XX(380)-JVS(2183)*XX(381)-JVS(2271)*XX(382)-JVS(2404)&
              &*XX(383)-JVS(2473)*XX(384)-JVS(2535)*XX(385)-JVS(2649)*XX(388)-JVS(2786)*XX(390)-JVS(2904)*XX(392)-JVS(2969)&
              &*XX(393)
  XX(371) = XX(371)-JVS(1845)*XX(373)-JVS(2182)*XX(381)-JVS(2270)*XX(382)-JVS(2403)*XX(383)-JVS(2472)*XX(384)-JVS(2580)&
              &*XX(386)-JVS(2609)*XX(387)-JVS(2691)*XX(389)-JVS(2785)*XX(390)-JVS(2837)*XX(391)-JVS(2968)*XX(393)-JVS(3003)&
              &*XX(394)-JVS(3053)*XX(395)
  XX(370) = XX(370)-JVS(1811)*XX(372)-JVS(1881)*XX(374)-JVS(1931)*XX(376)-JVS(2002)*XX(378)-JVS(2098)*XX(380)-JVS(2181)&
              &*XX(381)-JVS(2269)*XX(382)-JVS(2402)*XX(383)-JVS(2471)*XX(384)-JVS(2534)*XX(385)-JVS(2608)*XX(387)-JVS(2690)&
              &*XX(389)-JVS(2784)*XX(390)-JVS(2903)*XX(392)-JVS(2967)*XX(393)
  XX(369) = XX(369)-JVS(1746)*XX(370)-JVS(1810)*XX(372)-JVS(1880)*XX(374)-JVS(1930)*XX(376)-JVS(2001)*XX(378)-JVS(2097)&
              &*XX(380)-JVS(2180)*XX(381)-JVS(2268)*XX(382)-JVS(2401)*XX(383)-JVS(2470)*XX(384)-JVS(2533)*XX(385)-JVS(2607)&
              &*XX(387)-JVS(2689)*XX(389)-JVS(2783)*XX(390)-JVS(2902)*XX(392)-JVS(2966)*XX(393)
  XX(368) = XX(368)-JVS(2000)*XX(378)-JVS(2096)*XX(380)-JVS(2179)*XX(381)-JVS(2267)*XX(382)-JVS(2400)*XX(383)-JVS(2532)&
              &*XX(385)-JVS(2782)*XX(390)-JVS(2901)*XX(392)-JVS(2965)*XX(393)
  XX(367) = XX(367)-JVS(1695)*XX(368)-JVS(1809)*XX(372)-JVS(1879)*XX(374)-JVS(1901)*XX(375)-JVS(1999)*XX(378)-JVS(2030)&
              &*XX(379)-JVS(2095)*XX(380)-JVS(2178)*XX(381)-JVS(2266)*XX(382)-JVS(2399)*XX(383)-JVS(2469)*XX(384)-JVS(2531)&
              &*XX(385)-JVS(2781)*XX(390)-JVS(2836)*XX(391)-JVS(2900)*XX(392)-JVS(2964)*XX(393)-JVS(3002)*XX(394)-JVS(3052)&
              &*XX(395)
  XX(366) = XX(366)-JVS(1694)*XX(368)-JVS(1723)*XX(369)-JVS(1745)*XX(370)-JVS(1808)*XX(372)-JVS(1878)*XX(374)-JVS(1929)&
              &*XX(376)-JVS(1998)*XX(378)-JVS(2094)*XX(380)-JVS(2177)*XX(381)-JVS(2265)*XX(382)-JVS(2398)*XX(383)-JVS(2468)&
              &*XX(384)-JVS(2530)*XX(385)-JVS(2780)*XX(390)-JVS(2899)*XX(392)-JVS(2963)*XX(393)
  XX(365) = XX(365)-JVS(1651)*XX(366)-JVS(1693)*XX(368)-JVS(1722)*XX(369)-JVS(1744)*XX(370)-JVS(1807)*XX(372)-JVS(1928)&
              &*XX(376)-JVS(1997)*XX(378)-JVS(2093)*XX(380)-JVS(2176)*XX(381)-JVS(2264)*XX(382)-JVS(2397)*XX(383)-JVS(2467)&
              &*XX(384)-JVS(2529)*XX(385)-JVS(2779)*XX(390)-JVS(2898)*XX(392)-JVS(2962)*XX(393)
  XX(364) = XX(364)-JVS(1996)*XX(378)-JVS(2175)*XX(381)-JVS(2263)*XX(382)-JVS(2396)*XX(383)-JVS(2528)*XX(385)-JVS(2778)&
              &*XX(390)-JVS(2961)*XX(393)
  XX(363) = XX(363)-JVS(1609)*XX(364)-JVS(1692)*XX(368)-JVS(1721)*XX(369)-JVS(1806)*XX(372)-JVS(1877)*XX(374)-JVS(1995)&
              &*XX(378)-JVS(2029)*XX(379)-JVS(2092)*XX(380)-JVS(2174)*XX(381)-JVS(2262)*XX(382)-JVS(2395)*XX(383)-JVS(2466)&
              &*XX(384)-JVS(2527)*XX(385)-JVS(2648)*XX(388)-JVS(2777)*XX(390)-JVS(2835)*XX(391)-JVS(2897)*XX(392)-JVS(2960)&
              &*XX(393)-JVS(3001)*XX(394)-JVS(3051)*XX(395)
  XX(362) = XX(362)-JVS(1579)*XX(363)-JVS(1608)*XX(364)-JVS(1635)*XX(365)-JVS(1650)*XX(366)-JVS(1691)*XX(368)-JVS(1720)&
              &*XX(369)-JVS(1805)*XX(372)-JVS(1876)*XX(374)-JVS(1900)*XX(375)-JVS(1953)*XX(377)-JVS(1994)*XX(378)-JVS(2091)&
              &*XX(380)-JVS(2173)*XX(381)-JVS(2261)*XX(382)-JVS(2394)*XX(383)-JVS(2465)*XX(384)-JVS(2526)*XX(385)-JVS(2647)&
              &*XX(388)-JVS(2776)*XX(390)-JVS(2896)*XX(392)-JVS(2959)*XX(393)
  XX(361) = XX(361)-JVS(1578)*XX(363)-JVS(1607)*XX(364)-JVS(1649)*XX(366)-JVS(1690)*XX(368)-JVS(1743)*XX(370)-JVS(1804)&
              &*XX(372)-JVS(1875)*XX(374)-JVS(1899)*XX(375)-JVS(1927)*XX(376)-JVS(1952)*XX(377)-JVS(1993)*XX(378)-JVS(2090)&
              &*XX(380)-JVS(2172)*XX(381)-JVS(2260)*XX(382)-JVS(2393)*XX(383)-JVS(2464)*XX(384)-JVS(2525)*XX(385)-JVS(2646)&
              &*XX(388)-JVS(2775)*XX(390)-JVS(2895)*XX(392)-JVS(2958)*XX(393)
  XX(360) = XX(360)-JVS(1689)*XX(368)-JVS(1803)*XX(372)-JVS(1874)*XX(374)-JVS(1992)*XX(378)-JVS(2089)*XX(380)-JVS(2171)&
              &*XX(381)-JVS(2259)*XX(382)-JVS(2392)*XX(383)-JVS(2463)*XX(384)-JVS(2524)*XX(385)-JVS(2645)*XX(388)-JVS(2774)&
              &*XX(390)-JVS(2894)*XX(392)-JVS(2957)*XX(393)
  XX(359) = XX(359)-JVS(1540)*XX(360)-JVS(1556)*XX(361)-JVS(1688)*XX(368)-JVS(1742)*XX(370)-JVS(1802)*XX(372)-JVS(1873)&
              &*XX(374)-JVS(1926)*XX(376)-JVS(1991)*XX(378)-JVS(2088)*XX(380)-JVS(2170)*XX(381)-JVS(2258)*XX(382)-JVS(2391)&
              &*XX(383)-JVS(2462)*XX(384)-JVS(2523)*XX(385)-JVS(2644)*XX(388)-JVS(2773)*XX(390)-JVS(2893)*XX(392)-JVS(2956)&
              &*XX(393)
  XX(358) = XX(358)-JVS(1719)*XX(369)-JVS(1741)*XX(370)-JVS(1801)*XX(372)-JVS(1925)*XX(376)-JVS(1990)*XX(378)-JVS(2087)&
              &*XX(380)-JVS(2169)*XX(381)-JVS(2257)*XX(382)-JVS(2390)*XX(383)-JVS(2461)*XX(384)-JVS(2772)*XX(390)-JVS(2892)&
              &*XX(392)
  XX(357) = XX(357)-JVS(1606)*XX(364)-JVS(1687)*XX(368)-JVS(1740)*XX(370)-JVS(1872)*XX(374)-JVS(1989)*XX(378)-JVS(2086)&
              &*XX(380)-JVS(2168)*XX(381)-JVS(2256)*XX(382)-JVS(2389)*XX(383)-JVS(2460)*XX(384)-JVS(2771)*XX(390)-JVS(2891)&
              &*XX(392)
  XX(356) = XX(356)-JVS(2085)*XX(380)-JVS(2167)*XX(381)-JVS(2255)*XX(382)-JVS(2388)*XX(383)-JVS(2522)*XX(385)-JVS(2770)&
              &*XX(390)-JVS(2955)*XX(393)
  XX(355) = XX(355)-JVS(1844)*XX(373)-JVS(2166)*XX(381)-JVS(2387)*XX(383)-JVS(2579)*XX(386)-JVS(2606)*XX(387)-JVS(2688)&
              &*XX(389)-JVS(2834)*XX(391)-JVS(3000)*XX(394)-JVS(3050)*XX(395)
  XX(354) = XX(354)-JVS(2165)*XX(381)-JVS(2254)*XX(382)-JVS(2386)*XX(383)-JVS(2954)*XX(393)
  XX(353) = XX(353)-JVS(1605)*XX(364)-JVS(1686)*XX(368)-JVS(1800)*XX(372)-JVS(1871)*XX(374)-JVS(1988)*XX(378)-JVS(2084)&
              &*XX(380)-JVS(2164)*XX(381)-JVS(2253)*XX(382)-JVS(2385)*XX(383)-JVS(2459)*XX(384)-JVS(2521)*XX(385)-JVS(2769)&
              &*XX(390)-JVS(2890)*XX(392)-JVS(2953)*XX(393)
  XX(352) = XX(352)-JVS(1924)*XX(376)-JVS(1987)*XX(378)-JVS(2083)*XX(380)-JVS(2163)*XX(381)-JVS(2252)*XX(382)-JVS(2384)&
              &*XX(383)-JVS(2458)*XX(384)-JVS(2643)*XX(388)-JVS(2768)*XX(390)-JVS(2889)*XX(392)
  XX(351) = XX(351)-JVS(1423)*XX(354)-JVS(1482)*XX(356)-JVS(1604)*XX(364)-JVS(1685)*XX(368)-JVS(1718)*XX(369)-JVS(1799)&
              &*XX(372)-JVS(1870)*XX(374)-JVS(1986)*XX(378)-JVS(2082)*XX(380)-JVS(2162)*XX(381)-JVS(2251)*XX(382)-JVS(2383)&
              &*XX(383)-JVS(2457)*XX(384)-JVS(2520)*XX(385)-JVS(2642)*XX(388)-JVS(2767)*XX(390)-JVS(2888)*XX(392)-JVS(2952)&
              &*XX(393)
  XX(350) = XX(350)-JVS(1923)*XX(376)-JVS(1985)*XX(378)-JVS(2081)*XX(380)-JVS(2161)*XX(381)-JVS(2250)*XX(382)-JVS(2382)&
              &*XX(383)-JVS(2456)*XX(384)-JVS(2766)*XX(390)-JVS(2887)*XX(392)
  XX(349) = XX(349)-JVS(1481)*XX(356)-JVS(1603)*XX(364)-JVS(1798)*XX(372)-JVS(1869)*XX(374)-JVS(1984)*XX(378)-JVS(2080)&
              &*XX(380)-JVS(2160)*XX(381)-JVS(2249)*XX(382)-JVS(2381)*XX(383)-JVS(2455)*XX(384)-JVS(2765)*XX(390)-JVS(2886)&
              &*XX(392)-JVS(2951)*XX(393)
  XX(348) = XX(348)-JVS(1422)*XX(354)-JVS(1459)*XX(355)-JVS(1843)*XX(373)-JVS(2159)*XX(381)-JVS(2248)*XX(382)-JVS(2380)&
              &*XX(383)-JVS(2578)*XX(386)-JVS(2605)*XX(387)-JVS(2687)*XX(389)-JVS(2833)*XX(391)-JVS(2950)*XX(393)-JVS(2999)&
              &*XX(394)-JVS(3049)*XX(395)
  XX(347) = XX(347)-JVS(1504)*XX(357)-JVS(1797)*XX(372)-JVS(1983)*XX(378)-JVS(2079)*XX(380)-JVS(2158)*XX(381)-JVS(2247)&
              &*XX(382)-JVS(2379)*XX(383)-JVS(2454)*XX(384)-JVS(2519)*XX(385)-JVS(2604)*XX(387)-JVS(2686)*XX(389)-JVS(2764)&
              &*XX(390)-JVS(2885)*XX(392)
  XX(346) = XX(346)-JVS(1503)*XX(357)-JVS(1602)*XX(364)-JVS(1739)*XX(370)-JVS(1796)*XX(372)-JVS(1868)*XX(374)-JVS(1922)&
              &*XX(376)-JVS(1982)*XX(378)-JVS(2078)*XX(380)-JVS(2157)*XX(381)-JVS(2246)*XX(382)-JVS(2378)*XX(383)-JVS(2453)&
              &*XX(384)-JVS(2763)*XX(390)-JVS(2884)*XX(392)
  XX(345) = XX(345)-JVS(1601)*XX(364)-JVS(1795)*XX(372)-JVS(1921)*XX(376)-JVS(1981)*XX(378)-JVS(2077)*XX(380)-JVS(2156)&
              &*XX(381)-JVS(2245)*XX(382)-JVS(2377)*XX(383)-JVS(2452)*XX(384)-JVS(2518)*XX(385)-JVS(2762)*XX(390)-JVS(2883)&
              &*XX(392)
  XX(344) = XX(344)-JVS(2155)*XX(381)-JVS(2376)*XX(383)-JVS(2761)*XX(390)-JVS(2832)*XX(391)-JVS(2998)*XX(394)-JVS(3048)&
              &*XX(395)
  XX(343) = XX(343)-JVS(1298)*XX(344)-JVS(1920)*XX(376)-JVS(2028)*XX(379)-JVS(2154)*XX(381)-JVS(2244)*XX(382)-JVS(2375)&
              &*XX(383)-JVS(2451)*XX(384)-JVS(2517)*XX(385)-JVS(2882)*XX(392)-JVS(2949)*XX(393)
  XX(342) = XX(342)-JVS(1517)*XX(358)-JVS(1600)*XX(364)-JVS(1634)*XX(365)-JVS(1648)*XX(366)-JVS(1738)*XX(370)-JVS(1794)&
              &*XX(372)-JVS(1980)*XX(378)-JVS(2076)*XX(380)-JVS(2153)*XX(381)-JVS(2243)*XX(382)-JVS(2374)*XX(383)-JVS(2450)&
              &*XX(384)-JVS(2516)*XX(385)-JVS(2760)*XX(390)-JVS(2881)*XX(392)
  XX(341) = XX(341)-JVS(1599)*XX(364)-JVS(1684)*XX(368)-JVS(2075)*XX(380)-JVS(2152)*XX(381)-JVS(2242)*XX(382)-JVS(2373)&
              &*XX(383)-JVS(2449)*XX(384)-JVS(2515)*XX(385)-JVS(2759)*XX(390)-JVS(2880)*XX(392)-JVS(2948)*XX(393)
  XX(340) = XX(340)-JVS(1683)*XX(368)-JVS(1793)*XX(372)-JVS(1919)*XX(376)-JVS(1979)*XX(378)-JVS(2074)*XX(380)-JVS(2151)&
              &*XX(381)-JVS(2241)*XX(382)-JVS(2372)*XX(383)-JVS(2448)*XX(384)-JVS(2758)*XX(390)-JVS(2879)*XX(392)
  XX(339) = XX(339)-JVS(1390)*XX(352)-JVS(1539)*XX(360)-JVS(1682)*XX(368)-JVS(1737)*XX(370)-JVS(1918)*XX(376)-JVS(1978)&
              &*XX(378)-JVS(2073)*XX(380)-JVS(2240)*XX(382)-JVS(2371)*XX(383)-JVS(2447)*XX(384)-JVS(2514)*XX(385)-JVS(2641)&
              &*XX(388)-JVS(2757)*XX(390)-JVS(2947)*XX(393)
  XX(338) = XX(338)-JVS(1297)*XX(344)-JVS(2027)*XX(379)-JVS(2072)*XX(380)-JVS(2150)*XX(381)-JVS(2239)*XX(382)-JVS(2370)&
              &*XX(383)-JVS(2446)*XX(384)-JVS(2756)*XX(390)-JVS(2946)*XX(393)
  XX(337) = XX(337)-JVS(2149)*XX(381)-JVS(2369)*XX(383)-JVS(2878)*XX(392)
  XX(336) = XX(336)-JVS(1296)*XX(344)-JVS(1598)*XX(364)-JVS(1977)*XX(378)-JVS(2026)*XX(379)-JVS(2148)*XX(381)-JVS(2238)&
              &*XX(382)-JVS(2368)*XX(383)-JVS(2445)*XX(384)-JVS(2513)*XX(385)-JVS(2877)*XX(392)-JVS(2945)*XX(393)
  XX(335) = XX(335)-JVS(1295)*XX(344)-JVS(1951)*XX(377)-JVS(2025)*XX(379)-JVS(2147)*XX(381)-JVS(2237)*XX(382)-JVS(2367)&
              &*XX(383)-JVS(2444)*XX(384)-JVS(2512)*XX(385)-JVS(2944)*XX(393)
  XX(334) = XX(334)-JVS(1502)*XX(357)-JVS(1976)*XX(378)-JVS(2146)*XX(381)-JVS(2366)*XX(383)-JVS(2511)*XX(385)-JVS(2603)&
              &*XX(387)-JVS(2685)*XX(389)-JVS(2876)*XX(392)
  XX(333) = XX(333)-JVS(1480)*XX(356)-JVS(1577)*XX(363)-JVS(1597)*XX(364)-JVS(1647)*XX(366)-JVS(1681)*XX(368)-JVS(2071)&
              &*XX(380)-JVS(2236)*XX(382)-JVS(2365)*XX(383)-JVS(2510)*XX(385)-JVS(2640)*XX(388)-JVS(2755)*XX(390)-JVS(2875)&
              &*XX(392)
  XX(332) = XX(332)-JVS(1206)*XX(337)-JVS(1792)*XX(372)-JVS(1975)*XX(378)-JVS(2070)*XX(380)-JVS(2235)*XX(382)-JVS(2364)&
              &*XX(383)-JVS(2443)*XX(384)-JVS(2754)*XX(390)-JVS(2874)*XX(392)
  XX(331) = XX(331)-JVS(1205)*XX(337)-JVS(1421)*XX(354)-JVS(1680)*XX(368)-JVS(1791)*XX(372)-JVS(1867)*XX(374)-JVS(1974)&
              &*XX(378)-JVS(2069)*XX(380)-JVS(2234)*XX(382)-JVS(2363)*XX(383)-JVS(2442)*XX(384)-JVS(2753)*XX(390)-JVS(2873)&
              &*XX(392)
  XX(330) = XX(330)-JVS(1294)*XX(344)-JVS(1596)*XX(364)-JVS(2024)*XX(379)-JVS(2145)*XX(381)-JVS(2233)*XX(382)-JVS(2362)&
              &*XX(383)-JVS(2441)*XX(384)-JVS(2509)*XX(385)-JVS(2943)*XX(393)
  XX(329) = XX(329)-JVS(2068)*XX(380)-JVS(2144)*XX(381)-JVS(2361)*XX(383)-JVS(2577)*XX(386)-JVS(2639)*XX(388)-JVS(2752)&
              &*XX(390)-JVS(2831)*XX(391)-JVS(2872)*XX(392)-JVS(2997)*XX(394)-JVS(3047)*XX(395)
  XX(328) = XX(328)-JVS(1293)*XX(344)-JVS(1479)*XX(356)-JVS(1679)*XX(368)-JVS(2023)*XX(379)-JVS(2143)*XX(381)-JVS(2232)&
              &*XX(382)-JVS(2360)*XX(383)-JVS(2440)*XX(384)-JVS(2508)*XX(385)-JVS(2942)*XX(393)
  XX(327) = XX(327)-JVS(1420)*XX(354)-JVS(2067)*XX(380)-JVS(2359)*XX(383)-JVS(2507)*XX(385)-JVS(2751)*XX(390)-JVS(2941)&
              &*XX(393)
  XX(326) = XX(326)-JVS(1478)*XX(356)-JVS(1595)*XX(364)-JVS(1973)*XX(378)-JVS(2066)*XX(380)-JVS(2142)*XX(381)-JVS(2231)&
              &*XX(382)-JVS(2358)*XX(383)-JVS(2750)*XX(390)-JVS(2940)*XX(393)
  XX(325) = XX(325)-JVS(1766)*XX(371)-JVS(2141)*XX(381)-JVS(2357)*XX(383)-JVS(2684)*XX(389)-JVS(2830)*XX(391)-JVS(2996)&
              &*XX(394)-JVS(3046)*XX(395)
  XX(324) = XX(324)-JVS(1594)*XX(364)-JVS(2065)*XX(380)-JVS(2230)*XX(382)-JVS(2356)*XX(383)-JVS(2506)*XX(385)-JVS(2871)&
              &*XX(392)
  XX(323) = XX(323)-JVS(1110)*XX(327)-JVS(1555)*XX(361)-JVS(1736)*XX(370)-JVS(1790)*XX(372)-JVS(1866)*XX(374)-JVS(2064)&
              &*XX(380)-JVS(2229)*XX(382)-JVS(2355)*XX(383)-JVS(2439)*XX(384)-JVS(2749)*XX(390)-JVS(2870)*XX(392)-JVS(2939)&
              &*XX(393)
  XX(322) = XX(322)-JVS(1109)*XX(327)-JVS(1554)*XX(361)-JVS(1735)*XX(370)-JVS(1789)*XX(372)-JVS(1865)*XX(374)-JVS(2063)&
              &*XX(380)-JVS(2228)*XX(382)-JVS(2354)*XX(383)-JVS(2438)*XX(384)-JVS(2748)*XX(390)-JVS(2869)*XX(392)
  XX(321) = XX(321)-JVS(1458)*XX(355)-JVS(1842)*XX(373)-JVS(2353)*XX(383)-JVS(2576)*XX(386)-JVS(2829)*XX(391)-JVS(3045)&
              &*XX(395)
  XX(320) = XX(320)-JVS(1131)*XX(329)-JVS(1236)*XX(338)-JVS(1255)*XX(340)-JVS(1282)*XX(343)-JVS(1316)*XX(345)-JVS(1917)&
              &*XX(376)-JVS(2062)*XX(380)-JVS(2352)*XX(383)-JVS(2505)*XX(385)-JVS(2638)*XX(388)-JVS(2747)*XX(390)-JVS(2868)&
              &*XX(392)-JVS(2938)*XX(393)
  XX(319) = XX(319)-JVS(1045)*XX(320)-JVS(1186)*XX(335)-JVS(1235)*XX(338)-JVS(1355)*XX(349)-JVS(1553)*XX(361)-JVS(1566)&
              &*XX(362)-JVS(1661)*XX(367)-JVS(1898)*XX(375)-JVS(1950)*XX(377)-JVS(1972)*XX(378)-JVS(2061)*XX(380)-JVS(2351)&
              &*XX(383)-JVS(2504)*XX(385)-JVS(2637)*XX(388)-JVS(2746)*XX(390)-JVS(2867)*XX(392)-JVS(2937)*XX(393)
  XX(318) = XX(318)-JVS(1204)*XX(337)-JVS(1593)*XX(364)-JVS(1678)*XX(368)-JVS(2060)*XX(380)-JVS(2140)*XX(381)-JVS(2227)&
              &*XX(382)-JVS(2350)*XX(383)-JVS(2437)*XX(384)-JVS(2745)*XX(390)-JVS(2936)*XX(393)
  XX(317) = XX(317)-JVS(1087)*XX(325)-JVS(1419)*XX(354)-JVS(1765)*XX(371)-JVS(2139)*XX(381)-JVS(2226)*XX(382)-JVS(2349)&
              &*XX(383)-JVS(2683)*XX(389)-JVS(2828)*XX(391)-JVS(2935)*XX(393)-JVS(2995)*XX(394)
  XX(316) = XX(316)-JVS(2138)*XX(381)-JVS(2348)*XX(383)-JVS(2636)*XX(388)-JVS(2744)*XX(390)-JVS(3044)*XX(395)
  XX(315) = XX(315)-JVS(1538)*XX(360)-JVS(1677)*XX(368)-JVS(1971)*XX(378)-JVS(2059)*XX(380)-JVS(2225)*XX(382)-JVS(2347)&
              &*XX(383)-JVS(2503)*XX(385)-JVS(2635)*XX(388)-JVS(2934)*XX(393)
  XX(314) = XX(314)-JVS(1108)*XX(327)-JVS(1418)*XX(354)-JVS(1477)*XX(356)-JVS(1592)*XX(364)-JVS(1676)*XX(368)-JVS(1717)&
              &*XX(369)-JVS(1788)*XX(372)-JVS(2224)*XX(382)-JVS(2346)*XX(383)-JVS(2436)*XX(384)-JVS(2743)*XX(390)
  XX(313) = XX(313)-JVS(1107)*XX(327)-JVS(1476)*XX(356)-JVS(1591)*XX(364)-JVS(1675)*XX(368)-JVS(2058)*XX(380)-JVS(2137)&
              &*XX(381)-JVS(2223)*XX(382)-JVS(2345)*XX(383)-JVS(2435)*XX(384)-JVS(2502)*XX(385)-JVS(2742)*XX(390)
  XX(312) = XX(312)-JVS(1787)*XX(372)-JVS(2344)*XX(383)-JVS(2741)*XX(390)
  XX(311) = XX(311)-JVS(1417)*XX(354)-JVS(1716)*XX(369)-JVS(1786)*XX(372)-JVS(2222)*XX(382)-JVS(2343)*XX(383)-JVS(2434)&
              &*XX(384)-JVS(2740)*XX(390)
  XX(310) = XX(310)-JVS(1098)*XX(326)-JVS(1265)*XX(341)-JVS(1576)*XX(363)-JVS(1633)*XX(365)-JVS(2057)*XX(380)-JVS(2221)&
              &*XX(382)-JVS(2342)*XX(383)-JVS(2634)*XX(388)-JVS(2739)*XX(390)
  XX(309) = XX(309)-JVS(1516)*XX(358)-JVS(1632)*XX(365)-JVS(1646)*XX(366)-JVS(1785)*XX(372)-JVS(2220)*XX(382)-JVS(2341)&
              &*XX(383)-JVS(2738)*XX(390)
  XX(308) = XX(308)-JVS(1552)*XX(361)-JVS(1734)*XX(370)-JVS(1784)*XX(372)-JVS(1864)*XX(374)-JVS(2219)*XX(382)-JVS(2340)&
              &*XX(383)-JVS(2737)*XX(390)
  XX(307) = XX(307)-JVS(2136)*XX(381)-JVS(2339)*XX(383)-JVS(2736)*XX(390)
  XX(306) = XX(306)-JVS(1416)*XX(354)-JVS(1457)*XX(355)-JVS(2135)*XX(381)-JVS(2218)*XX(382)-JVS(2338)*XX(383)-JVS(2827)&
              &*XX(391)-JVS(2933)*XX(393)-JVS(2994)*XX(394)
  XX(305) = XX(305)-JVS(1403)*XX(353)-JVS(1674)*XX(368)-JVS(2056)*XX(380)-JVS(2337)*XX(383)-JVS(2501)*XX(385)-JVS(2735)&
              &*XX(390)
  XX(304) = XX(304)-JVS(976)*XX(311)-JVS(1863)*XX(374)-JVS(2336)*XX(383)-JVS(2633)*XX(388)-JVS(2734)*XX(390)
  XX(303) = XX(303)-JVS(1673)*XX(368)-JVS(1862)*XX(374)-JVS(2335)*XX(383)-JVS(2500)*XX(385)-JVS(2733)*XX(390)
  XX(302) = XX(302)-JVS(1354)*XX(349)-JVS(1475)*XX(356)-JVS(1590)*XX(364)-JVS(1861)*XX(374)-JVS(1970)*XX(378)-JVS(2055)&
              &*XX(380)-JVS(2334)*XX(383)-JVS(2732)*XX(390)
  XX(301) = XX(301)-JVS(1501)*XX(357)-JVS(1589)*XX(364)-JVS(1969)*XX(378)-JVS(2054)*XX(380)-JVS(2134)*XX(381)-JVS(2333)&
              &*XX(383)
  XX(300) = XX(300)-JVS(1000)*XX(313)-JVS(1565)*XX(362)-JVS(1575)*XX(363)-JVS(1897)*XX(375)-JVS(1949)*XX(377)-JVS(2053)&
              &*XX(380)-JVS(2332)*XX(383)-JVS(2731)*XX(390)
  XX(299) = XX(299)-JVS(923)*XX(303)-JVS(1380)*XX(351)-JVS(1474)*XX(356)-JVS(1588)*XX(364)-JVS(1672)*XX(368)-JVS(2331)&
              &*XX(383)-JVS(2499)*XX(385)-JVS(2730)*XX(390)
  XX(298) = XX(298)-JVS(1366)*XX(350)-JVS(1415)*XX(354)-JVS(2133)*XX(381)-JVS(2330)*XX(383)-JVS(2498)*XX(385)-JVS(2602)&
              &*XX(387)-JVS(2682)*XX(389)-JVS(2932)*XX(393)
  XX(297) = XX(297)-JVS(1715)*XX(369)-JVS(1783)*XX(372)-JVS(2329)*XX(383)-JVS(2729)*XX(390)
  XX(296) = XX(296)-JVS(1074)*XX(324)-JVS(1315)*XX(345)-JVS(1782)*XX(372)-JVS(2217)*XX(382)-JVS(2328)*XX(383)-JVS(2728)&
              &*XX(390)
  XX(295) = XX(295)-JVS(1254)*XX(340)-JVS(1671)*XX(368)-JVS(1916)*XX(376)-JVS(2052)*XX(380)-JVS(2327)*XX(383)-JVS(2727)&
              &*XX(390)
  XX(294) = XX(294)-JVS(2022)*XX(379)-JVS(2326)*XX(383)
  XX(293) = XX(293)-JVS(1086)*XX(325)-JVS(2325)*XX(383)-JVS(2681)*XX(389)
  XX(292) = XX(292)-JVS(2051)*XX(380)-JVS(2216)*XX(382)-JVS(2324)*XX(383)
  XX(291) = XX(291)-JVS(1389)*XX(352)-JVS(1915)*XX(376)-JVS(2323)*XX(383)-JVS(2726)*XX(390)
  XX(290) = XX(290)-JVS(2680)*XX(389)-JVS(2826)*XX(391)
  XX(289) = XX(289)-JVS(2050)*XX(380)-JVS(2132)*XX(381)-JVS(2322)*XX(383)-JVS(2725)*XX(390)-JVS(2866)*XX(392)
  XX(288) = XX(288)-JVS(1149)*XX(331)-JVS(1537)*XX(360)-JVS(1968)*XX(378)-JVS(2049)*XX(380)-JVS(2321)*XX(383)
  XX(287) = XX(287)-JVS(2131)*XX(381)-JVS(2215)*XX(382)-JVS(2320)*XX(383)-JVS(2724)*XX(390)-JVS(2931)*XX(393)
  XX(286) = XX(286)-JVS(1051)*XX(321)-JVS(1841)*XX(373)-JVS(2825)*XX(391)
  XX(285) = XX(285)-JVS(1764)*XX(371)-JVS(2130)*XX(381)-JVS(2319)*XX(383)-JVS(2575)*XX(386)-JVS(2679)*XX(389)-JVS(2723)&
              &*XX(390)-JVS(2865)*XX(392)
  XX(284) = XX(284)-JVS(2129)*XX(381)-JVS(2318)*XX(383)-JVS(2497)*XX(385)-JVS(2722)*XX(390)-JVS(2824)*XX(391)-JVS(2864)&
              &*XX(392)-JVS(2993)*XX(394)
  XX(283) = XX(283)-JVS(1414)*XX(354)-JVS(2021)*XX(379)-JVS(2048)*XX(380)-JVS(2317)*XX(383)-JVS(2863)*XX(392)-JVS(2930)&
              &*XX(393)
  XX(282) = XX(282)-JVS(1175)*XX(334)-JVS(1335)*XX(347)-JVS(2316)*XX(383)-JVS(2721)*XX(390)
  XX(281) = XX(281)-JVS(1158)*XX(332)-JVS(1781)*XX(372)-JVS(2315)*XX(383)-JVS(2720)*XX(390)
  XX(280) = XX(280)-JVS(2128)*XX(381)-JVS(2214)*XX(382)-JVS(2314)*XX(383)-JVS(2433)*XX(384)
  XX(279) = XX(279)-JVS(1365)*XX(350)-JVS(1914)*XX(376)-JVS(2313)*XX(383)-JVS(2719)*XX(390)
  XX(278) = XX(278)-JVS(1157)*XX(332)-JVS(1334)*XX(347)-JVS(2312)*XX(383)-JVS(2496)*XX(385)-JVS(2601)*XX(387)-JVS(2678)&
              &*XX(389)
  XX(277) = XX(277)-JVS(1840)*XX(373)-JVS(2127)*XX(381)-JVS(2311)*XX(383)-JVS(2574)*XX(386)-JVS(2823)*XX(391)-JVS(3043)&
              &*XX(395)
  XX(276) = XX(276)-JVS(1839)*XX(373)-JVS(2126)*XX(381)-JVS(2310)*XX(383)-JVS(2573)*XX(386)-JVS(2822)*XX(391)-JVS(3042)&
              &*XX(395)
  XX(275) = XX(275)-JVS(1838)*XX(373)-JVS(2125)*XX(381)-JVS(2309)*XX(383)-JVS(2572)*XX(386)-JVS(2821)*XX(391)-JVS(3041)&
              &*XX(395)
  XX(274) = XX(274)-JVS(1837)*XX(373)-JVS(2124)*XX(381)-JVS(2308)*XX(383)-JVS(2571)*XX(386)-JVS(2820)*XX(391)-JVS(3040)&
              &*XX(395)
  XX(273) = XX(273)-JVS(1456)*XX(355)-JVS(2213)*XX(382)-JVS(2307)*XX(383)-JVS(2819)*XX(391)
  XX(272) = XX(272)-JVS(1455)*XX(355)-JVS(1836)*XX(373)-JVS(2306)*XX(383)-JVS(3039)*XX(395)
  XX(271) = XX(271)-JVS(2047)*XX(380)-JVS(2212)*XX(382)-JVS(2718)*XX(390)-JVS(2862)*XX(392)-JVS(2929)*XX(393)
  XX(270) = XX(270)-JVS(1763)*XX(371)-JVS(2305)*XX(383)-JVS(2570)*XX(386)-JVS(2677)*XX(389)-JVS(3038)*XX(395)
  XX(269) = XX(269)-JVS(1762)*XX(371)-JVS(2304)*XX(383)-JVS(2569)*XX(386)-JVS(2676)*XX(389)-JVS(3037)*XX(395)
  XX(268) = XX(268)-JVS(831)*XX(286)-JVS(1454)*XX(355)-JVS(1835)*XX(373)-JVS(2303)*XX(383)-JVS(2818)*XX(391)
  XX(267) = XX(267)-JVS(1967)*XX(378)-JVS(2302)*XX(383)-JVS(2861)*XX(392)
  XX(266) = XX(266)-JVS(1966)*XX(378)-JVS(2211)*XX(382)-JVS(2860)*XX(392)-JVS(2928)*XX(393)
  XX(265) = XX(265)-JVS(2210)*XX(382)-JVS(2432)*XX(384)-JVS(2568)*XX(386)-JVS(3036)*XX(395)
  XX(264) = XX(264)-JVS(1413)*XX(354)-JVS(1714)*XX(369)-JVS(2301)*XX(383)-JVS(2927)*XX(393)
  XX(263) = XX(263)-JVS(2020)*XX(379)-JVS(2300)*XX(383)-JVS(2495)*XX(385)-JVS(3035)*XX(395)
  XX(262) = XX(262)-JVS(2431)*XX(384)-JVS(2717)*XX(390)
  XX(261) = XX(261)-JVS(2430)*XX(384)-JVS(2716)*XX(390)
  XX(260) = XX(260)-JVS(2429)*XX(384)-JVS(2567)*XX(386)
  XX(259) = XX(259)-JVS(1761)*XX(371)-JVS(1834)*XX(373)-JVS(2566)*XX(386)-JVS(2675)*XX(389)-JVS(2817)*XX(391)-JVS(3034)&
              &*XX(395)
  XX(258) = XX(258)-JVS(2428)*XX(384)-JVS(2715)*XX(390)
  XX(257) = XX(257)-JVS(1388)*XX(352)-JVS(2209)*XX(382)
  XX(256) = XX(256)-JVS(1760)*XX(371)-JVS(2565)*XX(386)-JVS(2674)*XX(389)-JVS(3033)*XX(395)
  XX(255) = XX(255)-JVS(1759)*XX(371)-JVS(2564)*XX(386)-JVS(2673)*XX(389)-JVS(3032)*XX(395)
  XX(254) = XX(254)-JVS(1833)*XX(373)-JVS(2563)*XX(386)-JVS(2816)*XX(391)-JVS(3031)*XX(395)
  XX(253) = XX(253)-JVS(1832)*XX(373)-JVS(2562)*XX(386)-JVS(2815)*XX(391)-JVS(3030)*XX(395)
  XX(252) = XX(252)-JVS(1831)*XX(373)-JVS(2561)*XX(386)-JVS(2814)*XX(391)-JVS(3029)*XX(395)
  XX(251) = XX(251)-JVS(1830)*XX(373)-JVS(2560)*XX(386)-JVS(2813)*XX(391)-JVS(3028)*XX(395)
  XX(250) = XX(250)-JVS(1829)*XX(373)-JVS(2559)*XX(386)-JVS(2812)*XX(391)-JVS(3027)*XX(395)
  XX(249) = XX(249)-JVS(1828)*XX(373)-JVS(2558)*XX(386)-JVS(2811)*XX(391)-JVS(3026)*XX(395)
  XX(248) = XX(248)-JVS(1034)*XX(318)-JVS(2208)*XX(382)
  XX(247) = XX(247)-JVS(999)*XX(313)-JVS(2299)*XX(383)
  XX(246) = XX(246)-JVS(2207)*XX(382)-JVS(2672)*XX(389)
  XX(245) = XX(245)-JVS(2123)*XX(381)-JVS(2298)*XX(383)-JVS(2810)*XX(391)
  XX(244) = XX(244)-JVS(734)*XX(258)-JVS(2297)*XX(383)
  XX(243) = XX(243)-JVS(750)*XX(262)-JVS(2296)*XX(383)
  XX(242) = XX(242)-JVS(745)*XX(261)-JVS(2295)*XX(383)
  XX(241) = XX(241)
  XX(240) = XX(240)
  XX(239) = XX(239)
  XX(238) = XX(238)
  XX(237) = XX(237)
  XX(236) = XX(236)
  XX(235) = XX(235)
  XX(234) = XX(234)
  XX(233) = XX(233)
  XX(232) = XX(232)
  XX(231) = XX(231)
  XX(230) = XX(230)
  XX(229) = XX(229)
  XX(228) = XX(228)
  XX(227) = XX(227)
  XX(226) = XX(226)
  XX(225) = XX(225)
  XX(224) = XX(224)
  XX(223) = XX(223)
  XX(222) = XX(222)
  XX(221) = XX(221)
  XX(220) = XX(220)
  XX(219) = XX(219)
  XX(218) = XX(218)
  XX(217) = XX(217)
  XX(216) = XX(216)
  XX(215) = XX(215)
  XX(214) = XX(214)
  XX(213) = XX(213)
  XX(212) = XX(212)
  XX(211) = XX(211)
  XX(210) = XX(210)
  XX(209) = XX(209)
  XX(208) = XX(208)
  XX(207) = XX(207)
  XX(206) = XX(206)
  XX(205) = XX(205)
  XX(204) = XX(204)
  XX(203) = XX(203)
  XX(202) = XX(202)
  XX(201) = XX(201)
  XX(200) = XX(200)
  XX(199) = XX(199)
  XX(198) = XX(198)
  XX(197) = XX(197)
  XX(196) = XX(196)
  XX(195) = XX(195)
  XX(194) = XX(194)
  XX(193) = XX(193)
  XX(192) = XX(192)
  XX(191) = XX(191)
  XX(190) = XX(190)
  XX(189) = XX(189)
  XX(188) = XX(188)
  XX(187) = XX(187)
  XX(186) = XX(186)
  XX(185) = XX(185)
  XX(184) = XX(184)
  XX(183) = XX(183)
  XX(182) = XX(182)
  XX(181) = XX(181)
  XX(180) = XX(180)
  XX(179) = XX(179)
  XX(178) = XX(178)
  XX(177) = XX(177)
  XX(176) = XX(176)
  XX(175) = XX(175)
  XX(174) = XX(174)
  XX(173) = XX(173)
  XX(172) = XX(172)
  XX(171) = XX(171)
  XX(170) = XX(170)
  XX(169) = XX(169)
  XX(168) = XX(168)
  XX(167) = XX(167)
  XX(166) = XX(166)
  XX(165) = XX(165)
  XX(164) = XX(164)
  XX(163) = XX(163)
  XX(162) = XX(162)
  XX(161) = XX(161)
  XX(160) = XX(160)
  XX(159) = XX(159)
  XX(158) = XX(158)
  XX(157) = XX(157)
  XX(156) = XX(156)
  XX(155) = XX(155)
  XX(154) = XX(154)
  XX(153) = XX(153)
  XX(152) = XX(152)
  XX(151) = XX(151)
  XX(150) = XX(150)
  XX(149) = XX(149)
  XX(148) = XX(148)
  XX(147) = XX(147)
  XX(146) = XX(146)
  XX(145) = XX(145)
  XX(144) = XX(144)
  XX(143) = XX(143)
  XX(142) = XX(142)
  XX(141) = XX(141)
  XX(140) = XX(140)
  XX(139) = XX(139)
  XX(138) = XX(138)
  XX(137) = XX(137)
  XX(136) = XX(136)
  XX(135) = XX(135)
  XX(134) = XX(134)
  XX(133) = XX(133)
  XX(132) = XX(132)
  XX(131) = XX(131)
  XX(130) = XX(130)
  XX(129) = XX(129)
  XX(128) = XX(128)
  XX(127) = XX(127)
  XX(126) = XX(126)
  XX(125) = XX(125)
  XX(124) = XX(124)
  XX(123) = XX(123)
  XX(122) = XX(122)
  XX(121) = XX(121)
  XX(120) = XX(120)
  XX(119) = XX(119)
  XX(118) = XX(118)
  XX(117) = XX(117)
  XX(116) = XX(116)
  XX(115) = XX(115)
  XX(114) = XX(114)
  XX(113) = XX(113)
  XX(112) = XX(112)
  XX(111) = XX(111)
  XX(110) = XX(110)
  XX(109) = XX(109)
  XX(108) = XX(108)
  XX(107) = XX(107)
  XX(106) = XX(106)
  XX(105) = XX(105)
  XX(104) = XX(104)
  XX(103) = XX(103)
  XX(102) = XX(102)
  XX(101) = XX(101)
  XX(100) = XX(100)
  XX(99) = XX(99)
  XX(98) = XX(98)
  XX(97) = XX(97)
  XX(96) = XX(96)
  XX(95) = XX(95)
  XX(94) = XX(94)
  XX(93) = XX(93)
  XX(92) = XX(92)
  XX(91) = XX(91)
  XX(90) = XX(90)
  XX(89) = XX(89)
  XX(88) = XX(88)
  XX(87) = XX(87)
  XX(86) = XX(86)
  XX(85) = XX(85)
  XX(84) = XX(84)
  XX(83) = XX(83)
  XX(82) = XX(82)
  XX(81) = XX(81)
  XX(80) = XX(80)
  XX(79) = XX(79)
  XX(78) = XX(78)
  XX(77) = XX(77)
  XX(76) = XX(76)
  XX(75) = XX(75)
  XX(74) = XX(74)
  XX(73) = XX(73)
  XX(72) = XX(72)
  XX(71) = XX(71)
  XX(70) = XX(70)
  XX(69) = XX(69)
  XX(68) = XX(68)
  XX(67) = XX(67)
  XX(66) = XX(66)
  XX(65) = XX(65)
  XX(64) = XX(64)
  XX(63) = XX(63)
  XX(62) = XX(62)
  XX(61) = XX(61)
  XX(60) = XX(60)
  XX(59) = XX(59)
  XX(58) = XX(58)
  XX(57) = XX(57)
  XX(56) = XX(56)
  XX(55) = XX(55)
  XX(54) = XX(54)
  XX(53) = XX(53)
  XX(52) = XX(52)
  XX(51) = XX(51)
  XX(50) = XX(50)
  XX(49) = XX(49)
  XX(48) = XX(48)
  XX(47) = XX(47)
  XX(46) = XX(46)
  XX(45) = XX(45)
  XX(44) = XX(44)
  XX(43) = XX(43)
  XX(42) = XX(42)
  XX(41) = XX(41)
  XX(40) = XX(40)
  XX(39) = XX(39)
  XX(38) = XX(38)
  XX(37) = XX(37)
  XX(36) = XX(36)
  XX(35) = XX(35)
  XX(34) = XX(34)
  XX(33) = XX(33)
  XX(32) = XX(32)
  XX(31) = XX(31)
  XX(30) = XX(30)
  XX(29) = XX(29)
  XX(28) = XX(28)
  XX(27) = XX(27)
  XX(26) = XX(26)
  XX(25) = XX(25)
  XX(24) = XX(24)
  XX(23) = XX(23)
  XX(22) = XX(22)
  XX(21) = XX(21)
  XX(20) = XX(20)
  XX(19) = XX(19)
  XX(18) = XX(18)
  XX(17) = XX(17)
  XX(16) = XX(16)
  XX(15) = XX(15)
  XX(14) = XX(14)
  XX(13) = XX(13)
  XX(12) = XX(12)
  XX(11) = XX(11)
  XX(10) = XX(10)
  XX(9) = XX(9)
  XX(8) = XX(8)
  XX(7) = XX(7)
  XX(6) = XX(6)
  XX(5) = XX(5)
  XX(4) = XX(4)
  XX(3) = XX(3)
  XX(2) = XX(2)
  XX(1) = XX(1)-JVS(2046)*XX(380)
      
END SUBROUTINE KppSolveTR

! End of KppSolveTR function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! BLAS_UTIL - BLAS-LIKE utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!--------------------------------------------------------------
!
! BLAS/LAPACK-like subroutines used by the integration algorithms
! It is recommended to replace them by calls to the optimized
!      BLAS/LAPACK library for your machine
!
!  (C) Adrian Sandu, Aug. 2004
!      Virginia Polytechnic Institute and State University
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE WCOPY(N,X,incX,Y,incY)
!--------------------------------------------------------------
!     copies a vector, x, to a vector, y:  y <- x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL  SCOPY(N,X,1,Y,1)   or   CALL  DCOPY(N,X,1,Y,1)
!--------------------------------------------------------------
!     USE gckpp_Precision
      
      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N)

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = X(i)
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i) = X(i)
        Y(i + 1) = X(i + 1)
        Y(i + 2) = X(i + 2)
        Y(i + 3) = X(i + 3)
        Y(i + 4) = X(i + 4)
        Y(i + 5) = X(i + 5)
        Y(i + 6) = X(i + 6)
        Y(i + 7) = X(i + 7)
      END DO

      END SUBROUTINE WCOPY


!--------------------------------------------------------------
      SUBROUTINE WAXPY(N,Alpha,X,incX,Y,incY)
!--------------------------------------------------------------
!     constant times a vector plus a vector: y <- y + Alpha*x
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SAXPY(N,Alpha,X,1,Y,1) or  CALL DAXPY(N,Alpha,X,1,Y,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,incY,M,MP1,N
      REAL(kind=dp) :: X(N),Y(N),Alpha
      REAL(kind=dp), PARAMETER :: ZERO = 0.0_dp

      IF (Alpha .EQ. ZERO) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,4)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = Y(i) + Alpha*X(i)
        END DO
        IF( N .LT. 4 ) RETURN
      END IF
      MP1 = M + 1
      DO i = MP1,N,4
        Y(i) = Y(i) + Alpha*X(i)
        Y(i + 1) = Y(i + 1) + Alpha*X(i + 1)
        Y(i + 2) = Y(i + 2) + Alpha*X(i + 2)
        Y(i + 3) = Y(i + 3) + Alpha*X(i + 3)
      END DO
      
      END SUBROUTINE WAXPY



!--------------------------------------------------------------
      SUBROUTINE WSCAL(N,Alpha,X,incX)
!--------------------------------------------------------------
!     constant times a vector: x(1:N) <- Alpha*x(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SSCAL(N,Alpha,X,1) or  CALL DSCAL(N,Alpha,X,1)
!--------------------------------------------------------------

      INTEGER  :: i,incX,M,MP1,N
      REAL(kind=dp)  :: X(N),Alpha
      REAL(kind=dp), PARAMETER  :: ZERO=0.0_dp, ONE=1.0_dp

      IF (Alpha .EQ. ONE) RETURN
      IF (N .LE. 0) RETURN

      M = MOD(N,5)
      IF( M .NE. 0 ) THEN
        IF (Alpha .EQ. (-ONE)) THEN
          DO i = 1,M
            X(i) = -X(i)
          END DO
        ELSEIF (Alpha .EQ. ZERO) THEN
          DO i = 1,M
            X(i) = ZERO
          END DO
        ELSE
          DO i = 1,M
            X(i) = Alpha*X(i)
          END DO
        END IF
        IF( N .LT. 5 ) RETURN
      END IF
      MP1 = M + 1
      IF (Alpha .EQ. (-ONE)) THEN
        DO i = MP1,N,5
          X(i)     = -X(i)
          X(i + 1) = -X(i + 1)
          X(i + 2) = -X(i + 2)
          X(i + 3) = -X(i + 3)
          X(i + 4) = -X(i + 4)
        END DO
      ELSEIF (Alpha .EQ. ZERO) THEN
        DO i = MP1,N,5
          X(i)     = ZERO
          X(i + 1) = ZERO
          X(i + 2) = ZERO
          X(i + 3) = ZERO
          X(i + 4) = ZERO
        END DO
      ELSE
        DO i = MP1,N,5
          X(i)     = Alpha*X(i)
          X(i + 1) = Alpha*X(i + 1)
          X(i + 2) = Alpha*X(i + 2)
          X(i + 3) = Alpha*X(i + 3)
          X(i + 4) = Alpha*X(i + 4)
        END DO
      END IF

      END SUBROUTINE WSCAL

!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WLAMCH( C )
!--------------------------------------------------------------
!     returns epsilon machine
!     after LAPACK
!     replace this by the function from the optimized LAPACK implementation:
!          CALL SLAMCH('E') or CALL DLAMCH('E')
!--------------------------------------------------------------
!      USE gckpp_Precision

      CHARACTER ::  C
      INTEGER    :: i
      REAL(kind=dp), SAVE  ::  Eps
      REAL(kind=dp)  ::  Suma
      REAL(kind=dp), PARAMETER  ::  ONE=1.0_dp, HALF=0.5_dp
      LOGICAL, SAVE   ::  First=.TRUE.

!$OMP THREADPRIVATE( Eps, First )      

      IF (First) THEN
        First = .FALSE.
        Eps = HALF**(16)
        DO i = 17, 80
          Eps = Eps*HALF
          CALL WLAMCH_ADD(ONE,Eps,Suma)
          IF (Suma.LE.ONE) GOTO 10
        END DO
        PRINT*,'ERROR IN WLAMCH. EPS < ',Eps
        RETURN
10      Eps = Eps*2
        i = i-1      
      END IF

      WLAMCH = Eps

      END FUNCTION WLAMCH
     
      SUBROUTINE WLAMCH_ADD( A, B, Suma )
!      USE gckpp_Precision
      
      REAL(kind=dp) A, B, Suma
      Suma = A + B

      END SUBROUTINE WLAMCH_ADD
!--------------------------------------------------------------


!--------------------------------------------------------------
      SUBROUTINE SET2ZERO(N,Y)
!--------------------------------------------------------------
!     copies zeros into the vector y:  y <- 0
!     after BLAS
!--------------------------------------------------------------
      
      INTEGER ::  i,M,MP1,N
      REAL(kind=dp) ::  Y(N)
      REAL(kind=dp), PARAMETER :: ZERO = 0.0d0

      IF (N.LE.0) RETURN

      M = MOD(N,8)
      IF( M .NE. 0 ) THEN
        DO i = 1,M
          Y(i) = ZERO
        END DO
        IF( N .LT. 8 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,8
        Y(i)     = ZERO
        Y(i + 1) = ZERO
        Y(i + 2) = ZERO
        Y(i + 3) = ZERO
        Y(i + 4) = ZERO
        Y(i + 5) = ZERO
        Y(i + 6) = ZERO
        Y(i + 7) = ZERO
      END DO

      END SUBROUTINE SET2ZERO


!--------------------------------------------------------------
      REAL(kind=dp) FUNCTION WDOT (N, DX, incX, DY, incY) 
!--------------------------------------------------------------
!     dot produce: wdot = x(1:N)*y(1:N) 
!     only for incX=incY=1
!     after BLAS
!     replace this by the function from the optimized BLAS implementation:
!         CALL SDOT(N,X,1,Y,1) or  CALL DDOT(N,X,1,Y,1)
!--------------------------------------------------------------
!      USE messy_mecca_kpp_Precision
!--------------------------------------------------------------
      IMPLICIT NONE
      INTEGER :: N, incX, incY
      REAL(kind=dp) :: DX(N), DY(N) 

      INTEGER :: i, IX, IY, M, MP1, NS
                                 
      WDOT = 0.0D0 
      IF (N .LE. 0) RETURN 
      IF (incX .EQ. incY) IF (incX-1) 5,20,60 
!                                                                       
!     Code for unequal or nonpositive increments.                       
!                                                                       
    5 IX = 1 
      IY = 1 
      IF (incX .LT. 0) IX = (-N+1)*incX + 1 
      IF (incY .LT. 0) IY = (-N+1)*incY + 1 
      DO i = 1,N 
        WDOT = WDOT + DX(IX)*DY(IY) 
        IX = IX + incX 
        IY = IY + incY 
      END DO 
      RETURN 
!                                                                       
!     Code for both increments equal to 1.                              
!                                                                       
!     Clean-up loop so remaining vector length is a multiple of 5.      
!                                                                       
   20 M = MOD(N,5) 
      IF (M .EQ. 0) GO TO 40 
      DO i = 1,M 
         WDOT = WDOT + DX(i)*DY(i) 
      END DO 
      IF (N .LT. 5) RETURN 
   40 MP1 = M + 1 
      DO i = MP1,N,5 
          WDOT = WDOT + DX(i)*DY(i) + DX(i+1)*DY(i+1) + DX(i+2)*DY(i+2) +  &
                   DX(i+3)*DY(i+3) + DX(i+4)*DY(i+4)                   
      END DO 
      RETURN 
!                                                                       
!     Code for equal, positive, non-unit increments.                    
!                                                                       
   60 NS = N*incX 
      DO i = 1,NS,incX 
        WDOT = WDOT + DX(i)*DY(i) 
      END DO 

      END FUNCTION WDOT                                          


!--------------------------------------------------------------
      SUBROUTINE WADD(N,X,Y,Z)
!--------------------------------------------------------------
!     adds two vectors: z <- x + y
!     BLAS - like
!--------------------------------------------------------------
!     USE gckpp_Precision
      
      INTEGER :: i, M, MP1, N
      REAL(kind=dp) :: X(N),Y(N),Z(N)

      IF (N.LE.0) RETURN

      M = MOD(N,5)
      IF( M /= 0 ) THEN
         DO i = 1,M
            Z(i) = X(i) + Y(i)
         END DO
         IF( N < 5 ) RETURN
      END IF    
      MP1 = M+1
      DO i = MP1,N,5
         Z(i)     = X(i)     + Y(i)
         Z(i + 1) = X(i + 1) + Y(i + 1)
         Z(i + 2) = X(i + 2) + Y(i + 2)
         Z(i + 3) = X(i + 3) + Y(i + 3)
         Z(i + 4) = X(i + 4) + Y(i + 4)
      END DO

      END SUBROUTINE WADD
      
      
      
!--------------------------------------------------------------
      SUBROUTINE WGEFA(N,A,Ipvt,info)
!--------------------------------------------------------------
!     WGEFA FACTORS THE MATRIX A (N,N) BY
!           GAUSS ELIMINATION WITH PARTIAL PIVOTING
!     LINPACK - LIKE 
!--------------------------------------------------------------
!
      INTEGER       :: N,Ipvt(N),info
      REAL(kind=dp) :: A(N,N)
      REAL(kind=dp) :: t, dmax, da
      INTEGER       :: j,k,l
      REAL(kind=dp), PARAMETER :: ZERO = 0.0, ONE = 1.0

      info = 0

size: IF (n > 1) THEN
      
col:  DO k = 1, n-1

!        find l = pivot index
!        l = idamax(n-k+1,A(k,k),1) + k - 1
         l = k; dmax = abs(A(k,k))
         DO j = k+1,n
            da = ABS(A(j,k))
            IF (da > dmax) THEN
              l = j; dmax = da
            END IF
         END DO
         Ipvt(k) = l

!        zero pivot implies this column already triangularized
         IF (ABS(A(l,k)) < TINY(ZERO)) THEN
            info = k
            return
         ELSE   
            IF (l /= k) THEN
               t = A(l,k); A(l,k) = A(k,k); A(k,k) = t
            END IF
            t = -ONE/A(k,k)
            CALL WSCAL(n-k,t,A(k+1,k),1)
            DO j = k+1, n
               t = A(l,j)
               IF (l /= k) THEN
                  A(l,j) = A(k,j); A(k,j) = t
               END IF
               CALL WAXPY(n-k,t,A(k+1,k),1,A(k+1,j),1)
            END DO         
         END IF
         
       END DO col
       
      END IF size
      
      Ipvt(N) = N
      IF (ABS(A(N,N)) == ZERO) info = N
      
      END SUBROUTINE WGEFA


!--------------------------------------------------------------
      SUBROUTINE WGESL(Trans,N,A,Ipvt,b)
!--------------------------------------------------------------
!     WGESL solves the system
!     a * x = b  or  trans(a) * x = b
!     using the factors computed by WGEFA.
!
!     Trans      = 'N'   to solve  A*x = b ,
!                = 'T'   to solve  transpose(A)*x = b
!     LINPACK - LIKE 
!--------------------------------------------------------------

      INTEGER       :: N,Ipvt(N)
      CHARACTER     :: trans
      REAL(kind=dp) :: A(N,N),b(N)
      REAL(kind=dp) :: t
      INTEGER       :: k,kb,l

      
      SELECT CASE (Trans)

      CASE ('n','N')  !  Solve  A * x = b

!        first solve  L*y = b
         IF (n >= 2) THEN
          DO k = 1, n-1
            l = Ipvt(k)
            t = b(l)
            IF (l /= k) THEN
               b(l) = b(k)
               b(k) = t
            END IF
            CALL WAXPY(n-k,t,a(k+1,k),1,b(k+1),1)
          END DO
         END IF
!        now solve  U*x = y
         DO kb = 1, n
            k = n + 1 - kb
            b(k) = b(k)/a(k,k)
            t = -b(k)
            CALL WAXPY(k-1,t,a(1,k),1,b(1),1)
         END DO
      
      CASE ('t','T')  !  Solve transpose(A) * x = b

!        first solve  trans(U)*y = b
         DO k = 1, n
            t = WDOT(k-1,a(1,k),1,b(1),1)
            b(k) = (b(k) - t)/a(k,k)
         END DO
!        now solve trans(L)*x = y
         IF (n >= 2) THEN
         DO kb = 1, n-1
            k = n - kb
            b(k) = b(k) + WDOT(n-k,a(k+1,k),1,b(k+1),1)
            l = Ipvt(k)
            IF (l /= k) THEN
               t = b(l); b(l) = b(k); b(k) = t
            END IF
         END DO
         END IF
   
      END SELECT

      END SUBROUTINE WGESL
! End of BLAS_UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE gckpp_LinearAlgebra

