! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Auxiliary Routines File
! 
! Generated by KPP-2.2.4_gc symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : gckpp_Util.f90
! Time                 : Wed Nov 30 14:50:29 2016
! Working directory    : /n/home05/msulprizio/GC/FlexChem/Mechanisms/Standard
! Equation file        : gckpp.kpp
! Output root filename : gckpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE gckpp_Util

  USE gckpp_Parameters
  IMPLICIT NONE

CONTAINS



! User INLINED Utility Functions

! End INLINED Utility Functions

! Utility Functions from KPP_HOME/util/util
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! UTIL - Utility functions
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! ****************************************************************
!                            
! InitSaveData - Opens the data file for writing
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE InitSaveData ()

      USE gckpp_Parameters

      open(10, file='gckpp.dat')

      END SUBROUTINE InitSaveData

! End of InitSaveData function
! ****************************************************************

! ****************************************************************
!                            
! SaveData - Write LOOKAT species in the data file 
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE SaveData ()

      USE gckpp_Global
      USE gckpp_Monitor

      INTEGER i

      WRITE(10,999) (TIME-TSTART)/3600.D0,  &
                   (C(LOOKAT(i))/CFACTOR, i=1,NLOOKAT)
999   FORMAT(E24.16,100(1X,E24.16))

      END SUBROUTINE SaveData

! End of SaveData function
! ****************************************************************

! ****************************************************************
!                            
! CloseSaveData - Close the data file 
!   Parameters :                                                  
!
! ****************************************************************

      SUBROUTINE CloseSaveData ()

      USE gckpp_Parameters

      CLOSE(10)

      END SUBROUTINE CloseSaveData

! End of CloseSaveData function
! ****************************************************************

! ****************************************************************
!                            
! GenerateMatlab - Generates MATLAB file to load the data file 
!   Parameters : 
!                It will have a character string to prefix each 
!                species name with.                                                 
!
! ****************************************************************

      SUBROUTINE GenerateMatlab ( PREFIX )

      USE gckpp_Parameters
      USE gckpp_Global
      USE gckpp_Monitor

      
      CHARACTER(LEN=8) PREFIX 
      INTEGER i

      open(20, file='gckpp.m')
      write(20,*) 'load gckpp.dat;'
      write(20,990) PREFIX
990   FORMAT(A1,'c = gckpp;')
      write(20,*) 'clear gckpp;'
      write(20,991) PREFIX, PREFIX
991   FORMAT(A1,'t=',A1,'c(:,1);')
      write(20,992) PREFIX
992   FORMAT(A1,'c(:,1)=[];')

      do i=1,NLOOKAT
        write(20,993) PREFIX, SPC_NAMES(LOOKAT(i)), PREFIX, i
993     FORMAT(A1,A6,' = ',A1,'c(:,',I2,');')
      end do
      
      CLOSE(20)

      END SUBROUTINE GenerateMatlab

! End of GenerateMatlab function
! ****************************************************************


! End Utility Functions from KPP_HOME/util/util
! End of UTIL function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Shuffle_user2kpp - function to copy concentrations from USER to KPP
!   Arguments :
!      V_USER    - Concentration of variable species in USER's order
!      V         - Concentrations of variable species (local)
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Shuffle_user2kpp ( V_USER, V )

! V_USER - Concentration of variable species in USER's order
  REAL(kind=dp) :: V_USER(NVAR)
! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)

  V(332) = V_USER(1)
  V(334) = V_USER(2)
  V(337) = V_USER(3)
  V(376) = V_USER(4)
  V(264) = V_USER(5)
  V(357) = V_USER(6)
  V(347) = V_USER(7)
  V(242) = V_USER(8)
  V(298) = V_USER(9)
  V(278) = V_USER(10)
  V(380) = V_USER(11)
  V(329) = V_USER(12)
  V(385) = V_USER(13)
  V(350) = V_USER(14)
  V(279) = V_USER(15)
  V(356) = V_USER(16)
  V(327) = V_USER(17)
  V(316) = V_USER(18)
  V(381) = V_USER(19)
  V(344) = V_USER(20)
  V(368) = V_USER(21)
  V(307) = V_USER(22)
  V(280) = V_USER(23)
  V(354) = V_USER(24)
  V(287) = V_USER(25)
  V(390) = V_USER(26)
  V(299) = V_USER(27)
  V(361) = V_USER(28)
  V(308) = V_USER(29)
  V(359) = V_USER(30)
  V(339) = V_USER(31)
  V(323) = V_USER(32)
  V(322) = V_USER(33)
  V(309) = V_USER(34)
  V(319) = V_USER(35)
  V(346) = V_USER(36)
  V(375) = V_USER(37)
  V(342) = V_USER(38)
  V(360) = V_USER(39)
  V(288) = V_USER(40)
  V(331) = V_USER(41)
  V(267) = V_USER(42)
  V(378) = V_USER(43)
  V(374) = V_USER(44)
  V(364) = V_USER(45)
  V(392) = V_USER(46)
  V(1) = V_USER(47)
  V(289) = V_USER(48)
  V(353) = V_USER(49)
  V(305) = V_USER(50)
  V(377) = V_USER(51)
  V(265) = V_USER(52)
  V(260) = V_USER(53)
  V(306) = V_USER(54)
  V(384) = V_USER(55)
  V(382) = V_USER(56)
  V(393) = V_USER(57)
  V(395) = V_USER(58)
  V(386) = V_USER(59)
  V(388) = V_USER(60)
  V(383) = V_USER(61)
  V(266) = V_USER(62)
  V(315) = V_USER(63)
  V(340) = V_USER(64)
  V(295) = V_USER(65)
  V(257) = V_USER(66)
  V(345) = V_USER(67)
  V(320) = V_USER(68)
  V(296) = V_USER(69)
  V(358) = V_USER(70)
  V(370) = V_USER(71)
  V(369) = V_USER(72)
  V(297) = V_USER(73)
  V(281) = V_USER(74)
  V(282) = V_USER(75)
  V(372) = V_USER(76)
  V(352) = V_USER(77)
  V(362) = V_USER(78)
  V(300) = V_USER(79)
  V(312) = V_USER(80)
  V(291) = V_USER(81)
  V(243) = V_USER(82)
  V(349) = V_USER(83)
  V(302) = V_USER(84)
  V(244) = V_USER(85)
  V(283) = V_USER(86)
  V(379) = V_USER(87)
  V(294) = V_USER(88)
  V(2) = V_USER(89)
  V(3) = V_USER(90)
  V(4) = V_USER(91)
  V(261) = V_USER(92)
  V(262) = V_USER(93)
  V(258) = V_USER(94)
  V(5) = V_USER(95)
  V(6) = V_USER(96)
  V(7) = V_USER(97)
  V(8) = V_USER(98)
  V(9) = V_USER(99)
  V(10) = V_USER(100)
  V(293) = V_USER(101)
  V(389) = V_USER(102)
  V(371) = V_USER(103)
  V(325) = V_USER(104)
  V(387) = V_USER(105)
  V(246) = V_USER(106)
  V(317) = V_USER(107)
  V(269) = V_USER(108)
  V(270) = V_USER(109)
  V(285) = V_USER(110)
  V(271) = V_USER(111)
  V(333) = V_USER(112)
  V(310) = V_USER(113)
  V(363) = V_USER(114)
  V(314) = V_USER(115)
  V(351) = V_USER(116)
  V(303) = V_USER(117)
  V(304) = V_USER(118)
  V(311) = V_USER(119)
  V(365) = V_USER(120)
  V(366) = V_USER(121)
  V(324) = V_USER(122)
  V(292) = V_USER(123)
  V(341) = V_USER(124)
  V(326) = V_USER(125)
  V(11) = V_USER(126)
  V(247) = V_USER(127)
  V(313) = V_USER(128)
  V(301) = V_USER(129)
  V(248) = V_USER(130)
  V(318) = V_USER(131)
  V(338) = V_USER(133)
  V(367) = V_USER(134)
  V(335) = V_USER(135)
  V(328) = V_USER(136)
  V(330) = V_USER(137)
  V(336) = V_USER(138)
  V(343) = V_USER(139)
  V(263) = V_USER(140)
  V(290) = V_USER(141)
  V(391) = V_USER(142)
  V(321) = V_USER(143)
  V(373) = V_USER(144)
  V(286) = V_USER(145)
  V(272) = V_USER(146)
  V(268) = V_USER(147)
  V(273) = V_USER(148)
  V(348) = V_USER(149)
  V(394) = V_USER(150)
  V(355) = V_USER(151)
  V(284) = V_USER(152)
  V(245) = V_USER(153)
  V(249) = V_USER(154)
  V(250) = V_USER(155)
  V(251) = V_USER(156)
  V(252) = V_USER(157)
  V(253) = V_USER(158)
  V(254) = V_USER(159)
  V(274) = V_USER(160)
  V(275) = V_USER(161)
  V(276) = V_USER(162)
  V(277) = V_USER(163)
  V(255) = V_USER(164)
  V(256) = V_USER(165)
  V(259) = V_USER(166)
  V(12) = V_USER(168)
  V(13) = V_USER(175)
  V(14) = V_USER(176)
  V(15) = V_USER(177)
  V(16) = V_USER(178)
  V(17) = V_USER(179)
  V(18) = V_USER(180)
  V(19) = V_USER(181)
  V(20) = V_USER(182)
  V(21) = V_USER(183)
  V(22) = V_USER(184)
  V(23) = V_USER(185)
  V(24) = V_USER(186)
  V(25) = V_USER(187)
  V(26) = V_USER(188)
  V(27) = V_USER(189)
  V(28) = V_USER(190)
  V(29) = V_USER(191)
  V(30) = V_USER(192)
  V(31) = V_USER(193)
  V(32) = V_USER(194)
  V(33) = V_USER(195)
  V(34) = V_USER(196)
  V(35) = V_USER(197)
  V(36) = V_USER(198)
  V(37) = V_USER(199)
  V(38) = V_USER(200)
  V(39) = V_USER(201)
  V(40) = V_USER(202)
  V(41) = V_USER(203)
  V(42) = V_USER(204)
  V(43) = V_USER(205)
  V(44) = V_USER(206)
  V(45) = V_USER(207)
  V(46) = V_USER(208)
  V(47) = V_USER(209)
  V(48) = V_USER(210)
  V(49) = V_USER(211)
  V(50) = V_USER(212)
  V(51) = V_USER(213)
  V(52) = V_USER(214)
  V(53) = V_USER(215)
  V(54) = V_USER(216)
  V(55) = V_USER(217)
  V(56) = V_USER(218)
  V(57) = V_USER(219)
  V(58) = V_USER(220)
  V(59) = V_USER(221)
  V(60) = V_USER(222)
  V(61) = V_USER(223)
  V(62) = V_USER(224)
  V(63) = V_USER(225)
  V(64) = V_USER(226)
  V(65) = V_USER(227)
  V(66) = V_USER(228)
  V(67) = V_USER(229)
  V(68) = V_USER(230)
  V(69) = V_USER(231)
  V(70) = V_USER(232)
  V(71) = V_USER(233)
  V(72) = V_USER(234)
  V(73) = V_USER(235)
  V(74) = V_USER(236)
  V(75) = V_USER(237)
  V(76) = V_USER(238)
  V(77) = V_USER(239)
  V(78) = V_USER(240)
  V(79) = V_USER(241)
  V(80) = V_USER(242)
  V(81) = V_USER(243)
  V(82) = V_USER(244)
  V(83) = V_USER(245)
  V(84) = V_USER(246)
  V(85) = V_USER(247)
  V(86) = V_USER(248)
  V(87) = V_USER(249)
  V(88) = V_USER(250)
  V(89) = V_USER(251)
  V(90) = V_USER(252)
  V(91) = V_USER(253)
  V(92) = V_USER(254)
  V(93) = V_USER(255)
  V(94) = V_USER(256)
  V(95) = V_USER(257)
  V(96) = V_USER(258)
  V(97) = V_USER(259)
  V(98) = V_USER(260)
  V(99) = V_USER(261)
  V(100) = V_USER(262)
  V(101) = V_USER(263)
  V(102) = V_USER(264)
  V(103) = V_USER(265)
  V(104) = V_USER(266)
  V(105) = V_USER(267)
  V(106) = V_USER(268)
  V(107) = V_USER(269)
  V(108) = V_USER(270)
  V(109) = V_USER(271)
  V(110) = V_USER(272)
  V(111) = V_USER(273)
  V(112) = V_USER(274)
  V(113) = V_USER(275)
  V(114) = V_USER(276)
  V(115) = V_USER(277)
  V(116) = V_USER(278)
  V(117) = V_USER(279)
  V(118) = V_USER(280)
  V(119) = V_USER(281)
  V(120) = V_USER(282)
  V(121) = V_USER(283)
  V(122) = V_USER(284)
  V(123) = V_USER(285)
  V(124) = V_USER(286)
  V(125) = V_USER(287)
  V(126) = V_USER(288)
  V(127) = V_USER(289)
  V(128) = V_USER(290)
  V(129) = V_USER(291)
  V(130) = V_USER(292)
  V(131) = V_USER(293)
  V(132) = V_USER(294)
  V(133) = V_USER(295)
  V(134) = V_USER(296)
  V(135) = V_USER(297)
  V(136) = V_USER(298)
  V(137) = V_USER(299)
  V(138) = V_USER(300)
  V(139) = V_USER(301)
  V(140) = V_USER(302)
  V(141) = V_USER(303)
  V(142) = V_USER(304)
  V(143) = V_USER(305)
  V(144) = V_USER(306)
  V(145) = V_USER(307)
  V(146) = V_USER(308)
  V(147) = V_USER(309)
  V(148) = V_USER(310)
  V(149) = V_USER(311)
  V(150) = V_USER(312)
  V(151) = V_USER(313)
  V(152) = V_USER(314)
  V(153) = V_USER(315)
  V(154) = V_USER(316)
  V(155) = V_USER(317)
  V(156) = V_USER(318)
  V(157) = V_USER(319)
  V(158) = V_USER(320)
  V(159) = V_USER(321)
  V(160) = V_USER(322)
  V(161) = V_USER(323)
  V(162) = V_USER(324)
  V(163) = V_USER(325)
  V(164) = V_USER(326)
  V(165) = V_USER(327)
  V(166) = V_USER(328)
  V(167) = V_USER(329)
  V(168) = V_USER(330)
  V(169) = V_USER(331)
  V(170) = V_USER(332)
  V(171) = V_USER(333)
  V(172) = V_USER(334)
  V(173) = V_USER(335)
  V(174) = V_USER(336)
  V(175) = V_USER(337)
  V(176) = V_USER(338)
  V(177) = V_USER(339)
  V(178) = V_USER(340)
  V(179) = V_USER(341)
  V(180) = V_USER(342)
  V(181) = V_USER(343)
  V(182) = V_USER(344)
  V(183) = V_USER(345)
  V(184) = V_USER(346)
  V(185) = V_USER(347)
  V(186) = V_USER(348)
  V(187) = V_USER(349)
  V(188) = V_USER(350)
  V(189) = V_USER(351)
  V(190) = V_USER(352)
  V(191) = V_USER(353)
  V(192) = V_USER(354)
  V(193) = V_USER(355)
  V(194) = V_USER(356)
  V(195) = V_USER(357)
  V(196) = V_USER(358)
  V(197) = V_USER(359)
  V(198) = V_USER(360)
  V(199) = V_USER(361)
  V(200) = V_USER(362)
  V(201) = V_USER(363)
  V(202) = V_USER(364)
  V(203) = V_USER(365)
  V(204) = V_USER(366)
  V(205) = V_USER(367)
  V(206) = V_USER(368)
  V(207) = V_USER(369)
  V(208) = V_USER(370)
  V(209) = V_USER(371)
  V(210) = V_USER(372)
  V(211) = V_USER(373)
  V(212) = V_USER(374)
  V(213) = V_USER(375)
  V(214) = V_USER(376)
  V(215) = V_USER(377)
  V(216) = V_USER(378)
  V(217) = V_USER(379)
  V(218) = V_USER(380)
  V(219) = V_USER(381)
  V(220) = V_USER(382)
  V(221) = V_USER(383)
  V(222) = V_USER(384)
  V(223) = V_USER(385)
  V(224) = V_USER(386)
  V(225) = V_USER(387)
  V(226) = V_USER(388)
  V(227) = V_USER(389)
  V(228) = V_USER(390)
  V(229) = V_USER(391)
      
END SUBROUTINE Shuffle_user2kpp

! End of Shuffle_user2kpp function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Shuffle_kpp2user - function to restore concentrations from KPP to USER
!   Arguments :
!      V         - Concentrations of variable species (local)
!      V_USER    - Concentration of variable species in USER's order
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Shuffle_kpp2user ( V, V_USER )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! V_USER - Concentration of variable species in USER's order
  REAL(kind=dp) :: V_USER(NVAR)

  V_USER(1) = V(332)
  V_USER(2) = V(334)
  V_USER(3) = V(337)
  V_USER(4) = V(376)
  V_USER(5) = V(264)
  V_USER(6) = V(357)
  V_USER(7) = V(347)
  V_USER(8) = V(242)
  V_USER(9) = V(298)
  V_USER(10) = V(278)
  V_USER(11) = V(380)
  V_USER(12) = V(329)
  V_USER(13) = V(385)
  V_USER(14) = V(350)
  V_USER(15) = V(279)
  V_USER(16) = V(356)
  V_USER(17) = V(327)
  V_USER(18) = V(316)
  V_USER(19) = V(381)
  V_USER(20) = V(344)
  V_USER(21) = V(368)
  V_USER(22) = V(307)
  V_USER(23) = V(280)
  V_USER(24) = V(354)
  V_USER(25) = V(287)
  V_USER(26) = V(390)
  V_USER(27) = V(299)
  V_USER(28) = V(361)
  V_USER(29) = V(308)
  V_USER(30) = V(359)
  V_USER(31) = V(339)
  V_USER(32) = V(323)
  V_USER(33) = V(322)
  V_USER(34) = V(309)
  V_USER(35) = V(319)
  V_USER(36) = V(346)
  V_USER(37) = V(375)
  V_USER(38) = V(342)
  V_USER(39) = V(360)
  V_USER(40) = V(288)
  V_USER(41) = V(331)
  V_USER(42) = V(267)
  V_USER(43) = V(378)
  V_USER(44) = V(374)
  V_USER(45) = V(364)
  V_USER(46) = V(392)
  V_USER(47) = V(1)
  V_USER(48) = V(289)
  V_USER(49) = V(353)
  V_USER(50) = V(305)
  V_USER(51) = V(377)
  V_USER(52) = V(265)
  V_USER(53) = V(260)
  V_USER(54) = V(306)
  V_USER(55) = V(384)
  V_USER(56) = V(382)
  V_USER(57) = V(393)
  V_USER(58) = V(395)
  V_USER(59) = V(386)
  V_USER(60) = V(388)
  V_USER(61) = V(383)
  V_USER(62) = V(266)
  V_USER(63) = V(315)
  V_USER(64) = V(340)
  V_USER(65) = V(295)
  V_USER(66) = V(257)
  V_USER(67) = V(345)
  V_USER(68) = V(320)
  V_USER(69) = V(296)
  V_USER(70) = V(358)
  V_USER(71) = V(370)
  V_USER(72) = V(369)
  V_USER(73) = V(297)
  V_USER(74) = V(281)
  V_USER(75) = V(282)
  V_USER(76) = V(372)
  V_USER(77) = V(352)
  V_USER(78) = V(362)
  V_USER(79) = V(300)
  V_USER(80) = V(312)
  V_USER(81) = V(291)
  V_USER(82) = V(243)
  V_USER(83) = V(349)
  V_USER(84) = V(302)
  V_USER(85) = V(244)
  V_USER(86) = V(283)
  V_USER(87) = V(379)
  V_USER(88) = V(294)
  V_USER(89) = V(2)
  V_USER(90) = V(3)
  V_USER(91) = V(4)
  V_USER(92) = V(261)
  V_USER(93) = V(262)
  V_USER(94) = V(258)
  V_USER(95) = V(5)
  V_USER(96) = V(6)
  V_USER(97) = V(7)
  V_USER(98) = V(8)
  V_USER(99) = V(9)
  V_USER(100) = V(10)
  V_USER(101) = V(293)
  V_USER(102) = V(389)
  V_USER(103) = V(371)
  V_USER(104) = V(325)
  V_USER(105) = V(387)
  V_USER(106) = V(246)
  V_USER(107) = V(317)
  V_USER(108) = V(269)
  V_USER(109) = V(270)
  V_USER(110) = V(285)
  V_USER(111) = V(271)
  V_USER(112) = V(333)
  V_USER(113) = V(310)
  V_USER(114) = V(363)
  V_USER(115) = V(314)
  V_USER(116) = V(351)
  V_USER(117) = V(303)
  V_USER(118) = V(304)
  V_USER(119) = V(311)
  V_USER(120) = V(365)
  V_USER(121) = V(366)
  V_USER(122) = V(324)
  V_USER(123) = V(292)
  V_USER(124) = V(341)
  V_USER(125) = V(326)
  V_USER(126) = V(11)
  V_USER(127) = V(247)
  V_USER(128) = V(313)
  V_USER(129) = V(301)
  V_USER(130) = V(248)
  V_USER(131) = V(318)
  V_USER(133) = V(338)
  V_USER(134) = V(367)
  V_USER(135) = V(335)
  V_USER(136) = V(328)
  V_USER(137) = V(330)
  V_USER(138) = V(336)
  V_USER(139) = V(343)
  V_USER(140) = V(263)
  V_USER(141) = V(290)
  V_USER(142) = V(391)
  V_USER(143) = V(321)
  V_USER(144) = V(373)
  V_USER(145) = V(286)
  V_USER(146) = V(272)
  V_USER(147) = V(268)
  V_USER(148) = V(273)
  V_USER(149) = V(348)
  V_USER(150) = V(394)
  V_USER(151) = V(355)
  V_USER(152) = V(284)
  V_USER(153) = V(245)
  V_USER(154) = V(249)
  V_USER(155) = V(250)
  V_USER(156) = V(251)
  V_USER(157) = V(252)
  V_USER(158) = V(253)
  V_USER(159) = V(254)
  V_USER(160) = V(274)
  V_USER(161) = V(275)
  V_USER(162) = V(276)
  V_USER(163) = V(277)
  V_USER(164) = V(255)
  V_USER(165) = V(256)
  V_USER(166) = V(259)
  V_USER(168) = V(12)
  V_USER(175) = V(13)
  V_USER(176) = V(14)
  V_USER(177) = V(15)
  V_USER(178) = V(16)
  V_USER(179) = V(17)
  V_USER(180) = V(18)
  V_USER(181) = V(19)
  V_USER(182) = V(20)
  V_USER(183) = V(21)
  V_USER(184) = V(22)
  V_USER(185) = V(23)
  V_USER(186) = V(24)
  V_USER(187) = V(25)
  V_USER(188) = V(26)
  V_USER(189) = V(27)
  V_USER(190) = V(28)
  V_USER(191) = V(29)
  V_USER(192) = V(30)
  V_USER(193) = V(31)
  V_USER(194) = V(32)
  V_USER(195) = V(33)
  V_USER(196) = V(34)
  V_USER(197) = V(35)
  V_USER(198) = V(36)
  V_USER(199) = V(37)
  V_USER(200) = V(38)
  V_USER(201) = V(39)
  V_USER(202) = V(40)
  V_USER(203) = V(41)
  V_USER(204) = V(42)
  V_USER(205) = V(43)
  V_USER(206) = V(44)
  V_USER(207) = V(45)
  V_USER(208) = V(46)
  V_USER(209) = V(47)
  V_USER(210) = V(48)
  V_USER(211) = V(49)
  V_USER(212) = V(50)
  V_USER(213) = V(51)
  V_USER(214) = V(52)
  V_USER(215) = V(53)
  V_USER(216) = V(54)
  V_USER(217) = V(55)
  V_USER(218) = V(56)
  V_USER(219) = V(57)
  V_USER(220) = V(58)
  V_USER(221) = V(59)
  V_USER(222) = V(60)
  V_USER(223) = V(61)
  V_USER(224) = V(62)
  V_USER(225) = V(63)
  V_USER(226) = V(64)
  V_USER(227) = V(65)
  V_USER(228) = V(66)
  V_USER(229) = V(67)
  V_USER(230) = V(68)
  V_USER(231) = V(69)
  V_USER(232) = V(70)
  V_USER(233) = V(71)
  V_USER(234) = V(72)
  V_USER(235) = V(73)
  V_USER(236) = V(74)
  V_USER(237) = V(75)
  V_USER(238) = V(76)
  V_USER(239) = V(77)
  V_USER(240) = V(78)
  V_USER(241) = V(79)
  V_USER(242) = V(80)
  V_USER(243) = V(81)
  V_USER(244) = V(82)
  V_USER(245) = V(83)
  V_USER(246) = V(84)
  V_USER(247) = V(85)
  V_USER(248) = V(86)
  V_USER(249) = V(87)
  V_USER(250) = V(88)
  V_USER(251) = V(89)
  V_USER(252) = V(90)
  V_USER(253) = V(91)
  V_USER(254) = V(92)
  V_USER(255) = V(93)
  V_USER(256) = V(94)
  V_USER(257) = V(95)
  V_USER(258) = V(96)
  V_USER(259) = V(97)
  V_USER(260) = V(98)
  V_USER(261) = V(99)
  V_USER(262) = V(100)
  V_USER(263) = V(101)
  V_USER(264) = V(102)
  V_USER(265) = V(103)
  V_USER(266) = V(104)
  V_USER(267) = V(105)
  V_USER(268) = V(106)
  V_USER(269) = V(107)
  V_USER(270) = V(108)
  V_USER(271) = V(109)
  V_USER(272) = V(110)
  V_USER(273) = V(111)
  V_USER(274) = V(112)
  V_USER(275) = V(113)
  V_USER(276) = V(114)
  V_USER(277) = V(115)
  V_USER(278) = V(116)
  V_USER(279) = V(117)
  V_USER(280) = V(118)
  V_USER(281) = V(119)
  V_USER(282) = V(120)
  V_USER(283) = V(121)
  V_USER(284) = V(122)
  V_USER(285) = V(123)
  V_USER(286) = V(124)
  V_USER(287) = V(125)
  V_USER(288) = V(126)
  V_USER(289) = V(127)
  V_USER(290) = V(128)
  V_USER(291) = V(129)
  V_USER(292) = V(130)
  V_USER(293) = V(131)
  V_USER(294) = V(132)
  V_USER(295) = V(133)
  V_USER(296) = V(134)
  V_USER(297) = V(135)
  V_USER(298) = V(136)
  V_USER(299) = V(137)
  V_USER(300) = V(138)
  V_USER(301) = V(139)
  V_USER(302) = V(140)
  V_USER(303) = V(141)
  V_USER(304) = V(142)
  V_USER(305) = V(143)
  V_USER(306) = V(144)
  V_USER(307) = V(145)
  V_USER(308) = V(146)
  V_USER(309) = V(147)
  V_USER(310) = V(148)
  V_USER(311) = V(149)
  V_USER(312) = V(150)
  V_USER(313) = V(151)
  V_USER(314) = V(152)
  V_USER(315) = V(153)
  V_USER(316) = V(154)
  V_USER(317) = V(155)
  V_USER(318) = V(156)
  V_USER(319) = V(157)
  V_USER(320) = V(158)
  V_USER(321) = V(159)
  V_USER(322) = V(160)
  V_USER(323) = V(161)
  V_USER(324) = V(162)
  V_USER(325) = V(163)
  V_USER(326) = V(164)
  V_USER(327) = V(165)
  V_USER(328) = V(166)
  V_USER(329) = V(167)
  V_USER(330) = V(168)
  V_USER(331) = V(169)
  V_USER(332) = V(170)
  V_USER(333) = V(171)
  V_USER(334) = V(172)
  V_USER(335) = V(173)
  V_USER(336) = V(174)
  V_USER(337) = V(175)
  V_USER(338) = V(176)
  V_USER(339) = V(177)
  V_USER(340) = V(178)
  V_USER(341) = V(179)
  V_USER(342) = V(180)
  V_USER(343) = V(181)
  V_USER(344) = V(182)
  V_USER(345) = V(183)
  V_USER(346) = V(184)
  V_USER(347) = V(185)
  V_USER(348) = V(186)
  V_USER(349) = V(187)
  V_USER(350) = V(188)
  V_USER(351) = V(189)
  V_USER(352) = V(190)
  V_USER(353) = V(191)
  V_USER(354) = V(192)
  V_USER(355) = V(193)
  V_USER(356) = V(194)
  V_USER(357) = V(195)
  V_USER(358) = V(196)
  V_USER(359) = V(197)
  V_USER(360) = V(198)
  V_USER(361) = V(199)
  V_USER(362) = V(200)
  V_USER(363) = V(201)
  V_USER(364) = V(202)
  V_USER(365) = V(203)
  V_USER(366) = V(204)
  V_USER(367) = V(205)
  V_USER(368) = V(206)
  V_USER(369) = V(207)
  V_USER(370) = V(208)
  V_USER(371) = V(209)
  V_USER(372) = V(210)
  V_USER(373) = V(211)
  V_USER(374) = V(212)
  V_USER(375) = V(213)
  V_USER(376) = V(214)
  V_USER(377) = V(215)
  V_USER(378) = V(216)
  V_USER(379) = V(217)
  V_USER(380) = V(218)
  V_USER(381) = V(219)
  V_USER(382) = V(220)
  V_USER(383) = V(221)
  V_USER(384) = V(222)
  V_USER(385) = V(223)
  V_USER(386) = V(224)
  V_USER(387) = V(225)
  V_USER(388) = V(226)
  V_USER(389) = V(227)
  V_USER(390) = V(228)
  V_USER(391) = V(229)
      
END SUBROUTINE Shuffle_kpp2user

! End of Shuffle_kpp2user function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! GetMass - compute total mass of selected atoms
!   Arguments :
!      CL        - Concentration of all species (local)
!      Mass      - value of mass balance
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE GetMass ( CL, Mass )

! CL - Concentration of all species (local)
  REAL(kind=dp) :: CL(NSPEC)
! Mass - value of mass balance
  REAL(kind=dp) :: Mass(1)

      
END SUBROUTINE GetMass

! End of GetMass function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! ComputeFamilies - function to calculate user-defined Prod/Loss families
!   Arguments :
!      V         - Concentrations of variable species (local)
!      FAM       - Accumulated user-defined prod/loss families.
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE ComputeFamilies ( V, FAM )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! FAM - Accumulated user-defined prod/loss families.
  REAL(kind=dp) :: FAM(NFAM)


! Computation of prod/loss families
  FAM(1) = V(13)+V(14)+V(15)+V(16)+V(17)+V(18)+V(19)+V(20)+V(21)+V(22)+V(23)+V(24)+V(25)+V(26)+V(27)+V(28)+V(29)+V(30)&
             &+V(31)+V(32)+V(33)+1.82*V(34)+0.4*V(35)+V(36)+V(37)+V(38)+0.15*V(39)+0.15*V(40)+0.15*V(41)+V(42)+V(43)+V(44)&
             &+V(45)+V(46)+V(47)+2.31*V(48)+V(49)+1.155*V(50)+2*V(51)+V(52)+V(53)+V(54)+1.15*V(55)+0.15*V(56)+V(57)+V(58)&
             &+V(59)+V(60)+V(61)+V(62)+V(63)+V(64)+V(65)+V(66)+V(67)+V(68)+V(69)+V(70)+V(71)+V(72)+V(73)+V(74)+V(75)+V(76)&
             &+V(77)+V(78)+V(79)+V(80)+V(81)+V(82)+2*V(83)+2*V(84)+V(85)+0.3*V(86)+V(87)+V(88)+V(89)
  FAM(2) = V(90)+V(91)+V(92)+V(93)+V(94)+2*V(95)+V(96)+V(97)+V(98)+1.4*V(99)+V(100)+V(101)+0.75*V(102)+V(103)+0.066&
             &*V(104)+0.3*V(105)+V(106)+V(107)+V(108)+V(109)+V(110)+V(111)+V(112)+V(113)+V(114)+V(115)+V(116)+V(117)+V(118)&
             &+V(119)+V(120)+2*V(121)+V(122)+V(123)+0.5*V(124)+V(125)+V(126)+V(127)+2*V(128)+2*V(129)+V(130)+V(131)+V(132)&
             &+V(133)+V(134)+V(135)+V(136)+0.388*V(137)+V(138)+V(139)+V(140)+V(141)+V(142)+V(143)+V(144)+V(145)+V(146)+2&
             &*V(147)+V(148)+V(149)+2*V(150)+V(151)+2*V(152)+2*V(153)+V(154)+V(155)+2*V(156)+V(157)+0.67*V(158)+0.65*V(159)&
             &+0.56*V(160)+0.17*V(161)+V(162)+V(163)+V(164)+V(165)+V(166)+2*V(167)+2*V(168)+2*V(169)+2*V(170)+2*V(171)&
             &+V(172)+V(173)+V(174)+V(175)+V(176)+V(177)+V(178)+2*V(179)+V(180)+2*V(181)+V(182)
  FAM(3) = V(183)+V(96)+0.05*V(184)+0.728*V(29)+V(185)+0.5*V(30)+V(100)+V(33)+0.5*V(38)+0.075*V(186)+0.33*V(187)+0.595&
             &*V(188)+0.375*V(189)+0.39*V(41)+0.56*V(109)+V(190)+0.505*V(191)+V(192)+2*V(193)+V(194)+2*V(111)+V(112)+0.5&
             &*V(195)+0.512*V(113)+0.56*V(114)+0.767*V(115)+0.251*V(196)+0.251*V(42)+0.89*V(120)+0.09*V(197)+0.857*V(198)&
             &+0.5*V(199)+V(200)+V(201)+V(202)+V(203)+V(204)+0.09*V(46)+1.5*V(205)+V(151)+V(157)+V(206)+V(207)+V(208)+V(209)&
             &+0.88*V(210)+V(211)+V(212)+V(213)+V(214)+2*V(215)+2*V(216)+V(217)+V(218)+V(219)+V(220)+V(221)+0.67*V(222)+0.5&
             &*V(223)+0.5*V(224)+V(225)+V(226)
  FAM(4) = V(227)+V(228)+V(229)+V(230)+V(231)+V(232)+V(233)
  FAM(5) = V(234)+V(235)+V(236)+V(237)+V(238)+V(239)+V(240)+V(241)
      
END SUBROUTINE ComputeFamilies

! End of ComputeFamilies function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE gckpp_Util

