! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Function of Chemical Model File
! 
! Generated by KPP-2.2.4_gc symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : gckpp_Function.f90
! Time                 : Wed Nov 30 14:50:58 2016
! Working directory    : /n/home05/msulprizio/GC/FlexChem/Mechanisms/UCX
! Equation file        : gckpp.kpp
! Output root filename : gckpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE gckpp_Function

  USE gckpp_Parameters
  IMPLICIT NONE

! A - Rate for each equation
  REAL(kind=dp) :: A(NREACT)
!$OMP THREADPRIVATE(  A )

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun - time derivatives of variables - Agregate form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      Vdot      - Time derivative of variable species concentrations
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun ( V, F, RCT, Vdot )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! Vdot - Time derivative of variable species concentrations
  REAL(kind=dp) :: Vdot(NVAR)


! Computation of equation rates
  A(1) = RCT(1)*V(373)*V(376)
  A(2) = RCT(2)*V(368)*V(373)
  A(3) = RCT(3)*V(373)*V(374)
  A(4) = RCT(4)*V(373)*V(375)
  A(5) = RCT(5)*V(373)*V(380)
  A(6) = RCT(6)*V(368)*V(368)
  A(7) = RCT(7)*V(368)*V(368)
  A(8) = RCT(8)*V(368)*V(374)
  A(9) = RCT(9)*V(330)*V(368)
  A(10) = RCT(10)*V(374)*V(376)
  A(11) = RCT(11)*V(374)*V(374)
  A(12) = RCT(12)*V(366)*V(368)
  A(13) = RCT(13)*V(316)*V(368)
  A(14) = RCT(14)*V(376)*V(380)
  A(15) = RCT(15)*V(374)*V(380)
  A(16) = RCT(16)*V(380)*V(380)
  A(17) = RCT(17)*V(380)*V(380)
  A(18) = RCT(18)*V(275)*V(368)
  A(19) = RCT(19)*V(275)*V(368)
  A(20) = RCT(20)*V(284)*V(368)
  A(21) = RCT(21)*V(284)*V(368)
  A(22) = RCT(22)*V(368)*V(378)
  A(23) = RCT(23)*V(368)*V(375)
  A(24) = RCT(24)*V(340)*V(368)
  A(25) = RCT(25)*V(368)*V(376)
  A(26) = RCT(26)*V(266)*V(368)
  A(27) = RCT(27)*V(374)*V(375)
  A(28) = RCT(28)*V(273)
  A(29) = RCT(29)*V(273)*V(368)
  A(30) = RCT(30)*V(374)*V(379)
  A(31) = RCT(31)*V(376)*V(379)
  A(32) = RCT(32)*V(368)*V(379)
  A(33) = RCT(33)*V(375)*V(379)
  A(34) = RCT(34)*V(292)
  A(35) = RCT(35)*V(293)*V(368)
  A(36) = RCT(36)*V(368)*F(3)
  A(37) = RCT(37)*V(375)*V(379)
  A(38) = RCT(38)*V(378)*V(379)
  A(39) = RCT(39)*V(362)*V(368)
  A(40) = RCT(40)*V(362)*V(379)
  A(41) = RCT(41)*V(364)*V(375)
  A(42) = RCT(42)*V(252)
  A(43) = RCT(43)*V(364)*V(376)
  A(44) = RCT(44)*V(285)*V(368)
  A(45) = RCT(45)*V(337)*V(376)
  A(46) = RCT(46)*V(264)*V(368)
  A(47) = RCT(47)*V(264)*V(368)
  A(48) = RCT(48)*V(319)*V(376)
  A(49) = RCT(49)*V(326)*V(376)
  A(50) = RCT(50)*V(250)*V(368)
  A(51) = RCT(51)*V(354)*V(376)
  A(52) = RCT(52)*V(354)*V(376)
  A(53) = RCT(53)*V(344)*V(376)
  A(54) = RCT(54)*V(343)*V(376)
  A(55) = RCT(55)*V(332)*V(376)
  A(56) = RCT(56)*V(347)*V(376)
  A(57) = RCT(57)*V(347)
  A(58) = RCT(58)*V(335)*V(376)
  A(59) = RCT(59)*V(339)*V(376)
  A(60) = RCT(60)*V(339)
  A(61) = RCT(61)*V(328)*V(376)
  A(62) = RCT(62)*V(334)*V(376)
  A(63) = RCT(63)*V(348)*V(376)
  A(64) = RCT(64)*V(348)*V(379)
  A(65) = RCT(65)*V(345)*V(379)
  A(66) = RCT(66)*V(325)*V(379)
  A(67) = RCT(67)*V(325)*V(376)
  A(68) = RCT(68)*V(325)*V(375)
  A(69) = RCT(69)*V(325)*V(374)
  A(70) = RCT(70)*V(310)*V(379)
  A(71) = RCT(71)*V(310)*V(376)
  A(72) = RCT(72)*V(310)*V(374)
  A(73) = RCT(73)*V(310)*V(380)
  A(74) = RCT(74)*V(345)*V(373)
  A(75) = RCT(75)*V(345)*V(368)
  A(76) = RCT(76)*V(308)*V(376)
  A(77) = RCT(77)*V(308)*V(374)
  A(78) = RCT(78)*V(308)*V(380)
  A(79) = RCT(79)*V(348)*V(348)
  A(80) = RCT(80)*V(331)*V(376)
  A(81) = RCT(81)*V(250)*V(379)
  A(82) = RCT(82)*V(356)*V(368)
  A(83) = RCT(83)*V(324)*V(368)
  A(84) = RCT(84)*V(358)*V(368)
  A(85) = RCT(85)*V(338)*V(375)
  A(86) = RCT(86)*V(246)
  A(87) = RCT(87)*V(346)*V(375)
  A(88) = RCT(88)*V(301)
  A(89) = RCT(89)*V(338)*V(376)
  A(90) = RCT(90)*V(346)*V(376)
  A(91) = RCT(91)*V(358)*V(379)
  A(92) = RCT(92)*V(321)*V(368)
  A(93) = RCT(93)*V(319)*V(380)
  A(94) = RCT(94)*V(326)*V(380)
  A(95) = RCT(95)*V(354)*V(374)
  A(96) = RCT(96)*V(344)*V(374)
  A(97) = RCT(97)*V(343)*V(374)
  A(98) = RCT(98)*V(332)*V(374)
  A(99) = RCT(99)*V(347)*V(374)
  A(100) = RCT(100)*V(335)*V(374)
  A(101) = RCT(101)*V(339)*V(374)
  A(102) = RCT(102)*V(328)*V(374)
  A(103) = RCT(103)*V(334)*V(374)
  A(104) = RCT(104)*V(348)*V(374)
  A(105) = RCT(105)*V(331)*V(374)
  A(106) = RCT(106)*V(359)*V(368)
  A(107) = RCT(107)*V(337)*V(380)
  A(108) = RCT(108)*V(359)*V(379)
  A(109) = RCT(109)*V(354)*V(380)
  A(110) = RCT(110)*V(344)*V(380)
  A(111) = RCT(111)*V(343)*V(380)
  A(112) = RCT(112)*V(332)*V(380)
  A(113) = RCT(113)*V(347)*V(380)
  A(114) = RCT(114)*V(347)*V(347)
  A(115) = RCT(115)*V(336)*V(380)
  A(116) = RCT(116)*V(335)*V(380)
  A(117) = RCT(117)*V(339)*V(380)
  A(118) = RCT(118)*V(328)*V(380)
  A(119) = RCT(119)*V(334)*V(380)
  A(120) = RCT(120)*V(348)*V(380)
  A(121) = RCT(121)*V(331)*V(380)
  A(122) = RCT(122)*V(368)*F(1)
  A(123) = RCT(123)*V(298)*V(368)
  A(124) = RCT(124)*V(337)*V(337)
  A(125) = RCT(125)*V(337)*V(337)
  A(126) = RCT(126)*V(337)*V(374)
  A(127) = RCT(127)*V(319)*V(374)
  A(128) = RCT(128)*V(326)*V(374)
  A(129) = RCT(129)*V(364)*V(374)
  A(130) = RCT(130)*V(338)*V(374)
  A(131) = RCT(131)*V(346)*V(374)
  A(132) = RCT(132)*V(306)*V(368)
  A(133) = RCT(133)*V(306)*V(373)
  A(134) = RCT(134)*V(301)*V(368)
  A(135) = RCT(135)*V(301)*V(373)
  A(136) = RCT(136)*V(342)*V(368)
  A(137) = RCT(137)*V(342)*V(368)
  A(138) = RCT(138)*V(306)*V(379)
  A(139) = RCT(139)*V(314)*V(368)
  A(140) = RCT(140)*V(350)*V(368)
  A(141) = RCT(141)*V(314)*V(379)
  A(142) = RCT(142)*V(350)*V(379)
  A(143) = RCT(143)*V(305)*V(368)
  A(144) = RCT(144)*V(363)*V(368)
  A(145) = RCT(145)*V(361)*V(368)
  A(146) = RCT(146)*V(355)*V(368)
  A(147) = RCT(147)*V(355)*V(368)
  A(148) = RCT(148)*V(319)*V(364)
  A(149) = RCT(149)*V(326)*V(364)
  A(150) = RCT(150)*V(319)*V(364)
  A(151) = RCT(151)*V(326)*V(364)
  A(152) = RCT(152)*V(305)*V(373)
  A(153) = RCT(153)*V(363)*V(373)
  A(154) = RCT(154)*V(361)*V(373)
  A(155) = RCT(155)*V(305)*V(379)
  A(156) = RCT(156)*V(361)*V(379)
  A(157) = RCT(157)*V(361)*V(379)
  A(158) = RCT(158)*V(338)*V(380)
  A(159) = RCT(159)*V(346)*V(380)
  A(160) = RCT(160)*V(338)*V(380)
  A(161) = RCT(161)*V(346)*V(380)
  A(162) = RCT(162)*V(294)*V(368)
  A(163) = RCT(163)*V(294)*V(368)
  A(164) = RCT(164)*V(280)*V(368)
  A(165) = RCT(165)*V(265)*V(368)
  A(166) = RCT(166)*V(267)*V(368)
  A(167) = RCT(167)*V(268)*V(368)
  A(168) = RCT(168)*V(283)*V(368)
  A(169) = RCT(169)*V(277)*V(368)
  A(170) = RCT(170)*V(279)*V(368)
  A(171) = RCT(171)*V(287)*V(368)
  A(172) = RCT(172)*V(287)*V(368)
  A(173) = RCT(173)*V(236)*V(368)
  A(174) = RCT(174)*V(299)*V(374)
  A(175) = RCT(175)*V(299)*V(376)
  A(176) = RCT(176)*V(286)*V(368)
  A(177) = RCT(177)*V(288)*V(368)
  A(178) = RCT(178)*V(291)*V(368)
  A(179) = RCT(179)*V(291)*V(368)
  A(180) = RCT(180)*V(274)*V(368)
  A(181) = RCT(181)*V(274)*V(368)
  A(182) = RCT(182)*V(318)*V(364)
  A(183) = RCT(183)*V(318)*V(364)
  A(184) = RCT(184)*V(318)*V(380)
  A(185) = RCT(185)*V(318)*V(318)
  A(186) = RCT(186)*V(318)*V(374)
  A(187) = RCT(187)*V(318)*V(376)
  A(188) = RCT(188)*V(318)*V(376)
  A(189) = RCT(189)*V(253)*V(368)
  A(190) = RCT(190)*V(285)*V(379)
  A(191) = RCT(191)*V(349)*V(373)
  A(192) = RCT(192)*V(364)*V(364)
  A(193) = RCT(193)*V(364)*V(380)
  A(194) = RCT(194)*V(364)*V(380)
  A(195) = RCT(195)*V(354)*V(364)
  A(196) = RCT(196)*V(343)*V(364)
  A(197) = RCT(197)*V(332)*V(364)
  A(198) = RCT(198)*V(347)*V(364)
  A(199) = RCT(199)*V(336)*V(364)
  A(200) = RCT(200)*V(335)*V(364)
  A(201) = RCT(201)*V(339)*V(364)
  A(202) = RCT(202)*V(334)*V(364)
  A(203) = RCT(203)*V(344)*V(364)
  A(204) = RCT(204)*V(328)*V(364)
  A(205) = RCT(205)*V(348)*V(364)
  A(206) = RCT(206)*V(331)*V(364)
  A(207) = RCT(207)*V(354)*V(364)
  A(208) = RCT(208)*V(343)*V(364)
  A(209) = RCT(209)*V(332)*V(364)
  A(210) = RCT(210)*V(347)*V(364)
  A(211) = RCT(211)*V(336)*V(364)
  A(212) = RCT(212)*V(335)*V(364)
  A(213) = RCT(213)*V(339)*V(364)
  A(214) = RCT(214)*V(344)*V(364)
  A(215) = RCT(215)*V(328)*V(364)
  A(216) = RCT(216)*V(348)*V(364)
  A(217) = RCT(217)*V(331)*V(364)
  A(218) = RCT(218)*V(334)*V(364)
  A(219) = RCT(219)*V(337)*V(364)
  A(220) = RCT(220)*V(337)*V(364)
  A(221) = RCT(221)*V(338)*V(364)
  A(222) = RCT(222)*V(346)*V(364)
  A(223) = RCT(223)*V(379)*V(379)
  A(224) = RCT(224)*V(375)*V(380)
  A(225) = RCT(225)*V(257)
  A(226) = RCT(226)*V(296)*V(373)
  A(227) = RCT(227)*V(309)*V(373)
  A(228) = RCT(228)*V(374)
  A(229) = RCT(229)*V(375)
  A(230) = RCT(230)*V(379)
  A(231) = RCT(231)*V(292)*V(377)
  A(232) = RCT(232)*V(269)*V(368)
  A(233) = RCT(233)*V(269)*V(368)
  A(234) = RCT(234)*V(269)*V(379)
  A(235) = RCT(235)*V(365)*V(368)
  A(236) = RCT(236)*V(367)*V(373)
  A(237) = RCT(237)*V(357)*V(374)
  A(238) = RCT(238)*V(367)*V(374)
  A(239) = RCT(239)*V(368)*V(371)
  A(240) = RCT(240)*V(357)*V(357)
  A(241) = RCT(241)*V(357)*V(357)
  A(242) = RCT(242)*V(357)*V(376)
  A(243) = RCT(243)*V(302)*V(367)
  A(244) = RCT(244)*V(282)*V(368)
  A(245) = RCT(245)*V(312)*V(369)
  A(246) = RCT(246)*V(369)*V(371)
  A(247) = RCT(247)*V(357)*V(368)
  A(248) = RCT(248)*V(367)*V(379)
  A(249) = RCT(249)*V(367)*V(378)
  A(250) = RCT(250)*V(362)*V(367)
  A(251) = RCT(251)*V(321)*V(367)
  A(252) = RCT(252)*V(285)*V(367)
  A(253) = RCT(253)*V(264)*V(367)
  A(254) = RCT(254)*V(367)*V(375)
  A(255) = RCT(255)*V(357)*V(375)
  A(256) = RCT(256)*V(255)*V(368)
  A(257) = RCT(257)*V(256)*V(368)
  A(258) = RCT(258)*V(271)*V(368)
  A(259) = RCT(259)*V(302)*V(377)
  A(260) = RCT(260)*V(312)
  A(261) = RCT(261)*V(371)
  A(262) = RCT(262)*V(312)
  A(263) = RCT(263)*V(371)
  A(264) = RCT(264)*V(349)*V(368)
  A(265) = RCT(265)*V(336)*V(376)
  A(266) = RCT(266)*V(336)*V(376)
  A(267) = RCT(267)*V(336)*V(374)
  A(268) = RCT(268)*V(309)*V(368)
  A(269) = RCT(269)*V(296)*V(368)
  A(270) = RCT(270)*V(352)*V(376)
  A(271) = RCT(271)*V(352)*V(376)
  A(272) = RCT(272)*V(352)*V(374)
  A(273) = RCT(273)*V(351)*V(376)
  A(274) = RCT(274)*V(351)*V(376)
  A(275) = RCT(275)*V(351)*V(374)
  A(276) = RCT(276)*V(295)*V(368)
  A(277) = RCT(277)*V(311)*V(368)
  A(278) = RCT(278)*V(327)*V(368)
  A(279) = RCT(279)*V(304)*V(376)
  A(280) = RCT(280)*V(304)*V(374)
  A(281) = RCT(281)*V(304)*V(375)
  A(282) = RCT(282)*V(237)
  A(283) = RCT(283)*V(290)*V(368)
  A(284) = RCT(284)*V(300)*V(376)
  A(285) = RCT(285)*V(300)*V(376)
  A(286) = RCT(286)*V(300)*V(374)
  A(287) = RCT(287)*V(289)*V(368)
  A(288) = RCT(288)*V(297)*V(376)
  A(289) = RCT(289)*V(297)*V(376)
  A(290) = RCT(290)*V(297)*V(374)
  A(291) = RCT(291)*V(289)*V(373)
  A(292) = RCT(292)*V(278)*V(368)
  A(293) = RCT(293)*V(313)*V(368)
  A(294) = RCT(294)*V(323)*V(376)
  A(295) = RCT(295)*V(323)*V(375)
  A(296) = RCT(296)*V(323)*V(365)
  A(297) = RCT(297)*V(323)*V(377)
  A(298) = RCT(298)*V(323)*V(377)
  A(299) = RCT(299)*V(353)*V(366)
  A(300) = RCT(300)*V(353)*V(376)
  A(301) = RCT(301)*V(353)*V(375)
  A(302) = RCT(302)*V(353)*V(365)
  A(303) = RCT(303)*V(353)*V(377)
  A(304) = RCT(304)*V(353)*V(377)
  A(305) = RCT(305)*V(317)*V(366)
  A(306) = RCT(306)*V(317)*V(376)
  A(307) = RCT(307)*V(317)*V(375)
  A(308) = RCT(308)*V(317)*V(365)
  A(309) = RCT(309)*V(317)*V(377)
  A(310) = RCT(310)*V(320)*V(366)
  A(311) = RCT(311)*V(320)*V(376)
  A(312) = RCT(312)*V(320)*V(375)
  A(313) = RCT(313)*V(320)*V(365)
  A(314) = RCT(314)*V(320)*V(377)
  A(315) = RCT(315)*V(322)*V(366)
  A(316) = RCT(316)*V(322)*V(376)
  A(317) = RCT(317)*V(322)*V(375)
  A(318) = RCT(318)*V(322)*V(365)
  A(319) = RCT(319)*V(322)*V(377)
  A(320) = RCT(320)*V(322)*V(377)
  A(321) = RCT(321)*V(329)*V(366)
  A(322) = RCT(322)*V(329)*V(376)
  A(323) = RCT(323)*V(329)*V(375)
  A(324) = RCT(324)*V(329)*V(365)
  A(325) = RCT(325)*V(329)*V(377)
  A(326) = RCT(326)*V(329)*V(377)
  A(327) = RCT(327)*V(315)*V(366)
  A(328) = RCT(328)*V(315)*V(376)
  A(329) = RCT(329)*V(315)*V(375)
  A(330) = RCT(330)*V(315)*V(365)
  A(331) = RCT(331)*V(315)*V(377)
  A(332) = RCT(332)*V(315)*V(377)
  A(333) = RCT(333)*V(372)*V(377)
  A(334) = RCT(334)*V(372)*F(4)
  A(335) = RCT(335)*V(372)*F(5)
  A(336) = RCT(336)*V(372)*F(2)
  A(337) = RCT(337)*V(248)*V(372)
  A(338) = RCT(338)*V(248)*V(372)
  A(339) = RCT(339)*V(316)*V(372)
  A(340) = RCT(340)*V(316)*V(372)
  A(341) = RCT(341)*V(316)*V(372)
  A(342) = RCT(342)*V(369)*F(5)
  A(343) = RCT(343)*V(369)*V(373)
  A(344) = RCT(344)*V(368)*F(2)
  A(345) = RCT(345)*V(368)*V(369)
  A(346) = RCT(346)*V(369)*V(374)
  A(347) = RCT(347)*V(372)*V(373)
  A(348) = RCT(348)*V(372)*V(373)
  A(349) = RCT(349)*V(249)*V(369)
  A(350) = RCT(350)*V(249)*V(368)
  A(351) = RCT(351)*V(369)*V(375)
  A(352) = RCT(352)*V(369)*V(379)
  A(353) = RCT(353)*V(369)*V(376)
  A(354) = RCT(354)*V(369)*V(375)
  A(355) = RCT(355)*V(330)*V(369)
  A(356) = RCT(356)*V(303)*F(5)
  A(357) = RCT(357)*V(303)*V(373)
  A(358) = RCT(358)*V(303)*V(374)
  A(359) = RCT(359)*V(303)*V(374)
  A(360) = RCT(360)*V(303)*V(374)
  A(361) = RCT(361)*V(251)*F(5)
  A(362) = RCT(362)*V(251)*V(376)
  A(363) = RCT(363)*V(251)*V(375)
  A(364) = RCT(364)*V(357)*V(369)
  A(365) = RCT(365)*V(369)*V(378)
  A(366) = RCT(366)*V(370)*V(372)
  A(367) = RCT(367)*V(371)*V(372)
  A(368) = RCT(368)*V(307)*V(372)
  A(369) = RCT(369)*V(238)*V(372)
  A(370) = RCT(370)*V(271)*V(372)
  A(371) = RCT(371)*V(256)*V(372)
  A(372) = RCT(372)*V(255)*V(372)
  A(373) = RCT(373)*V(260)*V(372)
  A(374) = RCT(374)*V(239)*V(372)
  A(375) = RCT(375)*V(240)*V(372)
  A(376) = RCT(376)*V(247)*V(372)
  A(377) = RCT(377)*V(244)*V(372)
  A(378) = RCT(378)*V(262)*V(372)
  A(379) = RCT(379)*V(263)*V(372)
  A(380) = RCT(380)*V(261)*V(372)
  A(381) = RCT(381)*V(241)*V(372)
  A(382) = RCT(382)*V(242)*V(372)
  A(383) = RCT(383)*V(243)*V(372)
  A(384) = RCT(384)*V(245)*V(372)
  A(385) = RCT(385)*V(307)*V(368)
  A(386) = RCT(386)*V(360)*V(380)
  A(387) = RCT(387)*V(360)*V(368)
  A(388) = RCT(388)*V(360)*V(368)
  A(389) = RCT(389)*V(258)*V(368)
  A(390) = RCT(390)*V(254)*V(368)
  A(391) = RCT(391)*V(368)*V(370)
  A(392) = RCT(392)*V(341)*V(368)
  A(393) = RCT(393)*V(259)*V(368)
  A(394) = RCT(394)*V(333)*V(368)
  A(395) = RCT(395)*V(270)*V(368)
  A(396) = RCT(396)*V(234)*V(368)
  A(397) = RCT(397)*V(260)*V(368)
  A(398) = RCT(398)*V(262)*V(368)
  A(399) = RCT(399)*V(263)*V(368)
  A(400) = RCT(400)*V(261)*V(368)
  A(401) = RCT(401)*V(316)*V(381)
  A(402) = RCT(402)*V(378)*V(381)
  A(403) = RCT(403)*V(373)*V(381)
  A(404) = RCT(404)*V(381)*F(2)
  A(405) = RCT(405)*V(330)*V(381)
  A(406) = RCT(406)*V(374)*V(381)
  A(407) = RCT(407)*V(374)*V(381)
  A(408) = RCT(408)*V(360)*V(369)
  A(409) = RCT(409)*V(360)*V(374)
  A(410) = RCT(410)*V(360)*V(376)
  A(411) = RCT(411)*V(360)*V(375)
  A(412) = RCT(412)*V(360)*V(360)
  A(413) = RCT(413)*V(360)*V(360)
  A(414) = RCT(414)*V(360)*V(360)
  A(415) = RCT(415)*V(381)*F(5)
  A(416) = RCT(416)*V(272)
  A(417) = RCT(417)*V(360)*V(360)
  A(418) = RCT(418)*V(254)
  A(419) = RCT(419)*V(272)*V(381)
  A(420) = RCT(420)*V(272)*V(381)
  A(421) = RCT(421)*V(357)*V(360)
  A(422) = RCT(422)*V(357)*V(360)
  A(423) = RCT(423)*V(357)*V(360)
  A(424) = RCT(424)*V(333)*V(369)
  A(425) = RCT(425)*V(333)*V(381)
  A(426) = RCT(426)*V(270)*V(381)
  A(427) = RCT(427)*V(292)*V(370)
  A(428) = RCT(428)*V(333)*V(377)
  A(429) = RCT(429)*V(333)*V(370)
  A(430) = RCT(430)*V(333)*V(371)
  A(431) = RCT(431)*V(302)*V(370)
  A(432) = RCT(432)*V(341)*V(370)
  A(433) = RCT(433)*V(341)*V(371)
  A(434) = RCT(434)*V(312)*V(370)
  A(435) = RCT(435)*V(373)
  A(436) = RCT(436)*V(373)
  A(437) = RCT(437)*F(5)
  A(438) = RCT(438)*V(375)
  A(439) = RCT(439)*V(330)
  A(440) = RCT(440)*V(275)
  A(441) = RCT(441)*V(378)
  A(442) = RCT(442)*V(378)
  A(443) = RCT(443)*V(340)
  A(444) = RCT(444)*V(266)
  A(445) = RCT(445)*V(273)
  A(446) = RCT(446)*V(273)
  A(447) = RCT(447)*V(379)
  A(448) = RCT(448)*V(379)
  A(449) = RCT(449)*V(292)
  A(450) = RCT(450)*V(362)
  A(451) = RCT(451)*V(362)
  A(452) = RCT(452)*V(252)
  A(453) = RCT(453)*V(358)
  A(454) = RCT(454)*V(321)
  A(455) = RCT(455)*V(321)
  A(456) = RCT(456)*V(359)
  A(457) = RCT(457)*V(342)
  A(458) = RCT(458)*V(314)
  A(459) = RCT(459)*V(314)
  A(460) = RCT(460)*V(314)
  A(461) = RCT(461)*V(350)
  A(462) = RCT(462)*V(363)
  A(463) = RCT(463)*V(363)
  A(464) = RCT(464)*V(363)
  A(465) = RCT(465)*V(361)
  A(466) = RCT(466)*V(355)
  A(467) = RCT(467)*V(294)
  A(468) = RCT(468)*V(280)
  A(469) = RCT(469)*V(265)
  A(470) = RCT(470)*V(267)
  A(471) = RCT(471)*V(268)
  A(472) = RCT(472)*V(283)
  A(473) = RCT(473)*V(279)
  A(474) = RCT(474)*V(277)
  A(475) = RCT(475)*V(287)
  A(476) = RCT(476)*V(286)
  A(477) = RCT(477)*V(295)
  A(478) = RCT(478)*V(288)
  A(479) = RCT(479)*V(291)
  A(480) = RCT(480)*V(274)
  A(481) = RCT(481)*V(356)
  A(482) = RCT(482)*V(253)
  A(483) = RCT(483)*V(327)
  A(484) = RCT(484)*V(311)
  A(485) = RCT(485)*V(296)
  A(486) = RCT(486)*V(282)
  A(487) = RCT(487)*V(357)
  A(488) = RCT(488)*V(312)
  A(489) = RCT(489)*V(302)
  A(490) = RCT(490)*V(302)
  A(491) = RCT(491)*V(235)
  A(492) = RCT(492)*V(255)
  A(493) = RCT(493)*V(257)
  A(494) = RCT(494)*V(257)
  A(495) = RCT(495)*V(309)
  A(496) = RCT(496)*V(313)
  A(497) = RCT(497)*V(284)
  A(498) = RCT(498)*V(248)
  A(499) = RCT(499)*V(249)
  A(500) = RCT(500)*V(281)
  A(501) = RCT(501)*V(376)
  A(502) = RCT(502)*V(271)
  A(503) = RCT(503)*V(276)
  A(504) = RCT(504)*V(307)
  A(505) = RCT(505)*V(360)
  A(506) = RCT(506)*V(258)
  A(507) = RCT(507)*V(254)
  A(508) = RCT(508)*V(259)
  A(509) = RCT(509)*V(333)
  A(510) = RCT(510)*V(333)
  A(511) = RCT(511)*V(341)
  A(512) = RCT(512)*V(270)
  A(513) = RCT(513)*V(234)
  A(514) = RCT(514)*V(238)
  A(515) = RCT(515)*V(239)
  A(516) = RCT(516)*V(240)
  A(517) = RCT(517)*V(241)
  A(518) = RCT(518)*V(242)
  A(519) = RCT(519)*V(243)
  A(520) = RCT(520)*V(261)
  A(521) = RCT(521)*V(262)
  A(522) = RCT(522)*V(263)
  A(523) = RCT(523)*V(260)
  A(524) = RCT(524)*V(244)
  A(525) = RCT(525)*V(247)
  A(526) = RCT(526)*V(245)
  A(527) = RCT(527)*V(256)
  A(528) = RCT(528)*V(272)

! Aggregate function
  Vdot(1) = 0.25*A(233)
  Vdot(2) = A(143)
  Vdot(3) = 0.35*A(277)
  Vdot(4) = A(12)+A(35)+A(43)+A(83)+A(90)+0.361*A(136)+0.5*A(147)+0.2*A(174)+0.2*A(175)+A(179)+2*A(182)+0.7*A(184)+2&
              &*A(185)+A(186)+A(187)+A(198)+A(204)+0.93*A(279)+0.93*A(280)+A(288)+0.5*A(290)+A(291)+A(292)+A(350)
  Vdot(5) = A(6)
  Vdot(6) = A(10)
  Vdot(7) = A(14)
  Vdot(8) = A(24)
  Vdot(9) = A(26)
  Vdot(10) = A(43)
  Vdot(11) = A(45)
  Vdot(12) = A(48)
  Vdot(13) = A(49)
  Vdot(14) = A(51)
  Vdot(15) = A(52)
  Vdot(16) = A(53)
  Vdot(17) = A(54)
  Vdot(18) = A(55)
  Vdot(19) = A(56)
  Vdot(20) = A(58)
  Vdot(21) = A(59)
  Vdot(22) = A(61)
  Vdot(23) = A(62)
  Vdot(24) = A(63)
  Vdot(25) = A(67)
  Vdot(26) = A(71)
  Vdot(27) = A(73)
  Vdot(28) = A(80)
  Vdot(29) = A(89)
  Vdot(30) = A(90)
  Vdot(31) = A(129)
  Vdot(32) = A(130)
  Vdot(33) = A(131)
  Vdot(34) = A(175)
  Vdot(35) = A(187)
  Vdot(36) = A(188)
  Vdot(37) = A(244)
  Vdot(38) = A(265)
  Vdot(39) = A(266)
  Vdot(40) = A(270)
  Vdot(41) = A(271)
  Vdot(42) = A(272)
  Vdot(43) = A(273)
  Vdot(44) = A(274)
  Vdot(45) = A(275)
  Vdot(46) = A(277)
  Vdot(47) = A(279)
  Vdot(48) = A(280)
  Vdot(49) = A(282)
  Vdot(50) = A(284)
  Vdot(51) = A(285)
  Vdot(52) = A(288)
  Vdot(53) = A(289)
  Vdot(54) = A(294)
  Vdot(55) = A(295)
  Vdot(56) = A(300)
  Vdot(57) = A(301)
  Vdot(58) = A(306)
  Vdot(59) = A(307)
  Vdot(60) = A(311)
  Vdot(61) = A(312)
  Vdot(62) = A(316)
  Vdot(63) = A(317)
  Vdot(64) = A(322)
  Vdot(65) = A(323)
  Vdot(66) = A(328)
  Vdot(67) = A(329)
  Vdot(68) = A(359)
  Vdot(69) = A(361)
  Vdot(70) = A(362)
  Vdot(71) = A(385)
  Vdot(72) = A(393)
  Vdot(73) = A(394)
  Vdot(74) = A(407)
  Vdot(75) = A(420)
  Vdot(76) = A(437)
  Vdot(77) = A(445)
  Vdot(78) = A(452)
  Vdot(79) = A(493)
  Vdot(80) = A(498)
  Vdot(81) = A(501)
  Vdot(82) = A(2)
  Vdot(83) = A(3)
  Vdot(84) = A(5)
  Vdot(85) = A(30)
  Vdot(86) = A(32)
  Vdot(87) = A(37)
  Vdot(88) = A(38)
  Vdot(89) = A(40)
  Vdot(90) = A(64)
  Vdot(91) = A(65)
  Vdot(92) = A(66)
  Vdot(93) = A(68)
  Vdot(94) = A(69)
  Vdot(95) = A(74)
  Vdot(96) = A(76)
  Vdot(97) = A(78)
  Vdot(98) = A(81)
  Vdot(99) = A(91)
  Vdot(100) = A(108)
  Vdot(101) = A(133)
  Vdot(102) = A(138)
  Vdot(103) = A(141)
  Vdot(104) = A(142)
  Vdot(105) = A(152)
  Vdot(106) = A(153)
  Vdot(107) = A(154)
  Vdot(108) = A(155)
  Vdot(109) = A(156)
  Vdot(110) = A(157)
  Vdot(111) = A(190)
  Vdot(112) = A(191)
  Vdot(113) = A(223)
  Vdot(114) = A(226)
  Vdot(115) = A(227)
  Vdot(116) = A(229)
  Vdot(117) = A(230)
  Vdot(118) = A(231)
  Vdot(119) = A(234)
  Vdot(120) = A(240)
  Vdot(121) = A(241)
  Vdot(122) = A(245)
  Vdot(123) = A(246)
  Vdot(124) = A(247)
  Vdot(125) = A(260)
  Vdot(126) = A(262)
  Vdot(127) = A(268)
  Vdot(128) = A(269)
  Vdot(129) = A(276)
  Vdot(130) = A(281)
  Vdot(131) = A(291)
  Vdot(132) = A(333)
  Vdot(133) = A(336)
  Vdot(134) = A(337)
  Vdot(135) = A(338)
  Vdot(136) = A(339)
  Vdot(137) = A(340)
  Vdot(138) = A(341)
  Vdot(139) = A(343)
  Vdot(140) = A(345)
  Vdot(141) = A(346)
  Vdot(142) = A(347)
  Vdot(143) = A(349)
  Vdot(144) = A(351)
  Vdot(145) = A(352)
  Vdot(146) = A(355)
  Vdot(147) = A(357)
  Vdot(148) = A(364)
  Vdot(149) = A(365)
  Vdot(150) = A(366)
  Vdot(151) = A(367)
  Vdot(152) = A(370)
  Vdot(153) = A(373)
  Vdot(154) = A(386)
  Vdot(155) = A(387)
  Vdot(156) = A(388)
  Vdot(157) = A(389)
  Vdot(158) = A(390)
  Vdot(159) = A(408)
  Vdot(160) = A(412)
  Vdot(161) = A(413)
  Vdot(162) = A(422)
  Vdot(163) = A(423)
  Vdot(164) = A(427)
  Vdot(165) = A(429)
  Vdot(166) = A(430)
  Vdot(167) = A(431)
  Vdot(168) = A(432)
  Vdot(169) = A(433)
  Vdot(170) = A(434)
  Vdot(171) = A(448)
  Vdot(172) = A(488)
  Vdot(173) = A(507)
  Vdot(174) = A(511)
  Vdot(175) = A(22)
  Vdot(176) = A(39)
  Vdot(177) = A(60)
  Vdot(178) = A(102)
  Vdot(179) = A(115)
  Vdot(180) = A(117)
  Vdot(181) = A(118)
  Vdot(182) = A(134)
  Vdot(183) = A(136)
  Vdot(184) = A(137)
  Vdot(185) = A(139)
  Vdot(186) = A(140)
  Vdot(187) = A(147)
  Vdot(188) = A(174)
  Vdot(189) = A(199)
  Vdot(190) = A(201)
  Vdot(191) = A(204)
  Vdot(192) = A(249)
  Vdot(193) = A(250)
  Vdot(194) = A(251)
  Vdot(195) = A(252)
  Vdot(196) = A(253)
  Vdot(197) = A(283)
  Vdot(198) = A(402)
  Vdot(199) = A(426)
  Vdot(200) = A(441)
  Vdot(201) = A(442)
  Vdot(202) = A(450)
  Vdot(203) = A(451)
  Vdot(204) = A(453)
  Vdot(205) = A(455)
  Vdot(206) = A(457)
  Vdot(207) = A(458)
  Vdot(208) = A(459)
  Vdot(209) = A(460)
  Vdot(210) = A(461)
  Vdot(211) = A(462)
  Vdot(212) = A(463)
  Vdot(213) = A(465)
  Vdot(214) = A(476)
  Vdot(215) = A(479)
  Vdot(216) = A(483)
  Vdot(217) = A(496)
  Vdot(218) = A(499)
  Vdot(219) = A(12)
  Vdot(220) = A(299)
  Vdot(221) = A(305)
  Vdot(222) = A(310)
  Vdot(223) = A(315)
  Vdot(224) = A(321)
  Vdot(225) = A(327)
  Vdot(226) = A(235)
  Vdot(227) = A(296)
  Vdot(228) = A(302)
  Vdot(229) = A(308)
  Vdot(230) = A(313)
  Vdot(231) = A(318)
  Vdot(232) = A(324)
  Vdot(233) = A(330)
  Vdot(234) = -A(396)-A(513)
  Vdot(235) = A(254)-A(491)
  Vdot(236) = A(172)-A(173)
  Vdot(237) = A(281)-A(282)
  Vdot(238) = -0.86*A(369)-A(514)
  Vdot(239) = -0.88*A(374)-A(515)
  Vdot(240) = -0.86*A(375)-A(516)
  Vdot(241) = -0.75*A(381)-A(517)
  Vdot(242) = -0.75*A(382)-A(518)
  Vdot(243) = -0.3*A(383)-A(519)
  Vdot(244) = -0.41*A(377)-A(524)
  Vdot(245) = -0.75*A(384)-A(526)
  Vdot(246) = A(85)-A(86)
  Vdot(247) = -0.64*A(376)-A(525)
  Vdot(248) = -A(337)-A(338)+A(363)-A(498)
  Vdot(249) = -A(349)-A(350)-A(499)
  Vdot(250) = -A(50)-A(81)
  Vdot(251) = -A(361)-A(362)-A(363)+A(501)
  Vdot(252) = A(41)-A(42)-A(452)
  Vdot(253) = 0.41*A(129)-A(189)-A(482)
  Vdot(254) = -A(390)+A(417)-A(418)-A(507)
  Vdot(255) = -A(256)-0.68*A(372)-A(492)
  Vdot(256) = -A(257)-0.95*A(371)-A(527)
  Vdot(257) = A(224)-A(225)-A(493)-A(494)
  Vdot(258) = -A(389)+A(414)+A(421)-A(506)
  Vdot(259) = -A(393)+A(427)-A(508)
  Vdot(260) = -0.72*A(373)-A(397)-A(523)
  Vdot(261) = -0.79*A(380)-A(400)-A(520)
  Vdot(262) = -0.69*A(378)-A(398)-A(521)
  Vdot(263) = -0.74*A(379)-A(399)-A(522)
  Vdot(264) = -A(46)-A(47)-A(253)
  Vdot(265) = A(126)-A(165)-A(469)
  Vdot(266) = A(25)-A(26)+0.5*A(229)-A(444)
  Vdot(267) = A(127)-A(166)-A(470)
  Vdot(268) = A(103)-A(167)-A(471)
  Vdot(269) = -A(232)-A(233)-A(234)
  Vdot(270) = -A(395)-A(426)-A(512)
  Vdot(271) = -A(258)-A(370)-A(502)
  Vdot(272) = A(386)+A(390)+A(413)+A(415)-A(416)-A(419)-A(420)+A(422)+A(507)-A(528)
  Vdot(273) = A(27)-A(28)-A(29)-A(445)-A(446)
  Vdot(274) = 0.41*A(131)-A(180)-A(181)-A(480)
  Vdot(275) = A(15)-A(18)-A(19)-A(440)
  Vdot(276) = A(423)+A(430)+A(431)+A(433)+A(434)-A(503)
  Vdot(277) = 0.75*A(69)+0.41*A(130)-A(169)-A(474)
  Vdot(278) = 0.5*A(227)+0.13*A(270)+0.065*A(272)-A(292)
  Vdot(279) = A(128)-A(170)-A(473)
  Vdot(280) = A(105)-A(164)-A(468)
  Vdot(281) = A(235)+A(296)+A(302)+A(308)+A(313)+A(318)+A(324)+A(330)-A(500)
  Vdot(282) = A(241)+A(243)-A(244)+0.5*A(260)+0.5*A(261)+0.5*A(262)+0.5*A(263)-A(486)
  Vdot(283) = A(95)-A(168)+0.85*A(286)+0.5*A(290)-A(472)
  Vdot(284) = -A(20)-A(21)+0.85*A(97)+0.85*A(98)-A(497)
  Vdot(285) = -A(44)-A(190)-A(252)
  Vdot(286) = -A(176)+0.1*A(267)-A(476)
  Vdot(287) = 0.88*A(99)-A(171)-A(172)-A(475)
  Vdot(288) = 0.1*A(100)-A(177)-A(478)
  Vdot(289) = 0.17*A(199)+0.17*A(265)-A(287)-A(291)
  Vdot(290) = 0.654*A(176)+0.29*A(199)+0.29*A(265)-A(283)
  Vdot(291) = A(101)-A(178)-A(179)+A(303)-A(479)
  Vdot(292) = A(33)-A(34)-A(231)-A(427)-A(449)
  Vdot(293) = -A(35)+0.134*A(136)+A(137)+0.5*A(147)+0.074*A(174)+0.074*A(175)+0.31*A(270)+0.155*A(272)+0.65*A(277)+0.07&
                &*A(279)+0.07*A(280)+A(298)
  Vdot(294) = A(72)+A(77)+A(104)-A(162)-A(163)-A(467)
  Vdot(295) = 0.85*A(102)+0.5*A(272)+0.5*A(275)-A(276)-A(477)
  Vdot(296) = 0.047*A(56)-A(226)-A(269)-A(485)
  Vdot(297) = A(287)-A(288)-A(289)-A(290)
  Vdot(298) = 0.25*A(93)+0.25*A(94)+0.25*A(109)+0.25*A(110)+0.25*A(112)+0.24*A(113)+0.48*A(114)+0.25*A(115)+0.25*A(116)&
                &+0.15*A(117)+0.25*A(119)+0.25*A(121)-A(123)+0.3*A(184)
  Vdot(299) = A(173)-A(174)-A(175)
  Vdot(300) = 0.1*A(56)+0.113*A(198)-A(284)-A(285)-A(286)
  Vdot(301) = A(68)+A(87)-A(88)-A(134)-A(135)
  Vdot(302) = -A(243)+A(255)-A(259)-A(431)-A(489)-A(490)
  Vdot(303) = A(336)+A(341)+A(344)+A(345)-A(356)-A(357)-A(358)-A(359)-A(360)+0.24*A(366)+0.15*A(367)+A(404)+A(441)
  Vdot(304) = A(278)-A(279)-A(280)-A(281)+A(282)
  Vdot(305) = -A(143)-A(152)-A(155)
  Vdot(306) = -A(132)-A(133)-A(138)+0.128*A(152)+A(462)
  Vdot(307) = -0.75*A(368)-A(385)+A(412)+A(419)+A(425)+A(429)+A(432)-A(504)
  Vdot(308) = 0.655*A(75)-A(76)-A(77)-A(78)
  Vdot(309) = 0.07*A(56)+0.5*A(79)+0.25*A(120)-A(227)-A(268)-A(495)
  Vdot(310) = 0.4*A(65)-A(70)-A(71)-A(72)-A(73)
  Vdot(311) = 0.12*A(58)+0.61*A(226)+0.14*A(273)+0.07*A(275)-A(277)-A(484)
  Vdot(312) = A(237)+A(244)-A(245)+A(259)-A(260)-A(262)-A(434)-A(488)
  Vdot(313) = 0.5*A(61)+0.075*A(102)+0.375*A(118)+0.791*A(164)+0.5*A(204)+0.5*A(227)+0.15*A(270)+0.075*A(272)-A(293)&
                &-A(496)
  Vdot(314) = 0.5*A(57)+A(70)+0.94*A(71)+0.7*A(73)+0.7*A(74)+0.919*A(76)+0.7*A(78)+0.134*A(136)-A(139)-A(141)+0.275&
                &*A(174)+0.275*A(175)+0.216*A(199)+0.216*A(265)+0.48*A(284)+0.072*A(286)-A(458)-A(459)-A(460)
  Vdot(315) = 0.055*A(191)-A(327)-A(328)-A(329)-A(330)-A(331)-A(332)
  Vdot(316) = -A(13)+0.1*A(133)-A(339)-A(340)-A(341)-A(401)+A(451)
  Vdot(317) = 0.044*A(152)-A(305)-A(306)-A(307)-A(308)-A(309)
  Vdot(318) = A(181)-A(182)-A(183)-A(184)-2*A(185)-A(186)-A(187)-A(188)
  Vdot(319) = A(47)-A(48)+0.05*A(51)-A(93)+0.03*A(109)-A(127)-A(148)-A(150)+0.36*A(166)+0.05*A(195)+A(253)+0.05*A(481)
  Vdot(320) = 0.022*A(154)+0.055*A(191)-A(310)-A(311)-A(312)-A(313)-A(314)
  Vdot(321) = 0.32*A(51)+A(62)-A(92)+0.16*A(109)+0.75*A(119)+0.791*A(167)+0.32*A(195)+A(202)+A(218)-A(251)-A(454)-A(455)&
                &+A(471)+0.32*A(481)
  Vdot(322) = 0.12*A(153)-A(315)-A(316)-A(317)-A(318)-A(319)-A(320)
  Vdot(323) = 0.12*A(133)+0.12*A(152)+0.12*A(153)+0.211*A(154)-A(294)-A(295)-A(296)-A(297)-A(298)
  Vdot(324) = -A(83)+0.15*A(129)+0.5*A(147)+A(150)+A(151)+A(183)+A(194)+A(207)+A(208)+A(209)+A(210)+A(211)+A(212)+A(213)&
                &+A(214)+A(215)+A(216)+A(217)+A(218)+A(220)+0.08*A(279)+0.08*A(280)+A(326)
  Vdot(325) = 0.6*A(65)-A(66)-A(67)-A(68)-A(69)+0.345*A(75)
  Vdot(326) = -A(49)-A(94)-A(128)+A(132)-A(149)-A(151)+0.209*A(170)
  Vdot(327) = 0.15*A(59)+0.39*A(226)+0.07*A(270)+0.035*A(272)+0.26*A(273)+0.13*A(275)-A(278)-A(483)
  Vdot(328) = -A(61)-A(102)-A(118)+A(156)-A(204)-A(215)
  Vdot(329) = 0.12*A(133)-A(321)-A(322)-A(323)-A(324)-A(325)-A(326)
  Vdot(330) = A(7)-A(9)+A(11)+A(297)+A(304)+A(309)+A(314)+A(320)+A(325)+A(331)-A(355)-A(405)-A(439)
  Vdot(331) = -A(80)-A(105)-A(121)+A(138)+0.209*A(164)-A(206)-A(217)
  Vdot(332) = -A(55)-A(98)+A(106)+A(108)-A(112)-A(197)-A(209)
  Vdot(333) = -A(394)+A(411)-A(424)-A(425)-A(428)-A(429)-A(430)-A(509)-A(510)
  Vdot(334) = A(46)+0.18*A(51)-A(62)-A(103)+0.09*A(109)-A(119)+0.209*A(167)+0.18*A(195)-A(202)-A(218)+0.18*A(481)
  Vdot(335) = -A(58)-A(100)-A(116)+A(144)+0.054*A(152)+0.209*A(177)-A(200)-A(212)
  Vdot(336) = -A(115)+0.346*A(176)-A(199)-A(211)+A(264)-A(265)-A(266)-A(267)
  Vdot(337) = A(44)-A(45)+0.32*A(51)+A(89)-A(107)+0.16*A(109)-2*A(124)-2*A(125)-A(126)+0.44*A(130)+A(158)+0.36*A(165)&
                &+A(190)+0.32*A(195)-A(219)-A(220)+A(221)+A(252)+A(453)+0.85*A(456)+0.32*A(481)
  Vdot(338) = A(84)-A(85)+A(86)-A(89)+A(91)-A(130)-A(158)-A(160)+A(169)-A(221)+0.15*A(456)+A(464)
  Vdot(339) = -A(59)-A(60)-A(101)-A(117)+0.47*A(145)+A(178)-A(201)-A(213)
  Vdot(340) = A(23)-A(24)+A(38)+A(40)+0.6*A(65)+A(81)+A(91)+A(108)+A(141)+A(142)+A(157)+A(188)+A(190)+0.5*A(229)+A(230)&
                &+2*A(231)+A(234)+A(259)+A(266)+A(271)+A(274)+A(285)+A(289)+A(427)+A(428)+A(429)+A(430)+A(431)-A(443)
  Vdot(341) = A(385)+A(389)+A(390)-A(392)+A(393)+A(394)+A(409)+A(428)-A(432)-A(433)-A(511)
  Vdot(342) = 0.5*A(57)+0.53*A(58)+0.578*A(100)+0.13*A(115)+0.36*A(116)-A(136)-A(137)+0.275*A(174)+0.275*A(175)+0.5&
                &*A(191)+0.234*A(199)+0.6*A(200)+0.5*A(227)+0.234*A(265)+0.9*A(267)+0.15*A(270)+0.075*A(272)+0.6*A(273)+0.3&
                &*A(275)+0.52*A(284)+0.078*A(286)+A(327)+A(328)+A(329)+A(330)+A(331)-A(457)+0.26*A(476)+0.7*A(478)+A(484)
  Vdot(343) = A(20)-A(54)+A(92)-A(97)-A(111)-A(196)-A(208)+A(251)
  Vdot(344) = -A(53)+A(82)-A(96)-A(110)-A(203)-A(214)+0.612*A(276)
  Vdot(345) = 0.7*A(63)+0.7*A(64)-A(65)-A(74)-A(75)+1.2*A(79)+0.6*A(120)+0.7*A(205)
  Vdot(346) = -A(87)+A(88)-A(90)-A(131)+0.53*A(145)+A(157)-A(159)-A(161)+A(180)-A(222)
  Vdot(347) = -A(56)-A(57)-A(99)-A(113)-2*A(114)+A(143)+0.387*A(171)-A(198)-A(210)
  Vdot(348) = -A(63)-A(64)-2*A(79)-A(104)-A(120)+A(155)+0.36*A(163)-A(205)-A(216)
  Vdot(349) = 0.123*A(56)+0.23*A(63)+0.23*A(64)+0.23*A(79)+0.3*A(113)+0.5*A(114)+0.115*A(120)+0.613*A(171)-A(191)+0.14&
                &*A(198)+0.23*A(205)-A(264)+0.29*A(475)+A(485)+A(495)
  Vdot(350) = A(21)+0.5*A(57)+0.35*A(58)+0.122*A(59)+0.5*A(61)+0.102*A(100)+0.075*A(102)+0.5*A(111)+0.29*A(115)+0.14&
                &*A(116)+0.255*A(117)+0.375*A(118)-A(140)-A(142)+A(146)+0.5*A(153)+0.88*A(154)+0.275*A(174)+0.275*A(175)+0.5&
                &*A(191)+0.234*A(199)+0.4*A(200)+0.143*A(201)+0.5*A(204)+0.234*A(265)+0.9*A(267)+0.65*A(277)+0.07*A(279)&
                &+0.07*A(280)+0.52*A(284)+0.078*A(286)+A(293)+A(310)+A(311)+A(312)+A(313)+A(314)+A(315)+A(316)+A(317)+A(318)&
                &+A(320)-A(461)+0.58*A(476)+0.3*A(478)+A(483)
  Vdot(351) = A(269)-A(273)-A(274)-A(275)+0.193*A(276)
  Vdot(352) = A(268)-A(270)-A(271)-A(272)+0.193*A(276)
  Vdot(353) = 0.066*A(152)-A(299)-A(300)-A(301)-A(302)-A(303)-A(304)
  Vdot(354) = A(50)-A(51)-A(52)+0.3*A(53)+A(81)-A(95)-A(109)+0.15*A(110)+0.209*A(168)-A(195)+0.3*A(203)-A(207)
  Vdot(355) = 0.5*A(57)+0.728*A(59)+A(60)+0.16*A(94)+0.2*A(111)+0.18*A(115)+0.595*A(117)+A(134)-A(146)-A(147)+0.65&
                &*A(151)+0.791*A(170)+0.725*A(174)+0.725*A(175)+A(179)+A(182)+0.7*A(184)+2*A(185)+A(186)+A(187)+0.216*A(199)&
                &+0.857*A(201)+0.5*A(227)+0.216*A(265)+0.44*A(270)+0.22*A(272)+0.6*A(273)+0.3*A(275)+0.85*A(279)+0.85*A(280)&
                &+0.5*A(283)+0.48*A(284)+0.072*A(286)+A(332)-A(466)+0.36*A(476)+A(479)+A(483)
  Vdot(356) = A(52)+0.04*A(54)+0.07*A(55)+A(66)+A(67)+A(70)+0.94*A(71)+0.7*A(73)+0.3*A(74)+0.934*A(76)+0.7*A(78)-A(82)&
                &+A(96)+0.25*A(118)+0.64*A(163)-A(481)
  Vdot(357) = A(236)-A(237)-2*A(240)-2*A(241)-A(242)+A(245)-A(247)+A(248)-A(255)-A(364)+0.15*A(367)+0.44*A(370)+0.95&
                &*A(371)+0.68*A(372)+0.31*A(376)+0.41*A(377)+0.75*A(384)-A(421)-A(422)-A(423)-A(487)+A(490)
  Vdot(358) = A(48)+0.13*A(51)+0.57*A(53)-A(84)-A(91)+0.75*A(93)+0.09*A(94)+0.033*A(100)+0.07*A(109)+0.54*A(110)+0.25&
                &*A(121)+A(123)+A(148)+A(150)+0.35*A(151)+0.64*A(166)+0.791*A(168)+0.13*A(195)+0.09*A(199)+0.57*A(203)&
                &+A(214)+A(215)+A(216)+A(217)+0.09*A(265)+A(288)+0.5*A(290)-A(453)+A(467)+A(468)+A(470)+A(472)+A(477)+0.13&
                &*A(481)
  Vdot(359) = 0.19*A(51)+0.187*A(100)-A(106)-A(108)+0.35*A(109)+0.25*A(112)+0.25*A(115)+0.25*A(116)+A(162)+0.791*A(177)&
                &+A(183)+0.19*A(195)+A(207)+A(208)+A(209)+A(210)+A(211)+A(212)+A(213)+0.34*A(270)+0.17*A(272)+0.5*A(283)&
                &+A(291)-A(456)+0.19*A(481)
  Vdot(360) = 0.24*A(366)+0.75*A(368)+0.86*A(369)+0.55*A(373)+0.88*A(374)+0.86*A(375)+0.33*A(376)+0.69*A(378)+0.74&
                &*A(379)+0.79*A(380)+0.75*A(381)+0.75*A(382)+0.3*A(383)-A(386)-A(387)-A(388)+A(392)+A(403)+A(407)-A(408)&
                &-A(409)-A(410)-A(411)-2*A(412)-2*A(413)-2*A(414)-2*A(417)+2*A(418)+2*A(420)-A(421)-A(422)-A(423)+A(424)&
                &-A(505)+A(506)+A(510)
  Vdot(361) = 0.26*A(56)+0.035*A(63)+0.035*A(64)+0.035*A(79)+0.047*A(99)+0.18*A(113)+0.36*A(114)+0.018*A(120)-A(145)+0.3&
                &*A(152)-A(154)-A(156)-A(157)+0.294*A(198)+0.035*A(205)+A(299)+A(300)+A(301)+A(302)+A(304)-A(465)+0.285&
                &*A(475)
  Vdot(362) = -A(39)-A(40)+A(45)+A(49)+0.32*A(51)+0.75*A(53)+0.93*A(55)+A(80)+0.5*A(94)+0.15*A(98)+0.75*A(107)+0.16&
                &*A(109)+0.38*A(110)+0.5*A(112)+0.5*A(121)+A(122)+2*A(124)+A(125)+0.5*A(133)+A(149)+0.1*A(153)+0.64*A(165)&
                &+0.32*A(195)+A(197)+0.75*A(203)+A(206)+A(219)+A(220)-A(250)+A(321)+A(322)+A(323)+A(324)+A(325)-A(450)&
                &-A(451)+A(469)+A(473)+A(474)+0.32*A(481)
  Vdot(363) = 0.4*A(56)+0.035*A(63)+0.035*A(64)+0.035*A(79)+0.073*A(99)+0.28*A(113)+0.56*A(114)+0.018*A(120)-A(144)+0.2&
                &*A(152)-A(153)+0.453*A(198)+0.035*A(205)+A(305)+A(306)+A(307)+A(308)+A(309)-A(462)-A(463)-A(464)+0.425&
                &*A(475)
  Vdot(364) = 0.95*A(39)+A(40)-A(41)+A(42)-A(43)+0.96*A(54)+0.93*A(55)+0.53*A(58)+0.5*A(90)+0.15*A(97)+0.15*A(98)+0.578&
                &*A(100)+0.3*A(111)+0.5*A(112)+0.36*A(116)-A(129)+A(135)+A(140)+A(142)-A(148)-A(149)-A(150)-A(151)+0.158&
                &*A(152)+0.28*A(153)+0.099*A(154)+A(159)-A(182)-A(183)+A(189)+0.445*A(191)-2*A(192)-A(193)-A(194)-A(195)&
                &-A(198)-A(199)-0.4*A(200)-A(201)-A(202)-A(203)-A(204)-A(205)-A(206)-A(207)-A(208)-A(209)-A(210)-A(211)&
                &-A(212)-A(213)-A(214)-A(215)-A(216)-A(217)-A(218)-A(219)-A(220)-A(221)+A(250)+A(319)+0.12*A(450)+0.7*A(452)&
                &+A(454)+0.85*A(456)+A(461)+A(463)+A(465)+A(466)+0.7*A(478)+A(480)+A(484)+A(497)
  Vdot(365) = A(232)+0.75*A(233)+A(234)-A(235)-A(296)-A(302)-A(308)-A(313)-A(318)-A(324)-A(330)+A(349)+A(350)+A(499)&
                &+A(500)
  Vdot(366) = -A(12)+A(22)+A(38)+0.05*A(39)+0.728*A(59)+A(60)+0.5*A(61)+A(66)+A(67)+0.5*A(90)+0.075*A(102)+0.33*A(115)&
                &+0.595*A(117)+0.375*A(118)+0.39*A(131)+0.56*A(133)+A(134)+0.505*A(136)+A(137)+2*A(139)+A(140)+2*A(141)&
                &+A(142)+0.5*A(147)+0.512*A(152)+0.56*A(153)+0.767*A(154)+0.251*A(174)+0.251*A(175)+0.89*A(191)+0.09*A(199)&
                &+0.857*A(201)+0.5*A(204)+A(249)+A(250)+A(251)+A(252)+A(253)+0.09*A(265)+1.5*A(283)-A(299)-A(305)-A(310)&
                &-A(315)-A(321)-A(327)+A(349)+A(365)+A(402)+A(426)+A(441)+A(442)+0.88*A(450)+A(451)+A(453)+A(455)+A(457)+2&
                &*A(458)+2*A(459)+A(460)+A(461)+A(462)+A(463)+A(465)+0.67*A(476)+0.5*A(479)+0.5*A(483)+A(496)+A(499)
  Vdot(367) = -A(236)-A(238)+A(239)+2*A(240)+A(242)-A(243)+A(244)+A(246)+A(247)-A(248)-A(249)-A(250)-A(251)-A(252)&
                &-A(253)-A(254)+3*A(256)+2*A(257)+A(258)+A(364)+0.65*A(367)+0.56*A(370)+0.95*A(371)+1.36*A(372)+0.33*A(376)&
                &+0.75*A(384)+A(421)+A(422)+2*A(486)+A(487)+A(488)+A(489)+A(491)+3*A(492)+A(502)+A(503)+A(524)+A(525)+2&
                &*A(526)+2*A(527)
  Vdot(368) = -A(2)+A(3)-2*A(6)-2*A(7)-A(8)-A(9)+A(10)-A(12)-A(13)-A(18)-A(20)-A(22)-A(23)-A(24)-A(25)-A(26)-A(29)+A(30)&
                &-A(32)-A(35)-A(36)-A(39)-A(44)-A(46)-A(47)-A(50)+A(57)+A(60)+0.5*A(61)-A(75)-A(82)-A(83)-A(84)-A(92)+0.15&
                &*A(97)+0.15*A(98)+0.12*A(99)+0.68*A(100)+0.15*A(102)-A(106)-A(122)-A(123)+0.44*A(129)+0.44*A(130)+0.44&
                &*A(131)-A(132)+0.36*A(133)-A(134)-0.773*A(136)-A(139)-A(140)-A(143)-A(144)-A(145)-A(146)+0.315*A(152)+0.36&
                &*A(153)+0.415*A(154)-0.36*A(163)-0.209*A(164)-0.36*A(165)-0.36*A(166)-0.209*A(167)-0.209*A(168)-A(169)&
                &-0.209*A(170)-0.387*A(171)-A(173)+1.125*A(174)+0.125*A(175)-0.346*A(176)-0.209*A(177)-A(178)-A(180)-A(181)&
                &+A(182)+0.7*A(184)+2*A(185)+2*A(186)+A(187)-A(189)+0.89*A(191)+0.27*A(226)+0.27*A(227)-A(232)-A(233)-A(235)&
                &-A(239)-A(244)+A(245)+A(246)-A(247)-A(256)-A(257)-A(258)-A(264)+0.9*A(267)-A(268)-A(269)+0.5*A(272)+0.5&
                &*A(275)-0.388*A(276)-A(277)-A(278)+A(280)-A(283)+0.15*A(286)-A(287)+0.5*A(290)+A(291)-A(292)-A(293)+2&
                &*A(333)+A(336)+A(339)-A(344)-A(345)+A(346)-A(350)+A(355)+A(357)+2*A(358)+A(365)+0.67*A(366)+0.65*A(367)&
                &-A(385)-A(387)-A(388)-A(389)-A(390)-A(391)-A(392)-A(393)-A(394)-A(395)-A(396)-A(397)-A(398)-A(399)-A(400)&
                &+A(407)+2*A(439)+A(440)+A(443)+A(444)+A(445)+0.07*A(457)+A(467)+A(468)+A(469)+A(470)+A(471)+A(472)+A(473)&
                &+A(474)+A(475)+A(476)+A(477)+A(478)+A(479)+A(480)+A(482)+A(488)+A(497)+2*A(500)+A(511)
  Vdot(369) = A(6)-A(245)-A(246)+A(334)+A(335)-A(342)-A(343)-A(345)-A(346)+2*A(348)-A(349)-A(351)-A(352)-A(353)-A(354)&
                &-A(355)+A(359)+A(361)+A(362)+A(363)-A(364)-A(365)+0.09*A(366)+0.2*A(367)+0.25*A(368)+0.14*A(369)+0.05&
                &*A(371)+0.32*A(372)+0.28*A(373)+0.12*A(374)+0.14*A(375)+0.36*A(376)+0.59*A(377)+0.31*A(378)+0.26*A(379)&
                &+0.21*A(380)+0.25*A(381)+0.25*A(382)+0.7*A(383)+0.25*A(384)-A(408)-A(424)+A(435)+2*A(437)+A(438)+A(447)&
                &+A(487)+A(501)+A(505)+A(506)
  Vdot(370) = -0.91*A(366)+A(388)-A(391)+A(401)+A(402)+A(404)+A(405)+A(406)+2*A(426)-A(427)-A(429)-A(431)-A(432)-A(434)
  Vdot(371) = A(238)-A(239)-A(246)+A(249)+A(250)+A(251)+A(252)+A(253)-A(261)-A(263)-0.8*A(367)-A(430)-A(433)
  Vdot(372) = -A(333)-A(334)-A(335)-A(336)-A(337)-A(338)-A(339)-A(340)-A(341)-A(347)-A(348)-A(366)-A(367)-A(368)-A(369)&
                &-A(370)-A(371)-A(372)-A(373)-A(374)-A(375)-A(376)-A(377)-A(378)-A(379)-A(380)-A(381)-A(382)-A(383)-A(384)&
                &+A(436)+A(498)
  Vdot(373) = -A(1)-A(2)-A(3)-A(4)-A(5)+0.25*A(69)-A(74)+0.15*A(129)+0.15*A(130)+0.15*A(131)-A(133)-A(135)-A(152)-A(153)&
                &-A(154)-A(191)-A(226)-A(227)-A(236)-A(291)+A(342)-A(343)-A(347)-A(348)-A(357)-A(403)-A(435)-A(436)
  Vdot(374) = A(2)-A(3)+A(5)-A(8)+A(9)-A(10)-2*A(11)+A(12)+A(14)-A(15)+2*A(17)+A(22)-A(27)+A(28)-A(30)+A(32)+A(35)+A(36)&
                &+A(38)+0.05*A(39)+A(45)+A(48)+A(49)+0.27*A(51)+0.783*A(56)+2*A(57)+0.35*A(58)+0.85*A(59)+A(62)+0.8*A(63)&
                &+0.8*A(64)+A(66)+A(67)-A(69)-A(72)+0.5*A(73)+0.5*A(74)+0.934*A(76)-A(77)+1.2*A(78)+0.8*A(79)+A(93)+A(94)&
                &-A(95)-A(96)-A(97)-A(98)-0.88*A(99)-0.898*A(100)-A(101)-0.925*A(102)-A(103)-A(104)-A(105)+A(107)+0.64&
                &*A(109)+0.5*A(110)+0.3*A(111)+0.5*A(112)+1.1*A(113)+1.28*A(114)+A(115)+0.64*A(116)+1.7*A(117)+0.375*A(118)&
                &+A(119)+0.9*A(120)+0.5*A(121)+A(122)+A(123)+2*A(124)-A(126)-A(127)-A(128)-A(129)-A(130)-A(131)+0.28*A(133)&
                &+0.773*A(136)+A(139)+A(141)+A(146)+A(148)+A(149)+0.308*A(152)+0.28*A(153)+0.317*A(154)+A(158)+A(159)-0.175&
                &*A(174)+0.825*A(175)+0.7*A(184)-A(186)+0.445*A(191)+A(193)+0.27*A(195)+0.887*A(198)+A(199)+0.4*A(200)+0.85&
                &*A(201)+A(202)+0.5*A(204)+0.8*A(205)+A(219)-A(228)+A(235)-A(237)-A(238)+A(247)+A(249)+A(258)+A(265)-0.1&
                &*A(267)+0.35*A(270)-0.825*A(272)+0.4*A(273)-0.8*A(275)-A(280)+A(283)+A(284)-0.85*A(286)+A(288)-0.5*A(290)&
                &+A(291)+A(341)-A(346)+A(355)+A(356)-A(358)-A(359)-A(360)+A(365)+A(386)+A(387)+A(395)+A(402)+A(405)-A(406)&
                &-A(407)-A(409)+A(426)+A(440)+A(441)+A(446)+A(450)+A(453)+1.73*A(457)+2*A(458)+A(461)+A(463)+A(465)+A(466)&
                &+A(467)+A(468)+A(469)+A(470)+A(471)+A(472)+A(473)+A(474)+A(475)+A(476)+A(477)+0.3*A(478)+A(479)+0.27*A(481)&
                &+A(483)+A(485)+A(493)+A(495)
  Vdot(375) = A(1)-A(4)+A(10)+A(14)-A(23)+A(26)-A(27)+A(28)+A(29)+A(30)+2*A(31)+A(32)-A(33)+A(34)-A(41)+A(42)+A(43)&
                &+A(45)+A(48)+A(49)+A(51)+2*A(53)+0.96*A(54)+0.93*A(55)+0.883*A(56)+0.88*A(58)+0.85*A(59)+1.5*A(61)+A(62)&
                &+1.3*A(63)+1.3*A(64)+A(66)+A(67)-A(68)+2*A(70)+1.88*A(71)+0.7*A(73)+0.7*A(74)+0.3*A(79)+2*A(80)-A(85)+A(86)&
                &-A(87)+A(88)+A(89)+A(90)+0.075*A(102)+A(110)+0.375*A(118)+0.15*A(120)+A(121)+A(134)+A(162)+A(175)+A(187)&
                &+A(203)+0.5*A(204)+0.3*A(205)+A(206)+A(214)+A(215)+A(216)+A(217)+2*A(223)-A(224)+A(225)-A(229)+A(242)&
                &+A(248)-A(254)-A(255)+A(265)+1.34*A(270)+0.17*A(272)+1.6*A(273)+0.3*A(275)+1.85*A(279)+0.85*A(280)-A(281)&
                &+A(282)+A(284)+A(288)+A(292)+A(293)+A(294)-A(295)+A(300)-A(301)+A(306)-A(307)+A(311)-A(312)+A(316)-A(317)&
                &+A(322)-A(323)+A(328)-A(329)-A(351)+A(352)+A(353)-A(354)-A(363)+A(393)+A(410)-A(411)-A(438)+A(443)+A(446)&
                &+A(447)+A(449)+0.7*A(452)+A(467)+A(468)+A(477)+A(481)+A(483)+A(484)+A(485)+A(490)+A(491)+A(494)+A(495)&
                &+A(496)+A(508)+A(510)
  Vdot(376) = -A(1)-A(10)-A(14)-A(25)-A(31)+A(37)-A(43)-A(45)-A(48)-A(49)-A(51)-A(52)-A(53)-A(54)-A(55)-A(56)-A(58)&
                &-A(59)-A(61)-A(62)-A(63)-A(67)-A(71)-A(76)-A(80)-A(89)-A(90)-A(175)-A(187)-A(188)-A(242)-A(265)-A(266)&
                &-A(270)-A(271)-A(273)-A(274)-A(279)-A(284)-A(285)-A(288)-A(289)-A(294)-A(300)-A(306)-A(311)-A(316)-A(322)&
                &-A(328)+2*A(338)+A(351)-A(353)+A(361)-A(362)-A(410)+A(438)+A(444)+A(448)-A(501)
  Vdot(377) = A(6)+A(8)+A(9)+A(13)+A(18)+A(19)+A(20)+A(21)+A(22)+A(24)+A(26)+A(29)+A(35)+A(39)+A(44)+A(82)+A(83)+A(84)&
                &+A(92)+A(106)-A(231)+A(239)+A(258)-A(259)+A(260)+A(262)-A(297)-A(298)-A(303)-A(304)-A(309)-A(314)-A(319)&
                &-A(320)-A(325)-A(326)-A(331)-A(332)-A(333)+A(344)+A(359)+A(391)+A(392)+A(395)+A(396)+A(397)+A(398)+A(399)&
                &+A(400)-A(428)+A(432)+A(433)+A(434)
  Vdot(378) = A(5)+A(14)+A(16)+2*A(17)+A(19)-A(22)+A(36)-A(38)+0.05*A(39)+A(49)+0.39*A(53)+0.96*A(54)+0.66*A(56)+A(57)&
                &+0.35*A(58)+0.122*A(59)+0.5*A(61)+0.07*A(63)+0.07*A(64)+0.75*A(73)+0.75*A(74)+0.75*A(78)+0.07*A(79)+A(80)&
                &+0.5*A(90)+0.75*A(93)+1.25*A(94)+0.15*A(97)+0.12*A(99)+0.102*A(100)+0.075*A(102)+0.75*A(107)+0.75*A(109)&
                &+0.95*A(110)+0.5*A(111)+0.75*A(112)+1.22*A(113)+0.92*A(114)+0.95*A(115)+0.89*A(116)+1.255*A(117)+0.625&
                &*A(118)+0.75*A(119)+0.785*A(120)+1.25*A(121)+0.59*A(131)+0.5*A(133)+A(135)+0.732*A(136)+A(149)+0.709*A(152)&
                &+0.6*A(153)+0.12*A(154)+A(158)+2*A(159)+A(160)+A(161)+0.375*A(174)+0.375*A(175)+A(184)+0.445*A(191)+A(193)&
                &+A(194)+A(196)+0.747*A(198)+0.4*A(200)+0.143*A(201)+0.39*A(203)+0.5*A(204)+0.07*A(205)+A(206)+A(222)+A(226)&
                &+A(232)+A(234)-A(249)+0.65*A(270)+0.325*A(272)+0.4*A(273)+0.2*A(275)+0.35*A(277)+0.08*A(279)+0.08*A(280)&
                &+A(292)+A(294)+A(295)+A(296)+A(297)+A(340)+A(341)-A(365)+A(386)-A(402)+A(440)-A(441)-A(442)+0.9*A(457)&
                &+A(460)+A(463)+A(465)+A(466)+A(473)+0.71*A(475)+0.3*A(478)+0.5*A(479)+A(480)+0.5*A(483)+A(493)+A(496)&
                &+A(497)
  Vdot(379) = A(4)+A(24)-A(30)-A(31)-A(32)-A(33)+A(34)-A(37)-A(38)-A(40)-A(64)-A(65)-A(66)-A(70)-A(81)-A(91)-A(108)&
                &+A(135)-A(138)-A(141)-A(142)-A(155)-A(156)-A(157)-A(190)-2*A(223)-A(230)-A(234)+A(243)-A(248)+0.31*A(270)&
                &+0.155*A(272)+A(277)+0.15*A(279)+0.15*A(280)+A(295)+A(301)+A(307)+A(312)+A(317)+A(323)+A(329)-A(352)+A(354)&
                &+A(394)+A(424)+A(425)+A(445)-A(447)-A(448)+A(449)+0.3*A(452)+A(489)+A(493)+A(509)
  Vdot(380) = -A(5)+A(13)-A(14)-A(15)-2*A(16)-2*A(17)+A(18)+A(43)+0.18*A(51)-A(73)-A(78)+A(83)+0.5*A(90)-A(93)-A(94)&
                &-A(107)-0.91*A(109)-A(110)-A(111)-A(112)-A(113)-A(115)-A(116)-A(117)-A(118)-A(119)-A(120)-A(121)+0.44&
                &*A(129)+0.39*A(131)+0.28*A(133)+0.5*A(147)+A(148)+A(149)+0.051*A(152)-A(158)-A(159)-A(160)-A(161)+A(182)&
                &-A(184)+2*A(192)-A(194)+A(195)+A(196)+A(197)+A(198)+A(199)+A(200)+A(201)+A(202)+A(203)+A(204)+A(205)+A(206)&
                &+A(219)+A(221)+A(222)-A(224)+A(225)+A(232)+A(233)+A(234)+A(319)+A(339)+A(370)-A(386)+A(401)+0.88*A(450)+0.3&
                &*A(452)+A(454)+2*A(455)+0.15*A(456)+A(464)+0.18*A(481)+A(482)+A(494)+A(496)+A(502)+A(512)
  Vdot(381) = 0.67*A(366)+0.75*A(368)+2.58*A(369)+0.17*A(373)+1.76*A(374)+1.72*A(375)+0.31*A(376)+0.69*A(378)+0.79&
                &*A(380)+1.5*A(381)+0.75*A(382)+A(385)+A(387)+A(391)+A(395)+3*A(396)+A(397)+2*A(398)+A(399)+2*A(400)-A(401)&
                &-A(402)-A(403)-A(404)-A(405)-A(406)-A(407)+A(408)+A(410)+A(413)+A(414)-A(415)+A(416)-A(419)-A(420)-A(425)&
                &-A(426)+A(503)+2*A(504)+A(505)+A(507)+A(508)+A(509)+A(511)+A(512)+3*A(513)+4*A(514)+3*A(515)+2*A(516)+3&
                &*A(517)+2*A(518)+A(519)+2*A(520)+2*A(521)+2*A(522)+2*A(523)+A(525)+A(528)
      
END SUBROUTINE Fun

! End of Fun function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE gckpp_Function

