! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Reaction Rates File
! 
! Generated by KPP-2.2.4_gc symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : gckpp_Rates.f90
! Time                 : Wed Nov 23 10:37:15 2016
! Working directory    : /n/home05/msulprizio/GC/FlexChem/Mechanisms/SOA
! Equation file        : gckpp.kpp
! Output root filename : gckpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE gckpp_Rates

  USE gckpp_Parameters
  USE gckpp_Global
  IMPLICIT NONE

CONTAINS



! Begin Rate Law Functions from KPP_HOME/util/UserRateLaws

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  User-defined Rate Law functions
!  Note: the default argument type for rate laws, as read from the equations file, is single precision
!        but all the internal calculations are performed in double precision
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!~~~>  Arrhenius
   REAL(kind=dp) FUNCTION ARR( A0,B0,C0 )
      REAL A0,B0,C0      
      ARR =  DBLE(A0) * EXP(-DBLE(B0)/TEMP) * (TEMP/300.0_dp)**DBLE(C0)
   END FUNCTION ARR        

!~~~> Simplified Arrhenius, with two arguments
!~~~> Note: The argument B0 has a changed sign when compared to ARR
   REAL(kind=dp) FUNCTION ARR2( A0,B0 )
      REAL A0,B0           
      ARR2 =  DBLE(A0) * EXP( DBLE(B0)/TEMP )              
   END FUNCTION ARR2          

   REAL(kind=dp) FUNCTION EP2(A0,C0,A2,C2,A3,C3)
      REAL A0,C0,A2,C2,A3,C3
      REAL(kind=dp) K0,K2,K3            
      K0 = DBLE(A0) * EXP(-DBLE(C0)/TEMP)
      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
      K3 = DBLE(A3) * EXP(-DBLE(C3)/TEMP)
      K3 = K3*CFACTOR*1.0E6_dp
      EP2 = K0 + K3/(1.0_dp+K3/K2 )
   END FUNCTION EP2

   REAL(kind=dp) FUNCTION EP3(A1,C1,A2,C2) 
      REAL A1, C1, A2, C2
      REAL(kind=dp) K1, K2      
      K1 = DBLE(A1) * EXP(-DBLE(C1)/TEMP)
      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
      EP3 = K1 + K2*(1.0E6_dp*CFACTOR)
   END FUNCTION EP3 

   REAL(kind=dp) FUNCTION FALL ( A0,B0,C0,A1,B1,C1,CF)
      REAL A0,B0,C0,A1,B1,C1,CF
      REAL(kind=dp) K0, K1     
      K0 = DBLE(A0) * EXP(-DBLE(B0)/TEMP)* (TEMP/300.0_dp)**DBLE(C0)
      K1 = DBLE(A1) * EXP(-DBLE(B1)/TEMP)* (TEMP/300.0_dp)**DBLE(C1)
      K0 = K0*CFACTOR*1.0E6_dp
      K1 = K0/K1
      FALL = (K0/(1.0_dp+K1))*   &
           DBLE(CF)**(1.0_dp/(1.0_dp+(LOG10(K1))**2))
   END FUNCTION FALL

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_3rd(temp,cair,k0_300K,n,kinf_300K,m,fc)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL, INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL, INTENT(IN) :: n         ! exponent for low pressure limit
    REAL, INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL, INTENT(IN) :: m         ! exponent for high pressure limit
    REAL, INTENT(IN) :: fc        ! broadening factor (usually fc=0.6)
    REAL(kind=dp) :: zt_help, k0_T, kinf_T, k_ratio

    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    k_3rd   = k0_T/(1._dp+k_ratio)*fc**(1._dp/(1._dp+LOG10(k_ratio)**2))

  END FUNCTION k_3rd

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_arr (k_298,tdep,temp)
    ! Arrhenius function

    REAL,     INTENT(IN) :: k_298 ! k at T = 298.15K
    REAL,     INTENT(IN) :: tdep  ! temperature dependence
    REAL(kind=dp), INTENT(IN) :: temp  ! temperature

    INTRINSIC EXP

    k_arr = k_298 * EXP(tdep*(1._dp/temp-3.3540E-3_dp)) ! 1/298.15=3.3540e-3

  END FUNCTION k_arr

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  End of User-defined Rate Law functions
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! End Rate Law Functions from KPP_HOME/util/UserRateLaws


! Begin INLINED Rate Law Functions


  REAL(kind=dp) FUNCTION OH_O1D (J, H2O, TEMP, NUMDEN)
  REAL*8 J, H2O, TEMP, NUMDEN
  REAL*8 K1, K2, K3
  REAL*8 N2, O2

  N2=0.79d0
  O2=0.21d0

  K1=1.63d-10*exp(60d0/TEMP)
  K2=2.15d-11*exp(110d0/TEMP)
  K3=3.30d-11*exp(55d0/TEMP)

  OH_O1D=J*K1*H2O/(K1*H2O+K2*N2*NUMDEN+K3*O2*NUMDEN)
  END FUNCTION OH_O1D

  REAL(kind=dp) FUNCTION HO2_H2O(H2O,TEMP)
  REAL*8 TEMP, H2O
  HO2_H2O=1+1.4D-21*H2O*EXP(2200/TEMP)
  END FUNCTION HO2_H2O


  REAL(kind=dp) FUNCTION GCARR( A0,B0,C0 )
      REAL A0,B0,C0 
      GCARR =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
  END FUNCTION GCARR    

  REAL(kind=dp) FUNCTION GC_HO2NO3( A0,B0,C0,A1,B1,C1 )
      REAL A0,B0,C0,A1,B1,C1
      REAL(kind=dp) :: R0,R1
      R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
      R1 =  DBLE(A1) * EXP(DBLE(C1)/TEMP) * (300._dp/TEMP)**DBLE(B1)

      GC_HO2NO3 = (R0+R1*NUMDEN)*(1.D0+1.4E-21_dp*H2O* &
                   EXP(2200.E+0_dp/TEMP))
  END FUNCTION GC_HO2NO3    
  
  REAL(kind=dp) FUNCTION GC_TBRANCH( A0,B0,C0,A1,B1,C1 )
! Temperature Dependent Branching Ratio
      REAL A0,B0,C0,A1,B1,C1
      REAL(kind=dp) :: R0,R1
      R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
      R1 =  DBLE(A1) * EXP(DBLE(C1)/TEMP) * (300._dp/TEMP)**DBLE(B1)

      GC_TBRANCH = R0/(1.D0+R1)

  END FUNCTION GC_TBRANCH

  REAL(kind=dp) FUNCTION GC_RO2HO2( A0,B0,C0,A1,B1,C1 )
! Carbon Dependence of RO2+HO2
      REAL A0,B0,C0,A1,B1,C1
      REAL(kind=dp) :: R0,R1
      R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
      R1 =  DBLE(A1) * EXP(DBLE(C1)/TEMP) * (300._dp/TEMP)**DBLE(B1)

      GC_RO2HO2 = R0*(1E0-EXP(-0.245E0*R1))

  END FUNCTION GC_RO2HO2

  REAL(kind=dp) FUNCTION GC_DMSOH( A0,B0,C0,A1,B1,C1 )
! DMS+OH+O2
    REAL A0,B0,C0,A1,B1,C1
    REAL(kind=dp) :: R0,R1
    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    R1 =  DBLE(A1) * EXP(DBLE(C1)/TEMP) * (300._dp/TEMP)**DBLE(B1)
!    GC_DMSOH = R0/(1e0_dp+R1*0.2095e0_dp)
    GC_DMSOH = (R0*NUMDEN*0.2095e0_dp)/(1e0_dp+R1*0.2095e0_dp)
    
  END FUNCTION GC_DMSOH

  REAL(kind=dp) FUNCTION GC_GLYXNO3( A0,B0,C0 )
! ---  K = K1*([O2]+3.5D18)/(2*[O2]+3.5D18) --- HO2+2*CO branch of GLYX+OH/NO3
    REAL A0,B0,C0
    REAL(kind=dp) R0
    REAL(kind=dp) O2

    O2 = NUMDEN*0.2095e0_dp
    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    GC_GLYXNO3 = R0*(O2+3.5E+18_dp)/(2.E+0_dp*O2+3.5E+18_dp)
    
  END FUNCTION GC_GLYXNO3

  REAL(kind=dp) FUNCTION GC_OHHNO3( A0,B0,C0,A1,B1,C1,A2,B2,C2 )
! ---  OH + HNO3:   K = K0 + K3[M] / (1 + K3[M]/K2)  ------
    REAL A0,B0,C0,A1,B1,C1,A2,B2,C2
    REAL(kind=dp) R0,R1,R2
    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    R1 =  DBLE(A1) * EXP(DBLE(C1)/TEMP) * (300._dp/TEMP)**DBLE(B1)
    R2 =  NUMDEN*(DBLE(A2) * EXP(DBLE(C2)/TEMP) * (300._dp/TEMP)**DBLE(B2))
    GC_OHHNO3 = R0 + R2/(1.E0_dp + R2/R1)
    
  END FUNCTION GC_OHHNO3

  REAL(kind=dp) FUNCTION GC_GLYCOHA( A0,B0,C0 )
! 
    REAL A0,B0,C0,R0,GLYC_FRAC
    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    GLYC_FRAC=1e+0_dp-11.0729e+0_dp*EXP(-(1._dp/73._dp)*TEMP)
    IF (GLYC_FRAC<0e+0_dp) GLYC_FRAC=0e+0_dp
    GC_GLYCOHA=R0*GLYC_FRAC

  END FUNCTION GC_GLYCOHA

  REAL(kind=dp) FUNCTION GC_GLYCOHB( A0,B0,C0 )
! 
    REAL A0,B0,C0
    REAL(kind=dp) :: R0,GLYC_FRAC
    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    GLYC_FRAC=1e+0_dp-11.0729e+0_dp*EXP(-(1._dp/73._dp)*TEMP)
    IF (GLYC_FRAC<0e+0_dp) GLYC_FRAC=0e+0_dp
    GC_GLYCOHB=R0*(1e0_dp-GLYC_FRAC)
    
  END FUNCTION GC_GLYCOHB

  REAL(kind=dp) FUNCTION GC_HACOHA( A0,B0,C0 )
! 
    REAL A0,B0,C0
    REAL(kind=dp) :: R0,HAC_FRAC
    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    HAC_FRAC=1e+0_dp-23.7e+0_dp*EXP(-(1._dp/60._dp)*TEMP)
    IF (HAC_FRAC<0e+0_dp) HAC_FRAC=0e+0_dp
    GC_HACOHA=R0*HAC_FRAC

  END FUNCTION GC_HACOHA

  REAL(kind=dp) FUNCTION GC_HACOHB( A0,B0,C0 )
! 
    REAL A0,B0,C0
    REAL(kind=dp) :: R0,HAC_FRAC
    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    HAC_FRAC=1e+0_dp-23.7e+0_dp*EXP(-(1._dp/60._dp)*TEMP)
    IF (HAC_FRAC<0e+0_dp) HAC_FRAC=0e+0_dp
    GC_HACOHB=R0*(1.E0_dp-HAC_FRAC)
    
  END FUNCTION GC_HACOHB

  REAL(kind=dp) FUNCTION GC_OHCO( A0,B0,C0 )

    REAL A0,B0,C0,R0
    REAL KLO1,KLO2,KHI1,KHI2,XYRAT1,XYRAT2,BLOG1,BLOG2,FEXP1,FEXP2
    REAL KCO1,KCO2,KCO

    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    R0 = R0 * (1.E+0_dp + 0.6e+0_dp*9.871E7_dp*PRESS)

    ! new OH+CO rate from JPL2006.
    KLO1=5.9E-33_dp*(300._dp/TEMP)**(1.4E+0_dp) 
    KHI1=1.1E-12_dp*(300._dp/TEMP)**(-1.3E0_dp)
    XYRAT1=KLO1*NUMDEN/KHI1
    BLOG1=LOG10(XYRAT1)
    FEXP1=1.E+0_dp/(1.E+0_dp+BLOG1*BLOG1)
    KCO1=KLO1*NUMDEN*0.6**FEXP1/(1.e+0_dp+XYRAT1)
    KLO2=1.5E-13_dp*(300._dp/TEMP)**(-0.6E+0_dp)
    KHI2=2.1e+09_dp *(300._dp/TEMP)**(-6.1E+0_dp)
    XYRAT2=KLO2*NUMDEN/KHI2
    BLOG2=LOG10(XYRAT2)
    FEXP2=1.E+0_dp/(1.E+0_dp+BLOG2*BLOG2)
    KCO2=KLO2*0.6**FEXP2/(1.e+0_dp+XYRAT2)
    KCO=KCO1+KCO2
    GC_OHCO=KCO
    
  END FUNCTION GC_OHCO

  REAL(kind=dp) FUNCTION GC_RO2NO( B,A0,B0,C0,A1,B1,C1 )
    ! ---  K = K1*(1-FYRNO3(K2,M,T))  ---  abstraction branch of RO2+NO
    CHARACTER(*) B !Branch Toggle
    REAL A0,B0,C0,A1,B1,C1
    REAL(kind=dp) :: R0,R1
    REAL(kind=dp) :: YYYN, XXYN,  AAA,  RARB, ZZYN
    REAL(kind=dp) :: XF, ALPHA, Y300, BETA, XMINF, XM0
    REAL(kind=dp) :: FYRNO3
    Y300 = 0.826
    ALPHA= 1.94e-22
    BETA = 0.97
    XM0  = 0.
    XMINF= 8.1
    XF   = 0.411
    
    R0 =  DBLE(A0) * EXP(DBLE(C0)/TEMP) * (300._dp/TEMP)**DBLE(B0)
    R1 =  DBLE(A1) * EXP(DBLE(C1)/TEMP) * (300._dp/TEMP)**DBLE(B1)
    
    ! Initialize static variables
    
    XXYN   = ALPHA*EXP(BETA*R1)*NUMDEN*((300./TEMP)**XM0)
    YYYN   = Y300*((300./TEMP)**XMINF)
    AAA    = LOG10(XXYN/YYYN)
    ZZYN   = 1./(1.+ AAA*AAA )
    RARB   = (XXYN/(1.+ (XXYN/YYYN)))*(XF**ZZYN)
    FYRNO3 = RARB/(1. + RARB)
    IF (trim(B) .eq. 'A') THEN
       GC_RO2NO     = R0 * FYRNO3
    ELSEIF (trim(B) .eq. 'B') THEN
       GC_RO2NO     = R0 * (1.E+0_dp - FYRNO3)
    ENDIF

  END FUNCTION GC_RO2NO

  REAL(kind=dp) FUNCTION GCJPL3( k0_300, n, ki_300, m)
!  Functions given in JPL Booklet
      REAL k0_300, n, ki_300,m
      REAL k0, ki

      k0=k0_300*((TEMP/300.d0)**(-n))
      ki=ki_300*((TEMP/300.d0)**(-m))

!      GCJPL3=(k0*NUMDEN)/(1+k0*NUMDEN/ki)*0.6** &
!	((1+((LOG10(k0*NUMDEN/ki))**2d0)**-1.0d0))
      GCJPL3=(k0/(1.d0+k0/(ki/NUMDEN)))*0.6** &
        ((1+((log10(k0/(ki/NUMDEN)))**2d0)**1.0e0))
      GCJPL3=GCJPL3*NUMDEN
  END FUNCTION GCJPL3
  
  REAL(kind=dp) FUNCTION GCJPLEQ( A0,B0,C0,A1,B1,C1,A2,B2,C2,FV,FCT1,FCT2 )
 ! Function calculates the rate constant of the forward reaction
 ! calculates the equilibrium constant 
 ! Find the backwards reaction by K=kforward/kbackwards
       REAL A0,B0,C0,A1,B1,C1
       REAL(kind=dp) :: R0,R1
       REAL, OPTIONAL :: A2,B2,C2,FV,FCT1,FCT2 !If a P-dependent rxn

       ! Calculate Backwards reaction
       R0 = GCARR( A0,B0,C0 )

       ! Calculate forwards reaction
       IF (present(A2)) THEN ! P-dependent
          IF (present(B2) .and. present(C2) .and. present(FV) &
                          .and. present(FCT1) .and. present(FCT2)) THEN
	     R1 = GCJPLPR( A1,B1,C1,A2,B2,C2,FV,FCT1,FCT2)
          ELSE ! Missing params!
	     write(*,'(a)') 'GCJPLEQ: Missing parameters for P-dependent reaction.'
	     write(*,'(a)') 'GCJPLEQ: Returning zero'
	     GCJPLEQ = 0.E0
	     RETURN
	  ENDIF
       ELSE
          R1 = gcarr( A1,B1,C1 ) !Std. Arrhenius eqn.
       ENDIF

       GCJPLEQ=R1/R0
  END FUNCTION GCJPLEQ
 
  REAL(kind=dp) FUNCTION GCJPLPR(A0,B0,C0,A1,B1,C1,FV,FCT1,FCT2)
! * PRESSURE-DEPENDENT EFFECTS 
! * ADD THE THIRD BODY EFFECT FOR PRESSURE DEPENDENCE OF RATE
! * COEFFICIENTS.
! A0 B0, & C0 are the Arrhenius parameters for the lower-limit
! rate. A1, B1 & C1 are the upper-limit parameters.
! FV is the falloff curve paramter, (SEE ATKINSON ET. AL (1992)
! J. PHYS. CHEM. REF. DATA 21, P. 1145). USUALLY = 0.6 
! 
       REAL A0,B0,C0,A1,B1,C1,FV,FCT1,FCT2
       REAL FCT,XYRAT,BLOG,RLOW,RHIGH,FEXP
       
       RLOW  = GCARR( A0,B0,C0 )*NUMDEN
       RHIGH = GCARR( A1,B1,C1 )

       IF     (FCT2.NE.0.) THEN	
             FCT            = EXP(-TEMP / FCT1) + EXP(-FCT2 / TEMP) 
             XYRAT          = RLOW/RHIGH
             BLOG           = LOG10(XYRAT)
             FEXP           = 1.e+0_dp / (1.e+0_dp + BLOG * BLOG)
             GCJPLPR        = RLOW*FCT**FEXP/(1e+0_dp+XYRAT) 
       ELSEIF (FCT1.NE.0.) THEN 
             FCT            = EXP(-TEMP / FCT1)
             XYRAT          = RLOW/RHIGH
             BLOG           = LOG10(XYRAT)
             FEXP           = 1.e+0_dp / (1.e+0_dp + BLOG * BLOG)
             GCJPLPR        = RLOW*FCT**FEXP/(1e+0_dp+XYRAT)  
       ELSE
             XYRAT          = RLOW/RHIGH
             BLOG           = LOG10(XYRAT)
             FEXP           = 1.e+0_dp / (1.e+0_dp + BLOG * BLOG)
             GCJPLPR        = RLOW*FV**FEXP/(1e+0_dp+XYRAT)
       ENDIF
       

  END FUNCTION GCJPLPR
 
  REAL(kind=dp) FUNCTION GCIUPAC3(ko_300,n,ki_300,m,Fc) 
! Function calcualtes the rate constant of 3 body reaction using IUPAC 
! methology
  REAL ko_300,n,ki_300,m,Fc
  REAL ko, ki, F, NN

  ko=ko_300*((TEMP/300.e0)**n)*NUMDEN
  ki=ki_300*((TEMP/300.e0)**m)

  NN=0.75-1.27*LOG10(Fc)
  F=10.0**(LOG10(Fc)/(1.0e0+(LOG10(ko/ki)/NN)**2.0))

  GCIUPAC3=ko/(1+ko/ki)*F
  END FUNCTION GCIUPAC3


! End INLINED Rate Law Functions

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_SUN - update SUN light using TIME
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  SUBROUTINE Update_SUN()
      !USE gckpp_Parameters
      !USE gckpp_Global

    IMPLICIT NONE

    REAL(kind=dp) :: SunRise, SunSet
    REAL(kind=dp) :: Thour, Tlocal, Ttmp 
    ! PI - Value of pi
    REAL(kind=dp), PARAMETER :: PI = 3.14159265358979d0
    
    SunRise = 4.5_dp 
    SunSet  = 19.5_dp 
    Thour = TIME/3600.0_dp 
    Tlocal = Thour - (INT(Thour)/24)*24

    IF ((Tlocal>=SunRise).AND.(Tlocal<=SunSet)) THEN
       Ttmp = (2.0*Tlocal-SunRise-SunSet)/(SunSet-SunRise)
       IF (Ttmp.GT.0) THEN
          Ttmp =  Ttmp*Ttmp
       ELSE
          Ttmp = -Ttmp*Ttmp
       END IF
       SUN = ( 1.0_dp + COS(PI*Ttmp) )/2.0_dp 
    ELSE
       SUN = 0.0_dp 
    END IF

 END SUBROUTINE Update_SUN

! End of Update_SUN function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_RCONST - function to update rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_RCONST ( )




! Begin INLINED RCONST


! End INLINED RCONST

  RCONST(1) = (GCARR(3.00E-12,0.0E+00,-1500.0))
  RCONST(2) = (GCARR(1.70E-12,0.0E+00,-940.0))
  RCONST(3) = (GCARR(1.00E-14,0.0E+00,-490.0))
  RCONST(4) = (GCARR(1.20E-13,0.0E+00,-2450.0))
  RCONST(5) = (GCARR(2.90E-16,0.0E+00,-1000.0))
  RCONST(6) = (GCARR(1.80E-12,0.0E+00,0.0))
  RCONST(7) = (GCJPLPR(6.90E-31,1.0E+00,0.0,2.6E-11,0.0,0.0,0.6,0.0,0.0))
  RCONST(8) = (GCARR(4.80E-11,0.0E+00,250.0))
  RCONST(9) = (GCARR(1.80E-12,0.0E+00,0.0))
  RCONST(10) = (GCARR(3.30E-12,0.0E+00,270.0))
  RCONST(11) = (GC_HO2NO3(3.00E-13,0.0E+00,460.0,2.1E-33,0.0,920.0))
  RCONST(12) = (GCARR(2.80E-12,0.0E+00,-1800.0))
  RCONST(13) = (GC_OHCO(1.50E-13,0.0E+00,0.0))
  RCONST(14) = (GCARR(2.45E-12,0.0E+00,-1775.0))
  RCONST(15) = (GCARR(2.80E-12,0.0E+00,300.0))
  RCONST(16) = (GCARR(4.10E-13,0.0E+00,750.0))
  RCONST(17) = (GC_TBRANCH(9.50E-14,0.0E+00,390.0,2.62E1,0.0,-1130.0))
  RCONST(18) = (GC_TBRANCH(9.50E-14,0.0E+00,390.0,4.E-2,0.0,1130.0))
  RCONST(19) = (GCARR(2.66E-12,0.0E+00,200.0))
  RCONST(20) = (GCARR(1.14E-12,0.0E+00,200.0))
  RCONST(21) = (GCARR(2.66E-12,0.0E+00,200.0))
  RCONST(22) = (GCARR(1.14E-12,0.0E+00,200.0))
  RCONST(23) = (GCARR(5.50E-12,0.0E+00,125.0))
  RCONST(24) = (GCJPLPR(1.80E-30,3.0E+00,0.0,2.8E-11,0.0,0.0,0.6,0.0,0.0))
  RCONST(25) = (GC_OHHNO3(2.41E-14,0.0E+00,460.0,2.69E-17,0.E0,2199.,6.51E-34,0.E0,1335.0))
  RCONST(26) = (GCJPLPR(7.00E-31,2.6E+00,0.0,3.60E-11,0.1,0.0,0.6,0.0,0.0))
  RCONST(27) = (GCARR(1.80E-11,0.0E+00,-390.0))
  RCONST(28) = (GCJPLPR(2.00E-31,3.4E+00,0.0,2.9e-12,1.1E0,0.0,0.6,0.0,0.0))
  RCONST(29) = (GCJPLPR(9.52E-05,3.4E+00,-10900.0,1.38E15,1.1E0,-10900.0,0.6,0.0,0.0))
  RCONST(30) = (GCARR(1.30E-12,0.0E+00,380.0))
  RCONST(31) = (GCARR(3.50E-12,0.0E+00,0.0))
  RCONST(32) = (GCARR(1.50E-11,0.0E+00,170.0))
  RCONST(33) = (GCARR(2.20E-11,0.0E+00,0.0))
  RCONST(34) = (GCJPLPR(2.00E-30,4.4E+00,0.0,1.4E-12,0.7,0.0,0.6,0.0,0.0))
  RCONST(35) = (GCJPLPR(7.40E-04,4.4E+00,-11000.0,5.18E14,0.7,-11000.0,0.6,0.0,0.0))
  RCONST(36) = (GCARR(4.00E-13,0.0E+00,0.0))
  RCONST(37) = (GCARR(2.90E-12,0.0E+00,-345.0))
  RCONST(38) = (GCARR(4.50E-14,0.0E+00,-1260.0))
  RCONST(39) = (GCARR(5.80E-16,0.0E+00,0.0))
  RCONST(40) = (GCARR(4.63E-12,0.0E+00,350.0))
  RCONST(41) = (GCARR(1.40E-12,0.0E+00,-1900.0))
  RCONST(42) = (GCJPLPR(9.70E-29,5.6E+00,0.0,9.3E-12,1.5E0,0.0,0.6,0.0,0.0))
  RCONST(43) = (GCJPLEQ(9.30E-29,0.0E+00,14000.0,9.7E-29,5.6E0,0.0,9.3E-12,1.5E0,0.,0.6,0.,0.))
  RCONST(44) = (GCARR(8.10E-12,0.0E+00,270.0))
  RCONST(45) = (GCARR(7.66E-12,0.0E+00,-1020.0))
  RCONST(46) = (GCARR(2.60E-12,0.0E+00,365.0))
  RCONST(47) = (GC_TBRANCH(7.60E-12,0.0E+00,-585.0,5.87E0,0.64E0,-816.0))
  RCONST(48) = (GC_TBRANCH(7.60E-12,0.0E+00,-585.0,1.7E-1,-0.64E0,816.0))
  RCONST(49) = (GCARR(2.90E-12,0.0E+00,350.0))
  RCONST(50) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(51) = (GCARR(9.10E-12,0.0E+00,-405.0))
  RCONST(52) = (GC_RO2NO('B',2.70E-12,0.0E+00,350.0,4.5E0,0.0,0.0))
  RCONST(53) = (GC_RO2NO('A',2.70E-12,0.0E+00,350.0,4.5E0,0.0,0.0))
  RCONST(54) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(55) = (GCARR(2.80E-12,0.0E+00,300.0))
  RCONST(56) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(57) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(58) = (GCARR(4.07E+08,0.0E+00,-7694.0))
  RCONST(59) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(60) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(61) = (GCARR(2.90E+07,0.0E+00,-5297.0))
  RCONST(62) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(63) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(64) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(65) = (GCARR(2.30E-12,0.0E+00,0.0))
  RCONST(66) = (GCARR(3.15E-13,0.0E+00,-448.0))
  RCONST(67) = (GCARR(4.00E-12,0.0E+00,0.0))
  RCONST(68) = (GCARR(6.70E-12,0.0E+00,340.0))
  RCONST(69) = (GCJPLPR(9.00E-28,8.9E+00,0.0,7.7E-12,0.2,0.0,0.6,0.0,0.0))
  RCONST(70) = (GCARR(5.20E-13,0.0E+00,980.0))
  RCONST(71) = (GCARR(2.30E-12,0.0E+00,0.0))
  RCONST(72) = (GCARR(2.60E-12,0.0E+00,380.0))
  RCONST(73) = (GCARR(2.06E-13,0.0E+00,1300.0))
  RCONST(74) = (GCARR(2.00E-13,0.0E+00,0.0))
  RCONST(75) = (GCARR(4.15E-15,0.0E+00,-1520.0))
  RCONST(76) = (GCARR(7.48E-12,0.0E+00,410.0))
  RCONST(77) = (GCARR(2.60E-12,0.0E+00,380.0))
  RCONST(78) = (GCARR(2.06E-13,0.0E+00,1300.0))
  RCONST(79) = (GCARR(2.06E-13,0.0E+00,0.0))
  RCONST(80) = (GCARR(1.20E-12,0.0E+00,0.0))
  RCONST(81) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(82) = (GCARR(2.80E-12,0.0E+00,-3280.0))
  RCONST(83) = (GCARR(1.60E-12,0.0E+00,0.0))
  RCONST(84) = (GCARR(3.15E-14,0.0E+00,920.0))
  RCONST(85) = (GCARR(6.00E-12,0.0E+00,410.0))
  RCONST(86) = (GCJPLPR(9.00E-28,8.9E+00,0.0,7.7E-12,0.2,0.0,0.6,0.0,0.0))
  RCONST(87) = (GCJPLEQ(9.00E-29,0.0E+00,14000.0,9.00E-28,8.9E0,0.0,7.7E-12,0.2,0.,0.6,0.,0.))
  RCONST(88) = (GCJPLPR(9.00E-28,8.9E+00,0.0,7.7E-12,0.2,0.0,0.6,0.0,0.0))
  RCONST(89) = (GCJPLEQ(9.00E-29,0.0E+00,14000.0,9.00E-28,8.9E0,0.0,7.7E-12,0.2,0.,0.6,0.,0.))
  RCONST(90) = (GCARR(6.70E-12,0.0E+00,340.0))
  RCONST(91) = (GCARR(6.70E-12,0.0E+00,340.0))
  RCONST(92) = (GCARR(6.50E-15,0.0E+00,0.0))
  RCONST(93) = (1.33E-13+3.82E-11*exp(-2000.0_dp/TEMP))
  RCONST(94) = (GCARR(5.92E-13,0.0E+00,0.0))
  RCONST(95) = (GCARR(5.92E-13,0.0E+00,0.0))
  RCONST(96) = (GCARR(7.40E-13,0.0E+00,700.0))
  RCONST(97) = (GCARR(7.40E-13,0.0E+00,700.0))
  RCONST(98) = (GCARR(8.60E-13,0.0E+00,700.0))
  RCONST(99) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,4.0,0.0,0.0))
  RCONST(100) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,5.0,0.0,0.0))
  RCONST(101) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,4.0,0.0,0.0))
  RCONST(102) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,4.0,0.0,0.0))
  RCONST(103) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,4.0,0.0,0.0))
  RCONST(104) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,3.0,0.0,0.0))
  RCONST(105) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,5.0,0.0,0.0))
  RCONST(106) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,3.0,0.0,0.0))
  RCONST(107) = (GCARR(1.30E-12,0.0E+00,-25.0))
  RCONST(108) = (GCARR(3.00E-13,0.0E+00,0.0))
  RCONST(109) = (GCARR(8.00E-16,0.0E+00,0.0))
  RCONST(110) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(111) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(112) = (GCARR(7.50E-13,0.0E+00,500.0))
  RCONST(113) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(114) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(115) = (GCARR(1.54E-13,0.0E+00,0.0))
  RCONST(116) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(117) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(118) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(119) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(120) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(121) = (GCARR(1.30E-12,0.0E+00,0.0))
  RCONST(122) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(123) = (GCARR(3.35E-12,0.0E+00,0.0))
  RCONST(124) = (GCARR(4.60E-12,0.0E+00,70.0))
  RCONST(125) = (GCARR(4.10E-14,0.0E+00,0.0))
  RCONST(126) = (GCARR(2.70E-14,0.0E+00,0.0))
  RCONST(127) = (GCARR(7.40E-13,0.0E+00,700.0))
  RCONST(128) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,3.0,0.0,0.0))
  RCONST(129) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,3.0,0.0,0.0))
  RCONST(130) = (GCARR(5.20E-13,0.0E+00,980.0))
  RCONST(131) = (GCARR(4.30E-13,0.0E+00,1040.0))
  RCONST(132) = (GCARR(4.30E-13,0.0E+00,1040.0))
  RCONST(133) = (GCJPLPR(8.00E-27,3.5E+00,0.0,3E-11,1E0,0.0,0.5,0.0,0.0))
  RCONST(134) = (GCARR(5.50E-15,0.0E+00,-1880.0))
  RCONST(135) = (GCARR(2.90E-11,0.0E+00,0.0))
  RCONST(136) = (GCARR(8.20E-18,0.0E+00,0.0))
  RCONST(137) = (GC_GLYCOHA(8.00E-12,0.0E+00,0.0))
  RCONST(138) = (GC_GLYCOHB(8.00E-12,0.0E+00,0.0))
  RCONST(139) = (GCARR(4.59E-13,0.0E+00,-1156.0))
  RCONST(140) = (GCARR(3.10E-12,0.0E+00,340.0))
  RCONST(141) = (GCARR(1.50E-11,0.0E+00,0.0))
  RCONST(142) = (GC_GLYXNO3(1.40E-12,0.0E+00,-1860.0))
  RCONST(143) = (GCARR(3.36E-12,0.0E+00,-1860.0))
  RCONST(144) = (GCARR(3.10E-11,0.0E+00,350.0))
  RCONST(145) = (GCARR(2.60E-12,0.0E+00,610.0))
  RCONST(146) = (GCARR(8.00E-12,0.0E+00,380.0))
  RCONST(147) = (GC_HACOHA(2.15E-12,0.0E+00,305.0))
  RCONST(148) = (GC_HACOHB(2.15E-12,0.0E+00,305.0))
  RCONST(149) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(150) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(151) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(152) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(153) = (GCARR(1.00E-14,0.0E+00,-1970.0))
  RCONST(154) = (GCARR(8.50E-16,0.0E+00,-1520.0))
  RCONST(155) = (GCARR(1.40E-15,0.0E+00,-2100.0))
  RCONST(156) = (GCARR(3.30E-12,0.0E+00,-450.0))
  RCONST(157) = (GCARR(2.30E-15,0.0E+00,0.0))
  RCONST(158) = (GCARR(1.10E-15,0.0E+00,0.0))
  RCONST(159) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(160) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(161) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(162) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(163) = (GCARR(1.90E-11,0.0E+00,390.0))
  RCONST(164) = (GCARR(5.18E-12,0.0E+00,200.0))
  RCONST(165) = (GCARR(8.78E-12,0.0E+00,200.0))
  RCONST(166) = (GCARR(5.18E-12,0.0E+00,200.0))
  RCONST(167) = (GCARR(5.18E-12,0.0E+00,200.0))
  RCONST(168) = (GCARR(8.78E-12,0.0E+00,200.0))
  RCONST(169) = (GCARR(8.78E-12,0.0E+00,200.0))
  RCONST(170) = (GCARR(6.13E-13,0.0E+00,200.0))
  RCONST(171) = (GCARR(8.78E-12,0.0E+00,200.0))
  RCONST(172) = (GCARR(4.75E-12,0.0E+00,200.0))
  RCONST(173) = (GCARR(1.90E-11,0.0E+00,390.0))
  RCONST(174) = (GCARR(5.78E-11,0.0E+00,-400.0))
  RCONST(175) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,5.0,0.0,0.0))
  RCONST(176) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(177) = (GCARR(5.31E-12,0.0E+00,200.0))
  RCONST(178) = (GCARR(8.78E-12,0.0E+00,200.0))
  RCONST(179) = (GCARR(1.84E-12,0.0E+00,200.0))
  RCONST(180) = (GCARR(4.40E-12,0.0E+00,380.0))
  RCONST(181) = (GCARR(6.13E-13,0.0E+00,200.0))
  RCONST(182) = (GCARR(3.60E-12,0.0E+00,380.0))
  RCONST(183) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(184) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(185) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(186) = (GCARR(8.37E-14,0.0E+00,0.0))
  RCONST(187) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,4.0,0.0,0.0))
  RCONST(188) = (GC_RO2NO('B',2.70E-12,0.0E+00,350.0,4.0,0.0,0.0))
  RCONST(189) = (GC_RO2NO('A',2.70E-12,0.0E+00,350.0,4.0,0.0,0.0))
  RCONST(190) = (GCARR(6.13E-13,0.0E+00,200.0))
  RCONST(191) = (GCARR(1.40E-18,0.0E+00,0.0))
  RCONST(192) = (GCARR(6.16E-15,0.0E+00,-1814.0))
  RCONST(193) = (GCARR(2.50E-12,0.0E+00,500.0))
  RCONST(194) = (GCARR(1.80E-12,0.0E+00,500.0))
  RCONST(195) = (GCARR(2.00E-13,0.0E+00,500.0))
  RCONST(196) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(197) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(198) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(199) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(200) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(201) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(202) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(203) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(204) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(205) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(206) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(207) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(208) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(209) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(210) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(211) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(212) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(213) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(214) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(215) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(216) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(217) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(218) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(219) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(220) = (GCARR(1.68E-12,0.0E+00,500.0))
  RCONST(221) = (GCARR(1.87E-13,0.0E+00,500.0))
  RCONST(222) = (GCARR(2.50E-12,0.0E+00,500.0))
  RCONST(223) = (GCARR(2.50E-12,0.0E+00,500.0))
  RCONST(224) = (GCARR(8.50E-13,0.0E+00,-2450.0))
  RCONST(225) = (GCJPLPR(1.00E-30,4.8E+00,0.0,7.2E-12,2.1E0,0.0,0.6,0.0,0.0))
  RCONST(226) = (GCJPLPR(1.05E-02,4.8E+00,-11234.0,7.58E16,2.1E0,-11234.0,0.6,0.0,0.0))
  RCONST(227) = (GCARR(1.06E-16,0.0E+00,0.0))
  RCONST(228) = (GCARR(5.30E-17,0.0E+00,0.0))
  RCONST(229) = (HET(ind_HO2,1))
  RCONST(230) = (HET(ind_NO2,1))
  RCONST(231) = (HET(ind_NO3,1))
  RCONST(232) = (HET(ind_N2O5,1))
  RCONST(233) = (GCARR(1.20E-11,0.0E+00,-280.0))
  RCONST(234) = (GC_DMSOH(8.20E-39,0.0E+00,5376.0,1.05E-5,0.0,3644.0))
  RCONST(235) = (GCARR(1.90E-13,0.0E+00,530.0))
  RCONST(236) = (GCJPLPR(3.30E-31,4.3E+00,0.0,1.6E-12,0.0,0.0,0.6,0.0,0.0))
  RCONST(237) = (GCARR(1.70E-11,0.0E+00,-800.0))
  RCONST(238) = (GCARR(4.50E-12,0.0E+00,460.0))
  RCONST(239) = (GCARR(4.80E-12,0.0E+00,-310.0))
  RCONST(240) = (GCARR(5.50E-12,0.0E+00,200.0))
  RCONST(241) = (GCARR(2.40E-12,0.0E+00,40.0))
  RCONST(242) = (GCARR(2.80E-14,0.0E+00,860.0))
  RCONST(243) = (GCARR(8.80E-12,0.0E+00,260.0))
  RCONST(244) = (GCARR(4.90E-11,0.0E+00,0.0))
  RCONST(245) = (GCARR(2.10E-11,0.0E+00,240.0))
  RCONST(246) = (GCARR(1.70E-11,0.0E+00,250.0))
  RCONST(247) = (GCARR(1.60E-11,0.0E+00,0.0))
  RCONST(248) = (GCARR(1.70E-11,0.0E+00,-800.0))
  RCONST(249) = (GCARR(1.30E-11,0.0E+00,-360.0))
  RCONST(250) = (GCARR(1.66E-10,0.0E+00,-7000.0))
  RCONST(251) = (GCARR(2.36E-10,0.0E+00,-6411.0))
  RCONST(252) = (GCARR(8.77E-11,0.0E+00,-4330.0))
  RCONST(253) = (GCJPLPR(4.20E-31,2.4E+00,0.0,2.7E-11,0.0,0.0,0.6,0.0,0.0))
  RCONST(254) = (GCJPLPR(5.20E-31,3.2E+00,0.0,6.9E-12,2.9E0,0.0,0.6,0.0,0.0))
  RCONST(255) = (GCARR(1.35E-12,0.0E+00,-600.0))
  RCONST(256) = (GCARR(2.00E-12,0.0E+00,-840.0))
  RCONST(257) = (GCARR(2.35E-12,0.0E+00,-1300.0))
  RCONST(258) = (HET(ind_BrNO3,1))
  RCONST(259) = (HET(ind_HOBr,1))
  RCONST(260) = (HET(ind_HBr,1))
  RCONST(261) = (HET(ind_HOBr,2))
  RCONST(262) = (HET(ind_HBr,2))
  RCONST(263) = (GCARR(3.35E-11,0.0E+00,380.0))
  RCONST(264) = (GC_RO2NO('B',2.70E-12,0.0E+00,350.0,5.0,0.0,0.0))
  RCONST(265) = (GC_RO2NO('A',2.70E-12,0.0E+00,350.0,5.0,0.0,0.0))
  RCONST(266) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,5.0,0.0,0.0))
  RCONST(267) = (GCARR(2.64E-11,0.0E+00,380.0))
  RCONST(268) = (GCARR(3.61E-12,0.0E+00,380.0))
  RCONST(269) = (GC_RO2NO('B',2.70E-12,0.0E+00,350.0,5.0,0.0,0.0))
  RCONST(270) = (GC_RO2NO('A',2.70E-12,0.0E+00,350.0,5.0,0.0,0.0))
  RCONST(271) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,5.0,0.0,0.0))
  RCONST(272) = (GC_RO2NO('B',2.70E-12,0.0E+00,350.0,5.0,0.0,0.0))
  RCONST(273) = (GC_RO2NO('A',2.70E-12,0.0E+00,350.0,5.0,0.0,0.0))
  RCONST(274) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,5.0,0.0,0.0))
  RCONST(275) = (GCARR(4.75E-12,0.0E+00,200.0))
  RCONST(276) = (GCARR(1.50E-12,0.0E+00,380.0))
  RCONST(277) = (GCARR(1.39E-11,0.0E+00,380.0))
  RCONST(278) = (GCARR(2.70E-12,0.0E+00,350.0))
  RCONST(279) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,4.0,0.0,0.0))
  RCONST(280) = (GCJPLPR(9.00E-28,8.9E+00,0.0,7.7E-12,0.2,0.0,0.6,0.0,0.0))
  RCONST(281) = (GCJPLEQ(9.00E-29,0.0E+00,14000.0,9.00E-28,8.9E0,0.0,7.7E-12,0.2,0.,0.6,0.,0.))
  RCONST(282) = (GCARR(2.52E-12,0.0E+00,410.0))
  RCONST(283) = (GC_RO2NO('B',2.70E-12,0.0E+00,350.0,5.0,0.0,0.0))
  RCONST(284) = (GC_RO2NO('A',2.70E-12,0.0E+00,350.0,5.0,0.0,0.0))
  RCONST(285) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,5.0,0.0,0.0))
  RCONST(286) = (GCARR(2.79E-11,0.0E+00,380.0))
  RCONST(287) = (GC_RO2NO('B',2.70E-12,0.0E+00,350.0,5.0,0.0,0.0))
  RCONST(288) = (GC_RO2NO('A',2.70E-12,0.0E+00,350.0,5.0,0.0,0.0))
  RCONST(289) = (GC_RO2HO2(2.91E-13,0.0E+00,1300.0,4.0,0.0,0.0))
  RCONST(290) = (GCARR(2.00E-17,0.0E+00,0.0))
  RCONST(291) = (GCARR(1.00E-11,0.0E+00,0.0))
  RCONST(292) = (GCARR(1.00E-15,0.0E+00,0.0))
  RCONST(293) = (GCARR(1.00E-14,0.0E+00,0.0))
  RCONST(294) = (GCARR(1.00E-15,0.0E+00,0.0))
  RCONST(295) = (GCARR(7.00E-14,0.0E+00,0.0))
  RCONST(296) = (GCARR(6.00E-18,0.0E+00,0.0))
  RCONST(297) = (GCARR(1.00E-17,0.0E+00,0.0))
  RCONST(298) = (GCARR(1.20E-15,0.0E+00,0.0))
  RCONST(299) = (GCARR(1.00E-14,0.0E+00,0.0))
  RCONST(300) = (GCARR(1.00E-15,0.0E+00,0.0))
  RCONST(301) = (GCARR(7.00E-14,0.0E+00,0.0))
  RCONST(302) = (GCARR(1.00E-17,0.0E+00,0.0))
  RCONST(303) = (GCARR(6.00E-18,0.0E+00,0.0))
  RCONST(304) = (GCARR(1.20E-15,0.0E+00,0.0))
  RCONST(305) = (GCARR(1.00E-14,0.0E+00,0.0))
  RCONST(306) = (GCARR(1.00E-15,0.0E+00,0.0))
  RCONST(307) = (GCARR(7.00E-14,0.0E+00,0.0))
  RCONST(308) = (GCARR(6.00E-18,0.0E+00,0.0))
  RCONST(309) = (GCARR(1.20E-15,0.0E+00,0.0))
  RCONST(310) = (GCARR(1.00E-14,0.0E+00,0.0))
  RCONST(311) = (GCARR(1.00E-15,0.0E+00,0.0))
  RCONST(312) = (GCARR(7.00E-14,0.0E+00,0.0))
  RCONST(313) = (GCARR(6.00E-18,0.0E+00,0.0))
  RCONST(314) = (GCARR(1.20E-15,0.0E+00,0.0))
  RCONST(315) = (GCARR(1.00E-14,0.0E+00,0.0))
  RCONST(316) = (GCARR(1.00E-15,0.0E+00,0.0))
  RCONST(317) = (GCARR(7.00E-14,0.0E+00,0.0))
  RCONST(318) = (GCARR(1.00E-17,0.0E+00,0.0))
  RCONST(319) = (GCARR(6.00E-18,0.0E+00,0.0))
  RCONST(320) = (GCARR(1.20E-15,0.0E+00,0.0))
  RCONST(321) = (GCARR(1.00E-14,0.0E+00,0.0))
  RCONST(322) = (GCARR(1.00E-15,0.0E+00,0.0))
  RCONST(323) = (GCARR(7.00E-14,0.0E+00,0.0))
  RCONST(324) = (GCARR(6.00E-18,0.0E+00,0.0))
  RCONST(325) = (GCARR(1.00E-17,0.0E+00,0.0))
  RCONST(326) = (GCARR(1.20E-15,0.0E+00,0.0))
  RCONST(327) = (GCARR(1.00E-14,0.0E+00,0.0))
  RCONST(328) = (GCARR(1.00E-15,0.0E+00,0.0))
  RCONST(329) = (GCARR(7.00E-14,0.0E+00,0.0))
  RCONST(330) = (GCARR(6.00E-18,0.0E+00,0.0))
  RCONST(331) = (GCARR(1.00E-17,0.0E+00,0.0))
  RCONST(332) = (GCARR(2.33E-12,0.0E+00,-193.0))
  RCONST(333) = (GCARR(1.81E-12,0.0E+00,338.0))
  RCONST(334) = (GCARR(2.31E-11,0.0E+00,0.0))
  RCONST(335) = (GCARR(1.07E-05,0.0E+00,0.0))
  RCONST(336) = (GCARR(1.40E-12,0.0E+00,700.0))
  RCONST(337) = (GCARR(2.60E-12,0.0E+00,350.0))
  RCONST(338) = (GCARR(1.40E-12,0.0E+00,700.0))
  RCONST(339) = (GCARR(2.60E-12,0.0E+00,350.0))
  RCONST(340) = (GCARR(1.40E-12,0.0E+00,700.0))
  RCONST(341) = (GCARR(2.60E-12,0.0E+00,350.0))
  RCONST(342) = (PHOTOL(3))
  RCONST(343) = (PHOTOL(103))
  RCONST(344) = (PHOTOL(11))
  RCONST(345) = (PHOTOL(9))
  RCONST(346) = (PHOTOL(10))
  RCONST(347) = (PHOTOL(7))
  RCONST(348) = (PHOTOL(8))
  RCONST(349) = (PHOTOL(16))
  RCONST(350) = (PHOTOL(15))
  RCONST(351) = (PHOTOL(17))
  RCONST(352) = (PHOTOL(18))
  RCONST(353) = (PHOTOL(12))
  RCONST(354) = (PHOTOL(13))
  RCONST(355) = (PHOTOL(14))
  RCONST(356) = (PHOTOL(61))
  RCONST(357) = (PHOTOL(62))
  RCONST(358) = (PHOTOL(59))
  RCONST(359) = (PHOTOL(70))
  RCONST(360) = (PHOTOL(76))
  RCONST(361) = (PHOTOL(77))
  RCONST(362) = (PHOTOL(69))
  RCONST(363) = (PHOTOL(68))
  RCONST(364) = (PHOTOL(72))
  RCONST(365) = (PHOTOL(73))
  RCONST(366) = (PHOTOL(74))
  RCONST(367) = (PHOTOL(71))
  RCONST(368) = (PHOTOL(63))
  RCONST(369) = (PHOTOL(64))
  RCONST(370) = (PHOTOL(65))
  RCONST(371) = (PHOTOL(66))
  RCONST(372) = (PHOTOL(75))
  RCONST(373) = (PHOTOL(78))
  RCONST(374) = (PHOTOL(79))
  RCONST(375) = (PHOTOL(80))
  RCONST(376) = (PHOTOL(81))
  RCONST(377) = (PHOTOL(82))
  RCONST(378) = (PHOTOL(83))
  RCONST(379) = (PHOTOL(84))
  RCONST(380) = (PHOTOL(85))
  RCONST(381) = (PHOTOL(86))
  RCONST(382) = (PHOTOL(87))
  RCONST(383) = (PHOTOL(88))
  RCONST(384) = (PHOTOL(89))
  RCONST(385) = (PHOTOL(90))
  RCONST(386) = (PHOTOL(91))
  RCONST(387) = (PHOTOL(98))
  RCONST(388) = (PHOTOL(99))
  RCONST(389) = (PHOTOL(92))
  RCONST(390) = (PHOTOL(93))
  RCONST(391) = (PHOTOL(94))
  RCONST(392) = (PHOTOL(23))
  RCONST(393) = (PHOTOL(28))
  RCONST(394) = (PHOTOL(32))
  RCONST(395) = (PHOTOL(29))
  RCONST(396) = (PHOTOL(30))
  RCONST(397) = (PHOTOL(31))
  RCONST(398) = (PHOTOL(56))
  RCONST(399) = (PHOTOL(104))
  RCONST(400) = (PHOTOL(105))
  RCONST(401) = (PHOTOL(95))
  RCONST(402) = (PHOTOL(96))
  RCONST(403) = (PHOTOL(97))
      
END SUBROUTINE Update_RCONST

! End of Update_RCONST function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_PHOTO - function to update photolytical rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_PHOTO ( )


   USE gckpp_Global

  RCONST(342) = (PHOTOL(3))
  RCONST(343) = (PHOTOL(103))
  RCONST(344) = (PHOTOL(11))
  RCONST(345) = (PHOTOL(9))
  RCONST(346) = (PHOTOL(10))
  RCONST(347) = (PHOTOL(7))
  RCONST(348) = (PHOTOL(8))
  RCONST(349) = (PHOTOL(16))
  RCONST(350) = (PHOTOL(15))
  RCONST(351) = (PHOTOL(17))
  RCONST(352) = (PHOTOL(18))
  RCONST(353) = (PHOTOL(12))
  RCONST(354) = (PHOTOL(13))
  RCONST(355) = (PHOTOL(14))
  RCONST(356) = (PHOTOL(61))
  RCONST(357) = (PHOTOL(62))
  RCONST(358) = (PHOTOL(59))
  RCONST(359) = (PHOTOL(70))
  RCONST(360) = (PHOTOL(76))
  RCONST(361) = (PHOTOL(77))
  RCONST(362) = (PHOTOL(69))
  RCONST(363) = (PHOTOL(68))
  RCONST(364) = (PHOTOL(72))
  RCONST(365) = (PHOTOL(73))
  RCONST(366) = (PHOTOL(74))
  RCONST(367) = (PHOTOL(71))
  RCONST(368) = (PHOTOL(63))
  RCONST(369) = (PHOTOL(64))
  RCONST(370) = (PHOTOL(65))
  RCONST(371) = (PHOTOL(66))
  RCONST(372) = (PHOTOL(75))
  RCONST(373) = (PHOTOL(78))
  RCONST(374) = (PHOTOL(79))
  RCONST(375) = (PHOTOL(80))
  RCONST(376) = (PHOTOL(81))
  RCONST(377) = (PHOTOL(82))
  RCONST(378) = (PHOTOL(83))
  RCONST(379) = (PHOTOL(84))
  RCONST(380) = (PHOTOL(85))
  RCONST(381) = (PHOTOL(86))
  RCONST(382) = (PHOTOL(87))
  RCONST(383) = (PHOTOL(88))
  RCONST(384) = (PHOTOL(89))
  RCONST(385) = (PHOTOL(90))
  RCONST(386) = (PHOTOL(91))
  RCONST(387) = (PHOTOL(98))
  RCONST(388) = (PHOTOL(99))
  RCONST(389) = (PHOTOL(92))
  RCONST(390) = (PHOTOL(93))
  RCONST(391) = (PHOTOL(94))
  RCONST(392) = (PHOTOL(23))
  RCONST(393) = (PHOTOL(28))
  RCONST(394) = (PHOTOL(32))
  RCONST(395) = (PHOTOL(29))
  RCONST(396) = (PHOTOL(30))
  RCONST(397) = (PHOTOL(31))
  RCONST(398) = (PHOTOL(56))
  RCONST(399) = (PHOTOL(104))
  RCONST(400) = (PHOTOL(105))
  RCONST(401) = (PHOTOL(95))
  RCONST(402) = (PHOTOL(96))
  RCONST(403) = (PHOTOL(97))
      
END SUBROUTINE Update_PHOTO

! End of Update_PHOTO function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE gckpp_Rates

