! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Function of Chemical Model File
! 
! Generated by KPP-2.2.4_gc symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : gckpp_Function.f90
! Time                 : Wed Nov 23 10:35:24 2016
! Working directory    : /n/home05/msulprizio/GC/FlexChem/Mechanisms/Tropchem
! Equation file        : gckpp.kpp
! Output root filename : gckpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE gckpp_Function

  USE gckpp_Parameters
  IMPLICIT NONE

! A - Rate for each equation
  REAL(kind=dp) :: A(NREACT)
!$OMP THREADPRIVATE(  A )

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun - time derivatives of variables - Agregate form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      Vdot      - Time derivative of variable species concentrations
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun ( V, F, RCT, Vdot )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! Vdot - Time derivative of variable species concentrations
  REAL(kind=dp) :: Vdot(NVAR)


! Computation of equation rates
  A(1) = RCT(1)*V(285)*V(286)
  A(2) = RCT(2)*V(285)*V(288)
  A(3) = RCT(3)*V(282)*V(285)
  A(4) = RCT(4)*V(285)*V(287)
  A(5) = RCT(5)*V(284)*V(285)
  A(6) = RCT(6)*V(288)*V(288)
  A(7) = RCT(7)*V(288)*V(288)
  A(8) = RCT(8)*V(282)*V(288)
  A(9) = RCT(9)*V(207)*V(288)
  A(10) = RCT(10)*V(282)*V(286)
  A(11) = RCT(11)*V(282)*V(282)
  A(12) = RCT(12)*V(288)*F(3)
  A(13) = RCT(13)*V(288)*V(290)
  A(14) = RCT(14)*V(288)*F(1)
  A(15) = RCT(15)*V(284)*V(286)
  A(16) = RCT(16)*V(282)*V(284)
  A(17) = RCT(17)*V(284)*V(284)
  A(18) = RCT(18)*V(284)*V(284)
  A(19) = RCT(19)*V(197)*V(288)
  A(20) = RCT(20)*V(197)*V(288)
  A(21) = RCT(21)*V(211)*V(288)
  A(22) = RCT(22)*V(211)*V(288)
  A(23) = RCT(23)*V(271)*V(288)
  A(24) = RCT(24)*V(287)*V(288)
  A(25) = RCT(25)*V(244)*V(288)
  A(26) = RCT(26)*V(286)*V(288)
  A(27) = RCT(27)*V(190)*V(288)
  A(28) = RCT(28)*V(282)*V(287)
  A(29) = RCT(29)*V(196)
  A(30) = RCT(30)*V(196)*V(288)
  A(31) = RCT(31)*V(282)*V(289)
  A(32) = RCT(32)*V(286)*V(289)
  A(33) = RCT(33)*V(288)*V(289)
  A(34) = RCT(34)*V(287)*V(289)
  A(35) = RCT(35)*V(187)
  A(36) = RCT(36)*V(212)*V(288)
  A(37) = RCT(37)*V(288)*F(5)
  A(38) = RCT(38)*V(287)*V(289)
  A(39) = RCT(39)*V(271)*V(289)
  A(40) = RCT(40)*V(277)*V(288)
  A(41) = RCT(41)*V(277)*V(289)
  A(42) = RCT(42)*V(287)*V(291)
  A(43) = RCT(43)*V(189)
  A(44) = RCT(44)*V(286)*V(291)
  A(45) = RCT(45)*V(206)*V(288)
  A(46) = RCT(46)*V(257)*V(286)
  A(47) = RCT(47)*V(194)*V(288)
  A(48) = RCT(48)*V(194)*V(288)
  A(49) = RCT(49)*V(245)*V(286)
  A(50) = RCT(50)*V(250)*V(286)
  A(51) = RCT(51)*V(188)*V(288)
  A(52) = RCT(52)*V(276)*V(286)
  A(53) = RCT(53)*V(276)*V(286)
  A(54) = RCT(54)*V(263)*V(286)
  A(55) = RCT(55)*V(262)*V(286)
  A(56) = RCT(56)*V(256)*V(286)
  A(57) = RCT(57)*V(269)*V(286)
  A(58) = RCT(58)*V(269)
  A(59) = RCT(59)*V(260)*V(286)
  A(60) = RCT(60)*V(272)*V(286)
  A(61) = RCT(61)*V(272)
  A(62) = RCT(62)*V(253)*V(286)
  A(63) = RCT(63)*V(254)*V(286)
  A(64) = RCT(64)*V(268)*V(286)
  A(65) = RCT(65)*V(268)*V(289)
  A(66) = RCT(66)*V(264)*V(289)
  A(67) = RCT(67)*V(252)*V(289)
  A(68) = RCT(68)*V(252)*V(286)
  A(69) = RCT(69)*V(252)*V(287)
  A(70) = RCT(70)*V(252)*V(282)
  A(71) = RCT(71)*V(243)*V(289)
  A(72) = RCT(72)*V(243)*V(286)
  A(73) = RCT(73)*V(243)*V(282)
  A(74) = RCT(74)*V(243)*V(284)
  A(75) = RCT(75)*V(264)*V(285)
  A(76) = RCT(76)*V(264)*V(288)
  A(77) = RCT(77)*V(234)*V(286)
  A(78) = RCT(78)*V(234)*V(282)
  A(79) = RCT(79)*V(234)*V(284)
  A(80) = RCT(80)*V(268)*V(268)
  A(81) = RCT(81)*V(255)*V(286)
  A(82) = RCT(82)*V(188)*V(289)
  A(83) = RCT(83)*V(278)*V(288)
  A(84) = RCT(84)*V(230)*V(288)
  A(85) = RCT(85)*V(288)*V(292)
  A(86) = RCT(86)*V(261)*V(287)
  A(87) = RCT(87)*V(186)
  A(88) = RCT(88)*V(265)*V(287)
  A(89) = RCT(89)*V(228)
  A(90) = RCT(90)*V(261)*V(286)
  A(91) = RCT(91)*V(265)*V(286)
  A(92) = RCT(92)*V(289)*V(292)
  A(93) = RCT(93)*V(233)*V(288)
  A(94) = RCT(94)*V(245)*V(284)
  A(95) = RCT(95)*V(250)*V(284)
  A(96) = RCT(96)*V(276)*V(282)
  A(97) = RCT(97)*V(263)*V(282)
  A(98) = RCT(98)*V(262)*V(282)
  A(99) = RCT(99)*V(256)*V(282)
  A(100) = RCT(100)*V(269)*V(282)
  A(101) = RCT(101)*V(260)*V(282)
  A(102) = RCT(102)*V(272)*V(282)
  A(103) = RCT(103)*V(253)*V(282)
  A(104) = RCT(104)*V(254)*V(282)
  A(105) = RCT(105)*V(268)*V(282)
  A(106) = RCT(106)*V(255)*V(282)
  A(107) = RCT(107)*V(281)*V(288)
  A(108) = RCT(108)*V(257)*V(284)
  A(109) = RCT(109)*V(281)*V(289)
  A(110) = RCT(110)*V(276)*V(284)
  A(111) = RCT(111)*V(263)*V(284)
  A(112) = RCT(112)*V(262)*V(284)
  A(113) = RCT(113)*V(256)*V(284)
  A(114) = RCT(114)*V(269)*V(284)
  A(115) = RCT(115)*V(269)*V(269)
  A(116) = RCT(116)*V(258)*V(284)
  A(117) = RCT(117)*V(260)*V(284)
  A(118) = RCT(118)*V(272)*V(284)
  A(119) = RCT(119)*V(253)*V(284)
  A(120) = RCT(120)*V(254)*V(284)
  A(121) = RCT(121)*V(268)*V(284)
  A(122) = RCT(122)*V(255)*V(284)
  A(123) = RCT(123)*V(288)*F(2)
  A(124) = RCT(124)*V(225)*V(288)
  A(125) = RCT(125)*V(257)*V(257)
  A(126) = RCT(126)*V(257)*V(257)
  A(127) = RCT(127)*V(257)*V(282)
  A(128) = RCT(128)*V(245)*V(282)
  A(129) = RCT(129)*V(250)*V(282)
  A(130) = RCT(130)*V(282)*V(291)
  A(131) = RCT(131)*V(261)*V(282)
  A(132) = RCT(132)*V(265)*V(282)
  A(133) = RCT(133)*V(239)*V(288)
  A(134) = RCT(134)*V(239)*V(285)
  A(135) = RCT(135)*V(228)*V(288)
  A(136) = RCT(136)*V(228)*V(285)
  A(137) = RCT(137)*V(259)*V(288)
  A(138) = RCT(138)*V(259)*V(288)
  A(139) = RCT(139)*V(239)*V(289)
  A(140) = RCT(140)*V(246)*V(288)
  A(141) = RCT(141)*V(267)*V(288)
  A(142) = RCT(142)*V(246)*V(289)
  A(143) = RCT(143)*V(267)*V(289)
  A(144) = RCT(144)*V(238)*V(288)
  A(145) = RCT(145)*V(280)*V(288)
  A(146) = RCT(146)*V(279)*V(288)
  A(147) = RCT(147)*V(275)*V(288)
  A(148) = RCT(148)*V(275)*V(288)
  A(149) = RCT(149)*V(245)*V(291)
  A(150) = RCT(150)*V(250)*V(291)
  A(151) = RCT(151)*V(245)*V(291)
  A(152) = RCT(152)*V(250)*V(291)
  A(153) = RCT(153)*V(238)*V(285)
  A(154) = RCT(154)*V(280)*V(285)
  A(155) = RCT(155)*V(279)*V(285)
  A(156) = RCT(156)*V(238)*V(289)
  A(157) = RCT(157)*V(279)*V(289)
  A(158) = RCT(158)*V(279)*V(289)
  A(159) = RCT(159)*V(261)*V(284)
  A(160) = RCT(160)*V(265)*V(284)
  A(161) = RCT(161)*V(261)*V(284)
  A(162) = RCT(162)*V(265)*V(284)
  A(163) = RCT(163)*V(220)*V(288)
  A(164) = RCT(164)*V(220)*V(288)
  A(165) = RCT(165)*V(210)*V(288)
  A(166) = RCT(166)*V(195)*V(288)
  A(167) = RCT(167)*V(198)*V(288)
  A(168) = RCT(168)*V(199)*V(288)
  A(169) = RCT(169)*V(213)*V(288)
  A(170) = RCT(170)*V(204)*V(288)
  A(171) = RCT(171)*V(209)*V(288)
  A(172) = RCT(172)*V(214)*V(288)
  A(173) = RCT(173)*V(214)*V(288)
  A(174) = RCT(174)*V(184)*V(288)
  A(175) = RCT(175)*V(223)*V(282)
  A(176) = RCT(176)*V(223)*V(286)
  A(177) = RCT(177)*V(215)*V(288)
  A(178) = RCT(178)*V(217)*V(288)
  A(179) = RCT(179)*V(216)*V(288)
  A(180) = RCT(180)*V(216)*V(288)
  A(181) = RCT(181)*V(203)*V(288)
  A(182) = RCT(182)*V(203)*V(288)
  A(183) = RCT(183)*V(247)*V(291)
  A(184) = RCT(184)*V(247)*V(291)
  A(185) = RCT(185)*V(247)*V(284)
  A(186) = RCT(186)*V(247)*V(247)
  A(187) = RCT(187)*V(247)*V(282)
  A(188) = RCT(188)*V(247)*V(286)
  A(189) = RCT(189)*V(247)*V(286)
  A(190) = RCT(190)*V(191)*V(288)
  A(191) = RCT(191)*V(206)*V(289)
  A(192) = RCT(192)*V(270)*V(285)
  A(193) = RCT(193)*V(291)*V(291)
  A(194) = RCT(194)*V(284)*V(291)
  A(195) = RCT(195)*V(284)*V(291)
  A(196) = RCT(196)*V(276)*V(291)
  A(197) = RCT(197)*V(262)*V(291)
  A(198) = RCT(198)*V(256)*V(291)
  A(199) = RCT(199)*V(269)*V(291)
  A(200) = RCT(200)*V(258)*V(291)
  A(201) = RCT(201)*V(260)*V(291)
  A(202) = RCT(202)*V(272)*V(291)
  A(203) = RCT(203)*V(254)*V(291)
  A(204) = RCT(204)*V(263)*V(291)
  A(205) = RCT(205)*V(253)*V(291)
  A(206) = RCT(206)*V(268)*V(291)
  A(207) = RCT(207)*V(255)*V(291)
  A(208) = RCT(208)*V(276)*V(291)
  A(209) = RCT(209)*V(262)*V(291)
  A(210) = RCT(210)*V(256)*V(291)
  A(211) = RCT(211)*V(269)*V(291)
  A(212) = RCT(212)*V(258)*V(291)
  A(213) = RCT(213)*V(260)*V(291)
  A(214) = RCT(214)*V(272)*V(291)
  A(215) = RCT(215)*V(263)*V(291)
  A(216) = RCT(216)*V(253)*V(291)
  A(217) = RCT(217)*V(268)*V(291)
  A(218) = RCT(218)*V(255)*V(291)
  A(219) = RCT(219)*V(254)*V(291)
  A(220) = RCT(220)*V(257)*V(291)
  A(221) = RCT(221)*V(257)*V(291)
  A(222) = RCT(222)*V(261)*V(291)
  A(223) = RCT(223)*V(265)*V(291)
  A(224) = RCT(224)*V(289)*V(289)
  A(225) = RCT(225)*V(284)*V(287)
  A(226) = RCT(226)*V(192)
  A(227) = RCT(227)*V(222)*V(285)
  A(228) = RCT(228)*V(241)*V(285)
  A(229) = RCT(229)*V(282)
  A(230) = RCT(230)*V(287)
  A(231) = RCT(231)*V(289)
  A(232) = RCT(232)*V(187)
  A(233) = RCT(233)*V(193)*V(288)
  A(234) = RCT(234)*V(193)*V(288)
  A(235) = RCT(235)*V(193)*V(289)
  A(236) = RCT(236)*V(266)*V(288)
  A(237) = RCT(237)*V(283)*V(285)
  A(238) = RCT(238)*V(240)*V(282)
  A(239) = RCT(239)*V(282)*V(283)
  A(240) = RCT(240)*V(202)*V(288)
  A(241) = RCT(241)*V(240)*V(240)
  A(242) = RCT(242)*V(240)*V(240)
  A(243) = RCT(243)*V(240)*V(286)
  A(244) = RCT(244)*V(208)*V(283)
  A(245) = RCT(245)*V(201)*V(288)
  A(246) = RCT(246)*V(240)*V(288)
  A(247) = RCT(247)*V(283)*V(289)
  A(248) = RCT(248)*V(271)*V(283)
  A(249) = RCT(249)*V(277)*V(283)
  A(250) = RCT(250)*V(233)*V(283)
  A(251) = RCT(251)*V(206)*V(283)
  A(252) = RCT(252)*V(194)*V(283)
  A(253) = RCT(253)*V(283)*V(287)
  A(254) = RCT(254)*V(240)*V(287)
  A(255) = RCT(255)*V(180)*V(288)
  A(256) = RCT(256)*V(181)*V(288)
  A(257) = RCT(257)*V(182)*V(288)
  A(258) = RCT(258)*V(208)
  A(259) = RCT(259)*V(200)
  A(260) = RCT(260)*V(202)
  A(261) = RCT(261)*V(200)
  A(262) = RCT(262)*V(202)
  A(263) = RCT(263)*V(270)*V(288)
  A(264) = RCT(264)*V(258)*V(286)
  A(265) = RCT(265)*V(258)*V(286)
  A(266) = RCT(266)*V(258)*V(282)
  A(267) = RCT(267)*V(241)*V(288)
  A(268) = RCT(268)*V(222)*V(288)
  A(269) = RCT(269)*V(274)*V(286)
  A(270) = RCT(270)*V(274)*V(286)
  A(271) = RCT(271)*V(274)*V(282)
  A(272) = RCT(272)*V(273)*V(286)
  A(273) = RCT(273)*V(273)*V(286)
  A(274) = RCT(274)*V(273)*V(282)
  A(275) = RCT(275)*V(221)*V(288)
  A(276) = RCT(276)*V(235)*V(288)
  A(277) = RCT(277)*V(251)*V(288)
  A(278) = RCT(278)*V(227)*V(286)
  A(279) = RCT(279)*V(227)*V(282)
  A(280) = RCT(280)*V(227)*V(287)
  A(281) = RCT(281)*V(185)
  A(282) = RCT(282)*V(218)*V(288)
  A(283) = RCT(283)*V(226)*V(286)
  A(284) = RCT(284)*V(226)*V(286)
  A(285) = RCT(285)*V(226)*V(282)
  A(286) = RCT(286)*V(219)*V(288)
  A(287) = RCT(287)*V(224)*V(286)
  A(288) = RCT(288)*V(224)*V(286)
  A(289) = RCT(289)*V(224)*V(282)
  A(290) = RCT(290)*V(219)*V(285)
  A(291) = RCT(291)*V(205)*V(288)
  A(292) = RCT(292)*V(248)*V(288)
  A(293) = RCT(293)*V(237)*V(286)
  A(294) = RCT(294)*V(237)*V(287)
  A(295) = RCT(295)*V(237)*V(266)
  A(296) = RCT(296)*V(237)*F(4)
  A(297) = RCT(297)*V(237)*F(4)
  A(298) = RCT(298)*V(249)*V(290)
  A(299) = RCT(299)*V(249)*V(286)
  A(300) = RCT(300)*V(249)*V(287)
  A(301) = RCT(301)*V(249)*V(266)
  A(302) = RCT(302)*V(249)*F(4)
  A(303) = RCT(303)*V(249)*F(4)
  A(304) = RCT(304)*V(229)*V(290)
  A(305) = RCT(305)*V(229)*V(286)
  A(306) = RCT(306)*V(229)*V(287)
  A(307) = RCT(307)*V(229)*V(266)
  A(308) = RCT(308)*V(229)*F(4)
  A(309) = RCT(309)*V(236)*V(290)
  A(310) = RCT(310)*V(236)*V(286)
  A(311) = RCT(311)*V(236)*V(287)
  A(312) = RCT(312)*V(236)*V(266)
  A(313) = RCT(313)*V(236)*F(4)
  A(314) = RCT(314)*V(242)*V(290)
  A(315) = RCT(315)*V(242)*V(286)
  A(316) = RCT(316)*V(242)*V(287)
  A(317) = RCT(317)*V(242)*V(266)
  A(318) = RCT(318)*V(242)*F(4)
  A(319) = RCT(319)*V(242)*F(4)
  A(320) = RCT(320)*V(231)*V(290)
  A(321) = RCT(321)*V(231)*V(286)
  A(322) = RCT(322)*V(231)*V(287)
  A(323) = RCT(323)*V(231)*V(266)
  A(324) = RCT(324)*V(231)*F(4)
  A(325) = RCT(325)*V(231)*F(4)
  A(326) = RCT(326)*V(232)*V(290)
  A(327) = RCT(327)*V(232)*V(286)
  A(328) = RCT(328)*V(232)*V(287)
  A(329) = RCT(329)*V(232)*V(266)
  A(330) = RCT(330)*V(232)*F(4)
  A(331) = RCT(331)*V(232)*F(4)
  A(332) = RCT(332)*V(285)
  A(333) = RCT(333)*V(285)
  A(334) = RCT(334)*V(287)
  A(335) = RCT(335)*V(207)
  A(336) = RCT(336)*V(197)
  A(337) = RCT(337)*V(271)
  A(338) = RCT(338)*V(271)
  A(339) = RCT(339)*V(244)
  A(340) = RCT(340)*V(190)
  A(341) = RCT(341)*V(196)
  A(342) = RCT(342)*V(196)
  A(343) = RCT(343)*V(289)
  A(344) = RCT(344)*V(289)
  A(345) = RCT(345)*V(187)
  A(346) = RCT(346)*V(277)
  A(347) = RCT(347)*V(277)
  A(348) = RCT(348)*V(189)
  A(349) = RCT(349)*V(292)
  A(350) = RCT(350)*V(233)
  A(351) = RCT(351)*V(233)
  A(352) = RCT(352)*V(281)
  A(353) = RCT(353)*V(259)
  A(354) = RCT(354)*V(246)
  A(355) = RCT(355)*V(246)
  A(356) = RCT(356)*V(246)
  A(357) = RCT(357)*V(267)
  A(358) = RCT(358)*V(280)
  A(359) = RCT(359)*V(280)
  A(360) = RCT(360)*V(280)
  A(361) = RCT(361)*V(279)
  A(362) = RCT(362)*V(275)
  A(363) = RCT(363)*V(220)
  A(364) = RCT(364)*V(210)
  A(365) = RCT(365)*V(195)
  A(366) = RCT(366)*V(198)
  A(367) = RCT(367)*V(199)
  A(368) = RCT(368)*V(213)
  A(369) = RCT(369)*V(209)
  A(370) = RCT(370)*V(204)
  A(371) = RCT(371)*V(214)
  A(372) = RCT(372)*V(215)
  A(373) = RCT(373)*V(221)
  A(374) = RCT(374)*V(217)
  A(375) = RCT(375)*V(216)
  A(376) = RCT(376)*V(203)
  A(377) = RCT(377)*V(278)
  A(378) = RCT(378)*V(191)
  A(379) = RCT(379)*V(251)
  A(380) = RCT(380)*V(235)
  A(381) = RCT(381)*V(222)
  A(382) = RCT(382)*V(201)
  A(383) = RCT(383)*V(240)
  A(384) = RCT(384)*V(200)
  A(385) = RCT(385)*V(208)
  A(386) = RCT(386)*V(208)
  A(387) = RCT(387)*V(183)
  A(388) = RCT(388)*V(180)
  A(389) = RCT(389)*V(192)
  A(390) = RCT(390)*V(192)
  A(391) = RCT(391)*V(241)
  A(392) = RCT(392)*V(248)
  A(393) = RCT(393)*V(211)

! Aggregate function
  Vdot(1) = A(236)+A(295)+A(301)+A(307)+A(312)+A(317)+A(323)+A(329)
  Vdot(2) = 0.25*A(234)
  Vdot(3) = A(144)
  Vdot(4) = 0.35*A(276)
  Vdot(5) = A(13)+A(36)+A(44)+A(84)+A(91)+0.361*A(137)+0.5*A(148)+0.2*A(175)+0.2*A(176)+A(180)+2*A(183)+0.7*A(185)+2&
              &*A(186)+A(187)+A(188)+A(199)+A(205)+0.93*A(278)+0.93*A(279)+A(287)+0.5*A(289)+A(290)+A(291)
  Vdot(6) = A(6)
  Vdot(7) = A(10)
  Vdot(8) = A(15)
  Vdot(9) = A(25)
  Vdot(10) = A(27)
  Vdot(11) = A(44)
  Vdot(12) = A(46)
  Vdot(13) = A(49)
  Vdot(14) = A(50)
  Vdot(15) = A(52)
  Vdot(16) = A(53)
  Vdot(17) = A(54)
  Vdot(18) = A(55)
  Vdot(19) = A(56)
  Vdot(20) = A(57)
  Vdot(21) = A(59)
  Vdot(22) = A(60)
  Vdot(23) = A(62)
  Vdot(24) = A(63)
  Vdot(25) = A(64)
  Vdot(26) = A(68)
  Vdot(27) = A(72)
  Vdot(28) = A(74)
  Vdot(29) = A(81)
  Vdot(30) = A(90)
  Vdot(31) = A(91)
  Vdot(32) = A(130)
  Vdot(33) = A(131)
  Vdot(34) = A(132)
  Vdot(35) = A(176)
  Vdot(36) = A(188)
  Vdot(37) = A(189)
  Vdot(38) = A(245)
  Vdot(39) = A(264)
  Vdot(40) = A(265)
  Vdot(41) = A(269)
  Vdot(42) = A(270)
  Vdot(43) = A(271)
  Vdot(44) = A(272)
  Vdot(45) = A(273)
  Vdot(46) = A(274)
  Vdot(47) = A(276)
  Vdot(48) = A(278)
  Vdot(49) = A(279)
  Vdot(50) = A(281)
  Vdot(51) = A(283)
  Vdot(52) = A(284)
  Vdot(53) = A(287)
  Vdot(54) = A(288)
  Vdot(55) = A(293)
  Vdot(56) = A(294)
  Vdot(57) = A(299)
  Vdot(58) = A(300)
  Vdot(59) = A(305)
  Vdot(60) = A(306)
  Vdot(61) = A(310)
  Vdot(62) = A(311)
  Vdot(63) = A(315)
  Vdot(64) = A(316)
  Vdot(65) = A(321)
  Vdot(66) = A(322)
  Vdot(67) = A(327)
  Vdot(68) = A(328)
  Vdot(69) = A(341)
  Vdot(70) = A(348)
  Vdot(71) = A(389)
  Vdot(72) = A(2)
  Vdot(73) = A(3)
  Vdot(74) = A(5)
  Vdot(75) = A(31)
  Vdot(76) = A(33)
  Vdot(77) = A(38)
  Vdot(78) = A(39)
  Vdot(79) = A(41)
  Vdot(80) = A(65)
  Vdot(81) = A(66)
  Vdot(82) = A(67)
  Vdot(83) = A(69)
  Vdot(84) = A(70)
  Vdot(85) = A(75)
  Vdot(86) = A(77)
  Vdot(87) = A(79)
  Vdot(88) = A(82)
  Vdot(89) = A(92)
  Vdot(90) = A(109)
  Vdot(91) = A(134)
  Vdot(92) = A(139)
  Vdot(93) = A(142)
  Vdot(94) = A(143)
  Vdot(95) = A(153)
  Vdot(96) = A(154)
  Vdot(97) = A(155)
  Vdot(98) = A(156)
  Vdot(99) = A(157)
  Vdot(100) = A(158)
  Vdot(101) = A(191)
  Vdot(102) = A(192)
  Vdot(103) = A(224)
  Vdot(104) = A(227)
  Vdot(105) = A(228)
  Vdot(106) = A(230)
  Vdot(107) = A(231)
  Vdot(108) = A(232)
  Vdot(109) = A(235)
  Vdot(110) = A(241)
  Vdot(111) = A(242)
  Vdot(112) = A(246)
  Vdot(113) = A(259)
  Vdot(114) = A(261)
  Vdot(115) = A(267)
  Vdot(116) = A(268)
  Vdot(117) = A(275)
  Vdot(118) = A(280)
  Vdot(119) = A(290)
  Vdot(120) = A(332)
  Vdot(121) = A(333)
  Vdot(122) = A(344)
  Vdot(123) = A(384)
  Vdot(124) = A(23)
  Vdot(125) = A(40)
  Vdot(126) = A(61)
  Vdot(127) = A(103)
  Vdot(128) = A(116)
  Vdot(129) = A(118)
  Vdot(130) = A(119)
  Vdot(131) = A(135)
  Vdot(132) = A(137)
  Vdot(133) = A(138)
  Vdot(134) = A(140)
  Vdot(135) = A(141)
  Vdot(136) = A(148)
  Vdot(137) = A(175)
  Vdot(138) = A(200)
  Vdot(139) = A(202)
  Vdot(140) = A(205)
  Vdot(141) = A(248)
  Vdot(142) = A(249)
  Vdot(143) = A(250)
  Vdot(144) = A(251)
  Vdot(145) = A(252)
  Vdot(146) = A(282)
  Vdot(147) = A(337)
  Vdot(148) = A(338)
  Vdot(149) = A(346)
  Vdot(150) = A(347)
  Vdot(151) = A(349)
  Vdot(152) = A(351)
  Vdot(153) = A(353)
  Vdot(154) = A(354)
  Vdot(155) = A(355)
  Vdot(156) = A(356)
  Vdot(157) = A(357)
  Vdot(158) = A(358)
  Vdot(159) = A(359)
  Vdot(160) = A(361)
  Vdot(161) = A(372)
  Vdot(162) = A(375)
  Vdot(163) = A(379)
  Vdot(164) = A(392)
  Vdot(165) = A(13)
  Vdot(166) = A(298)
  Vdot(167) = A(304)
  Vdot(168) = A(309)
  Vdot(169) = A(314)
  Vdot(170) = A(320)
  Vdot(171) = A(326)
  Vdot(172) = A(236)
  Vdot(173) = A(295)
  Vdot(174) = A(301)
  Vdot(175) = A(307)
  Vdot(176) = A(312)
  Vdot(177) = A(317)
  Vdot(178) = A(323)
  Vdot(179) = A(329)
  Vdot(180) = -A(255)-A(388)
  Vdot(181) = -A(256)
  Vdot(182) = -A(257)
  Vdot(183) = A(253)-A(387)
  Vdot(184) = A(173)-A(174)
  Vdot(185) = A(280)-A(281)
  Vdot(186) = A(86)-A(87)
  Vdot(187) = A(34)-A(35)-A(232)-A(345)
  Vdot(188) = -A(51)-A(82)
  Vdot(189) = A(42)-A(43)-A(348)
  Vdot(190) = A(26)-A(27)+0.5*A(230)-A(340)
  Vdot(191) = 0.41*A(130)-A(190)-A(378)
  Vdot(192) = A(225)-A(226)-A(389)-A(390)
  Vdot(193) = -A(233)-A(234)-A(235)
  Vdot(194) = -A(47)-A(48)-A(252)
  Vdot(195) = A(127)-A(166)-A(365)
  Vdot(196) = A(28)-A(29)-A(30)-A(341)-A(342)
  Vdot(197) = A(16)-A(19)-A(20)-A(336)
  Vdot(198) = A(128)-A(167)-A(366)
  Vdot(199) = A(104)-A(168)-A(367)
  Vdot(200) = A(238)+A(245)+A(258)-A(259)-A(261)-A(384)
  Vdot(201) = A(242)+A(244)-A(245)+0.5*A(259)+0.5*A(260)+0.5*A(261)+0.5*A(262)-A(382)
  Vdot(202) = A(239)-A(240)+A(248)+A(249)+A(250)+A(251)+A(252)-A(260)-A(262)
  Vdot(203) = 0.41*A(132)-A(181)-A(182)-A(376)
  Vdot(204) = 0.75*A(70)+0.41*A(131)-A(170)-A(370)
  Vdot(205) = 0.5*A(228)+0.13*A(269)+0.065*A(271)-A(291)
  Vdot(206) = -A(45)-A(191)-A(251)
  Vdot(207) = A(7)-A(9)+A(11)+A(296)+A(303)+A(308)+A(313)+A(319)+A(324)+A(330)-A(335)
  Vdot(208) = -A(244)+A(254)-A(258)-A(385)-A(386)
  Vdot(209) = A(129)-A(171)-A(369)
  Vdot(210) = A(106)-A(165)-A(364)
  Vdot(211) = -A(21)-A(22)+0.85*A(98)+0.85*A(99)-A(393)
  Vdot(212) = -A(36)+0.134*A(137)+A(138)+0.5*A(148)+0.074*A(175)+0.074*A(176)+0.31*A(269)+0.155*A(271)+0.65*A(276)+0.07&
                &*A(278)+0.07*A(279)+A(297)
  Vdot(213) = A(96)-A(169)+0.85*A(285)+0.5*A(289)-A(368)
  Vdot(214) = 0.88*A(100)-A(172)-A(173)-A(371)
  Vdot(215) = -A(177)+0.1*A(266)-A(372)
  Vdot(216) = A(102)-A(179)-A(180)+A(302)-A(375)
  Vdot(217) = 0.1*A(101)-A(178)-A(374)
  Vdot(218) = 0.654*A(177)+0.29*A(200)+0.29*A(264)-A(282)
  Vdot(219) = 0.17*A(200)+0.17*A(264)-A(286)-A(290)
  Vdot(220) = A(73)+A(78)+A(105)-A(163)-A(164)-A(363)
  Vdot(221) = 0.85*A(103)+0.5*A(271)+0.5*A(274)-A(275)-A(373)
  Vdot(222) = 0.047*A(57)-A(227)-A(268)-A(381)
  Vdot(223) = A(174)-A(175)-A(176)
  Vdot(224) = A(286)-A(287)-A(288)-A(289)
  Vdot(225) = 0.25*A(94)+0.25*A(95)+0.25*A(110)+0.25*A(111)+0.25*A(113)+0.24*A(114)+0.48*A(115)+0.25*A(116)+0.25*A(117)&
                &+0.15*A(118)+0.25*A(120)+0.25*A(122)-A(124)+0.3*A(185)
  Vdot(226) = 0.1*A(57)+0.113*A(199)-A(283)-A(284)-A(285)
  Vdot(227) = A(277)-A(278)-A(279)-A(280)+A(281)
  Vdot(228) = A(69)+A(88)-A(89)-A(135)-A(136)
  Vdot(229) = 0.044*A(153)-A(304)-A(305)-A(306)-A(307)-A(308)
  Vdot(230) = -A(84)+0.15*A(130)+0.5*A(148)+A(151)+A(152)+A(184)+A(195)+A(208)+A(209)+A(210)+A(211)+A(212)+A(213)+A(214)&
                &+A(215)+A(216)+A(217)+A(218)+A(219)+A(221)+0.08*A(278)+0.08*A(279)+A(325)
  Vdot(231) = 0.12*A(134)-A(320)-A(321)-A(322)-A(323)-A(324)-A(325)
  Vdot(232) = 0.055*A(192)-A(326)-A(327)-A(328)-A(329)-A(330)-A(331)
  Vdot(233) = 0.32*A(52)+A(63)-A(93)+0.16*A(110)+0.75*A(120)+0.791*A(168)+0.32*A(196)+A(203)+A(219)-A(250)-A(350)-A(351)&
                &+A(367)+0.32*A(377)
  Vdot(234) = 0.655*A(76)-A(77)-A(78)-A(79)
  Vdot(235) = 0.12*A(59)+0.61*A(227)+0.14*A(272)+0.07*A(274)-A(276)-A(380)
  Vdot(236) = 0.022*A(155)+0.055*A(192)-A(309)-A(310)-A(311)-A(312)-A(313)
  Vdot(237) = 0.12*A(134)+0.12*A(153)+0.12*A(154)+0.211*A(155)-A(293)-A(294)-A(295)-A(296)-A(297)
  Vdot(238) = -A(144)-A(153)-A(156)
  Vdot(239) = -A(133)-A(134)-A(139)+0.128*A(153)+A(358)
  Vdot(240) = A(237)-A(238)-2*A(241)-2*A(242)-A(243)-A(246)+A(247)-A(254)-A(383)+A(386)
  Vdot(241) = 0.07*A(57)+0.5*A(80)+0.25*A(121)-A(228)-A(267)-A(391)
  Vdot(242) = 0.12*A(154)-A(314)-A(315)-A(316)-A(317)-A(318)-A(319)
  Vdot(243) = 0.4*A(66)-A(71)-A(72)-A(73)-A(74)
  Vdot(244) = A(24)-A(25)+A(39)+A(41)+0.6*A(66)+A(82)+A(92)+A(109)+A(142)+A(143)+A(158)+A(189)+A(191)+0.5*A(230)+A(231)&
                &+2*A(232)+A(235)+A(258)+A(265)+A(270)+A(273)+A(284)+A(288)-A(339)
  Vdot(245) = A(48)-A(49)+0.05*A(52)-A(94)+0.03*A(110)-A(128)-A(149)-A(151)+0.36*A(167)+0.05*A(196)+A(252)+0.05*A(377)
  Vdot(246) = 0.5*A(58)+A(71)+0.94*A(72)+0.7*A(74)+0.7*A(75)+0.919*A(77)+0.7*A(79)+0.134*A(137)-A(140)-A(142)+0.275&
                &*A(175)+0.275*A(176)+0.216*A(200)+0.216*A(264)+0.48*A(283)+0.072*A(285)-A(354)-A(355)-A(356)
  Vdot(247) = A(182)-A(183)-A(184)-A(185)-2*A(186)-A(187)-A(188)-A(189)
  Vdot(248) = 0.5*A(62)+0.075*A(103)+0.375*A(119)+0.791*A(165)+0.5*A(205)+0.5*A(228)+0.15*A(269)+0.075*A(271)-A(292)&
                &-A(392)
  Vdot(249) = 0.066*A(153)-A(298)-A(299)-A(300)-A(301)-A(302)-A(303)
  Vdot(250) = -A(50)-A(95)-A(129)+A(133)-A(150)-A(152)+0.209*A(171)
  Vdot(251) = 0.15*A(60)+0.39*A(227)+0.07*A(269)+0.035*A(271)+0.26*A(272)+0.13*A(274)-A(277)-A(379)
  Vdot(252) = 0.6*A(66)-A(67)-A(68)-A(69)-A(70)+0.345*A(76)
  Vdot(253) = -A(62)-A(103)-A(119)+A(157)-A(205)-A(216)
  Vdot(254) = A(47)+0.18*A(52)-A(63)-A(104)+0.09*A(110)-A(120)+0.209*A(168)+0.18*A(196)-A(203)-A(219)+0.18*A(377)
  Vdot(255) = -A(81)-A(106)-A(122)+A(139)+0.209*A(165)-A(207)-A(218)
  Vdot(256) = -A(56)-A(99)+A(107)+A(109)-A(113)-A(198)-A(210)
  Vdot(257) = A(45)-A(46)+0.32*A(52)+A(90)-A(108)+0.16*A(110)-2*A(125)-2*A(126)-A(127)+0.44*A(131)+A(159)+0.36*A(166)&
                &+A(191)+0.32*A(196)-A(220)-A(221)+A(222)+A(251)+A(349)+0.85*A(352)+0.32*A(377)
  Vdot(258) = -A(116)+0.346*A(177)-A(200)-A(212)+A(263)-A(264)-A(265)-A(266)
  Vdot(259) = 0.5*A(58)+0.53*A(59)+0.578*A(101)+0.13*A(116)+0.36*A(117)-A(137)-A(138)+0.275*A(175)+0.275*A(176)+0.5&
                &*A(192)+0.234*A(200)+0.6*A(201)+0.5*A(228)+0.234*A(264)+0.9*A(266)+0.15*A(269)+0.075*A(271)+0.6*A(272)+0.3&
                &*A(274)+0.52*A(283)+0.078*A(285)+A(326)+A(327)+A(328)+A(329)+A(330)-A(353)+0.26*A(372)+0.7*A(374)+A(380)
  Vdot(260) = -A(59)-A(101)-A(117)+A(145)+0.054*A(153)+0.209*A(178)-A(201)-A(213)
  Vdot(261) = A(85)-A(86)+A(87)-A(90)+A(92)-A(131)-A(159)-A(161)+A(170)-A(222)+0.15*A(352)+A(360)
  Vdot(262) = A(21)-A(55)+A(93)-A(98)-A(112)-A(197)-A(209)+A(250)
  Vdot(263) = -A(54)+A(83)-A(97)-A(111)-A(204)-A(215)+0.612*A(275)
  Vdot(264) = 0.7*A(64)+0.7*A(65)-A(66)-A(75)-A(76)+1.2*A(80)+0.6*A(121)+0.7*A(206)
  Vdot(265) = -A(88)+A(89)-A(91)-A(132)+0.53*A(146)+A(158)-A(160)-A(162)+A(181)-A(223)
  Vdot(266) = A(233)+0.75*A(234)+A(235)-A(236)-A(295)-A(301)-A(307)-A(312)-A(317)-A(323)-A(329)
  Vdot(267) = A(22)+0.5*A(58)+0.35*A(59)+0.122*A(60)+0.5*A(62)+0.102*A(101)+0.075*A(103)+0.5*A(112)+0.29*A(116)+0.14&
                &*A(117)+0.255*A(118)+0.375*A(119)-A(141)-A(143)+A(147)+0.5*A(154)+0.88*A(155)+0.275*A(175)+0.275*A(176)+0.5&
                &*A(192)+0.234*A(200)+0.4*A(201)+0.143*A(202)+0.5*A(205)+0.234*A(264)+0.9*A(266)+0.65*A(276)+0.07*A(278)&
                &+0.07*A(279)+0.52*A(283)+0.078*A(285)+A(292)+A(309)+A(310)+A(311)+A(312)+A(313)+A(314)+A(315)+A(316)+A(317)&
                &+A(319)-A(357)+0.58*A(372)+0.3*A(374)+A(379)
  Vdot(268) = -A(64)-A(65)-2*A(80)-A(105)-A(121)+A(156)+0.36*A(164)-A(206)-A(217)
  Vdot(269) = -A(57)-A(58)-A(100)-A(114)-2*A(115)+A(144)+0.387*A(172)-A(199)-A(211)
  Vdot(270) = 0.123*A(57)+0.23*A(64)+0.23*A(65)+0.23*A(80)+0.3*A(114)+0.5*A(115)+0.115*A(121)+0.613*A(172)-A(192)+0.14&
                &*A(199)+0.23*A(206)-A(263)+0.29*A(371)+A(381)+A(391)
  Vdot(271) = A(5)+A(15)+A(17)+2*A(18)+A(20)-A(23)+A(37)-A(39)+0.05*A(40)+A(50)+0.39*A(54)+0.96*A(55)+0.66*A(57)+A(58)&
                &+0.35*A(59)+0.122*A(60)+0.5*A(62)+0.07*A(64)+0.07*A(65)+0.75*A(74)+0.75*A(75)+0.75*A(79)+0.07*A(80)+A(81)&
                &+0.5*A(91)+0.75*A(94)+1.25*A(95)+0.15*A(98)+0.12*A(100)+0.102*A(101)+0.075*A(103)+0.75*A(108)+0.75*A(110)&
                &+0.95*A(111)+0.5*A(112)+0.75*A(113)+1.22*A(114)+0.92*A(115)+0.95*A(116)+0.89*A(117)+1.255*A(118)+0.625&
                &*A(119)+0.75*A(120)+0.785*A(121)+1.25*A(122)+0.59*A(132)+0.5*A(134)+A(136)+0.732*A(137)+A(150)+0.709*A(153)&
                &+0.6*A(154)+0.12*A(155)+A(159)+2*A(160)+A(161)+A(162)+0.375*A(175)+0.375*A(176)+A(185)+0.445*A(192)+A(194)&
                &+A(195)+A(197)+0.747*A(199)+0.4*A(201)+0.143*A(202)+0.39*A(204)+0.5*A(205)+0.07*A(206)+A(207)+A(223)+A(227)&
                &+A(233)+A(235)-A(248)+0.65*A(269)+0.325*A(271)+0.4*A(272)+0.2*A(274)+0.35*A(276)+0.08*A(278)+0.08*A(279)&
                &+A(291)+A(293)+A(294)+A(295)+A(296)+A(336)-A(337)-A(338)+0.9*A(353)+A(356)+A(359)+A(361)+A(362)+A(369)+0.71&
                &*A(371)+0.3*A(374)+0.5*A(375)+A(376)+0.5*A(379)+A(389)+A(392)+A(393)
  Vdot(272) = -A(60)-A(61)-A(102)-A(118)+0.47*A(146)+A(179)-A(202)-A(214)
  Vdot(273) = A(268)-A(272)-A(273)-A(274)+0.193*A(275)
  Vdot(274) = A(267)-A(269)-A(270)-A(271)+0.193*A(275)
  Vdot(275) = 0.5*A(58)+0.728*A(60)+A(61)+0.16*A(95)+0.2*A(112)+0.18*A(116)+0.595*A(118)+A(135)-A(147)-A(148)+0.65&
                &*A(152)+0.791*A(171)+0.725*A(175)+0.725*A(176)+A(180)+A(183)+0.7*A(185)+2*A(186)+A(187)+A(188)+0.216*A(200)&
                &+0.857*A(202)+0.5*A(228)+0.216*A(264)+0.44*A(269)+0.22*A(271)+0.6*A(272)+0.3*A(274)+0.85*A(278)+0.85*A(279)&
                &+0.5*A(282)+0.48*A(283)+0.072*A(285)+A(331)-A(362)+0.36*A(372)+A(375)+A(379)
  Vdot(276) = A(51)-A(52)-A(53)+0.3*A(54)+A(82)-A(96)-A(110)+0.15*A(111)+0.209*A(169)-A(196)+0.3*A(204)-A(208)
  Vdot(277) = -A(40)-A(41)+A(46)+A(50)+0.32*A(52)+0.75*A(54)+0.93*A(56)+A(81)+0.5*A(95)+0.15*A(99)+0.75*A(108)+0.16&
                &*A(110)+0.38*A(111)+0.5*A(113)+0.5*A(122)+A(123)+2*A(125)+A(126)+0.5*A(134)+A(150)+0.1*A(154)+0.64*A(166)&
                &+0.32*A(196)+A(198)+0.75*A(204)+A(207)+A(220)+A(221)-A(249)+A(320)+A(321)+A(322)+A(323)+A(324)-A(346)&
                &-A(347)+A(365)+A(369)+A(370)+0.32*A(377)
  Vdot(278) = A(53)+0.04*A(55)+0.07*A(56)+A(67)+A(68)+A(71)+0.94*A(72)+0.7*A(74)+0.3*A(75)+0.934*A(77)+0.7*A(79)-A(83)&
                &+A(97)+0.25*A(119)+0.64*A(164)-A(377)
  Vdot(279) = 0.26*A(57)+0.035*A(64)+0.035*A(65)+0.035*A(80)+0.047*A(100)+0.18*A(114)+0.36*A(115)+0.018*A(121)-A(146)&
                &+0.3*A(153)-A(155)-A(157)-A(158)+0.294*A(199)+0.035*A(206)+A(298)+A(299)+A(300)+A(301)+A(303)-A(361)+0.285&
                &*A(371)
  Vdot(280) = 0.4*A(57)+0.035*A(64)+0.035*A(65)+0.035*A(80)+0.073*A(100)+0.28*A(114)+0.56*A(115)+0.018*A(121)-A(145)+0.2&
                &*A(153)-A(154)+0.453*A(199)+0.035*A(206)+A(304)+A(305)+A(306)+A(307)+A(308)-A(358)-A(359)-A(360)+0.425&
                &*A(371)
  Vdot(281) = 0.19*A(52)+0.187*A(101)-A(107)-A(109)+0.35*A(110)+0.25*A(113)+0.25*A(116)+0.25*A(117)+A(163)+0.791*A(178)&
                &+A(184)+0.19*A(196)+A(208)+A(209)+A(210)+A(211)+A(212)+A(213)+A(214)+0.34*A(269)+0.17*A(271)+0.5*A(282)&
                &+A(290)-A(352)+0.19*A(377)
  Vdot(282) = A(2)-A(3)+A(5)-A(8)+A(9)-A(10)-2*A(11)+A(12)+A(13)+A(15)-A(16)+2*A(18)+A(23)-A(28)+A(29)-A(31)+A(33)+A(36)&
                &+A(37)+A(39)+0.05*A(40)+A(46)+A(49)+A(50)+0.27*A(52)+0.783*A(57)+2*A(58)+0.35*A(59)+0.85*A(60)+A(63)+0.8&
                &*A(64)+0.8*A(65)+A(67)+A(68)-A(70)-A(73)+0.5*A(74)+0.5*A(75)+0.934*A(77)-A(78)+1.2*A(79)+0.8*A(80)+A(94)&
                &+A(95)-A(96)-A(97)-A(98)-A(99)-0.88*A(100)-0.898*A(101)-A(102)-0.925*A(103)-A(104)-A(105)-A(106)+A(108)&
                &+0.64*A(110)+0.5*A(111)+0.3*A(112)+0.5*A(113)+1.1*A(114)+1.28*A(115)+A(116)+0.64*A(117)+1.7*A(118)+0.375&
                &*A(119)+A(120)+0.9*A(121)+0.5*A(122)+A(123)+A(124)+2*A(125)-A(127)-A(128)-A(129)-A(130)-A(131)-A(132)+0.28&
                &*A(134)+0.773*A(137)+A(140)+A(142)+A(147)+A(149)+A(150)+0.308*A(153)+0.28*A(154)+0.317*A(155)+A(159)+A(160)&
                &-0.175*A(175)+0.825*A(176)+0.7*A(185)-A(187)+0.445*A(192)+A(194)+0.27*A(196)+0.887*A(199)+A(200)+0.4*A(201)&
                &+0.85*A(202)+A(203)+0.5*A(205)+0.8*A(206)+A(220)-A(229)+A(236)-A(238)-A(239)+A(246)+A(248)+A(264)-0.1&
                &*A(266)+0.35*A(269)-0.825*A(271)+0.4*A(272)-0.8*A(274)-A(279)+A(282)+A(283)-0.85*A(285)+A(287)-0.5*A(289)&
                &+A(290)+A(333)+A(336)+2*A(337)+A(342)+A(346)+A(349)+1.73*A(353)+2*A(354)+A(357)+A(359)+A(361)+A(362)+A(363)&
                &+A(364)+A(365)+A(366)+A(367)+A(368)+A(369)+A(370)+A(371)+A(372)+A(373)+0.3*A(374)+A(375)+0.27*A(377)+A(379)&
                &+A(381)+A(389)+A(391)
  Vdot(283) = -A(237)-A(239)+A(240)+2*A(241)+A(243)-A(244)+A(245)+A(246)-A(247)-A(248)-A(249)-A(250)-A(251)-A(252)&
                &-A(253)+3*A(255)+2*A(256)+A(257)+2*A(382)+A(383)+A(384)+A(385)+A(387)+3*A(388)
  Vdot(284) = -A(5)+A(14)-A(15)-A(16)-2*A(17)-2*A(18)+A(19)+A(44)+0.18*A(52)-A(74)-A(79)+A(84)+0.5*A(91)-A(94)-A(95)&
                &-A(108)-0.91*A(110)-A(111)-A(112)-A(113)-A(114)-A(116)-A(117)-A(118)-A(119)-A(120)-A(121)-A(122)+0.44&
                &*A(130)+0.39*A(132)+0.28*A(134)+0.5*A(148)+A(149)+A(150)+0.051*A(153)-A(159)-A(160)-A(161)-A(162)+A(183)&
                &-A(185)+2*A(193)-A(195)+A(196)+A(197)+A(198)+A(199)+A(200)+A(201)+A(202)+A(203)+A(204)+A(205)+A(206)+A(207)&
                &+A(220)+A(222)+A(223)-A(225)+A(226)+A(233)+A(234)+A(235)+A(318)+0.88*A(346)+0.3*A(348)+A(350)+2*A(351)+0.15&
                &*A(352)+A(360)+0.18*A(377)+A(378)+A(390)+A(392)
  Vdot(285) = -A(1)-A(2)-A(3)-A(4)-A(5)+A(6)+0.25*A(70)-A(75)+0.15*A(130)+0.15*A(131)+0.15*A(132)-A(134)-A(136)-A(153)&
                &-A(154)-A(155)-A(192)-A(227)-A(228)-A(237)-A(290)-A(332)-A(333)+A(334)+A(343)+A(383)
  Vdot(286) = -A(1)-A(10)-A(15)-A(26)-A(32)+A(38)-A(44)-A(46)-A(49)-A(50)-A(52)-A(53)-A(54)-A(55)-A(56)-A(57)-A(59)&
                &-A(60)-A(62)-A(63)-A(64)-A(68)-A(72)-A(77)-A(81)-A(90)-A(91)-A(176)-A(188)-A(189)-A(243)-A(264)-A(265)&
                &-A(269)-A(270)-A(272)-A(273)-A(278)-A(283)-A(284)-A(287)-A(288)-A(293)-A(299)-A(305)-A(310)-A(315)-A(321)&
                &-A(327)+A(334)+A(340)+A(344)
  Vdot(287) = A(1)-A(4)+A(10)+A(15)-A(24)+A(27)-A(28)+A(29)+A(30)+A(31)+2*A(32)+A(33)-A(34)+A(35)-A(42)+A(43)+A(44)&
                &+A(46)+A(49)+A(50)+A(52)+2*A(54)+0.96*A(55)+0.93*A(56)+0.883*A(57)+0.88*A(59)+0.85*A(60)+1.5*A(62)+A(63)&
                &+1.3*A(64)+1.3*A(65)+A(67)+A(68)-A(69)+2*A(71)+1.88*A(72)+0.7*A(74)+0.7*A(75)+0.3*A(80)+2*A(81)-A(86)+A(87)&
                &-A(88)+A(89)+A(90)+A(91)+0.075*A(103)+A(111)+0.375*A(119)+0.15*A(121)+A(122)+A(135)+A(163)+A(176)+A(188)&
                &+A(204)+0.5*A(205)+0.3*A(206)+A(207)+A(215)+A(216)+A(217)+A(218)+2*A(224)-A(225)+A(226)-A(230)+A(243)&
                &+A(247)-A(253)-A(254)+A(264)+1.34*A(269)+0.17*A(271)+1.6*A(272)+0.3*A(274)+1.85*A(278)+0.85*A(279)-A(280)&
                &+A(281)+A(283)+A(287)+A(291)+A(292)+A(293)-A(294)+A(299)-A(300)+A(305)-A(306)+A(310)-A(311)+A(315)-A(316)&
                &+A(321)-A(322)+A(327)-A(328)-A(334)+A(339)+A(342)+A(343)+A(345)+0.7*A(348)+A(363)+A(364)+A(373)+A(377)&
                &+A(379)+A(380)+A(381)+A(386)+A(387)+A(390)+A(391)+A(392)
  Vdot(288) = -A(2)+A(3)-2*A(6)-2*A(7)-A(8)-A(9)+A(10)-A(12)-A(13)-A(14)-A(19)-A(21)-A(23)-A(24)-A(25)-A(26)-A(27)-A(30)&
                &+A(31)-A(33)-A(36)-A(37)-A(40)-A(45)-A(47)-A(48)-A(51)+A(58)+A(61)+0.5*A(62)-A(76)-A(83)-A(84)-A(85)-A(93)&
                &+0.15*A(98)+0.15*A(99)+0.12*A(100)+0.68*A(101)+0.15*A(103)-A(107)-A(123)-A(124)+0.44*A(130)+0.44*A(131)&
                &+0.44*A(132)-A(133)+0.36*A(134)-A(135)-0.773*A(137)-A(140)-A(141)-A(144)-A(145)-A(146)-A(147)+0.315*A(153)&
                &+0.36*A(154)+0.415*A(155)-0.36*A(164)-0.209*A(165)-0.36*A(166)-0.36*A(167)-0.209*A(168)-0.209*A(169)-A(170)&
                &-0.209*A(171)-0.387*A(172)-A(174)+1.125*A(175)+0.125*A(176)-0.346*A(177)-0.209*A(178)-A(179)-A(181)-A(182)&
                &+A(183)+0.7*A(185)+2*A(186)+2*A(187)+A(188)-A(190)+0.89*A(192)+0.27*A(227)+0.27*A(228)-A(233)-A(234)-A(236)&
                &-A(240)-A(245)-A(246)-A(255)-A(256)-A(257)-A(263)+0.9*A(266)-A(267)-A(268)+0.5*A(271)+0.5*A(274)-0.388&
                &*A(275)-A(276)-A(277)+A(279)-A(282)+0.15*A(285)-A(286)+0.5*A(289)+A(290)-A(291)-A(292)+2*A(332)+A(333)+2&
                &*A(335)+A(336)+A(339)+A(340)+A(341)+0.07*A(353)+A(363)+A(364)+A(365)+A(366)+A(367)+A(368)+A(369)+A(370)&
                &+A(371)+A(372)+A(373)+A(374)+A(375)+A(376)+A(378)+A(384)+A(393)
  Vdot(289) = A(4)+A(25)-A(31)-A(32)-A(33)-A(34)+A(35)-A(38)-A(39)-A(41)-A(65)-A(66)-A(67)-A(71)-A(82)-A(92)-A(109)&
                &+A(136)-A(139)-A(142)-A(143)-A(156)-A(157)-A(158)-A(191)-2*A(224)-A(231)-A(235)+A(244)-A(247)+0.31*A(269)&
                &+0.155*A(271)+A(276)+0.15*A(278)+0.15*A(279)+A(294)+A(300)+A(306)+A(311)+A(316)+A(322)+A(328)+A(341)-A(343)&
                &-A(344)+A(345)+0.3*A(348)+A(385)+A(389)
  Vdot(290) = -A(13)+A(23)+A(39)+0.05*A(40)+0.728*A(60)+A(61)+0.5*A(62)+A(67)+A(68)+0.5*A(91)+0.075*A(103)+0.33*A(116)&
                &+0.595*A(118)+0.375*A(119)+0.39*A(132)+0.56*A(134)+A(135)+0.505*A(137)+A(138)+2*A(140)+A(141)+2*A(142)&
                &+A(143)+0.5*A(148)+0.512*A(153)+0.56*A(154)+0.767*A(155)+0.251*A(175)+0.251*A(176)+0.89*A(192)+0.09*A(200)&
                &+0.857*A(202)+0.5*A(205)+A(248)+A(249)+A(250)+A(251)+A(252)+0.09*A(264)+1.5*A(282)-A(298)-A(304)-A(309)&
                &-A(314)-A(320)-A(326)+A(337)+A(338)+0.88*A(346)+A(347)+A(349)+A(351)+A(353)+2*A(354)+2*A(355)+A(356)+A(357)&
                &+A(358)+A(359)+A(361)+0.67*A(372)+0.5*A(375)+0.5*A(379)+A(392)
  Vdot(291) = 0.95*A(40)+A(41)-A(42)+A(43)-A(44)+0.96*A(55)+0.93*A(56)+0.53*A(59)+0.5*A(91)+0.15*A(98)+0.15*A(99)+0.578&
                &*A(101)+0.3*A(112)+0.5*A(113)+0.36*A(117)-A(130)+A(136)+A(141)+A(143)-A(149)-A(150)-A(151)-A(152)+0.158&
                &*A(153)+0.28*A(154)+0.099*A(155)+A(160)-A(183)-A(184)+A(190)+0.445*A(192)-2*A(193)-A(194)-A(195)-A(196)&
                &-A(199)-A(200)-0.4*A(201)-A(202)-A(203)-A(204)-A(205)-A(206)-A(207)-A(208)-A(209)-A(210)-A(211)-A(212)&
                &-A(213)-A(214)-A(215)-A(216)-A(217)-A(218)-A(219)-A(220)-A(221)-A(222)+A(249)+A(318)+0.12*A(346)+0.7*A(348)&
                &+A(350)+0.85*A(352)+A(357)+A(359)+A(361)+A(362)+0.7*A(374)+A(376)+A(380)+A(393)
  Vdot(292) = A(49)+0.13*A(52)+0.57*A(54)-A(85)-A(92)+0.75*A(94)+0.09*A(95)+0.033*A(101)+0.07*A(110)+0.54*A(111)+0.25&
                &*A(122)+A(124)+A(149)+A(151)+0.35*A(152)+0.64*A(167)+0.791*A(169)+0.13*A(196)+0.09*A(200)+0.57*A(204)&
                &+A(215)+A(216)+A(217)+A(218)+0.09*A(264)+A(287)+0.5*A(289)-A(349)+A(363)+A(364)+A(366)+A(368)+A(373)+0.13&
                &*A(377)
      
END SUBROUTINE Fun

! End of Fun function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE gckpp_Function

