/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class EIDSInstaller
extends Installer {
    public static final String OS_NAME = "os.name";
    public static final String EIDS_DIST_URL = "http://www.isti2.com/QWIDS/current_dist";
    public static final String EIDS_INSTALLER_VERSION = "EIDS Installer v0.53 (2009/08/18)";
    public static final int DEFAULT_SERVER_PORT = 39977;
    public static final int DEFAULT_NOTIF_PORT = 39988;
    public static final String JAR_FILE = "jar_file";
    public static final String CONFIG_FILE = "config_file";
    public static final String SERVER_ADDRESS = "server_address";
    public static final String SERVER_PORT = "server_port";
    public static final String NOTIF_PORT = "notif_port";
    public static final String ALTERNATES = "alternates";
    public static final String DEFAULT_INSTALL_DIRECTORY = "EIDS";
    public static final String GENERIC_INIT_RESOURCE = "etc/generic_init.sh";
    public static final String GENERIC_INIT = "bin/generic_init.sh";
    public static final String URL_SEPARATOR = "/";
    public static final String FILE_SEPARATOR = File.separator;
    protected final String[] args;
    public static final String ARG_INSTALL_CUBE_CLIENT = "--cubeClient";
    public static final String ARG_INSTALL_EQXML_CLIENT = "--xmlClient";
    public static final String ARG_INSTALL_SERVER = "--server";

    public EIDSInstaller(String[] args) {
        super(args);
        this.args = args;
        if (this.getInstallDirectory() == null) {
            this.setInstallDirectory(new File(DEFAULT_INSTALL_DIRECTORY));
        }
        this.setProperty(NOTIF_PORT, Integer.toString(39988));
        this.setProperty(SERVER_PORT, Integer.toString(39977));
    }

    public final void installWindowsBatchFile(String resource, String destination) throws IOException {
        File windowsBatch = new File(this.getInstallDirectory(), destination);
        this.installCustomResource(resource, windowsBatch);
        System.out.println(EIDSInstaller.getAnsiBold("INFO: Windows batch script is  " + windowsBatch.getAbsolutePath()));
    }

    public final void installUnixInitScript(String resource, String destination) throws IOException {
        File installDirectory = this.getInstallDirectory();
        File genericInitScript = new File(installDirectory, GENERIC_INIT);
        this.install(this.getResource(GENERIC_INIT_RESOURCE), genericInitScript, true);
        this.makeExecutable(genericInitScript);
        File initScript = new File(installDirectory, destination);
        this.installCustomResource(resource, initScript, true);
        this.makeExecutable(initScript);
        System.out.println(EIDSInstaller.getAnsiBold("INFO: UNIX init script is " + initScript.getAbsolutePath()));
    }

    public final void setServers(List servers) {
        InetSocketAddress primary = (InetSocketAddress)servers.remove(0);
        this.setProperty(SERVER_ADDRESS, primary.getHostName());
        this.setProperty(SERVER_PORT, Integer.toString(primary.getPort()));
        this.setProperty(ALTERNATES, EIDSInstaller.serverListToString(servers));
        servers.add(0, primary);
    }

    public static List promptServers() {
        LinkedList<InetSocketAddress> servers = new LinkedList<InetSocketAddress>();
        do {
            InetSocketAddress server;
            if ((server = Prompt.promptServer("", 39977)) == null) continue;
            servers.add(server);
        } while (Prompt.promptYesNo("Enter a backup server?", false));
        return servers;
    }

    public static String serverListToString(List servers) {
        StringBuffer buf = new StringBuffer();
        Iterator i = servers.iterator();
        while (i.hasNext()) {
            InetSocketAddress server = (InetSocketAddress)i.next();
            buf.append(server.getHostName()).append(":").append(server.getPort());
            if (!i.hasNext()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public String getArgList() {
        return "(--cubeClient|--xmlClient|--server) " + super.getArgList();
    }

    public String getArgUsage() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.getArgUsage());
        buf.append("\tDefault is a directory named EIDS in the current working directory.\n\n");
        buf.append("--cubeClient\tInstall CUBE client (for QDDS users who receive messages)\n");
        buf.append("--server\tInstall EIDS server (for QDDS users who send messages)\n");
        buf.append("--xmlClient\tInstall EQXML client.\n");
        return buf.toString();
    }

    public void install(boolean updateOnly) throws IOException {
        boolean installed = false;
        for (int i = 0; i < this.args.length; ++i) {
            String arg = this.args[i];
            if (ARG_INSTALL_SERVER.equals(arg)) {
                EIDSServerInstaller.main(this.args);
                installed = true;
                continue;
            }
            if (ARG_INSTALL_EQXML_CLIENT.equals(arg)) {
                EIDSEQXMLClientInstaller.main(this.args);
                installed = true;
                continue;
            }
            if (!ARG_INSTALL_CUBE_CLIENT.equals(arg)) continue;
            EIDSCubeClientInstaller.main(this.args);
            installed = true;
        }
        if (!installed) {
            System.out.println(this.getUsage());
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println(Installer.getAnsiBold(EIDS_INSTALLER_VERSION));
        new EIDSInstaller(args).run();
    }
}

