/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public class Installer
extends Properties {
    public static final String JAVA_VERSION = "java.version";
    public static final String INSTALL_NAME = "install_name";
    public static final String INSTALL_DATE = "install_date";
    public static final String INSTALL_DIRECTORY = "install_dir";
    public static final int BUFFER_SIZE = 4096;
    public static final String STATUS_BAR = "0%.........25%.........50%.........75%........100%";
    public static final String ARG_INSTALL = "--install";
    public static final String ARG_UPDATE = "--update";
    private static boolean windows = false;
    private boolean installing = false;
    private boolean updating = false;
    static /* synthetic */ Class class$Installer;

    public Installer(String[] args) {
        String installDirectory = null;
        this.setProperty(INSTALL_DATE, new Date().toString());
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals(ARG_INSTALL)) {
                this.installing = true;
                continue;
            }
            if (arg.equals(ARG_UPDATE)) {
                this.updating = true;
                continue;
            }
            if (arg.startsWith("-")) continue;
            installDirectory = arg;
        }
        if (installDirectory != null) {
            this.setProperty(INSTALL_DIRECTORY, new File(installDirectory).getAbsolutePath());
        }
    }

    public static boolean isWindows() {
        return windows;
    }

    public final File getInstallDirectory() {
        String path = this.getProperty(INSTALL_DIRECTORY);
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    public final void setInstallDirectory(File directory) {
        this.setProperty(INSTALL_DIRECTORY, directory.getAbsolutePath());
    }

    public final String getInstallName() {
        return this.getProperty(INSTALL_NAME);
    }

    public final void setInstallName(String name) {
        this.setProperty(INSTALL_NAME, name);
    }

    public final void run() throws IOException {
        if (this.installing) {
            this.install(false);
        } else if (this.updating) {
            this.install(true);
        } else {
            System.out.println(this.getUsage());
            System.exit(1);
        }
    }

    public final String getUsage() {
        StringBuffer buf = new StringBuffer();
        buf.append("USAGE:\n\tjava -jar JARFILE ").append(this.getArgList()).append("\n\n");
        buf.append(this.getArgUsage());
        buf.append("\n");
        return buf.toString();
    }

    public void install(boolean updateOnly) throws IOException {
    }

    public String getArgList() {
        return "[(--install|--update) [<directory>]]";
    }

    public String getArgUsage() {
        StringBuffer buf = new StringBuffer();
        buf.append("--install\tDownload and Configure\n");
        buf.append("--update\tDownload only\n");
        buf.append("<directory>\tInstall location\n");
        buf.append("\tFiles will be placed INTO the specified directory, NOT a sub directory\n");
        return buf.toString();
    }

    public final URL getResource(String path) {
        return (class$Installer == null ? (class$Installer = Installer.class$("Installer")) : class$Installer).getClassLoader().getResource(path);
    }

    public final URL getDownload(String url) {
        try {
            return new URL(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    public final void install(URL from, File to) throws IOException {
        this.install(from, to, false);
    }

    public final void install(URL from, File to, boolean replace) throws IOException {
        if (to.exists() && !replace) {
            return;
        }
        if (from == null) {
            return;
        }
        InputStream in = null;
        int contentLength = -1;
        long lastModified = 0L;
        if (from.toString().startsWith("http")) {
            HttpURLConnection conn = (HttpURLConnection)from.openConnection();
            conn.setIfModifiedSince(to.lastModified());
            conn.connect();
            if (conn.getResponseCode() == 304) {
                System.out.println("Not Modified");
                conn.disconnect();
                return;
            }
            contentLength = conn.getContentLength();
            lastModified = conn.getLastModified();
            in = conn.getInputStream();
        } else {
            in = from.openStream();
        }
        File parent = to.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        File temp = File.createTempFile(to.getName(), "download", parent);
        temp.deleteOnExit();
        this.transferStream(in, new FileOutputStream(temp), contentLength);
        temp.renameTo(to);
        if (lastModified != 0L) {
            to.setLastModified(lastModified);
        }
    }

    public final void installCustomResource(String name, File to) throws IOException {
        this.installCustomResource(name, to, false);
    }

    public final void installCustomResource(String name, File to, boolean replace) throws IOException {
        if (to.exists() && !replace) {
            return;
        }
        URL resource = this.getResource(name);
        if (resource == null) {
            return;
        }
        File parent = to.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        String content = this.customize(new String(this.readStream(resource.openStream())));
        this.transferStream(new ByteArrayInputStream(content.getBytes()), new FileOutputStream(to));
    }

    public final String customize(String content) {
        String r = content;
        Enumeration<?> keys = this.propertyNames();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            String replaceKey = "%(" + key.toUpperCase() + ")";
            r = this.stringReplace(replaceKey, this.getProperty(key), r);
        }
        return r;
    }

    public final byte[] readStream(InputStream inStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.transferStream(inStream, baos);
        return baos.toByteArray();
    }

    public final void transferStream(InputStream inStream, OutputStream outStream) throws IOException {
        this.transferStream(inStream, outStream, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void transferStream(InputStream inStream, OutputStream outStream, int expectedLength) throws IOException {
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        IOException ioe = null;
        int readTotal = 0;
        int lastPercent = 0;
        try {
            int read;
            in = new BufferedInputStream(inStream);
            out = new BufferedOutputStream(outStream);
            byte[] buffer = new byte[4096];
            while ((read = in.read(buffer, 0, 4096)) != -1) {
                ((BufferedOutputStream)out).write(buffer, 0, read);
                if (expectedLength <= 0) continue;
                int percentComplete = (readTotal += read) * 100 / expectedLength;
                while (lastPercent < percentComplete) {
                    if (++lastPercent % 2 != 0) continue;
                    System.out.print(STATUS_BAR.charAt(lastPercent / 2 - 1));
                }
            }
        }
        catch (IOException e) {
            ioe = e;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
            try {
                out.close();
            }
            catch (Exception e) {}
        }
        if (expectedLength > 0) {
            System.out.println();
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public final void requireJavaVersion(String minVersion) {
        String version = System.getProperty(JAVA_VERSION);
        if (version.startsWith(minVersion) || minVersion.compareTo(version) > 0) {
            System.err.println("INFO: Java version " + version);
        } else {
            System.err.println("ERROR: Incompatible version of java; " + minVersion + " or newer required.");
            System.exit(1);
        }
    }

    public final void makeExecutable(File toChmod) {
        try {
            Runtime.getRuntime().exec(new String[]{"chmod", "+x", toChmod.getAbsolutePath()});
        }
        catch (Exception e) {
            System.err.println("Unable to make executable: " + toChmod.toString());
        }
    }

    public void startSection(String name) {
        this.startSection(name, false);
    }

    public void startSection(String name, boolean first) {
        System.out.println();
        System.out.println(name);
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            System.out.print("=");
        }
        System.out.println();
    }

    public static String getAnsiBold(String toBold) {
        if (Installer.isWindows()) {
            return toBold;
        }
        return "\u001b[1m" + toBold + "\u001b[m";
    }

    public String stringReplace(String toReplace, String replacement, String string) {
        StringBuffer buf = new StringBuffer();
        int lastIndex = 0;
        int length = string.length();
        int replaceLength = toReplace.length();
        while (lastIndex < length) {
            int index = string.indexOf(toReplace, lastIndex);
            if (index == -1) {
                buf.append(string.substring(lastIndex));
                break;
            }
            buf.append(string.substring(lastIndex, index));
            buf.append(replacement);
            lastIndex = index + replaceLength;
        }
        return buf.toString();
    }

    private void ansiStatusBar(int percentComplete) {
        this.ansiStatusBar(percentComplete, 55);
    }

    private void ansiStatusBar(int percentComplete, int width) {
        System.out.print("\u001b[s");
        System.out.print("\u001b[255C\u001b[" + width + "D");
        System.out.print("[ ");
        StringBuffer buf = new StringBuffer();
        int barWidth = width - 5;
        for (int i = 0; i < barWidth; ++i) {
            if (100 * i / barWidth < percentComplete) {
                buf.append("#");
                continue;
            }
            buf.append(" ");
        }
        System.out.print(this.centerPercentInString(percentComplete, buf.toString()));
        System.out.print(" ] ");
        System.out.print("\u001b[u");
    }

    private String centerPercentInString(int percent, String str) {
        String percentString = " " + percent + "% ";
        int percentLength = percentString.length();
        int strLength = str.length();
        int offset = (strLength - percentLength) / 2;
        StringBuffer buf = new StringBuffer();
        buf.append(str.substring(0, offset));
        buf.append(percentString);
        buf.append(str.substring(buf.toString().length()));
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (System.getProperty("os.name", "none").toLowerCase().indexOf("windows") > -1) {
            windows = true;
        }
    }
}

