/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.util.List;

class Prompt {
    Prompt() {
    }

    public static String prompt(String message) {
        String response = null;
        if (message != null) {
            System.out.print(message);
            System.out.print(": ");
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            response = br.readLine();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(1);
        }
        return response;
    }

    public static String prompt(String message, String defaultAnswer) {
        String response = Prompt.prompt(message + " [" + defaultAnswer + "]");
        if ("".equals(response)) {
            response = defaultAnswer;
        }
        return response;
    }

    public static boolean promptYesNo(String message) {
        String response;
        String yesNoPrompt = message + " (y|n)";
        while (!(response = Prompt.prompt(yesNoPrompt).trim().toUpperCase()).startsWith("Y") && !response.startsWith("N")) {
        }
        return response.startsWith("Y");
    }

    public static boolean promptYesNo(String message, boolean defaultAnswer) {
        String response;
        String yesNoPrompt = message + " (y|n)";
        while (!(response = Prompt.prompt(yesNoPrompt, defaultAnswer ? "Y" : "N").toUpperCase()).startsWith("Y") && !response.startsWith("N")) {
        }
        return response.startsWith("Y");
    }

    public static int promptSelect(String message, List options) {
        int choice;
        int numOptions = options.size();
        String selectionPrompt = "Enter selection (1-" + numOptions + ")";
        System.out.println(message);
        for (int i = 0; i < numOptions; ++i) {
            System.out.println("\t" + (i + 1) + ") " + options.get(i).toString());
        }
        do {
            String response = Prompt.prompt(selectionPrompt);
            try {
                choice = Integer.parseInt(response);
            }
            catch (NumberFormatException nfe) {
                choice = 0;
            }
        } while (choice < 1 || choice > numOptions);
        return choice - 1;
    }

    public static InetSocketAddress promptServer() {
        return Prompt.promptServer("", -1);
    }

    public static InetSocketAddress promptServer(String defaultHost, int defaultPort) {
        String hostPrompt = "Enter server hostname or ip address";
        String portPrompt = "Enter server port";
        String host = "".equals(defaultHost) ? Prompt.prompt(hostPrompt) : Prompt.prompt(hostPrompt, defaultHost);
        int port = defaultPort < 1 ? Prompt.promptInt(portPrompt) : Prompt.promptInt(portPrompt, defaultPort);
        return new InetSocketAddress(host, port);
    }

    public static int promptInt(String prompt) {
        while (true) {
            try {
                String response = Prompt.prompt(prompt);
                return Integer.parseInt(response);
            }
            catch (NumberFormatException nfe) {
                System.out.println("ERROR: integer required.");
                continue;
            }
            break;
        }
    }

    public static int promptInt(String prompt, int defaultValue) {
        while (true) {
            try {
                String response = Prompt.prompt(prompt, Integer.toString(defaultValue));
                return Integer.parseInt(response);
            }
            catch (NumberFormatException nfe) {
                System.out.println("ERROR: integer required.");
                continue;
            }
            break;
        }
    }
}

