/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;

public class EIDSServerInstaller
extends EIDSInstaller {
    public static final String SERVER_CONFIG_RESOURCE = "etc/server/server.xml";
    public static final String SERVER_CONFIG = "conf/server.xml";
    public static final String FEEDER_CONFIG_RESOURCE = "etc/server/feeders.xml";
    public static final String FEEDER_CONFIG = "conf/feeders.xml";
    public static final String RELAY_FEEDER_TEMPLATE_RESOURCE = "etc/server/relay_feeder_template.xml";
    public static final String SERVER_JAR_URL = "/QWServer/QWServer.jar";
    public static final String SERVER_JAR = "bin/QWServer.jar";
    public static final String NOTIF_JAR_URL = "/QWServer/ISTINotifServer.jar";
    public static final String NOTIF_JAR = "bin/ISTINotifServer.jar";
    public static final String SERVER_NAME = "server_name";
    public static final String FEEDER_NAME = "feeder_name";
    public static final String IP_ADDRESS = "ip_address";
    public static final String RELAY_FEEDERS = "relay_feeders";
    public static final String SERVER_INIT_RESOURCE = "etc/server/server_init.sh";
    public static final String SERVER_BATCH_RESOURCE = "etc/server/server_run.bat";
    public static final String SERVER_INIT = "server_init.sh";
    public static final String SERVER_BATCH = "server_run.bat";

    public EIDSServerInstaller(String[] args) {
        super(args);
    }

    public void install(boolean updateOnly) throws IOException {
        File installDir = this.getInstallDirectory();
        this.startSection("Downloading JARs", true);
        System.out.print("ISTINotifServer.jar\t");
        this.install(this.getDownload("http://www.isti2.com/QWIDS/current_dist/QWServer/ISTINotifServer.jar"), new File(installDir, NOTIF_JAR), true);
        System.out.print("QWServer.jar\t\t");
        this.install(this.getDownload("http://www.isti2.com/QWIDS/current_dist/QWServer/QWServer.jar"), new File(installDir, SERVER_JAR), true);
        if (updateOnly) {
            System.out.println();
            System.out.println("Update complete");
            return;
        }
        this.startSection("Configuring Server");
        File serverConfig = new File(installDir, SERVER_CONFIG);
        if (!serverConfig.exists() || Prompt.promptYesNo("WARNING: Server config file already exists!\n\t(" + serverConfig.getAbsolutePath() + ")\n" + "Replace existing config", false)) {
            InetAddress localhost = InetAddress.getLocalHost();
            String ipAddress = localhost.getHostAddress();
            String hostName = localhost.getCanonicalHostName();
            System.out.println();
            System.out.println("The IP Address/Hostname clients use to connect to this server.");
            System.out.println("You MAY use a hostname, but the hostname MUST be resolvable by all clients.");
            ipAddress = Prompt.prompt("Server IP Address", ipAddress);
            this.setProperty(IP_ADDRESS, ipAddress);
            System.out.println();
            System.out.println("Clients connecting to the server specify this port address.");
            System.out.println("\tNOTE: if the specified port value is less than 1024 then special");
            System.out.println("\toperating-system administrator privileges may be required to run.");
            int serverPort = Prompt.promptInt("QWServer port number", 39977);
            this.setProperty("server_port", Integer.toString(serverPort));
            System.out.println();
            System.out.println("The port number on which the notification server will run.");
            System.out.println("Clients must also be able to connect to this port.");
            int notifPort = Prompt.promptInt("Notification server port", 39988);
            this.setProperty("notif_port", Integer.toString(notifPort));
            System.out.println();
            System.out.println("The Server Name is sent to clients connecting to the server.");
            String serverName = Prompt.prompt("Server Name", hostName);
            this.setProperty(SERVER_NAME, serverName);
            System.out.println();
            System.out.println("The Default Feeder Name is used by clients to detect duplicate messages.");
            System.out.println("This MUST be unique for each server.");
            String feederName = Prompt.prompt("Default Feeder Name", hostName);
            this.setProperty(FEEDER_NAME, feederName);
            this.installCustomResource(SERVER_CONFIG_RESOURCE, serverConfig, true);
            System.out.println(EIDSServerInstaller.getAnsiBold("\nINFO: Server config file is " + serverConfig.getAbsolutePath()));
        } else {
            System.out.println("Not modified");
        }
        this.startSection("Configuring Server Feeders");
        File feederConfig = new File(installDir, FEEDER_CONFIG);
        if (!feederConfig.exists() || Prompt.promptYesNo("WARNING: Feeder config file already exists!\n\t(" + feederConfig.getAbsolutePath() + ")\n" + "Replace existing config", false)) {
            System.out.println();
            System.out.println("By default, a file feeder is configured to read messages from the directory");
            System.out.println("\tpolldir every 5 seconds.");
            System.out.println("Relay feeders forward messages from other servers and are not configured by default.");
            StringBuffer relayFeederXML = new StringBuffer();
            String relayFeederTemplate = new String(this.readStream(this.getResource(RELAY_FEEDER_TEMPLATE_RESOURCE).openStream()));
            while (Prompt.promptYesNo("Add a relay feeder", false)) {
                this.setServers(EIDSInstaller.promptServers());
                relayFeederXML.append(this.customize(relayFeederTemplate));
            }
            this.setProperty(RELAY_FEEDERS, relayFeederXML.toString());
            this.installCustomResource(FEEDER_CONFIG_RESOURCE, feederConfig);
            System.out.println(EIDSServerInstaller.getAnsiBold("\nINFO: Feeder config file is " + feederConfig.getAbsolutePath()));
        } else {
            System.out.println("Not modified");
        }
        this.startSection("Installing Start Script");
        if (Installer.isWindows()) {
            this.installWindowsBatchFile(SERVER_BATCH_RESOURCE, SERVER_BATCH);
        } else {
            this.installUnixInitScript(SERVER_INIT_RESOURCE, SERVER_INIT);
        }
        System.out.println();
    }

    public static void main(String[] args) throws IOException {
        System.out.println("\n#########################");
        System.out.println("# EIDS Server Installer #");
        System.out.println("#########################");
        System.out.println("This program installs the EIDS QWServer and NotifServer,");
        System.out.println("which accepts both CUBE and EQXML messages, and is equivalent to a QDDS server.");
        System.out.println("http://www.isti2.com/QWIDS/current_dist/QWServer/doc/QWServer.html");
        new EIDSServerInstaller(args).run();
    }
}

