 subroutine set_eta(km, ks, ptop, ak, bk)

 implicit none
      integer,  intent(in)::  km           ! vertical dimension
      integer,  intent(out):: ks           ! number of pure p layers
      real, intent(out):: ak(km+1)
      real, intent(out):: bk(km+1)
      real, intent(out):: ptop         ! model top (Pa)
! local
      real a24(25),b24(25)            ! GFDL AM2L24
      real a32(33),b32(33)
      real a32w(33),b32w(33)
      real a48(49),b48(49)
      real a48x(49),b48x(49)
      real a55(56),b55(56)
      real a60(61),b60(61)
      real a64(65),b64(65)
      real a100(101),b100(101)
#ifdef MARS_GCM
      real:: p0= 6.0E2
      real:: pc= 1.0e-3
      real a36(37),b36(37)            ! For Mars GCM
      real a28(29),b28(29)            !  Mars 28 levels 
#else
      real:: p0=1000.E2
      real:: pc=200.E2
#endif MARS_GCM 
      real pt, pint, lnpe, dlnp
      real press(km+1)
      integer  k

! Definition: press(i,j,k) = ak(k) + bk(k) * ps(i,j)

#ifdef MARS_GCM
!------- Mars vertical levels -----------------------------

  data a28 /     &
       2.0000000e-02,5.7381273e-02,1.9583981e-01,5.9229580e-01, &
       1.5660228e+00,2.4454965e+00,2.7683755e+00,2.8851692e+00, &
       2.9172228e+00,2.9087039e+00,2.8598939e+00,2.7687652e+00, &
       2.6327054e+00,2.4509219e+00,2.2266811e+00,1.9684681e+00, &
       1.6894832e+00,1.4055812e+00,1.1324258e+00,8.8289177e-01, &
       6.6548467e-01,4.8401020e-01,3.3824119e-01,2.2510704e-01, &
       1.3995719e-01,7.7611554e-02,3.3085503e-02,2.0000000e-03, &
       0.0000000e+00  /

  data b28 /      &
       0.0000000e+00,0.0000000e+00,0.0000000e+00,0.0000000e+00, &
       0.0000000e+00,1.9366394e-03,7.4419133e-03,1.6227267e-02, &
       2.7075192e-02,4.3641000e-02,6.8106804e-02,1.0280240e-01, &
       1.4971954e-01,2.0987133e-01,2.8270233e-01,3.6581610e-01, &
       4.5520230e-01,5.4593599e-01,6.3310970e-01,7.1267629e-01, &
       7.8196151e-01,8.3977530e-01,8.8620345e-01,9.2223168e-01, &
       9.4934533e-01,9.6919618e-01,9.8337259e-01,9.9326941e-01, &
       1.0000000e+00  /


  data a36 /      &
  2.0000000000e-03,  6.3299931399e-03,  1.2501646444e-02, & 
  2.4215113043e-02,  4.6000346612e-02,  8.5702012910e-02, & 
  1.5659441036e-01,  2.8061882660e-01,  4.9318818941e-01, & 
  8.5008792314e-01,  1.4370449074e+00,  2.0054945771e+00, & 
  2.3335916338e+00,  2.5221957520e+00,  2.6264602874e+00, & 
  2.6762480591e+00,  2.6870173757e+00,  2.6657174771e+00, & 
  2.6140573091e+00,  2.5304052915e+00,  2.4110051828e+00, &
  2.2508885698e+00,  2.0446940567e+00,  1.8074358726e+00, & 
  1.5511877409e+00,  1.2904762231e+00,  1.0396626704e+00, & 
  8.1055438393e-01,  6.1095195817e-01,  4.4434410651e-01, & 
  3.1051916267e-01,  2.0665632614e-01,  1.2848513437e-01, & 
  7.1249514632e-02,  3.0373097709e-02,  2.1040298410e-16, & 
  0.0000000000e+00  /
  
  data b36 /      &
  0.0000000000e+00,  0.0000000000e+00,  0.0000000000e+00, & 
  0.0000000000e+00,  0.0000000000e+00,  0.0000000000e+00, & 
  0.0000000000e+00,  0.0000000000e+00,  0.0000000000e+00, & 
  0.0000000000e+00,  0.0000000000e+00,  6.2833541661e-04, & 
  2.5671934940e-03,  6.0923860938e-03,  1.1725248117e-02, & 
  2.0238695380e-02,  3.2676843179e-02,  5.0373898012e-02, & 
  7.4959525687e-02,  1.0833815470e-01,  1.5263019875e-01, & 
  2.1006506655e-01,  2.8281982789e-01,  3.6584598427e-01, & 
  4.5513763376e-01,  5.4577516959e-01,  6.3285639147e-01, & 
  7.1233851133e-01,  7.8155013540e-01,  8.3930250332e-01, & 
  8.8568132228e-01,  9.2167127115e-01,  9.4875609753e-01, & 
  9.6858585131e-01,  9.8274719475e-01,  9.9326941371e-01, & 
  1.0000000000e+00  /

#endif MARS_GCM 

!-----------------------------------------------
! GFDL AM2-L24: modified by SJL at the model top
!-----------------------------------------------
!     data a24 /  100.0000,  1050.0000,  3474.7942,  7505.5556, 12787.2428,   &
      data a24 /  100.0000,   903.4465,  3474.7942,  7505.5556, 12787.2428,   &
                19111.3683, 21854.9274, 22884.1866, 22776.3058, 21716.1604,   &
                20073.2963, 18110.5123, 16004.7832, 13877.6253, 11812.5452,   &
                 9865.8840,  8073.9726,  6458.0834,  5027.9899,  3784.6085,   &
                 2722.0086,  1828.9752,  1090.2396,   487.4595,     0.0000    /

      data b24 / 0.0000000, 0.0000000, 0.0000000, 0.0000000, 0.0000000,       &
                 0.0000000, 0.0435679, 0.1102275, 0.1922249, 0.2817656,       &
                 0.3694997, 0.4532348, 0.5316253, 0.6038733, 0.6695556,       &
                 0.7285176, 0.7808017, 0.8265992, 0.8662148, 0.9000406,       &
                 0.9285364, 0.9522140, 0.9716252, 0.9873523, 1.0000000        /
! High-resolution troposphere setup
! Revised Apr 14, 2004: PINT = 245.027 mb
      data a32/100.00000,     400.00000,     818.60211, &
              1378.88653,    2091.79519,    2983.64084, &
              4121.78960,    5579.22148,    7419.79300, &
              9704.82578,   12496.33710,   15855.26306, &
             19839.62499,   24502.73262,   28177.10152, &
             29525.28447,   29016.34358,   27131.32792, &
             24406.11225,   21326.04907,   18221.18357, &
             15275.14642,   12581.67796,   10181.42843, &
              8081.89816,    6270.86956,    4725.35001, &
              3417.39199,    2317.75459,    1398.09473, &
               632.49506,       0.00000,       0.00000  /

      data b32/0.00000,       0.00000,       0.00000, &
               0.00000,       0.00000,       0.00000, &
               0.00000,       0.00000,       0.00000, &
               0.00000,       0.00000,       0.00000, &
               0.00000,       0.00000,       0.01711, &
               0.06479,       0.13730,       0.22693, &
               0.32416,       0.42058,       0.51105, &
               0.59325,       0.66628,       0.73011, &
               0.78516,       0.83217,       0.87197, &
               0.90546,       0.93349,       0.95685, &
               0.97624,       0.99223,       1.00000  /

!---------------------
! Wilson's 32L settings:
!---------------------
! Top changed to 0.01 mb
      data a32w/  1.00,       26.6378,     84.5529,     228.8592,   & 
                539.9597,   1131.7087,   2141.8082,    3712.0454,   &
               5963.5317,   8974.1873,  12764.5388,   17294.5911,   &
              20857.7007,  22221.8651,  22892.7202,   22891.1641,   &
              22286.0724,  21176.0846,  19673.0671,   17889.0989,   &
              15927.5060,  13877.6239,  11812.5474,    9865.8830,   &
               8073.9717,   6458.0824,   5027.9893,    3784.6104,   &
               2722.0093,   1828.9741,   1090.2397,     487.4575,   &
               0.0000 /
         
      data b32w/ 0.0000,   0.0000,   0.0000,    0.0000,       &
                0.0000,   0.0000,   0.0000,    0.0000,       &
                0.0000,   0.0000,   0.0000,    0.0000,       &
                0.0159,   0.0586,   0.1117,    0.1734,       &
                0.2415,   0.3137,   0.3878,    0.4619,       &
                0.5344,   0.6039,   0.6696,    0.7285,       &
                0.7808,   0.8266,   0.8662,    0.9000,       &
                0.9285,   0.9522,   0.9716,    0.9874,       &
                1.0000 /

! High trop-resolution (Feb 2004)
           data a48x/                                &
                   1.00000,       2.69722,       5.17136,   &
                   8.89455,      14.24790,      22.07157,   &
                  33.61283,      50.48096,      74.79993,   &
                 109.40055,     158.00460,     225.44108,   &
                 317.89560,     443.19350,     611.11558,   &
                 833.74392,    1125.83405,    1505.20759,   &
                1993.15829,    2614.86254,    3399.78420,   &
                4382.06240,    5600.87014,    7100.73115,   &
                8931.78242,   11149.97021,   13817.16841,   &
               17001.20930,   20775.81856,   23967.33875,   &
               25527.64563,   25671.22552,   24609.29622,   &
               22640.51220,   20147.13482,   17477.63530,   &
               14859.86462,   12414.92533,   10201.44191,   &
                8241.50255,    6534.43202,    5066.17865,   &
                3815.60705,    2758.60264,    1870.64631,   &
                1128.33931,     510.47983,       0.00000,   &
                   0.00000  /

           data b48x/              &
                   0.00000,       0.00000,       0.00000,   &
                   0.00000,       0.00000,       0.00000,   &
                   0.00000,       0.00000,       0.00000,   &
                   0.00000,       0.00000,       0.00000,   &
                   0.00000,       0.00000,       0.00000,   &
                   0.00000,       0.00000,       0.00000,   &
                   0.00000,       0.00000,       0.00000,   &
                   0.00000,       0.00000,       0.00000,   &
                   0.00000,       0.00000,       0.00000,   &
                   0.00000,       0.00000,       0.01253,   &
                   0.04887,       0.10724,       0.18455,   &
                   0.27461,       0.36914,       0.46103,   &
                   0.54623,       0.62305,       0.69099,   &
                   0.75016,       0.80110,       0.84453,   &
                   0.88127,       0.91217,       0.93803,   &
                   0.95958,       0.97747,       0.99223,   &
                   1.00000   /

!     John Wilson 48 stratosphere 
      data a48/  0.2000,       0.4643,       1.1978,        2.8806,  &
                 6.4919,      13.7758,      27.6477,       52.6975,  &
                95.7569,     166.4702,     277.7878,      446.2903,  &
               692.2605,    1039.4396,    1514.4422,     2145.8457,  &
              2963.0124,    3994.7360,    5267.8238,     6805.7330,  &
              8627.3676,   10746.1233,   13169.2374,    15897.4710,  &
             18925.1187,   20785.0282,   21756.8874,    22456.5487,  &
             22864.2127,   22968.7603,   22767.3528,    22264.7045,  &
             21472.1263,   20406.4316,   19088.7860,    17543.5673,  &
             15797.2892,   13877.6239,   11812.5474,     9865.8830,  &
              8073.9717,    6458.0824,    5027.9893,     3784.6104,  &
              2722.0093,    1828.9741,    1090.2397,      487.4575,  &
                 0.0000 /


        data b48/       0.00000,   0.00000,   0.00000,    0.00000,   &
                        0.00000,   0.00000,   0.00000,    0.00000,   &
                        0.00000,   0.00000,   0.00000,    0.00000,   &
                        0.00000,   0.00000,   0.00000,    0.00000,   &
                        0.00000,   0.00000,   0.00000,    0.00000,   &
                        0.00000,   0.00000,   0.00000,    0.00000,   &
                        0.00000,   0.01436,   0.04016,    0.07108,   &
                        0.10707,   0.14795,   0.19344,    0.24318,   &
                        0.29672,   0.35358,   0.41326,    0.47522,   &
                        0.53893,   0.60387,   0.66956,    0.72852,   &
                        0.78080,   0.82660,   0.86621,    0.90004,   &
                        0.92854,   0.95221,   0.97163,    0.98735,   &
                        1.00000  /


      data a55/ 1.00000,     2.00000,       3.27000,       &
              4.75850,       6.60000,       8.93450,       &
             11.97030,      15.94950,      21.13490,       &
             27.85260,      36.50410,      47.58060,       &
             61.67790,      79.51340,     101.94420,       &
            130.05080,     165.07920,     208.49720,       &
            262.02120,     327.64330,     407.65670,       &
            504.68050,     621.68000,     761.98390,       &
            929.29430,    1127.68880,    1364.33920,       &
           1645.70720,    1979.15540,    2373.03610,       &
           2836.78160,    3380.99550,    4017.54170,       &
           4764.39320,    5638.79380,    6660.33770,       &
           7851.22980,    9236.56610,   10866.34270,       &
          12783.70000,   15039.30000,   17693.00000,       &
          20119.20876,   21686.49129,   22436.28749,       &
          22388.46844,   21541.75227,   19873.78342,       &
          17340.31831,   13874.44006,   10167.16551,       &
           6609.84274,    3546.59643,    1270.49390,       &
              0.00000,       0.00000   /

      data b55 /0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     & 
                0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     &
                0.00696,       0.02801,       0.06372,     &
                0.11503,       0.18330,       0.27033,     &
                0.37844,       0.51046,       0.64271,     &
                0.76492,       0.86783,       0.94329,     &
                0.98511,       1.00000  /

      data a60/                                                    &
               0.17861,      1.08051,      3.96471,       9.75160, &
              19.81658,     36.69595,     62.55057,      99.19962, &
             147.92505,    209.47487,    284.22571,     372.41721, &
             474.37835,    590.70236,    722.36063,     870.76746, &
            1037.81388,   1225.88773,   1437.89246,    1677.27266, &
            1948.05064,   2254.87627,   2603.09094,    2998.80592, &
            3448.99523,   3961.60289,   4545.66416,    5211.44017, &
            5970.56440,   6836.19818,   7823.19060,    8948.23510, &
           10230.01066,  11689.28975,  13348.98686,   15234.11106, &
           17371.57323,  19789.78458,  22005.56455,   23550.11512, &
           24468.58332,  24800.54880,  24582.44507,   23849.99962, &
           22640.51974,  20994.73715,  18957.84873,   16579.41323, &
           14080.07103,  11753.63092,   9651.69963,    7793.80093, &
            6176.90628,   4787.42760,   3605.04975,    2605.98607, &
            1766.83282,   1065.61312,    482.26201,       0.00000, &
               0.00000   / 

        data b60/                                       &
             0.00000,   0.00000,   0.00000,   0.00000,  &
             0.00000,   0.00000,   0.00000,   0.00000,  &
             0.00000,   0.00000,   0.00000,   0.00000,  &
             0.00000,   0.00000,   0.00000,   0.00000,  &
             0.00000,   0.00000,   0.00000,   0.00000,  &
             0.00000,   0.00000,   0.00000,   0.00000,  &
             0.00000,   0.00000,   0.00000,   0.00000,  &
             0.00000,   0.00000,   0.00000,   0.00000,  &
             0.00000,   0.00000,   0.00000,   0.00000,  &
             0.00000,   0.00000,   0.00506,   0.02008,  &
             0.04490,   0.07936,   0.12326,   0.17634,  &
             0.23820,   0.30827,   0.38581,   0.46989,  &
             0.55393,   0.62958,   0.69642,   0.75458,  &
             0.80463,   0.84728,   0.88335,   0.91368,  &
             0.93905,   0.96020,   0.97775,   0.99223,  &
             1.00000  /  

      data a64/1.00000,       3.90000,       8.70000,      &
              15.42000,      24.00000,      34.50000,      &
              47.00000,      61.50000,      78.60000,      &
              99.13500,     124.12789,     154.63770,      &
             191.69700,     236.49300,     290.38000,      &
             354.91000,     431.82303,     523.09300,      &
             630.92800,     757.79000,     906.45000,      &
            1079.85000,    1281.00000,    1515.00000,      &
            1788.00000,    2105.00000,    2470.00000,      &
            2889.00000,    3362.00000,    3890.00000,      &
            4475.00000,    5120.00000,    5830.00000,      &
            6608.00000,    7461.00000,    8395.00000,      &
            9424.46289,   10574.46880,   11864.80270,      &
           13312.58890,   14937.03710,   16759.70700,      &
           18804.78710,   21099.41210,   23674.03710,      &
           26562.82810,   29804.11720,   32627.31640,      &
           34245.89840,   34722.28910,   34155.19920,      &
           32636.50390,   30241.08200,   27101.44920,      &
           23362.20700,   19317.05270,   15446.17090,      &
           12197.45210,    9496.39941,    7205.66992,      &
            5144.64307,    3240.79346,    1518.62134,      &
               0.00000,       0.00000 /

      data b64/0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00813,      &
               0.03224,       0.07128,       0.12445,      &
               0.19063,       0.26929,       0.35799,      &
               0.45438,       0.55263,       0.64304,      &
               0.71703,       0.77754,       0.82827,      &
               0.87352,       0.91502,       0.95235,      &
               0.98511,       1.00000 /
!
! Ultra high troposphere resolution
      data a100/100.00000,     300.00000,     800.00000,   &
               1762.35235,    3106.43596,    4225.71874,   &
               4946.40525,    5388.77387,    5708.35540,   &
               5993.33124,    6277.73673,    6571.49996,   &
               6877.05339,    7195.14327,    7526.24920,   &
               7870.82981,    8229.35361,    8602.30193,   &
               8990.16936,    9393.46399,    9812.70768,   &
              10248.43625,   10701.19980,   11171.56286,   &
              11660.10476,   12167.41975,   12694.11735,   &
              13240.82253,   13808.17600,   14396.83442,   &
              15007.47066,   15640.77407,   16297.45067,   &
              16978.22343,   17683.83253,   18415.03554,   &
              19172.60771,   19957.34218,   20770.05022,   &
              21559.14829,   22274.03147,   22916.87519,   &
              23489.70456,   23994.40187,   24432.71365,   &
              24806.25734,   25116.52754,   25364.90190,   &
              25552.64670,   25680.92203,   25750.78675,   &
              25763.20311,   25719.04113,   25619.08274,   &
              25464.02630,   25254.49482,   24991.06137,   &
              24674.32737,   24305.11235,   23884.79781,   &
              23415.77059,   22901.76510,   22347.84738,   &
              21759.93950,   21144.07284,   20505.73136,   &
              19849.54271,   19179.31412,   18498.23400,   &
              17809.06809,   17114.28232,   16416.10343,   &
              15716.54833,   15017.44246,   14320.43478,   &
              13627.01116,   12938.50682,   12256.11762,   &
              11580.91062,   10913.83385,   10255.72526,   &
               9607.32122,    8969.26427,    8342.11044,   &
               7726.33606,    7122.34405,    6530.46991,   &
               5950.98721,    5384.11279,    4830.01153,   &
               4288.80090,    3760.55514,    3245.30920,   &
               2743.06250,    2253.78294,    1777.41285,   &
               1313.88054,     863.12371,     425.13088,   &
                  0.00000,       0.00000  /


      data b100/0.00000,       0.00000,       0.00000,   &
                0.00000,       0.00000,       0.00000,   &
                0.00000,       0.00000,       0.00000,   &
                0.00000,       0.00000,       0.00000,   &
                0.00000,       0.00000,       0.00000,   &
                0.00000,       0.00000,       0.00000,   &
                0.00000,       0.00000,       0.00000,   &
                0.00000,       0.00000,       0.00000,   &
                0.00000,       0.00000,       0.00000,   &
                0.00000,       0.00000,       0.00000,   &
                0.00000,       0.00000,       0.00000,   &
                0.00000,       0.00000,       0.00000,   &
                0.00000,       0.00000,       0.00000,   &
                0.00052,       0.00209,       0.00468,   &
                0.00828,       0.01288,       0.01849,   &
                0.02508,       0.03266,       0.04121,   &
                0.05075,       0.06126,       0.07275,   &
                0.08521,       0.09866,       0.11308,   &
                0.12850,       0.14490,       0.16230,   &
                0.18070,       0.20009,       0.22042,   &
                0.24164,       0.26362,       0.28622,   &
                0.30926,       0.33258,       0.35605,   &
                0.37958,       0.40308,       0.42651,   &
                0.44981,       0.47296,       0.49591,   &
                0.51862,       0.54109,       0.56327,   &
                0.58514,       0.60668,       0.62789,   &
                0.64872,       0.66919,       0.68927,   &
                0.70895,       0.72822,       0.74709,   &
                0.76554,       0.78357,       0.80117,   &
                0.81835,       0.83511,       0.85145,   &
                0.86736,       0.88286,       0.89794,   &
                0.91261,       0.92687,       0.94073,   &
                0.95419,       0.96726,       0.97994,   &
                0.99223,       1.00000  /

      select case (km)

        case (24)

          ks = 5     
          do k=1,km+1
            ak(k) = a24(k)
            bk(k) = b24(k)
          enddo

#ifdef MARS_GCM
       case (28)
          ks = 4     
          do k=1,km+1
            ak(k) = a28(k)
            bk(k) = b28(k)
          enddo

       case (36)
          ks = 10     
          do k=1,km+1
            ak(k) = a36(k)
            bk(k) = b36(k)
          enddo
#endif MARS_GCM 


        case (32)
!         ks = 11              ! John Wilson's setup
          ks = 13              ! high-res trop_32 setup
          do k=1,km+1
            ak(k) = a32(k)
            bk(k) = b32(k)
          enddo

        case (48)
          ks = 28
          do k=1,km+1
            ak(k) = a48(k)
            bk(k) = b48(k)
          enddo

        case (55)
          ks = 41
          do k=1,km+1
            ak(k) = a55(k)
            bk(k) = b55(k)
          enddo

        case (60)
          ks = 37
          do k=1,km+1
            ak(k) = a60(k)
            bk(k) = b60(k)
          enddo


        case (64)
          ks = 46
          do k=1,km+1
            ak(k) = a64(k)
            bk(k) = b64(k)
          enddo

        case (100)
          ks = 38
          do k=1,km+1
            ak(k) = a100(k)
            bk(k) = b100(k)
          enddo

        case (10)
!--------------------------------------------------
! Pure sigma-coordinate with uniform spacing in "z"
!-------------------------------------------------0
!
         pt = 2000.           ! model top pressure (pascal)
         press(1) = pt
         press(km+1) = p0
         dlnp = (log(p0) - log(pt)) / real(km)

            lnpe = log(press(km+1))
         do k=km,2,-1
            lnpe = lnpe - dlnp
            press(k) = exp(lnpe)
         enddo

! Search KS
            ks = 0
         do k=1,km
            if(press(k) >= pc) then
               ks = k-1
               goto 123
            endif
         enddo
123   continue

         if(ks /= 0) then
            do k=1,ks
               ak(k) = press(k)
               bk(k) = 0.
            enddo                                                
          endif                                                

             pint = press(ks+1)
          do k=ks+1,km                                        
             ak(k) =  pint*(press(km)-press(k))/(press(km)-pint)               
             bk(k) = (press(k) - ak(k)) / press(km+1)          
          enddo                                                
             ak(km+1) = 0. 
             bk(km+1) = 1.                                     
                                                              
          do k=2,km
!            bk(k) = real(k-1) / real(km)
!            ak(k) = pt * ( 1. - bk(k) )
          enddo

             ak(km+1) = 0.
             bk(km+1) = 1.

        case default

!-----------------------------------------------------------------
! Pure sigma-coordinate with uniform spacing in sigma and ptop = 0
!-----------------------------------------------------------------
         pt = 0.
         pint = pt
         ks = 0
             ak(1) = 0.
             bk(1) = 0.
 
          do k=2,km
             ak(k) = 0.
             bk(k) = real(k-1) / real(km)
          enddo
             ak(km+1) = 0.
             bk(km+1) = 1.
!--- fix the top at 1 mb
             ak(1) = 100.
!---
!         do k=1,km+1
!            write(*,*) k, ak(k), bk(k)
!         enddo

      end select

          ptop = ak(1)

 end subroutine set_eta

 subroutine check_eta(km, ks, ptop, ak, bk)

 use fv_pack,      only: master
 use fms_mod,      only: error_mesg,  FATAL

 implicit none

      integer,  intent(in)::  km           ! vertical dimension
      integer,  intent(in):: ks           ! number of pure p layers
      real, intent(in):: ak(km+1)
      real, intent(in):: bk(km+1)
      real, intent(in):: ptop         ! model top (Pa)
! local
      real dlp, ps_max
      integer  k

      ps_max = 0.

      do k=ks+1,km
         dlp = (ak(k)-ak(k+1))/(bk(k+1)-bk(k))
!        if ( master ) write(*,*) k, dlp*0.01
         ps_max = max( ps_max, dlp )
      enddo

      if ( master ) write(*,*) 'Check_eta: allowable min_ps (mb)=', ps_max*0.01
      if( ps_max > 450.E2 ) then
          call error_mesg('check_eta', 'invalid (a,b) in set_eta',FATAL)
      endif

 end subroutine check_eta

