#####################################################################
#
#		Make File for ELM 
#  
#
# This make file is invoked from the ELM "build" script
# For that script (and here), the environment variable ELM_HOME must
# be defined (the "build" script assembles other paths used in this makefile)
# Additionally, $OSTYPE definition is required (e.g., linux, solaris, darwin, etc)
#
# Last updated for ELM v2.3 
#####################################################################

SpatMod =	$(DriverPath)/Sources/SpatMod

UnitMod =	$(DriverPath)/Sources/UnitMod

TargetApp =	$(ModelPath)$(ProjName)/Load/$(ProjName).$(OSTYPE)

ToolDir = 	$(DriverPath)/Sources/Tools

Src = 		$(DriverPath)/Sources/Driver_Sources

Objects = 	$(SpatMod)/$(OSTYPE)/Fluxes.o \
		$(SpatMod)/$(OSTYPE)/WatMgmt.o \
		$(SpatMod)/$(OSTYPE)/stage_inp.o \
		$(SpatMod)/$(OSTYPE)/rain_inp.o \
		$(SpatMod)/$(OSTYPE)/evap_inp.o \
		$(SpatMod)/$(OSTYPE)/Success.o \
		$(UnitMod)/$(OSTYPE)/UnitMod.o \
		$(UnitMod)/$(OSTYPE)/BudgStats.o \
		$(Src)/$(OSTYPE)/Driver_Utilities.o \
		$(Src)/$(OSTYPE)/Generic_Driver.o \
		$(ToolDir)/$(OSTYPE)/$(Tool).o \
		$(ToolDir)/$(OSTYPE)/gridmap.o \
		$(ToolDir)/$(OSTYPE)/grid_io.o \
		$(ToolDir)/$(OSTYPE)/MultiRun.o \

# includes for hdf (not used v2.2+) and ELM (sme) sources
INC_DIR =  $(ELM_HOME)/include
#INC = -I$(INC_DIR)/hdf -I$(INC_DIR)/sme
INC = -I$(INC_DIR)/sme

# Linking macros, put all the libraries in ELM_HOME/lib
LDFLAGS = -g -v -H 

#LIB_DIR =  -L. -L$(ELM_HOME)/lib 
#LIB_DIR = -L /vol/forte6/SUNWspro/lib -L. -L$(ELM_HOME)/lib 
#LIBS = $(LIB_DIR) -ljpeg -lz -lmfhdf -ldf -lm
#LIBS = $(LIB_DIR)  -lz -lm 
LIBS =  -lm 

# useful Sun Solaris Forte 6 compiler options
# -g == debug (can combine with optimization to get some debug info)
# -fast == full optimize 
# -xO5 -fast == works for best optimization on ULTRAsparc proc class
#
# useful gcc compiler options
# -g == debug 
# -Wall all warnings
# -O3 -ffast-math == works for best optimization
CFLAGS = -O3 -ffast-math

# Compiler selection
#C = gcc (gnu cc)
#C = cc62 (sun forte cc62)
C = gcc

########################### DEPENDENCIES of target all ###############################
all: $(TargetApp)

$(TargetApp): $(Objects)
	$(C) -o Driver $(Objects) $(CFLAGS) $(LDFLAGS) $(LIBS);
	mv Driver $(TargetApp);

######################## Dynamic calculation code #########
$(UnitMod)/$(OSTYPE)/UnitMod.o: $(UnitMod)/UnitMod.c $(INC_DIR)/sme/unitmod.h $(INC_DIR)/sme/unitmod_vars.h $(INC_DIR)/sme/unitmod_globparms.h $(INC_DIR)/sme/unitmod_habparms.h $(INC_DIR)/sme/globals.h 
	 $(C) $(CFLAGS) $(INC) -o $(UnitMod)/$(OSTYPE)/UnitMod.o -c $(UnitMod)/UnitMod.c

$(UnitMod)/$(OSTYPE)/BudgStats.o: $(UnitMod)/BudgStats.c $(INC_DIR)/sme/budgstats.h $(INC_DIR)/sme/budgstats_birvars.h $(INC_DIR)/sme/budgstats_statvars.h  $(INC_DIR)/sme/globals.h
	$(C) $(CFLAGS) $(INC) -o $(UnitMod)/$(OSTYPE)/BudgStats.o -c $(UnitMod)/BudgStats.c

$(SpatMod)/$(OSTYPE)/WatMgmt.o: $(SpatMod)/WatMgmt.c $(INC_DIR)/sme/watmgmt.h  $(INC_DIR)/sme/globals.h
	$(C) $(CFLAGS) $(INC) -o $(SpatMod)/$(OSTYPE)/WatMgmt.o -c $(SpatMod)/WatMgmt.c

$(SpatMod)/$(OSTYPE)/Fluxes.o: $(SpatMod)/Fluxes.c $(INC_DIR)/sme/fluxes.h  $(INC_DIR)/sme/globals.h 
	$(C) $(CFLAGS) $(INC) -o $(SpatMod)/$(OSTYPE)/Fluxes.o -c $(SpatMod)/Fluxes.c

$(SpatMod)/$(OSTYPE)/Success.o: $(SpatMod)/Success.c $(INC_DIR)/sme/success.h  $(INC_DIR)/sme/globals.h
	$(C) $(CFLAGS) $(INC) -o $(SpatMod)/$(OSTYPE)/Success.o -c $(SpatMod)/Success.c

######################## Utility code #########
$(Src)/$(OSTYPE)/Generic_Driver.o: $(Src)/Generic_Driver.c $(INC_DIR)/sme/generic_driver.h  $(INC_DIR)/sme/globals.h
	$(C) $(CFLAGS) $(INC) -o $(Src)/$(OSTYPE)/Generic_Driver.o -c $(Src)/Generic_Driver.c

$(Src)/$(OSTYPE)/Driver_Utilities.o: $(Src)/Driver_Utilities.c $(INC_DIR)/sme/driver_utilities.h  $(INC_DIR)/sme/globals.h
	$(C) $(CFLAGS) $(INC) -o $(Src)/$(OSTYPE)/Driver_Utilities.o -c $(Src)/Driver_Utilities.c

$(ToolDir)/$(OSTYPE)/$(Tool).o: $(ToolDir)/$(Tool).c $(INC_DIR)/sme/serial.h  $(INC_DIR)/sme/globals.h
	$(C) $(CFLAGS) $(INC) -o $(ToolDir)/$(OSTYPE)/$(Tool).o -c $(ToolDir)/$(Tool).c

$(ToolDir)/$(OSTYPE)/gridmap.o: $(ToolDir)/gridmap.c $(INC_DIR)/sme/gridmap.h  $(INC_DIR)/sme/globals.h
	$(C) $(CFLAGS) $(INC) -o $(ToolDir)/$(OSTYPE)/gridmap.o -c $(ToolDir)/gridmap.c

$(ToolDir)/$(OSTYPE)/grid_io.o: $(ToolDir)/grid_io.c $(INC_DIR)/sme/grid_io.h 
	$(C) $(CFLAGS) $(INC) -o $(ToolDir)/$(OSTYPE)/grid_io.o -c $(ToolDir)/grid_io.c

$(ToolDir)/$(OSTYPE)/MultiRun.o: $(ToolDir)/MultiRun.c $(INC_DIR)/sme/multi_run.h  $(INC_DIR)/sme/globals.h
	$(C) $(CFLAGS) $(INC) -o $(ToolDir)/$(OSTYPE)/MultiRun.o -c $(ToolDir)/MultiRun.c

$(SpatMod)/$(OSTYPE)/rain_inp.o: $(SpatMod)/rain_inp.c $(INC_DIR)/sme/rain.h  $(INC_DIR)/sme/grid_io.h  $(INC_DIR)/sme/globals.h
	$(C) $(CFLAGS) $(INC) -o $(SpatMod)/$(OSTYPE)/rain_inp.o -c $(SpatMod)/rain_inp.c

$(SpatMod)/$(OSTYPE)/evap_inp.o: $(SpatMod)/evap_inp.c $(INC_DIR)/sme/evap.h  $(INC_DIR)/sme/grid_io.h  $(INC_DIR)/sme/globals.h
	$(C) $(CFLAGS) $(INC) -o $(SpatMod)/$(OSTYPE)/evap_inp.o -c $(SpatMod)/evap_inp.c

$(SpatMod)/$(OSTYPE)/stage_inp.o: $(SpatMod)/stage_inp.c $(INC_DIR)/sme/stage.h  $(INC_DIR)/sme/grid_io.h $(INC_DIR)/sme/globals.h 
	$(C) $(CFLAGS) $(INC) -o $(SpatMod)/$(OSTYPE)/stage_inp.o -c $(SpatMod)/stage_inp.c

################################################################################

clean:
	rm -f $(Objects) $(TargetApp);


