#!/bin/sh
# Install the ELM project in the user's directory

####
#### Version attributes for Code and Data archives (changeable)
VersionCode=2.5
VersionData=2.5

VersionRelease=2.5

####
#### Descriptive attributes for Code and Data archives (changeable)
DescriptCode=update0.2
DescriptData=update0.2

####
#### Base name of the Code and Data archives
ArchiveSource=ELM$VersionCode.src.$DescriptCode
ArchiveData=ELM$VersionData.data.$DescriptData

####
#### portable function for getting yes/no answer
get_yesno()
{
    ANS="X"
    while [ "$ANS" != "y" -a "$ANS" != "n" -a "$ANS" != "Y" -a "$ANS" != "N" ]
    do
      echo  " (y/n): "
      read ANS
    done
}

####
#### Introductary info
clear
echo "########"
echo ""
echo "This script installs the Everglades Landscape Model (ELM$VersionData) project."
echo ""
echo "It builds the complete code and data structure used in an ELM"
echo "distribution release.  The actual compilation script is not invoked here,"
echo "but the user is set up and prompted to initiate that final, single"
echo "step.  NOTE: this script will not touch anything outside of the "
echo "ELM_HOME directory that you are about to define."
echo ""
echo "You should have put this ELMinstall$VersionRelease script and the two archive files"
echo "(source code and data, $ArchiveSource.tar.gz and"
echo "$ArchiveData.tar.gz) together into a previously-empty, "
echo "new directory existing anywhere on your file system."
echo "You are about to create the "ELM_HOME" environment variable"
echo "that points to this directory."
echo ""
echo "Have you put the files together in the desired directory? (y/n)"
get_yesno
if [ "$ANS" != "y" -a "$ANS" != "Y" ]
  then 
	echo ""
  	echo "#########"
	echo "OK.  Invoke the ELMinstall script again when you have moved things."
	echo ""
  	echo "End of instructions, exited script."
	exit
  else
	echo ""
  	echo "#########"
	echo "Great. Now for the next step."
fi

####
#### Test for existence of an ELM_HOME environment variable
#### and give instructions for setting it up if it has not been set up
if [ ! "$ELM_HOME" ] ;
then
	# no setting at all for ELM_HOME
	clear
	echo "# "
	echo "######## NOTHING has happened yet, and the script has stopped."
	echo "# You are ready to set up your environment."
  	echo "# To invoke the three commands to set up the ELM environment"
  	echo "# (temporarily or permanently), follow the instructions below."
	echo "#"
  	echo "# >>>>>After you think you've set up the environment, invoke this ELMinstall"
  	echo "# >>>>>script again from the same shell (window) that you set things up in."
	echo "#"
  	echo "#########"
  	# this JUNK should be (?) set up so a user can just source a file with the commands
  	echo "# FOR ALL SHELLS, replace the \"/MY/DIRECTORY/\" string below with the  " 
  	echo "# absolute path where you have the ELM tar.gz files."
  	echo "# If you have problems, see other examples/instructions "
  	echo "# in ./SME/scripts/aaELM_setenv_instruct_notScript.txt."
  	echo "#"
  	echo "#########"
  	echo "# For tcsh or csh: "
  	echo "# Cut&Paste these into the command line to invoke temporarily for this shell (window),"
  	echo "# OR make them permanent by putting them in your ~/.cshrc (or ~/.tcshrc or...)"
  	echo "setenv ELM_HOME /MY/DIRECTORY/"
  	echo "set  path = ({\$ELM_HOME}/SME/scripts/ \$path)"
  	echo "setenv ELM_ARCHIVE_PATH {\$ELM_HOME}/arc_out/"
  	echo "#"
  	echo "#########"
  	echo "# For bash: "
  	echo "# Sorry - we just found that an environment variable (OSTYPE) "
  	echo "# doesn't get exported properly when booting into bash alone. "
  	echo "# These were tested in bash, having invoked bash from tcsh,  "
  	echo "# which allowed things to work fine in bash.  "
  	echo "# FOR NOW (July 15, 2004), please build and run ELM from tcsh (ignore below).  "
  	echo "# #########################  "
  	echo "# Cut&Paste these into the command line to invoke temporarily for this shell (window),"
  	echo "# OR make them permanent by putting them in your ~/.profile (or ~/.bashrc or...)"
  	echo "export ELM_HOME=/MY/DIRECTORY/"
  	echo "PATH=\$ELM_HOME/SME/scripts/:\$PATH"
  	echo "export ELM_ARCHIVE_PATH=\$ELM_HOME/arc_out/"
 	echo "#########"
  	echo "# End of instructions, exited script."
    exit
fi

####
#### Test for validity of the directory pointed to by the ELM_HOME environment variable
if test -d $ELM_HOME
  then
	# valid directory for ELM_HOME
	echo ""
	echo "Good job.  You've set up your ELM_HOME."
	echo "ELM_HOME= $ELM_HOME"
	echo "Now we'll unpack the compressed tar files."
	echo ""
	echo "They will expand in your ELM_HOME directory, which is:"
	echo "################ "
	echo "$ELM_HOME"
	echo "################ "
	echo "Nothing outside of the above ELM_HOME directory will be touched."
	echo "******************************* "
	echo ">>>> ARE YOU SURE you want to write the files to the above location? (y/n)"
	echo "******************************* "
	get_yesno
		if [ "$ANS" != "y" -a "$ANS" != "Y" ]
		  then 
			echo ""
			echo "######## NOTHING has happened yet, and the script has stopped."
			echo "Reset your ELM_HOME environment variable (& path) to the desired location."
			echo ""
  			echo "#########"
  			# this JUNK should be (?) set up so a user can just source a file with the commands
  			echo "# FOR ALL SHELLS, replace the \"/MY/DIRECTORY/\" string below with the  " 
 		 	echo "# absolute path where you have the ELM tar.gz files."
  			echo "# If you have problems, see other examples/instructions "
  			echo "# in ./SME/scripts/aaELM_setenv_instruct_notScript.txt."
 		 	echo "#"
  			echo "#########"
  			echo "# For tcsh or csh: "
  			echo "# Cut&Paste these into the command line to invoke temporarily for this shell (window),"
 		 	echo "# OR make them permanent by putting them in your ~/.cshrc (or ~/.tcshrc or...)"
 		 	echo "setenv ELM_HOME /MY/DIRECTORY/"
 		 	echo "set  path = ({\$ELM_HOME}/SME/scripts/ \$path)"
 		 	echo "setenv ELM_ARCHIVE_PATH {\$ELM_HOME}/arc_out/"
 		 	echo "#"
 		 	echo "#########"
 		 	echo "# For bash: "
  			echo "# Sorry - we just found that an environment variable (OSTYPE) "
  			echo "# doesn't get exported properly when booting into bash alone. "
  			echo "# These were tested in bash, having invoked bash from tcsh,  "
  			echo "# which allowed things to work fine in bash.  "
  			echo "# FOR NOW (July 15, 2004), please build and run ELM from tcsh (ignore below).  "
  			echo "# #########################  "
 		 	echo "# Cut&Paste these into the command line to invoke temporarily for this shell (window),"
 		 	echo "# OR make them permanent by putting them in your ~/.profile (or ~/.bashrc or...)"
 		 	echo "export ELM_HOME=/MY/DIRECTORY/"
 		 	echo "PATH=\$ELM_HOME/SME/scripts/:\$PATH"
 		 	echo "export ELM_ARCHIVE_PATH=\$ELM_HOME/arc_out/"
 			echo "#########"
		  	echo "# End of instructions, exited script."
			exit
		  else
			echo ""
			echo "#########"
			echo "OK.  We'll try unzipping & un-tarring files there now..."
			echo "#########"
		fi
  else
	# invalid directory for ELM_HOME
	echo ""
	echo "######## NOTHING has happened yet, and the script has stopped."
	echo "Oops.  You've set up your ELM_HOME, but it is pointing to "
	echo "nowhere: ELM_HOME= $ELM_HOME "
    echo "###### Error: Your above ELM_HOME directory does not exist."
    echo "Sorry.  Try setting that environment variable (& path) again."
	echo ""
  	echo "#########"
  	# this should be (?) set up so a user can just source a file with the commands
  	echo "# FOR ALL SHELLS, replace the \"/MY/DIRECTORY/\" string below with the  " 
  	echo "# absolute path where you have the ELM tar.gz files."
  	echo "# If you have problems, see other examples/instructions "
  	echo "# in ./SME/scripts/aaELM_setenv_instruct_notScript.txt."
  	echo "#"
  	echo "#########"
  	echo "# For tcsh or csh: "
  	echo "# Cut&Paste these into the command line to invoke temporarily for this shell (window),"
  	echo "# OR make them permanent by putting them in your ~/.cshrc (or ~/.tcshrc or...)"
  	echo "setenv ELM_HOME /MY/DIRECTORY/"
  	echo "set  path = ({\$ELM_HOME}/SME/scripts/ \$path)"
  	echo "setenv ELM_ARCHIVE_PATH {\$ELM_HOME}/arc_out/"
  	echo "#"
  	echo "#########"
  	echo "# For bash: "
  	echo "# Sorry - we just found that an environment variable (OSTYPE) "
  	echo "# doesn't get exported properly when booting into bash alone. "
  	echo "# These were tested in bash, having invoked bash from tcsh,  "
  	echo "# which allowed things to work fine in bash.  "
  	echo "# FOR NOW (July 15, 2004), please build and run ELM from tcsh (ignore below).  "
  	echo "# #########################  "
  	echo "# Cut&Paste these into the command line to invoke temporarily for this shell (window),"
  	echo "# OR make them permanent by putting them in your ~/.profile (or ~/.bashrc or...)"
  	echo "export ELM_HOME=/MY/DIRECTORY/"
  	echo "PATH=\$ELM_HOME/SME/scripts/:\$PATH"
  	echo "export ELM_ARCHIVE_PATH=\$ELM_HOME/arc_out/"
 	echo "#########"
  	echo "End of instructions, exited script."
    exit
fi

####
#### Test for existance of both data and source tar files
if
test ! -f $ELM_HOME/$ArchiveData.tar.gz
then
    echo "The expected Data archive is not there."
    echo "Expected: $ELM_HOME/$ArchiveData.tar.gz"
    echo "Here is a listing of *.gz in your ELM_HOME:"
    ls $ELM_HOME/*.gz
    echo ""
    echo "Exiting...The expected file is $ArchiveData.tar.gz"
	echo "######## NO files have been created, and the script has stopped."
    exit
fi

if
test ! -f $ELM_HOME/$ArchiveSource.tar.gz
then
    echo "The expected Source archive is not there."
    echo "Expected: $ELM_HOME/$ArchiveSource.tar.gz"
    echo "Here is a listing of *.gz in your ELM_HOME:"
    ls $ELM_HOME/*.gz
    echo ""
    echo "Exiting...The expected file is $ArchiveSource.tar.gz"
	echo "######## NO files have been created, and the script has stopped."
    exit
fi


####
#### Now do the gunzipping & extracting
####
echo "Now uncompressing $ArchiveSource.tar.gz ...."
gunzip $ArchiveSource.tar.gz
echo "Now uncompressing $ArchiveData.tar.gz ...."
gunzip $ArchiveData.tar.gz

echo "Now extracting the two tar files... "
tar -xvf $ArchiveData.tar
tar -xvf $ArchiveSource.tar



########
########

# create an empty directory which will hold the executable (expected by makefile)
echo "Creating $ELM_HOME/SME/Projects/ELM$VersionData/Load directory to hold the executable."
mkdir $ELM_HOME/SME/Projects/ELM$VersionData/Load

# create empty directories which will hold the the model output 
echo "Creating model output directories in $ELM_HOME/SME/Projects/ELM$VersionData ..."
$ELM_HOME/SME/scripts/mkOutDirs $ELM_HOME/SME/Projects/ ELM$VersionData

# create an empty directory which will hold archived model runs
echo "Creating $ELM_HOME/arc_out/ELM$VersionData directory to hold archived model output."
mkdir $ELM_HOME/arc_out
mkdir $ELM_HOME/arc_out/ELM$VersionData


echo " "
echo "######## "
echo "Congratulations!  You should be done with your ELM file installations.  "
echo "If all appears to have run w/o errors, run the build script to make an executable."
echo "Does your system know where to find the build script?  The next line will tell:"
which build
echo "Hopefully, the command above found the executable build script (the path is shown if so)."
echo "That means your ELM scripts path is set up ok, and you can move along!"
echo "Just type \"build ELM$VersionData\" to have a running model."
echo "But, if you got something above like \"build: command not found\", you need to fix your path."
echo "That's all for this ELMinstall$VersionRelease script."

