/***************************************************************************
                          cell.h  -  description
                             -------------------
    begin                : Mon Feb 24 2003
    copyright            : (C) 2003 by Beheen Trimble
    email                : btrimble@sfwmd.gov
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CELL_H
#define CELL_H

using namespace std;

#include <fstream>

/**
  *@author Beheen Trimble
  */


#include "polygon.h"
class Point;
class Data;
class ConsoleMsg;


class Cell  : public Polygon {
public:
  Cell();
  Cell(int id);
	Cell(int,Point,Point,Point,Point);
	~Cell();
  Point getLowerLeft();
  Point getLowerRight();
  Point getUpperLeft();
  Point getUpperRight();
 
  double calcArea();
  
  int pointInConvexPolygon(const Point pt);
  int pointInCell(const Point pt);
  int getRow();
  int getCol();
  int getMappedID();

  void setRow(int);
  void setCol(int);
  void setMappedID(int);
  void setCoords(Point& ll,Point& lr, Point& ur, Point& ul);
  void print();
  void copyMappedCell(Cell*);
  
private: 
  int Row;
  int Col;
  int MappedID;
  Point LowerLeft;
  Point LowerRight;
  Point UpperLeft;
  Point UpperRight;
  ConsoleMsg* console;
  
};

#endif
