/***************************************************************************
                          consolemsg.h  -  description
                             -------------------
    begin                : Tue Feb 11 2003
    copyright            : (C) 2003 by Beheen Trimble
    email                : btrimble@sfwmd.gov
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONSOLEMSG_H
#define CONSOLEMSG_H


/**
  *@author Beheen Trimble
  * First author Joseph Parks
  */

using namespace std;

#include <string>
#include <vector>
#include <iostream>
#include <map>

#include "keyword.h"
     
class ConsoleMsg {
public: 
  ConsoleMsg();
  ConsoleMsg(string);
	~ConsoleMsg();

  void ErrMsg     (const char *msg, const char *arg);
  void ErrMsg     (const char *msg, const char *arg, int status);
  void ErrMsg     (const char *msg, string arg,      int status);
  void ErrMsg     (const char *msg, int arg,         int status);
  void ErrMsg     (const char *msg, double arg,      int status);
  void ErrMsg     (string      msg, const char *arg, int status);
  void ErrMsg     (string      msg, string arg,      int status);
  void ErrMsg     (string      msg, int arg,         int status);
  void ErrMsg     (string      msg, double arg,      int status);
  void MsgFail (const char *msg, const char *arg);

  void MsgDelete(const char *msg);
  void MsgPrint(const char *msg, const char *arg);
  void MsgWrite(const char *msg, const char *arg, string outfile); 
  void Msg (const char *msg, const char *arg, int status);
  void Msg (const char *msg, string arg,      int status);
  void Msg (const char *msg, int arg,         int status);
  void Msg (const char *msg, double arg,      int status);
  void Msg (string      msg, const char *arg, int status);
  void Msg (string      msg, string arg,      int status);
  void Msg (string      msg, int arg,         int status);
  void Msg (string      msg, double arg,      int status);

  void DebugMsg   (const char *msg, const char *arg, string);
  void DebugMsg   (const char *msg, double arg1, double arg2);
  void DebugMsg   (const char *msg, const char *arg, int status);
  void DebugMsg   (const char *msg, string arg,      int status);
  void DebugMsg   (const char *msg, int arg,         int status);
  void DebugMsg   (const char *msg, double arg,      int status);
  void DebugMsg   (string      msg, const char *arg, int status);
  void DebugMsg   (string      msg, string arg,      int status);
  void DebugMsg   (string      msg, int arg,         int status);
  void DebugMsg   (string      msg, double arg,      int status);

  void PrintKeywordMap(map<string,Keyword*>*);
  
  int estatus;    // -1 error
  int xstatus;    // 0 success
  string Owner;
};

#endif
