/***************************************************************************
                          keywordmgr.h  -  description
                             -------------------
    begin                : Tue Feb 11 2003
    copyright            : (C) 2003 by Beheen Trimble
    email                : btrimble@sfwmd.gov
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KEYWORDMGR_H
#define KEYWORDMGR_H

using namespace std;

#include <vector>
#include <iostream>  // cout, cerr, ....
#include <fstream>   // to open the file via ifstream object
#include <string>
#include <map>
#include <exception>
#include <iomanip>
#include "keyword.h"
#include "consolemsg.h"

/**
  *@author Beheen Trimble
  */

class KeywordInputBlock;


class KeywordMgr {
public: 
	KeywordMgr();
	~KeywordMgr();

  void printInputBlock();
  bool commentLine(string *line);
  int readCfgFile(string);
  int getLine(vector<string>::iterator fileIterator, string* line);
  int checkTermParen(string* fileLine);
  int checkFormat(string keyStart,string keyEnd);
  int parseInputBlock(map<string,Keyword*>& keywords,string kyStart,string kyEnd);
  int updateInputBlock(string gridname, vector<Keyword*> updatelist);
    
  string::size_type findNoWhiteSpace(string str, string::size_type offset, int direction);
  Keyword* findKeywordFromMap(string key,map<string,Keyword*>&);
  map<string,Keyword*> getInputBlock(string key);
  
private:
  vector<string> fileVector;
  ConsoleMsg* console;
  map<string,KeywordInputBlock*> keyInputBlock;
  enum direction{back, forward};
                                     
};

#endif
