/***************************************************************************
                          point.cpp  -  description
                             -------------------
    begin                : Sun Feb 23 2003
    copyright            : (C) 2003 by Beheen Trimble
    email                : btrimble@sfwmd.gov
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

using namespace std;
 
#include "point.h"
#include <iostream>  // cout, cerr, ....


Point::Point() {
  console = new ConsoleMsg("Point");
  x = y = 0.0;
}

Point::Point(double xpt, double ypt) {
  x = xpt;
  y = ypt;
  console = new ConsoleMsg("Point");
}

Point::~Point() {} // can not delete console here

Point::Point(const Point& rhs) {
  x = rhs.x;
  y = rhs.y;
}

Point Point::operator=(const Point& rhs){
  
  if(&rhs != this) {
    x = rhs.x; y = rhs.y;
  }
  return *this;
} 

Point Point::operator=(const double rhs){
  x = rhs; y = rhs;
  return *this;
}

Point Point::operator-(const Point &rhs) const {
  Point result(x - rhs.x, y - rhs.y);
  return result;
}

Point Point::operator+(const Point &rhs) const {
  Point result(x + rhs.x, y + rhs.y);
  return result;
}

Point Point::operator+=(const Point &rhs) {
  x += rhs.x; y += rhs.y;
  return *this;
}

Point Point::operator+=(const double rhs) {
  x += rhs; y += rhs;
  return *this;
}

Point Point::operator*(const double rhs) const {
  Point result(x * rhs, y * rhs);
  return result;
}

Point Point::operator/(const double rhs) const {
  Point result(x / rhs, y / rhs);
  return result;
}

Point Point::operator*=(const double rhs) {
  x *= rhs; y *=rhs;
  return *this;
}

int Point::operator== (const Point &rhs) const {
  const double POINT_TOL = 1e-30;
  return ( fabs(x - rhs.x) < POINT_TOL && fabs(y - rhs.y) < POINT_TOL );
}

void Point::print() {
  cout.precision(10);
  //int status = console->xstatus;
  //console->Msg("Point ==> ", "", status);
  std::cout << "Point ==> X = " << x << " Y = " << y << endl;
}

void Point::setX(double thisx) { x = thisx; }
void Point::setY(double thisy) { y = thisy;}
double Point::getX() const {return x;}
double Point::getY() const {return y;}

