/*! \file budgstats.h
\brief Header file for calculations of Basin/Indicator-Region budgets, and other statistical summaries. 

This defines or declares variables & functions that are global to BudgStats.c.  \n

Note: documented with Doxygen, which expects specific syntax within special comments.  \n
	
The Everglades Landscape Model (ELM). \n
last updated: Jan 2005 \n
*/

#ifndef BUDGSTATS_H
#define BUDGSTATS_H

#include "globals.h" 

FILE *basInFile;
FILE *budget_Wacr1, *budget_Wacr2, *budget_Wacr3, *budget_Wacr4, *budget_Wacr5;
FILE *budget_Wcm1, *budget_Wcm2, *budget_Wcm3, *budget_Wcm4, *budget_Wcm5;
FILE *budget_P1, *budget_P2, *budget_P3, *budget_P4, *budget_P5;
FILE *budget_Par1, *budget_Par2, *budget_Par3, *budget_Par4, *budget_Par5;
FILE *budget_Plive1, *budget_Plive2, *budget_Plive3, *budget_Plive4, *budget_Plive5;
FILE *budget_Pdead1, *budget_Pdead2, *budget_Pdead3, *budget_Pdead4, *budget_Pdead5;
FILE *budget_Pwat1, *budget_Pwat2, *budget_Pwat3, *budget_Pwat4, *budget_Pwat5;
FILE *budget_S1, *budget_S2, *budget_S3, *budget_S4, *budget_S5;
FILE *BIRavg1, *BIRavg2, *BIRavg3, *BIRavg4, *BIRavg5;

#define conv_m3TOthousacrft 8.1070e-7  /*!< conversion from m^3 to thousands of acre-feet (m^3 * (2.471e-4acre/m^2) * (3.2808399 ft/m) == m^3 * 0.00081070 acre-ft/m^3) */

basnDef **basn_list; /*!< Basin/Indicator Region data */
basnDef *basins; /*!< Basin/Indicator Region data */
int numBasn; /*!< number of basins in model domain */

char modelFileName[300]; /*!< generic string for input/output file name */

void stats(int step);
void BIRstats_sum(void);
void BIRbudg_sum(void);

void BIRstats_sumFinal(void);
void BIRbudg_sumFinal(void);

void BIRstats_print(int ibas);
void BIRbudg_print(int ibas);

void BIRstats_date(void);
void BIRbudg_date(void);

void BIRstats_reset(void);
void BIRbudg_reset(void);

void BIRinit(void);
void BIRoutfiles(void);
void CellAvg(void);
void Cell_reset_avg(void);
void Cell_reset_hydper(void);
void alloc_mem_stats(void);

/* externs */
/* from unitmod.h */
extern float DAYJUL;

/* from driver_utilities.h */
extern char *ModelPath, *ProjName;
extern char *OutputPath;
extern char modelName[20], modelVers[10];

extern char *Scip(char *s, char SYM );
extern void init_pvar(VOIDP Map, UCHAR* mask, unsigned char Mtype,float iv);
extern VOIDP nalloc(unsigned mem_size, const char var_name[]);
extern float FMOD( float x, float y);

/* from generic_driver.h */
extern char SimAlt[20], SimModif[20];
extern int ESPmodeON;
extern float budg_Intvl, BIRavg_Intvl, avg_Intvl;
extern int avgPrint; 


#endif   /* BUDGSTATS_H */
