/*! \file budgstats_statvars.h
\brief Header file for spatial map statistical summary variables. 

This declares spatial statistical average variables that are global to BudgStats.c.  \n

Note: documented with Doxygen, which expects specific syntax within special comments.  \n
	
The Everglades Landscape Model (ELM). \n
last updated: Jan 2005 \n
*/

#ifndef BUDGSTATS_STATVARS_H
#define BUDGSTATS_STATVARS_H

/*! \remarks This header file is generated from the "ModelOutlist_creator_v?.xls" OpenOffice workbook.
Editing this .h header source directly is not recommended w/o changing ModelOutlist_creator. \n
To add/remove a statistical spatial variable to/from the model: \n
1) Enter/delete the variable documentation in ModelOutlist_creator_v?.xls; \n
2) Add/remove the 2 lines of code in the alloc_mem_stats function of BudgStats.c; \n
3) If you want a variable to be available for output, indicate so in ModelOutlist_creator, and add/remove the line of code in the gen_output function of Unit_Mod.c; \n
4) Export (cut&paste) the contents of this page into budgstats_statvars.h; \n
5) Use/delete the variable in the code equations! */



float *Floc_fr_phBioAvg; /*!< _Units_: kgOM/m^2/d; _Brief_: TemporalAverageOf: Floc_fr_phBio */
float *TPSfMinAvg; /*!< _Units_: kgP/d; _Brief_: TemporalAverageOf: TP_SFWT_MINER */



float *ETAvg; /*!< _Units_: m/d; _Brief_: TemporalAverageOf: HYD_ET */
float *EvapAvg; /*!< _Units_: m/d; _Brief_: TemporalAverageOf: SF_WT_EVAP */
float *HydPerAnn; /*!< _Units_: days; _Brief_: Number of days with ponded water per water year  */
float *LAI_effAvg; /*!< _Units_: dimless; _Brief_: TemporalAverageOf: LAI_eff */
float *Manning_nAvg; /*!< _Units_: d/(m^(1/3)); _Brief_: TemporalAverageOf: HYD_MANNINGS_N */
float *RainAvg; /*!< _Units_: m/d; _Brief_: TemporalAverageOf: SF_WT_FROM_RAIN */
float *SfWatAvg; /*!< _Units_: m; _Brief_: TemporalAverageOf: SURFACE_WAT */
float *TotHeadAvg; /*!< _Units_: m; _Brief_: TemporalAverageOf: HydTotHd */
float *TranspAvg; /*!< _Units_: m/d; _Brief_: TemporalAverageOf: HYD_TRANSP */
float *UnsatMoistAvg; /*!< _Units_: dimless; _Brief_: TemporalAverageOf: UNSAT_MOIST_PRP */
float *UnsatZavg; /*!< _Units_: m; _Brief_: TemporalAverageOf: UNSAT_DEPTH */





float *mac_nph_PCAvg; /*!< _Units_: mgP/kgC; _Brief_: TemporalAverageOf: mac_nph_PC_rep */
float *Mac_nphBioAvg; /*!< _Units_: kgC/m^2; _Brief_: TemporalAverageOf: MAC_NOPH_BIOMAS */
float *Mac_nphMortAvg; /*!< _Units_: kgC/m^2/d; _Brief_: TemporalAverageOf: NPHBIO_MORT */
float *Mac_nppAvg; /*!< _Units_: kgC/m^2/d; _Brief_: TemporalAverageOf: PHBIO_NPP */
float *mac_ph_PCAvg; /*!< _Units_: mgP/kgC; _Brief_: TemporalAverageOf: mac_ph_PC_rep */
float *Mac_phBioAvg; /*!< _Units_: kgC/m^2; _Brief_: TemporalAverageOf: MAC_PH_BIOMAS */
float *Mac_phMortAvg; /*!< _Units_: kgC/m^2/d; _Brief_: TemporalAverageOf: PHBIO_MORT */
float *Mac_totBioAvg; /*!< _Units_: kgC/m^2; _Brief_: TemporalAverageOf: MAC_TOT_BIOM */
float *MacNutCfAvg; /*!< _Units_: dimless; _Brief_: TemporalAverageOf: MAC_NUT_CF */
float *MacWatCfAvg; /*!< _Units_: dimless; _Brief_: TemporalAverageOf: MAC_WATER_CF */
float *TPSedUptAvg; /*!< _Units_: kgP/d; _Brief_: TemporalAverageOf: TP_SEDWT_UPTAKE */





float *C_Peri_mortAvg; /*!< _Units_: gC/m2/d; _Brief_: TemporalAverageOf: C_ALG_MORT */
float *C_Peri_nppAvg; /*!< _Units_: gC/m2/d; _Brief_: TemporalAverageOf: C_ALG_NPP */
float *C_Peri_PCAvg; /*!< _Units_: mgP/kgC; _Brief_: TemporalAverageOf: C_ALG_PCrep */
float *C_PeriAvg; /*!< _Units_: gC/m^2; _Brief_: TemporalAverageOf: C_ALG */
float *C_PeriNutCFAvg; /*!< _Units_: dimless; _Brief_: TemporalAverageOf: C_ALG_NUT_CF */
float *C_PeriRespAvg; /*!< _Units_: gC/m2/d; _Brief_: TemporalAverageOf: C_ALG_RESP */
float *NC_Peri_mortAvg; /*!< _Units_: gC/m2/d; _Brief_: TemporalAverageOf: NC_ALG_MORT */
float *NC_Peri_nppAvg; /*!< _Units_: gC/m2/d; _Brief_: TemporalAverageOf: NC_ALG_NPP */
float *NC_Peri_PCAvg; /*!< _Units_: mgP/kgC; _Brief_: TemporalAverageOf: NC_ALG_PCrep */
float *NC_PeriAvg; /*!< _Units_: gC/m^2; _Brief_: TemporalAverageOf: NC_ALG */
float *NC_PeriNutCFAvg; /*!< _Units_: dimless; _Brief_: TemporalAverageOf: vNC_ALG_NUT_CF */
float *NC_PeriRespAvg; /*!< _Units_: gC/m2/d; _Brief_: TemporalAverageOf: NC_ALG_RESP */
float *PeriAvg; /*!< _Units_: gC/m^2; _Brief_: TemporalAverageOf: ALG_TOT */
float *PeriLiteCFAvg; /*!< _Units_: dimless; _Brief_: TemporalAverageOf: ALG_LIGHT_CF */
float *TPSfUptAvg; /*!< _Units_: kgP/d; _Brief_: TemporalAverageOf: TP_SFWT_UPTAK */




float *TP_settlAvg; /*!< _Units_: kgP/d; _Brief_: TemporalAverageOf: TP_settl */
float *TPSedWatAvg; /*!< _Units_: mgP/L; _Brief_: TemporalAverageOf: TP_SEDWT_CONCACTMG */
float *TPSfWatAvg; /*!< _Units_: mgP/L; _Brief_: TemporalAverageOf: TP_SFWT_CONC_MG */




float *SaltSedAvg; /*!< _Units_: kgSalt/m^3; _Brief_: TemporalAverageOf: SAL_SED_WT */
float *SaltSfAvg; /*!< _Units_: kgSalt/m^3; _Brief_: TemporalAverageOf: SAL_SF_WT */


float *SedElevAvg; /*!< _Units_: m (see descript); _Brief_: TemporalAverageOf: SED_ELEV  */
float *TPSedMinAvg; /*!< _Units_: kgP/d; _Brief_: TemporalAverageOf: TP_SED_MINER */
float *TPSorbAvg; /*!< _Units_: mgP/kg_soil; _Brief_: TemporalAverageOf: TP_SORBCONC_rep */
float *TPtoSOILAvg; /*!< _Units_: mgP/kg_soil; _Brief_: TemporalAverageOf: TPtoSOIL_rep */
float *TPtoVOLAvg; /*!< _Units_: ug/cm^3; _Brief_: TemporalAverageOf: TPtoVOL_rep */



#endif /* BUDGSTATS_STATVARS_H */
