/*! \file fluxes.h
\brief Header file for the horizontal raster flux calculations. 

This defines or declares variables & functions that are global to Fluxes.c.  \n

Note: documented with Doxygen, which expects specific syntax within special comments.  \n
	
The Everglades Landscape Model (ELM). \n
last updated: Jan 2005 \n
*/

/* General notes on revisions to this source file. 
       Jan 2005 v2.3.3: documentation upgrade 
       		- Re-organized, clarified scopes, Doxygen tags added 
	
*/
#ifndef FLUX_H
#define FLUX_H


#include "globals.h"


void Flux_SWater(int it, float *SURFACE_WAT,float *SED_ELEV,float *HYD_MANNINGS_N,
		 double *STUF1, double *STUF2, double *STUF3);
float Flux_SWcells(int i0,int i1,int j0,int j1, 
		   float *SWater,float *Elevation,float *MC);
void Flux_SWstuff(int i0,int i1,int j0,int j1, float Flux, 
		  float *SURFACE_WAT, double *STUF1, 
		  double *STUF2, double *STUF3);
float Disp_Calc(float flux, float depth_i, float depth_j, float tim_step);

void Flux_GWater (int it, float *SatWat, float *Unsat, float *SfWat,
		  float *rate, float *poros, float *sp_yield, float *elev,
		  double *gwSTUF1, double *gwSTUF2, double *gwSTUF3,
		  double *swSTUF1, double *swSTUF2, double *swSTUF3);
void Flux_GWcells(int i0, int i1, int j0, int j1, float *SatWat, 
		  float *Unsat, float *SfWat, float *rate, 
		  float *poros, float *sp_yield, float *elev,
		  double *gwSTUF1, double *gwSTUF2, double *gwSTUF3,
		  double *swSTUF1, double *swSTUF2, double *swSTUF3);


/* externs */
/* from unitmod.h */
extern float* boundcond_depth;
extern int *basn, *BCondFlow;
extern float GP_DetentZ, GP_MinCheck;
extern float  GP_mannDepthPow, GP_mannHeadPow;
extern unsigned char *HAB;

/* from generic_driver.h */
extern int WatMgmtOn;
extern float step_Cell;

/* from budgstats_birvars.h */
extern double *VOL_IN_OVL, *VOL_IN_GW;
extern double *VOL_OUT_OVL, *VOL_OUT_GW;
extern double *P_IN_OVL, *P_IN_GW;
extern double *P_OUT_OVL, *P_OUT_GW;
extern double *S_IN_OVL, *S_IN_GW;
extern double *S_OUT_OVL, *S_OUT_GW;

/* from budgstats.h */
extern basnDef **basn_list;
extern basnDef *basins;
	
#endif   /* FLUX_H */

