/*! \file multi_run.h
\brief Header file for multiple simulation runs per program execution.

This defines or declares variables & functions that are global to MultiRun.c. \n

Note: documented with Doxygen, which expects specific syntax within special comments.  \n
	
The Everglades Landscape Model (ELM). \n
last updated: Feb 2005 \n
*/

/* General notes on revisions to this source file. 
       Feb 2005 v2.4.0 initial development
	
*/

#ifndef MULTI_RUN_H
#define MULTI_RUN_H

#include "globals.h"


int numRuns(int SParmNum, int NumSRunsPerSet);
int SensiParm_list(char* sparm_name);
void alloc_mem_runs(int SParmNum);



/* from generic_driver.h */
extern ProgAttr *ProgExec;
extern ProgAttr **RunList;

/* from driver_utilities.h */
extern char *ModelPath, *ProjName;

#endif  /* MULTI_RUN_H */
