/*! \file stage.h
\brief Header file for acquiring water depth (misnamed stage) grid_io data. 

This defines or declares variables & functions that are global to stage_inp.c.  \n

Note: documented with Doxygen, which expects specific syntax within special comments.  \n
	
The Everglades Landscape Model (ELM). \n
last updated: Jan 2005 \n
*/

#ifndef STAGE_H
#define STAGE_H

#include "gridmap.h"
#include "globals.h"

applicationStruct stage_struct;

char stage_binfilename[135];		/*!< grid_io binary data file name */
int stage_data_wmm(float*);		/*!< stage (depth) data array */

/* externs */
/* from driver_utilities.h */
extern char *ModelPath, *ProjName;
extern VOIDP nalloc(unsigned mem_size, const char var_name[]);

#endif  /* STAGE_H */
