/***************************************************************************
                          consolemsg.cpp  -  description
                             -------------------
    begin                : Tue Feb 11 2003
    copyright            : (C) 2003 by Beheen Trimble
    email                : btrimble@sfwmd.gov
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "consolemsg.h"

ConsoleMsg::ConsoleMsg(){estatus = -1; xstatus = 0; }

ConsoleMsg::ConsoleMsg(string name){
  Owner = name;
  estatus = -1;
  xstatus = 0;
}

ConsoleMsg::~ConsoleMsg() {
  #ifdef DEBUG
  //MsgDelete("ConsoleMsg");
  #endif
}


void  ConsoleMsg::DebugMsg(const char *msg, const char *arg, string arg1) {
  cout << endl;
  cout << msg << " ==> " << arg << " " << arg1 << endl;
}

void  ConsoleMsg::DebugMsg(const char *msg, double arg1, double arg2) {
  cout << msg << " ==> " << arg1 << " " << arg2 << endl;
}
            
void  ConsoleMsg::DebugMsg(const char *msg, const char *arg, int status) {
  cout << endl;
  cout << msg << " ==> " << arg <<  " " << status << endl;
}

void  ConsoleMsg::DebugMsg(const char *msg, string arg, int status) {
  cout << msg << " " << arg <<  " : (" << status << ")\n";
}

void  ConsoleMsg::DebugMsg(const char *msg, int arg, int status) {
  cout << msg << " " << arg <<  " : (" << status << ")\n";
}

void  ConsoleMsg::DebugMsg(const char *msg, double arg, int status) {
  cout << msg << " " << arg <<  " : (" << status << ")\n";
}

void  ConsoleMsg::DebugMsg(string msg, const char *arg, int status) {
  cout << msg << " " << arg <<  " : (" << status << ")\n";
}

void  ConsoleMsg::DebugMsg(string msg, string arg, int status) {
  cout << msg << " " << arg <<  " : (" << status << ")\n";
}

void  ConsoleMsg::DebugMsg(string msg, int arg, int status) {
  cout << msg << " " << arg <<  " : (" << status << ")\n";
}

void  ConsoleMsg::DebugMsg(string msg, double arg, int status) {
  cout << msg << " " << arg <<  " : (" << status << ")\n";
}


// Error Massage
void ConsoleMsg::MsgFail(const char *msg, const char *method) {
  cerr << endl;
  cerr << msg << " ==> " << "!!!!!!!!!!!!!!!!!!!!!!!!!!! =:( !!!! " << endl;
  cerr << msg << " ==> " << method << " Method Failed " << endl;
  cerr << msg << " ==> " << "!!!!!!!!!!!!!!!!!!!!!!!!!!! =:( !!!! " << endl;
}

void ConsoleMsg::ErrMsg(const char *msg, const char *arg) {
  cerr << endl;
  cerr << msg << " ==> " << "!!!!!!!!!!!!!!!!!!!!!!!!!!! =:( !!!! " << endl;
  cerr << msg << " ==> " << "Error In " << arg << endl;
  cerr << msg << " ==> " << "!!!!!!!!!!!!!!!!!!!!!!!!!!! =:( !!!! " << endl;
}


void ConsoleMsg::ErrMsg(const char *msg, const char *arg, int status) {
  cerr << msg << " " << arg <<  " : (" << status << ")\n";
}

void ConsoleMsg::ErrMsg(const char *msg, string arg, int status) {
  cerr << msg << " " << arg <<  " : (" << status << ")\n";
}

void ConsoleMsg::ErrMsg(const char *msg, int arg, int status) {
  cerr << msg << " " << arg <<  " : (" << status << ")\n";
}

void ConsoleMsg::ErrMsg(const char *msg, double arg, int status) {
  cerr << msg << " " << arg <<  " : (" << status << ")\n";
}

void ConsoleMsg::ErrMsg(string msg, const char *arg, int status) {
  cerr << msg << " " << arg <<  " : (" << status << ")\n";
}

void ConsoleMsg::ErrMsg(string msg, string arg, int status) {
  cerr << msg << " " << arg <<  " : (" << status << ")\n";
}

void ConsoleMsg::ErrMsg(string msg, int arg, int status) {
  cerr << msg << " " << arg <<  " : (" << status << ")\n";
}

void ConsoleMsg::ErrMsg(string msg, double arg, int status) {
  cerr << msg << " " << arg <<  " : (" << status << ")\n";
}

// Msg
void  ConsoleMsg::MsgWrite(const char *msg, const char *arg, string outfile) {
  cout << endl;
  cout << msg << " ==> " << "Writing " << arg << " to " << outfile << endl;
  cout << msg << " ==> " << "===========================" << endl;
}

void  ConsoleMsg::MsgPrint(const char *msg, const char *arg) {
  cout << msg << " ==> " << "Printing " << arg << endl;
  cout << msg << " ==> " << "===========================" << endl;
}

void  ConsoleMsg::MsgDelete(const char *msg) {
  cout << endl;
  cout << msg << " ==> " << "Deleting " << endl;
  cout << msg << " ==> " << "===========================" << endl;
}

void ConsoleMsg::Msg(const char *msg, const char *arg, int status) {
  cout << msg << " " << arg <<  " : (" << status << ")\n";
}

void ConsoleMsg::Msg(const char *msg, string arg, int status) {
  cout << msg << " " << arg <<  " : (" << status << ")\n";
}

void ConsoleMsg::Msg(const char *msg, int arg, int status) {
  cout << msg << " " << arg <<  " : (" << status << ")\n";
}

void ConsoleMsg::Msg(const char *msg, double arg, int status) {
  cout << msg << " " << arg <<  " : (" << status << ")\n";
}

void ConsoleMsg::Msg(string msg, const char *arg, int status) {
  cout << msg << " " << arg <<  " : (" << status << ")\n";
}

void ConsoleMsg::Msg(string msg, string arg, int status) {
  cout << msg << " " << arg <<  " : (" << status << ")\n";
}

void ConsoleMsg::Msg(string msg, int arg, int status) {
  cout << msg << " " << arg <<  " : (" << status << ")\n";
}

void ConsoleMsg::Msg(string msg, double arg, int status) {
  cout << msg << " " << arg <<  " : (" << status << ")\n";
}

// PrintKeywords
void ConsoleMsg::PrintKeywordMap(map<string, Keyword*> *keywords) {
  
  // Note that map->first returns the key, map->second returns the value
  map<string, Keyword*> :: const_iterator ki;

  cout.precision(15);

  MsgPrint("ConsoleMsg", "Keyword Map");
  for(ki = keywords->begin(); ki != keywords->end(); ++ki ) {

    // check the type field before printing
    string typ = ki->second->type;
    if(typ == "INT") cout << "ConsoleMsg ==> " << ki->first << ": " << ki->second->ivalue << endl;
    if(typ == "FLOAT") cout << "ConsoleMsg ==> " << ki->first << ": " << ki->second->fvalue << endl;
    if(typ == "DOUBLE") cout << "ConsoleMsg ==> " << ki->first << ": " << ki->second->dvalue << endl;
    if(typ == "STRING") cout << "ConsoleMsg ==> " << ki->first << ": " << ki->second->svalue << endl;
  }
}

