/***************************************************************************
                          grid.h  -  description
                             -------------------
    begin                : Thu Feb 20 2003
    copyright            : (C) 2003 by Beheen Trimble
    email                : btrimble@sfwmd.gov
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GRID_H
#define GRID_H

using namespace std;

#include <string>
#include <vector>
#include <map>
#include "point.h"
#include "cell.h"
#include "consolemsg.h"
#include "util.h"

/**
  *@author Beheen Trimble
  */

class Grid {
public: 
	Grid();
  Grid(string);
	~Grid();

  void setName(string);
  void setX_Origin(double);
  void setY_Origin(double);
  void setX_Direction(string);
  void setY_Direction(string);
  void setNumRow(int);
  void setNumCol(int);
  void setTimeStep(float);
  void setNumbering(int);
  void print();
  void printCorners(); 
  void setLowerLeftCorner(double,double);
  void setUpperRightCorner(double,double);
  void setLowerRightCorner(double,double);
  void setUpperLeftCorner(double,double);
  void drawCell(vector<int> ids,FILE*);
  void setCorners();
  void resetVectorPoint(Point*& start0, Point& ll, Point& lr, Point& ur, Point& ul);
  void setVectorCell(Point*& start0, Cell* cellr);
                           
  int defineCells();
  int setVectorPoint(Point* start0, Point& ll, Point& lr, Point& ur, Point& ul);
  int getNumCol();
  int getNumRow();        
  int getCellNumbers();
  int findCellNumber(Point&);
  int getNumbering();
  int writeGrid(string outfile, vector<string>);
  
  float getTimeStep();

  double getX_Origin();
  double getY_Origin();
  double getCellY(int cellNo);
  double getCellX(int cellNo);

  string getX_Direction();
  string getY_Direction();
  string getGridName();
  string getValueType();
      
  Point* getLowerLeftCorner();
  Point* getLowerRightCorner();
  Point* getUpperRightCorner();
  Point* getUpperLeftCorner();
  
  Cell* findCellByID(int);
  Cell* findCellByRowCol(int row, int col);
  
  vector<Cell*>& getCellList();

private: // Private attributes

  string GridName;
  string X_Direction;
  string Y_Direction;

  int NumRow;
  int NumCol;
  int Numbering;
  
  double X_Origin;
  double Y_Origin;
  float TimeStep;

  Point* LowerLeftCorner;
  Point* LowerRightCorner;
  Point* UpperRightCorner;
  Point* UpperLeftCorner;
  ConsoleMsg* console;
  vector<Cell*> cellList;

};

#endif
