/***************************************************************************
                          point.h  -  description
                             -------------------
    begin                : Sun Feb 23 2003
    copyright            : (C) 2003 by Beheen Trimble
    email                : btrimble@sfwmd.gov
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef POINT_H
#define POINT_H


/**
  *@author Beheen Trimble
  */


#include <math.h>
#include <iostream>
#include <iomanip>
#include <vector>
#include "consolemsg.h"


class Point {
public: 
  Point();
  Point(double, double);
  ~Point();
  Point(const Point &rhs);
  Point operator=(const Point&);
  Point operator=(const double);
  Point operator-(const Point&) const;
  Point operator+(const Point&) const;
  Point operator+=(const Point&);
  Point operator+=(const double);
  Point operator*(const double) const;
  Point operator/(const double) const;
  Point operator*=(const double);
  int operator== (const Point&) const ;
    
  friend  std::ostream& operator<<(std::ostream& s, const Point& p);
  friend  std::istream& operator>>(std::istream& s, Point& p);
    
  void setX(double);
  void setY(double);
  void print();
  double getX() const; 
  double getY() const;
  
  
   
private:  
  double x;
  double y;
  ConsoleMsg* console;
};  

// don't use word greater()!  is defined in stl.

inline Point largerXlargerYPoint(Point* p1, Point* p2) {

  double clipX, px1, px2;
  double clipY, py1, py2;

  px1 = p1->getX();
  py1 = p1->getY();

  px2 = p2->getX();
  py2 = p2->getY();

  if(px1 >= px2) {
    clipX = px1;

    if(py1 >= py2)
      clipY = py1;
    else if(py1 <= py2)
      clipY = py2;
  }
  else if(px2 >= px1) {
    clipX = px2;

    if(py2 >= py1)
      clipY = py2;
    else if(py2 <= py1)
      clipY = py1;
  }

  Point clipXY = Point(clipX,clipY);
  return (clipXY);
}

inline Point smallerXsmallerYPoint(Point* p1, Point* p2) {

  double clipX, px1, px2;
  double clipY, py1, py2;

  px1 = p1->getX();
  py1 = p1->getY();

  px2 = p2->getX();
  py2 = p2->getY();

  if(px1 <= px2) {
    clipX = px1;

    if(py1 <= py2)
      clipY = py1;
    else if(py1 >= py2)
      clipY = py2;
  }
  else if(px2 <= px1) {
    clipX = px2;

    if(py2 <= py1)
      clipY = py2;
    else if(py2 >= py1)
      clipY = py1;
  }
 

  Point clipXY = Point(clipX,clipY);
  return clipXY;
}


inline Point smallerXLargerYPoint(Point* p1, Point* p2) {

  double clipX=0.0, px1=0.0, px2=0.0;
  double clipY=0.0, py1=0.0, py2=0.0;

  px1 = p1->getX();
  py1 = p1->getY();

  px2 = p2->getX();
  py2 = p2->getY();
  
  if(px1 <= px2) {
    clipX = px1;

    if(py1 >= py2)
      clipY = py1;
    else if(py1 <= py2)
      clipY = py2;
  }
  
  else if(px2 <= px1) {
    clipX = px2;

    if(py2 >= py1)
      clipY = py2;
    else if(py2 <= py1)
      clipY = py1;
  }


  Point clipXY = Point(clipX,clipY);
  return clipXY;
}


inline Point largerXsmallerYPoint(Point* p1, Point* p2) {

  double clipX=0.0, px1=0.0, px2=0.0;
  double clipY=0.0, py1=0.0, py2=0.0;

  px1 = p1->getX();
  py1 = p1->getY();

  px2 = p2->getX();
  py2 = p2->getY();

  if(px1 >= px2) {
    clipX = px1;

    if(py1 <= py2)
      clipY = py1;
    else if(py1 >= py2)
      clipY = py2;
  }
  else if(px2 >= px1) {
    clipX = px2;

    if(py2 <= py1)
      clipY = py2;
    else if(py2 >= py1)
      clipY = py1;
  }

  Point clipXY = Point(clipX,clipY);
  return (clipXY);
}

inline std::ostream& operator<<(std::ostream& s, const Point& p){
  s << p.x << " " << p.y << " 0.0";  // use a 3d format for now
  return s;
}

inline std::istream& operator>>(std::istream& s, Point& p){
  s >> p.x >> p.y;
  return s;
}
     
#endif
