/***************************************************************************
                          util.cpp  -  description
                             -------------------
    begin                : Tue Feb 11 2003
    copyright            : (C) 2003 by Beheen Trimble
    email                : btrimble@sfwmd.gov
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

using namespace std;

#include <iostream>  // cout, cerr, ....
#include <fstream>   // to open the file via ifstream object
#include <vector>    // vector of strings to hold lines
#include <string>    

#include "util.h"
#include "consolemsg.h"

 /* This method tokenize a delimeted line into
   * a vector of strings or return NULL in the first
   * index if the line did not tokenize. At least one
   * delim must exist.
   */
  vector<string> myTokenize(string line, char delim) {

    string::size_type startPosition = 0;
    string::size_type endPosition = line.length();
    string::size_type startValuePosition = 0;
    int foundDelim = 0;  //no delim is found yet
    
    vector<string> token;
    
    while(startPosition < endPosition) {
      startValuePosition = line.find_first_of(delim, ++startValuePosition);
      // as long as find a delim, go ahead
      if(startValuePosition != line.npos) {
        foundDelim = 1;
        string s = line.substr(0,startValuePosition); 
        token.push_back(s);
        startPosition += (s.length() + 1);
        string news = line.substr(startValuePosition+1);
        line = news;
        startValuePosition = 0;
      }
      else { // reaches the last string

        if(!foundDelim) 
          token[0]="NULL";
        else {
          // condition to insure the termination
          startPosition = endPosition;
          // push the last string
          token.push_back(line);
        }            
      }  
    }
    
    return token;
  }  // end of tokenize

  /* This method returns a vector of unique
   * integers by using a map data structure.
   */
  vector<int> filter(vector<int> id) {

    map<int,int> fid;

    for(unsigned int i=0; i<id.size(); ++i)
      fid[id[i]] = id[i];

    vector<int> filteredId;
    map<int,int>::const_iterator itr;
    for(itr=fid.begin(); itr!=fid.end(); ++itr)
      filteredId.push_back(itr->first);
    return filteredId;
  } // end of filter


