/*! \file budgstats_birvars.h
\brief Header file for Basin/Indicator Region summary variables. 

This declares Basin/Indicator Region summary variables that are global to BudgStats.c.  \n

Note: documented with Doxygen, which expects specific syntax within special comments.  \n
	
The Everglades Landscape Model (ELM). \n
last updated: Jan 2005 \n
*/

#ifndef BUDGSTATS_BIRVARS_H
#define BUDGSTATS_BIRVARS_H

/*! \remarks This header file is generated from the "ModelOutlist_creator_v?.xls" OpenOffice workbook.
Editing this .h header source directly is not recommended w/o changing ModelOutlist_creator. \n
To add/remove a Basin/Indicator-Region-summary spatial variable to/from the model: \n
1) Enter/delete the variable documentation in ModelOutlist_creator_v?.xls; \n
2) Add/remove the 2 lines of code in the alloc_mem_stats function of BudgStats.c; \n
3) Budget/IndReg_summary output data is not modified by user (i.e., not in Model.outList); modify the output code if needed for new/deleted variable; \n
4) Export (cut&paste) the contents of this page into budgstats_birvars.h; \n
5) Use/delete the variable in the code equations! */




int *numCells; /*!< _Units_: dimless; _Brief_: Number of cells in a Basin/Indicator-Region */
double *EVAP; /*!< _Units_: m^3; _Brief_:  */
double *RAIN; /*!< _Units_: m^3; _Brief_:  */
double *RCHG; /*!< _Units_: m^3; _Brief_:  */
double *SUMGW; /*!< _Units_: m^3; _Brief_:  */
double *SUMSF; /*!< _Units_: m^3; _Brief_:  */
double *SUMUW; /*!< _Units_: m^3; _Brief_:  */
double *TOT_VOL; /*!< _Units_: m^3; _Brief_:  */
double *TOT_VOL_AVG_ERR; /*!< _Units_: m^3; _Brief_:  */
double *TOT_VOL_CAN        ; /*!< _Units_: m^3; _Brief_:  */
double *TOT_VOL_CUM_ERR; /*!< _Units_: m^3; _Brief_:  */
double *TOT_VOL_ERR; /*!< _Units_: m^3; _Brief_:  */
double *TOT_VOL_OLD; /*!< _Units_: m^3; _Brief_:  */
double *TRANSP; /*!< _Units_: m^3; _Brief_:  */
double *VOL_ERR_PER_INFL; /*!< _Units_: m^3; _Brief_:  */
double *VOL_IN; /*!< _Units_: m^3; _Brief_:  */
double *VOL_IN_AVG; /*!< _Units_: m^3; _Brief_:  */
double *VOL_IN_GW; /*!< _Units_: m^3; _Brief_:  */
double *VOL_IN_OVL        ; /*!< _Units_: m^3; _Brief_:  */
double *VOL_IN_SPG        ; /*!< _Units_: m^3; _Brief_:  */
double *VOL_IN_STR        ; /*!< _Units_: m^3; _Brief_:  */
double *VOL_IN_SUM; /*!< _Units_: m^3; _Brief_:  */
double *VOL_OUT; /*!< _Units_: m^3; _Brief_:  */
double *VOL_OUT_AVG; /*!< _Units_: m^3; _Brief_:  */
double *VOL_OUT_GW; /*!< _Units_: m^3; _Brief_:  */
double *VOL_OUT_OVL        ; /*!< _Units_: m^3; _Brief_:  */
double *VOL_OUT_SPG        ; /*!< _Units_: m^3; _Brief_:  */
double *VOL_OUT_STR        ; /*!< _Units_: m^3; _Brief_:  */
double *VOL_OUT_SUM; /*!< _Units_: m^3; _Brief_:  */
double *P; /*!< _Units_: kgP; _Brief_:  */
double *P_CELL; /*!< _Units_: kgP; _Brief_:  */
double *P_ERR; /*!< _Units_: kgP; _Brief_:  */
double *P_ERR_CUM; /*!< _Units_: kgP; _Brief_:  */
double *P_IN; /*!< _Units_: kgP; _Brief_:  */
double *P_IN_AVG; /*!< _Units_: kgP; _Brief_:  */
double *P_IN_GW; /*!< _Units_: kgP; _Brief_:  */
double *P_IN_OVL        ; /*!< _Units_: kgP; _Brief_:  */
double *P_IN_SPG        ; /*!< _Units_: kgP; _Brief_:  */
double *P_IN_STR        ; /*!< _Units_: kgP; _Brief_:  */
double *P_IN_SUM; /*!< _Units_: kgP; _Brief_:  */
double *P_OLD; /*!< _Units_: kgP; _Brief_:  */
double *P_OUT; /*!< _Units_: kgP; _Brief_:  */
double *P_OUT_AVG; /*!< _Units_: kgP; _Brief_:  */
double *P_OUT_GW; /*!< _Units_: kgP; _Brief_:  */
double *P_OUT_OVL        ; /*!< _Units_: kgP; _Brief_:  */
double *P_OUT_SPG        ; /*!< _Units_: kgP; _Brief_:  */
double *P_OUT_STR        ; /*!< _Units_: kgP; _Brief_:  */
double *P_OUT_SUM; /*!< _Units_: kgP; _Brief_:  */
double *P_RAIN ; /*!< _Units_: kgP; _Brief_:  */
double *TOT_P_CAN         ; /*!< _Units_: kgP; _Brief_:  */
double *dop_decomp; /*!< _Units_: kgP; _Brief_:  */
double *dop_desorb; /*!< _Units_: kgP; _Brief_:  */
double *dop_macIn; /*!< _Units_: kgP; _Brief_:  */
double *dop_sorbIn; /*!< _Units_: kgP; _Brief_:  */
double *floc_decomp; /*!< _Units_: kgP; _Brief_:  */
double *floc_In; /*!< _Units_: kgP; _Brief_:  */
double *P_DEAD; /*!< _Units_: kgP; _Brief_:  */
double *P_DEAD_CELL; /*!< _Units_: kgP; _Brief_:  */
double *P_DEAD_ERR; /*!< _Units_: kgP; _Brief_:  */
double *P_DEAD_ERR_CUM; /*!< _Units_: kgP; _Brief_:  */
double *P_DEAD_IN; /*!< _Units_: kgP; _Brief_:  */
double *P_DEAD_IN_AVG; /*!< _Units_: kgP; _Brief_:  */
double *P_DEAD_IN_SUM; /*!< _Units_: kgP; _Brief_:  */
double *P_DEAD_OLD; /*!< _Units_: kgP; _Brief_:  */
double *P_DEAD_OUT; /*!< _Units_: kgP; _Brief_:  */
double *P_DEAD_OUT_AVG; /*!< _Units_: kgP; _Brief_:  */
double *P_DEAD_OUT_SUM; /*!< _Units_: kgP; _Brief_:  */
double *Calg_GPP; /*!< _Units_: kgP; _Brief_:  */
double *Calg_mort; /*!< _Units_: kgP; _Brief_:  */
double *mac_mort; /*!< _Units_: kgP; _Brief_:  */
double *mac_NPP; /*!< _Units_: kgP; _Brief_:  */
double *NCalg_GPP; /*!< _Units_: kgP; _Brief_:  */
double *NCalg_mort; /*!< _Units_: kgP; _Brief_:  */
double *P_Calg; /*!< _Units_: kgP; _Brief_:  */
double *P_LIVE; /*!< _Units_: kgP; _Brief_:  */
double *P_LIVE_CELL; /*!< _Units_: kgP; _Brief_:  */
double *P_LIVE_ERR; /*!< _Units_: kgP; _Brief_:  */
double *P_LIVE_ERR_CUM; /*!< _Units_: kgP; _Brief_:  */
double *P_LIVE_IN; /*!< _Units_: kgP; _Brief_:  */
double *P_LIVE_IN_AVG; /*!< _Units_: kgP; _Brief_:  */
double *P_LIVE_IN_SUM; /*!< _Units_: kgP; _Brief_:  */
double *P_LIVE_OLD; /*!< _Units_: kgP; _Brief_:  */
double *P_LIVE_OUT; /*!< _Units_: kgP; _Brief_:  */
double *P_LIVE_OUT_AVG; /*!< _Units_: kgP; _Brief_:  */
double *P_LIVE_OUT_SUM; /*!< _Units_: kgP; _Brief_:  */
double *P_MAC; /*!< _Units_: kgP; _Brief_:  */
double *P_NCalg; /*!< _Units_: kgP; _Brief_:  */
double *P_settl; /*!< _Units_: kgP; _Brief_:  */
double *P_WAT; /*!< _Units_: kgP; _Brief_:  */
double *P_WAT_CELL; /*!< _Units_: kgP; _Brief_:  */
double *P_WAT_ERR; /*!< _Units_: kgP; _Brief_:  */
double *P_WAT_ERR_CUM; /*!< _Units_: kgP; _Brief_:  */
double *P_WAT_IN; /*!< _Units_: kgP; _Brief_:  */
double *P_WAT_IN_AVG; /*!< _Units_: kgP; _Brief_:  */
double *P_WAT_IN_SUM; /*!< _Units_: kgP; _Brief_:  */
double *P_WAT_OLD; /*!< _Units_: kgP; _Brief_:  */
double *P_WAT_OUT; /*!< _Units_: kgP; _Brief_:  */
double *P_WAT_OUT_AVG; /*!< _Units_: kgP; _Brief_:  */
double *P_WAT_OUT_SUM; /*!< _Units_: kgP; _Brief_:  */
double *wat_sedMiner; /*!< _Units_: kgP; _Brief_:  */
double *wat_sedUpt; /*!< _Units_: kgP; _Brief_:  */
double *wat_sfMiner; /*!< _Units_: kgP; _Brief_:  */
double *wat_sfUpt; /*!< _Units_: kgP; _Brief_:  */
double *S_ERR_CUM; /*!< _Units_: kgSalt; _Brief_:  */
double *S_IN; /*!< _Units_: kgSalt; _Brief_:  */
double *S_IN_AVG; /*!< _Units_: kgSalt; _Brief_:  */
double *S_IN_GW; /*!< _Units_: kgSalt; _Brief_:  */
double *S_IN_OVL        ; /*!< _Units_: kgSalt; _Brief_:  */
double *S_IN_SPG        ; /*!< _Units_: kgSalt; _Brief_:  */
double *S_IN_STR        ; /*!< _Units_: kgSalt; _Brief_:  */
double *S_IN_SUM; /*!< _Units_: kgSalt; _Brief_:  */
double *S_OUT; /*!< _Units_: kgSalt; _Brief_:  */
double *S_OUT_AVG; /*!< _Units_: kgSalt; _Brief_:  */
double *S_OUT_GW; /*!< _Units_: kgSalt; _Brief_:  */
double *S_OUT_OVL        ; /*!< _Units_: kgSalt; _Brief_:  */
double *S_OUT_SPG        ; /*!< _Units_: kgSalt; _Brief_:  */
double *S_OUT_STR        ; /*!< _Units_: kgSalt; _Brief_:  */
double *S_OUT_SUM; /*!< _Units_: kgSalt; _Brief_:  */
double *TOT_S; /*!< _Units_: kgSalt; _Brief_:  */
double *TOT_S_CAN          ; /*!< _Units_: kgSalt; _Brief_:  */
double *TOT_S_CELL ; /*!< _Units_: kgSalt; _Brief_:  */
double *TOT_S_ERR; /*!< _Units_: kgSalt; _Brief_:  */
double *TOT_S_OLD; /*!< _Units_: kgSalt; _Brief_:  */
double *Cperi_avg; /*!< _Units_: ; _Brief_:  */
double *Elev_avg; /*!< _Units_: ; _Brief_:  */
double *Mac_avg; /*!< _Units_: ; _Brief_:  */
double *NCperi_avg; /*!< _Units_: ; _Brief_:  */
double *Sfwat_avg; /*!< _Units_: ; _Brief_:  */
double *TPpore_avg; /*!< _Units_: ; _Brief_:  */
double *TPsf_avg; /*!< _Units_: ; _Brief_:  */
double *TPsoil_avg; /*!< _Units_: ; _Brief_:  */
double *Unsat_avg; /*!< _Units_: ; _Brief_:  */



#endif /* BUDGSTATS_BIRVARS_H */
