/*! \file evap.h
\brief Header file for acquiring potential ET grid_io data. 

This defines or declares variables & functions that are global to evap_inp.c.  \n

Note: documented with Doxygen, which expects specific syntax within special comments.  \n
	
The Everglades Landscape Model (ELM). \n
last updated: Jan 2005 \n
*/

#ifndef EVAP_H
#define EVAP_H

#include "gridmap.h"
#include "globals.h"

applicationStruct evap_struct;

char evap_binfilename[135];		/*!< grid_io binary data file name */
int evap_data_wmm(float*);		/*!< potential ET data array */

/* externs */
/* from driver_utilities.h */
extern char *ModelPath, *ProjName;
extern VOIDP nalloc(unsigned mem_size, const char var_name[]);

#endif  /* EVAP_H */
