/*! \file rain.h
\brief Header file for acquiring rainfall grid_io data. 

This defines or declares variables & functions that are global to rain_inp.c.  \n

Note: documented with Doxygen, which expects specific syntax within special comments.  \n
	
The Everglades Landscape Model (ELM). \n
last updated: Jan 2005 \n
*/

#ifndef RAIN_H
#define RAIN_H

#include "gridmap.h"
#include "globals.h"

applicationStruct rain_struct;

char rain_binfilename[135];		/*!< grid_io binary data file name */
int rain_data_wmm(float*);		/*!< rainfall data array */

/* externs */
/* from driver_utilities.h */
extern char *ModelPath, *ProjName;
extern VOIDP nalloc(unsigned mem_size, const char var_name[]);

#endif  /* RAIN_H */
