/*! \file serial.h
\brief Header file for Serial (non-parallel) utilities. 

This defines or declares variables & functions that are global to Serial.c. \n

Note: documented with Doxygen, which expects specific syntax within special comments.  \n
	
The Everglades Landscape Model (ELM). \n
last updated: Dec 2004 \n
*/

/* General notes on revisions to this source file. 
       Nov/Dec 2004 v2.3.2: documentation upgrade 
       		- Re-organized, clarified scopes, Doxygen tags added 
	
*/

#ifndef SERIAL_H
#define SERIAL_H

#include "globals.h"
#if HDF /* (Nov 2004): do not #define HDF to true (globals.h) until hdf header sources are updated */
#include "hdf.h"
#endif


#define HDF_VERIFY(a) if(ret == FAIL) { printf("*** UNEXPECTED RETURN from %s is %d\n", a, (int)ret); }

	/*! Global per-map-stream structure for spatial array summaries (debug-related) */
struct combo_table      
{
  char  name[25];       /*!< File name */
  int step;             /*!< Current step */
  int type;             /*!< Combo type */
  int ocnt;             /*!< # of times currently open */
  float fvalue[10];     /*!< var vakye */
  UCHAR  free;          /*!< free slot */
};


/* char gSectorChar = ''; */ /* this was changed (in HabParms dbase); the ascii special char had Macintosh origin (worked in code, but obscure translation in other OS) */
/* char gHabChar = ''; */    /* this was changed (in HabParms dbase); the ascii special char had Macintosh origin (worked in code, but obscure translation in other OS) */
char gSectorChar = '@'; 	/*!< delimiter for ecological module (i.e., sector) ID number in reading habitat-specfic database file */
char gHabChar = '^';   		 /*!< delimiter for habitat ID number in reading habitat-specfic database file */
int habNumTot = 0;					/*!< total number of habitat-types used in model */

char fileDelimitChar = ''; /* unused in v2.3 and above; the special char removed from .c source, put here only to indicate the past use of this special char in file name delimitation */
char cTemp[200];		/*!< A temp char holder  */
char gTerm[4];			/*!< Four different characters to denote the format type of the model outlist configuration file */

char gCArg[kCArgDepth][kCArgWidth];	/*!< Output command arguments, parsed from the output configuration file */

int cell_pts[MAX_TS_FILES]; 	/*!< The number of cell point locs per variable (1 var per file) for point time series output (clumsy) */
int numPtFiles=0; 				/*!< The number of files (= variables) for point time series output (clumsy) */

FILE* dFile;			/*!< File pointer to the low-level (ELM.debug) debug file */
FILE* Driver_outfile;	/*!< File pointer to (Driver0.out, or DriverX.out (for X'th simulation run)) debug file(s) */
FILE* *cnfgFile;		/*!< File pointer to the output (Model.outList) configuration file */
	
#define MAXCOMBOS  30   				/*!< Maximum # of current combos used for spatial array summaries (debug-related) */
struct combo_table ctable[MAXCOMBOS];   /*!< Combination table for spatial array summaries (debug-related) */
UINT max_combos_open;    				 /*!< Max open map streams for spatial array summaries (debug-related) */              

void writeMap(char*, void*, int, unsigned char, int);
void write_header(char* mapFileName,int size);
void send_point_lists2(SeriesParm *pSeries, int nSeries);
void writeSeries(void* fValue, char* label, char* desc, int N0, int N1, byte Mtype, byte format);
void Combine(float* fValue, char* label, int nComp, int cType, int step);
void open_point_lists(SeriesParm *pSeries, int nSeries);

void exparam( struct nodenv* envInfo);
void exgridsplit(int nprocs, int ndim,int nprocs2[2]);
void exgridcoord(int pnum, int rnum[2]);
void exgridsize( int pnum, int gsize[2],int lsize[2],int lstart[2]);
void set_async_mode(FILE* file);
void fmulti(FILE* file);
void fsingl(FILE* file);
void fasync(FILE* file);
void exchange_borders(UCHAR* map, int size);
void Cplot(VOIDP Map, unsigned char Mtype, float max_value, float min_value);
void broadcastMsg( UCHAR* msgPtr);
void broadcastInt(int* iValPtr);
void broadcastChar(UCHAR* cPtr);
void broadcastData( void* dataPtr, int *dataSize);
void broadcastFloat(void* dataPtr);
void sync_processors();
void open_debug_outFile(int index);
int exgridinit(int dim, int* nprocs);
int on_this_proc(int x,int y);
void local_setup(int argc, char** argv);

int init_config_file(FILE *vpFile, char term1, char term2, char term3, char term4);
int skip_cnfg_space(FILE *vpFile, char* tch);
int parse_packet( FILE *vpFile, int* nArgs, char* test);
int get_number(FILE *infile );
int goto_index(FILE *infile, char tchar, int index);
int read_header(char* mapfile);
int getCombineIndex( char* name, int step,int type,int *last);

float* get_hab_parm(char* s_parm_name, int s_parm_relval, char* parmName);
float get_global_parm(char* s_parm_name, int s_parm_relval, char* parmName );
float get_Nth_parm( FILE *infile, int pIndex, int* end, int hIndex );
char* match_Sparm( char* s_parm_name, int s_parm_relval, char* parmName); 

float SMDRAND(float fminVal, float fmaxVal);
float* readSeriesCol(char *filename, int format, int index, int* Npt, float* TStep, int col);

byte readMap(char*, void*);

int gSLen[MAX_NHAB]; /* unused */

/* externs */
/* from driver_utilities.h */
extern char *ProjName;
extern char *ModelPath;
extern char *OutputPath;
extern char modelName[20], modelVers[10];

extern void fatal(const char *msg);
extern void calcdate(double jd, int *m, int *d, int *y, int *h, int *mi, double *sec);
extern int skip_white(FILE* infile);
extern int scan_forward (FILE* infile, const char* tstring);
extern int find_char(FILE *infile, char tchar);
extern double julday(int mon, int day, int year, int h, int mi, double se);
extern VOIDP nalloc(unsigned mem_size, const char var_name[]);

/* from generic_driver.h */
extern char SimAlt[20];        
extern char SimModif[20];        
extern int gbl_size[2]; 
extern int seed; 
extern int procnum, Lprocnum, nprocs[2], nproc, recpnum[2], tramType, tramNum[2];
extern int PORnumday;
extern double Jdate_init;

#endif  /* SERIAL_H */
