/*! \file unitmod_globparms.h
\brief Header file for global parameters for the ecological Unit Model. 

This declares non-habitat-specific parameters that are global to Unit_Mod.c.  \n

Note: documented with Doxygen, which expects specific syntax within special comments.  \n
	
The Everglades Landscape Model (ELM). \n
last updated: Jan 2005 \n
*/

/* General notes on revisions to this source file. 
       Jan 2005 v2.3.3: documentation upgrade 
       		- Re-organized, clarified scopes, Doxygen tags added 
       		- Created quasi-automated unitmod_*.h header file generation for vars and parms 
	
*/

#ifndef UNITMOD_GLOBPARMS_H
#define UNITMOD_GLOBPARMS_H

/*! \remarks This header file is generated from the "GlobalParms_v?.xls" OpenOffice workbook.
Editing this .h header source directly is not recommended w/o changing GlobalParms. \n
To add/remove a Global (non-habitat-specific) parameter to/from the model: \n
1) Enter/delete the parameter data and documentation in GlobalParms_v?.xls; \n
2) Add/remove the line of code in the ReadGlobalParms function of UnitMod.c; \n
3) Export (cut&paste) the contents of this page into unitmod_globparms.h; \n
4) Use/delete the parameter in the code equations! */

float GP_SOLOMEGA; /*!< Global parameter. _Units_: dimless; _Brief_: ***empirical constant used in solar radiation, don't change from 0.03259; _Extended_: fixed published value */
float GP_ALTIT; /*!< Global parameter. _Units_: m; _Brief_: ***regional altitude of land surface; _Extended_: pertinent only to moving model to other region */
float GP_LATDEG; /*!< Global parameter. _Units_: deg.min; _Brief_: ***regional latitude (degrees.minutes, don't convert min to decimal deg) ; _Extended_: pertinent only to moving model to other region */
float GP_mannDepthPow; /*!< Global parameter. _Units_: dimless; _Brief_: ***power used in manning's equation water depth; _Extended_: for "true" manning's, use 1.667  */
float GP_mannHeadPow; /*!< Global parameter. _Units_: dimless; _Brief_: ***power used in manning's equation head difference; _Extended_: for "true" manning's, use 2.0  */
float GP_calibGWat; /*!< Global parameter. _Units_: dimless; _Brief_: ***calibration parameter, multiply groundwater cell-cell flow calculation; _Extended_: v2.3=1.05 */
float GP_IDW_pow; /*!< Global parameter. _Units_: dimless; _Brief_: ***power for (all) inverse distance^parm interpolations; _Extended_: have always used IDW^2 (parm=2.0) */
float GP_calibET; /*!< Global parameter. _Units_: dimless; _Brief_: ***calibration parameter, multiply potential ET input data; _Extended_:  */
float GP_DATUM_DISTANCE; /*!< Global parameter. _Units_: m; _Brief_: ***distance below NGVD'29 to base datum; _Extended_: not simulating deep aquifer; non-critical parameter */
float GP_HYD_IC_SFWAT_ADD; /*!< Global parameter. _Units_: m; _Brief_: ***surf water depth added to Initial Condition ponded surface water depth map (+/- m) ; _Extended_: only used in exploratory model experiments */
float GP_HYD_IC_UNSAT_ADD; /*!< Global parameter. _Units_: m; _Brief_: ***depth of unsat zone added to Initial Condition unsaturated water storage depth map (+/-m) ; _Extended_: only used in exploratory model experiments; v2.3=1 */
float GP_HYD_RCRECHG; /*!< Global parameter. _Units_: m/d; _Brief_: ***Rate of recharging of the aquifer below the base datum (loss from model system). ; _Extended_: ***should always=0.0, deep recharge effectively not implemented */
float GP_HYD_ICUNSATMOIST; /*!< Global parameter. _Units_: dimless; _Brief_: ***Initial condition of the moisture proportion in the unsaturated zone. ; _Extended_: limited spatial data; non-critical initial condition */
float GP_DetentZ; /*!< Global parameter. _Units_: m; _Brief_: ***detention depth in a grid cell, below which surface flows do not occur; _Extended_: scale-dependent relative to topographic heterogeneity */
float GP_MinCheck; /*!< Global parameter. _Units_: m; _Brief_: ***small threshold number, for relative error-checking (not a multiplier etc); _Extended_: only used in constraining fluxes at extremely mimimal conditions */
float GP_dispLenRef; /*!< Global parameter. _Units_: m; _Brief_: ***reference length for which numerical dispersion (of finite difference sol'n) approximates actual turbulent diffusion, or dispersion; _Extended_: code not truly established for input of actual dispersion estimates - at this point, dispersion is poorly quantified in these wetlands */
float GP_dispParm; /*!< Global parameter. _Units_: dimless; _Brief_: ***calibration parameter, can be ~representative of Dispersion Number estimates; a value of 0 removes any dispersion adjustments (leaving only the numerical dispersion of model scale); _Extended_: code not truly established for input of actual dispersion estimates - at this point, dispersion is poorly quantified in these wetlands */
float GP_SLRise; /*!< Global parameter. _Units_: m/yr; _Brief_: ***rate of Sea Level Rise; _Extended_: based on CERP Guidance Memo 016.00 */

float GP_ALG_IC_MULT; /*!< Global parameter. _Units_: dimless; _Brief_: ***algal init-cond multiplier (0-1 proportion, relative to maximum attainable biomass); _Extended_: intended only for use in exploratory model experiments */
float GP_alg_uptake_coef; /*!< Global parameter. _Units_: dimless; _Brief_: ***parameter for exp function describing uptake kinetics; _Extended_: only used to define (fixed) function behavior; set at 3.0 */
float GP_ALG_SHADE_FACTOR; /*!< Global parameter. _Units_: dimless; _Brief_: ***calibration parm to modify LAI in shading fcn; _Extended_: regulate magnitude of macrophyte shading; CALIBRATE to achieve observed periphyton biomass in dense/moderate vegetation; v2.3=1.2 */
float GP_algMortDepth; /*!< Global parameter. _Units_: m; _Brief_: ***depth of the unsat zone below which accelerated "drydown" alg mort occurs ; _Extended_: limited field observations */
float GP_ALG_RC_MORT_DRY; /*!< Global parameter. _Units_: 1/d; _Brief_: ***Specific mortality rate of benthic algae (periphyton) in "drydown" conditions.  ; _Extended_: limited field observations; preliminary lab experiments; v2.3=0.05 */
float GP_ALG_RC_MORT; /*!< Global parameter. _Units_: 1/d; _Brief_: ***Baseline specific rate of algal (periphyton) mortality.  Note that this is in the presence of water. ; _Extended_: liimited field observations relating to biomass changes */
float GP_ALG_RC_PROD; /*!< Global parameter. _Units_: 1/d; _Brief_: ***Maximum specific rate observed/attainable of algal (periphyton) gross primary production.  ; _Extended_: field experiments (and O2->Carbon conversion); CALIBRATE to achieve observed periphyton production rates; v2.3=0.2 */
float GP_ALG_RC_RESP; /*!< Global parameter. _Units_: 1/d; _Brief_: ***Max specific rate of algal respiration.  ; _Extended_: field experiments (and O2->Carbon conversion) */
float GP_alg_R_accel; /*!< Global parameter. _Units_: dimless; _Brief_: ***acceleration of mortality (via assumed loss of calcareous sheath) of oligotrophic community under high phosphorus conditions; _Extended_: due to uncertainty of mechanism for mat loss, increase loss at elevated P concentrations; CALIBRATE to achieve biomass  observations */
float GP_AlgComp; /*!< Global parameter. _Units_: dimless; _Brief_: ***algal density-dep competition, with parameter >1.0 increasing competitive "ability" of oligotrophic periphyton; _Extended_: CALIBRATE to achieve relative biomass estimates of the two communities under low nutrient conditions */
float GP_ALG_REF_MULT; /*!< Global parameter. _Units_: dimless; _Brief_: ***proportion of max attainable periphyton biomass, defining a refuge density (from losses); _Extended_: this parameter multiplied by HP_ALG_MAX habitat-specific parameter to obtain refuge density; proxy for maintaining senescent stocks under severe drydown conditions */
float GP_NC_ALG_KS_P; /*!< Global parameter. _Units_: mg/L; _Brief_: ***half-saturation conc of avail phosphorus for uptake kinetics, eutrophic (was non-calcareous); _Extended_: Lab study; CALIBRATE to achieve plant growth rates along nutrient gradients; v2.3=0.15 */
float GP_alg_alkP_min; /*!< Global parameter. _Units_: dimless; _Brief_: ***minimum possible constraint level (0-1) on phosphorus uptake and growth;  value>0 indicative of non-zero nutrient limitation due to APActivity ; _Extended_: a proportion >0 is indicative of the observed continued (low) uptake and growth by periphyton at very low ambient P concentrations, due to alkaline phosphotase activity increasing bioavailability in low P conditions */
float GP_C_ALG_KS_P; /*!< Global parameter. _Units_: mg/L; _Brief_: ***half-saturation conc of avail phosphorus for uptake kinetics,  oligotrophic (was calcareous) periph; _Extended_: Lab study; CALIBRATE to achieve plant growth rates along nutrient gradients; v2.3=0.1 */
float GP_ALG_TEMP_OPT; /*!< Global parameter. _Units_: deg C; _Brief_: ***Optimal temperature for algal primary production (degrees C).  Also used in respiration control.; _Extended_: General literature estimates relative to plant type/family */
float GP_C_ALG_threshTP; /*!< Global parameter. _Units_: mg/L; _Brief_: ***TP conc above which oligotrophic (was calcareous) periphyton have elevated mortality (via asmed loss of calcareous sheath); _Extended_: due to uncertainty of mechanism for mat loss, increase respiration loss at elevated P concentrations; CALIBRATE to achieve biomass  observations */
float GP_ALG_C_TO_OM; /*!< Global parameter. _Units_: gC/gOM; _Brief_: ***Mass ratio of organic carbon to total organic material in algae (ash free dry weight).  ; _Extended_: multiple glades field and lab observations */
float GP_alg_light_ext_coef; /*!< Global parameter. _Units_: 1/m; _Brief_: ***light extinction parameter, currently used to fully define (statically) extinction; _Extended_: fixed extinction coef for clear water */
float GP_ALG_LIGHT_SAT; /*!< Global parameter. _Units_: cal/cm^2/d; _Brief_: ***Saturating light intensity for algal photosyn (langley/d = cal/cm^2 per day); _Extended_: assume max normal radiation is saturation */
float GP_ALG_PC; /*!< Global parameter. _Units_: gP/gC; _Brief_: ***Initial phophorus:carbon ratio in all algae/periphyton; _Extended_: multiple glades field and lab observations */

float GP_DOM_RCDECOMP; /*!< Global parameter. _Units_: 1/d; _Brief_: ***Maximum observed/attainable specific rate of organic matter decomposition (w/o limitations); _Extended_: field and lab studies, glades peat-systems */
float GP_DOM_DECOMPRED; /*!< Global parameter. _Units_: dimless; _Brief_: ***under anaerobic conditions, proportional reduction of the maximum rate of aerobic decomposition; _Extended_: glades lab experiments */
float GP_calibDecomp; /*!< Global parameter. _Units_: dimless; _Brief_: ***calibration parameter, multiply soil/floc decomposition flux calculation ; _Extended_:  */
float GP_DOM_decomp_coef; /*!< Global parameter. _Units_: dimless; _Brief_: ***parameter for exp function describing decomposition kinetics; _Extended_: only used to define (fixed) function behavior */
float GP_DOM_DECOMP_POPT; /*!< Global parameter. _Units_: mg/L; _Brief_: ***Optimal phosphorus concentration in water for maximal decomposition of organic matter; _Extended_: glades lab experiments; v2.3=0.55 */
float GP_DOM_DECOMP_TOPT; /*!< Global parameter. _Units_: deg C; _Brief_: ***Optimal temperature for maximal decomposition of organic matter; _Extended_: assume max normal temperature is optimum */
float GP_sorbToTP; /*!< Global parameter. _Units_: dimless; _Brief_: ***initial condition only, the ratio of sorbed phosphorus to total phosphorus in soil; _Extended_: generalization of soilTP conc initial condition */
float GP_IC_BATHY_MULT; /*!< Global parameter. _Units_: dimless; _Brief_: ***Bathymetry initial condition multiplier, mutiply by the bathymetry initial condition (actually static) map; _Extended_: intended only for use in exploratory model experiments */
float GP_IC_TPtoSOIL_MULT; /*!< Global parameter. _Units_: dimless; _Brief_: ***Soil TP concentration initial condition multiplier, mutiply by the TPsoil initial condition map; _Extended_: intended only for use in exploratory model experiments */
float GP_IC_DOM_BD_MULT; /*!< Global parameter. _Units_: dimless; _Brief_: Organic bulk density initial condition multiplier, mutiply by the Organic Bulk Density initial condition map; _Extended_: intended only for use in exploratory model experiments */
float GP_IC_BulkD_MULT; /*!< Global parameter. _Units_: dimless; _Brief_: ***Soil bulk density initial condition multiplier, mutiply by the soil bulk density initial condition (actually static) map; _Extended_: intended only for use in exploratory model experiments */
float GP_IC_ELEV_MULT; /*!< Global parameter. _Units_: dimless; _Brief_: ***Land elevation initial condition multiplier, mutiply by the elevation initial condition map; _Extended_: intended only for use in exploratory model experiments */

float GP_MAC_IC_MULT; /*!< Global parameter. _Units_: dimless; _Brief_: ***macrophyte initial condition multiplier (0-1 proportion, relative to maximum attainable (photo, non-photo) biomass); _Extended_: intended only for use in exploratory model experiments */
float GP_MAC_REFUG_MULT; /*!< Global parameter. _Units_: dimless; _Brief_: ***proportion of max attainable macrophyte biomass, defining a refuge density (from losses); _Extended_: this parameter multiplied by HP_PH{NPH}BIO_MAX to obtain refuge density; proxy for maintaining a seed source */
float GP_mac_uptake_coef; /*!< Global parameter. _Units_: dimless; _Brief_: ***parameter for exp function describing nutrient uptake kinetics; _Extended_: only used to define (fixed) function behavior */
float GP_mann_height_coef; /*!< Global parameter. _Units_: dimless; _Brief_: ***proportion of height at which macrophyte starts to bend over in flowing systems; _Extended_: used in determining appropriate breakpoint in manning's n */

float GP_Floc_BD; /*!< Global parameter. _Units_: mg/cm3; _Brief_: ***bulk density of floc layer (mg/cm3 == kg/m3) ; _Extended_: generalized from multiple soil cores */
float GP_FlocMax; /*!< Global parameter. _Units_: m; _Brief_: ***max floc depth observed/attainable; _Extended_: generalized from multiple soil cores */
float GP_TP_P_OM; /*!< Global parameter. _Units_: gP/gOM; _Brief_: ***phosphorus to organic matter ratio of particulate phosphorus (ash-free masses); _Extended_: standard redfield ratios */
float GP_Floc_rcSoil; /*!< Global parameter. _Units_: 1/d; _Brief_: ***baseline rate of floc layer consolidation into the soil matrix (under flooded conditions); _Extended_: CALIBRATE to achieve spatial and temporal distribution in floc depth */

float GP_TP_DIFFCOEF; /*!< Global parameter. _Units_: cm^2/sec; _Brief_: ***Phosphorus molecular (surface-soil water) diffusion coefficient. ; _Extended_: general literature value */
float GP_TP_K_INTER; /*!< Global parameter. _Units_: mg/L; _Brief_: ***intercept for Freundlich soil sorption eqn; _Extended_: lab study */
float GP_TP_K_SLOPE; /*!< Global parameter. _Units_: dimless; _Brief_: ***slope for Freundlich soil sorption eqn; _Extended_: lab study */
float GP_WQMthresh; /*!< Global parameter. _Units_: m; _Brief_: ***UNUSED in ELM - EWQM implementation ONLY: water depth threshold below which settling stops (EWQM used 0.15m); _Extended_: ONLY used to emulate Everglades Water Quallity Model; v2.3=0.01 */
float GP_PO4toTP; /*!< Global parameter. _Units_: dimless; _Brief_: ***slope of empirical regression of predicting PO4 from TP from long-term historical data, northern Everglades locations; _Extended_: synoptic (northern) glades monitoring  */
float GP_TP_IN_RAIN; /*!< Global parameter. _Units_: mg/L; _Brief_: ***TP concentration in rainfall (will be switching to new data for versions > ELMv2.2); _Extended_: glades literature estimates; to incorporate recent reviews of data */
float GP_PO4toTPint; /*!< Global parameter. _Units_: mg/l; _Brief_: ***intercept of empirical regression of predicting PO4 from TP from long-term historical data, northern Everglades locations; _Extended_: synoptic (northern) glades monitoring  */
float GP_TP_ICSFWAT; /*!< Global parameter. _Units_: mg/L; _Brief_: ***initial TP concentration, surface water; _Extended_: global estimate */
float GP_TP_ICSEDWAT; /*!< Global parameter. _Units_: mg/L; _Brief_: ***initial TP concentration, soil pore water; _Extended_: global estimate */
float GP_TPpart_thresh; /*!< Global parameter. _Units_: mg/L; _Brief_: ***TP conc used for predicting particulate P for settling; _Extended_: generalized estimate from (relatively limited) POC and TP observations */
float GP_TP_DIFFDEPTH; /*!< Global parameter. _Units_: m; _Brief_: ***depth of surface-soil water diffusion zone; _Extended_: large depth due to poorly defined soil-water interface (w/ floc) */
float GP_settlVel; /*!< Global parameter. _Units_: m/d; _Brief_: ***ELM (NOT EWQM emulation) mean settling velocity of particulate phosphorus (NOT of Total Phosphorus); _Extended_: Calibrated parameter: "Black-box" to incorporate particulate settling and microbial uptake at high concentrations/particulate levels */



#endif /* UNITMOD_GLOBPARMS_H */
