/*! \file unitmod_habparms.h
\brief Header file for habitat-specific parameters for the ecological Unit Model. 

This declares habitat-specific parameters that are global to Unit_Mod.c.  \n

Note: documented with Doxygen, which expects specific syntax within special comments.  \n
	
The Everglades Landscape Model (ELM). \n
last updated: Jan 2005 \n
*/

/* General notes on revisions to this source file. 
       Jan 2005 v2.3.3: documentation upgrade 
       		- Re-organized, clarified scopes, Doxygen tags added 
       		- Created quasi-automated unitmod_*.h header file generation for vars and parms 
	
*/

#ifndef UNITMOD_HABPARMS_H
#define UNITMOD_HABPARMS_H

/*! \remarks This header file is generated from the "HabParms_v?.xls" OpenOffice workbook.
Editing this .h header source directly is not recommended w/o changing HabParms. \n
To add/remove a habitat-specific parameter to/from the model: \n
1) Enter/delete the parameter data and documentation in HabParms_v?.xls; \n
2) Add/remove the line of code in the ReadHabParms function of UnitMod.c; \n
3) Add/remove the line of code in the alloc_memory function of UnitMod.c; \n
3) Export (cut&paste) the contents of this page into unitmod_habparms.h; \n
4) Use/delete the parameter in the code equations! */

float *HP_ALG_MAX; /*!< Habitat-specific parameter. _Units_: gC/m^2; _Brief_: Maximum attainable (observed)  algal biomass density. */

float *HP_FLOC_IC; /*!< Habitat-specific parameter. _Units_: kgOM/m^2; _Brief_: Initial mass of floc organic material  (ash free dry weight). */
float *HP_FLOC_IC_CTOOM; /*!< Habitat-specific parameter. _Units_: dimless; _Brief_: Initial mass ratio of organic carbon to total organic material in floc (ash free dry weight).   */
float *HP_FLOC_IC_PC; /*!< Habitat-specific parameter. _Units_: dimless; _Brief_: Initial mass ratio of phosphorus to carbon in floc organic matter (ash free dry weight).   */

float *HP_DOM_MAXDEPTH; /*!< Habitat-specific parameter. _Units_: m; _Brief_: Maximum depth (positive, from sediment surface) of Deposited Organic Matter to consider in model.  This determines the depth of the active DOM zone for all model dynamics via: 1) decomposition, 2) sorption/desorption of nutrients, and 3)  nutrient uptake by macrophytes.  This generally should be <= the max root depth parm (less than root depth in case of trees).  */
float *HP_DOM_AEROBTHIN; /*!< Habitat-specific parameter. _Units_: m; _Brief_: The thin aerobic zone in a flooded wetland.  Note that aerobic total depth is defined to include any zone of soil/sediment that is unsaturated or devoid of water. */

float *HP_HYD_RCINFILT; /*!< Habitat-specific parameter. _Units_: m/d; _Brief_: Rate of infiltration into the unsaturated water storage zone. */
float *HP_HYD_SPEC_YIELD; /*!< Habitat-specific parameter. _Units_: dimless; _Brief_: Proportion of total sediment/soil volume, for a given soil type, that represents water able to be drained by gravity.  Field capacity = porosity - specific yield; ensure that alterations to  porosity and specific yield are consistent in your parameterization. */
float *HP_HYD_POROSITY; /*!< Habitat-specific parameter. _Units_: dimless; _Brief_: Porosity of the aquifer, average from the sediment to base datum.  Field capacity = porosity - specific yield; ensure that alterations to  porosity and specific yield are consistent in your parameterization.  Must be non-zero.   */

float *HP_TP_CONC_GRAD; /*!< Habitat-specific parameter. _Units_: dimless; _Brief_: For concentration gradient, provide the ratio of this nutrient in the inactive DOM zone to that in the active DOM zone.  Used in partioning the mass of sediment nutrients to different concentrations in the shallow active DOM zone and the deeper inactive zone.  */

float *HP_SALT_ICSEDWAT; /*!< Habitat-specific parameter. _Units_: g/L; _Brief_: Initial salt concentration in the sediment water.   */
float *HP_SALT_ICSFWAT; /*!< Habitat-specific parameter. _Units_: g/L; _Brief_: Initial salt concentration in the surface water.   */

float *HP_PHBIO_MAX; /*!< Habitat-specific parameter. _Units_: kgC/m^2; _Brief_: Maximum attainable (observed)  biomass density of photosynthetic tissue.     */
float *HP_NPHBIO_MAX; /*!< Habitat-specific parameter. _Units_: kgC/m^2; _Brief_: Maximum attainable (observed)  biomass density of nonphotosynthetic tissue.     */
float *HP_MAC_MAXHT; /*!< Habitat-specific parameter. _Units_: m; _Brief_: Maximum observed/attainable height of mature plant community (associated with a unit plant density at maturity). */
float *HP_NPHBIO_ROOTDEPTH; /*!< Habitat-specific parameter. _Units_: m; _Brief_: Depth of roots below the sediment/soil zone (positive value) for the community.  */
float *HP_MAC_MAXROUGH; /*!< Habitat-specific parameter. _Units_: d/(m^(1/3)); _Brief_: The maximum Manning's n roughness associated with present vegetation when fully inundated by water.  The relation of the total manning's n to water depth ranges along the continuum from the roughness due to sediment only and  roughness imparted by inundation of plants by water depth.  Be sure this max value > the  minimum roughness coeff.   */
float *HP_MAC_MINROUGH; /*!< Habitat-specific parameter. _Units_: d/(m^(1/3)); _Brief_: The minimum Manning's roughness coefficient for minimal/no vegetation.  Be sure this value is less than the roughness coeff for the vegetation.   */
float *HP_MAC_MAXLAI; /*!< Habitat-specific parameter. _Units_: dimless; _Brief_: Maximum observed/attainable Leaf Area Index for a mature community (= area of leaves/area of ground).   */
float *HP_MAC_MAXCANOPCOND; /*!< Habitat-specific parameter. _Units_: mol/m^2/sec; _Brief_: UNUSED (v2.2+)Maximum canopy conductance (units mol LEAFm-2 sec-1) for plant that is NOT water stressed. For simplicitly, assume canopy conductance = unweighted mean of all leaves in canopy, using lit. values for leaf conductance.  See Jarvis & McNaughton 1986. */
float *HP_MAC_CANOPDECOUP; /*!< Habitat-specific parameter. _Units_: dimless; _Brief_: UNUSED (v2.2+)Canopy couple/decouple factor descirbing how closely the saturation deficit at the canopy surface is linked to the saturation deficit outside the Planetary Boundary Layer.  SCALE dependent; this algorithm assumes model is geared towards large field, scale of hundreds to several thousand meters size.  See Jarvis 1986.  Values near 0 (perfectly coupled) for many tree canopies, near 1 for grassland-type canopies.   */
float *HP_MAC_TEMPOPT; /*!< Habitat-specific parameter. _Units_: deg C; _Brief_: Optimal temperature for maximum primary production growth rate.   */
float *HP_MAC_LIGHTSAT; /*!< Habitat-specific parameter. _Units_: cal/cm^2/d; _Brief_: Saturating light intensity (langleys/d = cal/cm^2 per day) for macrophyte growth kinetics.   */
float *HP_MAC_KSP; /*!< Habitat-specific parameter. _Units_: mgP/L; _Brief_: Half saturation coeff of phosphorus for the nutrient uptake kinetics of macrophytes. */
float *HP_PHBIO_RCNPP; /*!< Habitat-specific parameter. _Units_: 1/d; _Brief_: Maximum observed/attainable specific rate of net primary production. */
float *HP_PHBIO_RCMORT; /*!< Habitat-specific parameter. _Units_: 1/d; _Brief_: Baseline  specific rate of photobiomass mortality.      */
float *HP_MAC_WAT_TOLER; /*!< Habitat-specific parameter. _Units_: m; _Brief_: Depth of ponded surface water above which plant growth becomes restricted.  Used in growth control function. Should be at least a very small positive number: A value of zero will be reset to 5mm in code. */
float *HP_MAC_SALIN_THRESH; /*!< Habitat-specific parameter. _Units_: g/L; _Brief_: UNUSED (v2.2, v2.3)Salinity threshold, above which plant growth decreases linearly with increasing salinity.   */
float *HP_PHBIO_IC_CTOOM; /*!< Habitat-specific parameter. _Units_: gC/gOM; _Brief_: Initial ratio of organic carbon to total organic material in PhotoBiomass (ash free dry weight).   */
float *HP_NPHBIO_IC_CTOOM; /*!< Habitat-specific parameter. _Units_: gC/gOM; _Brief_: Initial ratio of organic carbon to total organic material in NonPhotoBiomass (ash free dry weight).   */
float *HP_PHBIO_IC_PC; /*!< Habitat-specific parameter. _Units_: gP/gC; _Brief_: Initial phosphorus:carbon ratio in PhotoBiomass (ash free dry weight).   */
float *HP_NPHBIO_IC_PC; /*!< Habitat-specific parameter. _Units_: gP/gC; _Brief_: Initial phosphorus:carbon ratio in NonPhotoBiomass (ash free dry weight).   */
float *HP_MAC_TRANSLOC_RC; /*!< Habitat-specific parameter. _Units_: 1/d; _Brief_: Simple, bi-directional baseline translocation rate between Non-photo and Photo biomass; consider this gradual equilibrium as placeholder for a more process-based algorithm */

float *HP_SfDepthLo; /*!< Habitat-specific parameter. _Units_: m; _Brief_: Lower Depth tolerance for Surface Water Depth */
float *HP_SfDepthHi; /*!< Habitat-specific parameter. _Units_: m; _Brief_: Higher Depth tolerance for Surface Water Depth */
float *HP_SfDepthInt; /*!< Habitat-specific parameter. _Units_: days; _Brief_: Time Interval for staying within Surface Water Depth range */
float *HP_PhosLo; /*!< Habitat-specific parameter. _Units_: mgP/kg soil; _Brief_: Lower concentration tolerance for soil total Phosphorus */
float *HP_PhosHi; /*!< Habitat-specific parameter. _Units_: mgP/kg soil; _Brief_: Higher concentration tolerance for soil total Phosphorus */
float *HP_PhosInt; /*!< Habitat-specific parameter. _Units_: days; _Brief_: Time Interval for staying within soil total Phosphorus range */
float *HP_FireInt; /*!< Habitat-specific parameter. _Units_: days; _Brief_: UNUSED. Time Interval since last Fire */


#endif /* UNITMOD_HABPARMS_H */
