


############################## model train ##############################
library(raster)
library(maptools)
library(ggplot2)
library('viridis')
library("cowplot")
library("readxl")
library('dplyr')
library('caret')
library(randomForest)
library(gbm)

rm(list = ls())

md5<-read.csv('grazing_soilC_TP.csv',
              na.strings =c("","Na",'na','NA'),header = T, stringsAsFactors=T)

md5<-md5[complete.cases(md5),]

set.seed(20231212.1146)
cv_folds <- trainControl(method = "cv", 10,allowParallel = TRUE)

rf <- train(yi~ndvi+mat+map+bd+ph+clay+soc+tn+cn+depth+dura+use, data = filter(md5,yi>-1 & yi<0.4 & use>0),
            method = 'rf',
            trControl = cv_folds)

rf$results

rf$finalModel$importance

outpath='D:/grazing/'
saveRDS(rf,paste(outpath,'grazing_train.RData',sep=''))



