library(raster)
library(maptools)
library(ggplot2)
library('viridis')
library("cowplot")
library("readxl")
library('dplyr')
library('caret')
library(randomForest)
library(gbm)

rm(list = ls())

# soil incubation

md<-read_excel('incubation_data.xls',sheet=5, na=c(""))

loca<-md[,c(3,4)]
colnames(loca)<-c("lat","lon")


incu.df<-read.csv('data_ref15_hamdi.csv',
                  na.strings =c("","Na",'na','NA'),header = T)

incu.df<-cbind(loca,incu.df)
incu.df<-filter(incu.df,lat>25 & lat<40 & lon>75 & lon<105)

incu.df<-mutate(incu.df,clay=100-sand-silt)


##### fcp
incu.df<-mutate(incu.df,fcp=log10(fcp))

set.seed(20231130.1640)
cv_folds <- trainControl(method = "cv", 5,allowParallel = TRUE)

rf <- train(fcp~ndvi+mat+map+bd+ph+clay+soc+tn+cn, data = incu.df,
            method = 'rf',
            trControl = cv_folds)

rf$results

outpath='D:/upscaling_turnover/'
saveRDS(rf,paste(outpath,'fcp_train.RData',sep=''))


##### scp
incu.df<-mutate(incu.df,scp=log10(scp))

set.seed(20231130.1641)
cv_folds <- trainControl(method = "cv", 5,allowParallel = TRUE)

rf <- train(scp~ndvi+mat+map+bd+ph+clay+soc+tn+cn, data = incu.df,
            method = 'rf',
            trControl = cv_folds)

rf$results

outpath='D:/upscaling_turnover/'
saveRDS(rf,paste(outpath,'scp_train.RData',sep=''))



##### fmrt
incu.df<-mutate(incu.df,fmrt=log10(fmrt))

set.seed(20231130.1643)
cv_folds <- trainControl(method = "cv", 5,allowParallel = TRUE)

rf <- train(fmrt~ndvi+mat+map+bd+ph+clay+soc+tn+cn, data = incu.df,
            method = 'rf',
            trControl = cv_folds)

rf$results

outpath='D:/upscaling_turnover/'
saveRDS(rf,paste(outpath,'fmrt_train.RData',sep=''))


##### smrt
incu.df<-mutate(incu.df,smrt=log10(smrt))

set.seed(20231130.1645)
cv_folds <- trainControl(method = "cv", 5,allowParallel = TRUE)

rf <- train(smrt~ndvi+mat+map+bd+ph+clay+soc+tn+cn, data = incu.df,
            method = 'rf',
            trControl = cv_folds)

rf$results

outpath='D:/upscaling_turnover/'
saveRDS(rf,paste(outpath,'smrt_train.RData',sep=''))


##### pmrt
incu.df<-mutate(incu.df,pmrt=log10(pmrt))

set.seed(20231130.1647)
cv_folds <- trainControl(method = "cv", 5,allowParallel = TRUE)

rf <- train(pmrt~ndvi+mat+map+bd+ph+clay+soc+tn+cn, data = incu.df,
            method = 'rf',
            trControl = cv_folds)

rf$results

outpath='D:/upscaling_turnover/'
saveRDS(rf,paste(outpath,'pmrt_train.RData',sep=''))


########################### upscaling ###########################

library(raster)
library(ggplot2)
library("cowplot")
library('dplyr')

rm(list = ls())

path_vars='D:/variables/'

mat<-raster(paste(path_vars,'mat_tp_005.tif',sep=""))

map<-raster(paste(path_vars,'map_tp_005.tif',sep=""))

ndvi<-raster(paste(path_vars,'ndvi_tp_005_scale10000.tif',sep=""))/10000
ndvi[ndvi<0]<-NA

bd<-raster(paste(path_vars,'bd_tp_005.tif',sep=""))
bd<-bd/100 # to g/cm3

ph<-raster(paste(path_vars,'ph_tp_005_scale10.tif',sep=""))/10

clay<-raster(paste(path_vars,'clay_tp_005.tif',sep=""))/10 # to %

soc<-raster(paste(path_vars,'soc_tp_005.tif',sep=""))/10 # to mg/g

tn<-raster(paste(path_vars,'tn_tp_005.tif',sep=""))/1000 # to mg/g

cn<-soc/tn

vars<-stack(mat,map,ndvi,bd,ph,clay,soc,tn,cn)

vars.df<-as.data.frame(vars,xy=T)

colnames(vars.df)<-c("x","y","mat","map","ndvi","bd","ph","clay","soc","tn","cn")

xy=vars.df[,c(1,2)]
vars.df<-vars.df[complete.cases(vars.df),]

model_path='D:/upscaling_turnover/'

# fcp
fcp_rf<-readRDS(paste(model_path,'fcp_train.RData',sep=""))

fcp<-data.frame(x=vars.df$x,y=vars.df$y,z=10^predict(fcp_rf,newdata=vars.df))

fcp[nrow(fcp)+1,]<-c(xy[1,],NA)
fcp[nrow(fcp)+1,]<-c(xy[nrow(xy),],NA)

pre <- rasterFromXYZ(fcp,crs="+proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0")
writeRaster(pre,paste(model_path,'fcp_tp_005',sep=""),format="GTiff",overwrite=TRUE)


# scp
scp_rf<-readRDS(paste(model_path,'scp_train.RData',sep=""))
scp<-data.frame(x=vars.df$x,y=vars.df$y,z=10^predict(scp_rf,newdata=vars.df))

scp[nrow(scp)+1,]<-c(xy[1,],NA)
scp[nrow(scp)+1,]<-c(xy[nrow(xy),],NA)

pre <- rasterFromXYZ(scp,crs="+proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0")
writeRaster(pre,paste(model_path,'scp_tp_005',sep=""),format="GTiff",overwrite=TRUE)


# fmrt
fmrt_rf<-readRDS(paste(model_path,'fmrt_train.RData',sep=""))
fmrt<-data.frame(x=vars.df$x,y=vars.df$y,z=10^predict(fmrt_rf,newdata=vars.df))

fmrt[nrow(fmrt)+1,]<-c(xy[1,],NA)
fmrt[nrow(fmrt)+1,]<-c(xy[nrow(xy),],NA)

pre <- rasterFromXYZ(fmrt,crs="+proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0")
writeRaster(pre,paste(model_path,'fmrt_tp_005',sep=""),format="GTiff",overwrite=TRUE)


# smrt
smrt_rf<-readRDS(paste(model_path,'smrt_train.RData',sep=""))
smrt<-data.frame(x=vars.df$x,y=vars.df$y,z=10^predict(smrt_rf,newdata=vars.df))

smrt[nrow(smrt)+1,]<-c(xy[1,],NA)
smrt[nrow(smrt)+1,]<-c(xy[nrow(xy),],NA)

pre <- rasterFromXYZ(smrt,crs="+proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0")
writeRaster(pre,paste(model_path,'smrt_tp_005',sep=""),format="GTiff",overwrite=TRUE)


# pmrt
pmrt_rf<-readRDS(paste(model_path,'pmrt_train.RData',sep=""))
pmrt<-data.frame(x=vars.df$x,y=vars.df$y,z=10^predict(pmrt_rf,newdata=vars.df))

pmrt[nrow(pmrt)+1,]<-c(xy[1,],NA)
pmrt[nrow(pmrt)+1,]<-c(xy[nrow(xy),],NA)

pre <- rasterFromXYZ(pmrt,crs="+proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0")
writeRaster(pre,paste(model_path,'pmrt_tp_005',sep=""),format="GTiff",overwrite=TRUE)







